#!/bin/sh
# Just install few modules
# Installe a module if a given control file exist
installif(){
	if [ -e $1 ]; then
		echo Configuration file $1 installed: Enabling module $2
		linuxconf --setmod $2
	fi
}
installif /etc/named.boot dnsconf
installif /etc/named.conf dnsconf
installif /etc/sendmail.cf mailconf
installif /etc/smb.conf samba
installif /etc/samba/smb.conf samba
installif /etc/httpd/conf/httpd.conf apache
installif /etc/ftpaccess wuftpd
installif /etc/dhcpd.conf dhcpd
installif /usr/bin/fetchmail fetchmailconf
installif /etc/inetd.conf inetdconf
installif /etc/xinetd.conf inetdconf
installif /etc/syslog.conf syslogconf
installif /etc/ssh/sshd_config opensshd
installif /etc/ircd/ircd.conf ircdconf
installif /etc/printcap printer
installif /etc/wine.conf wineconf
installif /etc/amanda amandaconf
installif /boot/map liloconf
installif /boot/grub/menu.lst grubconf
installif /etc/security pamconf
installif /etc/postfix/main.cf postfixconf
installif /etc/exports nfsconf


# Install the dialout module if they are some *.dconf
NBDCONF=`ls /etc/ppp/*.dconf 2>/dev/null | wc -l`
NBDCONF=`expr $NBDCONF`
if [ "$NBDCONF" != "0" ] ; then
	echo Some ppp dialout configs: Enabling module dialout
	linuxconf --setmod dialout
fi
echo Enabling module redhatppp
linuxconf --setmod redhatppp
echo Enabling module modemconf
linuxconf --setmod modemconf
echo Enabling module motd
linuxconf --setmod motd
echo Enabling module firewall
linuxconf --setmod firewall
echo Enabling module status
linuxconf --setmod status
echo Enabling treemenu module
linuxconf --setmod treemenu
echo Enabling module inittab
linuxconf --setmod inittab
echo Enabling module managerpm
linuxconf --setmod managerpm
echo Enabling module shellmod
linuxconf --setmod shellmod
echo Enabling module kernelconf
linuxconf --setmod kernelconf
echo Enabling module gurus
linuxconf --setmod gurus
echo Enabling module updatemon
linuxconf --setmod updatemon
echo Enabling module report
linuxconf --setmod report

case `/bin/arch` in
	i386|i486|i586|i686)
		echo Enabling module isapnpconf
		linuxconf --setmod isapnpconf
		;;
esac

