/*
 * jclassinfo
 * Copyright (C) 2003  Nicos Panayides
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Nicos Panayides
 * anarxia@gmx.net
 *
 * $Id: string_list.h,v 1.5 2003/12/08 11:10:52 anarxia Exp $
 */

/** @file string_list.h
* @brief Header for the string set 
*/

#ifndef STRING_LIST_H
#define STRING_LIST_H

#include "config.h"
#include <stdio.h>

/*
* String list linked list implementation.
*/
typedef struct {
	/** Pointer to the head */
	struct string_node* head;
} StringList;


/* IS_LOCAL and IS_DEPENDENCY are exclusive to each other
 and IS_LOCAL has higher preference.
*/
#define IS_LOCAL 0x01
#define IS_DEPENDENCY 0x2
#define IS_FINISHED 0x04
#define IS_ANY (~0)

StringList* string_list_new(void);
void string_list_free(StringList*);
int string_list_add(StringList*, const char*, int flag);
void string_list_remove(StringList*, const char*, int flag);
void string_list_remove_all(StringList*, int flag);
char* string_list_remove_first(StringList*, int flag);
void string_list_print(FILE*, StringList*, int flag);
void string_list_print_xml(FILE*, StringList*, int flag);
int string_list_contains(StringList*, const char*, int flag);
int string_list_is_empty(StringList*);

#endif
