/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/

#ifndef __IA32E_ROOTN_D_G_DATA_CL__
#define __IA32E_ROOTN_D_G_DATA_CL__

typedef struct
{
  VUINT32 _dAbsMask[2];

  VUINT32 rcp_t1[1026][2];
  VUINT32 log2_t1[2050][2];
  VUINT32 exp2_tbl[256][2];

  VUINT32 clv[7][2];
  VUINT32 cev[5][2];

  VUINT32 iMantissaMask[2];
  VUINT32 i3fe7fe0000000000[2];
  VUINT32 dbOne[2];
  VUINT32 iffffffff00000000[2];
  VUINT32 db2p20_2p19[2];
  VUINT32 iHighMask[2];
  VUINT32 LHN[2];
  VUINT32 ifff0000000000000[2];
  VUINT32 db2p45_2p44[2];

  VUINT32 NEG_INF[2];
  VUINT32 NEG_ZERO[2];
  VUINT32 d2pow52[2];
  VUINT32 d1div2pow111[2];

  VUINT32 HIDELTA[1];
  VUINT32 LORANGE[1];
  VUINT32 ABSMASK[1];
  VUINT32 INF[1];
  VUINT32 DOMAINRANGE[1];

  VUINT32 iIndexMask[1];
  VUINT32 iIndexAdd[1];

  VUINT32 i3fe7fe00[1];
  VUINT32 i2p20_2p19[1];
  VUINT32 iOne[1];
  VUINT32 jIndexMask[1];

} dPow_Table_Type;

__constant dPow_Table_Type __ocl_svml_drootn_data = {
  {(VUINT32) ((0x7fffffffffffffffuLL) >> 0),
   (VUINT32) ((0x7fffffffffffffffuLL) >> 32)},
  {
   {(VUINT32) ((0x3FF7154740000000uLL) >> 0),
    (VUINT32) ((0x3FF7154740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF70F8340000000uLL) >> 0),
    (VUINT32) ((0x3FF70F8340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF709C240000000uLL) >> 0),
    (VUINT32) ((0x3FF709C240000000uLL) >> 32)},
   {(VUINT32) ((0x3FF7040440000000uLL) >> 0),
    (VUINT32) ((0x3FF7040440000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6FE4900000000uLL) >> 0),
    (VUINT32) ((0x3FF6FE4900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6F89080000000uLL) >> 0),
    (VUINT32) ((0x3FF6F89080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6F2DB00000000uLL) >> 0),
    (VUINT32) ((0x3FF6F2DB00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6ED2840000000uLL) >> 0),
    (VUINT32) ((0x3FF6ED2840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6E77840000000uLL) >> 0),
    (VUINT32) ((0x3FF6E77840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6E1CB40000000uLL) >> 0),
    (VUINT32) ((0x3FF6E1CB40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6DC2100000000uLL) >> 0),
    (VUINT32) ((0x3FF6DC2100000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6D67980000000uLL) >> 0),
    (VUINT32) ((0x3FF6D67980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6D0D4C0000000uLL) >> 0),
    (VUINT32) ((0x3FF6D0D4C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6CB32C0000000uLL) >> 0),
    (VUINT32) ((0x3FF6CB32C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6C593C0000000uLL) >> 0),
    (VUINT32) ((0x3FF6C593C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6BFF780000000uLL) >> 0),
    (VUINT32) ((0x3FF6BFF780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6BA5DC0000000uLL) >> 0),
    (VUINT32) ((0x3FF6BA5DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6B4C700000000uLL) >> 0),
    (VUINT32) ((0x3FF6B4C700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6AF32C0000000uLL) >> 0),
    (VUINT32) ((0x3FF6AF32C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6A9A180000000uLL) >> 0),
    (VUINT32) ((0x3FF6A9A180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6A41300000000uLL) >> 0),
    (VUINT32) ((0x3FF6A41300000000uLL) >> 32)},
   {(VUINT32) ((0x3FF69E8700000000uLL) >> 0),
    (VUINT32) ((0x3FF69E8700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF698FDC0000000uLL) >> 0),
    (VUINT32) ((0x3FF698FDC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6937740000000uLL) >> 0),
    (VUINT32) ((0x3FF6937740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF68DF380000000uLL) >> 0),
    (VUINT32) ((0x3FF68DF380000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6887280000000uLL) >> 0),
    (VUINT32) ((0x3FF6887280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF682F400000000uLL) >> 0),
    (VUINT32) ((0x3FF682F400000000uLL) >> 32)},
   {(VUINT32) ((0x3FF67D7840000000uLL) >> 0),
    (VUINT32) ((0x3FF67D7840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF677FF40000000uLL) >> 0),
    (VUINT32) ((0x3FF677FF40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF67288C0000000uLL) >> 0),
    (VUINT32) ((0x3FF67288C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF66D1540000000uLL) >> 0),
    (VUINT32) ((0x3FF66D1540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF667A400000000uLL) >> 0),
    (VUINT32) ((0x3FF667A400000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6623580000000uLL) >> 0),
    (VUINT32) ((0x3FF6623580000000uLL) >> 32)},
   {(VUINT32) ((0x3FF65CC9C0000000uLL) >> 0),
    (VUINT32) ((0x3FF65CC9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6576080000000uLL) >> 0),
    (VUINT32) ((0x3FF6576080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF651FA00000000uLL) >> 0),
    (VUINT32) ((0x3FF651FA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF64C9600000000uLL) >> 0),
    (VUINT32) ((0x3FF64C9600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6473480000000uLL) >> 0),
    (VUINT32) ((0x3FF6473480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF641D5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF641D5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF63C7980000000uLL) >> 0),
    (VUINT32) ((0x3FF63C7980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6372000000000uLL) >> 0),
    (VUINT32) ((0x3FF6372000000000uLL) >> 32)},
   {(VUINT32) ((0x3FF631C900000000uLL) >> 0),
    (VUINT32) ((0x3FF631C900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF62C7480000000uLL) >> 0),
    (VUINT32) ((0x3FF62C7480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6272280000000uLL) >> 0),
    (VUINT32) ((0x3FF6272280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF621D340000000uLL) >> 0),
    (VUINT32) ((0x3FF621D340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF61C8640000000uLL) >> 0),
    (VUINT32) ((0x3FF61C8640000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6173C00000000uLL) >> 0),
    (VUINT32) ((0x3FF6173C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF611F440000000uLL) >> 0),
    (VUINT32) ((0x3FF611F440000000uLL) >> 32)},
   {(VUINT32) ((0x3FF60CAF00000000uLL) >> 0),
    (VUINT32) ((0x3FF60CAF00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6076C40000000uLL) >> 0),
    (VUINT32) ((0x3FF6076C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF6022C00000000uLL) >> 0),
    (VUINT32) ((0x3FF6022C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5FCEE80000000uLL) >> 0),
    (VUINT32) ((0x3FF5FCEE80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5F7B340000000uLL) >> 0),
    (VUINT32) ((0x3FF5F7B340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5F27A80000000uLL) >> 0),
    (VUINT32) ((0x3FF5F27A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5ED4440000000uLL) >> 0),
    (VUINT32) ((0x3FF5ED4440000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5E81040000000uLL) >> 0),
    (VUINT32) ((0x3FF5E81040000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5E2DF00000000uLL) >> 0),
    (VUINT32) ((0x3FF5E2DF00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5DDB040000000uLL) >> 0),
    (VUINT32) ((0x3FF5DDB040000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5D883C0000000uLL) >> 0),
    (VUINT32) ((0x3FF5D883C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5D359C0000000uLL) >> 0),
    (VUINT32) ((0x3FF5D359C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5CE3240000000uLL) >> 0),
    (VUINT32) ((0x3FF5CE3240000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5C90D40000000uLL) >> 0),
    (VUINT32) ((0x3FF5C90D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5C3EA80000000uLL) >> 0),
    (VUINT32) ((0x3FF5C3EA80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5BECA40000000uLL) >> 0),
    (VUINT32) ((0x3FF5BECA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5B9AC80000000uLL) >> 0),
    (VUINT32) ((0x3FF5B9AC80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5B49100000000uLL) >> 0),
    (VUINT32) ((0x3FF5B49100000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5AF7800000000uLL) >> 0),
    (VUINT32) ((0x3FF5AF7800000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5AA6180000000uLL) >> 0),
    (VUINT32) ((0x3FF5AA6180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5A54D40000000uLL) >> 0),
    (VUINT32) ((0x3FF5A54D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5A03B40000000uLL) >> 0),
    (VUINT32) ((0x3FF5A03B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF59B2BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF59B2BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5961EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF5961EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF59113C0000000uLL) >> 0),
    (VUINT32) ((0x3FF59113C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF58C0B80000000uLL) >> 0),
    (VUINT32) ((0x3FF58C0B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5870540000000uLL) >> 0),
    (VUINT32) ((0x3FF5870540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF58201C0000000uLL) >> 0),
    (VUINT32) ((0x3FF58201C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF57D0040000000uLL) >> 0),
    (VUINT32) ((0x3FF57D0040000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5780140000000uLL) >> 0),
    (VUINT32) ((0x3FF5780140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5730480000000uLL) >> 0),
    (VUINT32) ((0x3FF5730480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF56E0A00000000uLL) >> 0),
    (VUINT32) ((0x3FF56E0A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF56911C0000000uLL) >> 0),
    (VUINT32) ((0x3FF56911C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5641C00000000uLL) >> 0),
    (VUINT32) ((0x3FF5641C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF55F2880000000uLL) >> 0),
    (VUINT32) ((0x3FF55F2880000000uLL) >> 32)},
   {(VUINT32) ((0x3FF55A3740000000uLL) >> 0),
    (VUINT32) ((0x3FF55A3740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5554840000000uLL) >> 0),
    (VUINT32) ((0x3FF5554840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5505BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF5505BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF54B7140000000uLL) >> 0),
    (VUINT32) ((0x3FF54B7140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5468900000000uLL) >> 0),
    (VUINT32) ((0x3FF5468900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF541A340000000uLL) >> 0),
    (VUINT32) ((0x3FF541A340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF53CBF80000000uLL) >> 0),
    (VUINT32) ((0x3FF53CBF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF537DE40000000uLL) >> 0),
    (VUINT32) ((0x3FF537DE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF532FF00000000uLL) >> 0),
    (VUINT32) ((0x3FF532FF00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF52E2240000000uLL) >> 0),
    (VUINT32) ((0x3FF52E2240000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5294780000000uLL) >> 0),
    (VUINT32) ((0x3FF5294780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5246F00000000uLL) >> 0),
    (VUINT32) ((0x3FF5246F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF51F98C0000000uLL) >> 0),
    (VUINT32) ((0x3FF51F98C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF51AC4C0000000uLL) >> 0),
    (VUINT32) ((0x3FF51AC4C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF515F300000000uLL) >> 0),
    (VUINT32) ((0x3FF515F300000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5112340000000uLL) >> 0),
    (VUINT32) ((0x3FF5112340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF50C5600000000uLL) >> 0),
    (VUINT32) ((0x3FF50C5600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF5078AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF5078AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF502C1C0000000uLL) >> 0),
    (VUINT32) ((0x3FF502C1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4FDFAC0000000uLL) >> 0),
    (VUINT32) ((0x3FF4FDFAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4F93600000000uLL) >> 0),
    (VUINT32) ((0x3FF4F93600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4F47380000000uLL) >> 0),
    (VUINT32) ((0x3FF4F47380000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4EFB340000000uLL) >> 0),
    (VUINT32) ((0x3FF4EFB340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4EAF500000000uLL) >> 0),
    (VUINT32) ((0x3FF4EAF500000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4E638C0000000uLL) >> 0),
    (VUINT32) ((0x3FF4E638C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4E17EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF4E17EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4DCC700000000uLL) >> 0),
    (VUINT32) ((0x3FF4DCC700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4D81180000000uLL) >> 0),
    (VUINT32) ((0x3FF4D81180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4D35DC0000000uLL) >> 0),
    (VUINT32) ((0x3FF4D35DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4CEAC80000000uLL) >> 0),
    (VUINT32) ((0x3FF4CEAC80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4C9FD00000000uLL) >> 0),
    (VUINT32) ((0x3FF4C9FD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4C54FC0000000uLL) >> 0),
    (VUINT32) ((0x3FF4C54FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4C0A4C0000000uLL) >> 0),
    (VUINT32) ((0x3FF4C0A4C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4BBFBC0000000uLL) >> 0),
    (VUINT32) ((0x3FF4BBFBC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4B754C0000000uLL) >> 0),
    (VUINT32) ((0x3FF4B754C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4B2B000000000uLL) >> 0),
    (VUINT32) ((0x3FF4B2B000000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4AE0D40000000uLL) >> 0),
    (VUINT32) ((0x3FF4AE0D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4A96C80000000uLL) >> 0),
    (VUINT32) ((0x3FF4A96C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4A4CE00000000uLL) >> 0),
    (VUINT32) ((0x3FF4A4CE00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4A03140000000uLL) >> 0),
    (VUINT32) ((0x3FF4A03140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF49B9700000000uLL) >> 0),
    (VUINT32) ((0x3FF49B9700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF496FE80000000uLL) >> 0),
    (VUINT32) ((0x3FF496FE80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4926800000000uLL) >> 0),
    (VUINT32) ((0x3FF4926800000000uLL) >> 32)},
   {(VUINT32) ((0x3FF48DD3C0000000uLL) >> 0),
    (VUINT32) ((0x3FF48DD3C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4894180000000uLL) >> 0),
    (VUINT32) ((0x3FF4894180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF484B100000000uLL) >> 0),
    (VUINT32) ((0x3FF484B100000000uLL) >> 32)},
   {(VUINT32) ((0x3FF48022C0000000uLL) >> 0),
    (VUINT32) ((0x3FF48022C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF47B96C0000000uLL) >> 0),
    (VUINT32) ((0x3FF47B96C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4770C80000000uLL) >> 0),
    (VUINT32) ((0x3FF4770C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4728440000000uLL) >> 0),
    (VUINT32) ((0x3FF4728440000000uLL) >> 32)},
   {(VUINT32) ((0x3FF46DFE00000000uLL) >> 0),
    (VUINT32) ((0x3FF46DFE00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF46979C0000000uLL) >> 0),
    (VUINT32) ((0x3FF46979C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF464F780000000uLL) >> 0),
    (VUINT32) ((0x3FF464F780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4607780000000uLL) >> 0),
    (VUINT32) ((0x3FF4607780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF45BF940000000uLL) >> 0),
    (VUINT32) ((0x3FF45BF940000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4577D00000000uLL) >> 0),
    (VUINT32) ((0x3FF4577D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF45302C0000000uLL) >> 0),
    (VUINT32) ((0x3FF45302C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF44E8A40000000uLL) >> 0),
    (VUINT32) ((0x3FF44E8A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF44A1400000000uLL) >> 0),
    (VUINT32) ((0x3FF44A1400000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4459F80000000uLL) >> 0),
    (VUINT32) ((0x3FF4459F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4412D40000000uLL) >> 0),
    (VUINT32) ((0x3FF4412D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF43CBCC0000000uLL) >> 0),
    (VUINT32) ((0x3FF43CBCC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4384E40000000uLL) >> 0),
    (VUINT32) ((0x3FF4384E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF433E180000000uLL) >> 0),
    (VUINT32) ((0x3FF433E180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF42F7700000000uLL) >> 0),
    (VUINT32) ((0x3FF42F7700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF42B0E40000000uLL) >> 0),
    (VUINT32) ((0x3FF42B0E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF426A780000000uLL) >> 0),
    (VUINT32) ((0x3FF426A780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4224280000000uLL) >> 0),
    (VUINT32) ((0x3FF4224280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF41DDF80000000uLL) >> 0),
    (VUINT32) ((0x3FF41DDF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4197E80000000uLL) >> 0),
    (VUINT32) ((0x3FF4197E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4151F40000000uLL) >> 0),
    (VUINT32) ((0x3FF4151F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF410C200000000uLL) >> 0),
    (VUINT32) ((0x3FF410C200000000uLL) >> 32)},
   {(VUINT32) ((0x3FF40C66C0000000uLL) >> 0),
    (VUINT32) ((0x3FF40C66C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF4080D40000000uLL) >> 0),
    (VUINT32) ((0x3FF4080D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF403B5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF403B5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3FF6000000000uLL) >> 0),
    (VUINT32) ((0x3FF3FF6000000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3FB0C00000000uLL) >> 0),
    (VUINT32) ((0x3FF3FB0C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3F6BA40000000uLL) >> 0),
    (VUINT32) ((0x3FF3F6BA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3F26A00000000uLL) >> 0),
    (VUINT32) ((0x3FF3F26A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3EE1BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF3EE1BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3E9CF80000000uLL) >> 0),
    (VUINT32) ((0x3FF3E9CF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3E58500000000uLL) >> 0),
    (VUINT32) ((0x3FF3E58500000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3E13C40000000uLL) >> 0),
    (VUINT32) ((0x3FF3E13C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3DCF580000000uLL) >> 0),
    (VUINT32) ((0x3FF3DCF580000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3D8B080000000uLL) >> 0),
    (VUINT32) ((0x3FF3D8B080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3D46D40000000uLL) >> 0),
    (VUINT32) ((0x3FF3D46D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3D02C00000000uLL) >> 0),
    (VUINT32) ((0x3FF3D02C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3CBEC80000000uLL) >> 0),
    (VUINT32) ((0x3FF3CBEC80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3C7AEC0000000uLL) >> 0),
    (VUINT32) ((0x3FF3C7AEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3C37300000000uLL) >> 0),
    (VUINT32) ((0x3FF3C37300000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3BF3900000000uLL) >> 0),
    (VUINT32) ((0x3FF3BF3900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3BB00C0000000uLL) >> 0),
    (VUINT32) ((0x3FF3BB00C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3B6CA40000000uLL) >> 0),
    (VUINT32) ((0x3FF3B6CA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3B29580000000uLL) >> 0),
    (VUINT32) ((0x3FF3B29580000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3AE62C0000000uLL) >> 0),
    (VUINT32) ((0x3FF3AE62C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3AA3180000000uLL) >> 0),
    (VUINT32) ((0x3FF3AA3180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3A60240000000uLL) >> 0),
    (VUINT32) ((0x3FF3A60240000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3A1D4C0000000uLL) >> 0),
    (VUINT32) ((0x3FF3A1D4C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF39DA900000000uLL) >> 0),
    (VUINT32) ((0x3FF39DA900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3997F40000000uLL) >> 0),
    (VUINT32) ((0x3FF3997F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3955700000000uLL) >> 0),
    (VUINT32) ((0x3FF3955700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3913080000000uLL) >> 0),
    (VUINT32) ((0x3FF3913080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF38D0BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF38D0BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF388E900000000uLL) >> 0),
    (VUINT32) ((0x3FF388E900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF384C7C0000000uLL) >> 0),
    (VUINT32) ((0x3FF384C7C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF380A840000000uLL) >> 0),
    (VUINT32) ((0x3FF380A840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF37C8AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF37C8AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3786EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF3786EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3745480000000uLL) >> 0),
    (VUINT32) ((0x3FF3745480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3703C00000000uLL) >> 0),
    (VUINT32) ((0x3FF3703C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF36C2540000000uLL) >> 0),
    (VUINT32) ((0x3FF36C2540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3681040000000uLL) >> 0),
    (VUINT32) ((0x3FF3681040000000uLL) >> 32)},
   {(VUINT32) ((0x3FF363FCC0000000uLL) >> 0),
    (VUINT32) ((0x3FF363FCC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF35FEB40000000uLL) >> 0),
    (VUINT32) ((0x3FF35FEB40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF35BDB40000000uLL) >> 0),
    (VUINT32) ((0x3FF35BDB40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF357CD00000000uLL) >> 0),
    (VUINT32) ((0x3FF357CD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF353C080000000uLL) >> 0),
    (VUINT32) ((0x3FF353C080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF34FB5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF34FB5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF34BAC80000000uLL) >> 0),
    (VUINT32) ((0x3FF34BAC80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF347A540000000uLL) >> 0),
    (VUINT32) ((0x3FF347A540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3439F80000000uLL) >> 0),
    (VUINT32) ((0x3FF3439F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF33F9B40000000uLL) >> 0),
    (VUINT32) ((0x3FF33F9B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF33B9900000000uLL) >> 0),
    (VUINT32) ((0x3FF33B9900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3379840000000uLL) >> 0),
    (VUINT32) ((0x3FF3379840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3339900000000uLL) >> 0),
    (VUINT32) ((0x3FF3339900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF32F9BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF32F9BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF32B9FC0000000uLL) >> 0),
    (VUINT32) ((0x3FF32B9FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF327A5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF327A5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF323AD40000000uLL) >> 0),
    (VUINT32) ((0x3FF323AD40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF31FB680000000uLL) >> 0),
    (VUINT32) ((0x3FF31FB680000000uLL) >> 32)},
   {(VUINT32) ((0x3FF31BC140000000uLL) >> 0),
    (VUINT32) ((0x3FF31BC140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF317CDC0000000uLL) >> 0),
    (VUINT32) ((0x3FF317CDC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF313DBC0000000uLL) >> 0),
    (VUINT32) ((0x3FF313DBC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF30FEB80000000uLL) >> 0),
    (VUINT32) ((0x3FF30FEB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF30BFD00000000uLL) >> 0),
    (VUINT32) ((0x3FF30BFD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3080FC0000000uLL) >> 0),
    (VUINT32) ((0x3FF3080FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3042480000000uLL) >> 0),
    (VUINT32) ((0x3FF3042480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF3003AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF3003AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2FC5280000000uLL) >> 0),
    (VUINT32) ((0x3FF2FC5280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2F86BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF2F86BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2F48700000000uLL) >> 0),
    (VUINT32) ((0x3FF2F48700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2F0A380000000uLL) >> 0),
    (VUINT32) ((0x3FF2F0A380000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2ECC1C0000000uLL) >> 0),
    (VUINT32) ((0x3FF2ECC1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2E8E180000000uLL) >> 0),
    (VUINT32) ((0x3FF2E8E180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2E502C0000000uLL) >> 0),
    (VUINT32) ((0x3FF2E502C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2E125C0000000uLL) >> 0),
    (VUINT32) ((0x3FF2E125C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2DD4A40000000uLL) >> 0),
    (VUINT32) ((0x3FF2DD4A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2D97080000000uLL) >> 0),
    (VUINT32) ((0x3FF2D97080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2D59840000000uLL) >> 0),
    (VUINT32) ((0x3FF2D59840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2D1C180000000uLL) >> 0),
    (VUINT32) ((0x3FF2D1C180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2CDEC40000000uLL) >> 0),
    (VUINT32) ((0x3FF2CDEC40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2CA1880000000uLL) >> 0),
    (VUINT32) ((0x3FF2CA1880000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2C64680000000uLL) >> 0),
    (VUINT32) ((0x3FF2C64680000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2C27600000000uLL) >> 0),
    (VUINT32) ((0x3FF2C27600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2BEA700000000uLL) >> 0),
    (VUINT32) ((0x3FF2BEA700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2BAD9C0000000uLL) >> 0),
    (VUINT32) ((0x3FF2BAD9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2B70DC0000000uLL) >> 0),
    (VUINT32) ((0x3FF2B70DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2B34380000000uLL) >> 0),
    (VUINT32) ((0x3FF2B34380000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2AF7AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF2AF7AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2ABB340000000uLL) >> 0),
    (VUINT32) ((0x3FF2ABB340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2A7ED80000000uLL) >> 0),
    (VUINT32) ((0x3FF2A7ED80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2A42980000000uLL) >> 0),
    (VUINT32) ((0x3FF2A42980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2A066C0000000uLL) >> 0),
    (VUINT32) ((0x3FF2A066C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF29CA580000000uLL) >> 0),
    (VUINT32) ((0x3FF29CA580000000uLL) >> 32)},
   {(VUINT32) ((0x3FF298E5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF298E5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF29527C0000000uLL) >> 0),
    (VUINT32) ((0x3FF29527C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2916B00000000uLL) >> 0),
    (VUINT32) ((0x3FF2916B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF28DAFC0000000uLL) >> 0),
    (VUINT32) ((0x3FF28DAFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF289F640000000uLL) >> 0),
    (VUINT32) ((0x3FF289F640000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2863E00000000uLL) >> 0),
    (VUINT32) ((0x3FF2863E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2828740000000uLL) >> 0),
    (VUINT32) ((0x3FF2828740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF27ED240000000uLL) >> 0),
    (VUINT32) ((0x3FF27ED240000000uLL) >> 32)},
   {(VUINT32) ((0x3FF27B1E80000000uLL) >> 0),
    (VUINT32) ((0x3FF27B1E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2776C40000000uLL) >> 0),
    (VUINT32) ((0x3FF2776C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF273BB80000000uLL) >> 0),
    (VUINT32) ((0x3FF273BB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2700C40000000uLL) >> 0),
    (VUINT32) ((0x3FF2700C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF26C5E80000000uLL) >> 0),
    (VUINT32) ((0x3FF26C5E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF268B200000000uLL) >> 0),
    (VUINT32) ((0x3FF268B200000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2650740000000uLL) >> 0),
    (VUINT32) ((0x3FF2650740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2615DC0000000uLL) >> 0),
    (VUINT32) ((0x3FF2615DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF25DB5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF25DB5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF25A0F40000000uLL) >> 0),
    (VUINT32) ((0x3FF25A0F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2566A40000000uLL) >> 0),
    (VUINT32) ((0x3FF2566A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF252C6C0000000uLL) >> 0),
    (VUINT32) ((0x3FF252C6C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF24F2480000000uLL) >> 0),
    (VUINT32) ((0x3FF24F2480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF24B83C0000000uLL) >> 0),
    (VUINT32) ((0x3FF24B83C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF247E480000000uLL) >> 0),
    (VUINT32) ((0x3FF247E480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF24446C0000000uLL) >> 0),
    (VUINT32) ((0x3FF24446C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF240AA40000000uLL) >> 0),
    (VUINT32) ((0x3FF240AA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF23D0F40000000uLL) >> 0),
    (VUINT32) ((0x3FF23D0F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF23975C0000000uLL) >> 0),
    (VUINT32) ((0x3FF23975C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF235DD80000000uLL) >> 0),
    (VUINT32) ((0x3FF235DD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF23246C0000000uLL) >> 0),
    (VUINT32) ((0x3FF23246C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF22EB180000000uLL) >> 0),
    (VUINT32) ((0x3FF22EB180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF22B1D80000000uLL) >> 0),
    (VUINT32) ((0x3FF22B1D80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2278B00000000uLL) >> 0),
    (VUINT32) ((0x3FF2278B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF223FA00000000uLL) >> 0),
    (VUINT32) ((0x3FF223FA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2206A40000000uLL) >> 0),
    (VUINT32) ((0x3FF2206A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF21CDC00000000uLL) >> 0),
    (VUINT32) ((0x3FF21CDC00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2194F00000000uLL) >> 0),
    (VUINT32) ((0x3FF2194F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF215C380000000uLL) >> 0),
    (VUINT32) ((0x3FF215C380000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2123940000000uLL) >> 0),
    (VUINT32) ((0x3FF2123940000000uLL) >> 32)},
   {(VUINT32) ((0x3FF20EB080000000uLL) >> 0),
    (VUINT32) ((0x3FF20EB080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF20B2940000000uLL) >> 0),
    (VUINT32) ((0x3FF20B2940000000uLL) >> 32)},
   {(VUINT32) ((0x3FF207A340000000uLL) >> 0),
    (VUINT32) ((0x3FF207A340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2041EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF2041EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF2009B80000000uLL) >> 0),
    (VUINT32) ((0x3FF2009B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1FD1980000000uLL) >> 0),
    (VUINT32) ((0x3FF1FD1980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1F99900000000uLL) >> 0),
    (VUINT32) ((0x3FF1F99900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1F619C0000000uLL) >> 0),
    (VUINT32) ((0x3FF1F619C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1F29C00000000uLL) >> 0),
    (VUINT32) ((0x3FF1F29C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1EF1FC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1EF1FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1EBA480000000uLL) >> 0),
    (VUINT32) ((0x3FF1EBA480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1E82AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1E82AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1E4B280000000uLL) >> 0),
    (VUINT32) ((0x3FF1E4B280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1E13B80000000uLL) >> 0),
    (VUINT32) ((0x3FF1E13B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1DDC5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF1DDC5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1DA5180000000uLL) >> 0),
    (VUINT32) ((0x3FF1DA5180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1D6DE80000000uLL) >> 0),
    (VUINT32) ((0x3FF1D6DE80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1D36CC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1D36CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1CFFC40000000uLL) >> 0),
    (VUINT32) ((0x3FF1CFFC40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1CC8D40000000uLL) >> 0),
    (VUINT32) ((0x3FF1CC8D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1C91F80000000uLL) >> 0),
    (VUINT32) ((0x3FF1C91F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1C5B340000000uLL) >> 0),
    (VUINT32) ((0x3FF1C5B340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1C24840000000uLL) >> 0),
    (VUINT32) ((0x3FF1C24840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1BEDE40000000uLL) >> 0),
    (VUINT32) ((0x3FF1BEDE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1BB7600000000uLL) >> 0),
    (VUINT32) ((0x3FF1BB7600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1B80EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1B80EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1B4A900000000uLL) >> 0),
    (VUINT32) ((0x3FF1B4A900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1B14480000000uLL) >> 0),
    (VUINT32) ((0x3FF1B14480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1ADE140000000uLL) >> 0),
    (VUINT32) ((0x3FF1ADE140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1AA7F40000000uLL) >> 0),
    (VUINT32) ((0x3FF1AA7F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1A71E80000000uLL) >> 0),
    (VUINT32) ((0x3FF1A71E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1A3BF40000000uLL) >> 0),
    (VUINT32) ((0x3FF1A3BF40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1A06140000000uLL) >> 0),
    (VUINT32) ((0x3FF1A06140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF19D0480000000uLL) >> 0),
    (VUINT32) ((0x3FF19D0480000000uLL) >> 32)},
   {(VUINT32) ((0x3FF199A900000000uLL) >> 0),
    (VUINT32) ((0x3FF199A900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1964EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1964EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF192F5C0000000uLL) >> 0),
    (VUINT32) ((0x3FF192F5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF18F9E00000000uLL) >> 0),
    (VUINT32) ((0x3FF18F9E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF18C47C0000000uLL) >> 0),
    (VUINT32) ((0x3FF18C47C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF188F280000000uLL) >> 0),
    (VUINT32) ((0x3FF188F280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1859EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1859EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1824C00000000uLL) >> 0),
    (VUINT32) ((0x3FF1824C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF17EFAC0000000uLL) >> 0),
    (VUINT32) ((0x3FF17EFAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF17BAA80000000uLL) >> 0),
    (VUINT32) ((0x3FF17BAA80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1785BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1785BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1750E40000000uLL) >> 0),
    (VUINT32) ((0x3FF1750E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF171C1C0000000uLL) >> 0),
    (VUINT32) ((0x3FF171C1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF16E76C0000000uLL) >> 0),
    (VUINT32) ((0x3FF16E76C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF16B2D00000000uLL) >> 0),
    (VUINT32) ((0x3FF16B2D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF167E440000000uLL) >> 0),
    (VUINT32) ((0x3FF167E440000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1649D00000000uLL) >> 0),
    (VUINT32) ((0x3FF1649D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF16156C0000000uLL) >> 0),
    (VUINT32) ((0x3FF16156C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF15E11C0000000uLL) >> 0),
    (VUINT32) ((0x3FF15E11C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF15ACE40000000uLL) >> 0),
    (VUINT32) ((0x3FF15ACE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1578BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1578BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1544A80000000uLL) >> 0),
    (VUINT32) ((0x3FF1544A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1510A80000000uLL) >> 0),
    (VUINT32) ((0x3FF1510A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF14DCBC0000000uLL) >> 0),
    (VUINT32) ((0x3FF14DCBC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF14A8E40000000uLL) >> 0),
    (VUINT32) ((0x3FF14A8E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF14751C0000000uLL) >> 0),
    (VUINT32) ((0x3FF14751C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF14416C0000000uLL) >> 0),
    (VUINT32) ((0x3FF14416C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF140DCC0000000uLL) >> 0),
    (VUINT32) ((0x3FF140DCC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF13DA400000000uLL) >> 0),
    (VUINT32) ((0x3FF13DA400000000uLL) >> 32)},
   {(VUINT32) ((0x3FF13A6C80000000uLL) >> 0),
    (VUINT32) ((0x3FF13A6C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1373600000000uLL) >> 0),
    (VUINT32) ((0x3FF1373600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1340100000000uLL) >> 0),
    (VUINT32) ((0x3FF1340100000000uLL) >> 32)},
   {(VUINT32) ((0x3FF130CD00000000uLL) >> 0),
    (VUINT32) ((0x3FF130CD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF12D9A40000000uLL) >> 0),
    (VUINT32) ((0x3FF12D9A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF12A68C0000000uLL) >> 0),
    (VUINT32) ((0x3FF12A68C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1273840000000uLL) >> 0),
    (VUINT32) ((0x3FF1273840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1240900000000uLL) >> 0),
    (VUINT32) ((0x3FF1240900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF120DB00000000uLL) >> 0),
    (VUINT32) ((0x3FF120DB00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF11DAE40000000uLL) >> 0),
    (VUINT32) ((0x3FF11DAE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF11A8280000000uLL) >> 0),
    (VUINT32) ((0x3FF11A8280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1175800000000uLL) >> 0),
    (VUINT32) ((0x3FF1175800000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1142EC0000000uLL) >> 0),
    (VUINT32) ((0x3FF1142EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF11106C0000000uLL) >> 0),
    (VUINT32) ((0x3FF11106C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF10DDFC0000000uLL) >> 0),
    (VUINT32) ((0x3FF10DDFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF10AB9C0000000uLL) >> 0),
    (VUINT32) ((0x3FF10AB9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1079540000000uLL) >> 0),
    (VUINT32) ((0x3FF1079540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF10471C0000000uLL) >> 0),
    (VUINT32) ((0x3FF10471C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF1014F80000000uLL) >> 0),
    (VUINT32) ((0x3FF1014F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0FE2E40000000uLL) >> 0),
    (VUINT32) ((0x3FF0FE2E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0FB0E40000000uLL) >> 0),
    (VUINT32) ((0x3FF0FB0E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0F7EF40000000uLL) >> 0),
    (VUINT32) ((0x3FF0F7EF40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0F4D180000000uLL) >> 0),
    (VUINT32) ((0x3FF0F4D180000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0F1B500000000uLL) >> 0),
    (VUINT32) ((0x3FF0F1B500000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0EE9980000000uLL) >> 0),
    (VUINT32) ((0x3FF0EE9980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0EB7F40000000uLL) >> 0),
    (VUINT32) ((0x3FF0EB7F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0E86600000000uLL) >> 0),
    (VUINT32) ((0x3FF0E86600000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0E54E00000000uLL) >> 0),
    (VUINT32) ((0x3FF0E54E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0E23700000000uLL) >> 0),
    (VUINT32) ((0x3FF0E23700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0DF2140000000uLL) >> 0),
    (VUINT32) ((0x3FF0DF2140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0DC0C80000000uLL) >> 0),
    (VUINT32) ((0x3FF0DC0C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0D8F900000000uLL) >> 0),
    (VUINT32) ((0x3FF0D8F900000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0D5E6C0000000uLL) >> 0),
    (VUINT32) ((0x3FF0D5E6C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0D2D540000000uLL) >> 0),
    (VUINT32) ((0x3FF0D2D540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0CFC540000000uLL) >> 0),
    (VUINT32) ((0x3FF0CFC540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0CCB640000000uLL) >> 0),
    (VUINT32) ((0x3FF0CCB640000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0C9A840000000uLL) >> 0),
    (VUINT32) ((0x3FF0C9A840000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0C69B40000000uLL) >> 0),
    (VUINT32) ((0x3FF0C69B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0C38F80000000uLL) >> 0),
    (VUINT32) ((0x3FF0C38F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0C08500000000uLL) >> 0),
    (VUINT32) ((0x3FF0C08500000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0BD7B80000000uLL) >> 0),
    (VUINT32) ((0x3FF0BD7B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0BA7300000000uLL) >> 0),
    (VUINT32) ((0x3FF0BA7300000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0B76BC0000000uLL) >> 0),
    (VUINT32) ((0x3FF0B76BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0B46580000000uLL) >> 0),
    (VUINT32) ((0x3FF0B46580000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0B16040000000uLL) >> 0),
    (VUINT32) ((0x3FF0B16040000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0AE5C40000000uLL) >> 0),
    (VUINT32) ((0x3FF0AE5C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0AB5940000000uLL) >> 0),
    (VUINT32) ((0x3FF0AB5940000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0A85780000000uLL) >> 0),
    (VUINT32) ((0x3FF0A85780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0A556C0000000uLL) >> 0),
    (VUINT32) ((0x3FF0A556C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0A25700000000uLL) >> 0),
    (VUINT32) ((0x3FF0A25700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF09F5880000000uLL) >> 0),
    (VUINT32) ((0x3FF09F5880000000uLL) >> 32)},
   {(VUINT32) ((0x3FF09C5AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF09C5AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0995E80000000uLL) >> 0),
    (VUINT32) ((0x3FF0995E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0966300000000uLL) >> 0),
    (VUINT32) ((0x3FF0966300000000uLL) >> 32)},
   {(VUINT32) ((0x3FF09368C0000000uLL) >> 0),
    (VUINT32) ((0x3FF09368C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0906F80000000uLL) >> 0),
    (VUINT32) ((0x3FF0906F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF08D7740000000uLL) >> 0),
    (VUINT32) ((0x3FF08D7740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF08A8000000000uLL) >> 0),
    (VUINT32) ((0x3FF08A8000000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0878A00000000uLL) >> 0),
    (VUINT32) ((0x3FF0878A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0849500000000uLL) >> 0),
    (VUINT32) ((0x3FF0849500000000uLL) >> 32)},
   {(VUINT32) ((0x3FF081A100000000uLL) >> 0),
    (VUINT32) ((0x3FF081A100000000uLL) >> 32)},
   {(VUINT32) ((0x3FF07EAE40000000uLL) >> 0),
    (VUINT32) ((0x3FF07EAE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF07BBC40000000uLL) >> 0),
    (VUINT32) ((0x3FF07BBC40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF078CB80000000uLL) >> 0),
    (VUINT32) ((0x3FF078CB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF075DBC0000000uLL) >> 0),
    (VUINT32) ((0x3FF075DBC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF072ED00000000uLL) >> 0),
    (VUINT32) ((0x3FF072ED00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF06FFF80000000uLL) >> 0),
    (VUINT32) ((0x3FF06FFF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF06D12C0000000uLL) >> 0),
    (VUINT32) ((0x3FF06D12C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF06A2740000000uLL) >> 0),
    (VUINT32) ((0x3FF06A2740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0673CC0000000uLL) >> 0),
    (VUINT32) ((0x3FF0673CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0645340000000uLL) >> 0),
    (VUINT32) ((0x3FF0645340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0616AC0000000uLL) >> 0),
    (VUINT32) ((0x3FF0616AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF05E8340000000uLL) >> 0),
    (VUINT32) ((0x3FF05E8340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF05B9D00000000uLL) >> 0),
    (VUINT32) ((0x3FF05B9D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF058B780000000uLL) >> 0),
    (VUINT32) ((0x3FF058B780000000uLL) >> 32)},
   {(VUINT32) ((0x3FF055D340000000uLL) >> 0),
    (VUINT32) ((0x3FF055D340000000uLL) >> 32)},
   {(VUINT32) ((0x3FF052F000000000uLL) >> 0),
    (VUINT32) ((0x3FF052F000000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0500D80000000uLL) >> 0),
    (VUINT32) ((0x3FF0500D80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF04D2C40000000uLL) >> 0),
    (VUINT32) ((0x3FF04D2C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF04A4C00000000uLL) >> 0),
    (VUINT32) ((0x3FF04A4C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0476CC0000000uLL) >> 0),
    (VUINT32) ((0x3FF0476CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0448E80000000uLL) >> 0),
    (VUINT32) ((0x3FF0448E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF041B140000000uLL) >> 0),
    (VUINT32) ((0x3FF041B140000000uLL) >> 32)},
   {(VUINT32) ((0x3FF03ED500000000uLL) >> 0),
    (VUINT32) ((0x3FF03ED500000000uLL) >> 32)},
   {(VUINT32) ((0x3FF03BF9C0000000uLL) >> 0),
    (VUINT32) ((0x3FF03BF9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0391FC0000000uLL) >> 0),
    (VUINT32) ((0x3FF0391FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0364680000000uLL) >> 0),
    (VUINT32) ((0x3FF0364680000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0336E40000000uLL) >> 0),
    (VUINT32) ((0x3FF0336E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0309700000000uLL) >> 0),
    (VUINT32) ((0x3FF0309700000000uLL) >> 32)},
   {(VUINT32) ((0x3FF02DC0C0000000uLL) >> 0),
    (VUINT32) ((0x3FF02DC0C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF02AEB80000000uLL) >> 0),
    (VUINT32) ((0x3FF02AEB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0281740000000uLL) >> 0),
    (VUINT32) ((0x3FF0281740000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0254400000000uLL) >> 0),
    (VUINT32) ((0x3FF0254400000000uLL) >> 32)},
   {(VUINT32) ((0x3FF02271C0000000uLL) >> 0),
    (VUINT32) ((0x3FF02271C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF01FA080000000uLL) >> 0),
    (VUINT32) ((0x3FF01FA080000000uLL) >> 32)},
   {(VUINT32) ((0x3FF01CD040000000uLL) >> 0),
    (VUINT32) ((0x3FF01CD040000000uLL) >> 32)},
   {(VUINT32) ((0x3FF01A00C0000000uLL) >> 0),
    (VUINT32) ((0x3FF01A00C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0173280000000uLL) >> 0),
    (VUINT32) ((0x3FF0173280000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0146540000000uLL) >> 0),
    (VUINT32) ((0x3FF0146540000000uLL) >> 32)},
   {(VUINT32) ((0x3FF01198C0000000uLL) >> 0),
    (VUINT32) ((0x3FF01198C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FF00ECD80000000uLL) >> 0),
    (VUINT32) ((0x3FF00ECD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FF00C0300000000uLL) >> 0),
    (VUINT32) ((0x3FF00C0300000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0093980000000uLL) >> 0),
    (VUINT32) ((0x3FF0093980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0067100000000uLL) >> 0),
    (VUINT32) ((0x3FF0067100000000uLL) >> 32)},
   {(VUINT32) ((0x3FF003A980000000uLL) >> 0),
    (VUINT32) ((0x3FF003A980000000uLL) >> 32)},
   {(VUINT32) ((0x3FF000E300000000uLL) >> 0),
    (VUINT32) ((0x3FF000E300000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFFC3A80000000uLL) >> 0),
    (VUINT32) ((0x3FEFFC3A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFF6B140000000uLL) >> 0),
    (VUINT32) ((0x3FEFF6B140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFF129C0000000uLL) >> 0),
    (VUINT32) ((0x3FEFF129C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFEBA480000000uLL) >> 0),
    (VUINT32) ((0x3FEFEBA480000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFE620C0000000uLL) >> 0),
    (VUINT32) ((0x3FEFE620C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFE09F40000000uLL) >> 0),
    (VUINT32) ((0x3FEFE09F40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFDB1F80000000uLL) >> 0),
    (VUINT32) ((0x3FEFDB1F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFD5A180000000uLL) >> 0),
    (VUINT32) ((0x3FEFD5A180000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFD02580000000uLL) >> 0),
    (VUINT32) ((0x3FEFD02580000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFCAAB80000000uLL) >> 0),
    (VUINT32) ((0x3FEFCAAB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFC53340000000uLL) >> 0),
    (VUINT32) ((0x3FEFC53340000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFBFBD00000000uLL) >> 0),
    (VUINT32) ((0x3FEFBFBD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFBA4880000000uLL) >> 0),
    (VUINT32) ((0x3FEFBA4880000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFB4D600000000uLL) >> 0),
    (VUINT32) ((0x3FEFB4D600000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFAF6540000000uLL) >> 0),
    (VUINT32) ((0x3FEFAF6540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFA9F680000000uLL) >> 0),
    (VUINT32) ((0x3FEFA9F680000000uLL) >> 32)},
   {(VUINT32) ((0x3FEFA48980000000uLL) >> 0),
    (VUINT32) ((0x3FEFA48980000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF9F1E40000000uLL) >> 0),
    (VUINT32) ((0x3FEF9F1E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF99B500000000uLL) >> 0),
    (VUINT32) ((0x3FEF99B500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF944DC0000000uLL) >> 0),
    (VUINT32) ((0x3FEF944DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF8EE800000000uLL) >> 0),
    (VUINT32) ((0x3FEF8EE800000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF898440000000uLL) >> 0),
    (VUINT32) ((0x3FEF898440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF842280000000uLL) >> 0),
    (VUINT32) ((0x3FEF842280000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF7EC280000000uLL) >> 0),
    (VUINT32) ((0x3FEF7EC280000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF796440000000uLL) >> 0),
    (VUINT32) ((0x3FEF796440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF7407C0000000uLL) >> 0),
    (VUINT32) ((0x3FEF7407C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF6EAD40000000uLL) >> 0),
    (VUINT32) ((0x3FEF6EAD40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF695480000000uLL) >> 0),
    (VUINT32) ((0x3FEF695480000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF63FD80000000uLL) >> 0),
    (VUINT32) ((0x3FEF63FD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF5EA880000000uLL) >> 0),
    (VUINT32) ((0x3FEF5EA880000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF595540000000uLL) >> 0),
    (VUINT32) ((0x3FEF595540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF5403C0000000uLL) >> 0),
    (VUINT32) ((0x3FEF5403C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF4EB400000000uLL) >> 0),
    (VUINT32) ((0x3FEF4EB400000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF496640000000uLL) >> 0),
    (VUINT32) ((0x3FEF496640000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF441A00000000uLL) >> 0),
    (VUINT32) ((0x3FEF441A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF3ECFC0000000uLL) >> 0),
    (VUINT32) ((0x3FEF3ECFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF398740000000uLL) >> 0),
    (VUINT32) ((0x3FEF398740000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF344080000000uLL) >> 0),
    (VUINT32) ((0x3FEF344080000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF2EFB80000000uLL) >> 0),
    (VUINT32) ((0x3FEF2EFB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF29B880000000uLL) >> 0),
    (VUINT32) ((0x3FEF29B880000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF247700000000uLL) >> 0),
    (VUINT32) ((0x3FEF247700000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF1F3780000000uLL) >> 0),
    (VUINT32) ((0x3FEF1F3780000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF19F980000000uLL) >> 0),
    (VUINT32) ((0x3FEF19F980000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF14BD80000000uLL) >> 0),
    (VUINT32) ((0x3FEF14BD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF0F8340000000uLL) >> 0),
    (VUINT32) ((0x3FEF0F8340000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF0A4AC0000000uLL) >> 0),
    (VUINT32) ((0x3FEF0A4AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEF0513C0000000uLL) >> 0),
    (VUINT32) ((0x3FEF0513C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEFFDEC0000000uLL) >> 0),
    (VUINT32) ((0x3FEEFFDEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEFAAB80000000uLL) >> 0),
    (VUINT32) ((0x3FEEFAAB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEF57A00000000uLL) >> 0),
    (VUINT32) ((0x3FEEF57A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEF04A00000000uLL) >> 0),
    (VUINT32) ((0x3FEEF04A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEEB1C00000000uLL) >> 0),
    (VUINT32) ((0x3FEEEB1C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEE5EF80000000uLL) >> 0),
    (VUINT32) ((0x3FEEE5EF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEE0C500000000uLL) >> 0),
    (VUINT32) ((0x3FEEE0C500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEDB9C00000000uLL) >> 0),
    (VUINT32) ((0x3FEEDB9C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEED67500000000uLL) >> 0),
    (VUINT32) ((0x3FEED67500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEED14F80000000uLL) >> 0),
    (VUINT32) ((0x3FEED14F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEECC2BC0000000uLL) >> 0),
    (VUINT32) ((0x3FEECC2BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEC709C0000000uLL) >> 0),
    (VUINT32) ((0x3FEEC709C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEC1E940000000uLL) >> 0),
    (VUINT32) ((0x3FEEC1E940000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEBCCAC0000000uLL) >> 0),
    (VUINT32) ((0x3FEEBCCAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEB7ADC0000000uLL) >> 0),
    (VUINT32) ((0x3FEEB7ADC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEB29280000000uLL) >> 0),
    (VUINT32) ((0x3FEEB29280000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEAD7900000000uLL) >> 0),
    (VUINT32) ((0x3FEEAD7900000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEA86140000000uLL) >> 0),
    (VUINT32) ((0x3FEEA86140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEEA34B40000000uLL) >> 0),
    (VUINT32) ((0x3FEEA34B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE9E36C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE9E36C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE992400000000uLL) >> 0),
    (VUINT32) ((0x3FEE992400000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE941300000000uLL) >> 0),
    (VUINT32) ((0x3FEE941300000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE8F0380000000uLL) >> 0),
    (VUINT32) ((0x3FEE8F0380000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE89F5C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE89F5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE84E9C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE84E9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE7FDF40000000uLL) >> 0),
    (VUINT32) ((0x3FEE7FDF40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE7AD680000000uLL) >> 0),
    (VUINT32) ((0x3FEE7AD680000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE75CF80000000uLL) >> 0),
    (VUINT32) ((0x3FEE75CF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE70CA00000000uLL) >> 0),
    (VUINT32) ((0x3FEE70CA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE6BC640000000uLL) >> 0),
    (VUINT32) ((0x3FEE6BC640000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE66C440000000uLL) >> 0),
    (VUINT32) ((0x3FEE66C440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE61C3C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE61C3C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE5CC500000000uLL) >> 0),
    (VUINT32) ((0x3FEE5CC500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE57C7C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE57C7C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE52CC40000000uLL) >> 0),
    (VUINT32) ((0x3FEE52CC40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE4DD280000000uLL) >> 0),
    (VUINT32) ((0x3FEE4DD280000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE48DA00000000uLL) >> 0),
    (VUINT32) ((0x3FEE48DA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE43E380000000uLL) >> 0),
    (VUINT32) ((0x3FEE43E380000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE3EEE80000000uLL) >> 0),
    (VUINT32) ((0x3FEE3EEE80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE39FB00000000uLL) >> 0),
    (VUINT32) ((0x3FEE39FB00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE350940000000uLL) >> 0),
    (VUINT32) ((0x3FEE350940000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE301940000000uLL) >> 0),
    (VUINT32) ((0x3FEE301940000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE2B2AC0000000uLL) >> 0),
    (VUINT32) ((0x3FEE2B2AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE263DC0000000uLL) >> 0),
    (VUINT32) ((0x3FEE263DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE215280000000uLL) >> 0),
    (VUINT32) ((0x3FEE215280000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE1C68C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE1C68C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE178080000000uLL) >> 0),
    (VUINT32) ((0x3FEE178080000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE129A00000000uLL) >> 0),
    (VUINT32) ((0x3FEE129A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE0DB540000000uLL) >> 0),
    (VUINT32) ((0x3FEE0DB540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE08D1C0000000uLL) >> 0),
    (VUINT32) ((0x3FEE08D1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEE03F000000000uLL) >> 0),
    (VUINT32) ((0x3FEE03F000000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDFF1000000000uLL) >> 0),
    (VUINT32) ((0x3FEDFF1000000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDFA3140000000uLL) >> 0),
    (VUINT32) ((0x3FEDFA3140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDF55440000000uLL) >> 0),
    (VUINT32) ((0x3FEDF55440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDF07900000000uLL) >> 0),
    (VUINT32) ((0x3FEDF07900000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDEB9F00000000uLL) >> 0),
    (VUINT32) ((0x3FEDEB9F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDE6C6C0000000uLL) >> 0),
    (VUINT32) ((0x3FEDE6C6C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDE1F040000000uLL) >> 0),
    (VUINT32) ((0x3FEDE1F040000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDDD1B00000000uLL) >> 0),
    (VUINT32) ((0x3FEDDD1B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDD84780000000uLL) >> 0),
    (VUINT32) ((0x3FEDD84780000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDD37580000000uLL) >> 0),
    (VUINT32) ((0x3FEDD37580000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDCEA500000000uLL) >> 0),
    (VUINT32) ((0x3FEDCEA500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDC9D600000000uLL) >> 0),
    (VUINT32) ((0x3FEDC9D600000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDC508C0000000uLL) >> 0),
    (VUINT32) ((0x3FEDC508C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDC03D00000000uLL) >> 0),
    (VUINT32) ((0x3FEDC03D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDBB72C0000000uLL) >> 0),
    (VUINT32) ((0x3FEDBB72C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDB6AA00000000uLL) >> 0),
    (VUINT32) ((0x3FEDB6AA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDB1E2C0000000uLL) >> 0),
    (VUINT32) ((0x3FEDB1E2C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDAD1D00000000uLL) >> 0),
    (VUINT32) ((0x3FEDAD1D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDA85900000000uLL) >> 0),
    (VUINT32) ((0x3FEDA85900000000uLL) >> 32)},
   {(VUINT32) ((0x3FEDA39680000000uLL) >> 0),
    (VUINT32) ((0x3FEDA39680000000uLL) >> 32)},
   {(VUINT32) ((0x3FED9ED540000000uLL) >> 0),
    (VUINT32) ((0x3FED9ED540000000uLL) >> 32)},
   {(VUINT32) ((0x3FED9A15C0000000uLL) >> 0),
    (VUINT32) ((0x3FED9A15C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED9557C0000000uLL) >> 0),
    (VUINT32) ((0x3FED9557C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED909B40000000uLL) >> 0),
    (VUINT32) ((0x3FED909B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FED8BE040000000uLL) >> 0),
    (VUINT32) ((0x3FED8BE040000000uLL) >> 32)},
   {(VUINT32) ((0x3FED8726C0000000uLL) >> 0),
    (VUINT32) ((0x3FED8726C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED826F00000000uLL) >> 0),
    (VUINT32) ((0x3FED826F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FED7DB880000000uLL) >> 0),
    (VUINT32) ((0x3FED7DB880000000uLL) >> 32)},
   {(VUINT32) ((0x3FED790380000000uLL) >> 0),
    (VUINT32) ((0x3FED790380000000uLL) >> 32)},
   {(VUINT32) ((0x3FED745000000000uLL) >> 0),
    (VUINT32) ((0x3FED745000000000uLL) >> 32)},
   {(VUINT32) ((0x3FED6F9E40000000uLL) >> 0),
    (VUINT32) ((0x3FED6F9E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FED6AEDC0000000uLL) >> 0),
    (VUINT32) ((0x3FED6AEDC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED663EC0000000uLL) >> 0),
    (VUINT32) ((0x3FED663EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED619140000000uLL) >> 0),
    (VUINT32) ((0x3FED619140000000uLL) >> 32)},
   {(VUINT32) ((0x3FED5CE540000000uLL) >> 0),
    (VUINT32) ((0x3FED5CE540000000uLL) >> 32)},
   {(VUINT32) ((0x3FED583AC0000000uLL) >> 0),
    (VUINT32) ((0x3FED583AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED5391C0000000uLL) >> 0),
    (VUINT32) ((0x3FED5391C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED4EEA40000000uLL) >> 0),
    (VUINT32) ((0x3FED4EEA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FED4A4440000000uLL) >> 0),
    (VUINT32) ((0x3FED4A4440000000uLL) >> 32)},
   {(VUINT32) ((0x3FED459F80000000uLL) >> 0),
    (VUINT32) ((0x3FED459F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FED40FC80000000uLL) >> 0),
    (VUINT32) ((0x3FED40FC80000000uLL) >> 32)},
   {(VUINT32) ((0x3FED3C5AC0000000uLL) >> 0),
    (VUINT32) ((0x3FED3C5AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED37BAC0000000uLL) >> 0),
    (VUINT32) ((0x3FED37BAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED331C00000000uLL) >> 0),
    (VUINT32) ((0x3FED331C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FED2E7EC0000000uLL) >> 0),
    (VUINT32) ((0x3FED2E7EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED29E300000000uLL) >> 0),
    (VUINT32) ((0x3FED29E300000000uLL) >> 32)},
   {(VUINT32) ((0x3FED254880000000uLL) >> 0),
    (VUINT32) ((0x3FED254880000000uLL) >> 32)},
   {(VUINT32) ((0x3FED20AFC0000000uLL) >> 0),
    (VUINT32) ((0x3FED20AFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED1C1840000000uLL) >> 0),
    (VUINT32) ((0x3FED1C1840000000uLL) >> 32)},
   {(VUINT32) ((0x3FED178240000000uLL) >> 0),
    (VUINT32) ((0x3FED178240000000uLL) >> 32)},
   {(VUINT32) ((0x3FED12EDC0000000uLL) >> 0),
    (VUINT32) ((0x3FED12EDC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED0E5AC0000000uLL) >> 0),
    (VUINT32) ((0x3FED0E5AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED09C900000000uLL) >> 0),
    (VUINT32) ((0x3FED09C900000000uLL) >> 32)},
   {(VUINT32) ((0x3FED0538C0000000uLL) >> 0),
    (VUINT32) ((0x3FED0538C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FED00AA00000000uLL) >> 0),
    (VUINT32) ((0x3FED00AA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FECFC1C80000000uLL) >> 0),
    (VUINT32) ((0x3FECFC1C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FECF790C0000000uLL) >> 0),
    (VUINT32) ((0x3FECF790C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECF30600000000uLL) >> 0),
    (VUINT32) ((0x3FECF30600000000uLL) >> 32)},
   {(VUINT32) ((0x3FECEE7D00000000uLL) >> 0),
    (VUINT32) ((0x3FECEE7D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FECE9F540000000uLL) >> 0),
    (VUINT32) ((0x3FECE9F540000000uLL) >> 32)},
   {(VUINT32) ((0x3FECE56F00000000uLL) >> 0),
    (VUINT32) ((0x3FECE56F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FECE0EA40000000uLL) >> 0),
    (VUINT32) ((0x3FECE0EA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FECDC66C0000000uLL) >> 0),
    (VUINT32) ((0x3FECDC66C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECD7E4C0000000uLL) >> 0),
    (VUINT32) ((0x3FECD7E4C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECD36440000000uLL) >> 0),
    (VUINT32) ((0x3FECD36440000000uLL) >> 32)},
   {(VUINT32) ((0x3FECCEE500000000uLL) >> 0),
    (VUINT32) ((0x3FECCEE500000000uLL) >> 32)},
   {(VUINT32) ((0x3FECCA6740000000uLL) >> 0),
    (VUINT32) ((0x3FECCA6740000000uLL) >> 32)},
   {(VUINT32) ((0x3FECC5EAC0000000uLL) >> 0),
    (VUINT32) ((0x3FECC5EAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECC16FC0000000uLL) >> 0),
    (VUINT32) ((0x3FECC16FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECBCF640000000uLL) >> 0),
    (VUINT32) ((0x3FECBCF640000000uLL) >> 32)},
   {(VUINT32) ((0x3FECB87E00000000uLL) >> 0),
    (VUINT32) ((0x3FECB87E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FECB40740000000uLL) >> 0),
    (VUINT32) ((0x3FECB40740000000uLL) >> 32)},
   {(VUINT32) ((0x3FECAF91C0000000uLL) >> 0),
    (VUINT32) ((0x3FECAF91C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECAB1DC0000000uLL) >> 0),
    (VUINT32) ((0x3FECAB1DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FECA6AB00000000uLL) >> 0),
    (VUINT32) ((0x3FECA6AB00000000uLL) >> 32)},
   {(VUINT32) ((0x3FECA239C0000000uLL) >> 0),
    (VUINT32) ((0x3FECA239C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC9DC9C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC9DC9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC995B40000000uLL) >> 0),
    (VUINT32) ((0x3FEC995B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC94EE00000000uLL) >> 0),
    (VUINT32) ((0x3FEC94EE00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC908240000000uLL) >> 0),
    (VUINT32) ((0x3FEC908240000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC8C17C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC8C17C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC87AEC0000000uLL) >> 0),
    (VUINT32) ((0x3FEC87AEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC834700000000uLL) >> 0),
    (VUINT32) ((0x3FEC834700000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC7EE0C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC7EE0C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC7A7BC0000000uLL) >> 0),
    (VUINT32) ((0x3FEC7A7BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC761800000000uLL) >> 0),
    (VUINT32) ((0x3FEC761800000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC71B5C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC71B5C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC6D54C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC6D54C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC68F540000000uLL) >> 0),
    (VUINT32) ((0x3FEC68F540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC649700000000uLL) >> 0),
    (VUINT32) ((0x3FEC649700000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC603A00000000uLL) >> 0),
    (VUINT32) ((0x3FEC603A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC5BDE80000000uLL) >> 0),
    (VUINT32) ((0x3FEC5BDE80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC578440000000uLL) >> 0),
    (VUINT32) ((0x3FEC578440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC532B80000000uLL) >> 0),
    (VUINT32) ((0x3FEC532B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC4ED3C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC4ED3C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC4A7DC0000000uLL) >> 0),
    (VUINT32) ((0x3FEC4A7DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC4628C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC4628C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC41D540000000uLL) >> 0),
    (VUINT32) ((0x3FEC41D540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC3D8300000000uLL) >> 0),
    (VUINT32) ((0x3FEC3D8300000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC393200000000uLL) >> 0),
    (VUINT32) ((0x3FEC393200000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC34E240000000uLL) >> 0),
    (VUINT32) ((0x3FEC34E240000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC309400000000uLL) >> 0),
    (VUINT32) ((0x3FEC309400000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC2C4700000000uLL) >> 0),
    (VUINT32) ((0x3FEC2C4700000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC27FB80000000uLL) >> 0),
    (VUINT32) ((0x3FEC27FB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC23B100000000uLL) >> 0),
    (VUINT32) ((0x3FEC23B100000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC1F6800000000uLL) >> 0),
    (VUINT32) ((0x3FEC1F6800000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC1B2040000000uLL) >> 0),
    (VUINT32) ((0x3FEC1B2040000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC16D9C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC16D9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC1294C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC1294C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC0E50C0000000uLL) >> 0),
    (VUINT32) ((0x3FEC0E50C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC0A0E40000000uLL) >> 0),
    (VUINT32) ((0x3FEC0A0E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC05CD00000000uLL) >> 0),
    (VUINT32) ((0x3FEC05CD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEC018D00000000uLL) >> 0),
    (VUINT32) ((0x3FEC018D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBFD4E40000000uLL) >> 0),
    (VUINT32) ((0x3FEBFD4E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBF91100000000uLL) >> 0),
    (VUINT32) ((0x3FEBF91100000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBF4D4C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBF4D4C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBF09A00000000uLL) >> 0),
    (VUINT32) ((0x3FEBF09A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBEC6080000000uLL) >> 0),
    (VUINT32) ((0x3FEBEC6080000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBE82840000000uLL) >> 0),
    (VUINT32) ((0x3FEBE82840000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBE3F140000000uLL) >> 0),
    (VUINT32) ((0x3FEBE3F140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBDFBB80000000uLL) >> 0),
    (VUINT32) ((0x3FEBDFBB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBDB8700000000uLL) >> 0),
    (VUINT32) ((0x3FEBDB8700000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBD753C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBD753C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBD32200000000uLL) >> 0),
    (VUINT32) ((0x3FEBD32200000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBCEF140000000uLL) >> 0),
    (VUINT32) ((0x3FEBCEF140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBCAC1C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBCAC1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBC693C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBC693C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBC266C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBC266C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBBE3B40000000uLL) >> 0),
    (VUINT32) ((0x3FEBBE3B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBBA10C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBBA10C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBB5E7C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBB5E7C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBB1BFC0000000uLL) >> 0),
    (VUINT32) ((0x3FEBB1BFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBAD9940000000uLL) >> 0),
    (VUINT32) ((0x3FEBAD9940000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBA973C0000000uLL) >> 0),
    (VUINT32) ((0x3FEBA973C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBA54FC0000000uLL) >> 0),
    (VUINT32) ((0x3FEBA54FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEBA12CC0000000uLL) >> 0),
    (VUINT32) ((0x3FEBA12CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB9D0B00000000uLL) >> 0),
    (VUINT32) ((0x3FEB9D0B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB98EAC0000000uLL) >> 0),
    (VUINT32) ((0x3FEB98EAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB94CB80000000uLL) >> 0),
    (VUINT32) ((0x3FEB94CB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB90AD80000000uLL) >> 0),
    (VUINT32) ((0x3FEB90AD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB8C90C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB8C90C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB887540000000uLL) >> 0),
    (VUINT32) ((0x3FEB887540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB845B00000000uLL) >> 0),
    (VUINT32) ((0x3FEB845B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB8041C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB8041C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB7C2A00000000uLL) >> 0),
    (VUINT32) ((0x3FEB7C2A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB781340000000uLL) >> 0),
    (VUINT32) ((0x3FEB781340000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB73FE00000000uLL) >> 0),
    (VUINT32) ((0x3FEB73FE00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB6FE9C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB6FE9C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB6BD6C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB6BD6C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB67C500000000uLL) >> 0),
    (VUINT32) ((0x3FEB67C500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB63B440000000uLL) >> 0),
    (VUINT32) ((0x3FEB63B440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB5FA500000000uLL) >> 0),
    (VUINT32) ((0x3FEB5FA500000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB5B96C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB5B96C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB5789C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB5789C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB537E00000000uLL) >> 0),
    (VUINT32) ((0x3FEB537E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB4F7380000000uLL) >> 0),
    (VUINT32) ((0x3FEB4F7380000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB4B6A00000000uLL) >> 0),
    (VUINT32) ((0x3FEB4B6A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB476200000000uLL) >> 0),
    (VUINT32) ((0x3FEB476200000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB435B00000000uLL) >> 0),
    (VUINT32) ((0x3FEB435B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB3F5540000000uLL) >> 0),
    (VUINT32) ((0x3FEB3F5540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB3B5080000000uLL) >> 0),
    (VUINT32) ((0x3FEB3B5080000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB374D00000000uLL) >> 0),
    (VUINT32) ((0x3FEB374D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB334AC0000000uLL) >> 0),
    (VUINT32) ((0x3FEB334AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB2F49C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB2F49C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB2B49C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB2B49C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB274B40000000uLL) >> 0),
    (VUINT32) ((0x3FEB274B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB234D80000000uLL) >> 0),
    (VUINT32) ((0x3FEB234D80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB1F5140000000uLL) >> 0),
    (VUINT32) ((0x3FEB1F5140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB1B5600000000uLL) >> 0),
    (VUINT32) ((0x3FEB1B5600000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB175C00000000uLL) >> 0),
    (VUINT32) ((0x3FEB175C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB136300000000uLL) >> 0),
    (VUINT32) ((0x3FEB136300000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB0F6B80000000uLL) >> 0),
    (VUINT32) ((0x3FEB0F6B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB0B74C0000000uLL) >> 0),
    (VUINT32) ((0x3FEB0B74C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB077F80000000uLL) >> 0),
    (VUINT32) ((0x3FEB077F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEB038B40000000uLL) >> 0),
    (VUINT32) ((0x3FEB038B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAFF9840000000uLL) >> 0),
    (VUINT32) ((0x3FEAFF9840000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAFBA640000000uLL) >> 0),
    (VUINT32) ((0x3FEAFBA640000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAF7B580000000uLL) >> 0),
    (VUINT32) ((0x3FEAF7B580000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAF3C600000000uLL) >> 0),
    (VUINT32) ((0x3FEAF3C600000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAEFD780000000uLL) >> 0),
    (VUINT32) ((0x3FEAEFD780000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAEBEA40000000uLL) >> 0),
    (VUINT32) ((0x3FEAEBEA40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAE7FE00000000uLL) >> 0),
    (VUINT32) ((0x3FEAE7FE00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAE41300000000uLL) >> 0),
    (VUINT32) ((0x3FEAE41300000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAE02900000000uLL) >> 0),
    (VUINT32) ((0x3FEAE02900000000uLL) >> 32)},
   {(VUINT32) ((0x3FEADC4040000000uLL) >> 0),
    (VUINT32) ((0x3FEADC4040000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAD858C0000000uLL) >> 0),
    (VUINT32) ((0x3FEAD858C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAD47240000000uLL) >> 0),
    (VUINT32) ((0x3FEAD47240000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAD08CC0000000uLL) >> 0),
    (VUINT32) ((0x3FEAD08CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEACCA8C0000000uLL) >> 0),
    (VUINT32) ((0x3FEACCA8C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAC8C580000000uLL) >> 0),
    (VUINT32) ((0x3FEAC8C580000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAC4E380000000uLL) >> 0),
    (VUINT32) ((0x3FEAC4E380000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAC102C0000000uLL) >> 0),
    (VUINT32) ((0x3FEAC102C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEABD2300000000uLL) >> 0),
    (VUINT32) ((0x3FEABD2300000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAB94480000000uLL) >> 0),
    (VUINT32) ((0x3FEAB94480000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAB56700000000uLL) >> 0),
    (VUINT32) ((0x3FEAB56700000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAB18A80000000uLL) >> 0),
    (VUINT32) ((0x3FEAB18A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAADAF80000000uLL) >> 0),
    (VUINT32) ((0x3FEAADAF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAA9D540000000uLL) >> 0),
    (VUINT32) ((0x3FEAA9D540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAA5FC40000000uLL) >> 0),
    (VUINT32) ((0x3FEAA5FC40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEAA22440000000uLL) >> 0),
    (VUINT32) ((0x3FEAA22440000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA9E4D80000000uLL) >> 0),
    (VUINT32) ((0x3FEA9E4D80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA9A77C0000000uLL) >> 0),
    (VUINT32) ((0x3FEA9A77C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA96A340000000uLL) >> 0),
    (VUINT32) ((0x3FEA96A340000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA92CFC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA92CFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA8EFD80000000uLL) >> 0),
    (VUINT32) ((0x3FEA8EFD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA8B2C40000000uLL) >> 0),
    (VUINT32) ((0x3FEA8B2C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA875C00000000uLL) >> 0),
    (VUINT32) ((0x3FEA875C00000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA838CC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA838CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA7FBEC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA7FBEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA7BF200000000uLL) >> 0),
    (VUINT32) ((0x3FEA7BF200000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA782640000000uLL) >> 0),
    (VUINT32) ((0x3FEA782640000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA745B80000000uLL) >> 0),
    (VUINT32) ((0x3FEA745B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA7091C0000000uLL) >> 0),
    (VUINT32) ((0x3FEA7091C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA6CC940000000uLL) >> 0),
    (VUINT32) ((0x3FEA6CC940000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA6901C0000000uLL) >> 0),
    (VUINT32) ((0x3FEA6901C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA653B40000000uLL) >> 0),
    (VUINT32) ((0x3FEA653B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA617600000000uLL) >> 0),
    (VUINT32) ((0x3FEA617600000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA5DB1C0000000uLL) >> 0),
    (VUINT32) ((0x3FEA5DB1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA59EE80000000uLL) >> 0),
    (VUINT32) ((0x3FEA59EE80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA562C80000000uLL) >> 0),
    (VUINT32) ((0x3FEA562C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA526B80000000uLL) >> 0),
    (VUINT32) ((0x3FEA526B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA4EAB80000000uLL) >> 0),
    (VUINT32) ((0x3FEA4EAB80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA4AECC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA4AECC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA472EC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA472EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA437200000000uLL) >> 0),
    (VUINT32) ((0x3FEA437200000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA3FB640000000uLL) >> 0),
    (VUINT32) ((0x3FEA3FB640000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA3BFBC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA3BFBC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA384240000000uLL) >> 0),
    (VUINT32) ((0x3FEA384240000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA3489C0000000uLL) >> 0),
    (VUINT32) ((0x3FEA3489C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA30D240000000uLL) >> 0),
    (VUINT32) ((0x3FEA30D240000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA2D1BC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA2D1BC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA296680000000uLL) >> 0),
    (VUINT32) ((0x3FEA296680000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA25B200000000uLL) >> 0),
    (VUINT32) ((0x3FEA25B200000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA21FEC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA21FEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA1E4CC0000000uLL) >> 0),
    (VUINT32) ((0x3FEA1E4CC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA1A9B80000000uLL) >> 0),
    (VUINT32) ((0x3FEA1A9B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA16EB40000000uLL) >> 0),
    (VUINT32) ((0x3FEA16EB40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA133C40000000uLL) >> 0),
    (VUINT32) ((0x3FEA133C40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA0F8E40000000uLL) >> 0),
    (VUINT32) ((0x3FEA0F8E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA0BE140000000uLL) >> 0),
    (VUINT32) ((0x3FEA0BE140000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA083540000000uLL) >> 0),
    (VUINT32) ((0x3FEA083540000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA048A40000000uLL) >> 0),
    (VUINT32) ((0x3FEA048A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FEA00E080000000uLL) >> 0),
    (VUINT32) ((0x3FEA00E080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9FD3780000000uLL) >> 0),
    (VUINT32) ((0x3FE9FD3780000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9F98FC0000000uLL) >> 0),
    (VUINT32) ((0x3FE9F98FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9F5E900000000uLL) >> 0),
    (VUINT32) ((0x3FE9F5E900000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9F24340000000uLL) >> 0),
    (VUINT32) ((0x3FE9F24340000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9EE9E80000000uLL) >> 0),
    (VUINT32) ((0x3FE9EE9E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9EAFAC0000000uLL) >> 0),
    (VUINT32) ((0x3FE9EAFAC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9E75800000000uLL) >> 0),
    (VUINT32) ((0x3FE9E75800000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9E3B640000000uLL) >> 0),
    (VUINT32) ((0x3FE9E3B640000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9E01580000000uLL) >> 0),
    (VUINT32) ((0x3FE9E01580000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9DC7600000000uLL) >> 0),
    (VUINT32) ((0x3FE9DC7600000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9D8D740000000uLL) >> 0),
    (VUINT32) ((0x3FE9D8D740000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9D539C0000000uLL) >> 0),
    (VUINT32) ((0x3FE9D539C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9D19D00000000uLL) >> 0),
    (VUINT32) ((0x3FE9D19D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9CE0180000000uLL) >> 0),
    (VUINT32) ((0x3FE9CE0180000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9CA66C0000000uLL) >> 0),
    (VUINT32) ((0x3FE9CA66C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9C6CD40000000uLL) >> 0),
    (VUINT32) ((0x3FE9C6CD40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9C33480000000uLL) >> 0),
    (VUINT32) ((0x3FE9C33480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9BF9D00000000uLL) >> 0),
    (VUINT32) ((0x3FE9BF9D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9BC0680000000uLL) >> 0),
    (VUINT32) ((0x3FE9BC0680000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9B870C0000000uLL) >> 0),
    (VUINT32) ((0x3FE9B870C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9B4DC40000000uLL) >> 0),
    (VUINT32) ((0x3FE9B4DC40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9B148C0000000uLL) >> 0),
    (VUINT32) ((0x3FE9B148C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9ADB600000000uLL) >> 0),
    (VUINT32) ((0x3FE9ADB600000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9AA2480000000uLL) >> 0),
    (VUINT32) ((0x3FE9AA2480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9A693C0000000uLL) >> 0),
    (VUINT32) ((0x3FE9A693C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9A30440000000uLL) >> 0),
    (VUINT32) ((0x3FE9A30440000000uLL) >> 32)},
   {(VUINT32) ((0x3FE99F7580000000uLL) >> 0),
    (VUINT32) ((0x3FE99F7580000000uLL) >> 32)},
   {(VUINT32) ((0x3FE99BE7C0000000uLL) >> 0),
    (VUINT32) ((0x3FE99BE7C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9985B40000000uLL) >> 0),
    (VUINT32) ((0x3FE9985B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE994CF80000000uLL) >> 0),
    (VUINT32) ((0x3FE994CF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE99144C0000000uLL) >> 0),
    (VUINT32) ((0x3FE99144C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE98DBB00000000uLL) >> 0),
    (VUINT32) ((0x3FE98DBB00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE98A3240000000uLL) >> 0),
    (VUINT32) ((0x3FE98A3240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE986AA80000000uLL) >> 0),
    (VUINT32) ((0x3FE986AA80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE98323C0000000uLL) >> 0),
    (VUINT32) ((0x3FE98323C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE97F9E00000000uLL) >> 0),
    (VUINT32) ((0x3FE97F9E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE97C1900000000uLL) >> 0),
    (VUINT32) ((0x3FE97C1900000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9789540000000uLL) >> 0),
    (VUINT32) ((0x3FE9789540000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9751240000000uLL) >> 0),
    (VUINT32) ((0x3FE9751240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9719080000000uLL) >> 0),
    (VUINT32) ((0x3FE9719080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE96E0F80000000uLL) >> 0),
    (VUINT32) ((0x3FE96E0F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE96A8F80000000uLL) >> 0),
    (VUINT32) ((0x3FE96A8F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9671040000000uLL) >> 0),
    (VUINT32) ((0x3FE9671040000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9639240000000uLL) >> 0),
    (VUINT32) ((0x3FE9639240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9601540000000uLL) >> 0),
    (VUINT32) ((0x3FE9601540000000uLL) >> 32)},
   {(VUINT32) ((0x3FE95C9900000000uLL) >> 0),
    (VUINT32) ((0x3FE95C9900000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9591DC0000000uLL) >> 0),
    (VUINT32) ((0x3FE9591DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE955A380000000uLL) >> 0),
    (VUINT32) ((0x3FE955A380000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9522A40000000uLL) >> 0),
    (VUINT32) ((0x3FE9522A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE94EB200000000uLL) >> 0),
    (VUINT32) ((0x3FE94EB200000000uLL) >> 32)},
   {(VUINT32) ((0x3FE94B3A80000000uLL) >> 0),
    (VUINT32) ((0x3FE94B3A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE947C400000000uLL) >> 0),
    (VUINT32) ((0x3FE947C400000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9444E80000000uLL) >> 0),
    (VUINT32) ((0x3FE9444E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE940DA00000000uLL) >> 0),
    (VUINT32) ((0x3FE940DA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE93D6640000000uLL) >> 0),
    (VUINT32) ((0x3FE93D6640000000uLL) >> 32)},
   {(VUINT32) ((0x3FE939F3C0000000uLL) >> 0),
    (VUINT32) ((0x3FE939F3C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9368200000000uLL) >> 0),
    (VUINT32) ((0x3FE9368200000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9331140000000uLL) >> 0),
    (VUINT32) ((0x3FE9331140000000uLL) >> 32)},
   {(VUINT32) ((0x3FE92FA140000000uLL) >> 0),
    (VUINT32) ((0x3FE92FA140000000uLL) >> 32)},
   {(VUINT32) ((0x3FE92C3280000000uLL) >> 0),
    (VUINT32) ((0x3FE92C3280000000uLL) >> 32)},
   {(VUINT32) ((0x3FE928C480000000uLL) >> 0),
    (VUINT32) ((0x3FE928C480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9255780000000uLL) >> 0),
    (VUINT32) ((0x3FE9255780000000uLL) >> 32)},
   {(VUINT32) ((0x3FE921EB40000000uLL) >> 0),
    (VUINT32) ((0x3FE921EB40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE91E8040000000uLL) >> 0),
    (VUINT32) ((0x3FE91E8040000000uLL) >> 32)},
   {(VUINT32) ((0x3FE91B1600000000uLL) >> 0),
    (VUINT32) ((0x3FE91B1600000000uLL) >> 32)},
   {(VUINT32) ((0x3FE917AC80000000uLL) >> 0),
    (VUINT32) ((0x3FE917AC80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9144440000000uLL) >> 0),
    (VUINT32) ((0x3FE9144440000000uLL) >> 32)},
   {(VUINT32) ((0x3FE910DCC0000000uLL) >> 0),
    (VUINT32) ((0x3FE910DCC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE90D7640000000uLL) >> 0),
    (VUINT32) ((0x3FE90D7640000000uLL) >> 32)},
   {(VUINT32) ((0x3FE90A1080000000uLL) >> 0),
    (VUINT32) ((0x3FE90A1080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE906ABC0000000uLL) >> 0),
    (VUINT32) ((0x3FE906ABC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE9034800000000uLL) >> 0),
    (VUINT32) ((0x3FE9034800000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8FFE540000000uLL) >> 0),
    (VUINT32) ((0x3FE8FFE540000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8FC8340000000uLL) >> 0),
    (VUINT32) ((0x3FE8FC8340000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8F92240000000uLL) >> 0),
    (VUINT32) ((0x3FE8F92240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8F5C200000000uLL) >> 0),
    (VUINT32) ((0x3FE8F5C200000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8F26300000000uLL) >> 0),
    (VUINT32) ((0x3FE8F26300000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8EF0480000000uLL) >> 0),
    (VUINT32) ((0x3FE8EF0480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8EBA740000000uLL) >> 0),
    (VUINT32) ((0x3FE8EBA740000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8E84AC0000000uLL) >> 0),
    (VUINT32) ((0x3FE8E84AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8E4EF40000000uLL) >> 0),
    (VUINT32) ((0x3FE8E4EF40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8E19480000000uLL) >> 0),
    (VUINT32) ((0x3FE8E19480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8DE3AC0000000uLL) >> 0),
    (VUINT32) ((0x3FE8DE3AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8DAE1C0000000uLL) >> 0),
    (VUINT32) ((0x3FE8DAE1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8D78A00000000uLL) >> 0),
    (VUINT32) ((0x3FE8D78A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8D432C0000000uLL) >> 0),
    (VUINT32) ((0x3FE8D432C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8D0DCC0000000uLL) >> 0),
    (VUINT32) ((0x3FE8D0DCC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8CD8780000000uLL) >> 0),
    (VUINT32) ((0x3FE8CD8780000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8CA3300000000uLL) >> 0),
    (VUINT32) ((0x3FE8CA3300000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8C6DF80000000uLL) >> 0),
    (VUINT32) ((0x3FE8C6DF80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8C38D00000000uLL) >> 0),
    (VUINT32) ((0x3FE8C38D00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8C03B40000000uLL) >> 0),
    (VUINT32) ((0x3FE8C03B40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8BCEA80000000uLL) >> 0),
    (VUINT32) ((0x3FE8BCEA80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8B99A80000000uLL) >> 0),
    (VUINT32) ((0x3FE8B99A80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8B64B80000000uLL) >> 0),
    (VUINT32) ((0x3FE8B64B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8B2FD40000000uLL) >> 0),
    (VUINT32) ((0x3FE8B2FD40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8AFB000000000uLL) >> 0),
    (VUINT32) ((0x3FE8AFB000000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8AC63C0000000uLL) >> 0),
    (VUINT32) ((0x3FE8AC63C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8A91840000000uLL) >> 0),
    (VUINT32) ((0x3FE8A91840000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8A5CD80000000uLL) >> 0),
    (VUINT32) ((0x3FE8A5CD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8A283C0000000uLL) >> 0),
    (VUINT32) ((0x3FE8A283C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE89F3B00000000uLL) >> 0),
    (VUINT32) ((0x3FE89F3B00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE89BF300000000uLL) >> 0),
    (VUINT32) ((0x3FE89BF300000000uLL) >> 32)},
   {(VUINT32) ((0x3FE898ABC0000000uLL) >> 0),
    (VUINT32) ((0x3FE898ABC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8956580000000uLL) >> 0),
    (VUINT32) ((0x3FE8956580000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8922040000000uLL) >> 0),
    (VUINT32) ((0x3FE8922040000000uLL) >> 32)},
   {(VUINT32) ((0x3FE88EDBC0000000uLL) >> 0),
    (VUINT32) ((0x3FE88EDBC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE88B9800000000uLL) >> 0),
    (VUINT32) ((0x3FE88B9800000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8885540000000uLL) >> 0),
    (VUINT32) ((0x3FE8885540000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8851380000000uLL) >> 0),
    (VUINT32) ((0x3FE8851380000000uLL) >> 32)},
   {(VUINT32) ((0x3FE881D240000000uLL) >> 0),
    (VUINT32) ((0x3FE881D240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE87E9240000000uLL) >> 0),
    (VUINT32) ((0x3FE87E9240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE87B52C0000000uLL) >> 0),
    (VUINT32) ((0x3FE87B52C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8781480000000uLL) >> 0),
    (VUINT32) ((0x3FE8781480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE874D6C0000000uLL) >> 0),
    (VUINT32) ((0x3FE874D6C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8719A00000000uLL) >> 0),
    (VUINT32) ((0x3FE8719A00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE86E5E40000000uLL) >> 0),
    (VUINT32) ((0x3FE86E5E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE86B2340000000uLL) >> 0),
    (VUINT32) ((0x3FE86B2340000000uLL) >> 32)},
   {(VUINT32) ((0x3FE867E900000000uLL) >> 0),
    (VUINT32) ((0x3FE867E900000000uLL) >> 32)},
   {(VUINT32) ((0x3FE864AFC0000000uLL) >> 0),
    (VUINT32) ((0x3FE864AFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8617740000000uLL) >> 0),
    (VUINT32) ((0x3FE8617740000000uLL) >> 32)},
   {(VUINT32) ((0x3FE85E3F80000000uLL) >> 0),
    (VUINT32) ((0x3FE85E3F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE85B08C0000000uLL) >> 0),
    (VUINT32) ((0x3FE85B08C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE857D300000000uLL) >> 0),
    (VUINT32) ((0x3FE857D300000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8549DC0000000uLL) >> 0),
    (VUINT32) ((0x3FE8549DC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8516980000000uLL) >> 0),
    (VUINT32) ((0x3FE8516980000000uLL) >> 32)},
   {(VUINT32) ((0x3FE84E3640000000uLL) >> 0),
    (VUINT32) ((0x3FE84E3640000000uLL) >> 32)},
   {(VUINT32) ((0x3FE84B03C0000000uLL) >> 0),
    (VUINT32) ((0x3FE84B03C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE847D200000000uLL) >> 0),
    (VUINT32) ((0x3FE847D200000000uLL) >> 32)},
   {(VUINT32) ((0x3FE844A100000000uLL) >> 0),
    (VUINT32) ((0x3FE844A100000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8417100000000uLL) >> 0),
    (VUINT32) ((0x3FE8417100000000uLL) >> 32)},
   {(VUINT32) ((0x3FE83E4200000000uLL) >> 0),
    (VUINT32) ((0x3FE83E4200000000uLL) >> 32)},
   {(VUINT32) ((0x3FE83B1380000000uLL) >> 0),
    (VUINT32) ((0x3FE83B1380000000uLL) >> 32)},
   {(VUINT32) ((0x3FE837E600000000uLL) >> 0),
    (VUINT32) ((0x3FE837E600000000uLL) >> 32)},
   {(VUINT32) ((0x3FE834B940000000uLL) >> 0),
    (VUINT32) ((0x3FE834B940000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8318D80000000uLL) >> 0),
    (VUINT32) ((0x3FE8318D80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE82E6280000000uLL) >> 0),
    (VUINT32) ((0x3FE82E6280000000uLL) >> 32)},
   {(VUINT32) ((0x3FE82B3840000000uLL) >> 0),
    (VUINT32) ((0x3FE82B3840000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8280F00000000uLL) >> 0),
    (VUINT32) ((0x3FE8280F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE824E640000000uLL) >> 0),
    (VUINT32) ((0x3FE824E640000000uLL) >> 32)},
   {(VUINT32) ((0x3FE821BEC0000000uLL) >> 0),
    (VUINT32) ((0x3FE821BEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE81E97C0000000uLL) >> 0),
    (VUINT32) ((0x3FE81E97C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE81B71C0000000uLL) >> 0),
    (VUINT32) ((0x3FE81B71C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8184C80000000uLL) >> 0),
    (VUINT32) ((0x3FE8184C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8152800000000uLL) >> 0),
    (VUINT32) ((0x3FE8152800000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8120480000000uLL) >> 0),
    (VUINT32) ((0x3FE8120480000000uLL) >> 32)},
   {(VUINT32) ((0x3FE80EE1C0000000uLL) >> 0),
    (VUINT32) ((0x3FE80EE1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE80BBFC0000000uLL) >> 0),
    (VUINT32) ((0x3FE80BBFC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8089E80000000uLL) >> 0),
    (VUINT32) ((0x3FE8089E80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8057E40000000uLL) >> 0),
    (VUINT32) ((0x3FE8057E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE8025EC0000000uLL) >> 0),
    (VUINT32) ((0x3FE8025EC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7FF4000000000uLL) >> 0),
    (VUINT32) ((0x3FE7FF4000000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7FC2200000000uLL) >> 0),
    (VUINT32) ((0x3FE7FC2200000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7F90500000000uLL) >> 0),
    (VUINT32) ((0x3FE7F90500000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7F5E8C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7F5E8C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7F2CD40000000uLL) >> 0),
    (VUINT32) ((0x3FE7F2CD40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7EFB280000000uLL) >> 0),
    (VUINT32) ((0x3FE7EFB280000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7EC9880000000uLL) >> 0),
    (VUINT32) ((0x3FE7EC9880000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7E97F80000000uLL) >> 0),
    (VUINT32) ((0x3FE7E97F80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7E66740000000uLL) >> 0),
    (VUINT32) ((0x3FE7E66740000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7E34FC0000000uLL) >> 0),
    (VUINT32) ((0x3FE7E34FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7E03940000000uLL) >> 0),
    (VUINT32) ((0x3FE7E03940000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7DD2340000000uLL) >> 0),
    (VUINT32) ((0x3FE7DD2340000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7DA0E40000000uLL) >> 0),
    (VUINT32) ((0x3FE7DA0E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7D6FA00000000uLL) >> 0),
    (VUINT32) ((0x3FE7D6FA00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7D3E680000000uLL) >> 0),
    (VUINT32) ((0x3FE7D3E680000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7D0D3C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7D0D3C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7CDC1C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7CDC1C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7CAB0C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7CAB0C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7C7A080000000uLL) >> 0),
    (VUINT32) ((0x3FE7C7A080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7C49100000000uLL) >> 0),
    (VUINT32) ((0x3FE7C49100000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7C18240000000uLL) >> 0),
    (VUINT32) ((0x3FE7C18240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7BE7440000000uLL) >> 0),
    (VUINT32) ((0x3FE7BE7440000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7BB6700000000uLL) >> 0),
    (VUINT32) ((0x3FE7BB6700000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7B85AC0000000uLL) >> 0),
    (VUINT32) ((0x3FE7B85AC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7B54F00000000uLL) >> 0),
    (VUINT32) ((0x3FE7B54F00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7B24440000000uLL) >> 0),
    (VUINT32) ((0x3FE7B24440000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7AF3A40000000uLL) >> 0),
    (VUINT32) ((0x3FE7AF3A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7AC3100000000uLL) >> 0),
    (VUINT32) ((0x3FE7AC3100000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7A92880000000uLL) >> 0),
    (VUINT32) ((0x3FE7A92880000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7A620C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7A620C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7A319C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7A319C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7A013C0000000uLL) >> 0),
    (VUINT32) ((0x3FE7A013C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE79D0E40000000uLL) >> 0),
    (VUINT32) ((0x3FE79D0E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE79A09C0000000uLL) >> 0),
    (VUINT32) ((0x3FE79A09C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7970600000000uLL) >> 0),
    (VUINT32) ((0x3FE7970600000000uLL) >> 32)},
   {(VUINT32) ((0x3FE79402C0000000uLL) >> 0),
    (VUINT32) ((0x3FE79402C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7910080000000uLL) >> 0),
    (VUINT32) ((0x3FE7910080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE78DFF00000000uLL) >> 0),
    (VUINT32) ((0x3FE78DFF00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE78AFE40000000uLL) >> 0),
    (VUINT32) ((0x3FE78AFE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE787FE40000000uLL) >> 0),
    (VUINT32) ((0x3FE787FE40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE784FF00000000uLL) >> 0),
    (VUINT32) ((0x3FE784FF00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7820080000000uLL) >> 0),
    (VUINT32) ((0x3FE7820080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE77F02C0000000uLL) >> 0),
    (VUINT32) ((0x3FE77F02C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE77C05C0000000uLL) >> 0),
    (VUINT32) ((0x3FE77C05C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE77909C0000000uLL) >> 0),
    (VUINT32) ((0x3FE77909C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7760E40000000uLL) >> 0),
    (VUINT32) ((0x3FE7760E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7731380000000uLL) >> 0),
    (VUINT32) ((0x3FE7731380000000uLL) >> 32)},
   {(VUINT32) ((0x3FE77019C0000000uLL) >> 0),
    (VUINT32) ((0x3FE77019C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE76D2080000000uLL) >> 0),
    (VUINT32) ((0x3FE76D2080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE76A2800000000uLL) >> 0),
    (VUINT32) ((0x3FE76A2800000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7673080000000uLL) >> 0),
    (VUINT32) ((0x3FE7673080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7643980000000uLL) >> 0),
    (VUINT32) ((0x3FE7643980000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7614340000000uLL) >> 0),
    (VUINT32) ((0x3FE7614340000000uLL) >> 32)},
   {(VUINT32) ((0x3FE75E4E00000000uLL) >> 0),
    (VUINT32) ((0x3FE75E4E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE75B5940000000uLL) >> 0),
    (VUINT32) ((0x3FE75B5940000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7586580000000uLL) >> 0),
    (VUINT32) ((0x3FE7586580000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7557240000000uLL) >> 0),
    (VUINT32) ((0x3FE7557240000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7527FC0000000uLL) >> 0),
    (VUINT32) ((0x3FE7527FC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE74F8E40000000uLL) >> 0),
    (VUINT32) ((0x3FE74F8E40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE74C9D40000000uLL) >> 0),
    (VUINT32) ((0x3FE74C9D40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE749AD00000000uLL) >> 0),
    (VUINT32) ((0x3FE749AD00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE746BD80000000uLL) >> 0),
    (VUINT32) ((0x3FE746BD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE743CEC0000000uLL) >> 0),
    (VUINT32) ((0x3FE743CEC0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE740E100000000uLL) >> 0),
    (VUINT32) ((0x3FE740E100000000uLL) >> 32)},
   {(VUINT32) ((0x3FE73DF3C0000000uLL) >> 0),
    (VUINT32) ((0x3FE73DF3C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE73B0740000000uLL) >> 0),
    (VUINT32) ((0x3FE73B0740000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7381B80000000uLL) >> 0),
    (VUINT32) ((0x3FE7381B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7353080000000uLL) >> 0),
    (VUINT32) ((0x3FE7353080000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7324600000000uLL) >> 0),
    (VUINT32) ((0x3FE7324600000000uLL) >> 32)},
   {(VUINT32) ((0x3FE72F5C80000000uLL) >> 0),
    (VUINT32) ((0x3FE72F5C80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE72C73C0000000uLL) >> 0),
    (VUINT32) ((0x3FE72C73C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7298B80000000uLL) >> 0),
    (VUINT32) ((0x3FE7298B80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE726A440000000uLL) >> 0),
    (VUINT32) ((0x3FE726A440000000uLL) >> 32)},
   {(VUINT32) ((0x3FE723BD80000000uLL) >> 0),
    (VUINT32) ((0x3FE723BD80000000uLL) >> 32)},
   {(VUINT32) ((0x3FE720D7C0000000uLL) >> 0),
    (VUINT32) ((0x3FE720D7C0000000uLL) >> 32)},
   {(VUINT32) ((0x3FE71DF280000000uLL) >> 0),
    (VUINT32) ((0x3FE71DF280000000uLL) >> 32)},
   {(VUINT32) ((0x3FE71B0E00000000uLL) >> 0),
    (VUINT32) ((0x3FE71B0E00000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7182A40000000uLL) >> 0),
    (VUINT32) ((0x3FE7182A40000000uLL) >> 32)},
   {(VUINT32) ((0x3FE7154740000000uLL) >> 0),
    (VUINT32) ((0x3FE7154740000000uLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   },
  {

   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   {(VUINT32) ((0x3F5712E100000000uLL) >> 0),
    (VUINT32) ((0x3F5712E100000000uLL) >> 32)},
   {(VUINT32) ((0x3E0EE8A22F7C5987uLL) >> 0),
    (VUINT32) ((0x3E0EE8A22F7C5987uLL) >> 32)},
   {(VUINT32) ((0x3F670FC100000000uLL) >> 0),
    (VUINT32) ((0x3F670FC100000000uLL) >> 32)},
   {(VUINT32) ((0x3E17E16043FD7529uLL) >> 0),
    (VUINT32) ((0x3E17E16043FD7529uLL) >> 32)},
   {(VUINT32) ((0x3F71497700000000uLL) >> 0),
    (VUINT32) ((0x3F71497700000000uLL) >> 32)},
   {(VUINT32) ((0x3E239EFB866B119CuLL) >> 0),
    (VUINT32) ((0x3E239EFB866B119CuLL) >> 32)},
   {(VUINT32) ((0x3F7709BB00000000uLL) >> 0),
    (VUINT32) ((0x3F7709BB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E1B5EA7EE997DC0uLL) >> 0),
    (VUINT32) ((0x3E1B5EA7EE997DC0uLL) >> 32)},
   {(VUINT32) ((0x3F7CC8AA00000000uLL) >> 0),
    (VUINT32) ((0x3F7CC8AA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E2EFAD156451E8DuLL) >> 0),
    (VUINT32) ((0x3E2EFAD156451E8DuLL) >> 32)},
   {(VUINT32) ((0x3F81430200000000uLL) >> 0),
    (VUINT32) ((0x3F81430200000000uLL) >> 32)},
   {(VUINT32) ((0x3E204975BF955EE8uLL) >> 0),
    (VUINT32) ((0x3E204975BF955EE8uLL) >> 32)},
   {(VUINT32) ((0x3F84210300000000uLL) >> 0),
    (VUINT32) ((0x3F84210300000000uLL) >> 32)},
   {(VUINT32) ((0x3E2E526353333F9AuLL) >> 0),
    (VUINT32) ((0x3E2E526353333F9AuLL) >> 32)},
   {(VUINT32) ((0x3F86FE5800000000uLL) >> 0),
    (VUINT32) ((0x3F86FE5800000000uLL) >> 32)},
   {(VUINT32) ((0x3E2DBBC5D9986525uLL) >> 0),
    (VUINT32) ((0x3E2DBBC5D9986525uLL) >> 32)},
   {(VUINT32) ((0x3F89DAE000000000uLL) >> 0),
    (VUINT32) ((0x3F89DAE000000000uLL) >> 32)},
   {(VUINT32) ((0x3E211AE127D370F8uLL) >> 0),
    (VUINT32) ((0x3E211AE127D370F8uLL) >> 32)},
   {(VUINT32) ((0x3F8CB6BA00000000uLL) >> 0),
    (VUINT32) ((0x3F8CB6BA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E2AF44E8A20FE77uLL) >> 0),
    (VUINT32) ((0x3E2AF44E8A20FE77uLL) >> 32)},
   {(VUINT32) ((0x3F8F91E600000000uLL) >> 0),
    (VUINT32) ((0x3F8F91E600000000uLL) >> 32)},
   {(VUINT32) ((0x3E1F77BD1CD9FBC7uLL) >> 0),
    (VUINT32) ((0x3E1F77BD1CD9FBC7uLL) >> 32)},
   {(VUINT32) ((0x3F91363100000000uLL) >> 0),
    (VUINT32) ((0x3F91363100000000uLL) >> 32)},
   {(VUINT32) ((0x3E40F52F789C83A3uLL) >> 0),
    (VUINT32) ((0x3E40F52F789C83A3uLL) >> 32)},
   {(VUINT32) ((0x3F92A31800000000uLL) >> 0),
    (VUINT32) ((0x3F92A31800000000uLL) >> 32)},
   {(VUINT32) ((0x3E172308C2064B24uLL) >> 0),
    (VUINT32) ((0x3E172308C2064B24uLL) >> 32)},
   {(VUINT32) ((0x3F940F9600000000uLL) >> 0),
    (VUINT32) ((0x3F940F9600000000uLL) >> 32)},
   {(VUINT32) ((0x3E2F342D9EB8AEEDuLL) >> 0),
    (VUINT32) ((0x3E2F342D9EB8AEEDuLL) >> 32)},
   {(VUINT32) ((0x3F957BBB00000000uLL) >> 0),
    (VUINT32) ((0x3F957BBB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E4ABB9A144866B7uLL) >> 0),
    (VUINT32) ((0x3E4ABB9A144866B7uLL) >> 32)},
   {(VUINT32) ((0x3F96E79800000000uLL) >> 0),
    (VUINT32) ((0x3F96E79800000000uLL) >> 32)},
   {(VUINT32) ((0x3E48B85AC72B0200uLL) >> 0),
    (VUINT32) ((0x3E48B85AC72B0200uLL) >> 32)},
   {(VUINT32) ((0x3F98530C00000000uLL) >> 0),
    (VUINT32) ((0x3F98530C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E2D1E01FBC85D86uLL) >> 0),
    (VUINT32) ((0x3E2D1E01FBC85D86uLL) >> 32)},
   {(VUINT32) ((0x3F99BE3600000000uLL) >> 0),
    (VUINT32) ((0x3F99BE3600000000uLL) >> 32)},
   {(VUINT32) ((0x3E37D26F00CDA0DDuLL) >> 0),
    (VUINT32) ((0x3E37D26F00CDA0DDuLL) >> 32)},
   {(VUINT32) ((0x3F9B28F600000000uLL) >> 0),
    (VUINT32) ((0x3F9B28F600000000uLL) >> 32)},
   {(VUINT32) ((0x3E3433218E840F16uLL) >> 0),
    (VUINT32) ((0x3E3433218E840F16uLL) >> 32)},
   {(VUINT32) ((0x3F9C935B00000000uLL) >> 0),
    (VUINT32) ((0x3F9C935B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E4F50A107FB8C37uLL) >> 0),
    (VUINT32) ((0x3E4F50A107FB8C37uLL) >> 32)},
   {(VUINT32) ((0x3F9DFD7700000000uLL) >> 0),
    (VUINT32) ((0x3F9DFD7700000000uLL) >> 32)},
   {(VUINT32) ((0x3E3604E609A9E948uLL) >> 0),
    (VUINT32) ((0x3E3604E609A9E948uLL) >> 32)},
   {(VUINT32) ((0x3F9F673700000000uLL) >> 0),
    (VUINT32) ((0x3F9F673700000000uLL) >> 32)},
   {(VUINT32) ((0x3E489F0DE52D1118uLL) >> 0),
    (VUINT32) ((0x3E489F0DE52D1118uLL) >> 32)},
   {(VUINT32) ((0x3FA0684E00000000uLL) >> 0),
    (VUINT32) ((0x3FA0684E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E4D127BD17ABD42uLL) >> 0),
    (VUINT32) ((0x3E4D127BD17ABD42uLL) >> 32)},
   {(VUINT32) ((0x3FA11CD300000000uLL) >> 0),
    (VUINT32) ((0x3FA11CD300000000uLL) >> 32)},
   {(VUINT32) ((0x3E3A899B4ECE6057uLL) >> 0),
    (VUINT32) ((0x3E3A899B4ECE6057uLL) >> 32)},
   {(VUINT32) ((0x3FA1D12900000000uLL) >> 0),
    (VUINT32) ((0x3FA1D12900000000uLL) >> 32)},
   {(VUINT32) ((0x3E5F0D0F99858CFAuLL) >> 0),
    (VUINT32) ((0x3E5F0D0F99858CFAuLL) >> 32)},
   {(VUINT32) ((0x3FA2855A00000000uLL) >> 0),
    (VUINT32) ((0x3FA2855A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E58B94E89D977A4uLL) >> 0),
    (VUINT32) ((0x3E58B94E89D977A4uLL) >> 32)},
   {(VUINT32) ((0x3FA3395D00000000uLL) >> 0),
    (VUINT32) ((0x3FA3395D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E402A7F6BF76796uLL) >> 0),
    (VUINT32) ((0x3E402A7F6BF76796uLL) >> 32)},
   {(VUINT32) ((0x3FA3ED3100000000uLL) >> 0),
    (VUINT32) ((0x3FA3ED3100000000uLL) >> 32)},
   {(VUINT32) ((0x3E3E342DA3E0AAB6uLL) >> 0),
    (VUINT32) ((0x3E3E342DA3E0AAB6uLL) >> 32)},
   {(VUINT32) ((0x3FA4A0DE00000000uLL) >> 0),
    (VUINT32) ((0x3FA4A0DE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E58CAE94CD5496BuLL) >> 0),
    (VUINT32) ((0x3E58CAE94CD5496BuLL) >> 32)},
   {(VUINT32) ((0x3FA5545500000000uLL) >> 0),
    (VUINT32) ((0x3FA5545500000000uLL) >> 32)},
   {(VUINT32) ((0x3E3FDC64D89D4032uLL) >> 0),
    (VUINT32) ((0x3E3FDC64D89D4032uLL) >> 32)},
   {(VUINT32) ((0x3FA607AD00000000uLL) >> 0),
    (VUINT32) ((0x3FA607AD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E37DFD30F154124uLL) >> 0),
    (VUINT32) ((0x3E37DFD30F154124uLL) >> 32)},
   {(VUINT32) ((0x3FA6BAD500000000uLL) >> 0),
    (VUINT32) ((0x3FA6BAD500000000uLL) >> 32)},
   {(VUINT32) ((0x3E5EB1E05460B0E3uLL) >> 0),
    (VUINT32) ((0x3E5EB1E05460B0E3uLL) >> 32)},
   {(VUINT32) ((0x3FA76DCF00000000uLL) >> 0),
    (VUINT32) ((0x3FA76DCF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E490EAD14C7109DuLL) >> 0),
    (VUINT32) ((0x3E490EAD14C7109DuLL) >> 32)},
   {(VUINT32) ((0x3FA820A100000000uLL) >> 0),
    (VUINT32) ((0x3FA820A100000000uLL) >> 32)},
   {(VUINT32) ((0x3E5258EAF10715E3uLL) >> 0),
    (VUINT32) ((0x3E5258EAF10715E3uLL) >> 32)},
   {(VUINT32) ((0x3FA8D34400000000uLL) >> 0),
    (VUINT32) ((0x3FA8D34400000000uLL) >> 32)},
   {(VUINT32) ((0x3E242A28E25FB4D0uLL) >> 0),
    (VUINT32) ((0x3E242A28E25FB4D0uLL) >> 32)},
   {(VUINT32) ((0x3FA985BF00000000uLL) >> 0),
    (VUINT32) ((0x3FA985BF00000000uLL) >> 32)},
   {(VUINT32) ((0x3DFA4A83C146EC0FuLL) >> 0),
    (VUINT32) ((0x3DFA4A83C146EC0FuLL) >> 32)},
   {(VUINT32) ((0x3FAA381200000000uLL) >> 0),
    (VUINT32) ((0x3FAA381200000000uLL) >> 32)},
   {(VUINT32) ((0x3E3C7DE45FE856F6uLL) >> 0),
    (VUINT32) ((0x3E3C7DE45FE856F6uLL) >> 32)},
   {(VUINT32) ((0x3FAAEA3500000000uLL) >> 0),
    (VUINT32) ((0x3FAAEA3500000000uLL) >> 32)},
   {(VUINT32) ((0x3E408258F0914A28uLL) >> 0),
    (VUINT32) ((0x3E408258F0914A28uLL) >> 32)},
   {(VUINT32) ((0x3FAB9C3000000000uLL) >> 0),
    (VUINT32) ((0x3FAB9C3000000000uLL) >> 32)},
   {(VUINT32) ((0x3E3F9589C628DFE0uLL) >> 0),
    (VUINT32) ((0x3E3F9589C628DFE0uLL) >> 32)},
   {(VUINT32) ((0x3FAC4DFA00000000uLL) >> 0),
    (VUINT32) ((0x3FAC4DFA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5721556BDE9F1FuLL) >> 0),
    (VUINT32) ((0x3E5721556BDE9F1FuLL) >> 32)},
   {(VUINT32) ((0x3FACFF9C00000000uLL) >> 0),
    (VUINT32) ((0x3FACFF9C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5A8867F80F2A46uLL) >> 0),
    (VUINT32) ((0x3E5A8867F80F2A46uLL) >> 32)},
   {(VUINT32) ((0x3FADB11600000000uLL) >> 0),
    (VUINT32) ((0x3FADB11600000000uLL) >> 32)},
   {(VUINT32) ((0x3E4A583C979A598EuLL) >> 0),
    (VUINT32) ((0x3E4A583C979A598EuLL) >> 32)},
   {(VUINT32) ((0x3FAE626700000000uLL) >> 0),
    (VUINT32) ((0x3FAE626700000000uLL) >> 32)},
   {(VUINT32) ((0x3E443847800C1405uLL) >> 0),
    (VUINT32) ((0x3E443847800C1405uLL) >> 32)},
   {(VUINT32) ((0x3FAF138700000000uLL) >> 0),
    (VUINT32) ((0x3FAF138700000000uLL) >> 32)},
   {(VUINT32) ((0x3E1664A168A10688uLL) >> 0),
    (VUINT32) ((0x3E1664A168A10688uLL) >> 32)},
   {(VUINT32) ((0x3FAFC48600000000uLL) >> 0),
    (VUINT32) ((0x3FAFC48600000000uLL) >> 32)},
   {(VUINT32) ((0x3E2EB49173242E2EuLL) >> 0),
    (VUINT32) ((0x3E2EB49173242E2EuLL) >> 32)},
   {(VUINT32) ((0x3FB03AA900000000uLL) >> 0),
    (VUINT32) ((0x3FB03AA900000000uLL) >> 32)},
   {(VUINT32) ((0x3E6B1B90DF1D2899uLL) >> 0),
    (VUINT32) ((0x3E6B1B90DF1D2899uLL) >> 32)},
   {(VUINT32) ((0x3FB092FB00000000uLL) >> 0),
    (VUINT32) ((0x3FB092FB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6F4828DCE8EF96uLL) >> 0),
    (VUINT32) ((0x3E6F4828DCE8EF96uLL) >> 32)},
   {(VUINT32) ((0x3FB0EB3900000000uLL) >> 0),
    (VUINT32) ((0x3FB0EB3900000000uLL) >> 32)},
   {(VUINT32) ((0x3E57E8A84071ED7CuLL) >> 0),
    (VUINT32) ((0x3E57E8A84071ED7CuLL) >> 32)},
   {(VUINT32) ((0x3FB1436100000000uLL) >> 0),
    (VUINT32) ((0x3FB1436100000000uLL) >> 32)},
   {(VUINT32) ((0x3E6EA26E46FC50E3uLL) >> 0),
    (VUINT32) ((0x3E6EA26E46FC50E3uLL) >> 32)},
   {(VUINT32) ((0x3FB19B7500000000uLL) >> 0),
    (VUINT32) ((0x3FB19B7500000000uLL) >> 32)},
   {(VUINT32) ((0x3E64D3EC52377554uLL) >> 0),
    (VUINT32) ((0x3E64D3EC52377554uLL) >> 32)},
   {(VUINT32) ((0x3FB1F37000000000uLL) >> 0),
    (VUINT32) ((0x3FB1F37000000000uLL) >> 32)},
   {(VUINT32) ((0x3E46A5728109990DuLL) >> 0),
    (VUINT32) ((0x3E46A5728109990DuLL) >> 32)},
   {(VUINT32) ((0x3FB24B5900000000uLL) >> 0),
    (VUINT32) ((0x3FB24B5900000000uLL) >> 32)},
   {(VUINT32) ((0x3E6B426B10E12CA0uLL) >> 0),
    (VUINT32) ((0x3E6B426B10E12CA0uLL) >> 32)},
   {(VUINT32) ((0x3FB2A32E00000000uLL) >> 0),
    (VUINT32) ((0x3FB2A32E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E59BBBA7C1B46C7uLL) >> 0),
    (VUINT32) ((0x3E59BBBA7C1B46C7uLL) >> 32)},
   {(VUINT32) ((0x3FB2FAED00000000uLL) >> 0),
    (VUINT32) ((0x3FB2FAED00000000uLL) >> 32)},
   {(VUINT32) ((0x3E67F99638784FAFuLL) >> 0),
    (VUINT32) ((0x3E67F99638784FAFuLL) >> 32)},
   {(VUINT32) ((0x3FB3529C00000000uLL) >> 0),
    (VUINT32) ((0x3FB3529C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E1E52F196858161uLL) >> 0),
    (VUINT32) ((0x3E1E52F196858161uLL) >> 32)},
   {(VUINT32) ((0x3FB3AA3000000000uLL) >> 0),
    (VUINT32) ((0x3FB3AA3000000000uLL) >> 32)},
   {(VUINT32) ((0x3E67A4FE6DEF19E6uLL) >> 0),
    (VUINT32) ((0x3E67A4FE6DEF19E6uLL) >> 32)},
   {(VUINT32) ((0x3FB401B000000000uLL) >> 0),
    (VUINT32) ((0x3FB401B000000000uLL) >> 32)},
   {(VUINT32) ((0x3E0302A326E6A3DCuLL) >> 0),
    (VUINT32) ((0x3E0302A326E6A3DCuLL) >> 32)},
   {(VUINT32) ((0x3FB4591D00000000uLL) >> 0),
    (VUINT32) ((0x3FB4591D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6FA21B2E435F49uLL) >> 0),
    (VUINT32) ((0x3E6FA21B2E435F49uLL) >> 32)},
   {(VUINT32) ((0x3FB4B07600000000uLL) >> 0),
    (VUINT32) ((0x3FB4B07600000000uLL) >> 32)},
   {(VUINT32) ((0x3E58415E51626967uLL) >> 0),
    (VUINT32) ((0x3E58415E51626967uLL) >> 32)},
   {(VUINT32) ((0x3FB507B900000000uLL) >> 0),
    (VUINT32) ((0x3FB507B900000000uLL) >> 32)},
   {(VUINT32) ((0x3E3A033D6C5941C4uLL) >> 0),
    (VUINT32) ((0x3E3A033D6C5941C4uLL) >> 32)},
   {(VUINT32) ((0x3FB55EE600000000uLL) >> 0),
    (VUINT32) ((0x3FB55EE600000000uLL) >> 32)},
   {(VUINT32) ((0x3E33C8467C54296BuLL) >> 0),
    (VUINT32) ((0x3E33C8467C54296BuLL) >> 32)},
   {(VUINT32) ((0x3FB5B60100000000uLL) >> 0),
    (VUINT32) ((0x3FB5B60100000000uLL) >> 32)},
   {(VUINT32) ((0x3E5E02F5A12FE65DuLL) >> 0),
    (VUINT32) ((0x3E5E02F5A12FE65DuLL) >> 32)},
   {(VUINT32) ((0x3FB60D0600000000uLL) >> 0),
    (VUINT32) ((0x3FB60D0600000000uLL) >> 32)},
   {(VUINT32) ((0x3E6ECFC86D9ED70DuLL) >> 0),
    (VUINT32) ((0x3E6ECFC86D9ED70DuLL) >> 32)},
   {(VUINT32) ((0x3FB663F600000000uLL) >> 0),
    (VUINT32) ((0x3FB663F600000000uLL) >> 32)},
   {(VUINT32) ((0x3E5EB24497A376B8uLL) >> 0),
    (VUINT32) ((0x3E5EB24497A376B8uLL) >> 32)},
   {(VUINT32) ((0x3FB6BAD400000000uLL) >> 0),
    (VUINT32) ((0x3FB6BAD400000000uLL) >> 32)},
   {(VUINT32) ((0x3E48C77F72E2B40FuLL) >> 0),
    (VUINT32) ((0x3E48C77F72E2B40FuLL) >> 32)},
   {(VUINT32) ((0x3FB7119B00000000uLL) >> 0),
    (VUINT32) ((0x3FB7119B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E68ED7D5E52D89EuLL) >> 0),
    (VUINT32) ((0x3E68ED7D5E52D89EuLL) >> 32)},
   {(VUINT32) ((0x3FB7684D00000000uLL) >> 0),
    (VUINT32) ((0x3FB7684D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E43FA7EA9D3799BuLL) >> 0),
    (VUINT32) ((0x3E43FA7EA9D3799BuLL) >> 32)},
   {(VUINT32) ((0x3FB7BEEC00000000uLL) >> 0),
    (VUINT32) ((0x3FB7BEEC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E60571414F770DBuLL) >> 0),
    (VUINT32) ((0x3E60571414F770DBuLL) >> 32)},
   {(VUINT32) ((0x3FB8157900000000uLL) >> 0),
    (VUINT32) ((0x3FB8157900000000uLL) >> 32)},
   {(VUINT32) ((0x3E68C7D07F316EE3uLL) >> 0),
    (VUINT32) ((0x3E68C7D07F316EE3uLL) >> 32)},
   {(VUINT32) ((0x3FB86BF000000000uLL) >> 0),
    (VUINT32) ((0x3FB86BF000000000uLL) >> 32)},
   {(VUINT32) ((0x3E6360F420C77BECuLL) >> 0),
    (VUINT32) ((0x3E6360F420C77BECuLL) >> 32)},
   {(VUINT32) ((0x3FB8C25000000000uLL) >> 0),
    (VUINT32) ((0x3FB8C25000000000uLL) >> 32)},
   {(VUINT32) ((0x3E6D91C947D50FA1uLL) >> 0),
    (VUINT32) ((0x3E6D91C947D50FA1uLL) >> 32)},
   {(VUINT32) ((0x3FB918A300000000uLL) >> 0),
    (VUINT32) ((0x3FB918A300000000uLL) >> 32)},
   {(VUINT32) ((0x3E4B231BA93BD154uLL) >> 0),
    (VUINT32) ((0x3E4B231BA93BD154uLL) >> 32)},
   {(VUINT32) ((0x3FB96EDA00000000uLL) >> 0),
    (VUINT32) ((0x3FB96EDA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E61D38C8099FDDDuLL) >> 0),
    (VUINT32) ((0x3E61D38C8099FDDDuLL) >> 32)},
   {(VUINT32) ((0x3FB9C50300000000uLL) >> 0),
    (VUINT32) ((0x3FB9C50300000000uLL) >> 32)},
   {(VUINT32) ((0x3E677EEB9B0174ACuLL) >> 0),
    (VUINT32) ((0x3E677EEB9B0174ACuLL) >> 32)},
   {(VUINT32) ((0x3FBA1B1100000000uLL) >> 0),
    (VUINT32) ((0x3FBA1B1100000000uLL) >> 32)},
   {(VUINT32) ((0x3E69D6DDD016014CuLL) >> 0),
    (VUINT32) ((0x3E69D6DDD016014CuLL) >> 32)},
   {(VUINT32) ((0x3FBA711100000000uLL) >> 0),
    (VUINT32) ((0x3FBA711100000000uLL) >> 32)},
   {(VUINT32) ((0x3E626690842B7789uLL) >> 0),
    (VUINT32) ((0x3E626690842B7789uLL) >> 32)},
   {(VUINT32) ((0x3FBAC6FA00000000uLL) >> 0),
    (VUINT32) ((0x3FBAC6FA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5830B93095C531uLL) >> 0),
    (VUINT32) ((0x3E5830B93095C531uLL) >> 32)},
   {(VUINT32) ((0x3FBB1CD000000000uLL) >> 0),
    (VUINT32) ((0x3FBB1CD000000000uLL) >> 32)},
   {(VUINT32) ((0x3E5C2B99518E0D2CuLL) >> 0),
    (VUINT32) ((0x3E5C2B99518E0D2CuLL) >> 32)},
   {(VUINT32) ((0x3FBB729300000000uLL) >> 0),
    (VUINT32) ((0x3FBB729300000000uLL) >> 32)},
   {(VUINT32) ((0x3E66279B91823620uLL) >> 0),
    (VUINT32) ((0x3E66279B91823620uLL) >> 32)},
   {(VUINT32) ((0x3FBBC84400000000uLL) >> 0),
    (VUINT32) ((0x3FBBC84400000000uLL) >> 32)},
   {(VUINT32) ((0x3E30ADAFC9057ECCuLL) >> 0),
    (VUINT32) ((0x3E30ADAFC9057ECCuLL) >> 32)},
   {(VUINT32) ((0x3FBC1DDD00000000uLL) >> 0),
    (VUINT32) ((0x3FBC1DDD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E461CE45269682AuLL) >> 0),
    (VUINT32) ((0x3E461CE45269682AuLL) >> 32)},
   {(VUINT32) ((0x3FBC736300000000uLL) >> 0),
    (VUINT32) ((0x3FBC736300000000uLL) >> 32)},
   {(VUINT32) ((0x3E5044EF5F2FE276uLL) >> 0),
    (VUINT32) ((0x3E5044EF5F2FE276uLL) >> 32)},
   {(VUINT32) ((0x3FBCC8D600000000uLL) >> 0),
    (VUINT32) ((0x3FBCC8D600000000uLL) >> 32)},
   {(VUINT32) ((0x3E4EB3DBD5234CE7uLL) >> 0),
    (VUINT32) ((0x3E4EB3DBD5234CE7uLL) >> 32)},
   {(VUINT32) ((0x3FBD1E3600000000uLL) >> 0),
    (VUINT32) ((0x3FBD1E3600000000uLL) >> 32)},
   {(VUINT32) ((0x3E2EB70A6E724019uLL) >> 0),
    (VUINT32) ((0x3E2EB70A6E724019uLL) >> 32)},
   {(VUINT32) ((0x3FBD737E00000000uLL) >> 0),
    (VUINT32) ((0x3FBD737E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5403A5977B9A51uLL) >> 0),
    (VUINT32) ((0x3E5403A5977B9A51uLL) >> 32)},
   {(VUINT32) ((0x3FBDC8B700000000uLL) >> 0),
    (VUINT32) ((0x3FBDC8B700000000uLL) >> 32)},
   {(VUINT32) ((0x3E62D343B2886C33uLL) >> 0),
    (VUINT32) ((0x3E62D343B2886C33uLL) >> 32)},
   {(VUINT32) ((0x3FBE1DDD00000000uLL) >> 0),
    (VUINT32) ((0x3FBE1DDD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5F443CFBD572A9uLL) >> 0),
    (VUINT32) ((0x3E5F443CFBD572A9uLL) >> 32)},
   {(VUINT32) ((0x3FBE72EB00000000uLL) >> 0),
    (VUINT32) ((0x3FBE72EB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E632FF4A08C00ADuLL) >> 0),
    (VUINT32) ((0x3E632FF4A08C00ADuLL) >> 32)},
   {(VUINT32) ((0x3FBEC7EA00000000uLL) >> 0),
    (VUINT32) ((0x3FBEC7EA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E611D934F5C870BuLL) >> 0),
    (VUINT32) ((0x3E611D934F5C870BuLL) >> 32)},
   {(VUINT32) ((0x3FBF1CD100000000uLL) >> 0),
    (VUINT32) ((0x3FBF1CD100000000uLL) >> 32)},
   {(VUINT32) ((0x3E610AFC18ECC7FDuLL) >> 0),
    (VUINT32) ((0x3E610AFC18ECC7FDuLL) >> 32)},
   {(VUINT32) ((0x3FBF71A900000000uLL) >> 0),
    (VUINT32) ((0x3FBF71A900000000uLL) >> 32)},
   {(VUINT32) ((0x3E4C5DB9D4383F15uLL) >> 0),
    (VUINT32) ((0x3E4C5DB9D4383F15uLL) >> 32)},
   {(VUINT32) ((0x3FBFC66800000000uLL) >> 0),
    (VUINT32) ((0x3FBFC66800000000uLL) >> 32)},
   {(VUINT32) ((0x3E6A615FE5DCF50AuLL) >> 0),
    (VUINT32) ((0x3E6A615FE5DCF50AuLL) >> 32)},
   {(VUINT32) ((0x3FC00D8C00000000uLL) >> 0),
    (VUINT32) ((0x3FC00D8C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6F8684B8524B4DuLL) >> 0),
    (VUINT32) ((0x3E6F8684B8524B4DuLL) >> 32)},
   {(VUINT32) ((0x3FC037DA00000000uLL) >> 0),
    (VUINT32) ((0x3FC037DA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7471E52C396096uLL) >> 0),
    (VUINT32) ((0x3E7471E52C396096uLL) >> 32)},
   {(VUINT32) ((0x3FC0621E00000000uLL) >> 0),
    (VUINT32) ((0x3FC0621E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7A1AAD94D3758AuLL) >> 0),
    (VUINT32) ((0x3E7A1AAD94D3758AuLL) >> 32)},
   {(VUINT32) ((0x3FC08C5800000000uLL) >> 0),
    (VUINT32) ((0x3FC08C5800000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F9B4F573CD19DuLL) >> 0),
    (VUINT32) ((0x3E7F9B4F573CD19DuLL) >> 32)},
   {(VUINT32) ((0x3FC0B68900000000uLL) >> 0),
    (VUINT32) ((0x3FC0B68900000000uLL) >> 32)},
   {(VUINT32) ((0x3E4E88E925A98AFDuLL) >> 0),
    (VUINT32) ((0x3E4E88E925A98AFDuLL) >> 32)},
   {(VUINT32) ((0x3FC0E0B100000000uLL) >> 0),
    (VUINT32) ((0x3FC0E0B100000000uLL) >> 32)},
   {(VUINT32) ((0x3E677212D0EEB433uLL) >> 0),
    (VUINT32) ((0x3E677212D0EEB433uLL) >> 32)},
   {(VUINT32) ((0x3FC10ACD00000000uLL) >> 0),
    (VUINT32) ((0x3FC10ACD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E63FF48E459228FuLL) >> 0),
    (VUINT32) ((0x3E63FF48E459228FuLL) >> 32)},
   {(VUINT32) ((0x3FC134E100000000uLL) >> 0),
    (VUINT32) ((0x3FC134E100000000uLL) >> 32)},
   {(VUINT32) ((0x3E63A241697ADC33uLL) >> 0),
    (VUINT32) ((0x3E63A241697ADC33uLL) >> 32)},
   {(VUINT32) ((0x3FC15EEB00000000uLL) >> 0),
    (VUINT32) ((0x3FC15EEB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E4F4A7AE82699A0uLL) >> 0),
    (VUINT32) ((0x3E4F4A7AE82699A0uLL) >> 32)},
   {(VUINT32) ((0x3FC188EC00000000uLL) >> 0),
    (VUINT32) ((0x3FC188EC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7D83A2E1FE8196uLL) >> 0),
    (VUINT32) ((0x3E7D83A2E1FE8196uLL) >> 32)},
   {(VUINT32) ((0x3FC1B2E400000000uLL) >> 0),
    (VUINT32) ((0x3FC1B2E400000000uLL) >> 32)},
   {(VUINT32) ((0x3E6E765C52C5B577uLL) >> 0),
    (VUINT32) ((0x3E6E765C52C5B577uLL) >> 32)},
   {(VUINT32) ((0x3FC1DCD100000000uLL) >> 0),
    (VUINT32) ((0x3FC1DCD100000000uLL) >> 32)},
   {(VUINT32) ((0x3E77EAA5780399BEuLL) >> 0),
    (VUINT32) ((0x3E77EAA5780399BEuLL) >> 32)},
   {(VUINT32) ((0x3FC206B400000000uLL) >> 0),
    (VUINT32) ((0x3FC206B400000000uLL) >> 32)},
   {(VUINT32) ((0x3E766C5EF95AB1FCuLL) >> 0),
    (VUINT32) ((0x3E766C5EF95AB1FCuLL) >> 32)},
   {(VUINT32) ((0x3FC2308F00000000uLL) >> 0),
    (VUINT32) ((0x3FC2308F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E703A52D5DB6084uLL) >> 0),
    (VUINT32) ((0x3E703A52D5DB6084uLL) >> 32)},
   {(VUINT32) ((0x3FC25A6200000000uLL) >> 0),
    (VUINT32) ((0x3FC25A6200000000uLL) >> 32)},
   {(VUINT32) ((0x3E51786D7D82F6F1uLL) >> 0),
    (VUINT32) ((0x3E51786D7D82F6F1uLL) >> 32)},
   {(VUINT32) ((0x3FC2842A00000000uLL) >> 0),
    (VUINT32) ((0x3FC2842A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6641EA2DED60B8uLL) >> 0),
    (VUINT32) ((0x3E6641EA2DED60B8uLL) >> 32)},
   {(VUINT32) ((0x3FC2ADE800000000uLL) >> 0),
    (VUINT32) ((0x3FC2ADE800000000uLL) >> 32)},
   {(VUINT32) ((0x3E4ADDFBEAA772F7uLL) >> 0),
    (VUINT32) ((0x3E4ADDFBEAA772F7uLL) >> 32)},
   {(VUINT32) ((0x3FC2D79B00000000uLL) >> 0),
    (VUINT32) ((0x3FC2D79B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E67CDFBBC061E04uLL) >> 0),
    (VUINT32) ((0x3E67CDFBBC061E04uLL) >> 32)},
   {(VUINT32) ((0x3FC3014800000000uLL) >> 0),
    (VUINT32) ((0x3FC3014800000000uLL) >> 32)},
   {(VUINT32) ((0x3E717AD775A7481BuLL) >> 0),
    (VUINT32) ((0x3E717AD775A7481BuLL) >> 32)},
   {(VUINT32) ((0x3FC32AE800000000uLL) >> 0),
    (VUINT32) ((0x3FC32AE800000000uLL) >> 32)},
   {(VUINT32) ((0x3E7E4F15A673BAF4uLL) >> 0),
    (VUINT32) ((0x3E7E4F15A673BAF4uLL) >> 32)},
   {(VUINT32) ((0x3FC3548300000000uLL) >> 0),
    (VUINT32) ((0x3FC3548300000000uLL) >> 32)},
   {(VUINT32) ((0x3E58ECA1813FA934uLL) >> 0),
    (VUINT32) ((0x3E58ECA1813FA934uLL) >> 32)},
   {(VUINT32) ((0x3FC37E1200000000uLL) >> 0),
    (VUINT32) ((0x3FC37E1200000000uLL) >> 32)},
   {(VUINT32) ((0x3E7A3622382E96FBuLL) >> 0),
    (VUINT32) ((0x3E7A3622382E96FBuLL) >> 32)},
   {(VUINT32) ((0x3FC3A79700000000uLL) >> 0),
    (VUINT32) ((0x3FC3A79700000000uLL) >> 32)},
   {(VUINT32) ((0x3E7916BB2A2CEA0AuLL) >> 0),
    (VUINT32) ((0x3E7916BB2A2CEA0AuLL) >> 32)},
   {(VUINT32) ((0x3FC3D11400000000uLL) >> 0),
    (VUINT32) ((0x3FC3D11400000000uLL) >> 32)},
   {(VUINT32) ((0x3E61E6A28AAA11CBuLL) >> 0),
    (VUINT32) ((0x3E61E6A28AAA11CBuLL) >> 32)},
   {(VUINT32) ((0x3FC3FA8800000000uLL) >> 0),
    (VUINT32) ((0x3FC3FA8800000000uLL) >> 32)},
   {(VUINT32) ((0x3E61A3CECA68F920uLL) >> 0),
    (VUINT32) ((0x3E61A3CECA68F920uLL) >> 32)},
   {(VUINT32) ((0x3FC423F100000000uLL) >> 0),
    (VUINT32) ((0x3FC423F100000000uLL) >> 32)},
   {(VUINT32) ((0x3E705825C8CAF8EDuLL) >> 0),
    (VUINT32) ((0x3E705825C8CAF8EDuLL) >> 32)},
   {(VUINT32) ((0x3FC44D5200000000uLL) >> 0),
    (VUINT32) ((0x3FC44D5200000000uLL) >> 32)},
   {(VUINT32) ((0x3E572D6F71F4B037uLL) >> 0),
    (VUINT32) ((0x3E572D6F71F4B037uLL) >> 32)},
   {(VUINT32) ((0x3FC476AA00000000uLL) >> 0),
    (VUINT32) ((0x3FC476AA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6060FDF3CABB49uLL) >> 0),
    (VUINT32) ((0x3E6060FDF3CABB49uLL) >> 32)},
   {(VUINT32) ((0x3FC49FF700000000uLL) >> 0),
    (VUINT32) ((0x3FC49FF700000000uLL) >> 32)},
   {(VUINT32) ((0x3E6DF855C48E67AAuLL) >> 0),
    (VUINT32) ((0x3E6DF855C48E67AAuLL) >> 32)},
   {(VUINT32) ((0x3FC4C93E00000000uLL) >> 0),
    (VUINT32) ((0x3FC4C93E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E60854767C83D89uLL) >> 0),
    (VUINT32) ((0x3E60854767C83D89uLL) >> 32)},
   {(VUINT32) ((0x3FC4F27700000000uLL) >> 0),
    (VUINT32) ((0x3FC4F27700000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C27D2ADFA3CF1uLL) >> 0),
    (VUINT32) ((0x3E7C27D2ADFA3CF1uLL) >> 32)},
   {(VUINT32) ((0x3FC51BAB00000000uLL) >> 0),
    (VUINT32) ((0x3FC51BAB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E21E96F77A9B8FFuLL) >> 0),
    (VUINT32) ((0x3E21E96F77A9B8FFuLL) >> 32)},
   {(VUINT32) ((0x3FC544D500000000uLL) >> 0),
    (VUINT32) ((0x3FC544D500000000uLL) >> 32)},
   {(VUINT32) ((0x3E69B89066DA0127uLL) >> 0),
    (VUINT32) ((0x3E69B89066DA0127uLL) >> 32)},
   {(VUINT32) ((0x3FC56DF400000000uLL) >> 0),
    (VUINT32) ((0x3FC56DF400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7831AB063F0639uLL) >> 0),
    (VUINT32) ((0x3E7831AB063F0639uLL) >> 32)},
   {(VUINT32) ((0x3FC5970B00000000uLL) >> 0),
    (VUINT32) ((0x3FC5970B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E62A3FF97F4402EuLL) >> 0),
    (VUINT32) ((0x3E62A3FF97F4402EuLL) >> 32)},
   {(VUINT32) ((0x3FC5C01B00000000uLL) >> 0),
    (VUINT32) ((0x3FC5C01B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5CFDEC6AA61224uLL) >> 0),
    (VUINT32) ((0x3E5CFDEC6AA61224uLL) >> 32)},
   {(VUINT32) ((0x3FC5E92000000000uLL) >> 0),
    (VUINT32) ((0x3FC5E92000000000uLL) >> 32)},
   {(VUINT32) ((0x3E30BF99A341739BuLL) >> 0),
    (VUINT32) ((0x3E30BF99A341739BuLL) >> 32)},
   {(VUINT32) ((0x3FC6121900000000uLL) >> 0),
    (VUINT32) ((0x3FC6121900000000uLL) >> 32)},
   {(VUINT32) ((0x3E7589025C069AF7uLL) >> 0),
    (VUINT32) ((0x3E7589025C069AF7uLL) >> 32)},
   {(VUINT32) ((0x3FC63B0C00000000uLL) >> 0),
    (VUINT32) ((0x3FC63B0C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E73E7C70DC28176uLL) >> 0),
    (VUINT32) ((0x3E73E7C70DC28176uLL) >> 32)},
   {(VUINT32) ((0x3FC663F600000000uLL) >> 0),
    (VUINT32) ((0x3FC663F600000000uLL) >> 32)},
   {(VUINT32) ((0x3E7319225255ED92uLL) >> 0),
    (VUINT32) ((0x3E7319225255ED92uLL) >> 32)},
   {(VUINT32) ((0x3FC68CD700000000uLL) >> 0),
    (VUINT32) ((0x3FC68CD700000000uLL) >> 32)},
   {(VUINT32) ((0x3E721D999E92E626uLL) >> 0),
    (VUINT32) ((0x3E721D999E92E626uLL) >> 32)},
   {(VUINT32) ((0x3FC6B5AF00000000uLL) >> 0),
    (VUINT32) ((0x3FC6B5AF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6FEABA3C111C8AuLL) >> 0),
    (VUINT32) ((0x3E6FEABA3C111C8AuLL) >> 32)},
   {(VUINT32) ((0x3FC6DE7E00000000uLL) >> 0),
    (VUINT32) ((0x3FC6DE7E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E67408FFBA276E0uLL) >> 0),
    (VUINT32) ((0x3E67408FFBA276E0uLL) >> 32)},
   {(VUINT32) ((0x3FC7074100000000uLL) >> 0),
    (VUINT32) ((0x3FC7074100000000uLL) >> 32)},
   {(VUINT32) ((0x3E7B9DE032CB0FD0uLL) >> 0),
    (VUINT32) ((0x3E7B9DE032CB0FD0uLL) >> 32)},
   {(VUINT32) ((0x3FC72FFE00000000uLL) >> 0),
    (VUINT32) ((0x3FC72FFE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6FBAB18DF0F78EuLL) >> 0),
    (VUINT32) ((0x3E6FBAB18DF0F78EuLL) >> 32)},
   {(VUINT32) ((0x3FC758B100000000uLL) >> 0),
    (VUINT32) ((0x3FC758B100000000uLL) >> 32)},
   {(VUINT32) ((0x3E7EED8F544CC58AuLL) >> 0),
    (VUINT32) ((0x3E7EED8F544CC58AuLL) >> 32)},
   {(VUINT32) ((0x3FC7815C00000000uLL) >> 0),
    (VUINT32) ((0x3FC7815C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5F34382F992A55uLL) >> 0),
    (VUINT32) ((0x3E5F34382F992A55uLL) >> 32)},
   {(VUINT32) ((0x3FC7A9FF00000000uLL) >> 0),
    (VUINT32) ((0x3FC7A9FF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E723A0BF2565894uLL) >> 0),
    (VUINT32) ((0x3E723A0BF2565894uLL) >> 32)},
   {(VUINT32) ((0x3FC7D29700000000uLL) >> 0),
    (VUINT32) ((0x3FC7D29700000000uLL) >> 32)},
   {(VUINT32) ((0x3E6784D72660BF64uLL) >> 0),
    (VUINT32) ((0x3E6784D72660BF64uLL) >> 32)},
   {(VUINT32) ((0x3FC7FB2800000000uLL) >> 0),
    (VUINT32) ((0x3FC7FB2800000000uLL) >> 32)},
   {(VUINT32) ((0x3E53CEF9F2A00FDAuLL) >> 0),
    (VUINT32) ((0x3E53CEF9F2A00FDAuLL) >> 32)},
   {(VUINT32) ((0x3FC823AD00000000uLL) >> 0),
    (VUINT32) ((0x3FC823AD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6636827E73660EuLL) >> 0),
    (VUINT32) ((0x3E6636827E73660EuLL) >> 32)},
   {(VUINT32) ((0x3FC84C2B00000000uLL) >> 0),
    (VUINT32) ((0x3FC84C2B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6E0BC0CE905E5FuLL) >> 0),
    (VUINT32) ((0x3E6E0BC0CE905E5FuLL) >> 32)},
   {(VUINT32) ((0x3FC874A000000000uLL) >> 0),
    (VUINT32) ((0x3FC874A000000000uLL) >> 32)},
   {(VUINT32) ((0x3E5B40D32CA21B4FuLL) >> 0),
    (VUINT32) ((0x3E5B40D32CA21B4FuLL) >> 32)},
   {(VUINT32) ((0x3FC89D0D00000000uLL) >> 0),
    (VUINT32) ((0x3FC89D0D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7A968650124684uLL) >> 0),
    (VUINT32) ((0x3E7A968650124684uLL) >> 32)},
   {(VUINT32) ((0x3FC8C56F00000000uLL) >> 0),
    (VUINT32) ((0x3FC8C56F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7724C9F4C54DC2uLL) >> 0),
    (VUINT32) ((0x3E7724C9F4C54DC2uLL) >> 32)},
   {(VUINT32) ((0x3FC8EDCA00000000uLL) >> 0),
    (VUINT32) ((0x3FC8EDCA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6B8D4AB3E3B13CuLL) >> 0),
    (VUINT32) ((0x3E6B8D4AB3E3B13CuLL) >> 32)},
   {(VUINT32) ((0x3FC9161B00000000uLL) >> 0),
    (VUINT32) ((0x3FC9161B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E74576BCFDAFE5EuLL) >> 0),
    (VUINT32) ((0x3E74576BCFDAFE5EuLL) >> 32)},
   {(VUINT32) ((0x3FC93E6500000000uLL) >> 0),
    (VUINT32) ((0x3FC93E6500000000uLL) >> 32)},
   {(VUINT32) ((0x3E7332208C376C3FuLL) >> 0),
    (VUINT32) ((0x3E7332208C376C3FuLL) >> 32)},
   {(VUINT32) ((0x3FC966A600000000uLL) >> 0),
    (VUINT32) ((0x3FC966A600000000uLL) >> 32)},
   {(VUINT32) ((0x3DF175E083C82DEBuLL) >> 0),
    (VUINT32) ((0x3DF175E083C82DEBuLL) >> 32)},
   {(VUINT32) ((0x3FC98EDC00000000uLL) >> 0),
    (VUINT32) ((0x3FC98EDC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E79EFCE11AA7D30uLL) >> 0),
    (VUINT32) ((0x3E79EFCE11AA7D30uLL) >> 32)},
   {(VUINT32) ((0x3FC9B70C00000000uLL) >> 0),
    (VUINT32) ((0x3FC9B70C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E62AE7840B35985uLL) >> 0),
    (VUINT32) ((0x3E62AE7840B35985uLL) >> 32)},
   {(VUINT32) ((0x3FC9DF3200000000uLL) >> 0),
    (VUINT32) ((0x3FC9DF3200000000uLL) >> 32)},
   {(VUINT32) ((0x3E4E8C13081D57DCuLL) >> 0),
    (VUINT32) ((0x3E4E8C13081D57DCuLL) >> 32)},
   {(VUINT32) ((0x3FCA074E00000000uLL) >> 0),
    (VUINT32) ((0x3FCA074E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E60B028BF61097BuLL) >> 0),
    (VUINT32) ((0x3E60B028BF61097BuLL) >> 32)},
   {(VUINT32) ((0x3FCA2F6200000000uLL) >> 0),
    (VUINT32) ((0x3FCA2F6200000000uLL) >> 32)},
   {(VUINT32) ((0x3E7FA41706304E8FuLL) >> 0),
    (VUINT32) ((0x3E7FA41706304E8FuLL) >> 32)},
   {(VUINT32) ((0x3FCA576D00000000uLL) >> 0),
    (VUINT32) ((0x3FCA576D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F0E5F94377493uLL) >> 0),
    (VUINT32) ((0x3E7F0E5F94377493uLL) >> 32)},
   {(VUINT32) ((0x3FCA7F7100000000uLL) >> 0),
    (VUINT32) ((0x3FCA7F7100000000uLL) >> 32)},
   {(VUINT32) ((0x3E6EDEEABEEEAB1AuLL) >> 0),
    (VUINT32) ((0x3E6EDEEABEEEAB1AuLL) >> 32)},
   {(VUINT32) ((0x3FCAA76D00000000uLL) >> 0),
    (VUINT32) ((0x3FCAA76D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6FDF22F0CA6C0DuLL) >> 0),
    (VUINT32) ((0x3E6FDF22F0CA6C0DuLL) >> 32)},
   {(VUINT32) ((0x3FCACF5D00000000uLL) >> 0),
    (VUINT32) ((0x3FCACF5D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E676D3AEE892F9CuLL) >> 0),
    (VUINT32) ((0x3E676D3AEE892F9CuLL) >> 32)},
   {(VUINT32) ((0x3FCAF74700000000uLL) >> 0),
    (VUINT32) ((0x3FCAF74700000000uLL) >> 32)},
   {(VUINT32) ((0x3E7FBC37F3121AB7uLL) >> 0),
    (VUINT32) ((0x3E7FBC37F3121AB7uLL) >> 32)},
   {(VUINT32) ((0x3FCB1F2800000000uLL) >> 0),
    (VUINT32) ((0x3FCB1F2800000000uLL) >> 32)},
   {(VUINT32) ((0x3E7717AF8E5DD5B2uLL) >> 0),
    (VUINT32) ((0x3E7717AF8E5DD5B2uLL) >> 32)},
   {(VUINT32) ((0x3FCB46FF00000000uLL) >> 0),
    (VUINT32) ((0x3FCB46FF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E70C006784D6D72uLL) >> 0),
    (VUINT32) ((0x3E70C006784D6D72uLL) >> 32)},
   {(VUINT32) ((0x3FCB6ECE00000000uLL) >> 0),
    (VUINT32) ((0x3FCB6ECE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E75EBF2ABE7A8F0uLL) >> 0),
    (VUINT32) ((0x3E75EBF2ABE7A8F0uLL) >> 32)},
   {(VUINT32) ((0x3FCB969600000000uLL) >> 0),
    (VUINT32) ((0x3FCB969600000000uLL) >> 32)},
   {(VUINT32) ((0x3E570772E1AA6F94uLL) >> 0),
    (VUINT32) ((0x3E570772E1AA6F94uLL) >> 32)},
   {(VUINT32) ((0x3FCBBE5300000000uLL) >> 0),
    (VUINT32) ((0x3FCBBE5300000000uLL) >> 32)},
   {(VUINT32) ((0x3E7507E05D60E5C4uLL) >> 0),
    (VUINT32) ((0x3E7507E05D60E5C4uLL) >> 32)},
   {(VUINT32) ((0x3FCBE60900000000uLL) >> 0),
    (VUINT32) ((0x3FCBE60900000000uLL) >> 32)},
   {(VUINT32) ((0x3E6A479C1C7622D5uLL) >> 0),
    (VUINT32) ((0x3E6A479C1C7622D5uLL) >> 32)},
   {(VUINT32) ((0x3FCC0DB700000000uLL) >> 0),
    (VUINT32) ((0x3FCC0DB700000000uLL) >> 32)},
   {(VUINT32) ((0x3E6A7653CAD63A6AuLL) >> 0),
    (VUINT32) ((0x3E6A7653CAD63A6AuLL) >> 32)},
   {(VUINT32) ((0x3FCC355B00000000uLL) >> 0),
    (VUINT32) ((0x3FCC355B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E63C6576AC08E77uLL) >> 0),
    (VUINT32) ((0x3E63C6576AC08E77uLL) >> 32)},
   {(VUINT32) ((0x3FCC5CF700000000uLL) >> 0),
    (VUINT32) ((0x3FCC5CF700000000uLL) >> 32)},
   {(VUINT32) ((0x3E696181FF9674A7uLL) >> 0),
    (VUINT32) ((0x3E696181FF9674A7uLL) >> 32)},
   {(VUINT32) ((0x3FCC848B00000000uLL) >> 0),
    (VUINT32) ((0x3FCC848B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E74C88B88CB08D4uLL) >> 0),
    (VUINT32) ((0x3E74C88B88CB08D4uLL) >> 32)},
   {(VUINT32) ((0x3FCCAC1500000000uLL) >> 0),
    (VUINT32) ((0x3FCCAC1500000000uLL) >> 32)},
   {(VUINT32) ((0x3E768EE1A3F58613uLL) >> 0),
    (VUINT32) ((0x3E768EE1A3F58613uLL) >> 32)},
   {(VUINT32) ((0x3FCCD39700000000uLL) >> 0),
    (VUINT32) ((0x3FCCD39700000000uLL) >> 32)},
   {(VUINT32) ((0x3E7BC7D00E53901CuLL) >> 0),
    (VUINT32) ((0x3E7BC7D00E53901CuLL) >> 32)},
   {(VUINT32) ((0x3FCCFB1200000000uLL) >> 0),
    (VUINT32) ((0x3FCCFB1200000000uLL) >> 32)},
   {(VUINT32) ((0x3E4CB8C314503175uLL) >> 0),
    (VUINT32) ((0x3E4CB8C314503175uLL) >> 32)},
   {(VUINT32) ((0x3FCD228400000000uLL) >> 0),
    (VUINT32) ((0x3FCD228400000000uLL) >> 32)},
   {(VUINT32) ((0x3E6A40646984129BuLL) >> 0),
    (VUINT32) ((0x3E6A40646984129BuLL) >> 32)},
   {(VUINT32) ((0x3FCD49EE00000000uLL) >> 0),
    (VUINT32) ((0x3FCD49EE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E77864B48C32B3CuLL) >> 0),
    (VUINT32) ((0x3E77864B48C32B3CuLL) >> 32)},
   {(VUINT32) ((0x3FCD714E00000000uLL) >> 0),
    (VUINT32) ((0x3FCD714E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E76DC470F22F1EEuLL) >> 0),
    (VUINT32) ((0x3E76DC470F22F1EEuLL) >> 32)},
   {(VUINT32) ((0x3FCD98A900000000uLL) >> 0),
    (VUINT32) ((0x3FCD98A900000000uLL) >> 32)},
   {(VUINT32) ((0x3E153043B87205ACuLL) >> 0),
    (VUINT32) ((0x3E153043B87205ACuLL) >> 32)},
   {(VUINT32) ((0x3FCDBFF800000000uLL) >> 0),
    (VUINT32) ((0x3FCDBFF800000000uLL) >> 32)},
   {(VUINT32) ((0x3E7CE2096F5BAED1uLL) >> 0),
    (VUINT32) ((0x3E7CE2096F5BAED1uLL) >> 32)},
   {(VUINT32) ((0x3FCDE74000000000uLL) >> 0),
    (VUINT32) ((0x3FCDE74000000000uLL) >> 32)},
   {(VUINT32) ((0x3E76B6293B0E2EA0uLL) >> 0),
    (VUINT32) ((0x3E76B6293B0E2EA0uLL) >> 32)},
   {(VUINT32) ((0x3FCE0E8000000000uLL) >> 0),
    (VUINT32) ((0x3FCE0E8000000000uLL) >> 32)},
   {(VUINT32) ((0x3E69E5C03298A8D0uLL) >> 0),
    (VUINT32) ((0x3E69E5C03298A8D0uLL) >> 32)},
   {(VUINT32) ((0x3FCE35B500000000uLL) >> 0),
    (VUINT32) ((0x3FCE35B500000000uLL) >> 32)},
   {(VUINT32) ((0x3E7359A4ADD9086CuLL) >> 0),
    (VUINT32) ((0x3E7359A4ADD9086CuLL) >> 32)},
   {(VUINT32) ((0x3FCE5CE400000000uLL) >> 0),
    (VUINT32) ((0x3FCE5CE400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7FBBA6E4320B0BuLL) >> 0),
    (VUINT32) ((0x3E7FBBA6E4320B0BuLL) >> 32)},
   {(VUINT32) ((0x3FCE840C00000000uLL) >> 0),
    (VUINT32) ((0x3FCE840C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E57A7356760BF17uLL) >> 0),
    (VUINT32) ((0x3E57A7356760BF17uLL) >> 32)},
   {(VUINT32) ((0x3FCEAB2B00000000uLL) >> 0),
    (VUINT32) ((0x3FCEAB2B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5412DD4C71D4AAuLL) >> 0),
    (VUINT32) ((0x3E5412DD4C71D4AAuLL) >> 32)},
   {(VUINT32) ((0x3FCED23F00000000uLL) >> 0),
    (VUINT32) ((0x3FCED23F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E708CBBD3DE4F64uLL) >> 0),
    (VUINT32) ((0x3E708CBBD3DE4F64uLL) >> 32)},
   {(VUINT32) ((0x3FCEF94D00000000uLL) >> 0),
    (VUINT32) ((0x3FCEF94D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7ED1EC6FB9EF8FuLL) >> 0),
    (VUINT32) ((0x3E7ED1EC6FB9EF8FuLL) >> 32)},
   {(VUINT32) ((0x3FCF205400000000uLL) >> 0),
    (VUINT32) ((0x3FCF205400000000uLL) >> 32)},
   {(VUINT32) ((0x3E4B20911D7E37DBuLL) >> 0),
    (VUINT32) ((0x3E4B20911D7E37DBuLL) >> 32)},
   {(VUINT32) ((0x3FCF474F00000000uLL) >> 0),
    (VUINT32) ((0x3FCF474F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7192AEE74AAF85uLL) >> 0),
    (VUINT32) ((0x3E7192AEE74AAF85uLL) >> 32)},
   {(VUINT32) ((0x3FCF6E4500000000uLL) >> 0),
    (VUINT32) ((0x3FCF6E4500000000uLL) >> 32)},
   {(VUINT32) ((0x3DE9FF7395251CF5uLL) >> 0),
    (VUINT32) ((0x3DE9FF7395251CF5uLL) >> 32)},
   {(VUINT32) ((0x3FCF953200000000uLL) >> 0),
    (VUINT32) ((0x3FCF953200000000uLL) >> 32)},
   {(VUINT32) ((0x3E418FCF45710FC3uLL) >> 0),
    (VUINT32) ((0x3E418FCF45710FC3uLL) >> 32)},
   {(VUINT32) ((0x3FCFBC1600000000uLL) >> 0),
    (VUINT32) ((0x3FCFBC1600000000uLL) >> 32)},
   {(VUINT32) ((0x3E77204D0144751BuLL) >> 0),
    (VUINT32) ((0x3E77204D0144751BuLL) >> 32)},
   {(VUINT32) ((0x3FCFE2F200000000uLL) >> 0),
    (VUINT32) ((0x3FCFE2F200000000uLL) >> 32)},
   {(VUINT32) ((0x3E7DF662B4D59D8EuLL) >> 0),
    (VUINT32) ((0x3E7DF662B4D59D8EuLL) >> 32)},
   {(VUINT32) ((0x3FD004E300000000uLL) >> 0),
    (VUINT32) ((0x3FD004E300000000uLL) >> 32)},
   {(VUINT32) ((0x3E75D25F17B09D21uLL) >> 0),
    (VUINT32) ((0x3E75D25F17B09D21uLL) >> 32)},
   {(VUINT32) ((0x3FD0184A00000000uLL) >> 0),
    (VUINT32) ((0x3FD0184A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E64044284485CA5uLL) >> 0),
    (VUINT32) ((0x3E64044284485CA5uLL) >> 32)},
   {(VUINT32) ((0x3FD02BAB00000000uLL) >> 0),
    (VUINT32) ((0x3FD02BAB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E80A9A0C732CB2CuLL) >> 0),
    (VUINT32) ((0x3E80A9A0C732CB2CuLL) >> 32)},
   {(VUINT32) ((0x3FD03F0900000000uLL) >> 0),
    (VUINT32) ((0x3FD03F0900000000uLL) >> 32)},
   {(VUINT32) ((0x3E89A98AD1490635uLL) >> 0),
    (VUINT32) ((0x3E89A98AD1490635uLL) >> 32)},
   {(VUINT32) ((0x3FD0526300000000uLL) >> 0),
    (VUINT32) ((0x3FD0526300000000uLL) >> 32)},
   {(VUINT32) ((0x3E897756562A827FuLL) >> 0),
    (VUINT32) ((0x3E897756562A827FuLL) >> 32)},
   {(VUINT32) ((0x3FD065B900000000uLL) >> 0),
    (VUINT32) ((0x3FD065B900000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F42D1CECD3768uLL) >> 0),
    (VUINT32) ((0x3E7F42D1CECD3768uLL) >> 32)},
   {(VUINT32) ((0x3FD0790A00000000uLL) >> 0),
    (VUINT32) ((0x3FD0790A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8BB6060195A070uLL) >> 0),
    (VUINT32) ((0x3E8BB6060195A070uLL) >> 32)},
   {(VUINT32) ((0x3FD08C5900000000uLL) >> 0),
    (VUINT32) ((0x3FD08C5900000000uLL) >> 32)},
   {(VUINT32) ((0x3E5C5A7B3A2BD335uLL) >> 0),
    (VUINT32) ((0x3E5C5A7B3A2BD335uLL) >> 32)},
   {(VUINT32) ((0x3FD09FA100000000uLL) >> 0),
    (VUINT32) ((0x3FD09FA100000000uLL) >> 32)},
   {(VUINT32) ((0x3E8A2743F6A4CD20uLL) >> 0),
    (VUINT32) ((0x3E8A2743F6A4CD20uLL) >> 32)},
   {(VUINT32) ((0x3FD0B2E700000000uLL) >> 0),
    (VUINT32) ((0x3FD0B2E700000000uLL) >> 32)},
   {(VUINT32) ((0x3E775F83F99025B0uLL) >> 0),
    (VUINT32) ((0x3E775F83F99025B0uLL) >> 32)},
   {(VUINT32) ((0x3FD0C62900000000uLL) >> 0),
    (VUINT32) ((0x3FD0C62900000000uLL) >> 32)},
   {(VUINT32) ((0x3E87CA856421A674uLL) >> 0),
    (VUINT32) ((0x3E87CA856421A674uLL) >> 32)},
   {(VUINT32) ((0x3FD0D96600000000uLL) >> 0),
    (VUINT32) ((0x3FD0D96600000000uLL) >> 32)},
   {(VUINT32) ((0x3E814D2830EF12FDuLL) >> 0),
    (VUINT32) ((0x3E814D2830EF12FDuLL) >> 32)},
   {(VUINT32) ((0x3FD0ECA000000000uLL) >> 0),
    (VUINT32) ((0x3FD0ECA000000000uLL) >> 32)},
   {(VUINT32) ((0x3E62348ECA90F220uLL) >> 0),
    (VUINT32) ((0x3E62348ECA90F220uLL) >> 32)},
   {(VUINT32) ((0x3FD0FFD600000000uLL) >> 0),
    (VUINT32) ((0x3FD0FFD600000000uLL) >> 32)},
   {(VUINT32) ((0x3E812FCF75D18B23uLL) >> 0),
    (VUINT32) ((0x3E812FCF75D18B23uLL) >> 32)},
   {(VUINT32) ((0x3FD1130700000000uLL) >> 0),
    (VUINT32) ((0x3FD1130700000000uLL) >> 32)},
   {(VUINT32) ((0x3E73B4C2BF9F9DD3uLL) >> 0),
    (VUINT32) ((0x3E73B4C2BF9F9DD3uLL) >> 32)},
   {(VUINT32) ((0x3FD1263600000000uLL) >> 0),
    (VUINT32) ((0x3FD1263600000000uLL) >> 32)},
   {(VUINT32) ((0x3E499EF30070A508uLL) >> 0),
    (VUINT32) ((0x3E499EF30070A508uLL) >> 32)},
   {(VUINT32) ((0x3FD1395F00000000uLL) >> 0),
    (VUINT32) ((0x3FD1395F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E61EDB0D9E8DA9BuLL) >> 0),
    (VUINT32) ((0x3E61EDB0D9E8DA9BuLL) >> 32)},
   {(VUINT32) ((0x3FD14C8400000000uLL) >> 0),
    (VUINT32) ((0x3FD14C8400000000uLL) >> 32)},
   {(VUINT32) ((0x3E8F23AC3152C264uLL) >> 0),
    (VUINT32) ((0x3E8F23AC3152C264uLL) >> 32)},
   {(VUINT32) ((0x3FD15FA600000000uLL) >> 0),
    (VUINT32) ((0x3FD15FA600000000uLL) >> 32)},
   {(VUINT32) ((0x3E752EC233B712ADuLL) >> 0),
    (VUINT32) ((0x3E752EC233B712ADuLL) >> 32)},
   {(VUINT32) ((0x3FD172C400000000uLL) >> 0),
    (VUINT32) ((0x3FD172C400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7A163986A7B84CuLL) >> 0),
    (VUINT32) ((0x3E7A163986A7B84CuLL) >> 32)},
   {(VUINT32) ((0x3FD185DD00000000uLL) >> 0),
    (VUINT32) ((0x3FD185DD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8F734FDA450672uLL) >> 0),
    (VUINT32) ((0x3E8F734FDA450672uLL) >> 32)},
   {(VUINT32) ((0x3FD198F400000000uLL) >> 0),
    (VUINT32) ((0x3FD198F400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7028962C15F52BuLL) >> 0),
    (VUINT32) ((0x3E7028962C15F52BuLL) >> 32)},
   {(VUINT32) ((0x3FD1AC0500000000uLL) >> 0),
    (VUINT32) ((0x3FD1AC0500000000uLL) >> 32)},
   {(VUINT32) ((0x3E8FD23E213F6416uLL) >> 0),
    (VUINT32) ((0x3E8FD23E213F6416uLL) >> 32)},
   {(VUINT32) ((0x3FD1BF1300000000uLL) >> 0),
    (VUINT32) ((0x3FD1BF1300000000uLL) >> 32)},
   {(VUINT32) ((0x3E68E4E3166C3339uLL) >> 0),
    (VUINT32) ((0x3E68E4E3166C3339uLL) >> 32)},
   {(VUINT32) ((0x3FD1D21E00000000uLL) >> 0),
    (VUINT32) ((0x3FD1D21E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E70EA55E7DA3FECuLL) >> 0),
    (VUINT32) ((0x3E70EA55E7DA3FECuLL) >> 32)},
   {(VUINT32) ((0x3FD1E52300000000uLL) >> 0),
    (VUINT32) ((0x3FD1E52300000000uLL) >> 32)},
   {(VUINT32) ((0x3E81B9E3403DF05DuLL) >> 0),
    (VUINT32) ((0x3E81B9E3403DF05DuLL) >> 32)},
   {(VUINT32) ((0x3FD1F82500000000uLL) >> 0),
    (VUINT32) ((0x3FD1F82500000000uLL) >> 32)},
   {(VUINT32) ((0x3E7E762367A00F4AuLL) >> 0),
    (VUINT32) ((0x3E7E762367A00F4AuLL) >> 32)},
   {(VUINT32) ((0x3FD20B2400000000uLL) >> 0),
    (VUINT32) ((0x3FD20B2400000000uLL) >> 32)},
   {(VUINT32) ((0x3E3388B4DD9D8704uLL) >> 0),
    (VUINT32) ((0x3E3388B4DD9D8704uLL) >> 32)},
   {(VUINT32) ((0x3FD21E1F00000000uLL) >> 0),
    (VUINT32) ((0x3FD21E1F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6603BBC7B763E4uLL) >> 0),
    (VUINT32) ((0x3E6603BBC7B763E4uLL) >> 32)},
   {(VUINT32) ((0x3FD2311400000000uLL) >> 0),
    (VUINT32) ((0x3FD2311400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F38B9F767E1C9uLL) >> 0),
    (VUINT32) ((0x3E7F38B9F767E1C9uLL) >> 32)},
   {(VUINT32) ((0x3FD2440700000000uLL) >> 0),
    (VUINT32) ((0x3FD2440700000000uLL) >> 32)},
   {(VUINT32) ((0x3E8361C0E424306BuLL) >> 0),
    (VUINT32) ((0x3E8361C0E424306BuLL) >> 32)},
   {(VUINT32) ((0x3FD256F600000000uLL) >> 0),
    (VUINT32) ((0x3FD256F600000000uLL) >> 32)},
   {(VUINT32) ((0x3E53E15A0763E5F5uLL) >> 0),
    (VUINT32) ((0x3E53E15A0763E5F5uLL) >> 32)},
   {(VUINT32) ((0x3FD269E100000000uLL) >> 0),
    (VUINT32) ((0x3FD269E100000000uLL) >> 32)},
   {(VUINT32) ((0x3E5C346E0F5542ABuLL) >> 0),
    (VUINT32) ((0x3E5C346E0F5542ABuLL) >> 32)},
   {(VUINT32) ((0x3FD27CC800000000uLL) >> 0),
    (VUINT32) ((0x3FD27CC800000000uLL) >> 32)},
   {(VUINT32) ((0x3E8623BAC0F6E8E5uLL) >> 0),
    (VUINT32) ((0x3E8623BAC0F6E8E5uLL) >> 32)},
   {(VUINT32) ((0x3FD28FAB00000000uLL) >> 0),
    (VUINT32) ((0x3FD28FAB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E82D664EA511964uLL) >> 0),
    (VUINT32) ((0x3E82D664EA511964uLL) >> 32)},
   {(VUINT32) ((0x3FD2A28B00000000uLL) >> 0),
    (VUINT32) ((0x3FD2A28B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E244827751649E1uLL) >> 0),
    (VUINT32) ((0x3E244827751649E1uLL) >> 32)},
   {(VUINT32) ((0x3FD2B56500000000uLL) >> 0),
    (VUINT32) ((0x3FD2B56500000000uLL) >> 32)},
   {(VUINT32) ((0x3E870662732A8325uLL) >> 0),
    (VUINT32) ((0x3E870662732A8325uLL) >> 32)},
   {(VUINT32) ((0x3FD2C83C00000000uLL) >> 0),
    (VUINT32) ((0x3FD2C83C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8DB880F0396C05uLL) >> 0),
    (VUINT32) ((0x3E8DB880F0396C05uLL) >> 32)},
   {(VUINT32) ((0x3FD2DB1000000000uLL) >> 0),
    (VUINT32) ((0x3FD2DB1000000000uLL) >> 32)},
   {(VUINT32) ((0x3E8409B34923F5D0uLL) >> 0),
    (VUINT32) ((0x3E8409B34923F5D0uLL) >> 32)},
   {(VUINT32) ((0x3FD2EDE000000000uLL) >> 0),
    (VUINT32) ((0x3FD2EDE000000000uLL) >> 32)},
   {(VUINT32) ((0x3E899C121E8496E6uLL) >> 0),
    (VUINT32) ((0x3E899C121E8496E6uLL) >> 32)},
   {(VUINT32) ((0x3FD300AD00000000uLL) >> 0),
    (VUINT32) ((0x3FD300AD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C232F22D20F20uLL) >> 0),
    (VUINT32) ((0x3E7C232F22D20F20uLL) >> 32)},
   {(VUINT32) ((0x3FD3137500000000uLL) >> 0),
    (VUINT32) ((0x3FD3137500000000uLL) >> 32)},
   {(VUINT32) ((0x3E73683D6C58CA0DuLL) >> 0),
    (VUINT32) ((0x3E73683D6C58CA0DuLL) >> 32)},
   {(VUINT32) ((0x3FD3263900000000uLL) >> 0),
    (VUINT32) ((0x3FD3263900000000uLL) >> 32)},
   {(VUINT32) ((0x3E836D65141862CFuLL) >> 0),
    (VUINT32) ((0x3E836D65141862CFuLL) >> 32)},
   {(VUINT32) ((0x3FD338FA00000000uLL) >> 0),
    (VUINT32) ((0x3FD338FA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E75BE12EFC2F601uLL) >> 0),
    (VUINT32) ((0x3E75BE12EFC2F601uLL) >> 32)},
   {(VUINT32) ((0x3FD34BB600000000uLL) >> 0),
    (VUINT32) ((0x3FD34BB600000000uLL) >> 32)},
   {(VUINT32) ((0x3E70751869F3B7A6uLL) >> 0),
    (VUINT32) ((0x3E70751869F3B7A6uLL) >> 32)},
   {(VUINT32) ((0x3FD35E6F00000000uLL) >> 0),
    (VUINT32) ((0x3FD35E6F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E89F95043BBFC91uLL) >> 0),
    (VUINT32) ((0x3E89F95043BBFC91uLL) >> 32)},
   {(VUINT32) ((0x3FD3712400000000uLL) >> 0),
    (VUINT32) ((0x3FD3712400000000uLL) >> 32)},
   {(VUINT32) ((0x3E80D499B29F7615uLL) >> 0),
    (VUINT32) ((0x3E80D499B29F7615uLL) >> 32)},
   {(VUINT32) ((0x3FD383D500000000uLL) >> 0),
    (VUINT32) ((0x3FD383D500000000uLL) >> 32)},
   {(VUINT32) ((0x3E83DD8F4DE52902uLL) >> 0),
    (VUINT32) ((0x3E83DD8F4DE52902uLL) >> 32)},
   {(VUINT32) ((0x3FD3968400000000uLL) >> 0),
    (VUINT32) ((0x3FD3968400000000uLL) >> 32)},
   {(VUINT32) ((0x3E748A73FA7E46E2uLL) >> 0),
    (VUINT32) ((0x3E748A73FA7E46E2uLL) >> 32)},
   {(VUINT32) ((0x3FD3A92E00000000uLL) >> 0),
    (VUINT32) ((0x3FD3A92E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6252112C0E2155uLL) >> 0),
    (VUINT32) ((0x3E6252112C0E2155uLL) >> 32)},
   {(VUINT32) ((0x3FD3BBD300000000uLL) >> 0),
    (VUINT32) ((0x3FD3BBD300000000uLL) >> 32)},
   {(VUINT32) ((0x3E52A1DC831E5AD7uLL) >> 0),
    (VUINT32) ((0x3E52A1DC831E5AD7uLL) >> 32)},
   {(VUINT32) ((0x3FD3CE7500000000uLL) >> 0),
    (VUINT32) ((0x3FD3CE7500000000uLL) >> 32)},
   {(VUINT32) ((0x3E825D1013E78284uLL) >> 0),
    (VUINT32) ((0x3E825D1013E78284uLL) >> 32)},
   {(VUINT32) ((0x3FD3E11400000000uLL) >> 0),
    (VUINT32) ((0x3FD3E11400000000uLL) >> 32)},
   {(VUINT32) ((0x3E796F27F8ED6AB1uLL) >> 0),
    (VUINT32) ((0x3E796F27F8ED6AB1uLL) >> 32)},
   {(VUINT32) ((0x3FD3F3AF00000000uLL) >> 0),
    (VUINT32) ((0x3FD3F3AF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E81043C4E106F6AuLL) >> 0),
    (VUINT32) ((0x3E81043C4E106F6AuLL) >> 32)},
   {(VUINT32) ((0x3FD4064500000000uLL) >> 0),
    (VUINT32) ((0x3FD4064500000000uLL) >> 32)},
   {(VUINT32) ((0x3E8723607A748D45uLL) >> 0),
    (VUINT32) ((0x3E8723607A748D45uLL) >> 32)},
   {(VUINT32) ((0x3FD418D900000000uLL) >> 0),
    (VUINT32) ((0x3FD418D900000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C5A76F3C6B991uLL) >> 0),
    (VUINT32) ((0x3E7C5A76F3C6B991uLL) >> 32)},
   {(VUINT32) ((0x3FD42B6900000000uLL) >> 0),
    (VUINT32) ((0x3FD42B6900000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C13D54B6EDE12uLL) >> 0),
    (VUINT32) ((0x3E7C13D54B6EDE12uLL) >> 32)},
   {(VUINT32) ((0x3FD43DF400000000uLL) >> 0),
    (VUINT32) ((0x3FD43DF400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7D02DC433313AEuLL) >> 0),
    (VUINT32) ((0x3E7D02DC433313AEuLL) >> 32)},
   {(VUINT32) ((0x3FD4507C00000000uLL) >> 0),
    (VUINT32) ((0x3FD4507C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8EDBA9F6E1776CuLL) >> 0),
    (VUINT32) ((0x3E8EDBA9F6E1776CuLL) >> 32)},
   {(VUINT32) ((0x3FD4630100000000uLL) >> 0),
    (VUINT32) ((0x3FD4630100000000uLL) >> 32)},
   {(VUINT32) ((0x3E86E864BF1D1AAAuLL) >> 0),
    (VUINT32) ((0x3E86E864BF1D1AAAuLL) >> 32)},
   {(VUINT32) ((0x3FD4758100000000uLL) >> 0),
    (VUINT32) ((0x3FD4758100000000uLL) >> 32)},
   {(VUINT32) ((0x3E7CAE90765ABC31uLL) >> 0),
    (VUINT32) ((0x3E7CAE90765ABC31uLL) >> 32)},
   {(VUINT32) ((0x3FD487FE00000000uLL) >> 0),
    (VUINT32) ((0x3FD487FE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E849FE23646E5A5uLL) >> 0),
    (VUINT32) ((0x3E849FE23646E5A5uLL) >> 32)},
   {(VUINT32) ((0x3FD49A7800000000uLL) >> 0),
    (VUINT32) ((0x3FD49A7800000000uLL) >> 32)},
   {(VUINT32) ((0x3E479A36743BE41DuLL) >> 0),
    (VUINT32) ((0x3E479A36743BE41DuLL) >> 32)},
   {(VUINT32) ((0x3FD4ACED00000000uLL) >> 0),
    (VUINT32) ((0x3FD4ACED00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8483E03299B840uLL) >> 0),
    (VUINT32) ((0x3E8483E03299B840uLL) >> 32)},
   {(VUINT32) ((0x3FD4BF5F00000000uLL) >> 0),
    (VUINT32) ((0x3FD4BF5F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7ABBA144C6B22BuLL) >> 0),
    (VUINT32) ((0x3E7ABBA144C6B22BuLL) >> 32)},
   {(VUINT32) ((0x3FD4D1CD00000000uLL) >> 0),
    (VUINT32) ((0x3FD4D1CD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E774D20FDD9F23BuLL) >> 0),
    (VUINT32) ((0x3E774D20FDD9F23BuLL) >> 32)},
   {(VUINT32) ((0x3FD4E43800000000uLL) >> 0),
    (VUINT32) ((0x3FD4E43800000000uLL) >> 32)},
   {(VUINT32) ((0x3E871D1F7AA47E01uLL) >> 0),
    (VUINT32) ((0x3E871D1F7AA47E01uLL) >> 32)},
   {(VUINT32) ((0x3FD4F69E00000000uLL) >> 0),
    (VUINT32) ((0x3FD4F69E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8F2860BA3B3DB5uLL) >> 0),
    (VUINT32) ((0x3E8F2860BA3B3DB5uLL) >> 32)},
   {(VUINT32) ((0x3FD5090200000000uLL) >> 0),
    (VUINT32) ((0x3FD5090200000000uLL) >> 32)},
   {(VUINT32) ((0x3E83AF1C17099BFEuLL) >> 0),
    (VUINT32) ((0x3E83AF1C17099BFEuLL) >> 32)},
   {(VUINT32) ((0x3FD51B6200000000uLL) >> 0),
    (VUINT32) ((0x3FD51B6200000000uLL) >> 32)},
   {(VUINT32) ((0x3E785FF9DE74A1B4uLL) >> 0),
    (VUINT32) ((0x3E785FF9DE74A1B4uLL) >> 32)},
   {(VUINT32) ((0x3FD52DBE00000000uLL) >> 0),
    (VUINT32) ((0x3FD52DBE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E709325CFAFA80FuLL) >> 0),
    (VUINT32) ((0x3E709325CFAFA80FuLL) >> 32)},
   {(VUINT32) ((0x3FD5401600000000uLL) >> 0),
    (VUINT32) ((0x3FD5401600000000uLL) >> 32)},
   {(VUINT32) ((0x3E6E6947CCF73D7AuLL) >> 0),
    (VUINT32) ((0x3E6E6947CCF73D7AuLL) >> 32)},
   {(VUINT32) ((0x3FD5526A00000000uLL) >> 0),
    (VUINT32) ((0x3FD5526A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E738124D5DB9AD7uLL) >> 0),
    (VUINT32) ((0x3E738124D5DB9AD7uLL) >> 32)},
   {(VUINT32) ((0x3FD564BB00000000uLL) >> 0),
    (VUINT32) ((0x3FD564BB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E86B2911C62B3A2uLL) >> 0),
    (VUINT32) ((0x3E86B2911C62B3A2uLL) >> 32)},
   {(VUINT32) ((0x3FD5770900000000uLL) >> 0),
    (VUINT32) ((0x3FD5770900000000uLL) >> 32)},
   {(VUINT32) ((0x3E6719BC759EE891uLL) >> 0),
    (VUINT32) ((0x3E6719BC759EE891uLL) >> 32)},
   {(VUINT32) ((0x3FD5895200000000uLL) >> 0),
    (VUINT32) ((0x3FD5895200000000uLL) >> 32)},
   {(VUINT32) ((0x3E869A322D9370BCuLL) >> 0),
    (VUINT32) ((0x3E869A322D9370BCuLL) >> 32)},
   {(VUINT32) ((0x3FD59B9800000000uLL) >> 0),
    (VUINT32) ((0x3FD59B9800000000uLL) >> 32)},
   {(VUINT32) ((0x3E719789A94340E2uLL) >> 0),
    (VUINT32) ((0x3E719789A94340E2uLL) >> 32)},
   {(VUINT32) ((0x3FD5ADDB00000000uLL) >> 0),
    (VUINT32) ((0x3FD5ADDB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E61C3D9786A1C1AuLL) >> 0),
    (VUINT32) ((0x3E61C3D9786A1C1AuLL) >> 32)},
   {(VUINT32) ((0x3FD5C01A00000000uLL) >> 0),
    (VUINT32) ((0x3FD5C01A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E37EF590A213419uLL) >> 0),
    (VUINT32) ((0x3E37EF590A213419uLL) >> 32)},
   {(VUINT32) ((0x3FD5D25400000000uLL) >> 0),
    (VUINT32) ((0x3FD5D25400000000uLL) >> 32)},
   {(VUINT32) ((0x3E8D54EB1103130FuLL) >> 0),
    (VUINT32) ((0x3E8D54EB1103130FuLL) >> 32)},
   {(VUINT32) ((0x3FD5E48D00000000uLL) >> 0),
    (VUINT32) ((0x3FD5E48D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E52F62A9CC12FD0uLL) >> 0),
    (VUINT32) ((0x3E52F62A9CC12FD0uLL) >> 32)},
   {(VUINT32) ((0x3FD5F6C100000000uLL) >> 0),
    (VUINT32) ((0x3FD5F6C100000000uLL) >> 32)},
   {(VUINT32) ((0x3E6BE9B244784641uLL) >> 0),
    (VUINT32) ((0x3E6BE9B244784641uLL) >> 32)},
   {(VUINT32) ((0x3FD608F100000000uLL) >> 0),
    (VUINT32) ((0x3FD608F100000000uLL) >> 32)},
   {(VUINT32) ((0x3E758A521184B277uLL) >> 0),
    (VUINT32) ((0x3E758A521184B277uLL) >> 32)},
   {(VUINT32) ((0x3FD61B1E00000000uLL) >> 0),
    (VUINT32) ((0x3FD61B1E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E86042873323471uLL) >> 0),
    (VUINT32) ((0x3E86042873323471uLL) >> 32)},
   {(VUINT32) ((0x3FD62D4700000000uLL) >> 0),
    (VUINT32) ((0x3FD62D4700000000uLL) >> 32)},
   {(VUINT32) ((0x3E8FBC7D80B47BCFuLL) >> 0),
    (VUINT32) ((0x3E8FBC7D80B47BCFuLL) >> 32)},
   {(VUINT32) ((0x3FD63F6D00000000uLL) >> 0),
    (VUINT32) ((0x3FD63F6D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6E2C82077EA756uLL) >> 0),
    (VUINT32) ((0x3E6E2C82077EA756uLL) >> 32)},
   {(VUINT32) ((0x3FD6518F00000000uLL) >> 0),
    (VUINT32) ((0x3FD6518F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E85CCEF6BF767F4uLL) >> 0),
    (VUINT32) ((0x3E85CCEF6BF767F4uLL) >> 32)},
   {(VUINT32) ((0x3FD663AE00000000uLL) >> 0),
    (VUINT32) ((0x3FD663AE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E46EAD81DF81E8FuLL) >> 0),
    (VUINT32) ((0x3E46EAD81DF81E8FuLL) >> 32)},
   {(VUINT32) ((0x3FD675C900000000uLL) >> 0),
    (VUINT32) ((0x3FD675C900000000uLL) >> 32)},
   {(VUINT32) ((0x3E82DD03F10CD685uLL) >> 0),
    (VUINT32) ((0x3E82DD03F10CD685uLL) >> 32)},
   {(VUINT32) ((0x3FD687E100000000uLL) >> 0),
    (VUINT32) ((0x3FD687E100000000uLL) >> 32)},
   {(VUINT32) ((0x3E3E902C6DBC1F0CuLL) >> 0),
    (VUINT32) ((0x3E3E902C6DBC1F0CuLL) >> 32)},
   {(VUINT32) ((0x3FD699F500000000uLL) >> 0),
    (VUINT32) ((0x3FD699F500000000uLL) >> 32)},
   {(VUINT32) ((0x3E84319ABAC9C4B2uLL) >> 0),
    (VUINT32) ((0x3E84319ABAC9C4B2uLL) >> 32)},
   {(VUINT32) ((0x3FD6AC0600000000uLL) >> 0),
    (VUINT32) ((0x3FD6AC0600000000uLL) >> 32)},
   {(VUINT32) ((0x3E5B055166C24B15uLL) >> 0),
    (VUINT32) ((0x3E5B055166C24B15uLL) >> 32)},
   {(VUINT32) ((0x3FD6BE1200000000uLL) >> 0),
    (VUINT32) ((0x3FD6BE1200000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C3BE07B4F7882uLL) >> 0),
    (VUINT32) ((0x3E7C3BE07B4F7882uLL) >> 32)},
   {(VUINT32) ((0x3FD6D01B00000000uLL) >> 0),
    (VUINT32) ((0x3FD6D01B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8CFD93DD847E5DuLL) >> 0),
    (VUINT32) ((0x3E8CFD93DD847E5DuLL) >> 32)},
   {(VUINT32) ((0x3FD6E22100000000uLL) >> 0),
    (VUINT32) ((0x3FD6E22100000000uLL) >> 32)},
   {(VUINT32) ((0x3E6ACE863358E8D7uLL) >> 0),
    (VUINT32) ((0x3E6ACE863358E8D7uLL) >> 32)},
   {(VUINT32) ((0x3FD6F42300000000uLL) >> 0),
    (VUINT32) ((0x3FD6F42300000000uLL) >> 32)},
   {(VUINT32) ((0x3E83E40C6242BFE9uLL) >> 0),
    (VUINT32) ((0x3E83E40C6242BFE9uLL) >> 32)},
   {(VUINT32) ((0x3FD7062300000000uLL) >> 0),
    (VUINT32) ((0x3FD7062300000000uLL) >> 32)},
   {(VUINT32) ((0x3E610AB6A8479B5DuLL) >> 0),
    (VUINT32) ((0x3E610AB6A8479B5DuLL) >> 32)},
   {(VUINT32) ((0x3FD7181E00000000uLL) >> 0),
    (VUINT32) ((0x3FD7181E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7CD689BCFD9CF6uLL) >> 0),
    (VUINT32) ((0x3E7CD689BCFD9CF6uLL) >> 32)},
   {(VUINT32) ((0x3FD72A1600000000uLL) >> 0),
    (VUINT32) ((0x3FD72A1600000000uLL) >> 32)},
   {(VUINT32) ((0x3E8B1978624662CCuLL) >> 0),
    (VUINT32) ((0x3E8B1978624662CCuLL) >> 32)},
   {(VUINT32) ((0x3FD73C0B00000000uLL) >> 0),
    (VUINT32) ((0x3FD73C0B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E3B1A8D9A80C213uLL) >> 0),
    (VUINT32) ((0x3E3B1A8D9A80C213uLL) >> 32)},
   {(VUINT32) ((0x3FD74DFA00000000uLL) >> 0),
    (VUINT32) ((0x3FD74DFA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8F44CC629FADC5uLL) >> 0),
    (VUINT32) ((0x3E8F44CC629FADC5uLL) >> 32)},
   {(VUINT32) ((0x3FD75FE900000000uLL) >> 0),
    (VUINT32) ((0x3FD75FE900000000uLL) >> 32)},
   {(VUINT32) ((0x3E70D17562376005uLL) >> 0),
    (VUINT32) ((0x3E70D17562376005uLL) >> 32)},
   {(VUINT32) ((0x3FD771D300000000uLL) >> 0),
    (VUINT32) ((0x3FD771D300000000uLL) >> 32)},
   {(VUINT32) ((0x3E731FBF269B0088uLL) >> 0),
    (VUINT32) ((0x3E731FBF269B0088uLL) >> 32)},
   {(VUINT32) ((0x3FD783B900000000uLL) >> 0),
    (VUINT32) ((0x3FD783B900000000uLL) >> 32)},
   {(VUINT32) ((0x3E52AB13F0273736uLL) >> 0),
    (VUINT32) ((0x3E52AB13F0273736uLL) >> 32)},
   {(VUINT32) ((0x3FD7959B00000000uLL) >> 0),
    (VUINT32) ((0x3FD7959B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8BA45253B127D6uLL) >> 0),
    (VUINT32) ((0x3E8BA45253B127D6uLL) >> 32)},
   {(VUINT32) ((0x3FD7A77B00000000uLL) >> 0),
    (VUINT32) ((0x3FD7A77B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E852FA4783A4DFDuLL) >> 0),
    (VUINT32) ((0x3E852FA4783A4DFDuLL) >> 32)},
   {(VUINT32) ((0x3FD7B95700000000uLL) >> 0),
    (VUINT32) ((0x3FD7B95700000000uLL) >> 32)},
   {(VUINT32) ((0x3E6528D527430D54uLL) >> 0),
    (VUINT32) ((0x3E6528D527430D54uLL) >> 32)},
   {(VUINT32) ((0x3FD7CB2F00000000uLL) >> 0),
    (VUINT32) ((0x3FD7CB2F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E84F6C8A8C54418uLL) >> 0),
    (VUINT32) ((0x3E84F6C8A8C54418uLL) >> 32)},
   {(VUINT32) ((0x3FD7DD0500000000uLL) >> 0),
    (VUINT32) ((0x3FD7DD0500000000uLL) >> 32)},
   {(VUINT32) ((0x3E5F404BA538C133uLL) >> 0),
    (VUINT32) ((0x3E5F404BA538C133uLL) >> 32)},
   {(VUINT32) ((0x3FD7EED700000000uLL) >> 0),
    (VUINT32) ((0x3FD7EED700000000uLL) >> 32)},
   {(VUINT32) ((0x3E81D08A084632F9uLL) >> 0),
    (VUINT32) ((0x3E81D08A084632F9uLL) >> 32)},
   {(VUINT32) ((0x3FD800A500000000uLL) >> 0),
    (VUINT32) ((0x3FD800A500000000uLL) >> 32)},
   {(VUINT32) ((0x3E84E2C39B578D96uLL) >> 0),
    (VUINT32) ((0x3E84E2C39B578D96uLL) >> 32)},
   {(VUINT32) ((0x3FD8127000000000uLL) >> 0),
    (VUINT32) ((0x3FD8127000000000uLL) >> 32)},
   {(VUINT32) ((0x3E8641178F2C2B02uLL) >> 0),
    (VUINT32) ((0x3E8641178F2C2B02uLL) >> 32)},
   {(VUINT32) ((0x3FD8243700000000uLL) >> 0),
    (VUINT32) ((0x3FD8243700000000uLL) >> 32)},
   {(VUINT32) ((0x3E781B9C28EE919EuLL) >> 0),
    (VUINT32) ((0x3E781B9C28EE919EuLL) >> 32)},
   {(VUINT32) ((0x3FD835FA00000000uLL) >> 0),
    (VUINT32) ((0x3FD835FA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8F7B17B6D5775CuLL) >> 0),
    (VUINT32) ((0x3E8F7B17B6D5775CuLL) >> 32)},
   {(VUINT32) ((0x3FD847BC00000000uLL) >> 0),
    (VUINT32) ((0x3FD847BC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E89DB0C612F1B2EuLL) >> 0),
    (VUINT32) ((0x3E89DB0C612F1B2EuLL) >> 32)},
   {(VUINT32) ((0x3FD8597800000000uLL) >> 0),
    (VUINT32) ((0x3FD8597800000000uLL) >> 32)},
   {(VUINT32) ((0x3E8DFFAAE2CBAD0FuLL) >> 0),
    (VUINT32) ((0x3E8DFFAAE2CBAD0FuLL) >> 32)},
   {(VUINT32) ((0x3FD86B3300000000uLL) >> 0),
    (VUINT32) ((0x3FD86B3300000000uLL) >> 32)},
   {(VUINT32) ((0x3E70F5B6D0513247uLL) >> 0),
    (VUINT32) ((0x3E70F5B6D0513247uLL) >> 32)},
   {(VUINT32) ((0x3FD87CE900000000uLL) >> 0),
    (VUINT32) ((0x3FD87CE900000000uLL) >> 32)},
   {(VUINT32) ((0x3E6699B2D0C42CCAuLL) >> 0),
    (VUINT32) ((0x3E6699B2D0C42CCAuLL) >> 32)},
   {(VUINT32) ((0x3FD88E9B00000000uLL) >> 0),
    (VUINT32) ((0x3FD88E9B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8EDC16362782B3uLL) >> 0),
    (VUINT32) ((0x3E8EDC16362782B3uLL) >> 32)},
   {(VUINT32) ((0x3FD8A04B00000000uLL) >> 0),
    (VUINT32) ((0x3FD8A04B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E83CD771D49FB4BuLL) >> 0),
    (VUINT32) ((0x3E83CD771D49FB4BuLL) >> 32)},
   {(VUINT32) ((0x3FD8B1F800000000uLL) >> 0),
    (VUINT32) ((0x3FD8B1F800000000uLL) >> 32)},
   {(VUINT32) ((0x3E60B05B11747E4CuLL) >> 0),
    (VUINT32) ((0x3E60B05B11747E4CuLL) >> 32)},
   {(VUINT32) ((0x3FD8C3A100000000uLL) >> 0),
    (VUINT32) ((0x3FD8C3A100000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F52C9816DB2C1uLL) >> 0),
    (VUINT32) ((0x3E7F52C9816DB2C1uLL) >> 32)},
   {(VUINT32) ((0x3FD8D54600000000uLL) >> 0),
    (VUINT32) ((0x3FD8D54600000000uLL) >> 32)},
   {(VUINT32) ((0x3E782D70D541D6C1uLL) >> 0),
    (VUINT32) ((0x3E782D70D541D6C1uLL) >> 32)},
   {(VUINT32) ((0x3FD8E6E800000000uLL) >> 0),
    (VUINT32) ((0x3FD8E6E800000000uLL) >> 32)},
   {(VUINT32) ((0x3E57AA91CC153DDEuLL) >> 0),
    (VUINT32) ((0x3E57AA91CC153DDEuLL) >> 32)},
   {(VUINT32) ((0x3FD8F88600000000uLL) >> 0),
    (VUINT32) ((0x3FD8F88600000000uLL) >> 32)},
   {(VUINT32) ((0x3E83F65A8E01AFFCuLL) >> 0),
    (VUINT32) ((0x3E83F65A8E01AFFCuLL) >> 32)},
   {(VUINT32) ((0x3FD90A2100000000uLL) >> 0),
    (VUINT32) ((0x3FD90A2100000000uLL) >> 32)},
   {(VUINT32) ((0x3E8ECAE2475966DFuLL) >> 0),
    (VUINT32) ((0x3E8ECAE2475966DFuLL) >> 32)},
   {(VUINT32) ((0x3FD91BBA00000000uLL) >> 0),
    (VUINT32) ((0x3FD91BBA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E591F169848D269uLL) >> 0),
    (VUINT32) ((0x3E591F169848D269uLL) >> 32)},
   {(VUINT32) ((0x3FD92D4F00000000uLL) >> 0),
    (VUINT32) ((0x3FD92D4F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E3647C7943A8D23uLL) >> 0),
    (VUINT32) ((0x3E3647C7943A8D23uLL) >> 32)},
   {(VUINT32) ((0x3FD93EE000000000uLL) >> 0),
    (VUINT32) ((0x3FD93EE000000000uLL) >> 32)},
   {(VUINT32) ((0x3E8726BF3DB3E718uLL) >> 0),
    (VUINT32) ((0x3E8726BF3DB3E718uLL) >> 32)},
   {(VUINT32) ((0x3FD9506D00000000uLL) >> 0),
    (VUINT32) ((0x3FD9506D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8C1A18FAFA10D5uLL) >> 0),
    (VUINT32) ((0x3E8C1A18FAFA10D5uLL) >> 32)},
   {(VUINT32) ((0x3FD961F900000000uLL) >> 0),
    (VUINT32) ((0x3FD961F900000000uLL) >> 32)},
   {(VUINT32) ((0x3E5B2740C198F220uLL) >> 0),
    (VUINT32) ((0x3E5B2740C198F220uLL) >> 32)},
   {(VUINT32) ((0x3FD9737F00000000uLL) >> 0),
    (VUINT32) ((0x3FD9737F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E887FB1536242B8uLL) >> 0),
    (VUINT32) ((0x3E887FB1536242B8uLL) >> 32)},
   {(VUINT32) ((0x3FD9850400000000uLL) >> 0),
    (VUINT32) ((0x3FD9850400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7EC5C619B71F3EuLL) >> 0),
    (VUINT32) ((0x3E7EC5C619B71F3EuLL) >> 32)},
   {(VUINT32) ((0x3FD9968400000000uLL) >> 0),
    (VUINT32) ((0x3FD9968400000000uLL) >> 32)},
   {(VUINT32) ((0x3E8366D3EB0E5D24uLL) >> 0),
    (VUINT32) ((0x3E8366D3EB0E5D24uLL) >> 32)},
   {(VUINT32) ((0x3FD9A80200000000uLL) >> 0),
    (VUINT32) ((0x3FD9A80200000000uLL) >> 32)},
   {(VUINT32) ((0x3E88A3C48F5901ADuLL) >> 0),
    (VUINT32) ((0x3E88A3C48F5901ADuLL) >> 32)},
   {(VUINT32) ((0x3FD9B97C00000000uLL) >> 0),
    (VUINT32) ((0x3FD9B97C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E74A3BB2D70054BuLL) >> 0),
    (VUINT32) ((0x3E74A3BB2D70054BuLL) >> 32)},
   {(VUINT32) ((0x3FD9CAF200000000uLL) >> 0),
    (VUINT32) ((0x3FD9CAF200000000uLL) >> 32)},
   {(VUINT32) ((0x3E825931E77B3ED9uLL) >> 0),
    (VUINT32) ((0x3E825931E77B3ED9uLL) >> 32)},
   {(VUINT32) ((0x3FD9DC6600000000uLL) >> 0),
    (VUINT32) ((0x3FD9DC6600000000uLL) >> 32)},
   {(VUINT32) ((0x3E8AC1BD72BB6920uLL) >> 0),
    (VUINT32) ((0x3E8AC1BD72BB6920uLL) >> 32)},
   {(VUINT32) ((0x3FD9EDD600000000uLL) >> 0),
    (VUINT32) ((0x3FD9EDD600000000uLL) >> 32)},
   {(VUINT32) ((0x3E7D26C9777B80E6uLL) >> 0),
    (VUINT32) ((0x3E7D26C9777B80E6uLL) >> 32)},
   {(VUINT32) ((0x3FD9FF4200000000uLL) >> 0),
    (VUINT32) ((0x3FD9FF4200000000uLL) >> 32)},
   {(VUINT32) ((0x3E87CDF6B003FE44uLL) >> 0),
    (VUINT32) ((0x3E87CDF6B003FE44uLL) >> 32)},
   {(VUINT32) ((0x3FDA10AD00000000uLL) >> 0),
    (VUINT32) ((0x3FDA10AD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E32256C5F5257DAuLL) >> 0),
    (VUINT32) ((0x3E32256C5F5257DAuLL) >> 32)},
   {(VUINT32) ((0x3FDA221200000000uLL) >> 0),
    (VUINT32) ((0x3FDA221200000000uLL) >> 32)},
   {(VUINT32) ((0x3E83B4A3FF1466D0uLL) >> 0),
    (VUINT32) ((0x3E83B4A3FF1466D0uLL) >> 32)},
   {(VUINT32) ((0x3FDA337600000000uLL) >> 0),
    (VUINT32) ((0x3FDA337600000000uLL) >> 32)},
   {(VUINT32) ((0x3E673FB048CD2B2FuLL) >> 0),
    (VUINT32) ((0x3E673FB048CD2B2FuLL) >> 32)},
   {(VUINT32) ((0x3FDA44D600000000uLL) >> 0),
    (VUINT32) ((0x3FDA44D600000000uLL) >> 32)},
   {(VUINT32) ((0x3E7844F0A7DA3C13uLL) >> 0),
    (VUINT32) ((0x3E7844F0A7DA3C13uLL) >> 32)},
   {(VUINT32) ((0x3FDA563100000000uLL) >> 0),
    (VUINT32) ((0x3FDA563100000000uLL) >> 32)},
   {(VUINT32) ((0x3E8BCBA6DA5B37E1uLL) >> 0),
    (VUINT32) ((0x3E8BCBA6DA5B37E1uLL) >> 32)},
   {(VUINT32) ((0x3FDA678B00000000uLL) >> 0),
    (VUINT32) ((0x3FDA678B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7325816E447B2DuLL) >> 0),
    (VUINT32) ((0x3E7325816E447B2DuLL) >> 32)},
   {(VUINT32) ((0x3FDA78E100000000uLL) >> 0),
    (VUINT32) ((0x3FDA78E100000000uLL) >> 32)},
   {(VUINT32) ((0x3E753DEFC2FB5AA0uLL) >> 0),
    (VUINT32) ((0x3E753DEFC2FB5AA0uLL) >> 32)},
   {(VUINT32) ((0x3FDA8A3300000000uLL) >> 0),
    (VUINT32) ((0x3FDA8A3300000000uLL) >> 32)},
   {(VUINT32) ((0x3E8E9F688620242EuLL) >> 0),
    (VUINT32) ((0x3E8E9F688620242EuLL) >> 32)},
   {(VUINT32) ((0x3FDA9B8300000000uLL) >> 0),
    (VUINT32) ((0x3FDA9B8300000000uLL) >> 32)},
   {(VUINT32) ((0x3E650C63633BBEC2uLL) >> 0),
    (VUINT32) ((0x3E650C63633BBEC2uLL) >> 32)},
   {(VUINT32) ((0x3FDAACCE00000000uLL) >> 0),
    (VUINT32) ((0x3FDAACCE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8E38F926FACEDDuLL) >> 0),
    (VUINT32) ((0x3E8E38F926FACEDDuLL) >> 32)},
   {(VUINT32) ((0x3FDABE1800000000uLL) >> 0),
    (VUINT32) ((0x3FDABE1800000000uLL) >> 32)},
   {(VUINT32) ((0x3E83EFE3F1BC83EAuLL) >> 0),
    (VUINT32) ((0x3E83EFE3F1BC83EAuLL) >> 32)},
   {(VUINT32) ((0x3FDACF5D00000000uLL) >> 0),
    (VUINT32) ((0x3FDACF5D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E809E9D83CD28E8uLL) >> 0),
    (VUINT32) ((0x3E809E9D83CD28E8uLL) >> 32)},
   {(VUINT32) ((0x3FDAE0A000000000uLL) >> 0),
    (VUINT32) ((0x3FDAE0A000000000uLL) >> 32)},
   {(VUINT32) ((0x3E72F7A9FEEA5B2AuLL) >> 0),
    (VUINT32) ((0x3E72F7A9FEEA5B2AuLL) >> 32)},
   {(VUINT32) ((0x3FDAF1DF00000000uLL) >> 0),
    (VUINT32) ((0x3FDAF1DF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E83762377A3C900uLL) >> 0),
    (VUINT32) ((0x3E83762377A3C900uLL) >> 32)},
   {(VUINT32) ((0x3FDB031B00000000uLL) >> 0),
    (VUINT32) ((0x3FDB031B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C7818EFDE9C0AuLL) >> 0),
    (VUINT32) ((0x3E7C7818EFDE9C0AuLL) >> 32)},
   {(VUINT32) ((0x3FDB145500000000uLL) >> 0),
    (VUINT32) ((0x3FDB145500000000uLL) >> 32)},
   {(VUINT32) ((0x3E618FF8CE39A19EuLL) >> 0),
    (VUINT32) ((0x3E618FF8CE39A19EuLL) >> 32)},
   {(VUINT32) ((0x3FDB258900000000uLL) >> 0),
    (VUINT32) ((0x3FDB258900000000uLL) >> 32)},
   {(VUINT32) ((0x3E8FD450B400CDC5uLL) >> 0),
    (VUINT32) ((0x3E8FD450B400CDC5uLL) >> 32)},
   {(VUINT32) ((0x3FDB36BC00000000uLL) >> 0),
    (VUINT32) ((0x3FDB36BC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E861347926AA708uLL) >> 0),
    (VUINT32) ((0x3E861347926AA708uLL) >> 32)},
   {(VUINT32) ((0x3FDB47EB00000000uLL) >> 0),
    (VUINT32) ((0x3FDB47EB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8BE7104FA3A380uLL) >> 0),
    (VUINT32) ((0x3E8BE7104FA3A380uLL) >> 32)},
   {(VUINT32) ((0x3FDB591700000000uLL) >> 0),
    (VUINT32) ((0x3FDB591700000000uLL) >> 32)},
   {(VUINT32) ((0x3E80FDC35B90EE8DuLL) >> 0),
    (VUINT32) ((0x3E80FDC35B90EE8DuLL) >> 32)},
   {(VUINT32) ((0x3FDB6A4100000000uLL) >> 0),
    (VUINT32) ((0x3FDB6A4100000000uLL) >> 32)},
   {(VUINT32) ((0x3E056415269E9ADCuLL) >> 0),
    (VUINT32) ((0x3E056415269E9ADCuLL) >> 32)},
   {(VUINT32) ((0x3FDB7B6600000000uLL) >> 0),
    (VUINT32) ((0x3FDB7B6600000000uLL) >> 32)},
   {(VUINT32) ((0x3E8DDBE05932E271uLL) >> 0),
    (VUINT32) ((0x3E8DDBE05932E271uLL) >> 32)},
   {(VUINT32) ((0x3FDB8C8900000000uLL) >> 0),
    (VUINT32) ((0x3FDB8C8900000000uLL) >> 32)},
   {(VUINT32) ((0x3E73FE21DF4FEA38uLL) >> 0),
    (VUINT32) ((0x3E73FE21DF4FEA38uLL) >> 32)},
   {(VUINT32) ((0x3FDB9DA800000000uLL) >> 0),
    (VUINT32) ((0x3FDB9DA800000000uLL) >> 32)},
   {(VUINT32) ((0x3E60B2E6D80D2CE6uLL) >> 0),
    (VUINT32) ((0x3E60B2E6D80D2CE6uLL) >> 32)},
   {(VUINT32) ((0x3FDBAEC400000000uLL) >> 0),
    (VUINT32) ((0x3FDBAEC400000000uLL) >> 32)},
   {(VUINT32) ((0x3E874289E4E1D49CuLL) >> 0),
    (VUINT32) ((0x3E874289E4E1D49CuLL) >> 32)},
   {(VUINT32) ((0x3FDBBFDD00000000uLL) >> 0),
    (VUINT32) ((0x3FDBBFDD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E87CE1B050AA700uLL) >> 0),
    (VUINT32) ((0x3E87CE1B050AA700uLL) >> 32)},
   {(VUINT32) ((0x3FDBD0F300000000uLL) >> 0),
    (VUINT32) ((0x3FDBD0F300000000uLL) >> 32)},
   {(VUINT32) ((0x3E65F3C859448338uLL) >> 0),
    (VUINT32) ((0x3E65F3C859448338uLL) >> 32)},
   {(VUINT32) ((0x3FDBE20400000000uLL) >> 0),
    (VUINT32) ((0x3FDBE20400000000uLL) >> 32)},
   {(VUINT32) ((0x3E8FFC7F79678A39uLL) >> 0),
    (VUINT32) ((0x3E8FFC7F79678A39uLL) >> 32)},
   {(VUINT32) ((0x3FDBF31400000000uLL) >> 0),
    (VUINT32) ((0x3FDBF31400000000uLL) >> 32)},
   {(VUINT32) ((0x3E824A1EC9BE7496uLL) >> 0),
    (VUINT32) ((0x3E824A1EC9BE7496uLL) >> 32)},
   {(VUINT32) ((0x3FDC042100000000uLL) >> 0),
    (VUINT32) ((0x3FDC042100000000uLL) >> 32)},
   {(VUINT32) ((0x3E8C2B16EC00F182uLL) >> 0),
    (VUINT32) ((0x3E8C2B16EC00F182uLL) >> 32)},
   {(VUINT32) ((0x3FDC152A00000000uLL) >> 0),
    (VUINT32) ((0x3FDC152A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6A92654EC891D7uLL) >> 0),
    (VUINT32) ((0x3E6A92654EC891D7uLL) >> 32)},
   {(VUINT32) ((0x3FDC263000000000uLL) >> 0),
    (VUINT32) ((0x3FDC263000000000uLL) >> 32)},
   {(VUINT32) ((0x3E7037888B90C7F8uLL) >> 0),
    (VUINT32) ((0x3E7037888B90C7F8uLL) >> 32)},
   {(VUINT32) ((0x3FDC373200000000uLL) >> 0),
    (VUINT32) ((0x3FDC373200000000uLL) >> 32)},
   {(VUINT32) ((0x3E84E5A090419BC8uLL) >> 0),
    (VUINT32) ((0x3E84E5A090419BC8uLL) >> 32)},
   {(VUINT32) ((0x3FDC483200000000uLL) >> 0),
    (VUINT32) ((0x3FDC483200000000uLL) >> 32)},
   {(VUINT32) ((0x3E882722E066F64DuLL) >> 0),
    (VUINT32) ((0x3E882722E066F64DuLL) >> 32)},
   {(VUINT32) ((0x3FDC592F00000000uLL) >> 0),
    (VUINT32) ((0x3FDC592F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6894AD710AEF0CuLL) >> 0),
    (VUINT32) ((0x3E6894AD710AEF0CuLL) >> 32)},
   {(VUINT32) ((0x3FDC6A2900000000uLL) >> 0),
    (VUINT32) ((0x3FDC6A2900000000uLL) >> 32)},
   {(VUINT32) ((0x3E74290C06A50919uLL) >> 0),
    (VUINT32) ((0x3E74290C06A50919uLL) >> 32)},
   {(VUINT32) ((0x3FDC7B1F00000000uLL) >> 0),
    (VUINT32) ((0x3FDC7B1F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8829EA41109E48uLL) >> 0),
    (VUINT32) ((0x3E8829EA41109E48uLL) >> 32)},
   {(VUINT32) ((0x3FDC8C1200000000uLL) >> 0),
    (VUINT32) ((0x3FDC8C1200000000uLL) >> 32)},
   {(VUINT32) ((0x3E8011FB6AD70668uLL) >> 0),
    (VUINT32) ((0x3E8011FB6AD70668uLL) >> 32)},
   {(VUINT32) ((0x3FDC9D0200000000uLL) >> 0),
    (VUINT32) ((0x3FDC9D0200000000uLL) >> 32)},
   {(VUINT32) ((0x3E8D1948F3CB0098uLL) >> 0),
    (VUINT32) ((0x3E8D1948F3CB0098uLL) >> 32)},
   {(VUINT32) ((0x3FDCADEF00000000uLL) >> 0),
    (VUINT32) ((0x3FDCADEF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E835C4DC117DE0DuLL) >> 0),
    (VUINT32) ((0x3E835C4DC117DE0DuLL) >> 32)},
   {(VUINT32) ((0x3FDCBED900000000uLL) >> 0),
    (VUINT32) ((0x3FDCBED900000000uLL) >> 32)},
   {(VUINT32) ((0x3E8E37710C7563B4uLL) >> 0),
    (VUINT32) ((0x3E8E37710C7563B4uLL) >> 32)},
   {(VUINT32) ((0x3FDCCFC000000000uLL) >> 0),
    (VUINT32) ((0x3FDCCFC000000000uLL) >> 32)},
   {(VUINT32) ((0x3E81B705B8191331uLL) >> 0),
    (VUINT32) ((0x3E81B705B8191331uLL) >> 32)},
   {(VUINT32) ((0x3FDCE0A400000000uLL) >> 0),
    (VUINT32) ((0x3FDCE0A400000000uLL) >> 32)},
   {(VUINT32) ((0x3E89474B1CFE31F4uLL) >> 0),
    (VUINT32) ((0x3E89474B1CFE31F4uLL) >> 32)},
   {(VUINT32) ((0x3FDCF18500000000uLL) >> 0),
    (VUINT32) ((0x3FDCF18500000000uLL) >> 32)},
   {(VUINT32) ((0x3E71C8D86EE32D3BuLL) >> 0),
    (VUINT32) ((0x3E71C8D86EE32D3BuLL) >> 32)},
   {(VUINT32) ((0x3FDD026300000000uLL) >> 0),
    (VUINT32) ((0x3FDD026300000000uLL) >> 32)},
   {(VUINT32) ((0x3E7815019917C831uLL) >> 0),
    (VUINT32) ((0x3E7815019917C831uLL) >> 32)},
   {(VUINT32) ((0x3FDD133D00000000uLL) >> 0),
    (VUINT32) ((0x3FDD133D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E86A58C1D40A370uLL) >> 0),
    (VUINT32) ((0x3E86A58C1D40A370uLL) >> 32)},
   {(VUINT32) ((0x3FDD241400000000uLL) >> 0),
    (VUINT32) ((0x3FDD241400000000uLL) >> 32)},
   {(VUINT32) ((0x3E70C2FC81BC79C2uLL) >> 0),
    (VUINT32) ((0x3E70C2FC81BC79C2uLL) >> 32)},
   {(VUINT32) ((0x3FDD34E900000000uLL) >> 0),
    (VUINT32) ((0x3FDD34E900000000uLL) >> 32)},
   {(VUINT32) ((0x3E88BA3405ADB567uLL) >> 0),
    (VUINT32) ((0x3E88BA3405ADB567uLL) >> 32)},
   {(VUINT32) ((0x3FDD45BA00000000uLL) >> 0),
    (VUINT32) ((0x3FDD45BA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5DDBA9ECF26BB9uLL) >> 0),
    (VUINT32) ((0x3E5DDBA9ECF26BB9uLL) >> 32)},
   {(VUINT32) ((0x3FDD568800000000uLL) >> 0),
    (VUINT32) ((0x3FDD568800000000uLL) >> 32)},
   {(VUINT32) ((0x3E3D1EF9E850540FuLL) >> 0),
    (VUINT32) ((0x3E3D1EF9E850540FuLL) >> 32)},
   {(VUINT32) ((0x3FDD675300000000uLL) >> 0),
    (VUINT32) ((0x3FDD675300000000uLL) >> 32)},
   {(VUINT32) ((0x3E80065D34CA0DCEuLL) >> 0),
    (VUINT32) ((0x3E80065D34CA0DCEuLL) >> 32)},
   {(VUINT32) ((0x3FDD781C00000000uLL) >> 0),
    (VUINT32) ((0x3FDD781C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E80D733E02D0DD1uLL) >> 0),
    (VUINT32) ((0x3E80D733E02D0DD1uLL) >> 32)},
   {(VUINT32) ((0x3FDD88E100000000uLL) >> 0),
    (VUINT32) ((0x3FDD88E100000000uLL) >> 32)},
   {(VUINT32) ((0x3E870EF65B098F9CuLL) >> 0),
    (VUINT32) ((0x3E870EF65B098F9CuLL) >> 32)},
   {(VUINT32) ((0x3FDD99A300000000uLL) >> 0),
    (VUINT32) ((0x3FDD99A300000000uLL) >> 32)},
   {(VUINT32) ((0x3E52C86102E26030uLL) >> 0),
    (VUINT32) ((0x3E52C86102E26030uLL) >> 32)},
   {(VUINT32) ((0x3FDDAA6100000000uLL) >> 0),
    (VUINT32) ((0x3FDDAA6100000000uLL) >> 32)},
   {(VUINT32) ((0x3E8E80C9EF4C81D3uLL) >> 0),
    (VUINT32) ((0x3E8E80C9EF4C81D3uLL) >> 32)},
   {(VUINT32) ((0x3FDDBB1E00000000uLL) >> 0),
    (VUINT32) ((0x3FDDBB1E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7692E19CB2B425uLL) >> 0),
    (VUINT32) ((0x3E7692E19CB2B425uLL) >> 32)},
   {(VUINT32) ((0x3FDDCBD600000000uLL) >> 0),
    (VUINT32) ((0x3FDDCBD600000000uLL) >> 32)},
   {(VUINT32) ((0x3E8C462E64521547uLL) >> 0),
    (VUINT32) ((0x3E8C462E64521547uLL) >> 32)},
   {(VUINT32) ((0x3FDDDC8C00000000uLL) >> 0),
    (VUINT32) ((0x3FDDDC8C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8D5A1DD411035EuLL) >> 0),
    (VUINT32) ((0x3E8D5A1DD411035EuLL) >> 32)},
   {(VUINT32) ((0x3FDDED4000000000uLL) >> 0),
    (VUINT32) ((0x3FDDED4000000000uLL) >> 32)},
   {(VUINT32) ((0x3E7C908DF47A8F92uLL) >> 0),
    (VUINT32) ((0x3E7C908DF47A8F92uLL) >> 32)},
   {(VUINT32) ((0x3FDDFDF000000000uLL) >> 0),
    (VUINT32) ((0x3FDDFDF000000000uLL) >> 32)},
   {(VUINT32) ((0x3E545CF17F40AA9DuLL) >> 0),
    (VUINT32) ((0x3E545CF17F40AA9DuLL) >> 32)},
   {(VUINT32) ((0x3FDE0E9D00000000uLL) >> 0),
    (VUINT32) ((0x3FDE0E9D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E687C172AC42C55uLL) >> 0),
    (VUINT32) ((0x3E687C172AC42C55uLL) >> 32)},
   {(VUINT32) ((0x3FDE1F4600000000uLL) >> 0),
    (VUINT32) ((0x3FDE1F4600000000uLL) >> 32)},
   {(VUINT32) ((0x3E78DA98936314CFuLL) >> 0),
    (VUINT32) ((0x3E78DA98936314CFuLL) >> 32)},
   {(VUINT32) ((0x3FDE2FED00000000uLL) >> 0),
    (VUINT32) ((0x3FDE2FED00000000uLL) >> 32)},
   {(VUINT32) ((0x3E4812E4AC4E8487uLL) >> 0),
    (VUINT32) ((0x3E4812E4AC4E8487uLL) >> 32)},
   {(VUINT32) ((0x3FDE409100000000uLL) >> 0),
    (VUINT32) ((0x3FDE409100000000uLL) >> 32)},
   {(VUINT32) ((0x3E64755453322906uLL) >> 0),
    (VUINT32) ((0x3E64755453322906uLL) >> 32)},
   {(VUINT32) ((0x3FDE513100000000uLL) >> 0),
    (VUINT32) ((0x3FDE513100000000uLL) >> 32)},
   {(VUINT32) ((0x3E7528AE2E3EF4FAuLL) >> 0),
    (VUINT32) ((0x3E7528AE2E3EF4FAuLL) >> 32)},
   {(VUINT32) ((0x3FDE61D000000000uLL) >> 0),
    (VUINT32) ((0x3FDE61D000000000uLL) >> 32)},
   {(VUINT32) ((0x3E7501716CF4BE90uLL) >> 0),
    (VUINT32) ((0x3E7501716CF4BE90uLL) >> 32)},
   {(VUINT32) ((0x3FDE726900000000uLL) >> 0),
    (VUINT32) ((0x3FDE726900000000uLL) >> 32)},
   {(VUINT32) ((0x3E8F3CEA8B8B9869uLL) >> 0),
    (VUINT32) ((0x3E8F3CEA8B8B9869uLL) >> 32)},
   {(VUINT32) ((0x3FDE830200000000uLL) >> 0),
    (VUINT32) ((0x3FDE830200000000uLL) >> 32)},
   {(VUINT32) ((0x3E7BE69828149B31uLL) >> 0),
    (VUINT32) ((0x3E7BE69828149B31uLL) >> 32)},
   {(VUINT32) ((0x3FDE939600000000uLL) >> 0),
    (VUINT32) ((0x3FDE939600000000uLL) >> 32)},
   {(VUINT32) ((0x3E8D5E2937A72435uLL) >> 0),
    (VUINT32) ((0x3E8D5E2937A72435uLL) >> 32)},
   {(VUINT32) ((0x3FDEA42800000000uLL) >> 0),
    (VUINT32) ((0x3FDEA42800000000uLL) >> 32)},
   {(VUINT32) ((0x3E89BFBBE2698141uLL) >> 0),
    (VUINT32) ((0x3E89BFBBE2698141uLL) >> 32)},
   {(VUINT32) ((0x3FDEB4B800000000uLL) >> 0),
    (VUINT32) ((0x3FDEB4B800000000uLL) >> 32)},
   {(VUINT32) ((0x3E56D15B8C6D35E8uLL) >> 0),
    (VUINT32) ((0x3E56D15B8C6D35E8uLL) >> 32)},
   {(VUINT32) ((0x3FDEC54400000000uLL) >> 0),
    (VUINT32) ((0x3FDEC54400000000uLL) >> 32)},
   {(VUINT32) ((0x3E886F8D094B9A13uLL) >> 0),
    (VUINT32) ((0x3E886F8D094B9A13uLL) >> 32)},
   {(VUINT32) ((0x3FDED5CD00000000uLL) >> 0),
    (VUINT32) ((0x3FDED5CD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7B23C5DCA4EFF0uLL) >> 0),
    (VUINT32) ((0x3E7B23C5DCA4EFF0uLL) >> 32)},
   {(VUINT32) ((0x3FDEE65300000000uLL) >> 0),
    (VUINT32) ((0x3FDEE65300000000uLL) >> 32)},
   {(VUINT32) ((0x3E7D463BF0218027uLL) >> 0),
    (VUINT32) ((0x3E7D463BF0218027uLL) >> 32)},
   {(VUINT32) ((0x3FDEF6D600000000uLL) >> 0),
    (VUINT32) ((0x3FDEF6D600000000uLL) >> 32)},
   {(VUINT32) ((0x3E8B651C6050E055uLL) >> 0),
    (VUINT32) ((0x3E8B651C6050E055uLL) >> 32)},
   {(VUINT32) ((0x3FDF075600000000uLL) >> 0),
    (VUINT32) ((0x3FDF075600000000uLL) >> 32)},
   {(VUINT32) ((0x3E6B46A793B8E626uLL) >> 0),
    (VUINT32) ((0x3E6B46A793B8E626uLL) >> 32)},
   {(VUINT32) ((0x3FDF17D400000000uLL) >> 0),
    (VUINT32) ((0x3FDF17D400000000uLL) >> 32)},
   {(VUINT32) ((0x3E74650236B11F5FuLL) >> 0),
    (VUINT32) ((0x3E74650236B11F5FuLL) >> 32)},
   {(VUINT32) ((0x3FDF284E00000000uLL) >> 0),
    (VUINT32) ((0x3FDF284E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E77629298EFA0ADuLL) >> 0),
    (VUINT32) ((0x3E77629298EFA0ADuLL) >> 32)},
   {(VUINT32) ((0x3FDF38C500000000uLL) >> 0),
    (VUINT32) ((0x3FDF38C500000000uLL) >> 32)},
   {(VUINT32) ((0x3E87D798BEBCB6ABuLL) >> 0),
    (VUINT32) ((0x3E87D798BEBCB6ABuLL) >> 32)},
   {(VUINT32) ((0x3FDF493A00000000uLL) >> 0),
    (VUINT32) ((0x3FDF493A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7CCDE6D2F4C9F7uLL) >> 0),
    (VUINT32) ((0x3E7CCDE6D2F4C9F7uLL) >> 32)},
   {(VUINT32) ((0x3FDF59AB00000000uLL) >> 0),
    (VUINT32) ((0x3FDF59AB00000000uLL) >> 32)},
   {(VUINT32) ((0x3E5186572A5FF9C8uLL) >> 0),
    (VUINT32) ((0x3E5186572A5FF9C8uLL) >> 32)},
   {(VUINT32) ((0x3FDF6A1A00000000uLL) >> 0),
    (VUINT32) ((0x3FDF6A1A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E799D006591C907uLL) >> 0),
    (VUINT32) ((0x3E799D006591C907uLL) >> 32)},
   {(VUINT32) ((0x3FDF7A8500000000uLL) >> 0),
    (VUINT32) ((0x3FDF7A8500000000uLL) >> 32)},
   {(VUINT32) ((0x3E841960E73EC979uLL) >> 0),
    (VUINT32) ((0x3E841960E73EC979uLL) >> 32)},
   {(VUINT32) ((0x3FDF8AEE00000000uLL) >> 0),
    (VUINT32) ((0x3FDF8AEE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E630AA8521479FDuLL) >> 0),
    (VUINT32) ((0x3E630AA8521479FDuLL) >> 32)},
   {(VUINT32) ((0x3FDF9B5300000000uLL) >> 0),
    (VUINT32) ((0x3FDF9B5300000000uLL) >> 32)},
   {(VUINT32) ((0x3E8E8B869C429D94uLL) >> 0),
    (VUINT32) ((0x3E8E8B869C429D94uLL) >> 32)},
   {(VUINT32) ((0x3FDFABB700000000uLL) >> 0),
    (VUINT32) ((0x3FDFABB700000000uLL) >> 32)},
   {(VUINT32) ((0x3E4350FC25C8A13BuLL) >> 0),
    (VUINT32) ((0x3E4350FC25C8A13BuLL) >> 32)},
   {(VUINT32) ((0x3FDFBC1700000000uLL) >> 0),
    (VUINT32) ((0x3FDFBC1700000000uLL) >> 32)},
   {(VUINT32) ((0x3E79009A6EF5D48AuLL) >> 0),
    (VUINT32) ((0x3E79009A6EF5D48AuLL) >> 32)},
   {(VUINT32) ((0x3FDFCC7300000000uLL) >> 0),
    (VUINT32) ((0x3FDFCC7300000000uLL) >> 32)},
   {(VUINT32) ((0x3E8306349A8ABFEFuLL) >> 0),
    (VUINT32) ((0x3E8306349A8ABFEFuLL) >> 32)},
   {(VUINT32) ((0x3FDFDCCE00000000uLL) >> 0),
    (VUINT32) ((0x3FDFDCCE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7D9F569F06BC1EuLL) >> 0),
    (VUINT32) ((0x3E7D9F569F06BC1EuLL) >> 32)},
   {(VUINT32) ((0x3FDFED2500000000uLL) >> 0),
    (VUINT32) ((0x3FDFED2500000000uLL) >> 32)},
   {(VUINT32) ((0x3E65160EC1D12919uLL) >> 0),
    (VUINT32) ((0x3E65160EC1D12919uLL) >> 32)},
   {(VUINT32) ((0x3FDFFD7900000000uLL) >> 0),
    (VUINT32) ((0x3FDFFD7900000000uLL) >> 32)},
   {(VUINT32) ((0x3E5A83FF2555A494uLL) >> 0),
    (VUINT32) ((0x3E5A83FF2555A494uLL) >> 32)},
   {(VUINT32) ((0x3FE006E500000000uLL) >> 0),
    (VUINT32) ((0x3FE006E500000000uLL) >> 32)},
   {(VUINT32) ((0x3E9AFCA83644DE26uLL) >> 0),
    (VUINT32) ((0x3E9AFCA83644DE26uLL) >> 32)},
   {(VUINT32) ((0x3FE00F0D00000000uLL) >> 0),
    (VUINT32) ((0x3FE00F0D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E53C49D9079D468uLL) >> 0),
    (VUINT32) ((0x3E53C49D9079D468uLL) >> 32)},
   {(VUINT32) ((0x3FE0173200000000uLL) >> 0),
    (VUINT32) ((0x3FE0173200000000uLL) >> 32)},
   {(VUINT32) ((0x3E9AE76BE763882EuLL) >> 0),
    (VUINT32) ((0x3E9AE76BE763882EuLL) >> 32)},
   {(VUINT32) ((0x3FE01F5700000000uLL) >> 0),
    (VUINT32) ((0x3FE01F5700000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F793285E25C81uLL) >> 0),
    (VUINT32) ((0x3E7F793285E25C81uLL) >> 32)},
   {(VUINT32) ((0x3FE0277A00000000uLL) >> 0),
    (VUINT32) ((0x3FE0277A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E800243639826EEuLL) >> 0),
    (VUINT32) ((0x3E800243639826EEuLL) >> 32)},
   {(VUINT32) ((0x3FE02F9B00000000uLL) >> 0),
    (VUINT32) ((0x3FE02F9B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E9B301832F2C8A9uLL) >> 0),
    (VUINT32) ((0x3E9B301832F2C8A9uLL) >> 32)},
   {(VUINT32) ((0x3FE037BC00000000uLL) >> 0),
    (VUINT32) ((0x3FE037BC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E54B54B5457AB7CuLL) >> 0),
    (VUINT32) ((0x3E54B54B5457AB7CuLL) >> 32)},
   {(VUINT32) ((0x3FE03FDA00000000uLL) >> 0),
    (VUINT32) ((0x3FE03FDA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E9A32F3449FA7A6uLL) >> 0),
    (VUINT32) ((0x3E9A32F3449FA7A6uLL) >> 32)},
   {(VUINT32) ((0x3FE047F700000000uLL) >> 0),
    (VUINT32) ((0x3FE047F700000000uLL) >> 32)},
   {(VUINT32) ((0x3E8E060E91D41DA5uLL) >> 0),
    (VUINT32) ((0x3E8E060E91D41DA5uLL) >> 32)},
   {(VUINT32) ((0x3FE0501300000000uLL) >> 0),
    (VUINT32) ((0x3FE0501300000000uLL) >> 32)},
   {(VUINT32) ((0x3E8A3F382AA1E82BuLL) >> 0),
    (VUINT32) ((0x3E8A3F382AA1E82BuLL) >> 32)},
   {(VUINT32) ((0x3FE0582D00000000uLL) >> 0),
    (VUINT32) ((0x3FE0582D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E9DA8B4318C1DD2uLL) >> 0),
    (VUINT32) ((0x3E9DA8B4318C1DD2uLL) >> 32)},
   {(VUINT32) ((0x3FE0604700000000uLL) >> 0),
    (VUINT32) ((0x3FE0604700000000uLL) >> 32)},
   {(VUINT32) ((0x3E3F9274A07C17A6uLL) >> 0),
    (VUINT32) ((0x3E3F9274A07C17A6uLL) >> 32)},
   {(VUINT32) ((0x3FE0685E00000000uLL) >> 0),
    (VUINT32) ((0x3FE0685E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E95804EC5F0FE6DuLL) >> 0),
    (VUINT32) ((0x3E95804EC5F0FE6DuLL) >> 32)},
   {(VUINT32) ((0x3FE0707400000000uLL) >> 0),
    (VUINT32) ((0x3FE0707400000000uLL) >> 32)},
   {(VUINT32) ((0x3E9C8EAC786D0112uLL) >> 0),
    (VUINT32) ((0x3E9C8EAC786D0112uLL) >> 32)},
   {(VUINT32) ((0x3FE0788900000000uLL) >> 0),
    (VUINT32) ((0x3FE0788900000000uLL) >> 32)},
   {(VUINT32) ((0x3E958943FB66416BuLL) >> 0),
    (VUINT32) ((0x3E958943FB66416BuLL) >> 32)},
   {(VUINT32) ((0x3FE0809D00000000uLL) >> 0),
    (VUINT32) ((0x3FE0809D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E33FB82CEDE51E0uLL) >> 0),
    (VUINT32) ((0x3E33FB82CEDE51E0uLL) >> 32)},
   {(VUINT32) ((0x3FE088AE00000000uLL) >> 0),
    (VUINT32) ((0x3FE088AE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E9CC27B15563034uLL) >> 0),
    (VUINT32) ((0x3E9CC27B15563034uLL) >> 32)},
   {(VUINT32) ((0x3FE090BF00000000uLL) >> 0),
    (VUINT32) ((0x3FE090BF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8581667CA3348DuLL) >> 0),
    (VUINT32) ((0x3E8581667CA3348DuLL) >> 32)},
   {(VUINT32) ((0x3FE098CE00000000uLL) >> 0),
    (VUINT32) ((0x3FE098CE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8454ACD057FBFAuLL) >> 0),
    (VUINT32) ((0x3E8454ACD057FBFAuLL) >> 32)},
   {(VUINT32) ((0x3FE0A0DC00000000uLL) >> 0),
    (VUINT32) ((0x3FE0A0DC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E91CF1C5C53F37DuLL) >> 0),
    (VUINT32) ((0x3E91CF1C5C53F37DuLL) >> 32)},
   {(VUINT32) ((0x3FE0A8E800000000uLL) >> 0),
    (VUINT32) ((0x3FE0A8E800000000uLL) >> 32)},
   {(VUINT32) ((0x3E93B2B423F481D0uLL) >> 0),
    (VUINT32) ((0x3E93B2B423F481D0uLL) >> 32)},
   {(VUINT32) ((0x3FE0B0F300000000uLL) >> 0),
    (VUINT32) ((0x3FE0B0F300000000uLL) >> 32)},
   {(VUINT32) ((0x3E7A8314E3B62474uLL) >> 0),
    (VUINT32) ((0x3E7A8314E3B62474uLL) >> 32)},
   {(VUINT32) ((0x3FE0B8FD00000000uLL) >> 0),
    (VUINT32) ((0x3FE0B8FD00000000uLL) >> 32)},
   {(VUINT32) ((0x3E574EEBA208D495uLL) >> 0),
    (VUINT32) ((0x3E574EEBA208D495uLL) >> 32)},
   {(VUINT32) ((0x3FE0C10400000000uLL) >> 0),
    (VUINT32) ((0x3FE0C10400000000uLL) >> 32)},
   {(VUINT32) ((0x3E961AC74D5ADA6AuLL) >> 0),
    (VUINT32) ((0x3E961AC74D5ADA6AuLL) >> 32)},
   {(VUINT32) ((0x3FE0C90B00000000uLL) >> 0),
    (VUINT32) ((0x3FE0C90B00000000uLL) >> 32)},
   {(VUINT32) ((0x3E926DDDE7AA78B1uLL) >> 0),
    (VUINT32) ((0x3E926DDDE7AA78B1uLL) >> 32)},
   {(VUINT32) ((0x3FE0D11000000000uLL) >> 0),
    (VUINT32) ((0x3FE0D11000000000uLL) >> 32)},
   {(VUINT32) ((0x3E9F51B91D907509uLL) >> 0),
    (VUINT32) ((0x3E9F51B91D907509uLL) >> 32)},
   {(VUINT32) ((0x3FE0D91400000000uLL) >> 0),
    (VUINT32) ((0x3FE0D91400000000uLL) >> 32)},
   {(VUINT32) ((0x3E9CA5D77A3BF837uLL) >> 0),
    (VUINT32) ((0x3E9CA5D77A3BF837uLL) >> 32)},
   {(VUINT32) ((0x3FE0E11700000000uLL) >> 0),
    (VUINT32) ((0x3FE0E11700000000uLL) >> 32)},
   {(VUINT32) ((0x3E84935EF97F078EuLL) >> 0),
    (VUINT32) ((0x3E84935EF97F078EuLL) >> 32)},
   {(VUINT32) ((0x3FE0E91800000000uLL) >> 0),
    (VUINT32) ((0x3FE0E91800000000uLL) >> 32)},
   {(VUINT32) ((0x3E80395F3D5449D6uLL) >> 0),
    (VUINT32) ((0x3E80395F3D5449D6uLL) >> 32)},
   {(VUINT32) ((0x3FE0F11800000000uLL) >> 0),
    (VUINT32) ((0x3FE0F11800000000uLL) >> 32)},
   {(VUINT32) ((0x3E8A2C7CB38D9ED1uLL) >> 0),
    (VUINT32) ((0x3E8A2C7CB38D9ED1uLL) >> 32)},
   {(VUINT32) ((0x3FE0F91600000000uLL) >> 0),
    (VUINT32) ((0x3FE0F91600000000uLL) >> 32)},
   {(VUINT32) ((0x3E9677BA0152CBB4uLL) >> 0),
    (VUINT32) ((0x3E9677BA0152CBB4uLL) >> 32)},
   {(VUINT32) ((0x3FE1011300000000uLL) >> 0),
    (VUINT32) ((0x3FE1011300000000uLL) >> 32)},
   {(VUINT32) ((0x3E9B3A7927AEC2FDuLL) >> 0),
    (VUINT32) ((0x3E9B3A7927AEC2FDuLL) >> 32)},
   {(VUINT32) ((0x3FE1090F00000000uLL) >> 0),
    (VUINT32) ((0x3FE1090F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E707F2889E8B7A9uLL) >> 0),
    (VUINT32) ((0x3E707F2889E8B7A9uLL) >> 32)},
   {(VUINT32) ((0x3FE1110900000000uLL) >> 0),
    (VUINT32) ((0x3FE1110900000000uLL) >> 32)},
   {(VUINT32) ((0x3E93BCF3BA17FB1FuLL) >> 0),
    (VUINT32) ((0x3E93BCF3BA17FB1FuLL) >> 32)},
   {(VUINT32) ((0x3FE1190200000000uLL) >> 0),
    (VUINT32) ((0x3FE1190200000000uLL) >> 32)},
   {(VUINT32) ((0x3E7CECD182C0B1E4uLL) >> 0),
    (VUINT32) ((0x3E7CECD182C0B1E4uLL) >> 32)},
   {(VUINT32) ((0x3FE120F900000000uLL) >> 0),
    (VUINT32) ((0x3FE120F900000000uLL) >> 32)},
   {(VUINT32) ((0x3E95A3C2FB2785B2uLL) >> 0),
    (VUINT32) ((0x3E95A3C2FB2785B2uLL) >> 32)},
   {(VUINT32) ((0x3FE128EF00000000uLL) >> 0),
    (VUINT32) ((0x3FE128EF00000000uLL) >> 32)},
   {(VUINT32) ((0x3E9EDBCE6A636A11uLL) >> 0),
    (VUINT32) ((0x3E9EDBCE6A636A11uLL) >> 32)},
   {(VUINT32) ((0x3FE130E400000000uLL) >> 0),
    (VUINT32) ((0x3FE130E400000000uLL) >> 32)},
   {(VUINT32) ((0x3E972C7DA9B832D3uLL) >> 0),
    (VUINT32) ((0x3E972C7DA9B832D3uLL) >> 32)},
   {(VUINT32) ((0x3FE138D700000000uLL) >> 0),
    (VUINT32) ((0x3FE138D700000000uLL) >> 32)},
   {(VUINT32) ((0x3E9E74EFEB672A03uLL) >> 0),
    (VUINT32) ((0x3E9E74EFEB672A03uLL) >> 32)},
   {(VUINT32) ((0x3FE140CA00000000uLL) >> 0),
    (VUINT32) ((0x3FE140CA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E2A1E54F6B89E31uLL) >> 0),
    (VUINT32) ((0x3E2A1E54F6B89E31uLL) >> 32)},
   {(VUINT32) ((0x3FE148BA00000000uLL) >> 0),
    (VUINT32) ((0x3FE148BA00000000uLL) >> 32)},
   {(VUINT32) ((0x3E90AD737019FD24uLL) >> 0),
    (VUINT32) ((0x3E90AD737019FD24uLL) >> 32)},
   {(VUINT32) ((0x3FE150A900000000uLL) >> 0),
    (VUINT32) ((0x3FE150A900000000uLL) >> 32)},
   {(VUINT32) ((0x3E9B639C287D2824uLL) >> 0),
    (VUINT32) ((0x3E9B639C287D2824uLL) >> 32)},
   {(VUINT32) ((0x3FE1589700000000uLL) >> 0),
    (VUINT32) ((0x3FE1589700000000uLL) >> 32)},
   {(VUINT32) ((0x3E9495B6DD3DDABDuLL) >> 0),
    (VUINT32) ((0x3E9495B6DD3DDABDuLL) >> 32)},
   {(VUINT32) ((0x3FE1608400000000uLL) >> 0),
    (VUINT32) ((0x3FE1608400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7F2AEFFE31B5D0uLL) >> 0),
    (VUINT32) ((0x3E7F2AEFFE31B5D0uLL) >> 32)},
   {(VUINT32) ((0x3FE1686F00000000uLL) >> 0),
    (VUINT32) ((0x3FE1686F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E827B385C52CC9FuLL) >> 0),
    (VUINT32) ((0x3E827B385C52CC9FuLL) >> 32)},
   {(VUINT32) ((0x3FE1705900000000uLL) >> 0),
    (VUINT32) ((0x3FE1705900000000uLL) >> 32)},
   {(VUINT32) ((0x3E71E501D3944026uLL) >> 0),
    (VUINT32) ((0x3E71E501D3944026uLL) >> 32)},
   {(VUINT32) ((0x3FE1784100000000uLL) >> 0),
    (VUINT32) ((0x3FE1784100000000uLL) >> 32)},
   {(VUINT32) ((0x3E99628A2C0E2602uLL) >> 0),
    (VUINT32) ((0x3E99628A2C0E2602uLL) >> 32)},
   {(VUINT32) ((0x3FE1802800000000uLL) >> 0),
    (VUINT32) ((0x3FE1802800000000uLL) >> 32)},
   {(VUINT32) ((0x3E9C2E52F159A4BFuLL) >> 0),
    (VUINT32) ((0x3E9C2E52F159A4BFuLL) >> 32)},
   {(VUINT32) ((0x3FE1880E00000000uLL) >> 0),
    (VUINT32) ((0x3FE1880E00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8976D9B0F3DFDDuLL) >> 0),
    (VUINT32) ((0x3E8976D9B0F3DFDDuLL) >> 32)},
   {(VUINT32) ((0x3FE18FF300000000uLL) >> 0),
    (VUINT32) ((0x3FE18FF300000000uLL) >> 32)},
   {(VUINT32) ((0x3E628513CD04695CuLL) >> 0),
    (VUINT32) ((0x3E628513CD04695CuLL) >> 32)},
   {(VUINT32) ((0x3FE197D600000000uLL) >> 0),
    (VUINT32) ((0x3FE197D600000000uLL) >> 32)},
   {(VUINT32) ((0x3E75B2DA605BDDF8uLL) >> 0),
    (VUINT32) ((0x3E75B2DA605BDDF8uLL) >> 32)},
   {(VUINT32) ((0x3FE19FB700000000uLL) >> 0),
    (VUINT32) ((0x3FE19FB700000000uLL) >> 32)},
   {(VUINT32) ((0x3E95EE648263EE18uLL) >> 0),
    (VUINT32) ((0x3E95EE648263EE18uLL) >> 32)},
   {(VUINT32) ((0x3FE1A79700000000uLL) >> 0),
    (VUINT32) ((0x3FE1A79700000000uLL) >> 32)},
   {(VUINT32) ((0x3E9F6E601AC91256uLL) >> 0),
    (VUINT32) ((0x3E9F6E601AC91256uLL) >> 32)},
   {(VUINT32) ((0x3FE1AF7700000000uLL) >> 0),
    (VUINT32) ((0x3FE1AF7700000000uLL) >> 32)},
   {(VUINT32) ((0x3E5D155A178B90CDuLL) >> 0),
    (VUINT32) ((0x3E5D155A178B90CDuLL) >> 32)},
   {(VUINT32) ((0x3FE1B75400000000uLL) >> 0),
    (VUINT32) ((0x3FE1B75400000000uLL) >> 32)},
   {(VUINT32) ((0x3E9CFBE9DE667B41uLL) >> 0),
    (VUINT32) ((0x3E9CFBE9DE667B41uLL) >> 32)},
   {(VUINT32) ((0x3FE1BF3100000000uLL) >> 0),
    (VUINT32) ((0x3FE1BF3100000000uLL) >> 32)},
   {(VUINT32) ((0x3E744AE80F899FBDuLL) >> 0),
    (VUINT32) ((0x3E744AE80F899FBDuLL) >> 32)},
   {(VUINT32) ((0x3FE1C70C00000000uLL) >> 0),
    (VUINT32) ((0x3FE1C70C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E76D96FF1C879C9uLL) >> 0),
    (VUINT32) ((0x3E76D96FF1C879C9uLL) >> 32)},
   {(VUINT32) ((0x3FE1CEE500000000uLL) >> 0),
    (VUINT32) ((0x3FE1CEE500000000uLL) >> 32)},
   {(VUINT32) ((0x3E9ECB5E2C072EB0uLL) >> 0),
    (VUINT32) ((0x3E9ECB5E2C072EB0uLL) >> 32)},
   {(VUINT32) ((0x3FE1D6BE00000000uLL) >> 0),
    (VUINT32) ((0x3FE1D6BE00000000uLL) >> 32)},
   {(VUINT32) ((0x3E71C11DBE1DB818uLL) >> 0),
    (VUINT32) ((0x3E71C11DBE1DB818uLL) >> 32)},
   {(VUINT32) ((0x3FE1DE9500000000uLL) >> 0),
    (VUINT32) ((0x3FE1DE9500000000uLL) >> 32)},
   {(VUINT32) ((0x3E625CBB9559D10FuLL) >> 0),
    (VUINT32) ((0x3E625CBB9559D10FuLL) >> 32)},
   {(VUINT32) ((0x3FE1E66A00000000uLL) >> 0),
    (VUINT32) ((0x3FE1E66A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E9841C66176BDDEuLL) >> 0),
    (VUINT32) ((0x3E9841C66176BDDEuLL) >> 32)},
   {(VUINT32) ((0x3FE1EE3F00000000uLL) >> 0),
    (VUINT32) ((0x3FE1EE3F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E78DD143C97C211uLL) >> 0),
    (VUINT32) ((0x3E78DD143C97C211uLL) >> 32)},
   {(VUINT32) ((0x3FE1F61200000000uLL) >> 0),
    (VUINT32) ((0x3FE1F61200000000uLL) >> 32)},
   {(VUINT32) ((0x3E309F38F10515B8uLL) >> 0),
    (VUINT32) ((0x3E309F38F10515B8uLL) >> 32)},
   {(VUINT32) ((0x3FE1FDE300000000uLL) >> 0),
    (VUINT32) ((0x3FE1FDE300000000uLL) >> 32)},
   {(VUINT32) ((0x3E9DE1D02B7ACB55uLL) >> 0),
    (VUINT32) ((0x3E9DE1D02B7ACB55uLL) >> 32)},
   {(VUINT32) ((0x3FE205B400000000uLL) >> 0),
    (VUINT32) ((0x3FE205B400000000uLL) >> 32)},
   {(VUINT32) ((0x3E7D6E666F069F9FuLL) >> 0),
    (VUINT32) ((0x3E7D6E666F069F9FuLL) >> 32)},
   {(VUINT32) ((0x3FE20D8300000000uLL) >> 0),
    (VUINT32) ((0x3FE20D8300000000uLL) >> 32)},
   {(VUINT32) ((0x3E80C459B58A9A68uLL) >> 0),
    (VUINT32) ((0x3E80C459B58A9A68uLL) >> 32)},
   {(VUINT32) ((0x3FE2155100000000uLL) >> 0),
    (VUINT32) ((0x3FE2155100000000uLL) >> 32)},
   {(VUINT32) ((0x3E4B3AC6C4422B43uLL) >> 0),
    (VUINT32) ((0x3E4B3AC6C4422B43uLL) >> 32)},
   {(VUINT32) ((0x3FE21D1D00000000uLL) >> 0),
    (VUINT32) ((0x3FE21D1D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E90A6DABDF57C13uLL) >> 0),
    (VUINT32) ((0x3E90A6DABDF57C13uLL) >> 32)},
   {(VUINT32) ((0x3FE224E800000000uLL) >> 0),
    (VUINT32) ((0x3FE224E800000000uLL) >> 32)},
   {(VUINT32) ((0x3E87A6F05E2E66B4uLL) >> 0),
    (VUINT32) ((0x3E87A6F05E2E66B4uLL) >> 32)},
   {(VUINT32) ((0x3FE22CB200000000uLL) >> 0),
    (VUINT32) ((0x3FE22CB200000000uLL) >> 32)},
   {(VUINT32) ((0x3E83EBCAAAA786FFuLL) >> 0),
    (VUINT32) ((0x3E83EBCAAAA786FFuLL) >> 32)},
   {(VUINT32) ((0x3FE2347A00000000uLL) >> 0),
    (VUINT32) ((0x3FE2347A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E933C5177AE38BEuLL) >> 0),
    (VUINT32) ((0x3E933C5177AE38BEuLL) >> 32)},
   {(VUINT32) ((0x3FE23C4100000000uLL) >> 0),
    (VUINT32) ((0x3FE23C4100000000uLL) >> 32)},
   {(VUINT32) ((0x3E9F44E5029B8B1DuLL) >> 0),
    (VUINT32) ((0x3E9F44E5029B8B1DuLL) >> 32)},
   {(VUINT32) ((0x3FE2440700000000uLL) >> 0),
    (VUINT32) ((0x3FE2440700000000uLL) >> 32)},
   {(VUINT32) ((0x3E9635C0E894DF30uLL) >> 0),
    (VUINT32) ((0x3E9635C0E894DF30uLL) >> 32)},
   {(VUINT32) ((0x3FE24BCC00000000uLL) >> 0),
    (VUINT32) ((0x3FE24BCC00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6E87F9F1F3590CuLL) >> 0),
    (VUINT32) ((0x3E6E87F9F1F3590CuLL) >> 32)},
   {(VUINT32) ((0x3FE2538F00000000uLL) >> 0),
    (VUINT32) ((0x3FE2538F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E7FEACB86A3B429uLL) >> 0),
    (VUINT32) ((0x3E7FEACB86A3B429uLL) >> 32)},
   {(VUINT32) ((0x3FE25B5100000000uLL) >> 0),
    (VUINT32) ((0x3FE25B5100000000uLL) >> 32)},
   {(VUINT32) ((0x3E8CFDCF4E10A41AuLL) >> 0),
    (VUINT32) ((0x3E8CFDCF4E10A41AuLL) >> 32)},
   {(VUINT32) ((0x3FE2631100000000uLL) >> 0),
    (VUINT32) ((0x3FE2631100000000uLL) >> 32)},
   {(VUINT32) ((0x3E9F73A21FDDE641uLL) >> 0),
    (VUINT32) ((0x3E9F73A21FDDE641uLL) >> 32)},
   {(VUINT32) ((0x3FE26AD100000000uLL) >> 0),
    (VUINT32) ((0x3FE26AD100000000uLL) >> 32)},
   {(VUINT32) ((0x3E7A8B8011D56D3BuLL) >> 0),
    (VUINT32) ((0x3E7A8B8011D56D3BuLL) >> 32)},
   {(VUINT32) ((0x3FE2728F00000000uLL) >> 0),
    (VUINT32) ((0x3FE2728F00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6F84BF7D5B34D0uLL) >> 0),
    (VUINT32) ((0x3E6F84BF7D5B34D0uLL) >> 32)},
   {(VUINT32) ((0x3FE27A4C00000000uLL) >> 0),
    (VUINT32) ((0x3FE27A4C00000000uLL) >> 32)},
   {(VUINT32) ((0x3E6985CC1C8F11B0uLL) >> 0),
    (VUINT32) ((0x3E6985CC1C8F11B0uLL) >> 32)},
   {(VUINT32) ((0x3FE2820700000000uLL) >> 0),
    (VUINT32) ((0x3FE2820700000000uLL) >> 32)},
   {(VUINT32) ((0x3E88D25A6A02C803uLL) >> 0),
    (VUINT32) ((0x3E88D25A6A02C803uLL) >> 32)},
   {(VUINT32) ((0x3FE289C100000000uLL) >> 0),
    (VUINT32) ((0x3FE289C100000000uLL) >> 32)},
   {(VUINT32) ((0x3E975FD4C3433E76uLL) >> 0),
    (VUINT32) ((0x3E975FD4C3433E76uLL) >> 32)},
   {(VUINT32) ((0x3FE2917A00000000uLL) >> 0),
    (VUINT32) ((0x3FE2917A00000000uLL) >> 32)},
   {(VUINT32) ((0x3E8825154781D2C2uLL) >> 0),
    (VUINT32) ((0x3E8825154781D2C2uLL) >> 32)},
   {(VUINT32) ((0x3FE2993200000000uLL) >> 0),
    (VUINT32) ((0x3FE2993200000000uLL) >> 32)},
   {(VUINT32) ((0x3E62791595E60D25uLL) >> 0),
    (VUINT32) ((0x3E62791595E60D25uLL) >> 32)},
   {(VUINT32) ((0x3FE2A0E800000000uLL) >> 0),
    (VUINT32) ((0x3FE2A0E800000000uLL) >> 32)},
   {(VUINT32) ((0x3E605B4C41D5635BuLL) >> 0),
    (VUINT32) ((0x3E605B4C41D5635BuLL) >> 32)},
   {(VUINT32) ((0x3FE2A89D00000000uLL) >> 0),
    (VUINT32) ((0x3FE2A89D00000000uLL) >> 32)},
   {(VUINT32) ((0x3E68E92900528496uLL) >> 0),
    (VUINT32) ((0x3E68E92900528496uLL) >> 32)},
   {(VUINT32) ((0x3FE2B05000000000uLL) >> 0),
    (VUINT32) ((0x3FE2B05000000000uLL) >> 32)},
   {(VUINT32) ((0x3E9970145DF6A281uLL) >> 0),
    (VUINT32) ((0x3E9970145DF6A281uLL) >> 32)},
   {(VUINT32) ((0xBFDA8FF900000000uLL) >> 0),
    (VUINT32) ((0xBFDA8FF900000000uLL) >> 32)},
   {(VUINT32) ((0xBE86302155DF0DE3uLL) >> 0),
    (VUINT32) ((0xBE86302155DF0DE3uLL) >> 32)},
   {(VUINT32) ((0xBFDA809600000000uLL) >> 0),
    (VUINT32) ((0xBFDA809600000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D2B316176FAD0uLL) >> 0),
    (VUINT32) ((0xBE8D2B316176FAD0uLL) >> 32)},
   {(VUINT32) ((0xBFDA713700000000uLL) >> 0),
    (VUINT32) ((0xBFDA713700000000uLL) >> 32)},
   {(VUINT32) ((0xBE824DB2F6ACEB96uLL) >> 0),
    (VUINT32) ((0xBE824DB2F6ACEB96uLL) >> 32)},
   {(VUINT32) ((0xBFDA61DA00000000uLL) >> 0),
    (VUINT32) ((0xBFDA61DA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE67117A804DA234uLL) >> 0),
    (VUINT32) ((0xBE67117A804DA234uLL) >> 32)},
   {(VUINT32) ((0xBFDA527F00000000uLL) >> 0),
    (VUINT32) ((0xBFDA527F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7F97F60FF5807BuLL) >> 0),
    (VUINT32) ((0xBE7F97F60FF5807BuLL) >> 32)},
   {(VUINT32) ((0xBFDA432700000000uLL) >> 0),
    (VUINT32) ((0xBFDA432700000000uLL) >> 32)},
   {(VUINT32) ((0xBE809D5C44ADAA28uLL) >> 0),
    (VUINT32) ((0xBE809D5C44ADAA28uLL) >> 32)},
   {(VUINT32) ((0xBFDA33D200000000uLL) >> 0),
    (VUINT32) ((0xBFDA33D200000000uLL) >> 32)},
   {(VUINT32) ((0xBE70E2C7DE9AC83BuLL) >> 0),
    (VUINT32) ((0xBE70E2C7DE9AC83BuLL) >> 32)},
   {(VUINT32) ((0xBFDA247F00000000uLL) >> 0),
    (VUINT32) ((0xBFDA247F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8781011952FB40uLL) >> 0),
    (VUINT32) ((0xBE8781011952FB40uLL) >> 32)},
   {(VUINT32) ((0xBFDA152F00000000uLL) >> 0),
    (VUINT32) ((0xBFDA152F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6794C0EDAF9F16uLL) >> 0),
    (VUINT32) ((0xBE6794C0EDAF9F16uLL) >> 32)},
   {(VUINT32) ((0xBFDA05E100000000uLL) >> 0),
    (VUINT32) ((0xBFDA05E100000000uLL) >> 32)},
   {(VUINT32) ((0xBE77DDF6E9895B08uLL) >> 0),
    (VUINT32) ((0xBE77DDF6E9895B08uLL) >> 32)},
   {(VUINT32) ((0xBFD9F69600000000uLL) >> 0),
    (VUINT32) ((0xBFD9F69600000000uLL) >> 32)},
   {(VUINT32) ((0xBE73AEF455AE3DA8uLL) >> 0),
    (VUINT32) ((0xBE73AEF455AE3DA8uLL) >> 32)},
   {(VUINT32) ((0xBFD9E74D00000000uLL) >> 0),
    (VUINT32) ((0xBFD9E74D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6EAF442C7BA9BEuLL) >> 0),
    (VUINT32) ((0xBE6EAF442C7BA9BEuLL) >> 32)},
   {(VUINT32) ((0xBFD9D80600000000uLL) >> 0),
    (VUINT32) ((0xBFD9D80600000000uLL) >> 32)},
   {(VUINT32) ((0xBE8DC93243F14070uLL) >> 0),
    (VUINT32) ((0xBE8DC93243F14070uLL) >> 32)},
   {(VUINT32) ((0xBFD9C8C300000000uLL) >> 0),
    (VUINT32) ((0xBFD9C8C300000000uLL) >> 32)},
   {(VUINT32) ((0xBE78D1BA7956F02DuLL) >> 0),
    (VUINT32) ((0xBE78D1BA7956F02DuLL) >> 32)},
   {(VUINT32) ((0xBFD9B98100000000uLL) >> 0),
    (VUINT32) ((0xBFD9B98100000000uLL) >> 32)},
   {(VUINT32) ((0xBE8B8C1E78260310uLL) >> 0),
    (VUINT32) ((0xBE8B8C1E78260310uLL) >> 32)},
   {(VUINT32) ((0xBFD9AA4300000000uLL) >> 0),
    (VUINT32) ((0xBFD9AA4300000000uLL) >> 32)},
   {(VUINT32) ((0xBE5CE27FC9D31391uLL) >> 0),
    (VUINT32) ((0xBE5CE27FC9D31391uLL) >> 32)},
   {(VUINT32) ((0xBFD99B0700000000uLL) >> 0),
    (VUINT32) ((0xBFD99B0700000000uLL) >> 32)},
   {(VUINT32) ((0xBE634B6355F4087AuLL) >> 0),
    (VUINT32) ((0xBE634B6355F4087AuLL) >> 32)},
   {(VUINT32) ((0xBFD98BCD00000000uLL) >> 0),
    (VUINT32) ((0xBFD98BCD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6C94B4572FEF43uLL) >> 0),
    (VUINT32) ((0xBE6C94B4572FEF43uLL) >> 32)},
   {(VUINT32) ((0xBFD97C9600000000uLL) >> 0),
    (VUINT32) ((0xBFD97C9600000000uLL) >> 32)},
   {(VUINT32) ((0xBE5846721DE94267uLL) >> 0),
    (VUINT32) ((0xBE5846721DE94267uLL) >> 32)},
   {(VUINT32) ((0xBFD96D6100000000uLL) >> 0),
    (VUINT32) ((0xBFD96D6100000000uLL) >> 32)},
   {(VUINT32) ((0xBE88B74ACDDE1F6AuLL) >> 0),
    (VUINT32) ((0xBE88B74ACDDE1F6AuLL) >> 32)},
   {(VUINT32) ((0xBFD95E2F00000000uLL) >> 0),
    (VUINT32) ((0xBFD95E2F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE801A3E03F6B280uLL) >> 0),
    (VUINT32) ((0xBE801A3E03F6B280uLL) >> 32)},
   {(VUINT32) ((0xBFD94F0000000000uLL) >> 0),
    (VUINT32) ((0xBFD94F0000000000uLL) >> 32)},
   {(VUINT32) ((0xBE4B35095482043FuLL) >> 0),
    (VUINT32) ((0xBE4B35095482043FuLL) >> 32)},
   {(VUINT32) ((0xBFD93FD200000000uLL) >> 0),
    (VUINT32) ((0xBFD93FD200000000uLL) >> 32)},
   {(VUINT32) ((0xBE856437D9BB4A5CuLL) >> 0),
    (VUINT32) ((0xBE856437D9BB4A5CuLL) >> 32)},
   {(VUINT32) ((0xBFD930A800000000uLL) >> 0),
    (VUINT32) ((0xBFD930A800000000uLL) >> 32)},
   {(VUINT32) ((0xBE5DB5B388B06A65uLL) >> 0),
    (VUINT32) ((0xBE5DB5B388B06A65uLL) >> 32)},
   {(VUINT32) ((0xBFD9218000000000uLL) >> 0),
    (VUINT32) ((0xBFD9218000000000uLL) >> 32)},
   {(VUINT32) ((0xBE79C93768C0E5D4uLL) >> 0),
    (VUINT32) ((0xBE79C93768C0E5D4uLL) >> 32)},
   {(VUINT32) ((0xBFD9125A00000000uLL) >> 0),
    (VUINT32) ((0xBFD9125A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE27F0E9D0AAF77AuLL) >> 0),
    (VUINT32) ((0xBE27F0E9D0AAF77AuLL) >> 32)},
   {(VUINT32) ((0xBFD9033700000000uLL) >> 0),
    (VUINT32) ((0xBFD9033700000000uLL) >> 32)},
   {(VUINT32) ((0xBE6E085F7C5942F1uLL) >> 0),
    (VUINT32) ((0xBE6E085F7C5942F1uLL) >> 32)},
   {(VUINT32) ((0xBFD8F41600000000uLL) >> 0),
    (VUINT32) ((0xBFD8F41600000000uLL) >> 32)},
   {(VUINT32) ((0xBE81B98DF5F47569uLL) >> 0),
    (VUINT32) ((0xBE81B98DF5F47569uLL) >> 32)},
   {(VUINT32) ((0xBFD8E4F700000000uLL) >> 0),
    (VUINT32) ((0xBFD8E4F700000000uLL) >> 32)},
   {(VUINT32) ((0xBE8F3428AC4DDEECuLL) >> 0),
    (VUINT32) ((0xBE8F3428AC4DDEECuLL) >> 32)},
   {(VUINT32) ((0xBFD8D5DC00000000uLL) >> 0),
    (VUINT32) ((0xBFD8D5DC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7127EF6092650EuLL) >> 0),
    (VUINT32) ((0xBE7127EF6092650EuLL) >> 32)},
   {(VUINT32) ((0xBFD8C6C300000000uLL) >> 0),
    (VUINT32) ((0xBFD8C6C300000000uLL) >> 32)},
   {(VUINT32) ((0xBE7C262E6C66CDB8uLL) >> 0),
    (VUINT32) ((0xBE7C262E6C66CDB8uLL) >> 32)},
   {(VUINT32) ((0xBFD8B7AC00000000uLL) >> 0),
    (VUINT32) ((0xBFD8B7AC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE876FAFFFF4AF15uLL) >> 0),
    (VUINT32) ((0xBE876FAFFFF4AF15uLL) >> 32)},
   {(VUINT32) ((0xBFD8A89800000000uLL) >> 0),
    (VUINT32) ((0xBFD8A89800000000uLL) >> 32)},
   {(VUINT32) ((0xBE635FDEAD9EF9A2uLL) >> 0),
    (VUINT32) ((0xBE635FDEAD9EF9A2uLL) >> 32)},
   {(VUINT32) ((0xBFD8998600000000uLL) >> 0),
    (VUINT32) ((0xBFD8998600000000uLL) >> 32)},
   {(VUINT32) ((0xBE7DFC6109E45CEBuLL) >> 0),
    (VUINT32) ((0xBE7DFC6109E45CEBuLL) >> 32)},
   {(VUINT32) ((0xBFD88A7600000000uLL) >> 0),
    (VUINT32) ((0xBFD88A7600000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D94A9416E4721uLL) >> 0),
    (VUINT32) ((0xBE8D94A9416E4721uLL) >> 32)},
   {(VUINT32) ((0xBFD87B6900000000uLL) >> 0),
    (VUINT32) ((0xBFD87B6900000000uLL) >> 32)},
   {(VUINT32) ((0xBE80C9BD35322FA9uLL) >> 0),
    (VUINT32) ((0xBE80C9BD35322FA9uLL) >> 32)},
   {(VUINT32) ((0xBFD86C5F00000000uLL) >> 0),
    (VUINT32) ((0xBFD86C5F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE45BD4714C8FFCFuLL) >> 0),
    (VUINT32) ((0xBE45BD4714C8FFCFuLL) >> 32)},
   {(VUINT32) ((0xBFD85D5700000000uLL) >> 0),
    (VUINT32) ((0xBFD85D5700000000uLL) >> 32)},
   {(VUINT32) ((0xBE7F0AC6ABBA5180uLL) >> 0),
    (VUINT32) ((0xBE7F0AC6ABBA5180uLL) >> 32)},
   {(VUINT32) ((0xBFD84E5100000000uLL) >> 0),
    (VUINT32) ((0xBFD84E5100000000uLL) >> 32)},
   {(VUINT32) ((0xBE74A1D4FC76C4E2uLL) >> 0),
    (VUINT32) ((0xBE74A1D4FC76C4E2uLL) >> 32)},
   {(VUINT32) ((0xBFD83F4E00000000uLL) >> 0),
    (VUINT32) ((0xBFD83F4E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE58C7BBD43EA059uLL) >> 0),
    (VUINT32) ((0xBE58C7BBD43EA059uLL) >> 32)},
   {(VUINT32) ((0xBFD8304D00000000uLL) >> 0),
    (VUINT32) ((0xBFD8304D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8A18240481523AuLL) >> 0),
    (VUINT32) ((0xBE8A18240481523AuLL) >> 32)},
   {(VUINT32) ((0xBFD8214E00000000uLL) >> 0),
    (VUINT32) ((0xBFD8214E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8E4115E0E87309uLL) >> 0),
    (VUINT32) ((0xBE8E4115E0E87309uLL) >> 32)},
   {(VUINT32) ((0xBFD8125300000000uLL) >> 0),
    (VUINT32) ((0xBFD8125300000000uLL) >> 32)},
   {(VUINT32) ((0xBE4067FCC9C54454uLL) >> 0),
    (VUINT32) ((0xBE4067FCC9C54454uLL) >> 32)},
   {(VUINT32) ((0xBFD8035A00000000uLL) >> 0),
    (VUINT32) ((0xBFD8035A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5519044060B3CAuLL) >> 0),
    (VUINT32) ((0xBE5519044060B3CAuLL) >> 32)},
   {(VUINT32) ((0xBFD7F46200000000uLL) >> 0),
    (VUINT32) ((0xBFD7F46200000000uLL) >> 32)},
   {(VUINT32) ((0xBE81F1C2BAB3EFA5uLL) >> 0),
    (VUINT32) ((0xBE81F1C2BAB3EFA5uLL) >> 32)},
   {(VUINT32) ((0xBFD7E56E00000000uLL) >> 0),
    (VUINT32) ((0xBFD7E56E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE2F4F8116A92F1FuLL) >> 0),
    (VUINT32) ((0xBE2F4F8116A92F1FuLL) >> 32)},
   {(VUINT32) ((0xBFD7D67C00000000uLL) >> 0),
    (VUINT32) ((0xBFD7D67C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7D00EBAF755412uLL) >> 0),
    (VUINT32) ((0xBE7D00EBAF755412uLL) >> 32)},
   {(VUINT32) ((0xBFD7C78C00000000uLL) >> 0),
    (VUINT32) ((0xBFD7C78C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE757CB332AA9B04uLL) >> 0),
    (VUINT32) ((0xBE757CB332AA9B04uLL) >> 32)},
   {(VUINT32) ((0xBFD7B89F00000000uLL) >> 0),
    (VUINT32) ((0xBFD7B89F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B67957924A221uLL) >> 0),
    (VUINT32) ((0xBE6B67957924A221uLL) >> 32)},
   {(VUINT32) ((0xBFD7A9B400000000uLL) >> 0),
    (VUINT32) ((0xBFD7A9B400000000uLL) >> 32)},
   {(VUINT32) ((0xBE749441F289397FuLL) >> 0),
    (VUINT32) ((0xBE749441F289397FuLL) >> 32)},
   {(VUINT32) ((0xBFD79ACB00000000uLL) >> 0),
    (VUINT32) ((0xBFD79ACB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE853E207739B243uLL) >> 0),
    (VUINT32) ((0xBE853E207739B243uLL) >> 32)},
   {(VUINT32) ((0xBFD78BE500000000uLL) >> 0),
    (VUINT32) ((0xBFD78BE500000000uLL) >> 32)},
   {(VUINT32) ((0xBE6F940FB688810DuLL) >> 0),
    (VUINT32) ((0xBE6F940FB688810DuLL) >> 32)},
   {(VUINT32) ((0xBFD77D0100000000uLL) >> 0),
    (VUINT32) ((0xBFD77D0100000000uLL) >> 32)},
   {(VUINT32) ((0xBE8B3DF7AD1F744BuLL) >> 0),
    (VUINT32) ((0xBE8B3DF7AD1F744BuLL) >> 32)},
   {(VUINT32) ((0xBFD76E2000000000uLL) >> 0),
    (VUINT32) ((0xBFD76E2000000000uLL) >> 32)},
   {(VUINT32) ((0xBE86B033AD082BC9uLL) >> 0),
    (VUINT32) ((0xBE86B033AD082BC9uLL) >> 32)},
   {(VUINT32) ((0xBFD75F4100000000uLL) >> 0),
    (VUINT32) ((0xBFD75F4100000000uLL) >> 32)},
   {(VUINT32) ((0xBE8A6AFC121884DAuLL) >> 0),
    (VUINT32) ((0xBE8A6AFC121884DAuLL) >> 32)},
   {(VUINT32) ((0xBFD7506500000000uLL) >> 0),
    (VUINT32) ((0xBFD7506500000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A7683B47C1884uLL) >> 0),
    (VUINT32) ((0xBE6A7683B47C1884uLL) >> 32)},
   {(VUINT32) ((0xBFD7418A00000000uLL) >> 0),
    (VUINT32) ((0xBFD7418A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8B777E34575FD6uLL) >> 0),
    (VUINT32) ((0xBE8B777E34575FD6uLL) >> 32)},
   {(VUINT32) ((0xBFD732B200000000uLL) >> 0),
    (VUINT32) ((0xBFD732B200000000uLL) >> 32)},
   {(VUINT32) ((0xBE8927FBBCB9EE5DuLL) >> 0),
    (VUINT32) ((0xBE8927FBBCB9EE5DuLL) >> 32)},
   {(VUINT32) ((0xBFD723DD00000000uLL) >> 0),
    (VUINT32) ((0xBFD723DD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE88C68D7090566BuLL) >> 0),
    (VUINT32) ((0xBE88C68D7090566BuLL) >> 32)},
   {(VUINT32) ((0xBFD7150B00000000uLL) >> 0),
    (VUINT32) ((0xBFD7150B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4A2B2A2A0EB191uLL) >> 0),
    (VUINT32) ((0xBE4A2B2A2A0EB191uLL) >> 32)},
   {(VUINT32) ((0xBFD7063900000000uLL) >> 0),
    (VUINT32) ((0xBFD7063900000000uLL) >> 32)},
   {(VUINT32) ((0xBE8AFBF68DE6383BuLL) >> 0),
    (VUINT32) ((0xBE8AFBF68DE6383BuLL) >> 32)},
   {(VUINT32) ((0xBFD6F76B00000000uLL) >> 0),
    (VUINT32) ((0xBFD6F76B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE86DDF093045EA8uLL) >> 0),
    (VUINT32) ((0xBE86DDF093045EA8uLL) >> 32)},
   {(VUINT32) ((0xBFD6E89F00000000uLL) >> 0),
    (VUINT32) ((0xBFD6E89F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8C8C435CC0756EuLL) >> 0),
    (VUINT32) ((0xBE8C8C435CC0756EuLL) >> 32)},
   {(VUINT32) ((0xBFD6D9D600000000uLL) >> 0),
    (VUINT32) ((0xBFD6D9D600000000uLL) >> 32)},
   {(VUINT32) ((0xBE786D3AE8F9661FuLL) >> 0),
    (VUINT32) ((0xBE786D3AE8F9661FuLL) >> 32)},
   {(VUINT32) ((0xBFD6CB0F00000000uLL) >> 0),
    (VUINT32) ((0xBFD6CB0F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6832E43F6D9D88uLL) >> 0),
    (VUINT32) ((0xBE6832E43F6D9D88uLL) >> 32)},
   {(VUINT32) ((0xBFD6BC4A00000000uLL) >> 0),
    (VUINT32) ((0xBFD6BC4A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE747CB81361877FuLL) >> 0),
    (VUINT32) ((0xBE747CB81361877FuLL) >> 32)},
   {(VUINT32) ((0xBFD6AD8800000000uLL) >> 0),
    (VUINT32) ((0xBFD6AD8800000000uLL) >> 32)},
   {(VUINT32) ((0xBE82035808F1C0F3uLL) >> 0),
    (VUINT32) ((0xBE82035808F1C0F3uLL) >> 32)},
   {(VUINT32) ((0xBFD69EC800000000uLL) >> 0),
    (VUINT32) ((0xBFD69EC800000000uLL) >> 32)},
   {(VUINT32) ((0xBE76FF1399DB6922uLL) >> 0),
    (VUINT32) ((0xBE76FF1399DB6922uLL) >> 32)},
   {(VUINT32) ((0xBFD6900A00000000uLL) >> 0),
    (VUINT32) ((0xBFD6900A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7FCDB431863DD3uLL) >> 0),
    (VUINT32) ((0xBE7FCDB431863DD3uLL) >> 32)},
   {(VUINT32) ((0xBFD6814E00000000uLL) >> 0),
    (VUINT32) ((0xBFD6814E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8F693D13FBB8D9uLL) >> 0),
    (VUINT32) ((0xBE8F693D13FBB8D9uLL) >> 32)},
   {(VUINT32) ((0xBFD6729600000000uLL) >> 0),
    (VUINT32) ((0xBFD6729600000000uLL) >> 32)},
   {(VUINT32) ((0xBE834EB29036FAD3uLL) >> 0),
    (VUINT32) ((0xBE834EB29036FAD3uLL) >> 32)},
   {(VUINT32) ((0xBFD663DF00000000uLL) >> 0),
    (VUINT32) ((0xBFD663DF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE899B456A12CE2EuLL) >> 0),
    (VUINT32) ((0xBE899B456A12CE2EuLL) >> 32)},
   {(VUINT32) ((0xBFD6552B00000000uLL) >> 0),
    (VUINT32) ((0xBFD6552B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE772618A503C189uLL) >> 0),
    (VUINT32) ((0xBE772618A503C189uLL) >> 32)},
   {(VUINT32) ((0xBFD6467900000000uLL) >> 0),
    (VUINT32) ((0xBFD6467900000000uLL) >> 32)},
   {(VUINT32) ((0xBE72CC529275C5A3uLL) >> 0),
    (VUINT32) ((0xBE72CC529275C5A3uLL) >> 32)},
   {(VUINT32) ((0xBFD637C900000000uLL) >> 0),
    (VUINT32) ((0xBFD637C900000000uLL) >> 32)},
   {(VUINT32) ((0xBE8344C9B19A2513uLL) >> 0),
    (VUINT32) ((0xBE8344C9B19A2513uLL) >> 32)},
   {(VUINT32) ((0xBFD6291C00000000uLL) >> 0),
    (VUINT32) ((0xBFD6291C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE72BE4C963D47B8uLL) >> 0),
    (VUINT32) ((0xBE72BE4C963D47B8uLL) >> 32)},
   {(VUINT32) ((0xBFD61A7100000000uLL) >> 0),
    (VUINT32) ((0xBFD61A7100000000uLL) >> 32)},
   {(VUINT32) ((0xBE77CB0653B68DE6uLL) >> 0),
    (VUINT32) ((0xBE77CB0653B68DE6uLL) >> 32)},
   {(VUINT32) ((0xBFD60BC800000000uLL) >> 0),
    (VUINT32) ((0xBFD60BC800000000uLL) >> 32)},
   {(VUINT32) ((0xBE8B082FAEDC50D1uLL) >> 0),
    (VUINT32) ((0xBE8B082FAEDC50D1uLL) >> 32)},
   {(VUINT32) ((0xBFD5FD2200000000uLL) >> 0),
    (VUINT32) ((0xBFD5FD2200000000uLL) >> 32)},
   {(VUINT32) ((0xBE86F7868080F7BCuLL) >> 0),
    (VUINT32) ((0xBE86F7868080F7BCuLL) >> 32)},
   {(VUINT32) ((0xBFD5EE7E00000000uLL) >> 0),
    (VUINT32) ((0xBFD5EE7E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A9FB569E79A60uLL) >> 0),
    (VUINT32) ((0xBE6A9FB569E79A60uLL) >> 32)},
   {(VUINT32) ((0xBFD5DFDC00000000uLL) >> 0),
    (VUINT32) ((0xBFD5DFDC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8CBDD5BF453A04uLL) >> 0),
    (VUINT32) ((0xBE8CBDD5BF453A04uLL) >> 32)},
   {(VUINT32) ((0xBFD5D13D00000000uLL) >> 0),
    (VUINT32) ((0xBFD5D13D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6BB6EE545183DCuLL) >> 0),
    (VUINT32) ((0xBE6BB6EE545183DCuLL) >> 32)},
   {(VUINT32) ((0xBFD5C2A000000000uLL) >> 0),
    (VUINT32) ((0xBFD5C2A000000000uLL) >> 32)},
   {(VUINT32) ((0xBE87EC26C29AA221uLL) >> 0),
    (VUINT32) ((0xBE87EC26C29AA221uLL) >> 32)},
   {(VUINT32) ((0xBFD5B40500000000uLL) >> 0),
    (VUINT32) ((0xBFD5B40500000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D5DA983E3CBEDuLL) >> 0),
    (VUINT32) ((0xBE8D5DA983E3CBEDuLL) >> 32)},
   {(VUINT32) ((0xBFD5A56D00000000uLL) >> 0),
    (VUINT32) ((0xBFD5A56D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE80B6E1BFE5EC04uLL) >> 0),
    (VUINT32) ((0xBE80B6E1BFE5EC04uLL) >> 32)},
   {(VUINT32) ((0xBFD596D700000000uLL) >> 0),
    (VUINT32) ((0xBFD596D700000000uLL) >> 32)},
   {(VUINT32) ((0xBE8228784608B2DFuLL) >> 0),
    (VUINT32) ((0xBE8228784608B2DFuLL) >> 32)},
   {(VUINT32) ((0xBFD5884300000000uLL) >> 0),
    (VUINT32) ((0xBFD5884300000000uLL) >> 32)},
   {(VUINT32) ((0xBE7116419622027EuLL) >> 0),
    (VUINT32) ((0xBE7116419622027EuLL) >> 32)},
   {(VUINT32) ((0xBFD579B200000000uLL) >> 0),
    (VUINT32) ((0xBFD579B200000000uLL) >> 32)},
   {(VUINT32) ((0xBE6AEE6A38F29592uLL) >> 0),
    (VUINT32) ((0xBE6AEE6A38F29592uLL) >> 32)},
   {(VUINT32) ((0xBFD56B2200000000uLL) >> 0),
    (VUINT32) ((0xBFD56B2200000000uLL) >> 32)},
   {(VUINT32) ((0xBE8A36AF180D0F15uLL) >> 0),
    (VUINT32) ((0xBE8A36AF180D0F15uLL) >> 32)},
   {(VUINT32) ((0xBFD55C9500000000uLL) >> 0),
    (VUINT32) ((0xBFD55C9500000000uLL) >> 32)},
   {(VUINT32) ((0xBE8C853372CA57CCuLL) >> 0),
    (VUINT32) ((0xBE8C853372CA57CCuLL) >> 32)},
   {(VUINT32) ((0xBFD54E0B00000000uLL) >> 0),
    (VUINT32) ((0xBFD54E0B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7BB00EE04486C4uLL) >> 0),
    (VUINT32) ((0xBE7BB00EE04486C4uLL) >> 32)},
   {(VUINT32) ((0xBFD53F8300000000uLL) >> 0),
    (VUINT32) ((0xBFD53F8300000000uLL) >> 32)},
   {(VUINT32) ((0xBE7CC02B891628DAuLL) >> 0),
    (VUINT32) ((0xBE7CC02B891628DAuLL) >> 32)},
   {(VUINT32) ((0xBFD530FD00000000uLL) >> 0),
    (VUINT32) ((0xBFD530FD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE63794FE93C7F63uLL) >> 0),
    (VUINT32) ((0xBE63794FE93C7F63uLL) >> 32)},
   {(VUINT32) ((0xBFD5227900000000uLL) >> 0),
    (VUINT32) ((0xBFD5227900000000uLL) >> 32)},
   {(VUINT32) ((0xBE75D7854E0DE2C5uLL) >> 0),
    (VUINT32) ((0xBE75D7854E0DE2C5uLL) >> 32)},
   {(VUINT32) ((0xBFD513F800000000uLL) >> 0),
    (VUINT32) ((0xBFD513F800000000uLL) >> 32)},
   {(VUINT32) ((0xBE372DA45519DCE0uLL) >> 0),
    (VUINT32) ((0xBE372DA45519DCE0uLL) >> 32)},
   {(VUINT32) ((0xBFD5057800000000uLL) >> 0),
    (VUINT32) ((0xBFD5057800000000uLL) >> 32)},
   {(VUINT32) ((0xBE79F8D2DA727BF4uLL) >> 0),
    (VUINT32) ((0xBE79F8D2DA727BF4uLL) >> 32)},
   {(VUINT32) ((0xBFD4F6FC00000000uLL) >> 0),
    (VUINT32) ((0xBFD4F6FC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE56CEC60358C3FDuLL) >> 0),
    (VUINT32) ((0xBE56CEC60358C3FDuLL) >> 32)},
   {(VUINT32) ((0xBFD4E88000000000uLL) >> 0),
    (VUINT32) ((0xBFD4E88000000000uLL) >> 32)},
   {(VUINT32) ((0xBE8602E65C350140uLL) >> 0),
    (VUINT32) ((0xBE8602E65C350140uLL) >> 32)},
   {(VUINT32) ((0xBFD4DA0800000000uLL) >> 0),
    (VUINT32) ((0xBFD4DA0800000000uLL) >> 32)},
   {(VUINT32) ((0xBE8328C92737A9B0uLL) >> 0),
    (VUINT32) ((0xBE8328C92737A9B0uLL) >> 32)},
   {(VUINT32) ((0xBFD4CB9200000000uLL) >> 0),
    (VUINT32) ((0xBFD4CB9200000000uLL) >> 32)},
   {(VUINT32) ((0xBE6DC3078767B5B5uLL) >> 0),
    (VUINT32) ((0xBE6DC3078767B5B5uLL) >> 32)},
   {(VUINT32) ((0xBFD4BD1E00000000uLL) >> 0),
    (VUINT32) ((0xBFD4BD1E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE79203927CD12CCuLL) >> 0),
    (VUINT32) ((0xBE79203927CD12CCuLL) >> 32)},
   {(VUINT32) ((0xBFD4AEAD00000000uLL) >> 0),
    (VUINT32) ((0xBFD4AEAD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE55C17DA1B07B42uLL) >> 0),
    (VUINT32) ((0xBE55C17DA1B07B42uLL) >> 32)},
   {(VUINT32) ((0xBFD4A03D00000000uLL) >> 0),
    (VUINT32) ((0xBFD4A03D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE80825C25CBDDA8uLL) >> 0),
    (VUINT32) ((0xBE80825C25CBDDA8uLL) >> 32)},
   {(VUINT32) ((0xBFD491D000000000uLL) >> 0),
    (VUINT32) ((0xBFD491D000000000uLL) >> 32)},
   {(VUINT32) ((0xBE7F601BA1CB823BuLL) >> 0),
    (VUINT32) ((0xBE7F601BA1CB823BuLL) >> 32)},
   {(VUINT32) ((0xBFD4836600000000uLL) >> 0),
    (VUINT32) ((0xBFD4836600000000uLL) >> 32)},
   {(VUINT32) ((0xBE2CAEBE06773E1BuLL) >> 0),
    (VUINT32) ((0xBE2CAEBE06773E1BuLL) >> 32)},
   {(VUINT32) ((0xBFD474FD00000000uLL) >> 0),
    (VUINT32) ((0xBFD474FD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE72AFC887224809uLL) >> 0),
    (VUINT32) ((0xBE72AFC887224809uLL) >> 32)},
   {(VUINT32) ((0xBFD4669700000000uLL) >> 0),
    (VUINT32) ((0xBFD4669700000000uLL) >> 32)},
   {(VUINT32) ((0xBE60B454DABABFEEuLL) >> 0),
    (VUINT32) ((0xBE60B454DABABFEEuLL) >> 32)},
   {(VUINT32) ((0xBFD4583200000000uLL) >> 0),
    (VUINT32) ((0xBFD4583200000000uLL) >> 32)},
   {(VUINT32) ((0xBE8777E382EF584FuLL) >> 0),
    (VUINT32) ((0xBE8777E382EF584FuLL) >> 32)},
   {(VUINT32) ((0xBFD449D000000000uLL) >> 0),
    (VUINT32) ((0xBFD449D000000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D0DEFA65E43F7uLL) >> 0),
    (VUINT32) ((0xBE8D0DEFA65E43F7uLL) >> 32)},
   {(VUINT32) ((0xBFD43B7100000000uLL) >> 0),
    (VUINT32) ((0xBFD43B7100000000uLL) >> 32)},
   {(VUINT32) ((0xBE8520E465F01125uLL) >> 0),
    (VUINT32) ((0xBE8520E465F01125uLL) >> 32)},
   {(VUINT32) ((0xBFD42D1400000000uLL) >> 0),
    (VUINT32) ((0xBFD42D1400000000uLL) >> 32)},
   {(VUINT32) ((0xBE68A9DB3066F3ADuLL) >> 0),
    (VUINT32) ((0xBE68A9DB3066F3ADuLL) >> 32)},
   {(VUINT32) ((0xBFD41EB900000000uLL) >> 0),
    (VUINT32) ((0xBFD41EB900000000uLL) >> 32)},
   {(VUINT32) ((0xBE7418CD285C77E6uLL) >> 0),
    (VUINT32) ((0xBE7418CD285C77E6uLL) >> 32)},
   {(VUINT32) ((0xBFD4106000000000uLL) >> 0),
    (VUINT32) ((0xBFD4106000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6CE1F66985CEA7uLL) >> 0),
    (VUINT32) ((0xBE6CE1F66985CEA7uLL) >> 32)},
   {(VUINT32) ((0xBFD4020900000000uLL) >> 0),
    (VUINT32) ((0xBFD4020900000000uLL) >> 32)},
   {(VUINT32) ((0xBE8798904973EF89uLL) >> 0),
    (VUINT32) ((0xBE8798904973EF89uLL) >> 32)},
   {(VUINT32) ((0xBFD3F3B500000000uLL) >> 0),
    (VUINT32) ((0xBFD3F3B500000000uLL) >> 32)},
   {(VUINT32) ((0xBE4967D2AB8251D8uLL) >> 0),
    (VUINT32) ((0xBE4967D2AB8251D8uLL) >> 32)},
   {(VUINT32) ((0xBFD3E56200000000uLL) >> 0),
    (VUINT32) ((0xBFD3E56200000000uLL) >> 32)},
   {(VUINT32) ((0xBE8F242D496E3D08uLL) >> 0),
    (VUINT32) ((0xBE8F242D496E3D08uLL) >> 32)},
   {(VUINT32) ((0xBFD3D71200000000uLL) >> 0),
    (VUINT32) ((0xBFD3D71200000000uLL) >> 32)},
   {(VUINT32) ((0xBE86A393BBA964C4uLL) >> 0),
    (VUINT32) ((0xBE86A393BBA964C4uLL) >> 32)},
   {(VUINT32) ((0xBFD3C8C500000000uLL) >> 0),
    (VUINT32) ((0xBFD3C8C500000000uLL) >> 32)},
   {(VUINT32) ((0xBE507570CACEF7BFuLL) >> 0),
    (VUINT32) ((0xBE507570CACEF7BFuLL) >> 32)},
   {(VUINT32) ((0xBFD3BA7900000000uLL) >> 0),
    (VUINT32) ((0xBFD3BA7900000000uLL) >> 32)},
   {(VUINT32) ((0xBE6EFE0FA4F69A96uLL) >> 0),
    (VUINT32) ((0xBE6EFE0FA4F69A96uLL) >> 32)},
   {(VUINT32) ((0xBFD3AC3000000000uLL) >> 0),
    (VUINT32) ((0xBFD3AC3000000000uLL) >> 32)},
   {(VUINT32) ((0xBE4B827373E0A286uLL) >> 0),
    (VUINT32) ((0xBE4B827373E0A286uLL) >> 32)},
   {(VUINT32) ((0xBFD39DE800000000uLL) >> 0),
    (VUINT32) ((0xBFD39DE800000000uLL) >> 32)},
   {(VUINT32) ((0xBE864AB3E2FB43D9uLL) >> 0),
    (VUINT32) ((0xBE864AB3E2FB43D9uLL) >> 32)},
   {(VUINT32) ((0xBFD38FA300000000uLL) >> 0),
    (VUINT32) ((0xBFD38FA300000000uLL) >> 32)},
   {(VUINT32) ((0xBE8F81504EB31318uLL) >> 0),
    (VUINT32) ((0xBE8F81504EB31318uLL) >> 32)},
   {(VUINT32) ((0xBFD3816100000000uLL) >> 0),
    (VUINT32) ((0xBFD3816100000000uLL) >> 32)},
   {(VUINT32) ((0xBE5D3164FB917590uLL) >> 0),
    (VUINT32) ((0xBE5D3164FB917590uLL) >> 32)},
   {(VUINT32) ((0xBFD3732000000000uLL) >> 0),
    (VUINT32) ((0xBFD3732000000000uLL) >> 32)},
   {(VUINT32) ((0xBE8CCB836B329F7FuLL) >> 0),
    (VUINT32) ((0xBE8CCB836B329F7FuLL) >> 32)},
   {(VUINT32) ((0xBFD364E200000000uLL) >> 0),
    (VUINT32) ((0xBFD364E200000000uLL) >> 32)},
   {(VUINT32) ((0xBE8133990D5010C8uLL) >> 0),
    (VUINT32) ((0xBE8133990D5010C8uLL) >> 32)},
   {(VUINT32) ((0xBFD356A600000000uLL) >> 0),
    (VUINT32) ((0xBFD356A600000000uLL) >> 32)},
   {(VUINT32) ((0xBE404BC113420455uLL) >> 0),
    (VUINT32) ((0xBE404BC113420455uLL) >> 32)},
   {(VUINT32) ((0xBFD3486C00000000uLL) >> 0),
    (VUINT32) ((0xBFD3486C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE697514CF0A57DCuLL) >> 0),
    (VUINT32) ((0xBE697514CF0A57DCuLL) >> 32)},
   {(VUINT32) ((0xBFD33A3400000000uLL) >> 0),
    (VUINT32) ((0xBFD33A3400000000uLL) >> 32)},
   {(VUINT32) ((0xBE6DCE5B769A0EB8uLL) >> 0),
    (VUINT32) ((0xBE6DCE5B769A0EB8uLL) >> 32)},
   {(VUINT32) ((0xBFD32BFE00000000uLL) >> 0),
    (VUINT32) ((0xBFD32BFE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8E6E1DD018CC95uLL) >> 0),
    (VUINT32) ((0xBE8E6E1DD018CC95uLL) >> 32)},
   {(VUINT32) ((0xBFD31DCB00000000uLL) >> 0),
    (VUINT32) ((0xBFD31DCB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE817B505F20E7F3uLL) >> 0),
    (VUINT32) ((0xBE817B505F20E7F3uLL) >> 32)},
   {(VUINT32) ((0xBFD30F9A00000000uLL) >> 0),
    (VUINT32) ((0xBFD30F9A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3835DF86199AB1uLL) >> 0),
    (VUINT32) ((0xBE3835DF86199AB1uLL) >> 32)},
   {(VUINT32) ((0xBFD3016B00000000uLL) >> 0),
    (VUINT32) ((0xBFD3016B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE69CF10D769BDDBuLL) >> 0),
    (VUINT32) ((0xBE69CF10D769BDDBuLL) >> 32)},
   {(VUINT32) ((0xBFD2F33E00000000uLL) >> 0),
    (VUINT32) ((0xBFD2F33E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7168482A60BB7CuLL) >> 0),
    (VUINT32) ((0xBE7168482A60BB7CuLL) >> 32)},
   {(VUINT32) ((0xBFD2E51400000000uLL) >> 0),
    (VUINT32) ((0xBFD2E51400000000uLL) >> 32)},
   {(VUINT32) ((0xBE4BD6CDF5BCF5C4uLL) >> 0),
    (VUINT32) ((0xBE4BD6CDF5BCF5C4uLL) >> 32)},
   {(VUINT32) ((0xBFD2D6EA00000000uLL) >> 0),
    (VUINT32) ((0xBFD2D6EA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D924633FFF084uLL) >> 0),
    (VUINT32) ((0xBE8D924633FFF084uLL) >> 32)},
   {(VUINT32) ((0xBFD2C8C500000000uLL) >> 0),
    (VUINT32) ((0xBFD2C8C500000000uLL) >> 32)},
   {(VUINT32) ((0xBE7542C49A05EE8FuLL) >> 0),
    (VUINT32) ((0xBE7542C49A05EE8FuLL) >> 32)},
   {(VUINT32) ((0xBFD2BAA000000000uLL) >> 0),
    (VUINT32) ((0xBFD2BAA000000000uLL) >> 32)},
   {(VUINT32) ((0xBE8AC97C411279DBuLL) >> 0),
    (VUINT32) ((0xBE8AC97C411279DBuLL) >> 32)},
   {(VUINT32) ((0xBFD2AC7F00000000uLL) >> 0),
    (VUINT32) ((0xBFD2AC7F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE536ACCE9910BF7uLL) >> 0),
    (VUINT32) ((0xBE536ACCE9910BF7uLL) >> 32)},
   {(VUINT32) ((0xBFD29E5F00000000uLL) >> 0),
    (VUINT32) ((0xBFD29E5F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6E5F25492F16F4uLL) >> 0),
    (VUINT32) ((0xBE6E5F25492F16F4uLL) >> 32)},
   {(VUINT32) ((0xBFD2904100000000uLL) >> 0),
    (VUINT32) ((0xBFD2904100000000uLL) >> 32)},
   {(VUINT32) ((0xBE74DF4847FE96F4uLL) >> 0),
    (VUINT32) ((0xBE74DF4847FE96F4uLL) >> 32)},
   {(VUINT32) ((0xBFD2822500000000uLL) >> 0),
    (VUINT32) ((0xBFD2822500000000uLL) >> 32)},
   {(VUINT32) ((0xBE763798F43090EBuLL) >> 0),
    (VUINT32) ((0xBE763798F43090EBuLL) >> 32)},
   {(VUINT32) ((0xBFD2740C00000000uLL) >> 0),
    (VUINT32) ((0xBFD2740C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5FB975AD3295A5uLL) >> 0),
    (VUINT32) ((0xBE5FB975AD3295A5uLL) >> 32)},
   {(VUINT32) ((0xBFD265F400000000uLL) >> 0),
    (VUINT32) ((0xBFD265F400000000uLL) >> 32)},
   {(VUINT32) ((0xBE8AFCC065467993uLL) >> 0),
    (VUINT32) ((0xBE8AFCC065467993uLL) >> 32)},
   {(VUINT32) ((0xBFD257E000000000uLL) >> 0),
    (VUINT32) ((0xBFD257E000000000uLL) >> 32)},
   {(VUINT32) ((0xBE751F024A4452FEuLL) >> 0),
    (VUINT32) ((0xBE751F024A4452FEuLL) >> 32)},
   {(VUINT32) ((0xBFD249CC00000000uLL) >> 0),
    (VUINT32) ((0xBFD249CC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8E6279A0249A31uLL) >> 0),
    (VUINT32) ((0xBE8E6279A0249A31uLL) >> 32)},
   {(VUINT32) ((0xBFD23BBC00000000uLL) >> 0),
    (VUINT32) ((0xBFD23BBC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7631798BCDA203uLL) >> 0),
    (VUINT32) ((0xBE7631798BCDA203uLL) >> 32)},
   {(VUINT32) ((0xBFD22DAD00000000uLL) >> 0),
    (VUINT32) ((0xBFD22DAD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE869D668FF512CDuLL) >> 0),
    (VUINT32) ((0xBE869D668FF512CDuLL) >> 32)},
   {(VUINT32) ((0xBFD21FA100000000uLL) >> 0),
    (VUINT32) ((0xBFD21FA100000000uLL) >> 32)},
   {(VUINT32) ((0xBE4179CAE9BEEE0DuLL) >> 0),
    (VUINT32) ((0xBE4179CAE9BEEE0DuLL) >> 32)},
   {(VUINT32) ((0xBFD2119700000000uLL) >> 0),
    (VUINT32) ((0xBFD2119700000000uLL) >> 32)},
   {(VUINT32) ((0xBE63FA3A108EC52DuLL) >> 0),
    (VUINT32) ((0xBE63FA3A108EC52DuLL) >> 32)},
   {(VUINT32) ((0xBFD2038E00000000uLL) >> 0),
    (VUINT32) ((0xBFD2038E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7BBAE8D6FB8A1CuLL) >> 0),
    (VUINT32) ((0xBE7BBAE8D6FB8A1CuLL) >> 32)},
   {(VUINT32) ((0xBFD1F58800000000uLL) >> 0),
    (VUINT32) ((0xBFD1F58800000000uLL) >> 32)},
   {(VUINT32) ((0xBE807F90E4C2EC69uLL) >> 0),
    (VUINT32) ((0xBE807F90E4C2EC69uLL) >> 32)},
   {(VUINT32) ((0xBFD1E78400000000uLL) >> 0),
    (VUINT32) ((0xBFD1E78400000000uLL) >> 32)},
   {(VUINT32) ((0xBE82BC2F5BABE119uLL) >> 0),
    (VUINT32) ((0xBE82BC2F5BABE119uLL) >> 32)},
   {(VUINT32) ((0xBFD1D98200000000uLL) >> 0),
    (VUINT32) ((0xBFD1D98200000000uLL) >> 32)},
   {(VUINT32) ((0xBE84BAA4D8E71F1CuLL) >> 0),
    (VUINT32) ((0xBE84BAA4D8E71F1CuLL) >> 32)},
   {(VUINT32) ((0xBFD1CB8200000000uLL) >> 0),
    (VUINT32) ((0xBFD1CB8200000000uLL) >> 32)},
   {(VUINT32) ((0xBE86A24FC7020B2BuLL) >> 0),
    (VUINT32) ((0xBE86A24FC7020B2BuLL) >> 32)},
   {(VUINT32) ((0xBFD1BD8500000000uLL) >> 0),
    (VUINT32) ((0xBFD1BD8500000000uLL) >> 32)},
   {(VUINT32) ((0xBE8302982DFE3735uLL) >> 0),
    (VUINT32) ((0xBE8302982DFE3735uLL) >> 32)},
   {(VUINT32) ((0xBFD1AF8900000000uLL) >> 0),
    (VUINT32) ((0xBFD1AF8900000000uLL) >> 32)},
   {(VUINT32) ((0xBE8536EECE3209FAuLL) >> 0),
    (VUINT32) ((0xBE8536EECE3209FAuLL) >> 32)},
   {(VUINT32) ((0xBFD1A19000000000uLL) >> 0),
    (VUINT32) ((0xBFD1A19000000000uLL) >> 32)},
   {(VUINT32) ((0xBE823ACE8FC13621uLL) >> 0),
    (VUINT32) ((0xBE823ACE8FC13621uLL) >> 32)},
   {(VUINT32) ((0xBFD1939900000000uLL) >> 0),
    (VUINT32) ((0xBFD1939900000000uLL) >> 32)},
   {(VUINT32) ((0xBE7F9B761181CC82uLL) >> 0),
    (VUINT32) ((0xBE7F9B761181CC82uLL) >> 32)},
   {(VUINT32) ((0xBFD185A400000000uLL) >> 0),
    (VUINT32) ((0xBFD185A400000000uLL) >> 32)},
   {(VUINT32) ((0xBE7C2E82ADD30FBFuLL) >> 0),
    (VUINT32) ((0xBE7C2E82ADD30FBFuLL) >> 32)},
   {(VUINT32) ((0xBFD177B100000000uLL) >> 0),
    (VUINT32) ((0xBFD177B100000000uLL) >> 32)},
   {(VUINT32) ((0xBE7A7DEFB44845FCuLL) >> 0),
    (VUINT32) ((0xBE7A7DEFB44845FCuLL) >> 32)},
   {(VUINT32) ((0xBFD169C000000000uLL) >> 0),
    (VUINT32) ((0xBFD169C000000000uLL) >> 32)},
   {(VUINT32) ((0xBE7AD8FC5EFE4B5FuLL) >> 0),
    (VUINT32) ((0xBE7AD8FC5EFE4B5FuLL) >> 32)},
   {(VUINT32) ((0xBFD15BD100000000uLL) >> 0),
    (VUINT32) ((0xBFD15BD100000000uLL) >> 32)},
   {(VUINT32) ((0xBE7D8EFA5836733AuLL) >> 0),
    (VUINT32) ((0xBE7D8EFA5836733AuLL) >> 32)},
   {(VUINT32) ((0xBFD14DE400000000uLL) >> 0),
    (VUINT32) ((0xBFD14DE400000000uLL) >> 32)},
   {(VUINT32) ((0xBE8177A6D8101FB8uLL) >> 0),
    (VUINT32) ((0xBE8177A6D8101FB8uLL) >> 32)},
   {(VUINT32) ((0xBFD13FFA00000000uLL) >> 0),
    (VUINT32) ((0xBFD13FFA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8030B69AB39BD3uLL) >> 0),
    (VUINT32) ((0xBE8030B69AB39BD3uLL) >> 32)},
   {(VUINT32) ((0xBFD1321100000000uLL) >> 0),
    (VUINT32) ((0xBFD1321100000000uLL) >> 32)},
   {(VUINT32) ((0xBE86067085D42483uLL) >> 0),
    (VUINT32) ((0xBE86067085D42483uLL) >> 32)},
   {(VUINT32) ((0xBFD1242A00000000uLL) >> 0),
    (VUINT32) ((0xBFD1242A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8DA8A239A3D693uLL) >> 0),
    (VUINT32) ((0xBE8DA8A239A3D693uLL) >> 32)},
   {(VUINT32) ((0xBFD1164700000000uLL) >> 0),
    (VUINT32) ((0xBFD1164700000000uLL) >> 32)},
   {(VUINT32) ((0xBE4D72294066A603uLL) >> 0),
    (VUINT32) ((0xBE4D72294066A603uLL) >> 32)},
   {(VUINT32) ((0xBFD1086400000000uLL) >> 0),
    (VUINT32) ((0xBFD1086400000000uLL) >> 32)},
   {(VUINT32) ((0xBE7B1BA1DC449B96uLL) >> 0),
    (VUINT32) ((0xBE7B1BA1DC449B96uLL) >> 32)},
   {(VUINT32) ((0xBFD0FA8400000000uLL) >> 0),
    (VUINT32) ((0xBFD0FA8400000000uLL) >> 32)},
   {(VUINT32) ((0xBE862896725DE3DDuLL) >> 0),
    (VUINT32) ((0xBE862896725DE3DDuLL) >> 32)},
   {(VUINT32) ((0xBFD0ECA600000000uLL) >> 0),
    (VUINT32) ((0xBFD0ECA600000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A4D928A11E457uLL) >> 0),
    (VUINT32) ((0xBE6A4D928A11E457uLL) >> 32)},
   {(VUINT32) ((0xBFD0DECA00000000uLL) >> 0),
    (VUINT32) ((0xBFD0DECA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE843A36B9D55575uLL) >> 0),
    (VUINT32) ((0xBE843A36B9D55575uLL) >> 32)},
   {(VUINT32) ((0xBFD0D0F000000000uLL) >> 0),
    (VUINT32) ((0xBFD0D0F000000000uLL) >> 32)},
   {(VUINT32) ((0xBE73F2208D19FE75uLL) >> 0),
    (VUINT32) ((0xBE73F2208D19FE75uLL) >> 32)},
   {(VUINT32) ((0xBFD0C31800000000uLL) >> 0),
    (VUINT32) ((0xBFD0C31800000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D4BFE81A344C0uLL) >> 0),
    (VUINT32) ((0xBE8D4BFE81A344C0uLL) >> 32)},
   {(VUINT32) ((0xBFD0B54200000000uLL) >> 0),
    (VUINT32) ((0xBFD0B54200000000uLL) >> 32)},
   {(VUINT32) ((0xBE88FF16F1F6621DuLL) >> 0),
    (VUINT32) ((0xBE88FF16F1F6621DuLL) >> 32)},
   {(VUINT32) ((0xBFD0A76F00000000uLL) >> 0),
    (VUINT32) ((0xBFD0A76F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE829E78B22B06AAuLL) >> 0),
    (VUINT32) ((0xBE829E78B22B06AAuLL) >> 32)},
   {(VUINT32) ((0xBFD0999D00000000uLL) >> 0),
    (VUINT32) ((0xBFD0999D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE84E64B365FEC9AuLL) >> 0),
    (VUINT32) ((0xBE84E64B365FEC9AuLL) >> 32)},
   {(VUINT32) ((0xBFD08BCD00000000uLL) >> 0),
    (VUINT32) ((0xBFD08BCD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8AB2BF39987EFFuLL) >> 0),
    (VUINT32) ((0xBE8AB2BF39987EFFuLL) >> 32)},
   {(VUINT32) ((0xBFD07E0000000000uLL) >> 0),
    (VUINT32) ((0xBFD07E0000000000uLL) >> 32)},
   {(VUINT32) ((0xBE8EF00E6F310240uLL) >> 0),
    (VUINT32) ((0xBE8EF00E6F310240uLL) >> 32)},
   {(VUINT32) ((0xBFD0703500000000uLL) >> 0),
    (VUINT32) ((0xBFD0703500000000uLL) >> 32)},
   {(VUINT32) ((0xBE7884F5DD34E44BuLL) >> 0),
    (VUINT32) ((0xBE7884F5DD34E44BuLL) >> 32)},
   {(VUINT32) ((0xBFD0626B00000000uLL) >> 0),
    (VUINT32) ((0xBFD0626B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8D92500F14B471uLL) >> 0),
    (VUINT32) ((0xBE8D92500F14B471uLL) >> 32)},
   {(VUINT32) ((0xBFD054A400000000uLL) >> 0),
    (VUINT32) ((0xBFD054A400000000uLL) >> 32)},
   {(VUINT32) ((0xBE8307E1DD3AD028uLL) >> 0),
    (VUINT32) ((0xBE8307E1DD3AD028uLL) >> 32)},
   {(VUINT32) ((0xBFD046DF00000000uLL) >> 0),
    (VUINT32) ((0xBFD046DF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE79971A63342C6AuLL) >> 0),
    (VUINT32) ((0xBE79971A63342C6AuLL) >> 32)},
   {(VUINT32) ((0xBFD0391C00000000uLL) >> 0),
    (VUINT32) ((0xBFD0391C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE760B6F55E8DB61uLL) >> 0),
    (VUINT32) ((0xBE760B6F55E8DB61uLL) >> 32)},
   {(VUINT32) ((0xBFD02B5A00000000uLL) >> 0),
    (VUINT32) ((0xBFD02B5A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8302CF89E64237uLL) >> 0),
    (VUINT32) ((0xBE8302CF89E64237uLL) >> 32)},
   {(VUINT32) ((0xBFD01D9B00000000uLL) >> 0),
    (VUINT32) ((0xBFD01D9B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE8A9F4C3EFC935AuLL) >> 0),
    (VUINT32) ((0xBE8A9F4C3EFC935AuLL) >> 32)},
   {(VUINT32) ((0xBFD00FDE00000000uLL) >> 0),
    (VUINT32) ((0xBFD00FDE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE788F5A8DC51CDFuLL) >> 0),
    (VUINT32) ((0xBE788F5A8DC51CDFuLL) >> 32)},
   {(VUINT32) ((0xBFD0022300000000uLL) >> 0),
    (VUINT32) ((0xBFD0022300000000uLL) >> 32)},
   {(VUINT32) ((0xBE8DE87B8DE45C1CuLL) >> 0),
    (VUINT32) ((0xBE8DE87B8DE45C1CuLL) >> 32)},
   {(VUINT32) ((0xBFCFE8D500000000uLL) >> 0),
    (VUINT32) ((0xBFCFE8D500000000uLL) >> 32)},
   {(VUINT32) ((0xBE73BC8FEAB63684uLL) >> 0),
    (VUINT32) ((0xBE73BC8FEAB63684uLL) >> 32)},
   {(VUINT32) ((0xBFCFCD6700000000uLL) >> 0),
    (VUINT32) ((0xBFCFCD6700000000uLL) >> 32)},
   {(VUINT32) ((0xBE766B590D531889uLL) >> 0),
    (VUINT32) ((0xBE766B590D531889uLL) >> 32)},
   {(VUINT32) ((0xBFCFB1FE00000000uLL) >> 0),
    (VUINT32) ((0xBFCFB1FE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE50BA5E451BFF1AuLL) >> 0),
    (VUINT32) ((0xBE50BA5E451BFF1AuLL) >> 32)},
   {(VUINT32) ((0xBFCF969700000000uLL) >> 0),
    (VUINT32) ((0xBFCF969700000000uLL) >> 32)},
   {(VUINT32) ((0xBE5D9E85A4FC1CE1uLL) >> 0),
    (VUINT32) ((0xBE5D9E85A4FC1CE1uLL) >> 32)},
   {(VUINT32) ((0xBFCF7B3600000000uLL) >> 0),
    (VUINT32) ((0xBFCF7B3600000000uLL) >> 32)},
   {(VUINT32) ((0xBE687FBDAB298DB0uLL) >> 0),
    (VUINT32) ((0xBE687FBDAB298DB0uLL) >> 32)},
   {(VUINT32) ((0xBFCF5FD800000000uLL) >> 0),
    (VUINT32) ((0xBFCF5FD800000000uLL) >> 32)},
   {(VUINT32) ((0xBE5C831EAF201561uLL) >> 0),
    (VUINT32) ((0xBE5C831EAF201561uLL) >> 32)},
   {(VUINT32) ((0xBFCF447E00000000uLL) >> 0),
    (VUINT32) ((0xBFCF447E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6C97CC28A0C985uLL) >> 0),
    (VUINT32) ((0xBE6C97CC28A0C985uLL) >> 32)},
   {(VUINT32) ((0xBFCF292900000000uLL) >> 0),
    (VUINT32) ((0xBFCF292900000000uLL) >> 32)},
   {(VUINT32) ((0xBE4096A784F160C8uLL) >> 0),
    (VUINT32) ((0xBE4096A784F160C8uLL) >> 32)},
   {(VUINT32) ((0xBFCF0DD800000000uLL) >> 0),
    (VUINT32) ((0xBFCF0DD800000000uLL) >> 32)},
   {(VUINT32) ((0xBE463A00E430058BuLL) >> 0),
    (VUINT32) ((0xBE463A00E430058BuLL) >> 32)},
   {(VUINT32) ((0xBFCEF28900000000uLL) >> 0),
    (VUINT32) ((0xBFCEF28900000000uLL) >> 32)},
   {(VUINT32) ((0xBE7A9AE40ADF8036uLL) >> 0),
    (VUINT32) ((0xBE7A9AE40ADF8036uLL) >> 32)},
   {(VUINT32) ((0xBFCED74100000000uLL) >> 0),
    (VUINT32) ((0xBFCED74100000000uLL) >> 32)},
   {(VUINT32) ((0xBE76178F7389C2B3uLL) >> 0),
    (VUINT32) ((0xBE76178F7389C2B3uLL) >> 32)},
   {(VUINT32) ((0xBFCEBBFC00000000uLL) >> 0),
    (VUINT32) ((0xBFCEBBFC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE628E408A6030DBuLL) >> 0),
    (VUINT32) ((0xBE628E408A6030DBuLL) >> 32)},
   {(VUINT32) ((0xBFCEA0BB00000000uLL) >> 0),
    (VUINT32) ((0xBFCEA0BB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE65370CFCA139E2uLL) >> 0),
    (VUINT32) ((0xBE65370CFCA139E2uLL) >> 32)},
   {(VUINT32) ((0xBFCE857D00000000uLL) >> 0),
    (VUINT32) ((0xBFCE857D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE509B099C44098AuLL) >> 0),
    (VUINT32) ((0xBE509B099C44098AuLL) >> 32)},
   {(VUINT32) ((0xBFCE6A4300000000uLL) >> 0),
    (VUINT32) ((0xBFCE6A4300000000uLL) >> 32)},
   {(VUINT32) ((0xBE68D5CAF2FAEF74uLL) >> 0),
    (VUINT32) ((0xBE68D5CAF2FAEF74uLL) >> 32)},
   {(VUINT32) ((0xBFCE4F0E00000000uLL) >> 0),
    (VUINT32) ((0xBFCE4F0E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4DD08F036B132FuLL) >> 0),
    (VUINT32) ((0xBE4DD08F036B132FuLL) >> 32)},
   {(VUINT32) ((0xBFCE33DD00000000uLL) >> 0),
    (VUINT32) ((0xBFCE33DD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE64CCF4CB32E460uLL) >> 0),
    (VUINT32) ((0xBE64CCF4CB32E460uLL) >> 32)},
   {(VUINT32) ((0xBFCE18AF00000000uLL) >> 0),
    (VUINT32) ((0xBFCE18AF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE64C4C42C4E4661uLL) >> 0),
    (VUINT32) ((0xBE64C4C42C4E4661uLL) >> 32)},
   {(VUINT32) ((0xBFCDFD8700000000uLL) >> 0),
    (VUINT32) ((0xBFCDFD8700000000uLL) >> 32)},
   {(VUINT32) ((0xBE70B81DE05729DEuLL) >> 0),
    (VUINT32) ((0xBE70B81DE05729DEuLL) >> 32)},
   {(VUINT32) ((0xBFCDE26000000000uLL) >> 0),
    (VUINT32) ((0xBFCDE26000000000uLL) >> 32)},
   {(VUINT32) ((0xBE7A821176A0FE0EuLL) >> 0),
    (VUINT32) ((0xBE7A821176A0FE0EuLL) >> 32)},
   {(VUINT32) ((0xBFCDC74000000000uLL) >> 0),
    (VUINT32) ((0xBFCDC74000000000uLL) >> 32)},
   {(VUINT32) ((0xBE669566643C24C3uLL) >> 0),
    (VUINT32) ((0xBE669566643C24C3uLL) >> 32)},
   {(VUINT32) ((0xBFCDAC2200000000uLL) >> 0),
    (VUINT32) ((0xBFCDAC2200000000uLL) >> 32)},
   {(VUINT32) ((0xBE767C88339625FCuLL) >> 0),
    (VUINT32) ((0xBE767C88339625FCuLL) >> 32)},
   {(VUINT32) ((0xBFCD910900000000uLL) >> 0),
    (VUINT32) ((0xBFCD910900000000uLL) >> 32)},
   {(VUINT32) ((0xBE72DA2735AA6C86uLL) >> 0),
    (VUINT32) ((0xBE72DA2735AA6C86uLL) >> 32)},
   {(VUINT32) ((0xBFCD75F300000000uLL) >> 0),
    (VUINT32) ((0xBFCD75F300000000uLL) >> 32)},
   {(VUINT32) ((0xBE644C6D4A5F5AD6uLL) >> 0),
    (VUINT32) ((0xBE644C6D4A5F5AD6uLL) >> 32)},
   {(VUINT32) ((0xBFCD5AE300000000uLL) >> 0),
    (VUINT32) ((0xBFCD5AE300000000uLL) >> 32)},
   {(VUINT32) ((0xBE6396DD21FE2514uLL) >> 0),
    (VUINT32) ((0xBE6396DD21FE2514uLL) >> 32)},
   {(VUINT32) ((0xBFCD3FD400000000uLL) >> 0),
    (VUINT32) ((0xBFCD3FD400000000uLL) >> 32)},
   {(VUINT32) ((0xBE6CA92AE56A4FCFuLL) >> 0),
    (VUINT32) ((0xBE6CA92AE56A4FCFuLL) >> 32)},
   {(VUINT32) ((0xBFCD24CB00000000uLL) >> 0),
    (VUINT32) ((0xBFCD24CB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7BDC846E0ED386uLL) >> 0),
    (VUINT32) ((0xBE7BDC846E0ED386uLL) >> 32)},
   {(VUINT32) ((0xBFCD09C600000000uLL) >> 0),
    (VUINT32) ((0xBFCD09C600000000uLL) >> 32)},
   {(VUINT32) ((0xBE55B88BE3AE865AuLL) >> 0),
    (VUINT32) ((0xBE55B88BE3AE865AuLL) >> 32)},
   {(VUINT32) ((0xBFCCEEC500000000uLL) >> 0),
    (VUINT32) ((0xBFCCEEC500000000uLL) >> 32)},
   {(VUINT32) ((0xBE3FC6A072116830uLL) >> 0),
    (VUINT32) ((0xBE3FC6A072116830uLL) >> 32)},
   {(VUINT32) ((0xBFCCD3C600000000uLL) >> 0),
    (VUINT32) ((0xBFCCD3C600000000uLL) >> 32)},
   {(VUINT32) ((0xBE7B1A6214562C52uLL) >> 0),
    (VUINT32) ((0xBE7B1A6214562C52uLL) >> 32)},
   {(VUINT32) ((0xBFCCB8CD00000000uLL) >> 0),
    (VUINT32) ((0xBFCCB8CD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5F2C91C96636D8uLL) >> 0),
    (VUINT32) ((0xBE5F2C91C96636D8uLL) >> 32)},
   {(VUINT32) ((0xBFCC9DD800000000uLL) >> 0),
    (VUINT32) ((0xBFCC9DD800000000uLL) >> 32)},
   {(VUINT32) ((0xBE60C3B48651CF97uLL) >> 0),
    (VUINT32) ((0xBE60C3B48651CF97uLL) >> 32)},
   {(VUINT32) ((0xBFCC82E600000000uLL) >> 0),
    (VUINT32) ((0xBFCC82E600000000uLL) >> 32)},
   {(VUINT32) ((0xBE5966F235766DDBuLL) >> 0),
    (VUINT32) ((0xBE5966F235766DDBuLL) >> 32)},
   {(VUINT32) ((0xBFCC67F800000000uLL) >> 0),
    (VUINT32) ((0xBFCC67F800000000uLL) >> 32)},
   {(VUINT32) ((0xBE78CE14EAE5DCA8uLL) >> 0),
    (VUINT32) ((0xBE78CE14EAE5DCA8uLL) >> 32)},
   {(VUINT32) ((0xBFCC4D0E00000000uLL) >> 0),
    (VUINT32) ((0xBFCC4D0E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE625479353B5C4AuLL) >> 0),
    (VUINT32) ((0xBE625479353B5C4AuLL) >> 32)},
   {(VUINT32) ((0xBFCC322800000000uLL) >> 0),
    (VUINT32) ((0xBFCC322800000000uLL) >> 32)},
   {(VUINT32) ((0xBE6D333A7B285AC2uLL) >> 0),
    (VUINT32) ((0xBE6D333A7B285AC2uLL) >> 32)},
   {(VUINT32) ((0xBFCC174500000000uLL) >> 0),
    (VUINT32) ((0xBFCC174500000000uLL) >> 32)},
   {(VUINT32) ((0xBE7277AFFE5D329AuLL) >> 0),
    (VUINT32) ((0xBE7277AFFE5D329AuLL) >> 32)},
   {(VUINT32) ((0xBFCBFC6700000000uLL) >> 0),
    (VUINT32) ((0xBFCBFC6700000000uLL) >> 32)},
   {(VUINT32) ((0xBE67FFFD12834EFCuLL) >> 0),
    (VUINT32) ((0xBE67FFFD12834EFCuLL) >> 32)},
   {(VUINT32) ((0xBFCBE18D00000000uLL) >> 0),
    (VUINT32) ((0xBFCBE18D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7B862223583BCFuLL) >> 0),
    (VUINT32) ((0xBE7B862223583BCFuLL) >> 32)},
   {(VUINT32) ((0xBFCBC6B700000000uLL) >> 0),
    (VUINT32) ((0xBFCBC6B700000000uLL) >> 32)},
   {(VUINT32) ((0xBE649B874647B1F2uLL) >> 0),
    (VUINT32) ((0xBE649B874647B1F2uLL) >> 32)},
   {(VUINT32) ((0xBFCBABE300000000uLL) >> 0),
    (VUINT32) ((0xBFCBABE300000000uLL) >> 32)},
   {(VUINT32) ((0xBE78929BF1C864A7uLL) >> 0),
    (VUINT32) ((0xBE78929BF1C864A7uLL) >> 32)},
   {(VUINT32) ((0xBFCB911600000000uLL) >> 0),
    (VUINT32) ((0xBFCB911600000000uLL) >> 32)},
   {(VUINT32) ((0xBE74D074968F73D7uLL) >> 0),
    (VUINT32) ((0xBE74D074968F73D7uLL) >> 32)},
   {(VUINT32) ((0xBFCB764A00000000uLL) >> 0),
    (VUINT32) ((0xBFCB764A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE79FB251B935310uLL) >> 0),
    (VUINT32) ((0xBE79FB251B935310uLL) >> 32)},
   {(VUINT32) ((0xBFCB5B8300000000uLL) >> 0),
    (VUINT32) ((0xBFCB5B8300000000uLL) >> 32)},
   {(VUINT32) ((0xBE769696568E41B9uLL) >> 0),
    (VUINT32) ((0xBE769696568E41B9uLL) >> 32)},
   {(VUINT32) ((0xBFCB40C100000000uLL) >> 0),
    (VUINT32) ((0xBFCB40C100000000uLL) >> 32)},
   {(VUINT32) ((0xBE65ED80B7EB91E0uLL) >> 0),
    (VUINT32) ((0xBE65ED80B7EB91E0uLL) >> 32)},
   {(VUINT32) ((0xBFCB260200000000uLL) >> 0),
    (VUINT32) ((0xBFCB260200000000uLL) >> 32)},
   {(VUINT32) ((0xBE07D52C3932A2E4uLL) >> 0),
    (VUINT32) ((0xBE07D52C3932A2E4uLL) >> 32)},
   {(VUINT32) ((0xBFCB0B4700000000uLL) >> 0),
    (VUINT32) ((0xBFCB0B4700000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B8AD7D7A99FE6uLL) >> 0),
    (VUINT32) ((0xBE6B8AD7D7A99FE6uLL) >> 32)},
   {(VUINT32) ((0xBFCAF08F00000000uLL) >> 0),
    (VUINT32) ((0xBFCAF08F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7CBC2B9155B770uLL) >> 0),
    (VUINT32) ((0xBE7CBC2B9155B770uLL) >> 32)},
   {(VUINT32) ((0xBFCAD5DB00000000uLL) >> 0),
    (VUINT32) ((0xBFCAD5DB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6AA03F2514A52BuLL) >> 0),
    (VUINT32) ((0xBE6AA03F2514A52BuLL) >> 32)},
   {(VUINT32) ((0xBFCABB2D00000000uLL) >> 0),
    (VUINT32) ((0xBFCABB2D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6CFB1D524B6DAFuLL) >> 0),
    (VUINT32) ((0xBE6CFB1D524B6DAFuLL) >> 32)},
   {(VUINT32) ((0xBFCAA08000000000uLL) >> 0),
    (VUINT32) ((0xBFCAA08000000000uLL) >> 32)},
   {(VUINT32) ((0xBE7A78CD1FBB1E99uLL) >> 0),
    (VUINT32) ((0xBE7A78CD1FBB1E99uLL) >> 32)},
   {(VUINT32) ((0xBFCA85D900000000uLL) >> 0),
    (VUINT32) ((0xBFCA85D900000000uLL) >> 32)},
   {(VUINT32) ((0xBE119017E37D4667uLL) >> 0),
    (VUINT32) ((0xBE119017E37D4667uLL) >> 32)},
   {(VUINT32) ((0xBFCA6B3400000000uLL) >> 0),
    (VUINT32) ((0xBFCA6B3400000000uLL) >> 32)},
   {(VUINT32) ((0xBE6184B897951F46uLL) >> 0),
    (VUINT32) ((0xBE6184B897951F46uLL) >> 32)},
   {(VUINT32) ((0xBFCA509400000000uLL) >> 0),
    (VUINT32) ((0xBFCA509400000000uLL) >> 32)},
   {(VUINT32) ((0xBE675349E1651FC0uLL) >> 0),
    (VUINT32) ((0xBE675349E1651FC0uLL) >> 32)},
   {(VUINT32) ((0xBFCA35F700000000uLL) >> 0),
    (VUINT32) ((0xBFCA35F700000000uLL) >> 32)},
   {(VUINT32) ((0xBE71C8ACC30679DDuLL) >> 0),
    (VUINT32) ((0xBE71C8ACC30679DDuLL) >> 32)},
   {(VUINT32) ((0xBFCA1B5F00000000uLL) >> 0),
    (VUINT32) ((0xBFCA1B5F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE72EC1682BF9837uLL) >> 0),
    (VUINT32) ((0xBE72EC1682BF9837uLL) >> 32)},
   {(VUINT32) ((0xBFCA00CA00000000uLL) >> 0),
    (VUINT32) ((0xBFCA00CA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE77D09336233C90uLL) >> 0),
    (VUINT32) ((0xBE77D09336233C90uLL) >> 32)},
   {(VUINT32) ((0xBFC9E63A00000000uLL) >> 0),
    (VUINT32) ((0xBFC9E63A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7852E40017E39CuLL) >> 0),
    (VUINT32) ((0xBE7852E40017E39CuLL) >> 32)},
   {(VUINT32) ((0xBFC9CBAD00000000uLL) >> 0),
    (VUINT32) ((0xBFC9CBAD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7D1FD8802FB817uLL) >> 0),
    (VUINT32) ((0xBE7D1FD8802FB817uLL) >> 32)},
   {(VUINT32) ((0xBFC9B12400000000uLL) >> 0),
    (VUINT32) ((0xBFC9B12400000000uLL) >> 32)},
   {(VUINT32) ((0xBE59D13FAE79743CuLL) >> 0),
    (VUINT32) ((0xBE59D13FAE79743CuLL) >> 32)},
   {(VUINT32) ((0xBFC9969D00000000uLL) >> 0),
    (VUINT32) ((0xBFC9969D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE748D385E0277CFuLL) >> 0),
    (VUINT32) ((0xBE748D385E0277CFuLL) >> 32)},
   {(VUINT32) ((0xBFC97C1B00000000uLL) >> 0),
    (VUINT32) ((0xBFC97C1B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7F678FA8388A68uLL) >> 0),
    (VUINT32) ((0xBE7F678FA8388A68uLL) >> 32)},
   {(VUINT32) ((0xBFC9619F00000000uLL) >> 0),
    (VUINT32) ((0xBFC9619F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5D6188E89480ECuLL) >> 0),
    (VUINT32) ((0xBE5D6188E89480ECuLL) >> 32)},
   {(VUINT32) ((0xBFC9472500000000uLL) >> 0),
    (VUINT32) ((0xBFC9472500000000uLL) >> 32)},
   {(VUINT32) ((0xBE74E4CB139C1E95uLL) >> 0),
    (VUINT32) ((0xBE74E4CB139C1E95uLL) >> 32)},
   {(VUINT32) ((0xBFC92CAF00000000uLL) >> 0),
    (VUINT32) ((0xBFC92CAF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6093E9A4239741uLL) >> 0),
    (VUINT32) ((0xBE6093E9A4239741uLL) >> 32)},
   {(VUINT32) ((0xBFC9123C00000000uLL) >> 0),
    (VUINT32) ((0xBFC9123C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3C518D850F7BA8uLL) >> 0),
    (VUINT32) ((0xBE3C518D850F7BA8uLL) >> 32)},
   {(VUINT32) ((0xBFC8F7CD00000000uLL) >> 0),
    (VUINT32) ((0xBFC8F7CD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE797B7FC86F1C0CuLL) >> 0),
    (VUINT32) ((0xBE797B7FC86F1C0CuLL) >> 32)},
   {(VUINT32) ((0xBFC8DD6200000000uLL) >> 0),
    (VUINT32) ((0xBFC8DD6200000000uLL) >> 32)},
   {(VUINT32) ((0xBE77D280A0117CFDuLL) >> 0),
    (VUINT32) ((0xBE77D280A0117CFDuLL) >> 32)},
   {(VUINT32) ((0xBFC8C2FA00000000uLL) >> 0),
    (VUINT32) ((0xBFC8C2FA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7D078174C6928FuLL) >> 0),
    (VUINT32) ((0xBE7D078174C6928FuLL) >> 32)},
   {(VUINT32) ((0xBFC8A89800000000uLL) >> 0),
    (VUINT32) ((0xBFC8A89800000000uLL) >> 32)},
   {(VUINT32) ((0xBE357F7A64CCD537uLL) >> 0),
    (VUINT32) ((0xBE357F7A64CCD537uLL) >> 32)},
   {(VUINT32) ((0xBFC88E3800000000uLL) >> 0),
    (VUINT32) ((0xBFC88E3800000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A22CD1F2E8F29uLL) >> 0),
    (VUINT32) ((0xBE6A22CD1F2E8F29uLL) >> 32)},
   {(VUINT32) ((0xBFC873DC00000000uLL) >> 0),
    (VUINT32) ((0xBFC873DC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE1C582D297FF644uLL) >> 0),
    (VUINT32) ((0xBE1C582D297FF644uLL) >> 32)},
   {(VUINT32) ((0xBFC8598400000000uLL) >> 0),
    (VUINT32) ((0xBFC8598400000000uLL) >> 32)},
   {(VUINT32) ((0xBE73CD87CE24F758uLL) >> 0),
    (VUINT32) ((0xBE73CD87CE24F758uLL) >> 32)},
   {(VUINT32) ((0xBFC83F3000000000uLL) >> 0),
    (VUINT32) ((0xBFC83F3000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6EB716BAC42623uLL) >> 0),
    (VUINT32) ((0xBE6EB716BAC42623uLL) >> 32)},
   {(VUINT32) ((0xBFC824DF00000000uLL) >> 0),
    (VUINT32) ((0xBFC824DF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE73592A0F410400uLL) >> 0),
    (VUINT32) ((0xBE73592A0F410400uLL) >> 32)},
   {(VUINT32) ((0xBFC80A9300000000uLL) >> 0),
    (VUINT32) ((0xBFC80A9300000000uLL) >> 32)},
   {(VUINT32) ((0xBE78343174876BA5uLL) >> 0),
    (VUINT32) ((0xBE78343174876BA5uLL) >> 32)},
   {(VUINT32) ((0xBFC7F04900000000uLL) >> 0),
    (VUINT32) ((0xBFC7F04900000000uLL) >> 32)},
   {(VUINT32) ((0xBE6BA4F9B930430EuLL) >> 0),
    (VUINT32) ((0xBE6BA4F9B930430EuLL) >> 32)},
   {(VUINT32) ((0xBFC7D60400000000uLL) >> 0),
    (VUINT32) ((0xBFC7D60400000000uLL) >> 32)},
   {(VUINT32) ((0xBE5367DD3B0B6B0BuLL) >> 0),
    (VUINT32) ((0xBE5367DD3B0B6B0BuLL) >> 32)},
   {(VUINT32) ((0xBFC7BBC200000000uLL) >> 0),
    (VUINT32) ((0xBFC7BBC200000000uLL) >> 32)},
   {(VUINT32) ((0xBE556265A1DC7A8EuLL) >> 0),
    (VUINT32) ((0xBE556265A1DC7A8EuLL) >> 32)},
   {(VUINT32) ((0xBFC7A18500000000uLL) >> 0),
    (VUINT32) ((0xBFC7A18500000000uLL) >> 32)},
   {(VUINT32) ((0xBE5F71ACA38241C4uLL) >> 0),
    (VUINT32) ((0xBE5F71ACA38241C4uLL) >> 32)},
   {(VUINT32) ((0xBFC7874B00000000uLL) >> 0),
    (VUINT32) ((0xBFC7874B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE746381F987646BuLL) >> 0),
    (VUINT32) ((0xBE746381F987646BuLL) >> 32)},
   {(VUINT32) ((0xBFC76D1500000000uLL) >> 0),
    (VUINT32) ((0xBFC76D1500000000uLL) >> 32)},
   {(VUINT32) ((0xBE665804BC056069uLL) >> 0),
    (VUINT32) ((0xBE665804BC056069uLL) >> 32)},
   {(VUINT32) ((0xBFC752E200000000uLL) >> 0),
    (VUINT32) ((0xBFC752E200000000uLL) >> 32)},
   {(VUINT32) ((0xBE68E83E5955BBC6uLL) >> 0),
    (VUINT32) ((0xBE68E83E5955BBC6uLL) >> 32)},
   {(VUINT32) ((0xBFC738B200000000uLL) >> 0),
    (VUINT32) ((0xBFC738B200000000uLL) >> 32)},
   {(VUINT32) ((0xBE787A19887D1E81uLL) >> 0),
    (VUINT32) ((0xBE787A19887D1E81uLL) >> 32)},
   {(VUINT32) ((0xBFC71E8800000000uLL) >> 0),
    (VUINT32) ((0xBFC71E8800000000uLL) >> 32)},
   {(VUINT32) ((0xBE5FD1054D6E1895uLL) >> 0),
    (VUINT32) ((0xBE5FD1054D6E1895uLL) >> 32)},
   {(VUINT32) ((0xBFC7045F00000000uLL) >> 0),
    (VUINT32) ((0xBFC7045F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6471E7650BE845uLL) >> 0),
    (VUINT32) ((0xBE6471E7650BE845uLL) >> 32)},
   {(VUINT32) ((0xBFC6EA3B00000000uLL) >> 0),
    (VUINT32) ((0xBFC6EA3B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE707E9D9296377FuLL) >> 0),
    (VUINT32) ((0xBE707E9D9296377FuLL) >> 32)},
   {(VUINT32) ((0xBFC6D01C00000000uLL) >> 0),
    (VUINT32) ((0xBFC6D01C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7B1BB94E9CC3B2uLL) >> 0),
    (VUINT32) ((0xBE7B1BB94E9CC3B2uLL) >> 32)},
   {(VUINT32) ((0xBFC6B5FF00000000uLL) >> 0),
    (VUINT32) ((0xBFC6B5FF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7936CECA9AFDC8uLL) >> 0),
    (VUINT32) ((0xBE7936CECA9AFDC8uLL) >> 32)},
   {(VUINT32) ((0xBFC69BE600000000uLL) >> 0),
    (VUINT32) ((0xBFC69BE600000000uLL) >> 32)},
   {(VUINT32) ((0xBE4CB3A881ABFDF7uLL) >> 0),
    (VUINT32) ((0xBE4CB3A881ABFDF7uLL) >> 32)},
   {(VUINT32) ((0xBFC681D100000000uLL) >> 0),
    (VUINT32) ((0xBFC681D100000000uLL) >> 32)},
   {(VUINT32) ((0xBE732151A8286C6FuLL) >> 0),
    (VUINT32) ((0xBE732151A8286C6FuLL) >> 32)},
   {(VUINT32) ((0xBFC667C000000000uLL) >> 0),
    (VUINT32) ((0xBFC667C000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6EFC2E3E9CED23uLL) >> 0),
    (VUINT32) ((0xBE6EFC2E3E9CED23uLL) >> 32)},
   {(VUINT32) ((0xBFC64DB200000000uLL) >> 0),
    (VUINT32) ((0xBFC64DB200000000uLL) >> 32)},
   {(VUINT32) ((0xBE78EB86AC9EF252uLL) >> 0),
    (VUINT32) ((0xBE78EB86AC9EF252uLL) >> 32)},
   {(VUINT32) ((0xBFC633A800000000uLL) >> 0),
    (VUINT32) ((0xBFC633A800000000uLL) >> 32)},
   {(VUINT32) ((0xBE6F50DF1ABE0FC9uLL) >> 0),
    (VUINT32) ((0xBE6F50DF1ABE0FC9uLL) >> 32)},
   {(VUINT32) ((0xBFC619A100000000uLL) >> 0),
    (VUINT32) ((0xBFC619A100000000uLL) >> 32)},
   {(VUINT32) ((0xBE73F3AEFE930C8FuLL) >> 0),
    (VUINT32) ((0xBE73F3AEFE930C8FuLL) >> 32)},
   {(VUINT32) ((0xBFC5FF9F00000000uLL) >> 0),
    (VUINT32) ((0xBFC5FF9F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7EDC30C01B141DuLL) >> 0),
    (VUINT32) ((0xBE7EDC30C01B141DuLL) >> 32)},
   {(VUINT32) ((0xBFC5E59F00000000uLL) >> 0),
    (VUINT32) ((0xBFC5E59F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7F08ED31FE1628uLL) >> 0),
    (VUINT32) ((0xBE7F08ED31FE1628uLL) >> 32)},
   {(VUINT32) ((0xBFC5CBA500000000uLL) >> 0),
    (VUINT32) ((0xBFC5CBA500000000uLL) >> 32)},
   {(VUINT32) ((0xBE5983B170E6C68FuLL) >> 0),
    (VUINT32) ((0xBE5983B170E6C68FuLL) >> 32)},
   {(VUINT32) ((0xBFC5B1AD00000000uLL) >> 0),
    (VUINT32) ((0xBFC5B1AD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7C5342DDBB7371uLL) >> 0),
    (VUINT32) ((0xBE7C5342DDBB7371uLL) >> 32)},
   {(VUINT32) ((0xBFC597BA00000000uLL) >> 0),
    (VUINT32) ((0xBFC597BA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE31F13B9ECB2DA6uLL) >> 0),
    (VUINT32) ((0xBE31F13B9ECB2DA6uLL) >> 32)},
   {(VUINT32) ((0xBFC57DC900000000uLL) >> 0),
    (VUINT32) ((0xBFC57DC900000000uLL) >> 32)},
   {(VUINT32) ((0xBE75038FC82FBC24uLL) >> 0),
    (VUINT32) ((0xBE75038FC82FBC24uLL) >> 32)},
   {(VUINT32) ((0xBFC563DC00000000uLL) >> 0),
    (VUINT32) ((0xBFC563DC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE783FF5AD081783uLL) >> 0),
    (VUINT32) ((0xBE783FF5AD081783uLL) >> 32)},
   {(VUINT32) ((0xBFC549F300000000uLL) >> 0),
    (VUINT32) ((0xBFC549F300000000uLL) >> 32)},
   {(VUINT32) ((0xBE662723A6715875uLL) >> 0),
    (VUINT32) ((0xBE662723A6715875uLL) >> 32)},
   {(VUINT32) ((0xBFC5300D00000000uLL) >> 0),
    (VUINT32) ((0xBFC5300D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B7B7CC9AF768AuLL) >> 0),
    (VUINT32) ((0xBE6B7B7CC9AF768AuLL) >> 32)},
   {(VUINT32) ((0xBFC5162B00000000uLL) >> 0),
    (VUINT32) ((0xBFC5162B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE1F78D1162B410DuLL) >> 0),
    (VUINT32) ((0xBE1F78D1162B410DuLL) >> 32)},
   {(VUINT32) ((0xBFC4FC4D00000000uLL) >> 0),
    (VUINT32) ((0xBFC4FC4D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7CB37679326801uLL) >> 0),
    (VUINT32) ((0xBE7CB37679326801uLL) >> 32)},
   {(VUINT32) ((0xBFC4E27200000000uLL) >> 0),
    (VUINT32) ((0xBFC4E27200000000uLL) >> 32)},
   {(VUINT32) ((0xBE7065FA9470590BuLL) >> 0),
    (VUINT32) ((0xBE7065FA9470590BuLL) >> 32)},
   {(VUINT32) ((0xBFC4C89C00000000uLL) >> 0),
    (VUINT32) ((0xBFC4C89C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6C3A0233EDA037uLL) >> 0),
    (VUINT32) ((0xBE6C3A0233EDA037uLL) >> 32)},
   {(VUINT32) ((0xBFC4AEC800000000uLL) >> 0),
    (VUINT32) ((0xBFC4AEC800000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E014055897901uLL) >> 0),
    (VUINT32) ((0xBE4E014055897901uLL) >> 32)},
   {(VUINT32) ((0xBFC494F900000000uLL) >> 0),
    (VUINT32) ((0xBFC494F900000000uLL) >> 32)},
   {(VUINT32) ((0xBE4FB8E003C2F3B1uLL) >> 0),
    (VUINT32) ((0xBE4FB8E003C2F3B1uLL) >> 32)},
   {(VUINT32) ((0xBFC47B2B00000000uLL) >> 0),
    (VUINT32) ((0xBFC47B2B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7C8996199D6EEAuLL) >> 0),
    (VUINT32) ((0xBE7C8996199D6EEAuLL) >> 32)},
   {(VUINT32) ((0xBFC4616400000000uLL) >> 0),
    (VUINT32) ((0xBFC4616400000000uLL) >> 32)},
   {(VUINT32) ((0xBE0FAF0BC81E4B94uLL) >> 0),
    (VUINT32) ((0xBE0FAF0BC81E4B94uLL) >> 32)},
   {(VUINT32) ((0xBFC4479D00000000uLL) >> 0),
    (VUINT32) ((0xBFC4479D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7CC047F1F25C83uLL) >> 0),
    (VUINT32) ((0xBE7CC047F1F25C83uLL) >> 32)},
   {(VUINT32) ((0xBFC42DDD00000000uLL) >> 0),
    (VUINT32) ((0xBFC42DDD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE53D0DA516B147FuLL) >> 0),
    (VUINT32) ((0xBE53D0DA516B147FuLL) >> 32)},
   {(VUINT32) ((0xBFC4141F00000000uLL) >> 0),
    (VUINT32) ((0xBFC4141F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7FCB190ACB1C29uLL) >> 0),
    (VUINT32) ((0xBE7FCB190ACB1C29uLL) >> 32)},
   {(VUINT32) ((0xBFC3FA6400000000uLL) >> 0),
    (VUINT32) ((0xBFC3FA6400000000uLL) >> 32)},
   {(VUINT32) ((0xBE7414EC0C60BAD1uLL) >> 0),
    (VUINT32) ((0xBE7414EC0C60BAD1uLL) >> 32)},
   {(VUINT32) ((0xBFC3E0AE00000000uLL) >> 0),
    (VUINT32) ((0xBFC3E0AE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE74E9BA984A9A60uLL) >> 0),
    (VUINT32) ((0xBE74E9BA984A9A60uLL) >> 32)},
   {(VUINT32) ((0xBFC3C6FC00000000uLL) >> 0),
    (VUINT32) ((0xBFC3C6FC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE624337CCC1362DuLL) >> 0),
    (VUINT32) ((0xBE624337CCC1362DuLL) >> 32)},
   {(VUINT32) ((0xBFC3AD4B00000000uLL) >> 0),
    (VUINT32) ((0xBFC3AD4B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7774B4CC0EC2A8uLL) >> 0),
    (VUINT32) ((0xBE7774B4CC0EC2A8uLL) >> 32)},
   {(VUINT32) ((0xBFC393A000000000uLL) >> 0),
    (VUINT32) ((0xBFC393A000000000uLL) >> 32)},
   {(VUINT32) ((0xBE732B380B7EFC7CuLL) >> 0),
    (VUINT32) ((0xBE732B380B7EFC7CuLL) >> 32)},
   {(VUINT32) ((0xBFC379F700000000uLL) >> 0),
    (VUINT32) ((0xBFC379F700000000uLL) >> 32)},
   {(VUINT32) ((0xBE62DAC931C2E190uLL) >> 0),
    (VUINT32) ((0xBE62DAC931C2E190uLL) >> 32)},
   {(VUINT32) ((0xBFC3605300000000uLL) >> 0),
    (VUINT32) ((0xBFC3605300000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B470FA43DC529uLL) >> 0),
    (VUINT32) ((0xBE6B470FA43DC529uLL) >> 32)},
   {(VUINT32) ((0xBFC346B100000000uLL) >> 0),
    (VUINT32) ((0xBFC346B100000000uLL) >> 32)},
   {(VUINT32) ((0xBE69ABF6162BFC32uLL) >> 0),
    (VUINT32) ((0xBE69ABF6162BFC32uLL) >> 32)},
   {(VUINT32) ((0xBFC32D1300000000uLL) >> 0),
    (VUINT32) ((0xBFC32D1300000000uLL) >> 32)},
   {(VUINT32) ((0xBE2BA4B334A02879uLL) >> 0),
    (VUINT32) ((0xBE2BA4B334A02879uLL) >> 32)},
   {(VUINT32) ((0xBFC3137A00000000uLL) >> 0),
    (VUINT32) ((0xBFC3137A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4D8BE297E30D03uLL) >> 0),
    (VUINT32) ((0xBE4D8BE297E30D03uLL) >> 32)},
   {(VUINT32) ((0xBFC2F9E300000000uLL) >> 0),
    (VUINT32) ((0xBFC2F9E300000000uLL) >> 32)},
   {(VUINT32) ((0xBE415BFDA1644C22uLL) >> 0),
    (VUINT32) ((0xBE415BFDA1644C22uLL) >> 32)},
   {(VUINT32) ((0xBFC2E04F00000000uLL) >> 0),
    (VUINT32) ((0xBFC2E04F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE763BBE948B1AC0uLL) >> 0),
    (VUINT32) ((0xBE763BBE948B1AC0uLL) >> 32)},
   {(VUINT32) ((0xBFC2C6C000000000uLL) >> 0),
    (VUINT32) ((0xBFC2C6C000000000uLL) >> 32)},
   {(VUINT32) ((0xBE016A3F42B0E0F2uLL) >> 0),
    (VUINT32) ((0xBE016A3F42B0E0F2uLL) >> 32)},
   {(VUINT32) ((0xBFC2AD3400000000uLL) >> 0),
    (VUINT32) ((0xBFC2AD3400000000uLL) >> 32)},
   {(VUINT32) ((0xBE00B500D8B4466EuLL) >> 0),
    (VUINT32) ((0xBE00B500D8B4466EuLL) >> 32)},
   {(VUINT32) ((0xBFC293AB00000000uLL) >> 0),
    (VUINT32) ((0xBFC293AB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE767834AAD3C38FuLL) >> 0),
    (VUINT32) ((0xBE767834AAD3C38FuLL) >> 32)},
   {(VUINT32) ((0xBFC27A2700000000uLL) >> 0),
    (VUINT32) ((0xBFC27A2700000000uLL) >> 32)},
   {(VUINT32) ((0xBE4B3FB7DED60421uLL) >> 0),
    (VUINT32) ((0xBE4B3FB7DED60421uLL) >> 32)},
   {(VUINT32) ((0xBFC260A600000000uLL) >> 0),
    (VUINT32) ((0xBFC260A600000000uLL) >> 32)},
   {(VUINT32) ((0xBE5CC6018F3BCD49uLL) >> 0),
    (VUINT32) ((0xBE5CC6018F3BCD49uLL) >> 32)},
   {(VUINT32) ((0xBFC2472700000000uLL) >> 0),
    (VUINT32) ((0xBFC2472700000000uLL) >> 32)},
   {(VUINT32) ((0xBE603B59BC184860uLL) >> 0),
    (VUINT32) ((0xBE603B59BC184860uLL) >> 32)},
   {(VUINT32) ((0xBFC22DAD00000000uLL) >> 0),
    (VUINT32) ((0xBFC22DAD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7A556695FCA0D7uLL) >> 0),
    (VUINT32) ((0xBE7A556695FCA0D7uLL) >> 32)},
   {(VUINT32) ((0xBFC2143600000000uLL) >> 0),
    (VUINT32) ((0xBFC2143600000000uLL) >> 32)},
   {(VUINT32) ((0xBE64434576D52CB7uLL) >> 0),
    (VUINT32) ((0xBE64434576D52CB7uLL) >> 32)},
   {(VUINT32) ((0xBFC1FAC400000000uLL) >> 0),
    (VUINT32) ((0xBFC1FAC400000000uLL) >> 32)},
   {(VUINT32) ((0xBE6796CA377EA74EuLL) >> 0),
    (VUINT32) ((0xBE6796CA377EA74EuLL) >> 32)},
   {(VUINT32) ((0xBFC1E15400000000uLL) >> 0),
    (VUINT32) ((0xBFC1E15400000000uLL) >> 32)},
   {(VUINT32) ((0xBE66F7798C85559DuLL) >> 0),
    (VUINT32) ((0xBE66F7798C85559DuLL) >> 32)},
   {(VUINT32) ((0xBFC1C7E800000000uLL) >> 0),
    (VUINT32) ((0xBFC1C7E800000000uLL) >> 32)},
   {(VUINT32) ((0xBE4BDE34965F6984uLL) >> 0),
    (VUINT32) ((0xBE4BDE34965F6984uLL) >> 32)},
   {(VUINT32) ((0xBFC1AE7D00000000uLL) >> 0),
    (VUINT32) ((0xBFC1AE7D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE79E4AB7003A0E6uLL) >> 0),
    (VUINT32) ((0xBE79E4AB7003A0E6uLL) >> 32)},
   {(VUINT32) ((0xBFC1951900000000uLL) >> 0),
    (VUINT32) ((0xBFC1951900000000uLL) >> 32)},
   {(VUINT32) ((0xBE49FD11E39ABAACuLL) >> 0),
    (VUINT32) ((0xBE49FD11E39ABAACuLL) >> 32)},
   {(VUINT32) ((0xBFC17BB800000000uLL) >> 0),
    (VUINT32) ((0xBFC17BB800000000uLL) >> 32)},
   {(VUINT32) ((0xBE56B7B48B95C15BuLL) >> 0),
    (VUINT32) ((0xBE56B7B48B95C15BuLL) >> 32)},
   {(VUINT32) ((0xBFC1625900000000uLL) >> 0),
    (VUINT32) ((0xBFC1625900000000uLL) >> 32)},
   {(VUINT32) ((0xBE5CC36D3E3CCA65uLL) >> 0),
    (VUINT32) ((0xBE5CC36D3E3CCA65uLL) >> 32)},
   {(VUINT32) ((0xBFC148FE00000000uLL) >> 0),
    (VUINT32) ((0xBFC148FE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE41CE485761F69CuLL) >> 0),
    (VUINT32) ((0xBE41CE485761F69CuLL) >> 32)},
   {(VUINT32) ((0xBFC12FA600000000uLL) >> 0),
    (VUINT32) ((0xBFC12FA600000000uLL) >> 32)},
   {(VUINT32) ((0xBE770A1F05316811uLL) >> 0),
    (VUINT32) ((0xBE770A1F05316811uLL) >> 32)},
   {(VUINT32) ((0xBFC1165300000000uLL) >> 0),
    (VUINT32) ((0xBFC1165300000000uLL) >> 32)},
   {(VUINT32) ((0xBE578D49DC1AFE94uLL) >> 0),
    (VUINT32) ((0xBE578D49DC1AFE94uLL) >> 32)},
   {(VUINT32) ((0xBFC0FD0300000000uLL) >> 0),
    (VUINT32) ((0xBFC0FD0300000000uLL) >> 32)},
   {(VUINT32) ((0xBE6E0DCA31CD9E54uLL) >> 0),
    (VUINT32) ((0xBE6E0DCA31CD9E54uLL) >> 32)},
   {(VUINT32) ((0xBFC0E3B500000000uLL) >> 0),
    (VUINT32) ((0xBFC0E3B500000000uLL) >> 32)},
   {(VUINT32) ((0xBE784E650E0A2FD5uLL) >> 0),
    (VUINT32) ((0xBE784E650E0A2FD5uLL) >> 32)},
   {(VUINT32) ((0xBFC0CA6B00000000uLL) >> 0),
    (VUINT32) ((0xBFC0CA6B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7C536D57D9DAB9uLL) >> 0),
    (VUINT32) ((0xBE7C536D57D9DAB9uLL) >> 32)},
   {(VUINT32) ((0xBFC0B12500000000uLL) >> 0),
    (VUINT32) ((0xBFC0B12500000000uLL) >> 32)},
   {(VUINT32) ((0xBE7B57A5578D01FDuLL) >> 0),
    (VUINT32) ((0xBE7B57A5578D01FDuLL) >> 32)},
   {(VUINT32) ((0xBFC097E300000000uLL) >> 0),
    (VUINT32) ((0xBFC097E300000000uLL) >> 32)},
   {(VUINT32) ((0xBE759CC0CF3DA52AuLL) >> 0),
    (VUINT32) ((0xBE759CC0CF3DA52AuLL) >> 32)},
   {(VUINT32) ((0xBFC07EA300000000uLL) >> 0),
    (VUINT32) ((0xBFC07EA300000000uLL) >> 32)},
   {(VUINT32) ((0xBE70DC7F7C36AAB7uLL) >> 0),
    (VUINT32) ((0xBE70DC7F7C36AAB7uLL) >> 32)},
   {(VUINT32) ((0xBFC0656900000000uLL) >> 0),
    (VUINT32) ((0xBFC0656900000000uLL) >> 32)},
   {(VUINT32) ((0xBE43057726EEA6F9uLL) >> 0),
    (VUINT32) ((0xBE43057726EEA6F9uLL) >> 32)},
   {(VUINT32) ((0xBFC04C3000000000uLL) >> 0),
    (VUINT32) ((0xBFC04C3000000000uLL) >> 32)},
   {(VUINT32) ((0xBE75532713B0B555uLL) >> 0),
    (VUINT32) ((0xBE75532713B0B555uLL) >> 32)},
   {(VUINT32) ((0xBFC032FC00000000uLL) >> 0),
    (VUINT32) ((0xBFC032FC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE51F736F8234297uLL) >> 0),
    (VUINT32) ((0xBE51F736F8234297uLL) >> 32)},
   {(VUINT32) ((0xBFC019C900000000uLL) >> 0),
    (VUINT32) ((0xBFC019C900000000uLL) >> 32)},
   {(VUINT32) ((0xBE757A9427127E28uLL) >> 0),
    (VUINT32) ((0xBE757A9427127E28uLL) >> 32)},
   {(VUINT32) ((0xBFC0009C00000000uLL) >> 0),
    (VUINT32) ((0xBFC0009C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE7DD37909D634E1uLL) >> 0),
    (VUINT32) ((0xBE7DD37909D634E1uLL) >> 32)},
   {(VUINT32) ((0xBFBFCEE400000000uLL) >> 0),
    (VUINT32) ((0xBFBFCEE400000000uLL) >> 32)},
   {(VUINT32) ((0xBE60E50B92227F37uLL) >> 0),
    (VUINT32) ((0xBE60E50B92227F37uLL) >> 32)},
   {(VUINT32) ((0xBFBF9C9700000000uLL) >> 0),
    (VUINT32) ((0xBFBF9C9700000000uLL) >> 32)},
   {(VUINT32) ((0xBE10744B2BBD5C34uLL) >> 0),
    (VUINT32) ((0xBE10744B2BBD5C34uLL) >> 32)},
   {(VUINT32) ((0xBFBF6A4D00000000uLL) >> 0),
    (VUINT32) ((0xBFBF6A4D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6576FB1AB66AD7uLL) >> 0),
    (VUINT32) ((0xBE6576FB1AB66AD7uLL) >> 32)},
   {(VUINT32) ((0xBFBF380F00000000uLL) >> 0),
    (VUINT32) ((0xBFBF380F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B5374D31A91EEuLL) >> 0),
    (VUINT32) ((0xBE6B5374D31A91EEuLL) >> 32)},
   {(VUINT32) ((0xBFBF05D600000000uLL) >> 0),
    (VUINT32) ((0xBFBF05D600000000uLL) >> 32)},
   {(VUINT32) ((0xBE4DB610EEE1B81BuLL) >> 0),
    (VUINT32) ((0xBE4DB610EEE1B81BuLL) >> 32)},
   {(VUINT32) ((0xBFBED3A000000000uLL) >> 0),
    (VUINT32) ((0xBFBED3A000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A19B7978E8BB8uLL) >> 0),
    (VUINT32) ((0xBE6A19B7978E8BB8uLL) >> 32)},
   {(VUINT32) ((0xBFBEA17600000000uLL) >> 0),
    (VUINT32) ((0xBFBEA17600000000uLL) >> 32)},
   {(VUINT32) ((0xBE6F4CB6BF56F18EuLL) >> 0),
    (VUINT32) ((0xBE6F4CB6BF56F18EuLL) >> 32)},
   {(VUINT32) ((0xBFBE6F5100000000uLL) >> 0),
    (VUINT32) ((0xBFBE6F5100000000uLL) >> 32)},
   {(VUINT32) ((0xBE57F67E0BD3B63FuLL) >> 0),
    (VUINT32) ((0xBE57F67E0BD3B63FuLL) >> 32)},
   {(VUINT32) ((0xBFBE3D3300000000uLL) >> 0),
    (VUINT32) ((0xBFBE3D3300000000uLL) >> 32)},
   {(VUINT32) ((0xBE666A27D6A83D6CuLL) >> 0),
    (VUINT32) ((0xBE666A27D6A83D6CuLL) >> 32)},
   {(VUINT32) ((0xBFBE0B1A00000000uLL) >> 0),
    (VUINT32) ((0xBFBE0B1A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE523CBF0C85FA27uLL) >> 0),
    (VUINT32) ((0xBE523CBF0C85FA27uLL) >> 32)},
   {(VUINT32) ((0xBFBDD90800000000uLL) >> 0),
    (VUINT32) ((0xBFBDD90800000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A7CED811F7DA6uLL) >> 0),
    (VUINT32) ((0xBE6A7CED811F7DA6uLL) >> 32)},
   {(VUINT32) ((0xBFBDA6FF00000000uLL) >> 0),
    (VUINT32) ((0xBFBDA6FF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5615E1BD550182uLL) >> 0),
    (VUINT32) ((0xBE5615E1BD550182uLL) >> 32)},
   {(VUINT32) ((0xBFBD74FD00000000uLL) >> 0),
    (VUINT32) ((0xBFBD74FD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B4DA043725D03uLL) >> 0),
    (VUINT32) ((0xBE6B4DA043725D03uLL) >> 32)},
   {(VUINT32) ((0xBFBD430000000000uLL) >> 0),
    (VUINT32) ((0xBFBD430000000000uLL) >> 32)},
   {(VUINT32) ((0xBE658A49AA2DCA64uLL) >> 0),
    (VUINT32) ((0xBE658A49AA2DCA64uLL) >> 32)},
   {(VUINT32) ((0xBFBD110B00000000uLL) >> 0),
    (VUINT32) ((0xBFBD110B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6066543AD84EF1uLL) >> 0),
    (VUINT32) ((0xBE6066543AD84EF1uLL) >> 32)},
   {(VUINT32) ((0xBFBCDF1A00000000uLL) >> 0),
    (VUINT32) ((0xBFBCDF1A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE66073D700E9F19uLL) >> 0),
    (VUINT32) ((0xBE66073D700E9F19uLL) >> 32)},
   {(VUINT32) ((0xBFBCAD3500000000uLL) >> 0),
    (VUINT32) ((0xBFBCAD3500000000uLL) >> 32)},
   {(VUINT32) ((0xBE63A29CD758D759uLL) >> 0),
    (VUINT32) ((0xBE63A29CD758D759uLL) >> 32)},
   {(VUINT32) ((0xBFBC7B5100000000uLL) >> 0),
    (VUINT32) ((0xBFBC7B5100000000uLL) >> 32)},
   {(VUINT32) ((0xBE49B8777D6BBC9DuLL) >> 0),
    (VUINT32) ((0xBE49B8777D6BBC9DuLL) >> 32)},
   {(VUINT32) ((0xBFBC497800000000uLL) >> 0),
    (VUINT32) ((0xBFBC497800000000uLL) >> 32)},
   {(VUINT32) ((0xBE623F87F4487FE4uLL) >> 0),
    (VUINT32) ((0xBE623F87F4487FE4uLL) >> 32)},
   {(VUINT32) ((0xBFBC17A400000000uLL) >> 0),
    (VUINT32) ((0xBFBC17A400000000uLL) >> 32)},
   {(VUINT32) ((0xBE55196CB4C66620uLL) >> 0),
    (VUINT32) ((0xBE55196CB4C66620uLL) >> 32)},
   {(VUINT32) ((0xBFBBE5D800000000uLL) >> 0),
    (VUINT32) ((0xBFBBE5D800000000uLL) >> 32)},
   {(VUINT32) ((0xBE496E785A0317A3uLL) >> 0),
    (VUINT32) ((0xBE496E785A0317A3uLL) >> 32)},
   {(VUINT32) ((0xBFBBB41000000000uLL) >> 0),
    (VUINT32) ((0xBFBBB41000000000uLL) >> 32)},
   {(VUINT32) ((0xBE5EE49501957B40uLL) >> 0),
    (VUINT32) ((0xBE5EE49501957B40uLL) >> 32)},
   {(VUINT32) ((0xBFBB825000000000uLL) >> 0),
    (VUINT32) ((0xBFBB825000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6CF6DF4849748BuLL) >> 0),
    (VUINT32) ((0xBE6CF6DF4849748BuLL) >> 32)},
   {(VUINT32) ((0xBFBB509500000000uLL) >> 0),
    (VUINT32) ((0xBFBB509500000000uLL) >> 32)},
   {(VUINT32) ((0xBE688F964BD70C8FuLL) >> 0),
    (VUINT32) ((0xBE688F964BD70C8FuLL) >> 32)},
   {(VUINT32) ((0xBFBB1EE600000000uLL) >> 0),
    (VUINT32) ((0xBFBB1EE600000000uLL) >> 32)},
   {(VUINT32) ((0xBE6072C317519BB4uLL) >> 0),
    (VUINT32) ((0xBE6072C317519BB4uLL) >> 32)},
   {(VUINT32) ((0xBFBAED3800000000uLL) >> 0),
    (VUINT32) ((0xBFBAED3800000000uLL) >> 32)},
   {(VUINT32) ((0xBE05B3290A662BD0uLL) >> 0),
    (VUINT32) ((0xBE05B3290A662BD0uLL) >> 32)},
   {(VUINT32) ((0xBFBABB9500000000uLL) >> 0),
    (VUINT32) ((0xBFBABB9500000000uLL) >> 32)},
   {(VUINT32) ((0xBE5B246AD0582C09uLL) >> 0),
    (VUINT32) ((0xBE5B246AD0582C09uLL) >> 32)},
   {(VUINT32) ((0xBFBA89F700000000uLL) >> 0),
    (VUINT32) ((0xBFBA89F700000000uLL) >> 32)},
   {(VUINT32) ((0xBE55372721811F66uLL) >> 0),
    (VUINT32) ((0xBE55372721811F66uLL) >> 32)},
   {(VUINT32) ((0xBFBA585D00000000uLL) >> 0),
    (VUINT32) ((0xBFBA585D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE67C995FE88BCE3uLL) >> 0),
    (VUINT32) ((0xBE67C995FE88BCE3uLL) >> 32)},
   {(VUINT32) ((0xBFBA26CC00000000uLL) >> 0),
    (VUINT32) ((0xBFBA26CC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE596605E161E768uLL) >> 0),
    (VUINT32) ((0xBE596605E161E768uLL) >> 32)},
   {(VUINT32) ((0xBFB9F54300000000uLL) >> 0),
    (VUINT32) ((0xBFB9F54300000000uLL) >> 32)},
   {(VUINT32) ((0xBE53BD6EA8CDCABFuLL) >> 0),
    (VUINT32) ((0xBE53BD6EA8CDCABFuLL) >> 32)},
   {(VUINT32) ((0xBFB9C3BE00000000uLL) >> 0),
    (VUINT32) ((0xBFB9C3BE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6873A6488F239EuLL) >> 0),
    (VUINT32) ((0xBE6873A6488F239EuLL) >> 32)},
   {(VUINT32) ((0xBFB9924200000000uLL) >> 0),
    (VUINT32) ((0xBFB9924200000000uLL) >> 32)},
   {(VUINT32) ((0xBE6038DB2539E54EuLL) >> 0),
    (VUINT32) ((0xBE6038DB2539E54EuLL) >> 32)},
   {(VUINT32) ((0xBFB960CA00000000uLL) >> 0),
    (VUINT32) ((0xBFB960CA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6A3576F0EB47EAuLL) >> 0),
    (VUINT32) ((0xBE6A3576F0EB47EAuLL) >> 32)},
   {(VUINT32) ((0xBFB92F5B00000000uLL) >> 0),
    (VUINT32) ((0xBFB92F5B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5CA16578E782D8uLL) >> 0),
    (VUINT32) ((0xBE5CA16578E782D8uLL) >> 32)},
   {(VUINT32) ((0xBFB8FDF000000000uLL) >> 0),
    (VUINT32) ((0xBFB8FDF000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6571DD058C9404uLL) >> 0),
    (VUINT32) ((0xBE6571DD058C9404uLL) >> 32)},
   {(VUINT32) ((0xBFB8CC8E00000000uLL) >> 0),
    (VUINT32) ((0xBFB8CC8E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E8172926B3912uLL) >> 0),
    (VUINT32) ((0xBE4E8172926B3912uLL) >> 32)},
   {(VUINT32) ((0xBFB89B3400000000uLL) >> 0),
    (VUINT32) ((0xBFB89B3400000000uLL) >> 32)},
   {(VUINT32) ((0xBE458EB8A49A1ED9uLL) >> 0),
    (VUINT32) ((0xBE458EB8A49A1ED9uLL) >> 32)},
   {(VUINT32) ((0xBFB869DE00000000uLL) >> 0),
    (VUINT32) ((0xBFB869DE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE67736434037B3EuLL) >> 0),
    (VUINT32) ((0xBE67736434037B3EuLL) >> 32)},
   {(VUINT32) ((0xBFB8388D00000000uLL) >> 0),
    (VUINT32) ((0xBFB8388D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6E2728B7069E85uLL) >> 0),
    (VUINT32) ((0xBE6E2728B7069E85uLL) >> 32)},
   {(VUINT32) ((0xBFB8074500000000uLL) >> 0),
    (VUINT32) ((0xBFB8074500000000uLL) >> 32)},
   {(VUINT32) ((0xBE61C6BCD5B504DEuLL) >> 0),
    (VUINT32) ((0xBE61C6BCD5B504DEuLL) >> 32)},
   {(VUINT32) ((0xBFB7D60500000000uLL) >> 0),
    (VUINT32) ((0xBFB7D60500000000uLL) >> 32)},
   {(VUINT32) ((0xBE62D9F791FD12F7uLL) >> 0),
    (VUINT32) ((0xBE62D9F791FD12F7uLL) >> 32)},
   {(VUINT32) ((0xBFB7A4CA00000000uLL) >> 0),
    (VUINT32) ((0xBFB7A4CA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE53B18B476F88BFuLL) >> 0),
    (VUINT32) ((0xBE53B18B476F88BFuLL) >> 32)},
   {(VUINT32) ((0xBFB7739300000000uLL) >> 0),
    (VUINT32) ((0xBFB7739300000000uLL) >> 32)},
   {(VUINT32) ((0xBE671B2AD71BBA2EuLL) >> 0),
    (VUINT32) ((0xBE671B2AD71BBA2EuLL) >> 32)},
   {(VUINT32) ((0xBFB7426500000000uLL) >> 0),
    (VUINT32) ((0xBFB7426500000000uLL) >> 32)},
   {(VUINT32) ((0xBE6329422BBD68E8uLL) >> 0),
    (VUINT32) ((0xBE6329422BBD68E8uLL) >> 32)},
   {(VUINT32) ((0xBFB7113F00000000uLL) >> 0),
    (VUINT32) ((0xBFB7113F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6E8B3C2FE4ECAEuLL) >> 0),
    (VUINT32) ((0xBE6E8B3C2FE4ECAEuLL) >> 32)},
   {(VUINT32) ((0xBFB6E01F00000000uLL) >> 0),
    (VUINT32) ((0xBFB6E01F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE2795EDD5ED58E9uLL) >> 0),
    (VUINT32) ((0xBE2795EDD5ED58E9uLL) >> 32)},
   {(VUINT32) ((0xBFB6AF0200000000uLL) >> 0),
    (VUINT32) ((0xBFB6AF0200000000uLL) >> 32)},
   {(VUINT32) ((0xBE6C4C07447A13FAuLL) >> 0),
    (VUINT32) ((0xBE6C4C07447A13FAuLL) >> 32)},
   {(VUINT32) ((0xBFB67DEF00000000uLL) >> 0),
    (VUINT32) ((0xBFB67DEF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4F2EA58340E81EuLL) >> 0),
    (VUINT32) ((0xBE4F2EA58340E81EuLL) >> 32)},
   {(VUINT32) ((0xBFB64CE400000000uLL) >> 0),
    (VUINT32) ((0xBFB64CE400000000uLL) >> 32)},
   {(VUINT32) ((0xBE4203398A8FFDA4uLL) >> 0),
    (VUINT32) ((0xBE4203398A8FFDA4uLL) >> 32)},
   {(VUINT32) ((0xBFB61BDA00000000uLL) >> 0),
    (VUINT32) ((0xBFB61BDA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE2D4147AD124EAAuLL) >> 0),
    (VUINT32) ((0xBE2D4147AD124EAAuLL) >> 32)},
   {(VUINT32) ((0xBFB5EADC00000000uLL) >> 0),
    (VUINT32) ((0xBFB5EADC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE539C66835B9867uLL) >> 0),
    (VUINT32) ((0xBE539C66835B9867uLL) >> 32)},
   {(VUINT32) ((0xBFB5B9DF00000000uLL) >> 0),
    (VUINT32) ((0xBFB5B9DF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6317F3D15A9860uLL) >> 0),
    (VUINT32) ((0xBE6317F3D15A9860uLL) >> 32)},
   {(VUINT32) ((0xBFB588EF00000000uLL) >> 0),
    (VUINT32) ((0xBFB588EF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE503474104B244EuLL) >> 0),
    (VUINT32) ((0xBE503474104B244EuLL) >> 32)},
   {(VUINT32) ((0xBFB557FF00000000uLL) >> 0),
    (VUINT32) ((0xBFB557FF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6F1DFAE0BD2E94uLL) >> 0),
    (VUINT32) ((0xBE6F1DFAE0BD2E94uLL) >> 32)},
   {(VUINT32) ((0xBFB5271900000000uLL) >> 0),
    (VUINT32) ((0xBFB5271900000000uLL) >> 32)},
   {(VUINT32) ((0xBE541889EF09D7C8uLL) >> 0),
    (VUINT32) ((0xBE541889EF09D7C8uLL) >> 32)},
   {(VUINT32) ((0xBFB4F63B00000000uLL) >> 0),
    (VUINT32) ((0xBFB4F63B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE52DC76D475D4D1uLL) >> 0),
    (VUINT32) ((0xBE52DC76D475D4D1uLL) >> 32)},
   {(VUINT32) ((0xBFB4C56200000000uLL) >> 0),
    (VUINT32) ((0xBFB4C56200000000uLL) >> 32)},
   {(VUINT32) ((0xBE433458770A1735uLL) >> 0),
    (VUINT32) ((0xBE433458770A1735uLL) >> 32)},
   {(VUINT32) ((0xBFB4948D00000000uLL) >> 0),
    (VUINT32) ((0xBFB4948D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6C8223B5C8B49BuLL) >> 0),
    (VUINT32) ((0xBE6C8223B5C8B49BuLL) >> 32)},
   {(VUINT32) ((0xBFB463C200000000uLL) >> 0),
    (VUINT32) ((0xBFB463C200000000uLL) >> 32)},
   {(VUINT32) ((0xBE540D91E2302042uLL) >> 0),
    (VUINT32) ((0xBE540D91E2302042uLL) >> 32)},
   {(VUINT32) ((0xBFB432FB00000000uLL) >> 0),
    (VUINT32) ((0xBFB432FB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE64B47F064D986FuLL) >> 0),
    (VUINT32) ((0xBE64B47F064D986FuLL) >> 32)},
   {(VUINT32) ((0xBFB4023900000000uLL) >> 0),
    (VUINT32) ((0xBFB4023900000000uLL) >> 32)},
   {(VUINT32) ((0xBE6CE4D526C81E43uLL) >> 0),
    (VUINT32) ((0xBE6CE4D526C81E43uLL) >> 32)},
   {(VUINT32) ((0xBFB3D18000000000uLL) >> 0),
    (VUINT32) ((0xBFB3D18000000000uLL) >> 32)},
   {(VUINT32) ((0xBE6C41714A091D46uLL) >> 0),
    (VUINT32) ((0xBE6C41714A091D46uLL) >> 32)},
   {(VUINT32) ((0xBFB3A0D000000000uLL) >> 0),
    (VUINT32) ((0xBFB3A0D000000000uLL) >> 32)},
   {(VUINT32) ((0xBE63540DB8C80703uLL) >> 0),
    (VUINT32) ((0xBE63540DB8C80703uLL) >> 32)},
   {(VUINT32) ((0xBFB3702100000000uLL) >> 0),
    (VUINT32) ((0xBFB3702100000000uLL) >> 32)},
   {(VUINT32) ((0xBE5F8CF1A845A25CuLL) >> 0),
    (VUINT32) ((0xBE5F8CF1A845A25CuLL) >> 32)},
   {(VUINT32) ((0xBFB33F7B00000000uLL) >> 0),
    (VUINT32) ((0xBFB33F7B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE430A65C7A2686FuLL) >> 0),
    (VUINT32) ((0xBE430A65C7A2686FuLL) >> 32)},
   {(VUINT32) ((0xBFB30EDD00000000uLL) >> 0),
    (VUINT32) ((0xBFB30EDD00000000uLL) >> 32)},
   {(VUINT32) ((0xBE62D26A7215665CuLL) >> 0),
    (VUINT32) ((0xBE62D26A7215665CuLL) >> 32)},
   {(VUINT32) ((0xBFB2DE4500000000uLL) >> 0),
    (VUINT32) ((0xBFB2DE4500000000uLL) >> 32)},
   {(VUINT32) ((0xBE1BFF57E3BAB991uLL) >> 0),
    (VUINT32) ((0xBE1BFF57E3BAB991uLL) >> 32)},
   {(VUINT32) ((0xBFB2ADB100000000uLL) >> 0),
    (VUINT32) ((0xBFB2ADB100000000uLL) >> 32)},
   {(VUINT32) ((0xBE5E8ADFC156E82DuLL) >> 0),
    (VUINT32) ((0xBE5E8ADFC156E82DuLL) >> 32)},
   {(VUINT32) ((0xBFB27D2200000000uLL) >> 0),
    (VUINT32) ((0xBFB27D2200000000uLL) >> 32)},
   {(VUINT32) ((0xBE6E5D041C5F1A05uLL) >> 0),
    (VUINT32) ((0xBE6E5D041C5F1A05uLL) >> 32)},
   {(VUINT32) ((0xBFB24C9D00000000uLL) >> 0),
    (VUINT32) ((0xBFB24C9D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE50A21095DF344CuLL) >> 0),
    (VUINT32) ((0xBE50A21095DF344CuLL) >> 32)},
   {(VUINT32) ((0xBFB21C2000000000uLL) >> 0),
    (VUINT32) ((0xBFB21C2000000000uLL) >> 32)},
   {(VUINT32) ((0xBE5B57C218054E22uLL) >> 0),
    (VUINT32) ((0xBE5B57C218054E22uLL) >> 32)},
   {(VUINT32) ((0xBFB1EBA400000000uLL) >> 0),
    (VUINT32) ((0xBFB1EBA400000000uLL) >> 32)},
   {(VUINT32) ((0xBE6B1806F4988888uLL) >> 0),
    (VUINT32) ((0xBE6B1806F4988888uLL) >> 32)},
   {(VUINT32) ((0xBFB1BB3200000000uLL) >> 0),
    (VUINT32) ((0xBFB1BB3200000000uLL) >> 32)},
   {(VUINT32) ((0xBE430029DC60A716uLL) >> 0),
    (VUINT32) ((0xBE430029DC60A716uLL) >> 32)},
   {(VUINT32) ((0xBFB18AC400000000uLL) >> 0),
    (VUINT32) ((0xBFB18AC400000000uLL) >> 32)},
   {(VUINT32) ((0xBE611E8ED29C4BEAuLL) >> 0),
    (VUINT32) ((0xBE611E8ED29C4BEAuLL) >> 32)},
   {(VUINT32) ((0xBFB15A5F00000000uLL) >> 0),
    (VUINT32) ((0xBFB15A5F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE6AAE4E1E1CD7E9uLL) >> 0),
    (VUINT32) ((0xBE6AAE4E1E1CD7E9uLL) >> 32)},
   {(VUINT32) ((0xBFB12A0000000000uLL) >> 0),
    (VUINT32) ((0xBFB12A0000000000uLL) >> 32)},
   {(VUINT32) ((0xBE4F2855166A96D5uLL) >> 0),
    (VUINT32) ((0xBE4F2855166A96D5uLL) >> 32)},
   {(VUINT32) ((0xBFB0F9A500000000uLL) >> 0),
    (VUINT32) ((0xBFB0F9A500000000uLL) >> 32)},
   {(VUINT32) ((0xBE68CCC743692647uLL) >> 0),
    (VUINT32) ((0xBE68CCC743692647uLL) >> 32)},
   {(VUINT32) ((0xBFB0C95400000000uLL) >> 0),
    (VUINT32) ((0xBFB0C95400000000uLL) >> 32)},
   {(VUINT32) ((0xBE50C2B8FF93EEA0uLL) >> 0),
    (VUINT32) ((0xBE50C2B8FF93EEA0uLL) >> 32)},
   {(VUINT32) ((0xBFB0990400000000uLL) >> 0),
    (VUINT32) ((0xBFB0990400000000uLL) >> 32)},
   {(VUINT32) ((0xBE329700306849F4uLL) >> 0),
    (VUINT32) ((0xBE329700306849F4uLL) >> 32)},
   {(VUINT32) ((0xBFB068C000000000uLL) >> 0),
    (VUINT32) ((0xBFB068C000000000uLL) >> 32)},
   {(VUINT32) ((0xBE661C7597DFA0CFuLL) >> 0),
    (VUINT32) ((0xBE661C7597DFA0CFuLL) >> 32)},
   {(VUINT32) ((0xBFB0387E00000000uLL) >> 0),
    (VUINT32) ((0xBFB0387E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE64F950C199FDD6uLL) >> 0),
    (VUINT32) ((0xBE64F950C199FDD6uLL) >> 32)},
   {(VUINT32) ((0xBFB0084500000000uLL) >> 0),
    (VUINT32) ((0xBFB0084500000000uLL) >> 32)},
   {(VUINT32) ((0xBE6434BDA55A11E5uLL) >> 0),
    (VUINT32) ((0xBE6434BDA55A11E5uLL) >> 32)},
   {(VUINT32) ((0xBFAFB02300000000uLL) >> 0),
    (VUINT32) ((0xBFAFB02300000000uLL) >> 32)},
   {(VUINT32) ((0xBE537435DBA745C1uLL) >> 0),
    (VUINT32) ((0xBE537435DBA745C1uLL) >> 32)},
   {(VUINT32) ((0xBFAF4FC600000000uLL) >> 0),
    (VUINT32) ((0xBFAF4FC600000000uLL) >> 32)},
   {(VUINT32) ((0xBE4793720209C664uLL) >> 0),
    (VUINT32) ((0xBE4793720209C664uLL) >> 32)},
   {(VUINT32) ((0xBFAEEF7B00000000uLL) >> 0),
    (VUINT32) ((0xBFAEEF7B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3E845C9D0173B4uLL) >> 0),
    (VUINT32) ((0xBE3E845C9D0173B4uLL) >> 32)},
   {(VUINT32) ((0xBFAE8F3A00000000uLL) >> 0),
    (VUINT32) ((0xBFAE8F3A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE527188BD53B8BFuLL) >> 0),
    (VUINT32) ((0xBE527188BD53B8BFuLL) >> 32)},
   {(VUINT32) ((0xBFAE2F0400000000uLL) >> 0),
    (VUINT32) ((0xBFAE2F0400000000uLL) >> 32)},
   {(VUINT32) ((0xBE49E4E1F2D00CB9uLL) >> 0),
    (VUINT32) ((0xBE49E4E1F2D00CB9uLL) >> 32)},
   {(VUINT32) ((0xBFADCED800000000uLL) >> 0),
    (VUINT32) ((0xBFADCED800000000uLL) >> 32)},
   {(VUINT32) ((0xBE57DB5B6132809AuLL) >> 0),
    (VUINT32) ((0xBE57DB5B6132809AuLL) >> 32)},
   {(VUINT32) ((0xBFAD6EBF00000000uLL) >> 0),
    (VUINT32) ((0xBFAD6EBF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE43C7FBABDF571FuLL) >> 0),
    (VUINT32) ((0xBE43C7FBABDF571FuLL) >> 32)},
   {(VUINT32) ((0xBFAD0EB000000000uLL) >> 0),
    (VUINT32) ((0xBFAD0EB000000000uLL) >> 32)},
   {(VUINT32) ((0xBE4C086873F1531FuLL) >> 0),
    (VUINT32) ((0xBE4C086873F1531FuLL) >> 32)},
   {(VUINT32) ((0xBFACAEAC00000000uLL) >> 0),
    (VUINT32) ((0xBFACAEAC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE33D01264312288uLL) >> 0),
    (VUINT32) ((0xBE33D01264312288uLL) >> 32)},
   {(VUINT32) ((0xBFAC4EB200000000uLL) >> 0),
    (VUINT32) ((0xBFAC4EB200000000uLL) >> 32)},
   {(VUINT32) ((0xBE4ED73A1B11C287uLL) >> 0),
    (VUINT32) ((0xBE4ED73A1B11C287uLL) >> 32)},
   {(VUINT32) ((0xBFABEECB00000000uLL) >> 0),
    (VUINT32) ((0xBFABEECB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE328D5761EA48D2uLL) >> 0),
    (VUINT32) ((0xBE328D5761EA48D2uLL) >> 32)},
   {(VUINT32) ((0xBFAB8EEE00000000uLL) >> 0),
    (VUINT32) ((0xBFAB8EEE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E2759579AC08AuLL) >> 0),
    (VUINT32) ((0xBE4E2759579AC08AuLL) >> 32)},
   {(VUINT32) ((0xBFAB2F1C00000000uLL) >> 0),
    (VUINT32) ((0xBFAB2F1C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4EEA927B8DE26EuLL) >> 0),
    (VUINT32) ((0xBE4EEA927B8DE26EuLL) >> 32)},
   {(VUINT32) ((0xBFAACF5500000000uLL) >> 0),
    (VUINT32) ((0xBFAACF5500000000uLL) >> 32)},
   {(VUINT32) ((0xBE3A03EC4341A4ACuLL) >> 0),
    (VUINT32) ((0xBE3A03EC4341A4ACuLL) >> 32)},
   {(VUINT32) ((0xBFAA6F9800000000uLL) >> 0),
    (VUINT32) ((0xBFAA6F9800000000uLL) >> 32)},
   {(VUINT32) ((0xBE54EFB9656181BFuLL) >> 0),
    (VUINT32) ((0xBE54EFB9656181BFuLL) >> 32)},
   {(VUINT32) ((0xBFAA0FEE00000000uLL) >> 0),
    (VUINT32) ((0xBFAA0FEE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE529AA680456564uLL) >> 0),
    (VUINT32) ((0xBE529AA680456564uLL) >> 32)},
   {(VUINT32) ((0xBFA9B04F00000000uLL) >> 0),
    (VUINT32) ((0xBFA9B04F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE42B60FBBF05015uLL) >> 0),
    (VUINT32) ((0xBE42B60FBBF05015uLL) >> 32)},
   {(VUINT32) ((0xBFA950BA00000000uLL) >> 0),
    (VUINT32) ((0xBFA950BA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE59EA4D388956ACuLL) >> 0),
    (VUINT32) ((0xBE59EA4D388956ACuLL) >> 32)},
   {(VUINT32) ((0xBFA8F13800000000uLL) >> 0),
    (VUINT32) ((0xBFA8F13800000000uLL) >> 32)},
   {(VUINT32) ((0xBE5C820F8DDADCD6uLL) >> 0),
    (VUINT32) ((0xBE5C820F8DDADCD6uLL) >> 32)},
   {(VUINT32) ((0xBFA891BA00000000uLL) >> 0),
    (VUINT32) ((0xBFA891BA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE27E05A334C58F7uLL) >> 0),
    (VUINT32) ((0xBE27E05A334C58F7uLL) >> 32)},
   {(VUINT32) ((0xBFA8324D00000000uLL) >> 0),
    (VUINT32) ((0xBFA8324D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5D3229B2BA0376uLL) >> 0),
    (VUINT32) ((0xBE5D3229B2BA0376uLL) >> 32)},
   {(VUINT32) ((0xBFA7D2EC00000000uLL) >> 0),
    (VUINT32) ((0xBFA7D2EC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE545E77C08ED94CuLL) >> 0),
    (VUINT32) ((0xBE545E77C08ED94CuLL) >> 32)},
   {(VUINT32) ((0xBFA7739600000000uLL) >> 0),
    (VUINT32) ((0xBFA7739600000000uLL) >> 32)},
   {(VUINT32) ((0xBE427656B6F95551uLL) >> 0),
    (VUINT32) ((0xBE427656B6F95551uLL) >> 32)},
   {(VUINT32) ((0xBFA7144A00000000uLL) >> 0),
    (VUINT32) ((0xBFA7144A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5C82A193D30405uLL) >> 0),
    (VUINT32) ((0xBE5C82A193D30405uLL) >> 32)},
   {(VUINT32) ((0xBFA6B50A00000000uLL) >> 0),
    (VUINT32) ((0xBFA6B50A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4DDEBD1F3C284AuLL) >> 0),
    (VUINT32) ((0xBE4DDEBD1F3C284AuLL) >> 32)},
   {(VUINT32) ((0xBFA655DC00000000uLL) >> 0),
    (VUINT32) ((0xBFA655DC00000000uLL) >> 32)},
   {(VUINT32) ((0xBE599C108199CFD8uLL) >> 0),
    (VUINT32) ((0xBE599C108199CFD8uLL) >> 32)},
   {(VUINT32) ((0xBFA5F6BA00000000uLL) >> 0),
    (VUINT32) ((0xBFA5F6BA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE348E1F3828F0D8uLL) >> 0),
    (VUINT32) ((0xBE348E1F3828F0D8uLL) >> 32)},
   {(VUINT32) ((0xBFA597A200000000uLL) >> 0),
    (VUINT32) ((0xBFA597A200000000uLL) >> 32)},
   {(VUINT32) ((0xBE5240BEB8DF56CAuLL) >> 0),
    (VUINT32) ((0xBE5240BEB8DF56CAuLL) >> 32)},
   {(VUINT32) ((0xBFA5389600000000uLL) >> 0),
    (VUINT32) ((0xBFA5389600000000uLL) >> 32)},
   {(VUINT32) ((0xBE1AED65370B9099uLL) >> 0),
    (VUINT32) ((0xBE1AED65370B9099uLL) >> 32)},
   {(VUINT32) ((0xBFA4D99400000000uLL) >> 0),
    (VUINT32) ((0xBFA4D99400000000uLL) >> 32)},
   {(VUINT32) ((0xBE5429166D091C5DuLL) >> 0),
    (VUINT32) ((0xBE5429166D091C5DuLL) >> 32)},
   {(VUINT32) ((0xBFA47A9E00000000uLL) >> 0),
    (VUINT32) ((0xBFA47A9E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE44D5DB06B75692uLL) >> 0),
    (VUINT32) ((0xBE44D5DB06B75692uLL) >> 32)},
   {(VUINT32) ((0xBFA41BBA00000000uLL) >> 0),
    (VUINT32) ((0xBFA41BBA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5E4FF2E670387AuLL) >> 0),
    (VUINT32) ((0xBE5E4FF2E670387AuLL) >> 32)},
   {(VUINT32) ((0xBFA3BCDA00000000uLL) >> 0),
    (VUINT32) ((0xBFA3BCDA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5E73DF6E675ED2uLL) >> 0),
    (VUINT32) ((0xBE5E73DF6E675ED2uLL) >> 32)},
   {(VUINT32) ((0xBFA35E0D00000000uLL) >> 0),
    (VUINT32) ((0xBFA35E0D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5DF2994AF6BBF0uLL) >> 0),
    (VUINT32) ((0xBE5DF2994AF6BBF0uLL) >> 32)},
   {(VUINT32) ((0xBFA2FF4C00000000uLL) >> 0),
    (VUINT32) ((0xBFA2FF4C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE31A09F65BFDEF1uLL) >> 0),
    (VUINT32) ((0xBE31A09F65BFDEF1uLL) >> 32)},
   {(VUINT32) ((0xBFA2A09500000000uLL) >> 0),
    (VUINT32) ((0xBFA2A09500000000uLL) >> 32)},
   {(VUINT32) ((0xBE5290BAFE6A7061uLL) >> 0),
    (VUINT32) ((0xBE5290BAFE6A7061uLL) >> 32)},
   {(VUINT32) ((0xBFA241EA00000000uLL) >> 0),
    (VUINT32) ((0xBFA241EA00000000uLL) >> 32)},
   {(VUINT32) ((0xBE425151C43B4181uLL) >> 0),
    (VUINT32) ((0xBE425151C43B4181uLL) >> 32)},
   {(VUINT32) ((0xBFA1E34A00000000uLL) >> 0),
    (VUINT32) ((0xBFA1E34A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE41D8DBC0646431uLL) >> 0),
    (VUINT32) ((0xBE41D8DBC0646431uLL) >> 32)},
   {(VUINT32) ((0xBFA184B500000000uLL) >> 0),
    (VUINT32) ((0xBFA184B500000000uLL) >> 32)},
   {(VUINT32) ((0xBE5298AC777C8C9DuLL) >> 0),
    (VUINT32) ((0xBE5298AC777C8C9DuLL) >> 32)},
   {(VUINT32) ((0xBFA1263400000000uLL) >> 0),
    (VUINT32) ((0xBFA1263400000000uLL) >> 32)},
   {(VUINT32) ((0xBE10A2F9D7E8035AuLL) >> 0),
    (VUINT32) ((0xBE10A2F9D7E8035AuLL) >> 32)},
   {(VUINT32) ((0xBFA0C7B600000000uLL) >> 0),
    (VUINT32) ((0xBFA0C7B600000000uLL) >> 32)},
   {(VUINT32) ((0xBE0BBC4C660FD088uLL) >> 0),
    (VUINT32) ((0xBE0BBC4C660FD088uLL) >> 32)},
   {(VUINT32) ((0xBFA0694B00000000uLL) >> 0),
    (VUINT32) ((0xBFA0694B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3CC374B7950D13uLL) >> 0),
    (VUINT32) ((0xBE3CC374B7950D13uLL) >> 32)},
   {(VUINT32) ((0xBFA00AEB00000000uLL) >> 0),
    (VUINT32) ((0xBFA00AEB00000000uLL) >> 32)},
   {(VUINT32) ((0xBE5AA058ACDC0265uLL) >> 0),
    (VUINT32) ((0xBE5AA058ACDC0265uLL) >> 32)},
   {(VUINT32) ((0xBF9F592000000000uLL) >> 0),
    (VUINT32) ((0xBF9F592000000000uLL) >> 32)},
   {(VUINT32) ((0xBE149B4D7E5DF2C0uLL) >> 0),
    (VUINT32) ((0xBE149B4D7E5DF2C0uLL) >> 32)},
   {(VUINT32) ((0xBF9E9C8F00000000uLL) >> 0),
    (VUINT32) ((0xBF9E9C8F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE10A7A7E78BDBA3uLL) >> 0),
    (VUINT32) ((0xBE10A7A7E78BDBA3uLL) >> 32)},
   {(VUINT32) ((0xBF9DE01500000000uLL) >> 0),
    (VUINT32) ((0xBF9DE01500000000uLL) >> 32)},
   {(VUINT32) ((0xBDE02A1D978DB2F1uLL) >> 0),
    (VUINT32) ((0xBDE02A1D978DB2F1uLL) >> 32)},
   {(VUINT32) ((0xBF9D23B100000000uLL) >> 0),
    (VUINT32) ((0xBF9D23B100000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E9227A287068EuLL) >> 0),
    (VUINT32) ((0xBE4E9227A287068EuLL) >> 32)},
   {(VUINT32) ((0xBF9C676500000000uLL) >> 0),
    (VUINT32) ((0xBF9C676500000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E8561096793F8uLL) >> 0),
    (VUINT32) ((0xBE4E8561096793F8uLL) >> 32)},
   {(VUINT32) ((0xBF9BAB3100000000uLL) >> 0),
    (VUINT32) ((0xBF9BAB3100000000uLL) >> 32)},
   {(VUINT32) ((0xBE0968E122179F22uLL) >> 0),
    (VUINT32) ((0xBE0968E122179F22uLL) >> 32)},
   {(VUINT32) ((0xBF9AEF1300000000uLL) >> 0),
    (VUINT32) ((0xBF9AEF1300000000uLL) >> 32)},
   {(VUINT32) ((0xBE328465C0DBA24FuLL) >> 0),
    (VUINT32) ((0xBE328465C0DBA24FuLL) >> 32)},
   {(VUINT32) ((0xBF9A330C00000000uLL) >> 0),
    (VUINT32) ((0xBF9A330C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE47051E31E0D70BuLL) >> 0),
    (VUINT32) ((0xBE47051E31E0D70BuLL) >> 32)},
   {(VUINT32) ((0xBF99771D00000000uLL) >> 0),
    (VUINT32) ((0xBF99771D00000000uLL) >> 32)},
   {(VUINT32) ((0xBE38B8D275FF3A9AuLL) >> 0),
    (VUINT32) ((0xBE38B8D275FF3A9AuLL) >> 32)},
   {(VUINT32) ((0xBF98BB5500000000uLL) >> 0),
    (VUINT32) ((0xBF98BB5500000000uLL) >> 32)},
   {(VUINT32) ((0xBE122BDB89883925uLL) >> 0),
    (VUINT32) ((0xBE122BDB89883925uLL) >> 32)},
   {(VUINT32) ((0xBF97FF9400000000uLL) >> 0),
    (VUINT32) ((0xBF97FF9400000000uLL) >> 32)},
   {(VUINT32) ((0xBE36FBF85D50FECBuLL) >> 0),
    (VUINT32) ((0xBE36FBF85D50FECBuLL) >> 32)},
   {(VUINT32) ((0xBF9743EB00000000uLL) >> 0),
    (VUINT32) ((0xBF9743EB00000000uLL) >> 32)},
   {(VUINT32) ((0xBDF87CBA8ECCAC44uLL) >> 0),
    (VUINT32) ((0xBDF87CBA8ECCAC44uLL) >> 32)},
   {(VUINT32) ((0xBF96886800000000uLL) >> 0),
    (VUINT32) ((0xBF96886800000000uLL) >> 32)},
   {(VUINT32) ((0xBE4BD57D800C1470uLL) >> 0),
    (VUINT32) ((0xBE4BD57D800C1470uLL) >> 32)},
   {(VUINT32) ((0xBF95CCEE00000000uLL) >> 0),
    (VUINT32) ((0xBF95CCEE00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3BE2933856D62EuLL) >> 0),
    (VUINT32) ((0xBE3BE2933856D62EuLL) >> 32)},
   {(VUINT32) ((0xBF95118B00000000uLL) >> 0),
    (VUINT32) ((0xBF95118B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE409620E0F1BE7BuLL) >> 0),
    (VUINT32) ((0xBE409620E0F1BE7BuLL) >> 32)},
   {(VUINT32) ((0xBF94564F00000000uLL) >> 0),
    (VUINT32) ((0xBF94564F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E4325CF62B811uLL) >> 0),
    (VUINT32) ((0xBE4E4325CF62B811uLL) >> 32)},
   {(VUINT32) ((0xBF939B1C00000000uLL) >> 0),
    (VUINT32) ((0xBF939B1C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE2ADEE9AF6A25C0uLL) >> 0),
    (VUINT32) ((0xBE2ADEE9AF6A25C0uLL) >> 32)},
   {(VUINT32) ((0xBF92E00000000000uLL) >> 0),
    (VUINT32) ((0xBF92E00000000000uLL) >> 32)},
   {(VUINT32) ((0xBE20CE46D28F63C9uLL) >> 0),
    (VUINT32) ((0xBE20CE46D28F63C9uLL) >> 32)},
   {(VUINT32) ((0xBF92250B00000000uLL) >> 0),
    (VUINT32) ((0xBF92250B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE41F6AA9FB6FE0BuLL) >> 0),
    (VUINT32) ((0xBE41F6AA9FB6FE0BuLL) >> 32)},
   {(VUINT32) ((0xBF916A1E00000000uLL) >> 0),
    (VUINT32) ((0xBF916A1E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E41409957601BuLL) >> 0),
    (VUINT32) ((0xBE4E41409957601BuLL) >> 32)},
   {(VUINT32) ((0xBF90AF5900000000uLL) >> 0),
    (VUINT32) ((0xBF90AF5900000000uLL) >> 32)},
   {(VUINT32) ((0xBE4E53E5A63658ADuLL) >> 0),
    (VUINT32) ((0xBE4E53E5A63658ADuLL) >> 32)},
   {(VUINT32) ((0xBF8FE93900000000uLL) >> 0),
    (VUINT32) ((0xBF8FE93900000000uLL) >> 32)},
   {(VUINT32) ((0xBE3EDED24D629D7DuLL) >> 0),
    (VUINT32) ((0xBE3EDED24D629D7DuLL) >> 32)},
   {(VUINT32) ((0xBF8E73EF00000000uLL) >> 0),
    (VUINT32) ((0xBF8E73EF00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3A29D2EA7D362BuLL) >> 0),
    (VUINT32) ((0xBE3A29D2EA7D362BuLL) >> 32)},
   {(VUINT32) ((0xBF8CFEF500000000uLL) >> 0),
    (VUINT32) ((0xBF8CFEF500000000uLL) >> 32)},
   {(VUINT32) ((0xBE1E2E79FE4AA765uLL) >> 0),
    (VUINT32) ((0xBE1E2E79FE4AA765uLL) >> 32)},
   {(VUINT32) ((0xBF8B8A0A00000000uLL) >> 0),
    (VUINT32) ((0xBF8B8A0A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3E8785027A216BuLL) >> 0),
    (VUINT32) ((0xBE3E8785027A216BuLL) >> 32)},
   {(VUINT32) ((0xBF8A155000000000uLL) >> 0),
    (VUINT32) ((0xBF8A155000000000uLL) >> 32)},
   {(VUINT32) ((0xBE37A174D5A8BDEDuLL) >> 0),
    (VUINT32) ((0xBE37A174D5A8BDEDuLL) >> 32)},
   {(VUINT32) ((0xBF88A0C600000000uLL) >> 0),
    (VUINT32) ((0xBF88A0C600000000uLL) >> 32)},
   {(VUINT32) ((0xBE35DDE88F39D7CEuLL) >> 0),
    (VUINT32) ((0xBE35DDE88F39D7CEuLL) >> 32)},
   {(VUINT32) ((0xBF872C6C00000000uLL) >> 0),
    (VUINT32) ((0xBF872C6C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE3C41EA3F44A785uLL) >> 0),
    (VUINT32) ((0xBE3C41EA3F44A785uLL) >> 32)},
   {(VUINT32) ((0xBF85B86300000000uLL) >> 0),
    (VUINT32) ((0xBF85B86300000000uLL) >> 32)},
   {(VUINT32) ((0xBE194C69FFD7F42DuLL) >> 0),
    (VUINT32) ((0xBE194C69FFD7F42DuLL) >> 32)},
   {(VUINT32) ((0xBF84446A00000000uLL) >> 0),
    (VUINT32) ((0xBF84446A00000000uLL) >> 32)},
   {(VUINT32) ((0xBE1A5E4E0D24AF39uLL) >> 0),
    (VUINT32) ((0xBE1A5E4E0D24AF39uLL) >> 32)},
   {(VUINT32) ((0xBF82D0A100000000uLL) >> 0),
    (VUINT32) ((0xBF82D0A100000000uLL) >> 32)},
   {(VUINT32) ((0xBE381611EB6C3818uLL) >> 0),
    (VUINT32) ((0xBE381611EB6C3818uLL) >> 32)},
   {(VUINT32) ((0xBF815D0900000000uLL) >> 0),
    (VUINT32) ((0xBF815D0900000000uLL) >> 32)},
   {(VUINT32) ((0xBE3DD5DA9CC5F987uLL) >> 0),
    (VUINT32) ((0xBE3DD5DA9CC5F987uLL) >> 32)},
   {(VUINT32) ((0xBF7FD34500000000uLL) >> 0),
    (VUINT32) ((0xBF7FD34500000000uLL) >> 32)},
   {(VUINT32) ((0xBE25BD80E0B0590EuLL) >> 0),
    (VUINT32) ((0xBE25BD80E0B0590EuLL) >> 32)},
   {(VUINT32) ((0xBF7CEC9900000000uLL) >> 0),
    (VUINT32) ((0xBF7CEC9900000000uLL) >> 32)},
   {(VUINT32) ((0xBE1CE47BB0EEA510uLL) >> 0),
    (VUINT32) ((0xBE1CE47BB0EEA510uLL) >> 32)},
   {(VUINT32) ((0xBF7A068E00000000uLL) >> 0),
    (VUINT32) ((0xBF7A068E00000000uLL) >> 32)},
   {(VUINT32) ((0xBE26DBE100877575uLL) >> 0),
    (VUINT32) ((0xBE26DBE100877575uLL) >> 32)},
   {(VUINT32) ((0xBF7720E600000000uLL) >> 0),
    (VUINT32) ((0xBF7720E600000000uLL) >> 32)},
   {(VUINT32) ((0xBD9AA4F614B9E1ACuLL) >> 0),
    (VUINT32) ((0xBD9AA4F614B9E1ACuLL) >> 32)},
   {(VUINT32) ((0xBF743B5F00000000uLL) >> 0),
    (VUINT32) ((0xBF743B5F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE271A96B1EB7842uLL) >> 0),
    (VUINT32) ((0xBE271A96B1EB7842uLL) >> 32)},
   {(VUINT32) ((0xBF71567B00000000uLL) >> 0),
    (VUINT32) ((0xBF71567B00000000uLL) >> 32)},
   {(VUINT32) ((0xBE2318F60005710DuLL) >> 0),
    (VUINT32) ((0xBE2318F60005710DuLL) >> 32)},
   {(VUINT32) ((0xBF6CE37400000000uLL) >> 0),
    (VUINT32) ((0xBF6CE37400000000uLL) >> 32)},
   {(VUINT32) ((0xBE0C7A4E122B1762uLL) >> 0),
    (VUINT32) ((0xBE0C7A4E122B1762uLL) >> 32)},
   {(VUINT32) ((0xBF671B3600000000uLL) >> 0),
    (VUINT32) ((0xBF671B3600000000uLL) >> 32)},
   {(VUINT32) ((0xBE1C85D1E3D214D1uLL) >> 0),
    (VUINT32) ((0xBE1C85D1E3D214D1uLL) >> 32)},
   {(VUINT32) ((0xBF61533F00000000uLL) >> 0),
    (VUINT32) ((0xBF61533F00000000uLL) >> 32)},
   {(VUINT32) ((0xBE0E793B61AA1F54uLL) >> 0),
    (VUINT32) ((0xBE0E793B61AA1F54uLL) >> 32)},
   {(VUINT32) ((0xBF57181C00000000uLL) >> 0),
    (VUINT32) ((0xBF57181C00000000uLL) >> 32)},
   {(VUINT32) ((0xBE01296A4555AF78uLL) >> 0),
    (VUINT32) ((0xBE01296A4555AF78uLL) >> 32)},
   {(VUINT32) ((0xBF47168E00000000uLL) >> 0),
    (VUINT32) ((0xBF47168E00000000uLL) >> 32)},
   {(VUINT32) ((0xBDF30D6F34EBFA1CuLL) >> 0),
    (VUINT32) ((0xBDF30D6F34EBFA1CuLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   },
  {

   {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   {(VUINT32) ((0x3FF0163DA9FB3335uLL) >> 0),
    (VUINT32) ((0x3FF0163DA9FB3335uLL) >> 32)},
   {(VUINT32) ((0x3C9B61299AB8CDB7uLL) >> 0),
    (VUINT32) ((0x3C9B61299AB8CDB7uLL) >> 32)},
   {(VUINT32) ((0x3FF02C9A3E778061uLL) >> 0),
    (VUINT32) ((0x3FF02C9A3E778061uLL) >> 32)},
   {(VUINT32) ((0xBC719083535B085DuLL) >> 0),
    (VUINT32) ((0xBC719083535B085DuLL) >> 32)},
   {(VUINT32) ((0x3FF04315E86E7F85uLL) >> 0),
    (VUINT32) ((0x3FF04315E86E7F85uLL) >> 32)},
   {(VUINT32) ((0xBC90A31C1977C96EuLL) >> 0),
    (VUINT32) ((0xBC90A31C1977C96EuLL) >> 32)},
   {(VUINT32) ((0x3FF059B0D3158574uLL) >> 0),
    (VUINT32) ((0x3FF059B0D3158574uLL) >> 32)},
   {(VUINT32) ((0x3C8D73E2A475B465uLL) >> 0),
    (VUINT32) ((0x3C8D73E2A475B465uLL) >> 32)},
   {(VUINT32) ((0x3FF0706B29DDF6DEuLL) >> 0),
    (VUINT32) ((0x3FF0706B29DDF6DEuLL) >> 32)},
   {(VUINT32) ((0xBC8C91DFE2B13C26uLL) >> 0),
    (VUINT32) ((0xBC8C91DFE2B13C26uLL) >> 32)},
   {(VUINT32) ((0x3FF0874518759BC8uLL) >> 0),
    (VUINT32) ((0x3FF0874518759BC8uLL) >> 32)},
   {(VUINT32) ((0x3C6186BE4BB284FFuLL) >> 0),
    (VUINT32) ((0x3C6186BE4BB284FFuLL) >> 32)},
   {(VUINT32) ((0x3FF09E3ECAC6F383uLL) >> 0),
    (VUINT32) ((0x3FF09E3ECAC6F383uLL) >> 32)},
   {(VUINT32) ((0x3C91487818316135uLL) >> 0),
    (VUINT32) ((0x3C91487818316135uLL) >> 32)},
   {(VUINT32) ((0x3FF0B5586CF9890FuLL) >> 0),
    (VUINT32) ((0x3FF0B5586CF9890FuLL) >> 32)},
   {(VUINT32) ((0x3C98A62E4ADC610AuLL) >> 0),
    (VUINT32) ((0x3C98A62E4ADC610AuLL) >> 32)},
   {(VUINT32) ((0x3FF0CC922B7247F7uLL) >> 0),
    (VUINT32) ((0x3FF0CC922B7247F7uLL) >> 32)},
   {(VUINT32) ((0x3C901EDC16E24F71uLL) >> 0),
    (VUINT32) ((0x3C901EDC16E24F71uLL) >> 32)},
   {(VUINT32) ((0x3FF0E3EC32D3D1A2uLL) >> 0),
    (VUINT32) ((0x3FF0E3EC32D3D1A2uLL) >> 32)},
   {(VUINT32) ((0x3C403A1727C57B52uLL) >> 0),
    (VUINT32) ((0x3C403A1727C57B52uLL) >> 32)},
   {(VUINT32) ((0x3FF0FB66AFFED31BuLL) >> 0),
    (VUINT32) ((0x3FF0FB66AFFED31BuLL) >> 32)},
   {(VUINT32) ((0xBC6B9BEDC44EBD7BuLL) >> 0),
    (VUINT32) ((0xBC6B9BEDC44EBD7BuLL) >> 32)},
   {(VUINT32) ((0x3FF11301D0125B51uLL) >> 0),
    (VUINT32) ((0x3FF11301D0125B51uLL) >> 32)},
   {(VUINT32) ((0xBC96C51039449B39uLL) >> 0),
    (VUINT32) ((0xBC96C51039449B39uLL) >> 32)},
   {(VUINT32) ((0x3FF12ABDC06C31CCuLL) >> 0),
    (VUINT32) ((0x3FF12ABDC06C31CCuLL) >> 32)},
   {(VUINT32) ((0xBC51B514B36CA5C7uLL) >> 0),
    (VUINT32) ((0xBC51B514B36CA5C7uLL) >> 32)},
   {(VUINT32) ((0x3FF1429AAEA92DE0uLL) >> 0),
    (VUINT32) ((0x3FF1429AAEA92DE0uLL) >> 32)},
   {(VUINT32) ((0xBC932FBF9AF1369EuLL) >> 0),
    (VUINT32) ((0xBC932FBF9AF1369EuLL) >> 32)},
   {(VUINT32) ((0x3FF15A98C8A58E51uLL) >> 0),
    (VUINT32) ((0x3FF15A98C8A58E51uLL) >> 32)},
   {(VUINT32) ((0x3C82406AB9EEAB09uLL) >> 0),
    (VUINT32) ((0x3C82406AB9EEAB09uLL) >> 32)},
   {(VUINT32) ((0x3FF172B83C7D517BuLL) >> 0),
    (VUINT32) ((0x3FF172B83C7D517BuLL) >> 32)},
   {(VUINT32) ((0xBC819041B9D78A75uLL) >> 0),
    (VUINT32) ((0xBC819041B9D78A75uLL) >> 32)},
   {(VUINT32) ((0x3FF18AF9388C8DEAuLL) >> 0),
    (VUINT32) ((0x3FF18AF9388C8DEAuLL) >> 32)},
   {(VUINT32) ((0xBC911023D1970F6BuLL) >> 0),
    (VUINT32) ((0xBC911023D1970F6BuLL) >> 32)},
   {(VUINT32) ((0x3FF1A35BEB6FCB75uLL) >> 0),
    (VUINT32) ((0x3FF1A35BEB6FCB75uLL) >> 32)},
   {(VUINT32) ((0x3C8E5B4C7B4968E4uLL) >> 0),
    (VUINT32) ((0x3C8E5B4C7B4968E4uLL) >> 32)},
   {(VUINT32) ((0x3FF1BBE084045CD4uLL) >> 0),
    (VUINT32) ((0x3FF1BBE084045CD4uLL) >> 32)},
   {(VUINT32) ((0xBC995386352EF607uLL) >> 0),
    (VUINT32) ((0xBC995386352EF607uLL) >> 32)},
   {(VUINT32) ((0x3FF1D4873168B9AAuLL) >> 0),
    (VUINT32) ((0x3FF1D4873168B9AAuLL) >> 32)},
   {(VUINT32) ((0x3C9E016E00A2643CuLL) >> 0),
    (VUINT32) ((0x3C9E016E00A2643CuLL) >> 32)},
   {(VUINT32) ((0x3FF1ED5022FCD91DuLL) >> 0),
    (VUINT32) ((0x3FF1ED5022FCD91DuLL) >> 32)},
   {(VUINT32) ((0xBC91DF98027BB78BuLL) >> 0),
    (VUINT32) ((0xBC91DF98027BB78BuLL) >> 32)},
   {(VUINT32) ((0x3FF2063B88628CD6uLL) >> 0),
    (VUINT32) ((0x3FF2063B88628CD6uLL) >> 32)},
   {(VUINT32) ((0x3C8DC775814A8494uLL) >> 0),
    (VUINT32) ((0x3C8DC775814A8494uLL) >> 32)},
   {(VUINT32) ((0x3FF21F49917DDC96uLL) >> 0),
    (VUINT32) ((0x3FF21F49917DDC96uLL) >> 32)},
   {(VUINT32) ((0x3C82A97E9494A5EDuLL) >> 0),
    (VUINT32) ((0x3C82A97E9494A5EDuLL) >> 32)},
   {(VUINT32) ((0x3FF2387A6E756238uLL) >> 0),
    (VUINT32) ((0x3FF2387A6E756238uLL) >> 32)},
   {(VUINT32) ((0x3C99B07EB6C70572uLL) >> 0),
    (VUINT32) ((0x3C99B07EB6C70572uLL) >> 32)},
   {(VUINT32) ((0x3FF251CE4FB2A63FuLL) >> 0),
    (VUINT32) ((0x3FF251CE4FB2A63FuLL) >> 32)},
   {(VUINT32) ((0x3C8AC155BEF4F4A4uLL) >> 0),
    (VUINT32) ((0x3C8AC155BEF4F4A4uLL) >> 32)},
   {(VUINT32) ((0x3FF26B4565E27CDDuLL) >> 0),
    (VUINT32) ((0x3FF26B4565E27CDDuLL) >> 32)},
   {(VUINT32) ((0x3C82BD339940E9D9uLL) >> 0),
    (VUINT32) ((0x3C82BD339940E9D9uLL) >> 32)},
   {(VUINT32) ((0x3FF284DFE1F56381uLL) >> 0),
    (VUINT32) ((0x3FF284DFE1F56381uLL) >> 32)},
   {(VUINT32) ((0xBC9A4C3A8C3F0D7DuLL) >> 0),
    (VUINT32) ((0xBC9A4C3A8C3F0D7DuLL) >> 32)},
   {(VUINT32) ((0x3FF29E9DF51FDEE1uLL) >> 0),
    (VUINT32) ((0x3FF29E9DF51FDEE1uLL) >> 32)},
   {(VUINT32) ((0x3C8612E8AFAD1255uLL) >> 0),
    (VUINT32) ((0x3C8612E8AFAD1255uLL) >> 32)},
   {(VUINT32) ((0x3FF2B87FD0DAD990uLL) >> 0),
    (VUINT32) ((0x3FF2B87FD0DAD990uLL) >> 32)},
   {(VUINT32) ((0xBC410ADCD6381AA3uLL) >> 0),
    (VUINT32) ((0xBC410ADCD6381AA3uLL) >> 32)},
   {(VUINT32) ((0x3FF2D285A6E4030BuLL) >> 0),
    (VUINT32) ((0x3FF2D285A6E4030BuLL) >> 32)},
   {(VUINT32) ((0x3C90024754DB41D4uLL) >> 0),
    (VUINT32) ((0x3C90024754DB41D4uLL) >> 32)},
   {(VUINT32) ((0x3FF2ECAFA93E2F56uLL) >> 0),
    (VUINT32) ((0x3FF2ECAFA93E2F56uLL) >> 32)},
   {(VUINT32) ((0x3C71CA0F45D52383uLL) >> 0),
    (VUINT32) ((0x3C71CA0F45D52383uLL) >> 32)},
   {(VUINT32) ((0x3FF306FE0A31B715uLL) >> 0),
    (VUINT32) ((0x3FF306FE0A31B715uLL) >> 32)},
   {(VUINT32) ((0x3C86F46AD23182E4uLL) >> 0),
    (VUINT32) ((0x3C86F46AD23182E4uLL) >> 32)},
   {(VUINT32) ((0x3FF32170FC4CD831uLL) >> 0),
    (VUINT32) ((0x3FF32170FC4CD831uLL) >> 32)},
   {(VUINT32) ((0x3C8A9CE78E18047CuLL) >> 0),
    (VUINT32) ((0x3C8A9CE78E18047CuLL) >> 32)},
   {(VUINT32) ((0x3FF33C08B26416FFuLL) >> 0),
    (VUINT32) ((0x3FF33C08B26416FFuLL) >> 32)},
   {(VUINT32) ((0x3C932721843659A5uLL) >> 0),
    (VUINT32) ((0x3C932721843659A5uLL) >> 32)},
   {(VUINT32) ((0x3FF356C55F929FF1uLL) >> 0),
    (VUINT32) ((0x3FF356C55F929FF1uLL) >> 32)},
   {(VUINT32) ((0xBC8B5CEE5C4E4628uLL) >> 0),
    (VUINT32) ((0xBC8B5CEE5C4E4628uLL) >> 32)},
   {(VUINT32) ((0x3FF371A7373AA9CBuLL) >> 0),
    (VUINT32) ((0x3FF371A7373AA9CBuLL) >> 32)},
   {(VUINT32) ((0xBC963AEABF42EAE1uLL) >> 0),
    (VUINT32) ((0xBC963AEABF42EAE1uLL) >> 32)},
   {(VUINT32) ((0x3FF38CAE6D05D866uLL) >> 0),
    (VUINT32) ((0x3FF38CAE6D05D866uLL) >> 32)},
   {(VUINT32) ((0xBC9E958D3C9904BCuLL) >> 0),
    (VUINT32) ((0xBC9E958D3C9904BCuLL) >> 32)},
   {(VUINT32) ((0x3FF3A7DB34E59FF7uLL) >> 0),
    (VUINT32) ((0x3FF3A7DB34E59FF7uLL) >> 32)},
   {(VUINT32) ((0xBC75E436D661F5E2uLL) >> 0),
    (VUINT32) ((0xBC75E436D661F5E2uLL) >> 32)},
   {(VUINT32) ((0x3FF3C32DC313A8E5uLL) >> 0),
    (VUINT32) ((0x3FF3C32DC313A8E5uLL) >> 32)},
   {(VUINT32) ((0xBC9EFFF8375D29C3uLL) >> 0),
    (VUINT32) ((0xBC9EFFF8375D29C3uLL) >> 32)},
   {(VUINT32) ((0x3FF3DEA64C123422uLL) >> 0),
    (VUINT32) ((0x3FF3DEA64C123422uLL) >> 32)},
   {(VUINT32) ((0x3C8ADA0911F09EBBuLL) >> 0),
    (VUINT32) ((0x3C8ADA0911F09EBBuLL) >> 32)},
   {(VUINT32) ((0x3FF3FA4504AC801CuLL) >> 0),
    (VUINT32) ((0x3FF3FA4504AC801CuLL) >> 32)},
   {(VUINT32) ((0xBC97D023F956F9F3uLL) >> 0),
    (VUINT32) ((0xBC97D023F956F9F3uLL) >> 32)},
   {(VUINT32) ((0x3FF4160A21F72E2AuLL) >> 0),
    (VUINT32) ((0x3FF4160A21F72E2AuLL) >> 32)},
   {(VUINT32) ((0xBC5EF3691C309278uLL) >> 0),
    (VUINT32) ((0xBC5EF3691C309278uLL) >> 32)},
   {(VUINT32) ((0x3FF431F5D950A897uLL) >> 0),
    (VUINT32) ((0x3FF431F5D950A897uLL) >> 32)},
   {(VUINT32) ((0xBC81C7DDE35F7998uLL) >> 0),
    (VUINT32) ((0xBC81C7DDE35F7998uLL) >> 32)},
   {(VUINT32) ((0x3FF44E086061892DuLL) >> 0),
    (VUINT32) ((0x3FF44E086061892DuLL) >> 32)},
   {(VUINT32) ((0x3C489B7A04EF80CFuLL) >> 0),
    (VUINT32) ((0x3C489B7A04EF80CFuLL) >> 32)},
   {(VUINT32) ((0x3FF46A41ED1D0057uLL) >> 0),
    (VUINT32) ((0x3FF46A41ED1D0057uLL) >> 32)},
   {(VUINT32) ((0x3C9C944BD1648A76uLL) >> 0),
    (VUINT32) ((0x3C9C944BD1648A76uLL) >> 32)},
   {(VUINT32) ((0x3FF486A2B5C13CD0uLL) >> 0),
    (VUINT32) ((0x3FF486A2B5C13CD0uLL) >> 32)},
   {(VUINT32) ((0x3C73C1A3B69062F0uLL) >> 0),
    (VUINT32) ((0x3C73C1A3B69062F0uLL) >> 32)},
   {(VUINT32) ((0x3FF4A32AF0D7D3DEuLL) >> 0),
    (VUINT32) ((0x3FF4A32AF0D7D3DEuLL) >> 32)},
   {(VUINT32) ((0x3C99CB62F3D1BE56uLL) >> 0),
    (VUINT32) ((0x3C99CB62F3D1BE56uLL) >> 32)},
   {(VUINT32) ((0x3FF4BFDAD5362A27uLL) >> 0),
    (VUINT32) ((0x3FF4BFDAD5362A27uLL) >> 32)},
   {(VUINT32) ((0x3C7D4397AFEC42E2uLL) >> 0),
    (VUINT32) ((0x3C7D4397AFEC42E2uLL) >> 32)},
   {(VUINT32) ((0x3FF4DCB299FDDD0DuLL) >> 0),
    (VUINT32) ((0x3FF4DCB299FDDD0DuLL) >> 32)},
   {(VUINT32) ((0x3C98ECDBBC6A7833uLL) >> 0),
    (VUINT32) ((0x3C98ECDBBC6A7833uLL) >> 32)},
   {(VUINT32) ((0x3FF4F9B2769D2CA7uLL) >> 0),
    (VUINT32) ((0x3FF4F9B2769D2CA7uLL) >> 32)},
   {(VUINT32) ((0xBC94B309D25957E3uLL) >> 0),
    (VUINT32) ((0xBC94B309D25957E3uLL) >> 32)},
   {(VUINT32) ((0x3FF516DAA2CF6642uLL) >> 0),
    (VUINT32) ((0x3FF516DAA2CF6642uLL) >> 32)},
   {(VUINT32) ((0xBC8F768569BD93EEuLL) >> 0),
    (VUINT32) ((0xBC8F768569BD93EEuLL) >> 32)},
   {(VUINT32) ((0x3FF5342B569D4F82uLL) >> 0),
    (VUINT32) ((0x3FF5342B569D4F82uLL) >> 32)},
   {(VUINT32) ((0xBC807ABE1DB13CACuLL) >> 0),
    (VUINT32) ((0xBC807ABE1DB13CACuLL) >> 32)},
   {(VUINT32) ((0x3FF551A4CA5D920FuLL) >> 0),
    (VUINT32) ((0x3FF551A4CA5D920FuLL) >> 32)},
   {(VUINT32) ((0xBC8D689CEFEDE59AuLL) >> 0),
    (VUINT32) ((0xBC8D689CEFEDE59AuLL) >> 32)},
   {(VUINT32) ((0x3FF56F4736B527DAuLL) >> 0),
    (VUINT32) ((0x3FF56F4736B527DAuLL) >> 32)},
   {(VUINT32) ((0x3C99BB2C011D93ACuLL) >> 0),
    (VUINT32) ((0x3C99BB2C011D93ACuLL) >> 32)},
   {(VUINT32) ((0x3FF58D12D497C7FDuLL) >> 0),
    (VUINT32) ((0x3FF58D12D497C7FDuLL) >> 32)},
   {(VUINT32) ((0x3C8295E15B9A1DE7uLL) >> 0),
    (VUINT32) ((0x3C8295E15B9A1DE7uLL) >> 32)},
   {(VUINT32) ((0x3FF5AB07DD485429uLL) >> 0),
    (VUINT32) ((0x3FF5AB07DD485429uLL) >> 32)},
   {(VUINT32) ((0x3C96324C054647ACuLL) >> 0),
    (VUINT32) ((0x3C96324C054647ACuLL) >> 32)},
   {(VUINT32) ((0x3FF5C9268A5946B7uLL) >> 0),
    (VUINT32) ((0x3FF5C9268A5946B7uLL) >> 32)},
   {(VUINT32) ((0x3C3C4B1B816986A2uLL) >> 0),
    (VUINT32) ((0x3C3C4B1B816986A2uLL) >> 32)},
   {(VUINT32) ((0x3FF5E76F15AD2148uLL) >> 0),
    (VUINT32) ((0x3FF5E76F15AD2148uLL) >> 32)},
   {(VUINT32) ((0x3C9BA6F93080E65DuLL) >> 0),
    (VUINT32) ((0x3C9BA6F93080E65DuLL) >> 32)},
   {(VUINT32) ((0x3FF605E1B976DC09uLL) >> 0),
    (VUINT32) ((0x3FF605E1B976DC09uLL) >> 32)},
   {(VUINT32) ((0xBC93E2429B56DE47uLL) >> 0),
    (VUINT32) ((0xBC93E2429B56DE47uLL) >> 32)},
   {(VUINT32) ((0x3FF6247EB03A5585uLL) >> 0),
    (VUINT32) ((0x3FF6247EB03A5585uLL) >> 32)},
   {(VUINT32) ((0xBC9383C17E40B496uLL) >> 0),
    (VUINT32) ((0xBC9383C17E40B496uLL) >> 32)},
   {(VUINT32) ((0x3FF6434634CCC320uLL) >> 0),
    (VUINT32) ((0x3FF6434634CCC320uLL) >> 32)},
   {(VUINT32) ((0xBC8C483C759D8932uLL) >> 0),
    (VUINT32) ((0xBC8C483C759D8932uLL) >> 32)},
   {(VUINT32) ((0x3FF6623882552225uLL) >> 0),
    (VUINT32) ((0x3FF6623882552225uLL) >> 32)},
   {(VUINT32) ((0xBC9BB60987591C33uLL) >> 0),
    (VUINT32) ((0xBC9BB60987591C33uLL) >> 32)},
   {(VUINT32) ((0x3FF68155D44CA973uLL) >> 0),
    (VUINT32) ((0x3FF68155D44CA973uLL) >> 32)},
   {(VUINT32) ((0x3C6038AE44F73E64uLL) >> 0),
    (VUINT32) ((0x3C6038AE44F73E64uLL) >> 32)},
   {(VUINT32) ((0x3FF6A09E667F3BCDuLL) >> 0),
    (VUINT32) ((0x3FF6A09E667F3BCDuLL) >> 32)},
   {(VUINT32) ((0xBC9BDD3413B26455uLL) >> 0),
    (VUINT32) ((0xBC9BDD3413B26455uLL) >> 32)},
   {(VUINT32) ((0x3FF6C012750BDABFuLL) >> 0),
    (VUINT32) ((0x3FF6C012750BDABFuLL) >> 32)},
   {(VUINT32) ((0xBC72895667FF0B0CuLL) >> 0),
    (VUINT32) ((0xBC72895667FF0B0CuLL) >> 32)},
   {(VUINT32) ((0x3FF6DFB23C651A2FuLL) >> 0),
    (VUINT32) ((0x3FF6DFB23C651A2FuLL) >> 32)},
   {(VUINT32) ((0xBC6BBE3A683C88AAuLL) >> 0),
    (VUINT32) ((0xBC6BBE3A683C88AAuLL) >> 32)},
   {(VUINT32) ((0x3FF6FF7DF9519484uLL) >> 0),
    (VUINT32) ((0x3FF6FF7DF9519484uLL) >> 32)},
   {(VUINT32) ((0xBC883C0F25860EF6uLL) >> 0),
    (VUINT32) ((0xBC883C0F25860EF6uLL) >> 32)},
   {(VUINT32) ((0x3FF71F75E8EC5F74uLL) >> 0),
    (VUINT32) ((0x3FF71F75E8EC5F74uLL) >> 32)},
   {(VUINT32) ((0xBC816E4786887A99uLL) >> 0),
    (VUINT32) ((0xBC816E4786887A99uLL) >> 32)},
   {(VUINT32) ((0x3FF73F9A48A58174uLL) >> 0),
    (VUINT32) ((0x3FF73F9A48A58174uLL) >> 32)},
   {(VUINT32) ((0xBC90A8D96C65D53BuLL) >> 0),
    (VUINT32) ((0xBC90A8D96C65D53BuLL) >> 32)},
   {(VUINT32) ((0x3FF75FEB564267C9uLL) >> 0),
    (VUINT32) ((0x3FF75FEB564267C9uLL) >> 32)},
   {(VUINT32) ((0xBC90245957316DD3uLL) >> 0),
    (VUINT32) ((0xBC90245957316DD3uLL) >> 32)},
   {(VUINT32) ((0x3FF780694FDE5D3FuLL) >> 0),
    (VUINT32) ((0x3FF780694FDE5D3FuLL) >> 32)},
   {(VUINT32) ((0x3C9866B80A02162CuLL) >> 0),
    (VUINT32) ((0x3C9866B80A02162CuLL) >> 32)},
   {(VUINT32) ((0x3FF7A11473EB0187uLL) >> 0),
    (VUINT32) ((0x3FF7A11473EB0187uLL) >> 32)},
   {(VUINT32) ((0xBC841577EE04992FuLL) >> 0),
    (VUINT32) ((0xBC841577EE04992FuLL) >> 32)},
   {(VUINT32) ((0x3FF7C1ED0130C132uLL) >> 0),
    (VUINT32) ((0x3FF7C1ED0130C132uLL) >> 32)},
   {(VUINT32) ((0x3C9F124CD1164DD5uLL) >> 0),
    (VUINT32) ((0x3C9F124CD1164DD5uLL) >> 32)},
   {(VUINT32) ((0x3FF7E2F336CF4E62uLL) >> 0),
    (VUINT32) ((0x3FF7E2F336CF4E62uLL) >> 32)},
   {(VUINT32) ((0x3C705D02BA15797EuLL) >> 0),
    (VUINT32) ((0x3C705D02BA15797EuLL) >> 32)},
   {(VUINT32) ((0x3FF80427543E1A12uLL) >> 0),
    (VUINT32) ((0x3FF80427543E1A12uLL) >> 32)},
   {(VUINT32) ((0xBC927C86626D972AuLL) >> 0),
    (VUINT32) ((0xBC927C86626D972AuLL) >> 32)},
   {(VUINT32) ((0x3FF82589994CCE13uLL) >> 0),
    (VUINT32) ((0x3FF82589994CCE13uLL) >> 32)},
   {(VUINT32) ((0xBC9D4C1DD41532D7uLL) >> 0),
    (VUINT32) ((0xBC9D4C1DD41532D7uLL) >> 32)},
   {(VUINT32) ((0x3FF8471A4623C7ADuLL) >> 0),
    (VUINT32) ((0x3FF8471A4623C7ADuLL) >> 32)},
   {(VUINT32) ((0xBC88D684A341CDFBuLL) >> 0),
    (VUINT32) ((0xBC88D684A341CDFBuLL) >> 32)},
   {(VUINT32) ((0x3FF868D99B4492EDuLL) >> 0),
    (VUINT32) ((0x3FF868D99B4492EDuLL) >> 32)},
   {(VUINT32) ((0xBC9FC6F89BD4F6BAuLL) >> 0),
    (VUINT32) ((0xBC9FC6F89BD4F6BAuLL) >> 32)},
   {(VUINT32) ((0x3FF88AC7D98A6699uLL) >> 0),
    (VUINT32) ((0x3FF88AC7D98A6699uLL) >> 32)},
   {(VUINT32) ((0x3C9994C2F37CB53AuLL) >> 0),
    (VUINT32) ((0x3C9994C2F37CB53AuLL) >> 32)},
   {(VUINT32) ((0x3FF8ACE5422AA0DBuLL) >> 0),
    (VUINT32) ((0x3FF8ACE5422AA0DBuLL) >> 32)},
   {(VUINT32) ((0x3C96E9F156864B26uLL) >> 0),
    (VUINT32) ((0x3C96E9F156864B26uLL) >> 32)},
   {(VUINT32) ((0x3FF8CF3216B5448CuLL) >> 0),
    (VUINT32) ((0x3FF8CF3216B5448CuLL) >> 32)},
   {(VUINT32) ((0xBC70D55E32E9E3AAuLL) >> 0),
    (VUINT32) ((0xBC70D55E32E9E3AAuLL) >> 32)},
   {(VUINT32) ((0x3FF8F1AE99157736uLL) >> 0),
    (VUINT32) ((0x3FF8F1AE99157736uLL) >> 32)},
   {(VUINT32) ((0x3C85CC13A2E3976CuLL) >> 0),
    (VUINT32) ((0x3C85CC13A2E3976CuLL) >> 32)},
   {(VUINT32) ((0x3FF9145B0B91FFC6uLL) >> 0),
    (VUINT32) ((0x3FF9145B0B91FFC6uLL) >> 32)},
   {(VUINT32) ((0xBC9DD6792E582523uLL) >> 0),
    (VUINT32) ((0xBC9DD6792E582523uLL) >> 32)},
   {(VUINT32) ((0x3FF93737B0CDC5E5uLL) >> 0),
    (VUINT32) ((0x3FF93737B0CDC5E5uLL) >> 32)},
   {(VUINT32) ((0xBC675FC781B57EBBuLL) >> 0),
    (VUINT32) ((0xBC675FC781B57EBBuLL) >> 32)},
   {(VUINT32) ((0x3FF95A44CBC8520FuLL) >> 0),
    (VUINT32) ((0x3FF95A44CBC8520FuLL) >> 32)},
   {(VUINT32) ((0xBC764B7C96A5F039uLL) >> 0),
    (VUINT32) ((0xBC764B7C96A5F039uLL) >> 32)},
   {(VUINT32) ((0x3FF97D829FDE4E50uLL) >> 0),
    (VUINT32) ((0x3FF97D829FDE4E50uLL) >> 32)},
   {(VUINT32) ((0xBC9D185B7C1B85D0uLL) >> 0),
    (VUINT32) ((0xBC9D185B7C1B85D0uLL) >> 32)},
   {(VUINT32) ((0x3FF9A0F170CA07BAuLL) >> 0),
    (VUINT32) ((0x3FF9A0F170CA07BAuLL) >> 32)},
   {(VUINT32) ((0xBC9173BD91CEE632uLL) >> 0),
    (VUINT32) ((0xBC9173BD91CEE632uLL) >> 32)},
   {(VUINT32) ((0x3FF9C49182A3F090uLL) >> 0),
    (VUINT32) ((0x3FF9C49182A3F090uLL) >> 32)},
   {(VUINT32) ((0x3C7C7C46B071F2BEuLL) >> 0),
    (VUINT32) ((0x3C7C7C46B071F2BEuLL) >> 32)},
   {(VUINT32) ((0x3FF9E86319E32323uLL) >> 0),
    (VUINT32) ((0x3FF9E86319E32323uLL) >> 32)},
   {(VUINT32) ((0x3C7824CA78E64C6EuLL) >> 0),
    (VUINT32) ((0x3C7824CA78E64C6EuLL) >> 32)},
   {(VUINT32) ((0x3FFA0C667B5DE565uLL) >> 0),
    (VUINT32) ((0x3FFA0C667B5DE565uLL) >> 32)},
   {(VUINT32) ((0xBC9359495D1CD532uLL) >> 0),
    (VUINT32) ((0xBC9359495D1CD532uLL) >> 32)},
   {(VUINT32) ((0x3FFA309BEC4A2D33uLL) >> 0),
    (VUINT32) ((0x3FFA309BEC4A2D33uLL) >> 32)},
   {(VUINT32) ((0x3C96305C7DDC36ABuLL) >> 0),
    (VUINT32) ((0x3C96305C7DDC36ABuLL) >> 32)},
   {(VUINT32) ((0x3FFA5503B23E255DuLL) >> 0),
    (VUINT32) ((0x3FFA5503B23E255DuLL) >> 32)},
   {(VUINT32) ((0xBC9D2F6EDB8D41E1uLL) >> 0),
    (VUINT32) ((0xBC9D2F6EDB8D41E1uLL) >> 32)},
   {(VUINT32) ((0x3FFA799E1330B358uLL) >> 0),
    (VUINT32) ((0x3FFA799E1330B358uLL) >> 32)},
   {(VUINT32) ((0x3C9BCB7ECAC563C6uLL) >> 0),
    (VUINT32) ((0x3C9BCB7ECAC563C6uLL) >> 32)},
   {(VUINT32) ((0x3FFA9E6B5579FDBFuLL) >> 0),
    (VUINT32) ((0x3FFA9E6B5579FDBFuLL) >> 32)},
   {(VUINT32) ((0x3C90FAC90EF7FD31uLL) >> 0),
    (VUINT32) ((0x3C90FAC90EF7FD31uLL) >> 32)},
   {(VUINT32) ((0x3FFAC36BBFD3F37AuLL) >> 0),
    (VUINT32) ((0x3FFAC36BBFD3F37AuLL) >> 32)},
   {(VUINT32) ((0xBC8F9234CAE76CD0uLL) >> 0),
    (VUINT32) ((0xBC8F9234CAE76CD0uLL) >> 32)},
   {(VUINT32) ((0x3FFAE89F995AD3ADuLL) >> 0),
    (VUINT32) ((0x3FFAE89F995AD3ADuLL) >> 32)},
   {(VUINT32) ((0x3C97A1CD345DCC81uLL) >> 0),
    (VUINT32) ((0x3C97A1CD345DCC81uLL) >> 32)},
   {(VUINT32) ((0x3FFB0E07298DB666uLL) >> 0),
    (VUINT32) ((0x3FFB0E07298DB666uLL) >> 32)},
   {(VUINT32) ((0xBC9BDEF54C80E424uLL) >> 0),
    (VUINT32) ((0xBC9BDEF54C80E424uLL) >> 32)},
   {(VUINT32) ((0x3FFB33A2B84F15FBuLL) >> 0),
    (VUINT32) ((0x3FFB33A2B84F15FBuLL) >> 32)},
   {(VUINT32) ((0xBC62805E3084D707uLL) >> 0),
    (VUINT32) ((0xBC62805E3084D707uLL) >> 32)},
   {(VUINT32) ((0x3FFB59728DE5593AuLL) >> 0),
    (VUINT32) ((0x3FFB59728DE5593AuLL) >> 32)},
   {(VUINT32) ((0xBC9C71DFBBBA6DE3uLL) >> 0),
    (VUINT32) ((0xBC9C71DFBBBA6DE3uLL) >> 32)},
   {(VUINT32) ((0x3FFB7F76F2FB5E47uLL) >> 0),
    (VUINT32) ((0x3FFB7F76F2FB5E47uLL) >> 32)},
   {(VUINT32) ((0xBC75584F7E54AC3AuLL) >> 0),
    (VUINT32) ((0xBC75584F7E54AC3AuLL) >> 32)},
   {(VUINT32) ((0x3FFBA5B030A1064AuLL) >> 0),
    (VUINT32) ((0x3FFBA5B030A1064AuLL) >> 32)},
   {(VUINT32) ((0xBC9EFCD30E54292EuLL) >> 0),
    (VUINT32) ((0xBC9EFCD30E54292EuLL) >> 32)},
   {(VUINT32) ((0x3FFBCC1E904BC1D2uLL) >> 0),
    (VUINT32) ((0x3FFBCC1E904BC1D2uLL) >> 32)},
   {(VUINT32) ((0x3C823DD07A2D9E84uLL) >> 0),
    (VUINT32) ((0x3C823DD07A2D9E84uLL) >> 32)},
   {(VUINT32) ((0x3FFBF2C25BD71E09uLL) >> 0),
    (VUINT32) ((0x3FFBF2C25BD71E09uLL) >> 32)},
   {(VUINT32) ((0xBC9EFDCA3F6B9C72uLL) >> 0),
    (VUINT32) ((0xBC9EFDCA3F6B9C72uLL) >> 32)},
   {(VUINT32) ((0x3FFC199BDD85529CuLL) >> 0),
    (VUINT32) ((0x3FFC199BDD85529CuLL) >> 32)},
   {(VUINT32) ((0x3C811065895048DDuLL) >> 0),
    (VUINT32) ((0x3C811065895048DDuLL) >> 32)},
   {(VUINT32) ((0x3FFC40AB5FFFD07AuLL) >> 0),
    (VUINT32) ((0x3FFC40AB5FFFD07AuLL) >> 32)},
   {(VUINT32) ((0x3C9B4537E083C60AuLL) >> 0),
    (VUINT32) ((0x3C9B4537E083C60AuLL) >> 32)},
   {(VUINT32) ((0x3FFC67F12E57D14BuLL) >> 0),
    (VUINT32) ((0x3FFC67F12E57D14BuLL) >> 32)},
   {(VUINT32) ((0x3C92884DFF483CACuLL) >> 0),
    (VUINT32) ((0x3C92884DFF483CACuLL) >> 32)},
   {(VUINT32) ((0x3FFC8F6D9406E7B5uLL) >> 0),
    (VUINT32) ((0x3FFC8F6D9406E7B5uLL) >> 32)},
   {(VUINT32) ((0x3C71ACBC48805C44uLL) >> 0),
    (VUINT32) ((0x3C71ACBC48805C44uLL) >> 32)},
   {(VUINT32) ((0x3FFCB720DCEF9069uLL) >> 0),
    (VUINT32) ((0x3FFCB720DCEF9069uLL) >> 32)},
   {(VUINT32) ((0x3C7503CBD1E949DBuLL) >> 0),
    (VUINT32) ((0x3C7503CBD1E949DBuLL) >> 32)},
   {(VUINT32) ((0x3FFCDF0B555DC3FAuLL) >> 0),
    (VUINT32) ((0x3FFCDF0B555DC3FAuLL) >> 32)},
   {(VUINT32) ((0xBC8DD83B53829D72uLL) >> 0),
    (VUINT32) ((0xBC8DD83B53829D72uLL) >> 32)},
   {(VUINT32) ((0x3FFD072D4A07897CuLL) >> 0),
    (VUINT32) ((0x3FFD072D4A07897CuLL) >> 32)},
   {(VUINT32) ((0xBC9CBC3743797A9CuLL) >> 0),
    (VUINT32) ((0xBC9CBC3743797A9CuLL) >> 32)},
   {(VUINT32) ((0x3FFD2F87080D89F2uLL) >> 0),
    (VUINT32) ((0x3FFD2F87080D89F2uLL) >> 32)},
   {(VUINT32) ((0xBC9D487B719D8577uLL) >> 0),
    (VUINT32) ((0xBC9D487B719D8577uLL) >> 32)},
   {(VUINT32) ((0x3FFD5818DCFBA487uLL) >> 0),
    (VUINT32) ((0x3FFD5818DCFBA487uLL) >> 32)},
   {(VUINT32) ((0x3C82ED02D75B3706uLL) >> 0),
    (VUINT32) ((0x3C82ED02D75B3706uLL) >> 32)},
   {(VUINT32) ((0x3FFD80E316C98398uLL) >> 0),
    (VUINT32) ((0x3FFD80E316C98398uLL) >> 32)},
   {(VUINT32) ((0xBC911EC18BEDDFE8uLL) >> 0),
    (VUINT32) ((0xBC911EC18BEDDFE8uLL) >> 32)},
   {(VUINT32) ((0x3FFDA9E603DB3285uLL) >> 0),
    (VUINT32) ((0x3FFDA9E603DB3285uLL) >> 32)},
   {(VUINT32) ((0x3C9C2300696DB532uLL) >> 0),
    (VUINT32) ((0x3C9C2300696DB532uLL) >> 32)},
   {(VUINT32) ((0x3FFDD321F301B460uLL) >> 0),
    (VUINT32) ((0x3FFDD321F301B460uLL) >> 32)},
   {(VUINT32) ((0x3C92DA5778F018C2uLL) >> 0),
    (VUINT32) ((0x3C92DA5778F018C2uLL) >> 32)},
   {(VUINT32) ((0x3FFDFC97337B9B5FuLL) >> 0),
    (VUINT32) ((0x3FFDFC97337B9B5FuLL) >> 32)},
   {(VUINT32) ((0xBC91A5CD4F184B5BuLL) >> 0),
    (VUINT32) ((0xBC91A5CD4F184B5BuLL) >> 32)},
   {(VUINT32) ((0x3FFE264614F5A129uLL) >> 0),
    (VUINT32) ((0x3FFE264614F5A129uLL) >> 32)},
   {(VUINT32) ((0xBC97B627817A1496uLL) >> 0),
    (VUINT32) ((0xBC97B627817A1496uLL) >> 32)},
   {(VUINT32) ((0x3FFE502EE78B3FF6uLL) >> 0),
    (VUINT32) ((0x3FFE502EE78B3FF6uLL) >> 32)},
   {(VUINT32) ((0x3C839E8980A9CC8FuLL) >> 0),
    (VUINT32) ((0x3C839E8980A9CC8FuLL) >> 32)},
   {(VUINT32) ((0x3FFE7A51FBC74C83uLL) >> 0),
    (VUINT32) ((0x3FFE7A51FBC74C83uLL) >> 32)},
   {(VUINT32) ((0x3C92D522CA0C8DE1uLL) >> 0),
    (VUINT32) ((0x3C92D522CA0C8DE1uLL) >> 32)},
   {(VUINT32) ((0x3FFEA4AFA2A490DAuLL) >> 0),
    (VUINT32) ((0x3FFEA4AFA2A490DAuLL) >> 32)},
   {(VUINT32) ((0xBC9E9C23179C2893uLL) >> 0),
    (VUINT32) ((0xBC9E9C23179C2893uLL) >> 32)},
   {(VUINT32) ((0x3FFECF482D8E67F1uLL) >> 0),
    (VUINT32) ((0x3FFECF482D8E67F1uLL) >> 32)},
   {(VUINT32) ((0xBC9C93F3B411AD8CuLL) >> 0),
    (VUINT32) ((0xBC9C93F3B411AD8CuLL) >> 32)},
   {(VUINT32) ((0x3FFEFA1BEE615A27uLL) >> 0),
    (VUINT32) ((0x3FFEFA1BEE615A27uLL) >> 32)},
   {(VUINT32) ((0x3C9DC7F486A4B6B0uLL) >> 0),
    (VUINT32) ((0x3C9DC7F486A4B6B0uLL) >> 32)},
   {(VUINT32) ((0x3FFF252B376BBA97uLL) >> 0),
    (VUINT32) ((0x3FFF252B376BBA97uLL) >> 32)},
   {(VUINT32) ((0x3C93A1A5BF0D8E43uLL) >> 0),
    (VUINT32) ((0x3C93A1A5BF0D8E43uLL) >> 32)},
   {(VUINT32) ((0x3FFF50765B6E4540uLL) >> 0),
    (VUINT32) ((0x3FFF50765B6E4540uLL) >> 32)},
   {(VUINT32) ((0x3C99D3E12DD8A18AuLL) >> 0),
    (VUINT32) ((0x3C99D3E12DD8A18AuLL) >> 32)},
   {(VUINT32) ((0x3FFF7BFDAD9CBE14uLL) >> 0),
    (VUINT32) ((0x3FFF7BFDAD9CBE14uLL) >> 32)},
   {(VUINT32) ((0xBC9DBB12D0063509uLL) >> 0),
    (VUINT32) ((0xBC9DBB12D0063509uLL) >> 32)},
   {(VUINT32) ((0x3FFFA7C1819E90D8uLL) >> 0),
    (VUINT32) ((0x3FFFA7C1819E90D8uLL) >> 32)},
   {(VUINT32) ((0x3C874853F3A5931EuLL) >> 0),
    (VUINT32) ((0x3C874853F3A5931EuLL) >> 32)},
   {(VUINT32) ((0x3FFFD3C22B8F71F1uLL) >> 0),
    (VUINT32) ((0x3FFFD3C22B8F71F1uLL) >> 32)},
   {(VUINT32) ((0x3C62EB74966579E7uLL) >> 0),
    (VUINT32) ((0x3C62EB74966579E7uLL) >> 32)},
   },
  {

   {(VUINT32) ((0x3F903950CF599C56uLL) >> 0),
    (VUINT32) ((0x3F903950CF599C56uLL) >> 32)},
   {(VUINT32) ((0xBF9B4EA0E9419F52uLL) >> 0),
    (VUINT32) ((0xBF9B4EA0E9419F52uLL) >> 32)},
   {(VUINT32) ((0x3FA7A334DDFC9F86uLL) >> 0),
    (VUINT32) ((0x3FA7A334DDFC9F86uLL) >> 32)},
   {(VUINT32) ((0xBFB550472A8BB463uLL) >> 0),
    (VUINT32) ((0xBFB550472A8BB463uLL) >> 32)},
   {(VUINT32) ((0x3FC47FD462B3B816uLL) >> 0),
    (VUINT32) ((0x3FC47FD462B3B816uLL) >> 32)},
   {(VUINT32) ((0xBFD62E4346694107uLL) >> 0),
    (VUINT32) ((0xBFD62E4346694107uLL) >> 32)},
   {(VUINT32) ((0x3E79C3A6966457EEuLL) >> 0),
    (VUINT32) ((0x3E79C3A6966457EEuLL) >> 32)},
   },
  {

   {(VUINT32) ((0x3F55D87FE78A6731uLL) >> 0),
    (VUINT32) ((0x3F55D87FE78A6731uLL) >> 32)},
   {(VUINT32) ((0x3F83B2AB6FBA4E77uLL) >> 0),
    (VUINT32) ((0x3F83B2AB6FBA4E77uLL) >> 32)},
   {(VUINT32) ((0x3FAC6B08D704A0BFuLL) >> 0),
    (VUINT32) ((0x3FAC6B08D704A0BFuLL) >> 32)},
   {(VUINT32) ((0x3FCEBFBDFF82C58EuLL) >> 0),
    (VUINT32) ((0x3FCEBFBDFF82C58EuLL) >> 32)},
   {(VUINT32) ((0x3FE62E42FEFA39EFuLL) >> 0),
    (VUINT32) ((0x3FE62E42FEFA39EFuLL) >> 32)},
   },

  {(VUINT32) ((0x000fffffffffffffuLL) >> 0),
   (VUINT32) ((0x000fffffffffffffuLL) >> 32)},
  {(VUINT32) ((0x3fe7fe0000000000uLL) >> 0),
   (VUINT32) ((0x3fe7fe0000000000uLL) >> 32)},
  {(VUINT32) ((0x3ff0000000000000uLL) >> 0),
   (VUINT32) ((0x3ff0000000000000uLL) >> 32)},
  {(VUINT32) ((0xffffffff00000000uLL) >> 0),
   (VUINT32) ((0xffffffff00000000uLL) >> 32)},
  {(VUINT32) ((0x4138000000000000uLL) >> 0),
   (VUINT32) ((0x4138000000000000uLL) >> 32)},
  {(VUINT32) ((0xfffffffff8000000uLL) >> 0),
   (VUINT32) ((0xfffffffff8000000uLL) >> 32)},
  {(VUINT32) ((0xBFF7154740000000uLL) >> 0),
   (VUINT32) ((0xBFF7154740000000uLL) >> 32)},
  {(VUINT32) ((0xfff0000000000000uLL) >> 0),
   (VUINT32) ((0xfff0000000000000uLL) >> 32)},
  {(VUINT32) ((0x42C8000000000000uLL) >> 0),
   (VUINT32) ((0x42C8000000000000uLL) >> 32)},

  {(VUINT32) ((0xFFF0000000000000uLL) >> 0),
   (VUINT32) ((0xFFF0000000000000uLL) >> 32)},
  {(VUINT32) ((0x8000000000000000uLL) >> 0),
   (VUINT32) ((0x8000000000000000uLL) >> 32)},
  {(VUINT32) ((0x4330000000000000uLL) >> 0),
   (VUINT32) ((0x4330000000000000uLL) >> 32)},
  {(VUINT32) ((0x3900000000000000uLL) >> 0),
   (VUINT32) ((0x3900000000000000uLL) >> 32)},

  {(VUINT32) (0x00100000u)},
  {(VUINT32) (0x00200000u)},
  {(VUINT32) (0x7fffffffu)},
  {(VUINT32) (0x7f800000u)},
  {(VUINT32) (0x408fefffu)},

  {(VUINT32) (0x000ffe00u)},
  {(VUINT32) (0x00000200u)},

  {(VUINT32) (0x3fe7fe00u)},
  {(VUINT32) (0x41380000u)},
  {(VUINT32) (0x3ff00000u)},
  {(VUINT32) (0x0000007fu)},

};

#endif
