/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider.h
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#if !defined(GDM_INFO_PROVIDER_H)
#define GDM_INFO_PROVIDER_H

#include <gnome-device-manager/gdm-info-provider-iface.h>

char   *gdm_info_provider_get_icon_name  (GdmDevice *device);
char   *gdm_info_provider_get_short_name (GdmDevice *device);
char   *gdm_info_provider_get_long_name  (GdmDevice *device);
char   *gdm_info_provider_get_vendor     (GdmDevice *device);
char   *gdm_info_provider_get_product    (GdmDevice *device);
GSList *gdm_info_provider_get_summary    (GdmDevice *device);
GSList *gdm_info_provider_get_errors     (GdmDevice *device);
GSList *gdm_info_provider_get_warnings   (GdmDevice *device);
GSList *gdm_info_provider_get_notices    (GdmDevice *device);

void     gdm_info_provider_register_builtin     (void);
void     gdm_info_provider_register_iface       (GdmInfoProviderIface *provider);


#endif /* GDM_INFO_PROVIDER_H */
