/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-device.h
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef GDM_DEVICE_H
#define GDM_DEVICE_H

#include <glib-object.h>
#include <libhal.h>

#define GDM_TYPE_DEVICE             (gdm_device_get_type ())
#define GDM_DEVICE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDM_TYPE_DEVICE, GdmDevice))
#define GDM_DEVICE_CLASS(obj)       (G_TYPE_CHECK_CLASS_CAST ((obj), GDM_DEVICE,  GdmDeviceClass))
#define GDM_IS_DEVICE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDM_TYPE_DEVICE))
#define GDM_IS_DEVICE_CLASS(obj)    (G_TYPE_CHECK_CLASS_TYPE ((obj), GDM_TYPE_DEVICE))
#define GDM_DEVICE_GET_CLASS        (G_TYPE_INSTANCE_GET_CLASS ((obj), GDM_TYPE_DEVICE, GdmDeviceClass))


typedef struct _GdmDevice            GdmDevice;
typedef struct _GdmDeviceClass       GdmDeviceClass;

struct _GdmDevicePrivate;
typedef struct _GdmDevicePrivate     GdmDevicePrivate;

struct _GdmDevice
{
        GObject parent;

        guint64 size;
        
        /* private */
        GdmDevicePrivate *priv;
};

struct _GdmDeviceClass
{
        GObjectClass parent_class;

        /* signals */
        void (*hal_property_changed) (GdmDevice *device, const char *key);
};


GType               gdm_device_get_type                   (void);
GdmDevice          *gdm_device_new_from_udi               (LibHalContext *hal_ctx, const char *udi);
void                gdm_device_hal_property_changed       (GdmDevice *device,      const char *key);

const char         *gdm_device_get_udi                    (GdmDevice *device);
const char         *gdm_device_get_parent_udi             (GdmDevice *device);
LibHalPropertySet  *gdm_device_get_properties             (GdmDevice *device);
const char         *gdm_device_get_property_string        (GdmDevice *device,      const char *key);
int                 gdm_device_get_property_int           (GdmDevice *device,      const char *key);
guint64             gdm_device_get_property_uint64        (GdmDevice *device,      const char *key);
double              gdm_device_get_property_double        (GdmDevice *device,      const char *key);
gboolean            gdm_device_get_property_bool          (GdmDevice *device,      const char *key);
char              **gdm_device_get_property_strlist       (GdmDevice *device,      const char *key);
gboolean            gdm_device_test_capability            (GdmDevice *device,      const char *capability);

#endif /* GDM_DEVICE_H */
