/*
 *  
 *  $Id: icontratosaprimaria.h 3700 2011-04-15 07:34:44Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <api/icontrato.h>
#include <api/icontextoestudio.h>
#include "../estudios/overlay.h"
namespace GNC {
	namespace GCS 
	{
		class IEntorno;
	}
}

class vtkGinkgoImageViewer;
class vtkLookupTable;
class vtkAlgorithmOutput;

namespace GNKVisualizator {
	//igual que el del core, pero ademas tiene el entorno
	class IContratoMapaColor: public  GNC::GCS::IContrato
	{
	public:
		IContratoMapaColor()
		{
		}

		~IContratoMapaColor()
		{
		}

		virtual void Setup(const GnkPtr<GNC::GCS::IContextoEstudio>& estudio )
		{
			Estudio = estudio;
		}

		virtual void SetMapaColor(vtkLookupTable* pTabla, int idLookupTable) = 0;

		GnkPtr<GNC::GCS::IContextoEstudio> Estudio;
	};

	class IContratoOverlays: public GNC::GCS::IContrato
	{
	public:
		GNKVisualizator::TListaOverlays* m_pListaOverlays;
		GNKVisualizator::TEstadoOverlay m_EstadoOverlays;
		GNC::GCS::IEntorno* m_pEntorno;

		IContratoOverlays(){
			m_pEntorno = NULL;
			m_pListaOverlays = NULL;
		}
		~IContratoOverlays() {
			m_pEntorno = NULL;
			m_pListaOverlays = NULL;
			m_EstadoOverlays.clear();
		}
		virtual void Setup(GNKVisualizator::TListaOverlays* pListaOverlays, GNC::GCS::IEntorno* pEntorno)
		{
			m_pListaOverlays = pListaOverlays;
			m_EstadoOverlays.clear();
			if(m_pListaOverlays != NULL) {
				for(GNKVisualizator::TListaOverlays::iterator it = pListaOverlays->begin(); it!=pListaOverlays->end(); it++) {
					m_EstadoOverlays[it->indice] = false;
				}
			}
			m_pEntorno = pEntorno;
		}
	};

	namespace Reconstruction {
		typedef enum ReconstructionMode {
			RM_OrthogonalMPR = 0,
			RM_MIP3D,
			RM_VolumeRendering,
			RM_SurfaceRendering,
			RM_3D_Endoscopy,
			RM_MaxMode
		} ReconstructionMode;
	}

	class IReconstructionContract: public GNC::GCS::IContrato
	{
	public:

		IReconstructionContract(){
		}
		~IReconstructionContract() {
		}
		virtual void Setup(const GnkPtr<GNC::GCS::IContextoEstudio>& estudio)
		{
			Estudio = estudio;
		}

		virtual void SetReconstructionMode(Reconstruction::ReconstructionMode mode) = 0;

		GnkPtr<GNC::GCS::IContextoEstudio> Estudio;
	};
};

