/*
 *  
 *  $Id: iwizard.h 4403 2011-11-14 10:59:24Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <wx/sizer.h>
#include <string>
#include <list>

class IWizard {
public:
	virtual void SiguientePaso() = 0;
	virtual void EnableSiguiente(bool enable) = 0;

	virtual void EnableAnterior(bool enable) = 0;

	virtual void EnableCancelar(bool enable) = 0;
};

class IPasoWizard{
public:
	typedef std::list<std::string> ListaFicheros;
protected:

	ListaFicheros* m_pListaFicheros;
	IWizard* m_pWizard;

public:
	IPasoWizard(IWizard * pWizard)
	{
		m_pWizard = pWizard;
	};

	virtual bool Attach()
	{
		return true;
	}

	virtual bool Detach()
	{
		return true;
	}

	virtual std::string GetTitle()=0;

	virtual std::string GetSubTitle()
	{
		return "";
	}

	virtual bool Siguiente()=0;

	virtual bool Anterior()=0;

	virtual bool Cancelar()=0;

	virtual bool Validar()=0;

	virtual bool AllowCancel() 
	{
		return true;
	}

	virtual void OnCancelled() {}

	virtual void AsignarListaFicheros(ListaFicheros &lista)
	{
		m_pListaFicheros=&lista;
	};

	virtual void SiguientePaso(){
		m_pWizard->SiguientePaso();
	}

	virtual void EnableSiguiente(bool enable){
		m_pWizard->EnableSiguiente(enable);
	}

	virtual void EnableAnterior(bool enable){
		m_pWizard->EnableAnterior(enable);
	}

	virtual void EnableCancelar(bool enable){
		m_pWizard->EnableCancelar(enable);
	}
	//helpers
	virtual bool ValidarDouble(std::string strNumero, double min, double max, bool obligatorio = false, bool estricto = true){
		if(strNumero != ""){
			wxString wxStr = wxString::FromUTF8(strNumero.c_str());
			double valor;
			if(!wxStr.ToDouble(&valor)) {
				return false;
			} else {
				if (estricto) {
					if(valor <= min || valor >= max){
						return false;
					}
				}
				else {
					if(valor < min || valor > max){
						return false;
					}
				}
			}
			return true;
		} else {
			if(obligatorio){
				return false;
			} else {
				return true;
			}
		}
	}

	virtual bool ValidarLong(std::string strNumero, long min, long max, bool obligatorio = false, bool estricto = true){
		if(strNumero != ""){
			wxString wxStr = wxString::FromUTF8(strNumero.c_str());
			long valor;
			if(!wxStr.ToLong(&valor)) {
				return false;
			} else {
				if (estricto) {
					if(valor<=min || valor >=max){
						return false;
					}
				}
				else {
					if(valor < min || valor > max){
						return false;
					}
				}
			}
			return true;
		} else {
			if(obligatorio){
				return false;
			} else {
				return true;
			}
		}
	}
};
