/*
 *  
 *  $Id: iimpresion.h 3713 2011-04-15 12:55:23Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
// Forward declarations
#pragma once
#include <api/api.h>
#include <api/icontextoestudio.h>
#include <export/icontratoscore.h>

namespace GNC {
	namespace GCS {
		class IWidgetsManager;
		class IWidgetsRenderer;
	}
}

namespace GNC {
	namespace GCS {

		// Clase con helpers de impresion. Base comun de todas las interfaces de impresion de vistas.
		class EXTAPI IImpresion  {
		public:

			IImpresion(GNC::GCS::IWidgetsManager* pWidgetsManager, const GnkPtr<GNC::GCS::IContextoEstudio>& pContextoEstudio, int index);

			~IImpresion()
			{
				m_pWidgetsManager = NULL;
			}

			//region "helpers"
		public:
			void CopiarRGBEnRGBA32(unsigned char* src, unsigned char* dst, unsigned int size)
			{
				for (unsigned int off = 0; off < size; ++off) {
					dst[0] = src[2];
					dst[1] = src[1];
					dst[2] = src[0];
					dst[3] = 255;
					src+=3;
					dst+=4;
				}
			}
			void CopiarRGBA32EnRGB(unsigned char* src, unsigned char* dst, unsigned int size)
			{
				for (unsigned int off = 0; off < size; ++off) {
					dst[0] = src[2];
					dst[1] = src[1];
					dst[2] = src[0];
					src+=4;
					dst+=3;
				}
			}
			//endregion

		protected:
			vtkSmartPointer<vtkImageData> GetImage();

			void Imprimir(vtkImageData* imageData, bool conWidgets, const GNC::GCS::Vector& size, GNC::GCS::IContratoExportacionImages::ImageType::Pointer& out);

			void ImprimirConWidgets(GNC::GCS::IContratoExportacionImages::ImageType::Pointer& img, const GNC::GCS::Vector& aspectRatio);

			GNC::GCS::IWidgetsManager*  m_pWidgetsManager;
			GnkPtr<GNC::GCS::IContextoEstudioReferido> m_pEstudioReferido;
			int m_index;
		};
	}
}
