/*
 *  
 *  $Id: icontroladorextensiones.h 4360 2011-11-02 10:15:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include "api.h"
#include <list>
#include <map>
#include <string>

#include "icontroladormodulo.h"
#include "iexception.h"
#include "observers/iextensionsobserver.h"

class PrivateExtension;

namespace GADVAPI {

	class EXTAPI IPrivateExtensionWrapper {

	public:

		virtual ~IPrivateExtensionWrapper() {}

		virtual bool Load() = 0;
		virtual bool UnLoad() = 0;
		virtual bool IsLoaded() const = 0;

		virtual int GetVersion() const = 0;
		virtual int GetSubVersion() const = 0;
		virtual int GetRelease() const = 0;
		virtual int GetBuild() const = 0;
		virtual const std::string& GetCodeName() const = 0;

		virtual const std::string& GetProvider() const = 0;
		virtual const std::string& GetDescription() const = 0;

		virtual const std::string& GetUpdateURL() const = 0;

		virtual const std::string& GetError() const = 0;

		virtual PrivateExtension* GetExtension() = 0;

	};

	class EXTAPI PrivateExtensionManager : private std::map<std::string, IPrivateExtensionWrapper*>
	{
	public:
		
		typedef std::map<std::string, IPrivateExtensionWrapper*> Base;
		typedef Base::iterator iterator;

		PrivateExtensionManager();
		~PrivateExtensionManager();

		IPrivateExtensionWrapper* GetExtension(const std::string& nombre);

		void Scan();

		void UnLoadAll();

		iterator begin();
		iterator end();
		
	};
}

namespace GNC {
	namespace GCS {

		class EXTAPI IExtensionException : public IException {
		public:			

		protected:
			IExtensionException(const std::string& msg, const std::string& component="GNC", bool fatal = true) throw();

			~IExtensionException() throw();
		};

		class EXTAPI IControladorExtensiones {
		public:
			virtual GADVAPI::PrivateExtensionManager& GetPrivateExtensionsManager() = 0;

		protected:
			IControladorExtensiones();
			~IControladorExtensiones();
		};
	}
}

