/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1996,1997                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify and distribute this software and its */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Alan W Black                            */
/*                     Date   :  December 1997                           */
/*-----------------------------------------------------------------------*/
/*  Run a WFST on some data, either as a recognizer or as a transducer   */
/*                                                                       */
/*=======================================================================*/
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "EST.h"
#include "EST_WFST.h"

static int wfst_run_main(int argc, char **argv);

int main(int argc, char **argv)
{

    wfst_run_main(argc,argv);

    exit(0);
    return 0;
}

static int wfst_run_main(int argc, char **argv)
{
    // recognize/transduce
    EST_Option al;
    EST_StrList files;
    EST_String wfstfile;
    FILE *ofd;
    int r;

    parse_command_line(argc, argv,
       EST_String("Usage:\n")+
       "wfst_run -wfst <WFSTFILE> <options> <datafile0> <datafile1> ...\n"+
       "Recognize/transduce using a WFST on data\n"+
       "-wfst <ifile>    The WFST to use\n"+
       "-transduce       Transduce input to output (default)\n"+
       "-recog           Recognize input consists of pairs\n"+
       "-itype <string>  char or token\n"+
       "-quiet           No extraneous messages\n"+
       "-o <ofile>       Output file for transduced forms\n",
		       files, al);
    
    if (al.present("-o"))
    {
	if ((ofd=fopen(al.val("-o"),"w")) == NULL)
	{
	    cerr << "wfst_run: can't open outfile \"" << al.val("-o")
		<< "\" for writing." << endl;
	    exit(-1);
	}
    }
    else
	ofd = stdout;

    if (al.present("-wfst"))
	wfstfile = al.val("-wfst");
    else
    {
	cerr << "wfst_run: no WFST specified." << endl;
	exit(-1);
    }
    
    siod_init();

    EST_WFST wfst;
    EST_TokenStream ts;
    EST_StrList ostrs,istrs;

    if (wfst.load(wfstfile) != format_ok)
    {
	cerr << "wfst_run: failed to read WFST from \"" << wfstfile 
	    << "\"" << endl;
	exit(-1);
    }

    if (files(files.head()) == "-")
	ts.open(stdin,FALSE);
    else
    {
	if (ts.open(files(files.head())) != 0)
	{
	    cerr << "wfst_run: can't open datafile \"" << files(files.head()) 
		<< "\" for reading." << endl;
	    exit(-1);
	}
    }
	    
    // Not the best way to input things but will do the the present
    while(!ts.eof())
	istrs.append(ts.get());

    if (al.present("-recog"))
	r = recognize(wfst,istrs);
    else
    {
	r = transduce(wfst,istrs,ostrs);
	if (r)
	{
	    cout << ostrs;
	    cout << endl;
	}
    }

    ts.close();

    if (ofd != stdout)
	fclose(ofd);

    if (!al.present("-quiet"))
    {
	if (r)
	    cout << "OK." << endl;
	else
	    cout << "failed." << endl;
    }
    
    if (r)
	return 0;
    else
	return -1;
}

