 ###########################################################################
 ##                                                                       ##
 ##                Centre for Speech Technology Research                  ##
 ##                     University of Edinburgh, UK                       ##
 ##                         Copyright (c) 1996                            ##
 ##                        All Rights Reserved.                           ##
 ##                                                                       ##
 ##  Permission to use, copy, modify, distribute this software and its    ##
 ##  documentation for research, educational and individual use only, is  ##
 ##  hereby granted without fee, subject to the following conditions:     ##
 ##   1. The code must retain the above copyright notice, this list of    ##
 ##      conditions and the following disclaimer.                         ##
 ##   2. Any modifications must be clearly marked as such.                ##
 ##   3. Original authors' names are not deleted.                         ##
 ##  This software may not be used for commercial purposes without        ##
 ##  specific prior written permission from the authors.                  ##
 ##                                                                       ##
 ##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
 ##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
 ##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
 ##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
 ##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
 ##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
 ##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
 ##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
 ##  THIS SOFTWARE.                                                       ##
 ##                                                                       ##
 ###########################################################################
 ##                                                                       ##
 ##                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ##
 ##                   Date: Thu Oct  2 1997                               ##
 ## --------------------------------------------------------------------  ##
 ## Description of directory structure etc. at CSTR.                      ##
 ##                                                                       ##
 ###########################################################################

###########################################################################
## Names of various gcc versions

GCC26=gcc-2.6.3 
GCC27=gcc

###########################################################################
## Installation directories

INSTALL_PREFIX=/cstr

###########################################################################
## We have a master RCS tree below this directory

LOCAL_REPOSITORY = /projects

###########################################################################
## Some of our things are installed under /cstr or /usr/local/GNU, and we
## don't have the common /usr/X11 link on some machines, so we need to
## reset some paths.

NAS_INCLUDE = /cstr/include
NAS_LIB     = /cstr/lib

X11_INCLUDE = /usr/X11R6/include
X11_LIB     = /usr/X11R6/lib

RL_DIR     = /usr/local/GNU
RL_INCLUDE = $(RL_DIR)/include
RL_LIB     = $(RL_DIR)/lib 

JAVA_HOME = /cstr/external/jdk

###########################################################################
# If we have this it's a _LOT_ faster than the java version

JAR=zip -0


