 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/


class DummyObject;

#ifndef __DUMMYOBJECT_H__
#define __DUMMYOBJECT_H__

#include "EST.h"
#include "SubtypedObject.h"

/** A functionless C++ object class visible from scheme as a skeleton
  * to build around.
  * @author Richard Caley <rjc@cstr,ed,ac,uk>
  * @version $Id: DummyObject.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */
class DummyObject : public SubtypedObject<DummyObject> {

public:
  // public types here
private:
  // private variables here
protected:
  // interface used by subclasses, eg to set the private variables.
public:

  /// Default constructor.
  DummyObject(void);
  /// Destructor.
  virtual ~DummyObject(void); 

  /**@name Subtyping */
  //@{
  /// read in from the file.
  virtual EST_read_status fill_from(FILE *stream, int binary=1);
  /// Write out to file.
  virtual EST_write_status write_to(FILE *stream, int binary=1);
  /// Record the filename.
  void set_filename(EST_String);
  //@}


  /**@name Properties */
  //@{
  /// List of all understood properties.
  virtual void property_names(EST_TList<EST_String> &list) const;
  /// Set a single property.
  virtual int set_property(EST_String property, ValueType value);
  /// Get value for a property.
  virtual ValueType property(EST_String property) const;
  //@}

#if defined(INCLUDE_LISP)
  /**@name Scheme interface
    * These are the functions which are imported into Scheme. 
    */
  //@{

  /// Initialisation function.
  static void lisp_declare(void);
  //@}
#endif

  friend class SubtypedObject<DummyObject>;
};
//@}


#endif
