#include <stdio.h>
#include <stdlib.h>

#include "Xsqldefs.h"
#include "Recorddefs.h"

void RecordClose(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;
   
   fl_hide_form(fd_Rec->Record);
   
   if(I->Res != 0)
     msqlFreeResult(I->Res);

   FreeInfoStruct(I);
   free(fd_Rec->Inputs);
   fl_free_form(fd_Rec->Record);
}

/* this is roughly the layout as it will be generated by fdesign */
FD_Record *create_form_Record(void)
{
   FL_OBJECT *obj;
   FD_Record *fdui = (FD_Record *) fl_calloc(1, sizeof(*fdui));
   
   fdui->Record = fl_bgn_form(FL_NO_BOX, RECWIDTH, RECHEIGHT);
   obj = fl_add_box(FL_UP_BOX,0,0,RECWIDTH,RECHEIGHT,"");
   fdui->Title = obj = fl_add_text(FL_NORMAL_TEXT,HMARGIN,TEXTOFFSET,
				   RECWIDTH - (2 * HMARGIN),VTEXTAREA,"");
   fl_set_object_lsize(obj,FL_NORMAL_SIZE);
   fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
   fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_EMBOSSED_STYLE);
   fl_set_object_resize(obj,FL_RESIZE_NONE);
   fl_set_object_gravity(obj,FL_NorthWest,FL_NoGravity);
   obj = fl_add_frame(FL_ENGRAVED_FRAME,HMARGIN,BUTTOFFSET,
		      RECWIDTH - (2* HMARGIN),VBUTAREA,"");
   fl_set_object_resize(obj,FL_RESIZE_NONE);
   fl_set_object_gravity(obj,FL_NorthWest,FL_NoGravity);
   
   fdui->Close = obj = fl_add_button(FL_NORMAL_BUTTON,HMARGIN + HBUTMARGIN,
				     BUTTOFFSET + VBUTMARGIN,WBUTTON,HBUTTON,"Close");
   fl_set_object_resize(obj,FL_RESIZE_NONE);
   fl_set_object_gravity(obj,FL_NorthWest,FL_NoGravity);
   fl_set_object_callback(obj,RecordClose,(long)fdui);
   
   fl_end_form();
   return fdui;
}

FD_Record *BuildRecordForm(Info_t *I, char *title, int buttons)
{
   FD_Record *fd_Rec;
   FL_OBJECT *obj;
   int y=0;
   int p;
   int recheight = VINPOFFSET + I->Numflds * (INPHEIGHT + VINPMARGIN) + VMARGIN;
   
   fd_Rec = create_form_Record();
   fd_Rec->vdata = CopyInfoStruct(I); /* store all table information locally !! */
   
   fl_addto_form(fd_Rec->Record);

   fl_set_form_size(fd_Rec->Record,RECWIDTH,recheight);
   fl_set_object_label(fd_Rec->Title,title);
   
   p = HMARGIN + HBUTMARGIN;
   if(buttons & MODBUT)
   {  
      p += WBUTTON + HBUTMARGIN;
      obj = fl_add_button(FL_NORMAL_BUTTON,p,BUTTOFFSET + VBUTMARGIN,
			  WBUTTON,HBUTTON,"Modify");
      fl_set_object_callback(obj,RecordUpdate,(long)fd_Rec);
   }
   if(buttons & DELBUT)
   {
      p += WBUTTON + HBUTMARGIN;
      obj = fl_add_button(FL_NORMAL_BUTTON,p,BUTTOFFSET + VBUTMARGIN,
			  WBUTTON,HBUTTON,"Delete");
      fl_set_object_callback(obj,RecordDelete,(long)fd_Rec);
   }
   if(buttons & INSBUT)
   {
      p += WBUTTON + HBUTMARGIN;
      obj = fl_add_button(FL_NORMAL_BUTTON,p,BUTTOFFSET + VBUTMARGIN,
			  WBUTTON,HBUTTON,"Insert");
      fl_set_object_callback(obj,RecordInsert,(long)fd_Rec);
   }
   if(buttons & CHGBUT)
   {
      p += WBUTTON + HBUTMARGIN;
      obj = fl_add_button(FL_NORMAL_BUTTON,p,BUTTOFFSET + VBUTMARGIN,
			  WBUTTON,HBUTTON,"Change");
      fl_set_object_callback(obj,RecordChange,(long)fd_Rec);
   }
   if(buttons & SEABUT)
   {
      p += WBUTTON + HBUTMARGIN;
      obj = fl_add_button(FL_NORMAL_BUTTON,p,BUTTOFFSET + VBUTMARGIN,
			  WBUTTON,HBUTTON,"Search");
      fl_set_object_callback(obj,RecordSearch,(long)fd_Rec);
   }
   if(buttons & PREBUT)
   {
      p += WBUTTON + HBUTMARGIN;
      fd_Rec->Previous = obj = fl_add_button(FL_TOUCH_BUTTON,p,BUTTOFFSET +
					     VBUTMARGIN,WBUTTON,HBUTTON,"Previous");
      fl_set_object_callback(obj,RecordPrevious,(long)fd_Rec);
   }
   if(buttons & NEXBUT)
   {
      p += WBUTTON + HBUTMARGIN;
      fd_Rec->Next = obj = fl_add_button(FL_TOUCH_BUTTON,p,BUTTOFFSET +
					 VBUTMARGIN,WBUTTON,HBUTTON,"Next");
      fl_set_object_callback(obj,RecordNext,(long)fd_Rec);
   }
   
   fd_Rec->Inputs = (FL_OBJECT **)malloc(I->Numflds * sizeof(FL_OBJECT *));
   
   for(y=0;y< I->Numflds;y++)
   {
      fd_Rec->Inputs[y] = fl_add_input(FL_NORMAL_INPUT,HINPOFFSET,
				       VINPOFFSET + y*(INPHEIGHT + VINPMARGIN),
				       INPWIDTH,INPHEIGHT,I->Fields[y].name);
      fl_set_object_lsize(fd_Rec->Inputs[y],FL_NORMAL_SIZE);
      fl_set_object_lalign(fd_Rec->Inputs[y],FL_ALIGN_LEFT);
      fl_set_object_lstyle(fd_Rec->Inputs[y],FL_BOLD_STYLE);
      fl_set_input_maxchars(fd_Rec->Inputs[y],I->Fields[y].length);

   }
   
   /* give the primary key a nice color : */

   fl_set_input_color(fd_Rec->Inputs[I->Primkey],FL_RED,FL_BLUE);
   fl_set_object_lcol(fd_Rec->Inputs[I->Primkey],FL_RED);

   fl_end_form();
   fl_show_form(fd_Rec->Record,
		FL_PLACE_MOUSE,FL_FULLBORDER,"Record");

   return fd_Rec;
}

