// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        imgserver.h
//
// Purpose:     server for texture images and URLs via Hyper-G
//
// Created:     16 Mar 94   Gaisbauer Mansuet Juergen
//
// Changed:     28 Apr 97   Michael Pichler
//
// changes (simplifications) over Mansuet's implementation:
// no image caching, sequential order of fetching images
//
// $Id: imgserver.h,v 1.9 1997/04/30 10:33:29 mpichler Exp $
//
//</file>


#ifndef harmony_scene_imgserver_h
#define harmony_scene_imgserver_h

#include <hyperg/utils/str.h>
#include <hyperg/hyperg/object.h>

#include <hyperg/harmony/utils/dcconnect.h>
/* #include <hyperg/Dispatch/rpcservice.h> */
#include <hyperg/Dispatch/iohandler.h>
#include <hyperg/Dispatch/iocallback.h>

#include "slist.h"

#include <fstream.h>

class Material;
class QvTexture2;
class QvWWWInline;

class HgViewerManager;
class ImageServer;
class ImageRequest;
class InlineURLRequest;


//<class>
//
// Name: ImageReader
//
//</class>

class ImageReader: public IOHandler
{
  public:
    ImageReader (int fd, ImageServer* server);
    ~ImageReader ();

    virtual int inputReady (int fd);

  private:
    enum
    { request,
      header_ok,
      no_header
    } header_state_;

    int pipe_port_;

    ImageServer* server_;

    RString filename_;

    ofstream ostr_;

    static char* rd_buf_;
    static unsigned int img_reader_no_;

  friend class ImageServer;

}; // ImageReader



class ImageServerCallback
{
  public:
    // fetching data:
    virtual int readImage (Material* mat, QvTexture2* tex, const char* filename) = 0;
    // return 0 to continue, or 1 to stop reading

    virtual int readInlineURL (QvWWWInline* nodeI, QvTexture2* nodeT, const char* filename, const char* absurl) = 0;
    // return 0 to continue, or 1 to stop reading

    // feedback:
    virtual void requestImage (const char* texname) = 0;
    virtual void requestURL (const char* url, int texture) = 0;
    virtual void requestFinished () = 0;
};


//<class>
//
// Name:     ImageServer
//
//</class>


// RpcService replaced by DcConnect

class ImageServer: public DcConnect
{
  public:
    ImageServer (
      HgViewerManager* manager,
      ImageServerCallback* callback
    );
    ~ImageServer ();

    void setDCHostPort (                // connection to DocumentCache
      const RString& dchost,            //   host
      int dcport                        //   port no.
    )
    {
      dchost_ = dchost;
      dcport_ = dcport;
    }

    void clearAllRequests ();           // cancel all current requests

    void cancelRequest (                // cancel specific request
      const char*                       //   ref.number (string)
    );

    void appendRequest (                // request for texture image
      const RString& doc_id,            //   document ID
      const Object& anchor_obj,         //   anchor object
      const RString& dest,              //   destination (string)
      Material* mat,                    //   textured material (SDF) or
      QvTexture2* tex                   //   texture node (VRML)
    );

    void parseURL (const char* url,     // parse an URL
      const char* docurl,               //   URL of requesting document (for local URLs)
      RString& msg,                     //   and build a Hyper-G object string
      RString& fullURL                  //   also return full (absolute) URL
    );
    // object string contains: DocumentID 0, unused ObjectID, Type,
    // DocumentType, RemoteType, Protocol, Host, Port, Path, WWWType, Title;
    // caller may append WWWType, LinkType, PipePort, PipeHost

    virtual void requestURLdata (       // URL request for either
      QvWWWInline* nodeI,               //   inline node (where attach inline scene)
      QvTexture2* nodeT,                //   texture node (to read texture image)
      const char* url,                  //   requested URL (of data to be fetched)
      const char* docurl                //   URL of requesting document (for local URLs)
    );

    void handleRequests (int texturesalso);

    void requestLink (RString msg);     // compose followLink request for manager_

    // RpcService
    virtual void createReader (int fd);

    const RString& getPath () const  { return path_; }

  private:
    void removeReader (                 // reader finished
      ImageReader* reader,              //   will be destroyed
      int fdtoclose = 0                 //   fd to be closed
    );

    void insertCache (long, long);

    boolean idIsRequested (const RString& doc_id);

    int req_without_connect_;   // number of requests without a reader; no
                                // connect has happend; is not equal to
                                // req_list_.count() because requests will
                                // be removed from this list if the image is
                                // identified by a header, but left in the list
                                // otherwise

    ImageRequest* pendingimgrequest_;   // pending image request
    slist imagerequests_;               // list of ImageRequest

    InlineURLRequest* pendingurlrequest_;  // pending URL (inline VRML) request
    slist urlrequests_;                 // list of InlineURLRequest

//     ImgReqList req_list_;       // list of requests, which are not assigned
//                                 // to an image via a header
//     ImgList image_list_;        // list of received images, which maybe 
//                                 // allready assigned to a request (after
//                                 // identifying them via a header)

    int requesttextures_;               // whether to load texture images too

    ImageReader* imgreader_;

    HgViewerManager* manager_;
    RString path_;

    ImageServerCallback* callback_;

    static long refno_;                 // free refno for WWW anchors

    RString dchost_;                    // DocCache host (for connect)
    int dcport_;                        // DocCache port

  friend class ImageReader;

}; // ImageServer


#endif
