/*================================================================
 * read index file
 *================================================================*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include "channel.h"
#include "util.h"
#include "midievent.h"
#include "controls.h"
#include "options.h"

static int read_midi_index(FILE *fp, MidiInfo *mp, int before_reading);

#define MIDI_INDEX_SUFFIX	".id"

int find_midi_index(MidiInfo *mp, int before_reading)
{
	char name[256], *ext;
	FILE *fp;
	int rc;

	strcpy(name, mp->filename);
	if ((ext = CmpGetExtension(name)) != NULL)
		*ext = 0;
	strcat(name, MIDI_INDEX_SUFFIX);
	/*fprintf(stderr, "searching %s\n", name);*/
	if ((fp = fopen(name, "r")) == NULL) {
		/* prepend dot */
		char name2[256];
		ext = strrchr(name, '/');
		if (ext) {
			*ext = 0;
			sprintf(name2, "%s/.%s", name, ext + 1);
		} else {
			sprintf(name2, ".%s", name);
		}
		/*fprintf(stderr, "searching %s\n", name2);*/
		if ((fp = fopen(name2, "r")) == NULL)
			return 0;
	}

	/*fprintf(stderr, "found %s\n", name);*/
	rc = read_midi_index(fp, mp, before_reading);
	fclose(fp);

	return rc;
}


static int divide_line(char *line, char **tokp, char **valp)
{
	char *tok, *val, *p;
	/* skip white spaces at the beginning */
	for (tok = line; *tok && isspace(*tok); tok++)
		;
	if (*tok == '#') /* skip comment line */
		return FALSE;
	/* search the value string */
	for (val = tok; *val && !isspace(*val); val++)
		;
	if (*val) {
		*val = 0;
		val++;
	}
	for (; isspace(*val); val++)
		;

	/* delete linefeed code */
	for (p = val; *p && *p != '\n'; p++)
		;
	*p = 0;

	*tokp = tok;
	*valp = val;
	return TRUE;
}

void parse_index_line(MidiInfo *mp, char *line, int before_reading)
{
	char *tok, *val;

	if (! divide_line(line, &tok, &val))
		return;

	switch (do_option_index(mp, tok, val, before_reading)) {
	case OPT_SUBSF:
		ctl->cmsg(CMSG_INFO, 0, "loading subsf %s", val);
		load_sub_sf(mp, val);
		break;
	case OPT_XGLOAD:
		if (!mp->dynamic_loaded && mp->midi_mode == MODE_XG &&
		    strcmp(val, "none") != 0) {
			ctl->cmsg(CMSG_INFO, 0, "loading xg map %s", val);
			preload_sample(mp, val);
		}
		mp->dynamic_loaded = TRUE; /* do not load any more */
		break;
	case OPT_TITLE:
		if (val && *val)
			ctl->title(val);
		break;
	case OPT_DYNAMIC:
		if (!mp->dynamic_loaded && strcmp(val, "none") != 0) {
			ctl->cmsg(CMSG_INFO, 0, "loading font %s", val);
			midi_open(mp);
			preload_sample(mp, val);
		}
		mp->dynamic_loaded = TRUE; /* do not load any more */
		break;
	case OPT_CHN_VOLUME:
		{int ch;
		if ((val = strtok(val, " \n\t\r")) == NULL)
			break;
		if ((ch = atoi(val)) < 1 || ch > MAX_MIDI_CHANNELS)
			break;
		if ((val = strtok(NULL, " \n\t\r")) == NULL)
			break;
		ch--;
		BITON(mp->chn_volflag, DRUMBIT(ch));
		channels[ch].volscale = adjust_volscale(val);
		ctl->cmsg(CMSG_INFO, 0, "channel(%d) volume scale %s", ch, val);
		break;}
	}
}

static int read_midi_index(FILE *fp, MidiInfo *mp, int before_reading)
{
	char line[256];

	while (fgets(line, sizeof(line), fp)) {
		parse_index_line(mp, line, before_reading);
	}
	return 1;
}

