/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

/*
 *	@(#)sysdep.h	1.3 1996-08-06
 */
#ifndef SYSDEP_H_INCLUDED
#define SYSDEP_H_INCLUDED

#if defined(__alpha) && (defined(__osf__) || defined(__linux__))
typedef unsigned int	UINT4;
#else
typedef unsigned long	UINT4;
#endif

#if defined(unixware) || defined(sys5) || defined(M_UNIX)
#include        <string.h>
#else   /* unixware */
#include        <strings.h>
#endif  /* unixware */

#if defined(bsdi)
#include        <machine/inline.h>
#include        <machine/endian.h>
#else	/* bsdi */
# ifdef __FreeBSD__
#  include        <stdlib.h>
# else
#  include        <malloc.h>
# endif  /* FreeBSD */
#endif	/* bsdi */

#if defined(aix)
#include	<sys/select.h>
#endif	/* aix 	*/

/* UTMP stuff. Uses utmpx on svr4 */
#ifdef __svr4__
#  include <utmpx.h>
#  include <sys/fcntl.h>
#  define utmp utmpx
#  define UT_NAMESIZE	32
#  define UT_LINESIZE	32
#  define UT_HOSTSIZE	257
#else
#  include <utmp.h>
#endif
#ifdef __osf__
#  define UT_NAMESIZE	32
#  define UT_LINESIZE	32
#  define UT_HOSTSIZE	64
#endif
#ifdef __FreeBSD__
#  ifndef UTMP_FILE
#    define UTMP_FILE "/var/run/utmp"
#  endif
#  define ut_user ut_name
#endif

#endif /* SYSDEP_H_INCLUDED */
