"traceplot" <-
function (x, combine.chains = F, smooth = T, ...) 
{
        x <- as.mcmc(x)
        if (combine.chains) 
                for (i in 1:nvar(x)) matplot(time(x), x[, i, 
                        , drop = T], type = "l", xlab = "Iterations", 
                        ylab = varnames(x)[i])
        else for (i in 1:nchain(x)) {
                for (j in 1:nvar(x)) {
                        xp <- as.vector(time(x))
                        yp <- x[, j, i, drop = T]
                        plot(xp, yp, type = "l", xlab = "Iterations", 
                                ylab = varnames(x)[j])
                        if (smooth) 
                                lines(lowess(xp, yp), col = "red")
                        mtext(paste("Trace of", varnames(x)[j]), 
                                side = 3, line = 2.5)
                        mtext(paste("(", format(niter(x)), " values per trace)", 
                                sep = ""), side = 3, line = 0.65)
                }
        }
}
