"[.mcmc" <-
function (x, i, j, k, drop = F) 
{
        #Drop = F by default, which is the opposite of the normal default
        #
        y <- NextMethod("[", drop = drop)
        if (drop) {
                attr(y, "tspar") <- NULL
                attr(y, "transform") <- NULL
                return(y)
        }
        else {
		if (!missing(j)) attr(y, "transform") <- attr(x, "transform")[j]
		else attr(y,"transform") <- attr(x,"transform")
		attr(y,"title") <- attr(x,"title")
	}
        if (missing(i)) 
                mcmc(y, start = start(x), thin = thin(x))
        else {
                n <- dim(x)[1]
                ind <- (1:n)[i]
                delta <- unique(ind[-1] - ind[-length(ind)])
                if (length(delta) != 1 || delta <= 0) {
                        warning("Not returning an MCMC object")
                }
                else {
                        xtspar <- tspar(x)
                        xtimes <- seq(from = xtspar[1], to = xtspar[2], 
                                by = xtspar[3])
                        ytspar <- numeric(3)
                        ytspar[1] <- xtimes[min(ind)]
                        ytspar[2] <- xtimes[max(ind)]
                        ytspar[3] <- (ytspar[2] - ytspar[1])/(length(ind) - 
                                1)
                        tspar(y) <- ytspar
                        class(y) <- "mcmc"
                }
                y
        }
}
