"codamenu.options.data" <-
function () 
{
        next.menu <- "codamenu.options.data"
        #
        work.vars <- varnames(work.dat)
        work.chains <- chanames(work.dat)
        work.start <- start(work.dat)
        work.end <- end(work.dat)
        work.thin <- thin(work.dat)
        #
        choices <- c("List current data options", "Select variables for analysis", 
                "Select chains for analysis", "Select iterations for analysis", 
                "Select thinning interval", "Return to main options menu")
        action.list <- c("ListDataOptions", "SelectVars", "SelectChains", 
                "SelectIters", "SelectThinInterval", "MainOptionsMenu")
        cat("\nCODA Data Options Menu\n***********************\n")
        pick <- menu(choices)
        if (pick == 0) 
                return("quit")
        switch(action.list[pick], ListDataOptions = {
                print.coda.options(data = T)
        }, SelectVars = {
                work.vars <- multi.menu(colnames(coda.dat), "Select variables for analysis", 
                        c("VARIABLE NUMBER", "VARIABLE NAME"), 
                        allow.zero = F)
        }, SelectChains = {
                work.chains <- multi.menu(dimnames(coda.dat)[[3]], 
                        "Select chains for analysis:", c("CHAIN NUMBER", 
                                "CHAIN NAME"), allow.zero = F)
        }, SelectIters = {
                cat("\nIterations available = ", start(coda.dat), 
                        ":", end(coda.dat), "\n", sep = "")
                work.start <- read.and.check("Enter iteration you wish to start at", 
                        lower = start(coda.dat), upper = end(coda.dat), 
                        default = start(work.dat))
                work.end <- read.and.check("Enter iteration you wish to end at", 
                        lower = work.start, upper = end(coda.dat), 
                        default = end(work.dat))
        }, SelectThinInterval = {
                cat("\nThinning interval of full data = ", thin(coda.dat), 
                        "\n", sep = "")
                work.thin <- read.and.check("Enter thinning interval:", 
                        lower = thin(coda.dat), default = thin(work.dat))
        }, MainOptionsMenu = {
                next.menu <- "codamenu.options"
        })
        if (action.list[pick] != "ListDataOptions" && action.list[pick] != 
                "MainOptionsMenu") {
                cat("Recreating working data...\n")
                work.dat <<- window(coda.dat[, work.vars, work.chains], 
                        start = work.start, end = work.end, thin = work.thin)
        }
        return(next.menu)
}
