#include <math.h>
#include <stddef.h>

void call_R(char *func, long nargs, void **arguments, char **modes,
	    long *lengths, char **names, long nres, char **results);

/* used in stable.c */
/* static */ void polint(double xa[], double ya[], int n, double x, double *y,
	    double *dy, int *err)
/* Press et al. p.109 */
{
  int i, m, ns=1;
  double den, dif, dift, ho, hp, w;
  double *c, *d;
 
  *err=0;
  dif=fabs(x-xa[1]);
  c=(double*)malloc((size_t)((n+1)*sizeof(double)));
  d=(double*)malloc((size_t)((n+1)*sizeof(double)));
  if(!c||!d){
    *err=1;
    return;}
  for(i=1;i<=n;i++){
    if((dift=fabs(x-xa[i]))<dif){
      ns=i;
      dif=dift;}
    c[i]=ya[i];
    d[i]=ya[i];}
  *y=ya[ns--];
  for(m=1;m<n;m++){
    for(i=1;i<=n-m;i++){
      ho=xa[i]-x;
      hp=xa[i+m]-x;
      w=c[i+1]-d[i];
      if((den=ho-hp)==0.0){
	*err=2;
	return;}
      den=w/den;
      d[i]=hp*den;
      c[i]=ho*den;}
    *y+=(*dy=(2*ns<(n-m)?c[ns+1]:d[ns--]));}
  free((char *)d);
  free((char *)c);}

static double midpnt(void *func, double a, double b, int n)
/* Press et al. p.142 */
{
  double *x, tnm, sum, del, ddel, zz[1];
  static double s;
  char *mode[1], *ss[1];
  long length[1];
  void *args[1];
  int it,j;

  mode[0] = "double";
  length[0] = 1;
  args[0] = (void *)(zz);

  if (n==1){
    zz[0]=0.5*(a+b);
    call_R(func, 1L, args, mode, length, 0L, 1L, ss);
    x=(double *)ss[0];
    return(s=(b-a)*x[0]);}
  else {
    for(it=1,j=1;j<n-1;j++) it*=3;
    tnm=it;
    del=(b-a)/(3.0*tnm);
    ddel=del+del;
    zz[0]=a+0.5*del;
    sum=0.0;
    for(j=1;j<=it;j++){
      call_R(func, 1L, args, mode, length, 0L, 1L, ss);
      x=(double *)ss[0];
      sum+=x[0];
      zz[0]+=ddel;
      call_R(func, 1L, args, mode, length, 0L, 1L, ss);
      x=(double *)ss[0];
      sum+=x[0];
      zz[0]+=del;}
    s=(s+(b-a)*sum/tnm)/3.0;
    return(s);}}

#define JMAX 16
#define JMAXP (JMAX+1)

void qromo(void *func, double *a, double *b, double *eps, int *k,
	     /* double (*choose)(double(*)(double), double,double,int), */
	     int *err, double *ss)
/* Press et al. p.143 */
{
  int j;
  double dss,h[JMAXP+1],s[JMAXP+1];

  *err=0;
  h[1]=1.0;
  for(j=1;j<=JMAX;j++){
/*    s[j]=(*choose)(func,*a,*b,j);*/
    s[j]=midpnt(func,*a,*b,j);
    if(j>=*k){
      polint(&h[j-*k],&s[j-*k],*k,0.0,ss,&dss,err);
      if(*err)return;
      if(fabs(dss)<*eps*fabs(*ss))return;}
    s[j+1]=s[j];
    h[j+1]=h[j]/9.0;}
  *err=3;
  return;}
