% $Id: residuals.gls.Rd,v 1.2 1998/04/06 21:35:19 pinheiro Exp $
\name{residuals.gls}
\title{Extract gls Residuals}
\usage{
residuals(object)
}
\alias{residuals.gls}
\arguments{
 \item{object}{an object inheriting from class \code{gls}, representing
   a generalized least squares fitted linear model.}
}
\description{
  The residuals for the linear model represented by \code{object}
  are extracted.
}
\value{
  a vector with the residuals for the linear model represented by
  \code{object}. 
}

\author{Jose Pinheiro and Douglas Bates}

\seealso{\code{\link{gls}}, \code{\link{residuals.gls}} }

\examples{
library(lme)
data(Ovary)
fm1 <- gls(follicles ~ sin(2*pi*Time) + cos(2*pi*Time), Ovary,
           correlation = corAR1(form = ~ 1 | Mare))
residuals(fm1)
}
\keyword{models}
