% $Id: corGaus.Rd,v 1.6 1998/04/02 20:02:06 bates Exp $
\name{corGaus}
\title{Gaussian Correlation Structure}
\usage{
corGaus(value, form, nugget, metric)
}
\alias{corGaus}
\arguments{
 \item{value}{an optional vector with the parameter values in
   constrained form. If \code{nugget} is \code{FALSE}, \code{value} can
   have only one element, corresponding to the "range" of the
   exponential correlation structure, which must be greater than
   zero. If \code{nugget} is \code{TRUE}, meaning that a nugget effect
   is present, \code{value} can contain one or two elements, the first
   being the "range" and the second the "nugget ratio" (the ratio
   between the variance of an observation and the covariance between two
   observations taken arbitrarily close together); the first must be
   greater than zero and the second must be between zero and
   one. Defaults to \code{numeric(0)}, which results in a range of 90\%
   of the minimum distance and a nugget ratio of 0.9 being assigned to
   the parameters when \code{object} is initialized.}
 \item{form}{a one sided formula of the form \code{~ S1+...+Sp}, or
   \code{~ S1+...+Sp | g}, specifying spatial covariates \code{S1}
   through \code{Sp} and,  optionally, a grouping factor \code{g}. 
   When a grouping factor is present in \code{form}, the correlation
   structure is assumed to apply only to observations within the same
   grouping level; observations with different grouping levels are
   assumed to be uncorrelated. Defaults to \code{~ 1}, which corresponds
   to using the order of the observations in the data as a covariate,
   and no groups.}   
 \item{nugget}{an optional logical value indicating whether a nugget
   effect is present. Defaults to \code{FALSE}.}
 \item{metric}{an optional character string specifying the distance
   metric to be used. The currently available options are
   \code{"euclidian"} for the root sum-of-squares of distances;
   \code{"maximum"} for the maximum difference; and \code{"manhattan"}
   for the sum of the absolute differences. Partial matching of
   arguments is used, so only the first three characters need to be
   provided.Defaults to \code{"euclidian"}.}
}
\description{
  This function is a constructor for the \code{corGaus} class,
  representing a Gaussian spatial correlation structure. Letting
  \eqn{d} denote the range and \eqn{n} denote the nugget
  ratio, the correlation between two observations a distance
  \eqn{r} apart is \eqn{\exp(-(r/d)^2)}{exp(-(r/d)^2)} when no nugget
  effect is present and \eqn{n \exp(-(r/d)^2)}{n*exp(-(r/d)^2)} when a
  nugget effect is assumed. Objects created using this constructor need
  to be later initialized using the appropriate \code{initialize} method.
}
\value{
  and object of class \code{corGaus}, also inheriting from class
  \code{corSpatial}, representing a Gaussian spatial correlation
  structure. 
}
\references{
  Venables, W.N. and Ripley, B.D. (1997) "Modern Applied Statistics with
  S-plus", 2nd Edition, Springer-Verlag.
  Littel, Milliken, Stroup, and Wolfinger (1997) "SAS Systems for Mixed
  Models", SAS Institute.
}
\author{Jose Pinheiro and Douglas Bates}

\seealso{\code{\link{initialize.corStruct}}, \code{\link{dist}}
}
\examples{
library(lme)
sp1 <- corGaus(form = ~ x + y + z)
}
\keyword{models}
