#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  The full text of the legal notices is contained in the file called
#  COPYING, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

set vFolderCut ""
# CreateMBoxWin --
#
# Create a hierachical browser widget to use for mailbox manipulation
#
# Arguments:
proc CreateMBoxWin {} {
    global option t b vFolderCurrent vFolderChanged hiervfld hierlb mailbox \
	tk_version

    set id .mailbox
    upvar #0 $id win
    set win(type) mailbox
    set mypad 8
    set win(mypad) $mypad

    # If a hierwin of this type already exists, exit, otherwise build one
    if [winfo exists $id] {
	wm deiconify $id
	raise $id
	return
    }
    # Make the window
    toplevel $id -class Postilion
    $id configure
    wm withdraw $id
    Place $id mailbox
    wm group $id .
    wm protocol $id WM_DELETE_WINDOW "VFHierWindowDestroy $id"
    wm title $id $t(mailboxes)
    wm iconname $id $t(mailboxes)

    BuildHierarchyWindow $id
    # Create path entry
    frame $id.fPE -bd 1 -relief flat
    label $id.path_label -relief flat
    label $id.path_begin -bd 2 -relief sunken -anchor w

    pack $id.fPE -fill x -padx $mypad -pady 4
    pack $id.path_label -in $id.fPE -side left
    pack $id.path_begin -in $id.fPE -side left -fill x \
	-padx 1 -pady 1 -ipady 2 -expand 1

    SetIcon $id mboxwin
    upvar #0 $id md
    # Set some global defaults, for now...
    set mypad 8
    set vFolderChanged 0
    set hiervfld 1
    set hierlb $id.fLBs.0.lb
    set vFolderCurrent {0 end}
    set md(win_type) mailbox
    set md(w) $id
    set md(done) 0
    set md(dragging) 0
    set oldFocus [focus]

    # Create action buttons
    set buts $id.buttons
    frame $buts
    button $buts.open -bd 1 -relief raised -text $t(open)
    set b($buts.open) vd_open
    menubutton $buts.new -bd 1 -relief raised -text $t(new) \
	-indicatoron yes -menu $buts.new.m
    set b($buts.new) vd_foldermenu
    menu $buts.new.m
    $buts.new.m add command -label file-folder -command {VFolderNew file}
    set b($buts.new.m,[$buts.new.m index end]) vd_newfile
    $buts.new.m add command -label MH-style -command {VFolderNew mh}
    set b($buts.new.m,[$buts.new.m index end]) vd_newmh
    $buts.new.m add command -label POP3 -command {VFolderNew pop3}
    set b($buts.new.m,[$buts.new.m index end]) vd_newpop
    $buts.new.m add command -label IMAP -command {VFolderNew imap}
    set b($buts.new.m,[$buts.new.m index end]) vd_newimap
    $buts.new.m add command -label Dynamic -command {VFolderNew dynamic}
    set b($buts.new.m,[$buts.new.m index end]) vd_newdynamic
    $buts.new.m add command -label DBase -command {VFolderNew dbase}
    set b($buts.new.m,[$buts.new.m index end]) vd_newdbase
    $buts.new.m add command -label Sub-menu -command VFolderCreateMenu
    set b($buts.new.m,[$buts.new.m index end]) vd_createsub
    button $buts.transfer -bd 1 -relief raised -text $t(move_to)
    set b($buts.transfer) move
    $buts.transfer config -default active
    
    button $buts.delete -bd 1 -relief raised -text $t(delete) \
	-command VFolderDelete
    set b($buts.delete) vd_delete
    pack $buts.delete $buts.new $buts.open $buts.transfer -side left \
	-padx 5 -pady 5 -ipadx 5 -fill x -expand yes

    pack $buts -padx $mypad -pady 5 -fill x -expand no
    
    #populate the first listbox and icon
    VFolderBuildList $id.fLBs.0.lb 0
    bind $id.fLBs.0.lb <ButtonRelease-1> "VFActHierList %W  mailbox"
    $id.labbox.0.text configure -text $t(mailboxes)
    $id.path_label configure -text $t(mailbox):

    # Create the floating menu
    set menu $id.m
    menu $menu -tearoff 0
    $menu add command -label $t(edit)... -command EditVFolderEntry
    set b($menu,[$menu index end]) vd_edit
    $menu add command -label $t(delete)... -command VFolderDelete
    set b($menu,[$menu index end]) vd_delete
    $menu add command -label $t(cut) -command VFolderCut
    set b($menu,[$menu index end]) vd_cut
    $menu add command -label $t(paste) -command VFolderPaste
    set b($menu,[$menu index end]) vd_paste
    $menu add command -label $t(set_to_inbox) \
	-command {VFolderSetToSpecial Inbox}
    set b($menu,[$menu index end]) vd_setinbox
    $menu add command -label $t(set_to_save_outgoing) \
	-command {VFolderSetToSpecial Save}
    set b($menu,[$menu index end]) vd_setsaveout
    $menu add command -label $t(create_submenu)... -command VFolderCreateMenu
    set b($menu,[$menu index end]) vd_createsub
    $menu add command -label $t(new_file)... -command {VFolderNew file}
    set b($menu,[$menu index end]) vd_newfile
    $menu add command -label $t(new_mh)... -command {VFolderNew mh}
    set b($menu,[$menu index end]) vd_newmh
    $menu add command -label $t(new_dbase)... -command {VFolderNew dbase}
    set b($menu,[$menu index end]) vd_newdbase
    $menu add command -label $t(new_imap)... -command {VFolderNew imap}
    set b($menu,[$menu index end]) vd_newimap
    $menu add command -label $t(new_pop3)... -command {VFolderNew pop3}
    set b($menu,[$menu index end]) vd_newpop
    $menu add command -label $t(new_dynamic)... -command {VFolderNew dynamic}
    set b($menu,[$menu index end]) vd_newdynamic

    bind $id <FocusIn> "ConfigMainMenu $id"
    wm deiconify $id
    Size $id mailbox
    return $id
}


# VFolderBuildList --
#
# Constructs a list of vfolders.
#
# Arguments:
# m   -		The listbox in which to insert the entries
# id  -		The id of the struct to start with
proc VFolderBuildList {m id} {
    global b vFolderStruct vFolderDef vFolderCurrent
    upvar #0 $m current

    set win [winfo parent [winfo parent [winfo parent $m]]]
    upvar #0 $win type
    set tri "->"
    set num 0

    if ![info exists vFolderStruct($id)] {
	return
    }

    # Store the structure id associated with this listbox
    set current(sIdent) $id

    foreach elem $vFolderStruct($id) {
	if ![string compare [lindex $elem 0] struct] {
	    set nm [list [lindex $elem 2] $tri]
	    $m insert end $nm
	    set current($num) $elem
	} else {
	    set vfolder $vFolderDef([lindex $elem 1])
	    if {![string compare dynamic [lindex $vfolder 1]]} {
		set nm [list [lindex $elem 2] $tri]
		$m insert end $nm
		set current($num) $elem
	    } else {
		set nm [lindex $elem 2]
		$m insert end $nm
		set current($num) $vfolder
	    }
	}
	incr num
    }
    # do the bindings
    if [string compare $type(type) mboxview] {
	bind $m <3> "VFolderMakeMenu %X %Y %W $id \[%W index @%x,%y\]; break"
	set b($m) vd_list
    } else {
	bind $m <3> "MBVMakeMenu %X %Y %W $id \[%W index @%x,%y\]; break"
	set b($m) mbv_list
    }
}

# DynamBuildList --
#
# Constructs a list of dynamic folders. 
#
# Arguments:
# m   -		The listbox in which to insert the entries
# id  -		The id of the dynamic folder to expand
proc DynamBuildList {m id} {
    global vFolderDef
    upvar #0 $m current

    set num 0
    set vfolder $vFolderDef($id)
    set win [winfo parent [winfo parent [winfo parent $m]]]
    upvar #0 $win type

    # Store the structure id associated with this listbox
    set current(sIdent) $id

    foreach f [lsort [glob -nocomplain [lindex $vfolder 3]/*]] {
	if [file isfile $f] {
	    $m insert end [file tail $f]
	    set current($num) [list [file tail $f] file \
				   [lindex $vfolder 2] $f]
	    incr num
	}
    }
    if [string compare $type(type) mboxview] {
	bind $m <3> "VFolderMakeMenu %X %Y %W $id \[%W index @%x,%y\]; break"
	set b($m) vd_list
    } else {
	bind $m <3> "MBVMakeMenu %X %Y %W $id \[%W index @%x,%y\]; break"
    }
}

# VFActHeirList --
#
# Act upon an event in a hierarchical virtual folder listbox widget
#
# Arguments:
#
# handler - the handler for this listbox
# Type      - the type of hierarchy we're dealing with
proc VFActHierList {handler type} {
    global t vFolderCurrent option vFolderStruct vFolderDef \
	vFolderInbox vFolderSave vFolderChanged hierlb
    upvar #0 $type htype
    upvar #0 $handler current

    # figure out which item was selected
    set itemnum [$handler curselection]
    if ![catch {set itemname [$handler get $itemnum]}] {
	$handler activate $itemnum
	set vFolderCurrent [list $current(sIdent) $itemnum]
    } else {
	set itemname {}
	set vFolderCurrent [list $current(sIdent) 0]
    }
    set hierlb $handler

    # figure out which listbox we're in and set some vars
    set parent [winfo parent $handler]
    set ggparent [winfo parent [winfo parent $parent]]
    set lbnum [lindex [split $parent .] end]
    set leftstring [string trimright $parent $lbnum]
    set labelstring $ggparent.labbox.
    set nextlbnum [expr $lbnum + 1]
    set num_lbs $htype(num_lbs)
    set nextlbname $leftstring$nextlbnum
    set nextlblist $nextlbname.lb
    set nextlabel $labelstring$nextlbnum
    set czero [lindex $current($itemnum) 0]
    set cone [lindex $current($itemnum) 1]
    set struct 0
    set dynamic 0
    set term 0

    #determine what type of selection has been made
    # structure (struct), dynamic, or mailbox (term)
    catch {
	if ![string compare $czero struct] {
	    set struct 1
	} elseif ![catch {set temp [lindex $vFolderDef($cone) 1]}] {
	    if ![string compare $temp dynamic] {
		set dynamic 1
	    }
	} else {
	    set term 1
	}
    }

    if !$term {
	#clear out the listboxes to the right of this one
	for {set i [expr $lbnum+$num_lbs]} {$i > $lbnum } {incr i -1} {
	    catch {$leftstring$i.lb delete 0 end}
	    catch {$labelstring$i.text configure -text ""}
	}
	
	# Create a new listbox to the right, if needed,  
	# or pack an existing one
	if !$term {
	    if ![winfo exists $nextlblist] {
		pack propagate $ggparent.fLBs 0
		CreateHierLB $ggparent $nextlbnum $type
		CreateLabel $ggparent $nextlbnum $type
		pack propagate $ggparent 1
	    } else {
		pack $leftstring$nextlbnum \
		    -side left -fill both -padx 2 -pady 2 -expand yes
		pack $labelstring$nextlbnum \
		    -side left -fill x -padx 2 -pady 2 -expand yes
	    }

	    # make room to the left if we've gotten too wide
	    if { $nextlbnum >= $num_lbs } {
		pack forget $leftstring[expr $nextlbnum - $num_lbs] 
		pack forget $labelstring[expr $nextlbnum - $num_lbs]
	    }

	    # fill in next listbox to the right, if needed
	    if $struct {
		VFolderBuildList $nextlblist $cone
		bind $nextlblist <ButtonRelease-1> "VFActHierList %W  $type"
	    } elseif $dynamic {
		DynamBuildList $nextlblist $cone
		bind $nextlblist <ButtonRelease-1> "VFActHierList %W  $type"
	    }

	    # create text label for listbox
	    $nextlabel.text configure -text $itemname
	}
    }

    if [string compare $type mboxview] {
	#correct the path entry
	set htype(path_begin) {}
	if { $htype(path) } {
	    if { $lbnum > 0 } {
		for {set i 1 } { $i < $lbnum +1 } { incr i } {
		    set htype(path_begin) \
			$htype(path_begin)[$labelstring$i.text cget -text]
		    set htype(path_begin) $htype(path_begin)$htype(seperator)
		}
	    }
	}
    
	#add the item name to the path widget
	set htype(path_begin) $htype(path_begin)$itemname
	$ggparent.path_begin configure -text $htype(path_begin)
    }

    # if we've backed up more than one level, restore those listboxes
    # that we've blown away off the left
    if {[winfo exists $leftstring[expr $nextlbnum +1]] \
	    && [winfo ismapped $leftstring[expr $nextlbnum + 1]] \
	    && [winfo exists $leftstring[expr $nextlbnum +1 - $num_lbs]] \
	    && ![winfo ismapped $leftstring[expr $nextlbnum +1 - $num_lbs]]} {

	# freeze geometry of parent window
	pack propagate $ggparent 0

	# make space to the right
	catch {destroy $leftstring[expr $nextlbnum + 1]}
	catch {destroy $labelstring[expr $nextlbnum + 1]}

	# replace the listbox and label we knocked off the left
	pack $leftstring[expr $lbnum - 1] -before $leftstring$lbnum \
	    -side left -fill both -padx 2 -pady 2 -expand yes
	pack $labelstring[expr $lbnum - 1] -before $labelstring$lbnum \
	    -side left -fill x -padx 2 -pady 2 -expand yes

	# let the window resize
	pack propagate $ggparent.fLBs 1
    }

    if [string compare $type mboxview] {
	# set the button properties
	set but $ggparent.buttons
	if $term {
	    $but.open configure -state normal -command \
		"FolderWindowCreate [list $current($itemnum)]"
	    $but.transfer configure -state normal -command \
		"Transfer"
	    $but.new configure -state disabled
	    $but.delete configure -state normal
	    bind $handler <Double-1> "VFBindHack $handler"
	} elseif $dynamic {
	    $but.open configure -state disabled
	    $but.transfer configure -state normal -command "Transfer"
	    $but.new configure -state disabled
	    $but.delete configure -state normal
	    bind $handler <Double-1> ""
	} elseif $struct {
	    $but.open configure -state disabled
	    $but.transfer configure -state disabled -command ""
	    $but.new configure -state normal
	    $but.delete configure -state normal
	    bind $handler <Double-1> ""
	}
	if [string match S* [lindex $current($itemnum) 1]] {
	    $but.delete configure -state disabled
	}
    } else {
	if $term {
	    bind $handler <Double-1> "VFBindHack $handler"
	} else {
	    bind $handler <Double-1> ""
	}
    }
    #    $ggparent.hsb.sb set 1 $num_lbs 0 $htype(highlbnum)
}

# VFBindHack --
#
# A hack to get around bind's expansion of "%" characters
#
# Arguments:
# handler - the handler for the selected listbox
proc VFBindHack { handler } {
    global activeFolder folderWindowList
    upvar #0 $handler current

    if {![string length $activeFolder] || \
	    -1 == [lsearch -exact $folderWindowList $activeFolder]} {
	set activeFolder [FolderWindowInit]
    }

    # figure out which item was selected
    set itemnum [$handler curselection]
    set vfolder $current($itemnum)
    VFolderOpen $activeFolder $vfolder
    focus .$activeFolder
}

# Transfer --
#
# Transfer the selected message(s) to a different mailbox
#
# Arguments:
proc Transfer {{folder {}}} {
    global vFolderStruct vFolderDef activeFolder vFolderCurrent \
	folderWindowList t

    if {![llength $activeFolder] || \
	    -1 == [lsearch -exact $folderWindowList $activeFolder]} {
	RatDialog Error "No mailbox window is selected to transfer from." \
	    "" 0 $t(close)
	return
    }
    upvar #0 $activeFolder fh
    # Default to group, if any messages are flagged, else current
    if ![llength [$fh(folder_handler) flagged flagged]] {
	set a 0
	set which current
    } else {
	set a 1
	set which group
    }

    if ![llength $folder] {set folder $vFolderCurrent}
    # set the variables which we pass to the workhorse
    set msg [GetMsgSet $activeFolder $which]
    set str $vFolderStruct([lindex $folder 0])
    set vf [lindex $folder 1]
    set vfd [lindex $str $vf]
    set dest $vFolderDef([lindex $vfd 1])

    foreach handler $folderWindowList {
	upvar #0 $handler ffh
	if ![string compare $ffh(stream) [lindex $dest 3]] {
	    set open 1
	} else {
	    set open 0
	}
    }

    if {![string compare [lindex $dest 1] file] && $open} {
	RatDialog Error "Sorry, can't transfer messages into a file type mailbox which is open." "" 0 $t(close)
    } else {
	VFolderInsert $activeFolder $a $msg $dest
	focus .$activeFolder
    }
}

# VFolderMakeMenu:
#
# Make the menu for the given entry.
#
# Arguments:
# x, y   -	Position of pointer, this is where we will popup the menu
# listW  -	Name of the list widget the entry belongs to
# sIdent -	Identifier of the vFolderStruct the entry belongs to
# index  -	Index in the above mentioned vFolderStruct
proc VFolderMakeMenu {x y listW sIdent index} {
    global vFolderCurrent vFolderStruct vFolderInbox vFolderSave t hierlb \
	vFolderCut

    set w [winfo toplevel $listW]
    set hierlb $listW

    set vFolderCurrent [list $sIdent $index]
    if ![catch {set elem [lindex $vFolderStruct($sIdent) $index]}] {
	if ![llength $elem] {
	    $w.m entryconfigure 0 -state disabled
	    $w.m entryconfigure 1 -state disabled
	    $w.m entryconfigure 4 -state disabled
	} elseif [string match S* [lindex $elem 1]] {
	    foreach i {0 1 2 4 5} {
		$w.m entryconfigure $i -state disabled
	    }
	} else {
	    $w.m entryconfigure 0 -state normal
	    if ![string compare vfolder [lindex $elem 0]] {
		if [string compare $vFolderInbox [lindex $elem 1]] {
		    $w.m entryconfigure 1 -state normal
		    $w.m entryconfigure 4 -state normal
		} else {
		    $w.m entryconfigure 1 -state disabled
		    $w.m entryconfigure 4 -state disabled
		}
		if [string compare $vFolderSave [lindex $elem 1]] {
		    $w.m entryconfigure 5 \
			-label $t(set_to_save_outgoing) -state normal
		} else {
		    $w.m entryconfigure 5 \
			-label $t(unset_to_save_outgoing) -state normal
		}
	    } else {
		$w.m entryconfigure 5 \
		    -label $t(set_to_save_outgoing) -state disabled
	    }
	}
	if [string length $vFolderCut] {
	    $w.m entryconfigure 2 -state disabled
	    $w.m entryconfigure 3 -state normal
	} elseif [string match S* [lindex $elem 1]] {
	    $w.m entryconfigure 2 -state disabled
	    $w.m entryconfigure 3 -state disabled
	} else {
	    $w.m entryconfigure 2 -state normal
	    $w.m entryconfigure 3 -state disabled
	}
#	bind $w.m <Unmap> "$listW selection clear $index"
	tk_popup $w.m $x $y
    }
}

# MBVMakeMenu:
#
# Make the menu for the given entry in the MailboxView window.
#
# Arguments:
# x, y   -	Position of pointer, this is where we will popup the menu
# listW  -	Name of the list widget the entry belongs to
# sIdent -	Identifier of the vFolderStruct the entry belongs to
# index  -	Index in the above mentioned vFolderStruct
proc MBVMakeMenu {x y listW sIdent index} {
    global vFolderStruct vFolderDef t

    set w [winfo parent [winfo parent [winfo parent $listW]]]
#    set hierlb $listW

    set vFolderCurrent [list $sIdent $index]
    if ![catch {set elem [lindex $vFolderStruct($sIdent) $index]}] {
	if ![llength $elem] {
	    $w.m entryconfigure 0 -state disabled
	    $w.m entryconfigure 1 -state disabled
	} elseif ![string compare vfolder [lindex $elem 0]] {
	    set vFolder $vFolderDef([lindex $elem 1])
	    set type [lindex $vFolder 1]
	    switch $type {
		dynamic {
		    $w.m entryconfigure 0 -state disabled
		    $w.m entryconfigure 1 -state normal -command \
			"Transfer [list $vFolderCurrent]"
		}
		pop3 {
		    $w.m entryconfigure 0 -state normal -command \
			"FolderWindowCreate [list $vFolder]"
		    $w.m entryconfigure 1 -state disabled
		}
		default {
		    $w.m entryconfigure 0 -state normal -command \
			"FolderWindowCreate [list $vFolder]"
		    $w.m entryconfigure 1 -state normal -command \
			"Transfer [list $vFolderCurrent]"
		}
	    }
	} else {
	    $w.m entryconfigure 0 -state disabled
	    $w.m entryconfigure 1 -state disabled
	}
	bind $w.m <Unmap> "$listW selection clear $index"
	tk_popup $w.m $x $y
    }
}

# VFHierWindowDestroy --
#
# This procedure is called when the vfolder hier window is destroyed. It
# writes any changes to the vfolder structure to disk, if needed.
#
# Arguments:
# id  - the id for this window
proc VFHierWindowDestroy {id} {
    global vFolderChanged hiervfld vFolderCut t quiting ratPlace
    upvar $id handler

    if [llength $vFolderCut] {
	if [RatDialog ! $t(pending_cut) {} 1 $t(delete) $t(cancel)] {
	    return
	} 
    }
    set hiervfld 0
    if $vFolderChanged {
	VFolderWrite
    }
    RecordPos $id mailbox
    RecordSize $id mailbox
    destroy ${id}_icon
    destroy $id
    if !{$quiting} {
	ConfigMainMenu default
	if { [llength [winfo children .]] <=2 } {
	    Quit all
}
    }
}

# FolderWindow Create --
#
# This procedure is called to create a new folder window
#
# Arguments:
# folder - the folder to open
proc FolderWindowCreate {folder} {
    global folderWindowList

    foreach handler $folderWindowList {
	upvar #0 $handler fh
	if ![string compare $fh(stream) [lindex $folder 3]] {
	    if [winfo exists .$handler] {
		wm deiconify .$handler
		raise .$handler
		return $handler
	    }
	}
    }
    set handler [FolderWindowInit]
    VFolderOpen $handler $folder
    focus .$handler
}
