#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/editinp/editinp.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.13
 | File mod date:    1997.11.29 23:10:31
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  editinp
 |
 | Purpose:          Friendly input, with prompts & all
 `------------------------------------------------------------------------|#

;;
;;  a prompting input port.
;;  this is where the readline library gets plugged in
;;

(define-class <edit-input-port> (<input-port>)
  filler-proc
  primary-prompt
  secondary-prompt
  completions
  buffer
  buffer-index
  use-secondary?)

(define (fill-edit-input-port (self <edit-input-port>))
  ((filler-proc self) self))

(define (open-edit-port . opt)
  (if (null? opt)
      (open-edit-port-on (current-input-port) (current-output-port))
      (if (= (length opt) 2)
	  (open-edit-port-on (car opt) (cadr opt))
	  (error "open-edit-port: wrong num args (expected 0 or 2) got: ~s"
		 opt))))

(define (open-edit-port-on inp out)
  (make <edit-input-port>
	filler-proc: (if (and (readline-enabled?)
			      (eq? inp $standard-input-port)
			      (eq? out $standard-output-port))
			 (console-prompting-filler)
			 (basic-prompting-filler inp out))
	primary-prompt: "? "
	secondary-prompt: " "
	completions: '()
	buffer: ""
	buffer-index: 1
	use-secondary?: #f))

;;
;; cause some operations on non-edit ports to be ignored
;;

(define-method set-primary-prompt! ((self <input-port>) arg))
(define-method set-secondary-prompt! ((self <input-port>) arg))
(define-method set-completions! ((self <input-port>) arg))

;;

;;
;;  if this <edit-input-port> is attached to the "console" (stdin),
;;  then we can use our readline subsystem
;;

(define (console-prompting-filler)
  (lambda ((self <edit-input-port>))
    (let ((line (readline-read-line 
		 (completions self) 
		 (if (use-secondary? self)
		     (secondary-prompt self)
		     (primary-prompt self)))))
      (if line
	  (begin
	    (readline-add-to-history line)
	    (set-buffer! self line))
	  (begin
	    (set-buffer! self $eof-object)))
      (set-buffer-index! self 0))))

;;
;; if we're connected to some other port, then just do a basic
;; prompt/read thing

(define (basic-prompting-filler raw-input-port raw-output-port)
  (lambda ((self <edit-input-port>))
    (display (if (use-secondary? self)
		 (secondary-prompt self)
		 (primary-prompt self))
	     raw-output-port)
    (flush-output-port raw-output-port)
    (set-buffer! self (read-line raw-input-port))
    (set-buffer-index! self 0)))

(define-method input-port-read-char ((self <edit-input-port>))
  (let (((ix <fixnum>) (buffer-index self)))
    (if (eof-object? (buffer self))
	(begin
	  (set-buffer! self "")
	  (set-buffer-index! self 1)
	  $eof-object)
	(if (< ix (string-length (buffer self)))
	    (begin
	      (set-buffer-index! self (+ ix 1))
	      (string-ref (buffer self) ix))
	    (if (eq? ix (string-length (buffer self)))
		(begin
		  (set-buffer-index! self (+ ix 1))
		  #\newline)
		(begin
		  (fill-edit-input-port self)
		  (input-port-read-char self)))))))


(define-method input-port-peek-char ((self <edit-input-port>))
  (let (((ix <fixnum>) (buffer-index self)))
    (if (eof-object? (buffer self))
	$eof-object
	(if (< ix (string-length (buffer self)))
	    (string-ref (buffer self) ix)
	    (if (eq? ix (string-length (buffer self)))
		#\newline
		(begin
		  (fill-edit-input-port self)
		  (input-port-peek-char self)))))))

(define-method input-port-char-ready? ((self <edit-input-port>))
  (or (eof-object? (buffer self))
      (<= (buffer-index self) (string-length (buffer self)))))

;;

(define (scanner-for-edit-port port)
  (let ((meth (find-method input-port-scan-token (list port)))
	(p port) ;; copy of port for scanner->port to use
	(ss set-use-secondary?!))
    (lambda ()
      (if ss
	  (bind ((type val (meth p)))
	    (ss p #t)
	    (set! ss #f)
	    (values type val))
	  (meth p)))))

(define-method input-port-read ((self <edit-input-port>))
  (let ((result (read:parse-object (scanner-for-edit-port self))))
    (set-use-secondary?! self #f)
    result))
