#include "config.h"

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/stat.h>

#include "McApp.h"
#include "McGadget.h"
#include "McViewBitmap.h"
#include "McFileRequest.h"
#include "McInfoRequest.h"

#include "xg3.h"
#include "g3decode.h"
#include "filegui.h"
#include "confirm.h"
#include "files.h"
#include "bitmap.h"

/****************************************************************************/

Pixmap canvas = 0;
GC cgc0=0, cgc1=0;
int scale=1, cw, ch;
int lines;
int rot;

/****************************************************************************/

void g3_redraw(void) {
  XFillRectangle(app->display, canvas, cgc0, 0, 0, cw, ch);

  if (current_data && current_size)
    g3_decode(current_data, current_size);
}

/****************************************************************************/

void g3_new_canvas(int sc) {
  XGCValues values;

  if (canvas) XFreePixmap(app->display, canvas);

  if (sc>0) scale=sc;

  if (rot & 1) { /* Landscape */
    ch=G3_MAXCOLS * scale / 1000;
    cw=G3_MAXLINES * scale / 1000;
  } else { /* Portrait */
    cw=G3_MAXCOLS * scale / 1000;
    ch=G3_MAXLINES * scale / 1000;
  }

  canvas=XCreatePixmap(app->display, app->mainWindow, cw, ch, 1);

  if (!cgc0) {
    values.foreground=0; values.background=1;
    cgc0=XCreateGC(app->display, canvas, GCForeground|GCBackground, &values);
  }

  if (!cgc1) {
    values.foreground=1; values.background=0;
    cgc1=XCreateGC(app->display, canvas, GCForeground|GCBackground, &values);
  }

  McViewBitmapSetPixmap(viewgad, canvas, 1, cw, ch);

  g3_redraw();

  ChangeMessage(zoomgad, "%d.%01d%%", scale/10, scale%10);
}

/****************************************************************************/

void g3_clear(void) {
  XFillRectangle(app->display, canvas, cgc0, 0, 0, cw, ch);
}

/****************************************************************************/

void g3_draw(int ypos, int xpos, int len) {
  int x1, y1, x2, y2;

  len=len*scale/1000;
  xpos=xpos*scale/1000;
  ypos=ypos*scale/1000;

  switch(rot&3) {
  case 0:
    x1 = xpos; y1=ypos;
    x2 = xpos+len-1; y2=ypos;
    break;

  case 1:
    x1 = ypos; y1 = ch - xpos;
    x2 = ypos; y2 = ch - (xpos+len-1);
    break;

  case 2:
    x1 = cw-xpos;         y1=ch-ypos;
    x2 = cw-(xpos+len-1); y2=ch-ypos;
    break;

  case 3:
    x1 = cw-ypos; y1 = xpos;
    x2 = cw-ypos; y2 = (xpos+len-1);
    break;
  }

  XDrawLine(app->display, canvas, cgc1, x1, y1, x2, y2);
}

/****************************************************************************/

void g3_update(int l) {
  lines=l;
  McGadgetRedraw(viewgad);
}

/****************************************************************************/

void inout_proc(int dir) {
  if (dir<0) {
    if (scale<=100) {
      XBell(app->display, 0);
    } else {
      int sc=scale * 9 / 10;
      g3_new_canvas((sc<100) ? 100 : sc);
    }
  } else {
    if (scale>=1000) {
      XBell(app->display, 0);
    } else {
      int sc=scale * 11 / 10;
      g3_new_canvas((sc>1000) ? 1000 : sc);
    }
  }
}

/****************************************************************************/

void zoom_in_proc(struct McGadget *nonsense) {
  inout_proc(1);
}

void zoom_out_proc(struct McGadget *nonsense) {
  inout_proc(-1);
}

void zoom_proc(int zoom) {
  int sc, sc2;

  if (zoom==-1) {
    sc=viewgad->height * 1000 / lines;
    sc2=viewgad->width * 1000 / G3_MAXCOLS;
    if (sc2<sc) sc=sc2;
    g3_new_canvas(sc);
  } else {
    g3_new_canvas(zoom*10);
  }
}

/****************************************************************************/

extern void rot_left_proc(struct McGadget *nonsense) {
  rot = (rot+1) & 3;
  g3_new_canvas(-1);
}

extern void rot_right_proc(struct McGadget *nonsense) {
  rot = (rot-1) & 3;
  g3_new_canvas(-1);
}

/****************************************************************************/
