#
# Makefile for G0FRD CW tutor for UNIX flavours
#
# The following UNIX variants are available:
#
#   Linux: IBM PC Console running Linux.
#   SCO:   IBM PC Console running SCO OpenServer.
#   UW:    IBM PC Console running SCO UnixWare.
#

# select the C compiler
#CC	= gcc	- for Linux
#CC	= cc	- for SCO OpenServer
#CC	= cc	- for SCO UnixWare
CC	= cc

# C compiler flags necessary to compile the programs correctly
#CFLAGS	= -DLINUX	- for Linux
#CFLAGS	= -DSCO		- for SCO OpenServer (optional -bELF)
#CFLAGS	= -DUNIXWARE	- for SCO UnixWare
CFLAGS	= -DSCO -bELF

# information for the installation
BINDIR	= /usr/local/bin
MANDIR	= /usr/local/man/cat.LOCAL
OWNER	= root:root
XMODE	= 755
RMODE	= 644


# default make target
default:	bins install

# do everything
all:	bins install test1 test2

# build the tutor binaries
bins:	cw cwgen cwcp

cw:	cw.h cw.c
	$(CC) $(CFLAGS) -o cw cw.c
	strip cw

cwgen:	cwgen.c
	$(CC) $(CFLAGS) -o cwgen cwgen.c
	strip cwgen

cwcp:	cw.h cwcp.c
	$(CC) $(CFLAGS) -o cwcp cwcp.c -lcurses
	strip cwcp

# install the binaries and man pages
install: bins cw.1.cat cwgen.1.cat cwcp.1.cat
	cp cw $(BINDIR)
	chown $(OWNER) $(BINDIR)/cw
	chmod $(XMODE) $(BINDIR)/cw
	cp cwgen $(BINDIR)
	chown $(OWNER) $(BINDIR)/cwgen
	chmod $(XMODE) $(BINDIR)/cwgen
	cp cwcp $(BINDIR)
	chown $(OWNER) $(BINDIR)/cwcp
	chmod $(XMODE) $(BINDIR)/cwcp
	compress <cw.1.cat >$(MANDIR)/cw.LOCAL.Z
	chown $(OWNER) $(MANDIR)/cw.LOCAL.Z
	chmod $(RMODE) $(MANDIR)/cw.LOCAL.Z
	compress <cwgen.1 >$(MANDIR)/cwgen.LOCAL.Z
	chown $(OWNER) $(MANDIR)/cwgen.LOCAL.Z
	chmod $(RMODE) $(MANDIR)/cwgen.LOCAL.Z
	compress <cwcp.1 >$(MANDIR)/cwcp.LOCAL.Z
	chown $(OWNER) $(MANDIR)/cwcp.LOCAL.Z
	chmod $(RMODE) $(MANDIR)/cwcp.LOCAL.Z

# run tests on the binaries built
test1:	bins
	./cw -w25 <cwtest1.cw

test2:	bins
	./cw <cwtest2.cw

# uninstall the binaries and man pages
uninstall:
	-rm $(BINDIR)/cw $(BINDIR)/cwgen $(BINDIR)/cwcp
	-rm $(MANDIR)/cw.LOCAL.Z $(MANDIR)/cwgen.LOCAL.Z $(MANDIR)/cwcp.LOCAL.Z

# clear up for a rebuild
clean:
	-rm -f *.o cw cwgen cwcp

# completely remove
clobber: clean uninstall

