// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  OOMFSelect.C

  Stephane Rehel

  October 19 1997
*/

#include "OOMFSelect.h"

#include "tools/IntegerArray.h"

#include "oom/OOMModule.h"
#include "oom/OOMModes.h"
#include "oom/OOMCommand.h"
#include "oom/OOMCommands.h"

#include "oom/modes/OOMMSelect.h"

/////////////////////////////////////////////////////////////////////////////

OOMFSelect::OOMFSelect( MLModule* _module ):
  MLBaseFunction(_module)
{}

/////////////////////////////////////////////////////////////////////////////

OOMFSelect::~OOMFSelect()
{}

/////////////////////////////////////////////////////////////////////////////

IBOOL OOMFSelect::_call()
{
  module->enterMode(OOMModes::SELECT);

  OOMModule* oom= (OOMModule*) module;

  oom->pushMessage( "Select function" );

  while( ! exitFunction )
    {
    if( ! interfaceYield() )
      break;

    OOMMSelect* s= (OOMMSelect*) oom->getMode(OOMModes::SELECT);
    if( s == 0 )
      break;

    OOMCommand* cmd= new OOMCommand;
    cmd->type= OOMCommands::SELECT;
    cmd->indices= s->objects;

    oom->post(cmd);
    }

  oom->popMessage();

  module->leaveMode();

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////
