// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLFCameraZoom.C

  Stephane Rehel
  August 2 1997
*/

#include "MLFCameraZoom.h"

#include "model/ModelModule.h"
#include "model/ModelModes.h"

#include "model/modes/MLMCameraZoom.h"

/////////////////////////////////////////////////////////////////////////////

MLFCameraZoom::MLFCameraZoom( MLModule* _module ):
  MLBaseFunction(_module)
{}

/////////////////////////////////////////////////////////////////////////////

MLFCameraZoom::~MLFCameraZoom()
{}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLFCameraZoom::_call()
{
  module->enterMode(ModelModes::CAMERA_ZOOM);

  ModelModule* model= (ModelModule*) module;

  model->pushMessage( "Camera Zoom: L(Pan)  M(zoom)  R(zoom faster)" );

  while( ! exitFunction )
    {
    if( ! interfaceYield() )
      break;
    }

  model->popMessage();

  module->leaveMode();

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////
