// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MakeStaticText.C

  Stephane Rehel

  August 11 1997
*/

#include <stdio.h>
#include <string.h>

int main( int argc, char* argv[] )
{
  if( argc != 3 )
    {
    fprintf( stderr, "%s: Usage: %s README_file var_name\n",
             argv[0], argv[0] );
    return 1;
    }

  char* var_name= argv[2];

  FILE* file= fopen( argv[1], "r" );
  if( file == 0 )
    {
    fprintf( stderr, "%s: unable to open file '%s'\n", argv[0], argv[1] );
    return 1;
    }

  printf( "#include \"MLDWelcome.h\"\n" );
  printf( "const char* MLDWelcome::%s=\n", var_name );

  char line[1024];
  char line2[1024];
  while( fgets( line, 1024-1, file ) != 0 )
    {
    int len= strlen(line);
    while( len > 0 )
      {
      if( line[len-1] >= ' ' )
        break;
      line[len-1]= '\0';
      --len;
      }

    int j= 0;
    for( int i= 0; i < len; ++i )
      {
      register char ch= line[i];
      if( ch == '"' || ch == '\\' )
        line2[j++]= '\\';

      line2[j++]= ch;
      }

    line2[j]= '\0';

    printf( "\"%s\\n\"\n", line2 );
    }

  printf( ";\n" );

  return 0;
}
