// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   VArea.C

   Stephane Rehel
   August 6 1996
*/

#include "graphics/MLEvent.h"
#include "kw/kw.h"
#include "VArea.h"

/////////////////////////////////////////////////////////////////////////////

VArea::VArea( VWindow* _parent ): VWidget(_parent)
{}

/////////////////////////////////////////////////////////////////////////////

VArea::~VArea()
{}

/////////////////////////////////////////////////////////////////////////////

void VArea::create( int x, int y, int width, int height )
{
  VWindow::create( x, y, width, height );
}

/////////////////////////////////////////////////////////////////////////////

void VArea::drawWidget()
{
  kwCall(KWEvent::DRAW);
}

/////////////////////////////////////////////////////////////////////////////

IBOOL VArea::handleEvent( MLEvent& event )
{
  if( event.type == MLEvent::REDRAW )
    {
    kwCall(KWEvent::DRAW);
    return ITRUE;
    }

  return VWindow::handleEvent(event);
}

/////////////////////////////////////////////////////////////////////////////

