/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "lyrics.pas" */


#include "cfuncs.h"


#define LYRICS_G
#include "lyrics.h"


#ifndef STRINGS_H

#endif


#define MaxVerse        4

#define shift_left      '<'
#define shift_right     '>'
#define stay            '='
#define equal           '='

#define shifts          "<=>"
#define continue_       "---"

#define hyphen          '-'
#define underscore      '_'

#define crotchet        16

#define lskip           "\\<"
#define rskip           "\\>"


static char rtxmacro[MaxVerse][8] = {
  "\\rtx ", "\\Drtx ", "\\Trtx ", "\\Qrtx "
};

static boolean note_shifted;


static void get_lr(char *syllable, short *lr)
{
  char s;

  *lr = 0;
  while (pos1(syllable[0], shifts) > 0) {
    s = syllable[0];
    predelete(syllable, 1);
    if (s == shift_left)
      (*lr)--;
    else if (s == shift_right)
      (*lr)++;
  }
}


#define room            5


static boolean long_word(char *syllable, boolean is_short)
{
  boolean Result;

  static short tfml['z' + 1 - 'a'] = {
    2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2,
    2
  };

  static short tfmu['Z' + 1 - 'A'] = {
    3, 3, 3, 3, 3, 3, 3, 3, 1, 2, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3,
    3
  };

  short i, l;
  short m = 0;
  char s;

  l = strlen(syllable);
/* p2c: lyrics.pas: Note: Eliminated unused assignment statement [338] */
  if (l == 0 || !is_short)
    return false;
  s = syllable[0];
  if (!isalpha(s))
    return false;
  for (i = 0; i <= l - 1; i++) {
    s = syllable[i];
    if (islower(s))
      m += tfml[s - 'a'];
    else if (isupper(s))
      m += tfmu[s - 'A'];
  }
  return (m > room);
}

#undef room


/* Handle syllables with embedded tildes and equals*/
static void compensate(boolean is_short, char *syllable, char *line)
{
  short i, l, lr;
  short ntilde = 0;
  char STR2[256];

  l = strlen(syllable);
  get_lr(syllable, &lr);
  if (verbose > 1)
    printf("%s --> ", syllable);
  for (i = 0; i <= l - 1; i++) {
    if (syllable[i] == underscore)
      syllable[i] = blank;
  }
  i = 2;
  while (i < l) {
    if (syllable[i-1] != tilde)
      i++;
    else {
      ntilde++;
      i += 2;
    }
  }
  i = 2;
  while (i < l) {
    if (syllable[i-1] != equal)
      i++;
    else {
      syllable[i-1] = hyphen;
      ntilde++;
      i += 2;
    }
  }
  for (i = 1; i <= ntilde; i++)
    sprintf(line, "%c%c%s", tilde, blank, strcpy(STR2, line));
  if (ntilde > 0 || long_word(syllable, is_short))
    sprintf(syllable, "%s%s", lskip, strcpy(STR2, syllable));
  if (lr < 0) {
    for (i = 1; i <= -lr; i++)
      sprintf(syllable, "%s%s", lskip, strcpy(STR2, syllable));
  } else if (lr > 0) {
    for (i = 1; i <= lr; i++)
      sprintf(syllable, "%s%s", rskip, strcpy(STR2, syllable));
  }
  if (verbose <= 1)
    return;
  fputs(syllable, stdout);
  if (is_short)
    printf("   SHORT\n");
  else
    putchar('\n');
}


static char *xsyllable(char *Result, short voice, char *line, short notelen)
{
  char x[256];
  short new_adjust;
  boolean is_short;
  line_status *WITH;

  WITH = &current[voice-1];
  if (WITH->after_slur < 2 && WITH->after_beam < 2) {
    NextWord(x, line, blank, dummy);
    if (*x == '\0')
      return strcpy(Result, "");
    if (x[0] == atsign) {   /** ------- Contains a lyrics adjustment -- */
      predelete(x, 1);
      get_num(x, &new_adjust);
      WITH->adjust += new_adjust;
      GetNextWord(x, line, blank, dummy);
    }
    is_short = (WITH->after_slur == 0 && WITH->after_beam == 0 &&
		notelen <= short_note);
    GetNextWord(x, line, blank, hyphen);
    compensate(is_short, x, line);
    return strcpy(Result, x);
  } else if (WITH->after_beam == 2 ||
	     WITH->after_slur == 2 && notelen < crotchet)
    return strcpy(Result, "~");
  else if (WITH->after_beam > 2 && notelen < crotchet) {
    sprintf(Result, "%c", hyphen);
    return Result;
  } else if (WITH->after_slur == 0 && notelen < crotchet) {
    sprintf(Result, "%c", hyphen);
    return Result;
  } else
    return strcpy(Result, continue_);
}


static char *CommonLyrics(char *Result, short voice, short notelen)
{
  short i, verses;
  char outline[256], syllable[256], macro[256];
  line_info *WITH;
  char STR1[256];

  WITH = &info[voice-1];
  verses = WITH->nlyr;
  *outline = '\0';
  *macro = '\0';
  for (i = -1; i <= verses - 2; i++) {
    sprintf(syllable, "%s|",
	    xsyllable(STR1, voice, P[i - WITH->lyr], notelen));
    strcat(outline, syllable);
    strcpy(macro, rtxmacro[verses-1]);
  }
  outline[strlen(outline) - 1] = '*';
  strcat(outline, "\\");
  sprintf(Result, "%s%s", macro, outline);
  return Result;
}


boolean upper(short voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (WITH->voice_pos == 1 && voice < nvoices)
    return (WITH->voice_stave == info[voice].voice_stave);
  else
    return false;
}


static char *OwnLyrics(char *Result, short voice, short notelen)
{
  static short place[2] = {
    -8, 18
  };

  char syllable[256], macro[256];
  short height;
  line_info *WITH;
  char STR2[256];

  WITH = &info[voice-1];
  xsyllable(syllable, voice, P[WITH->lyr - 1], notelen);
  if (*syllable == '\0')
    return strcpy(Result, "");
  strcpy(macro, "\\zchar");
  /*---- If voice is the upper of two, put lyrics above stave, else below ----*/
  height = place[upper(voice)] + current[voice-1].adjust;
  sprintf(Result, "%s{%s}{%s}\\", macro, strnum(STR2, height), syllable);
  return Result;
}


static boolean alone(short voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (WITH->voice_pos == 1 && voice < nvoices)
    return (WITH->voice_stave != info[voice].voice_stave ||
	    info[voice].has_lyrics == none);
  else if (WITH->voice_pos == 2)
    return (WITH->voice_stave != info[voice-2].voice_stave ||
	    info[voice-2].has_lyrics == none);
  else
    return true;
}


typedef enum {
  nome, inhibit, slur, beam
} melismatype;


static melismatype melisma[maxvoices] = {
  nome, nome, nome, nome, nome, nome, nome, nome, nome, nome, nome, nome,
  nome, nome
};

static short melisma_level[maxvoices] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


#define shift           'r'


/* static variables for get_syllable: */
struct LOC_get_syllable {
  short voice;
  char pre[256], auxpre[256];
} ;

static void check_melisma(melismatype start, melismatype finish,
			 struct LOC_get_syllable *LINK)
{
  static char melisma_name[4][9] = {
    "nome", "inhibit", "slur", "beam"
  };

  char STR1[54];

  if (start == inhibit)
    return;
  if (start != finish) {
    sprintf(STR1, "Melisma starts with %s but ends with %s",
	    melisma_name[(long)start], melisma_name[(long)finish]);
    error3(LINK->voice, STR1);
  }
  strcpy(LINK->pre, "\\endmel");
  melisma[LINK->voice-1] = nome;
}

static void start_melisma(melismatype t, struct LOC_get_syllable *LINK)
{
  strcpy(LINK->auxpre, "\\lyr");
  if (melisma[LINK->voice-1] == nome) {
    strcpy(LINK->pre, "\\beginmel");
    melisma[LINK->voice-1] = t;
  }
}

static void end_melisma(melismatype t, struct LOC_get_syllable *LINK)
{
  line_status *WITH;

  WITH = &current[LINK->voice-1];
  if (t == slur && WITH->slurlevel == 1) {
    if (!WITH->no_slur_melisma[0])
      return;
  }
  check_melisma(melisma[LINK->voice-1], t, LINK);
}


void get_syllable(short voice_, char *note, char *pretex)
{
  struct LOC_get_syllable V;
  char s[256];
  short dur, k, l;
  line_info *WITH;
  line_status *WITH1;

  V.voice = voice_;
  if (musixlyr) {
    WITH = &info[V.voice-1];
    WITH1 = &current[V.voice-1];
    if (WITH->has_lyrics == none) {
      if (!alone(V.voice))
	strcat(pretex, "\\nolyr");
      return;
    }
    *V.pre = '\0';
    *V.auxpre = '\0';
    if (WITH1->after_slur == 1) {
      if (WITH1->no_slur_melisma[WITH1->slurlevel - 1])
	melisma[V.voice-1] = inhibit;
      else
	start_melisma(slur, &V);
    } else if (WITH1->after_beam == 1) {
      if (WITH1->no_beam_melisma)
	melisma[V.voice-1] = inhibit;
      else
	start_melisma(beam, &V);
    } else if (WITH1->last_under_slur)
      end_melisma(slur, &V);
    else if (WITH1->last_under_beam)
      end_melisma(beam, &V);
    else if (WITH1->after_slur > 0 || WITH1->after_beam > 0)
      strcpy(V.auxpre, "\\nolyr");
    if (WITH->has_lyrics == normal) {
      if (*V.pre != '\0')
	strcat(pretex, V.pre);
      return;
    }
    if (*V.pre != '\0') {
      sprintf(pretex + strlen(pretex), "\\auxlyr{%s%s}\\nolyr",
	      V.pre, V.auxpre);
      return;
    }
    if (*V.auxpre == '\0')
      strcat(pretex, "\\AL");
    else
      strcat(pretex, V.auxpre);
    return;
  }
  if (*note == '\0' || info[V.voice-1].nlyr == 0)
    return;
  dur = note_length(note, V.voice);
  if (dur == 0)
    return;
  note_shifted = false;
  l = strlen(note);
  for (k = 1; k <= l - 1; k++) {
    if (note[k] == shift)
      note_shifted = true;
  }
  if (info[V.voice-1].lyr < 0)
    CommonLyrics(s, V.voice, dur);
  else
    OwnLyrics(s, V.voice, dur);
  strcat(pretex, s);
}

#undef shift




/* End. */
