/* Header for module globals, generated by p2c 1.21alpha-07.Dec.93 */
#ifndef GLOBALS_H
#define GLOBALS_H


#ifdef GLOBALS_G
# define vextern
#else
# define vextern extern
#endif


/* Main global variables.  See also variables in other unit interfaces. */

/* Variables that control lyrics:
   musixlyr              = use musixlyr.tex
   line_status.adjust    = height adjustment (internotes)
   line_status.auxadjust = auxiliary height adjustment (internotes)
   line_info.has_lyrics  = type of musixlyr lyrics stream
   line_info.lyr         = lyrics starting on this line of paragraph
   line_info.nyr         = number of lyrics lines for this voice
*/


#define maxstaves       7
#define maxvoices       14
#define maxgroups       3
#define PMXlinelength   128

#define max_lyrics_line_length  (PMXlinelength - 4)

#define lines_in_paragraph  24

#define comment         '%'
#define blank           ' '
#define colon           ':'
#define tilde           '~'
#define atsign          '@'
#define dummy           '\0'


typedef char paragraph[lines_in_paragraph][256];
typedef short line_nos[lines_in_paragraph];
typedef enum {
  other, abcdefg, zword, lparen, rparen, rlparen, lbrac, rbrac, pmxl, mword,
  oword, rword, nextvoice, barword, texword, atword, FirstOnly, err
} music_word;


typedef enum {
  none, normal, auxiliary
} musixlyr_line;
typedef music_word word_scan[64];

typedef struct line_status {
  char duration, octave, lastnote;
  char slurtoggle[2];
  short pitch, after_beam, slurlevel, after_slur, adjust, auxadjust,
	octave_adjust;
  boolean beamnext, beamed, slurnext, slurred, last_under_slur,
	  last_under_beam, no_beam_melisma;
  boolean no_slur_melisma[2];
  char delay_slur[256];
} line_status;

typedef struct line_info {
  char line[256], uptext_font[256];
  boolean vocal;
  musixlyr_line has_lyrics;
  short mus, chord, uptext, lyr, nlyr, nbar, left, here, nword, voice_pos,
	voice_stave, uptext_adjust, uptext_lcz;
  short bar_bound[17];
  short word_bound[65];
  word_scan scan;
} line_info;


extern short verbose;
extern boolean ignore, dochords, dotext, dolyrics, musixlyr, split_dots,
	       set_names, unbeam_if_vocal, extended_dots;

extern boolean bind_left[18];

extern char name[18][9];

vextern char voice_label[maxvoices][256];
vextern char clef[maxstaves];
vextern line_info info[maxvoices];
vextern line_status current[maxvoices], cstat[maxvoices];
vextern short nvoices, bottom, top, one_beat, full_bar, line_no, exit_code,
	      nstaves, ninstr, short_note, meternum, meterdenom;
vextern double xmtrnum0;
vextern paragraph P;
vextern line_nos orig_line_no;
vextern FILE *infile, *outfile;
vextern char infile_NAME[_FNSIZE];
vextern char outfile_NAME[_FNSIZE];


extern void error(char *message);
extern void error3(short voice, char *message);
extern void fatalerror(char *message);
extern void warning(char *message);
extern char *GetNextWord(char *Result, char *s, char Delim, char Term);
extern char *NextWord(char *Result, char *s, char Delim, char Term);
extern short word_count(char *s);
extern char *plural(char *Result, short n);
extern short curtail(char *s, char c);
/* Remove last character if it equals c and return its position;
   otherwise return 0 */
extern char *strnum(char *Result, short n);
extern void stripblanks(char *s);
extern short digit(char c);
extern short instrument(short voice);
extern void onumber(char *s, short *j, short *n1);


#undef vextern

#endif /*GLOBALS_H*/

/* End. */
