# Conditional build (replace "#" with "%" to enable). Default is clamav.
# More than one engine can be specified in configure line below, like
# --with-av-engine="clamav,clamdscan"
#
#define _with_clamav            1 # use clamav
#define _with_clamdscan         1 # use clamdscan
#define _with_kav               1 # use kaspersky < 4.5
#define _with_aveserver         1 # use kaspersky >= 4.5
#define _with_trophie           1 # use trophie (TrendMicro)
#define _with_sophie            1 # use sophie (Sophos)
#define _with_icap              1 # use icap (experimental)

%define version 6.4.4.1
Summary: The DansGuardian Anti-Virus Plugin
Name: dansguardian-antivirus
Version: %{version}
Release: 1
License: GPL
Group: Applications/Daemon
URL: http://sourceforge.net/projects/dgav
Vendor: dgav
Packager: dgav-devel@lists.sourceforge.net
BuildRoot: /var/tmp/dansguardian-virus-%{version}-buildroot/
BuildRequires: gcc, make, patch, libesmtp-devel, clamav-devel
Requires: chkconfig, libesmtp, clamav
Obsoletes: DansGuardian, dansguardian, dansguardian-virus

%define DGVersion 2.8.0
%define DGRelease 6

Provides: dansguardian=%{DGVersion}.%{DGRelease}

Source0: dansguardian-%{DGVersion}.%{DGRelease}.source.tar.gz
Patch10: dansguardian-%{DGVersion}.%{DGRelease}-antivirus-%{version}.patch
Patch20: linux.in-rpmfixup.patch

%description
This is DansGuardian with Anti-Virus Plugin integrated into it.

%prep
%setup -q -n dansguardian-%{DGVersion}.%{DGRelease}

# apply the AntiVirus patch.
%patch10 -p1

# fixup the autoconf/linux.in file
cd autoconf
%patch20

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure \
	--sysconfdir=/etc/dansguardian/ \
	--sysvdir=/etc/rc.d/init.d/ \
	--cgidir=/var/www/cgi-bin/ \
%{?_with_clamav: --with-av-engine=clamav} \
%{?_with_clamdscan: --with-av-engine=clamdscan} \
%{?_with_kav: --with-av-engine=kav} \
%{?_with_aveserver: --with-av-engine=aveserver} \
%{?_with_trophie: --with-av-engine=trophie} \
%{?_with_sophie: --with-av-engine=sophie} \
%{?_with_icap: --with-av-engine=icap}

make

%clean
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
mkdir -p $RPM_BUILD_ROOT/var/log/dansguardian
make PREFIX=$RPM_BUILD_ROOT install

find $RPM_BUILD_ROOT/ -type f -print |
	sed "s@^$RPM_BUILD_ROOT@@g" |
        grep -v "\.conf" |
	grep -v "banned" |
	grep -v "exception" |
	grep -v "pics" |
	grep -v "template\.html" |
	grep -v "weightedphraselist" |
	grep -v "var\/log\/dansguardian" |
	grep -v "messages" |
	grep -v "contentregexplist" |
	grep -v "languages" |
        grep -v "phraselists" > dansguardian-virus-%{version}-filelist
if [ "$(cat dansguardian-virus-%{version}-filelist)X" = "X" ] ; then
    echo "ERROR: EMPTY FILE LIST"
    exit -1
fi

%pre

%post
chkconfig --add dansguardian
chkconfig --level 2345 dansguardian on
echo "After modifying /etc/dansguardian/dansguardian.conf"
echo "  run service dansguardian start"
echo "  to activate DansGuardian."

%preun
if [ $1 = 0 ]; then
  # we are being deleted, not upgraded
  service dansguardian stop >/dev/null 2>&1
  chkconfig dansguardian off
  chkconfig --del dansguardian
fi
exit 0

%postun
#if [ "$1" -ge "1" ]; then
#  # we are being upgrade/replaced, not deleted
#  service dansguardian restart >/dev/null 2>&1
#fi
exit 0

%files -f dansguardian-virus-%{version}-filelist
%defattr(-,root,root)
%doc README
%doc README.AV
%doc LICENSE
%doc INSTALL
%dir /etc/dansguardian
%config(noreplace) /etc/dansguardian/dansguardian.conf
#%config(noreplace) /etc/dansguardian/virusscanner.conf

%config(noreplace) /etc/dansguardian/bannedextensionlist
%config(noreplace) /etc/dansguardian/bannediplist
%config(noreplace) /etc/dansguardian/bannedmimetypelist
%config(noreplace) /etc/dansguardian/bannedphraselist
%config(noreplace) /etc/dansguardian/bannedregexpurllist
%config(noreplace) /etc/dansguardian/bannedsitelist
%config(noreplace) /etc/dansguardian/bannedurllist
%config(noreplace) /etc/dansguardian/banneduserlist

%config(noreplace) /etc/dansguardian/exceptioniplist
%config(noreplace) /etc/dansguardian/exceptionphraselist
%config(noreplace) /etc/dansguardian/exceptionsitelist
%config(noreplace) /etc/dansguardian/exceptionurllist
%config(noreplace) /etc/dansguardian/exceptionuserlist
%config(noreplace) /etc/dansguardian/exceptionvirusextensionlist
%config(noreplace) /etc/dansguardian/exceptionvirusmimetypelist
%config(noreplace) /etc/dansguardian/exceptionvirussitelist
%config(noreplace) /etc/dansguardian/exceptionvirusurllist
%config(noreplace) /etc/dansguardian/dlmgrextensionlist

%config(noreplace) /etc/dansguardian/dansguardianf1.conf
%config(noreplace) /etc/dansguardian/pics
%config(noreplace) /etc/dansguardian/weightedphraselist

%dir /etc/dansguardian/phraselists
%dir /etc/dansguardian/phraselists/badwords
%config(noreplace) /etc/dansguardian/phraselists/badwords/weighted_dutch
%config(noreplace) /etc/dansguardian/phraselists/badwords/weighted_french
%config(noreplace) /etc/dansguardian/phraselists/badwords/weighted_german
%config(noreplace) /etc/dansguardian/phraselists/badwords/weighted_portuguese
%config(noreplace) /etc/dansguardian/phraselists/badwords/weighted_spanish

%dir /etc/dansguardian/phraselists/chat
%config(noreplace) /etc/dansguardian/phraselists/chat/weighted
%config(noreplace) /etc/dansguardian/phraselists/chat/weighted_italian

%dir /etc/dansguardian/phraselists/drugadvocacy
%config(noreplace) /etc/dansguardian/phraselists/drugadvocacy/weighted

%dir /etc/dansguardian/phraselists/gambling
%config(noreplace) /etc/dansguardian/phraselists/gambling/banned
%config(noreplace) /etc/dansguardian/phraselists/gambling/banned_portuguese
%config(noreplace) /etc/dansguardian/phraselists/gambling/weighted
%config(noreplace) /etc/dansguardian/phraselists/gambling/weighted_portuguese

%dir /etc/dansguardian/phraselists/games
%config(noreplace) /etc/dansguardian/phraselists/games/weighted

%dir /etc/dansguardian/phraselists/goodphrases
%config(noreplace) /etc/dansguardian/phraselists/goodphrases/exception
%config(noreplace) /etc/dansguardian/phraselists/goodphrases/exception_email
%config(noreplace) /etc/dansguardian/phraselists/goodphrases/weighted_general
%config(noreplace) /etc/dansguardian/phraselists/goodphrases/weighted_general_danish
%config(noreplace) /etc/dansguardian/phraselists/goodphrases/weighted_general_portuguese
%config(noreplace) /etc/dansguardian/phraselists/goodphrases/weighted_news

%dir /etc/dansguardian/phraselists/googlesearches
%config(noreplace) /etc/dansguardian/phraselists/googlesearches/banned

%dir /etc/dansguardian/phraselists/gore
%config(noreplace) /etc/dansguardian/phraselists/gore/weighted
%config(noreplace) /etc/dansguardian/phraselists/gore/weighted_portuguese

%dir /etc/dansguardian/phraselists/illegaldrugs
%config(noreplace) /etc/dansguardian/phraselists/illegaldrugs/banned
%config(noreplace) /etc/dansguardian/phraselists/illegaldrugs/banned_portuguese
%config(noreplace) /etc/dansguardian/phraselists/illegaldrugs/weighted
%config(noreplace) /etc/dansguardian/phraselists/illegaldrugs/weighted_portuguese

%dir /etc/dansguardian/phraselists/intolerance
%config(noreplace) /etc/dansguardian/phraselists/intolerance/banned_portuguese
%config(noreplace) /etc/dansguardian/phraselists/intolerance/weighted
%config(noreplace) /etc/dansguardian/phraselists/intolerance/weighted_portuguese

%dir /etc/dansguardian/phraselists/legaldrugs
%config(noreplace) /etc/dansguardian/phraselists/legaldrugs/weighted

%dir /etc/dansguardian/phraselists/malware
%config(noreplace) /etc/dansguardian/phraselists/malware/weighted

%dir /etc/dansguardian/phraselists/news
%config(noreplace) /etc/dansguardian/phraselists/news/weighted

%dir /etc/dansguardian/phraselists/nudism
%config(noreplace) /etc/dansguardian/phraselists/nudism/weighted

%dir /etc/dansguardian/phraselists/peer2peer
%config(noreplace) /etc/dansguardian/phraselists/peer2peer/weighted

%dir /etc/dansguardian/phraselists/personals
%config(noreplace) /etc/dansguardian/phraselists/personals/weighted
%config(noreplace) /etc/dansguardian/phraselists/personals/weighted_portuguese

%dir /etc/dansguardian/phraselists/pornography
%config(noreplace) /etc/dansguardian/phraselists/pornography/banned
%config(noreplace) /etc/dansguardian/phraselists/pornography/banned_portuguese
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_danish
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_dutch
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_french
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_german
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_italian
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_portuguese
%config(noreplace) /etc/dansguardian/phraselists/pornography/weighted_spanish

%dir /etc/dansguardian/phraselists/proxies
%config(noreplace) /etc/dansguardian/phraselists/proxies/weighted

%dir /etc/dansguardian/phraselists/sport
%config(noreplace) /etc/dansguardian/phraselists/sport/weighted

%dir /etc/dansguardian/phraselists/violence
%config(noreplace) /etc/dansguardian/phraselists/violence/weighted
%config(noreplace) /etc/dansguardian/phraselists/violence/weighted_portuguese

%dir /etc/dansguardian/phraselists/warezhacking
%config(noreplace) /etc/dansguardian/phraselists/warezhacking/weighted

%dir /etc/dansguardian/phraselists/weapons
%config(noreplace) /etc/dansguardian/phraselists/weapons/weighted
%config(noreplace) /etc/dansguardian/phraselists/weapons/weighted_portuguese

%dir /etc/dansguardian/phraselists/webmail
%config(noreplace) /etc/dansguardian/phraselists/webmail/weighted

%config(noreplace) /etc/dansguardian/contentregexplist

/etc/dansguardian/languages/ReadMe

%dir /etc/dansguardian/languages/arspanish
%config(noreplace) /etc/dansguardian/languages/arspanish/messages
%config(noreplace) /etc/dansguardian/languages/arspanish/template.html

%dir /etc/dansguardian/languages/bulgarian
%config(noreplace) /etc/dansguardian/languages/bulgarian/messages
%config(noreplace) /etc/dansguardian/languages/bulgarian/template.html

%dir /etc/dansguardian/languages/chinesebig5
%config(noreplace) /etc/dansguardian/languages/chinesebig5/messages
%config(noreplace) /etc/dansguardian/languages/chinesebig5/template.html

%dir /etc/dansguardian/languages/chinesegb2312
%config(noreplace) /etc/dansguardian/languages/chinesegb2312/messages
%config(noreplace) /etc/dansguardian/languages/chinesegb2312/template.html

%dir /etc/dansguardian/languages/czech
%config(noreplace) /etc/dansguardian/languages/czech/messages
%config(noreplace) /etc/dansguardian/languages/czech/template.html

%dir /etc/dansguardian/languages/danish
%config(noreplace) /etc/dansguardian/languages/danish/messages
%config(noreplace) /etc/dansguardian/languages/danish/template.html

%dir /etc/dansguardian/languages/dutch
%config(noreplace) /etc/dansguardian/languages/dutch/messages
%config(noreplace) /etc/dansguardian/languages/dutch/template.html

%dir /etc/dansguardian/languages/french
%config(noreplace) /etc/dansguardian/languages/french/messages
%config(noreplace) /etc/dansguardian/languages/french/template.html

%dir /etc/dansguardian/languages/german
%config(noreplace) /etc/dansguardian/languages/german/messages
%config(noreplace) /etc/dansguardian/languages/german/template.html

%dir /etc/dansguardian/languages/hebrew
%config(noreplace) /etc/dansguardian/languages/hebrew/messages
%config(noreplace) /etc/dansguardian/languages/hebrew/template.html

%dir /etc/dansguardian/languages/indonesian
%config(noreplace) /etc/dansguardian/languages/indonesian/messages
%config(noreplace) /etc/dansguardian/languages/indonesian/template.html

%dir /etc/dansguardian/languages/italian
%config(noreplace) /etc/dansguardian/languages/italian/messages
%config(noreplace) /etc/dansguardian/languages/italian/template.html

%dir /etc/dansguardian/languages/lithuanian
%config(noreplace) /etc/dansguardian/languages/lithuanian/messages
%config(noreplace) /etc/dansguardian/languages/lithuanian/template.html

%dir /etc/dansguardian/languages/mxspanish
%config(noreplace) /etc/dansguardian/languages/mxspanish/messages
%config(noreplace) /etc/dansguardian/languages/mxspanish/template.html

%dir /etc/dansguardian/languages/polish
%config(noreplace) /etc/dansguardian/languages/polish/messages
%config(noreplace) /etc/dansguardian/languages/polish/template.html

%dir /etc/dansguardian/languages/portuguese
%config(noreplace) /etc/dansguardian/languages/portuguese/messages
%config(noreplace) /etc/dansguardian/languages/portuguese/template.html

%dir /etc/dansguardian/languages/russian-1251
%config(noreplace) /etc/dansguardian/languages/russian-1251/messages
%config(noreplace) /etc/dansguardian/languages/russian-1251/template.html

%dir /etc/dansguardian/languages/slovak
%config(noreplace) /etc/dansguardian/languages/slovak/messages
%config(noreplace) /etc/dansguardian/languages/slovak/template.html

%dir /etc/dansguardian/languages/spanish
%config(noreplace) /etc/dansguardian/languages/spanish/messages
%config(noreplace) /etc/dansguardian/languages/spanish/template.html

%dir /etc/dansguardian/languages/swedish
%config(noreplace) /etc/dansguardian/languages/swedish/messages
%config(noreplace) /etc/dansguardian/languages/swedish/template.html

%dir /etc/dansguardian/languages/turkish
%config(noreplace) /etc/dansguardian/languages/turkish/messages
%config(noreplace) /etc/dansguardian/languages/turkish/template.html

%dir /etc/dansguardian/languages/ukenglish
%config(noreplace) /etc/dansguardian/languages/ukenglish/messages
%config(noreplace) /etc/dansguardian/languages/ukenglish/template.html

%attr(755,nobody,nobody) %dir /var/log/dansguardian
