/*
 * Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it would be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Further, this software is distributed without any warranty that it is
 * free of the rightful claim of any third person regarding infringement
 * or the like.  Any license provided herein, whether implied or
 * otherwise, applies only to this software file.  Patent licenses, if
 * any, provided herein do not apply to combinations of this program with
 * other software, or any other product whatsoever.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * 
 * Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 * Mountain View, CA  94043, or:
 * 
 * http://www.sgi.com 
 * 
 * For further information regarding this notice, see: 
 * 
 * http://oss.sgi.com/projects/GenInfo/SGIGPLNoticeExplan/
 */
#ifndef TYPES_H
#define TYPES_H

#define XFSDUMP_DIRPATH	inv_basepath()

/*
 * Should be, but isn't, defined in uuid/uuid.h
 */
#define UUID_STR_LEN	36

/* fundamental page size - probably should not be hardwired, but
 * for now we will
 */
#define PGSZLOG2	12
#define PGSZ		( 1 << PGSZLOG2 )
#define PGMASK		( PGSZ - 1 )

/* integers
 */
typedef u_int32_t size32_t;
typedef u_int64_t size64_t;
typedef char char_t;
typedef unsigned char u_char_t;
typedef unsigned int u_intgen_t;
typedef long long_t;
typedef unsigned long u_long_t;
typedef size_t ix_t;
typedef int32_t time32_t;

/* limits
 */
#define	MKMAX( t, s )	( ( t )						\
			  ( ( ( 1ull					\
			        <<					\
			        ( ( unsigned long long )sizeof( t )	\
				  *					\
				  ( unsigned long long )NBBY		\
			          -					\
			          ( s + 1ull )))			\
			      -						\
			      1ull )					\
			    *						\
			    2ull					\
			    +						\
			    1ull ))
#define MKSMAX( t )	MKMAX( t, 1ull )
#define MKUMAX( t )	MKMAX( t, 0ull )
#define INT32MAX	MKSMAX( int32_t )
#define UINT32MAX	MKUMAX( u_int32_t )
#define SIZE32MAX	MKUMAX( size32_t )
#define INT64MAX	MKSMAX( int64_t )
#define UINT64MAX	MKUMAX( u_int64_t )
#define SIZE64MAX	MKUMAX( size64_t )
#define INO64MAX	MKUMAX( xfs_ino_t )
#define OFF64MAX	MKSMAX( off64_t )
#define INTGENMAX	MKSMAX( intgen_t )
#define UINTGENMAX	MKUMAX( u_intgen_t )
#define OFFMAX		MKSMAX( off_t )
#define SIZEMAX		MKUMAX( size_t )
#define IXMAX		MKUMAX( size_t )
#define INOMAX		MKUMAX( ino_t )
#define TIMEMAX		MKSMAX( time32_t )
#define INT16MAX	0x7fff
#define UINT16MAX	0xffff

/* boolean
 */
typedef int bool_t;
#define BOOL_TRUE	1
#define BOOL_FALSE	0
#define BOOL_UNKNOWN	( -1 )
#define BOOL_ERROR	( -2 )

/* useful return code scheme
 * NOTE: that there are macros and error messages in common/types.h that should
 * be updated when new error codes are added here.
 */
typedef enum { RV_OK,		/* mission accomplished */
	       RV_NOTOK,	/* media erase request denied */
	       RV_NOMORE,	/* no more work to do */
	       RV_EOD,		/* ran out of data */
	       RV_EOF,		/* hit end of media file */
	       RV_EOM,		/* hit end of media object */
	       RV_ERROR,	/* operator error or resource exhaustion */
	       RV_DONE,		/* return early because someone else did work */
	       RV_INTR,		/* cldmgr_stop_requested( ) */
	       RV_CORRUPT,	/* stopped because corrupt data encountered */
	       RV_QUIT,		/* stop using resource */
	       RV_DRIVE,	/* drive quit working */
	       RV_TIMEOUT,	/* operation timed out */
	       RV_MEDIA,	/* no media object in drive */
	       RV_PROTECTED,	/* want to write but write-protected */
	       RV_CORE,		/* really bad - dump core! */
	       RV_OPT,		/* bad command line option */
	       RV_INIT,		/* could not initialise subsystem */
	       RV_PERM,		/* insufficient privilege */
	       RV_COMPAT,	/* dump incompatible */
	       RV_INCOMPLETE,	/* some part of the dump is incomplete */
	       RV_KBD_INTR,	/* keyboard interrupt */
	       RV_INV,		/* session inventory error */
	       RV_USAGE,	/* print command usage only */
	       RV_EXISTS,	/* file or directory already exists */
	       RV_NONE,		/* no error code available */
	       RV_UNKNOWN,	/* there was an error but we don't know which one */
	       _RV_NUM		/* number of return codes */
} rv_t;

/* typedefs I'd like to see ...
 */
typedef struct getbmapx getbmapx_t;
typedef struct fsdmidata fsdmidata_t;

#endif /* TYPES_H */
