;;; skk-vip.el --- vip related functions for skk.el
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 1.1.4
;; Keywords: japanese
;; Last Modified: Sun Dec 15 08:39:13 1996

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;; Following people contributed to skk-vip.el (Alphabetical order):
;;      Kiyotaka Sakai <ksakai@netwk.ntt-at.co.jp>
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;      Murata Shuuichirou <mrt@mickey.ai.kyutech.ac.jp>
;;
;; *TO DO*
;; VIPER б

;;; Change log:
;; version 1.1.4 released 1996.12.15 (derived from the skk.el)

;;; Code:
(require 'skk)

;; (require 'vip) ٤vip 3.5 Ǥ (provide 'vip) Ƥʤ
(if (not (boundp 'vip-current-mode)) (load "vip"))

(defvar skk-vip-load-hook nil
  "*skk-vip.el ɤ줿˥뤵եå" )

;;; --- user variable.
(defvar skk-vip-mode-hook nil
  "*skk-use-vip non-nil ξǡskk-mode ưȤ˥뤵եå" )

(defun skk-ovwrt-len (len)
  ;; 񤭤ɤĹ֤ (<(skk.el/skk-ovwrt-len)>)
  (if (boundp 'vip-ovwrt-limit)
         ;; vip-ovwrt-limit  vip version 4 ǻѤƤưŪѿ
         ;; ǽǤСΤ褦ʥǥ󥰥򤱤٤
      (min (- vip-ovwrt-limit (point))
           (- (save-excursion (end-of-line) (point)) (point))
           len )
    (min (string-width
          (skk-buffer-substring (point) (save-excursion (end-of-line)(point))) )
         len )))

;; masahiko deletes the two functions below
;;;(defun vip-change-mode-to-emacs ()
;;;  "Change mode to emacs mode."
;;;  (interactive)
;;;  (vip-change-mode 'emacs-mode)
;;;  (setq skk-use-vip nil) )

;;;(defun vip-change-mode-to-vi ()
;;;  "Change mode to vi mode."
;;;  (interactive)
;;;  (vip-change-mode 'vi-mode)
;;;  (setq skk-use-vip t) )

(defun skk-vip-change-mode (new-mode)
  "NEW-MODE ˥⡼ɤѹ롣
NEW-MODE ͤϡemacs-modevi-mode ⤷ insert-mode Τ줫"
;;;  (if (skk-in-minibuffer-p)
;;;      (if skk-japanese-message-and-error
;;;          (error "ߥ˥Хåե VIP Υ⡼ɤѹ뤳ȤϤǤޤ")
;;;        (error "Cannot change mode in minibuffer!") ))
  (or (eq new-mode vip-current-mode)
      (progn
        (cond ((eq new-mode 'vi-mode)
               (if (eq vip-current-mode 'insert-mode)
                   (progn
                     (if (and skk-mode skk-j-mode) (skk-kakutei))
                     (vip-copy-region-as-kill (point) vip-insert-point)
                     (vip-repeat-insert-command))
                 (setq vip-emacs-local-map (current-local-map)
                       vip-emacs-mode-line-buffer-identification
                       mode-line-buffer-identification
                       vip-insert-local-map (vip-copy-keymap
                                             (current-local-map))))
               (vip-change-mode-line "Vi:   ")
               (if skk-mode (skk-change-mode-line skk-mode-string))
               (skk-use-local-map vip-mode-map))
              ((eq new-mode 'insert-mode)
               (move-marker vip-insert-point (point))
               (if (eq vip-current-mode 'emacs-mode)
                   (setq vip-emacs-local-map (current-local-map)
                         vip-emacs-mode-line-buffer-identification
                         mode-line-buffer-identification
                         vip-insert-local-map (vip-copy-keymap
                                               (current-local-map) )))
               (vip-change-mode-line "Insert")
               (if skk-mode
                   (if skk-j-mode
                       (progn (skk-change-mode-line (if skk-katakana 
                                                        skk-katakana-mode-string
                                                      skk-hirakana-mode-string ))
                              (skk-use-local-map skk-map) )
                     (if skk-zenkaku
                         (progn (skk-change-mode-line skk-zenei-mode-string)
                                (skk-use-local-map skk-zenkaku-map) )
                       (skk-change-mode-line skk-mode-string)
                       (skk-use-local-map vip-insert-local-map)
                       (local-set-key skk-kakutei-key 'skk-kakutei) ))
		 (skk-use-local-map vip-insert-local-map))
               (local-set-key "\e" 'vip-change-mode-to-vi)
               (local-set-key "\C-z" 'vip-ESC)
               (local-set-key "\C-h"
                              (if vip-help-in-insert-mode 'help-command
                                'skk-delete-backward-char))
               (local-set-key "\C-w"
                              'vip-delete-backward-word))
              ((eq new-mode 'emacs-mode) 
               (vip-change-mode-line "Emacs:")
               (if skk-mode (skk-change-mode-line skk-mode-string))
               (skk-use-local-map vip-emacs-local-map) ))
        (setq vip-current-mode new-mode)
        (if (featurep 'viper)
            (vip-refresh-mode-line)
          (set-buffer-modified-p (buffer-modified-p)) ))))

(defun skk-vip-mode ()
  ;; skk-mode Υ VIP ϢΥåȥåפԤ
  (if (and (skk-in-minibuffer-p) (boundp 'vip-current-mode))
      (add-hook
       'vip-read-string-hook
       (function
	(lambda ()
	  (define-key minibuffer-local-map skk-kakutei-key 'skk-kakutei)
	  (define-key minibuffer-local-map "\C-m" 'skk-newline) ))))
  (if (not skk-mode)
      (vip-change-mode-to-insert)
    (if (not skk-org-mode-line-format)
        ;; check vip's version.  this modification will not be
        ;; necessary for vip4.x.
        (if (string= (vip-version) "VIP version 3.5 of September 15, 1987")
            (progn
              (message "")
              (defalias 'vip-change-mode 'skk-vip-change-mode) )))
    (let (skk-mode) (vip-change-mode-to-insert))
    (if (or (not skk-org-mode-line-format) (skk-in-minibuffer-p))
        (run-hooks 'skk-vip-mode-hook) )))

(defun skk-delete-backward-char (count) ;(count &optional killp)
  "ߤΥݥȤä COUNT ʸõ롣"
  ;; <(skk.el/skk-delete-backward-char)>
  ;; Ƥޤȡ⡼ɤ BS 򲡤ȲΤꤹ뤳Ȥʤ֢פ
  ;; Ƥޤ
  ;;(interactive "*p\nP")
  (interactive "*P")
  ;;(if skk-okurigana
  ;;    (skk-delete-okuri-mark) )
  (if (and skk-henkan-on (>= skk-henkan-start-point (point)))
      (progn
        (setq skk-henkan-count 0)
        (skk-kakutei) )
    (if skk-henkan-active
        (if (and (not skk-delete-implies-kakutei)
                 (= skk-henkan-end-point (point)) )
            (skk-previous-candidate)
          (if skk-use-face (skk-henkan-face-off))
          ;; overwrite-mode ʸʸ˰Ϥޤ졢ľʸʸ
          ;; ǤݥȤ delete-backward-char ȤȡʸϾä
          ;; Ⱦʸʬ backward ˥ݥȤʤ (Emacs 19.31 
          ;; ˤƳǧ)ѴθФƤ delete-backward-char ɬ
          ;; ʸ 1 ʸʬ backward äɤ
          (if overwrite-mode
              (progn
                (backward-char (prefix-numeric-value count))
                (delete-char (prefix-numeric-value count)) )
            ;;(delete-backward-char count killp)
            (delete-backward-char (prefix-numeric-value count) count) )
          (if (>= skk-henkan-end-point (point)) (skk-kakutei)) )
      ;; θФФƤ delete-backward-char ɬʸ 1 ʸ
      ;; ʬ backward äɤ
      (if (and skk-henkan-on overwrite-mode)
          (progn
            (backward-char (prefix-numeric-value count))
            (delete-char (prefix-numeric-value count)) )
        (if (skk-in-minibuffer-p)
            (delete-backward-char (prefix-numeric-value count) count)
          ;; we should not emulate original map if skk-use-vip is t and
          ;; vip-current-mode's value is insert-mode
          (if (and skk-use-vip (eq vip-current-mode 'insert-mode))
              (delete-backward-char (prefix-numeric-value count) count)
            (skk-emulate-original-map count) ))))))

(defun skk-insert-str (str)
  ;; skk-insert Υ֥롼STR 롣ɬפǤ
  ;; self-insert-after-hook 򥳡뤹롣overwrite-mode ǤСŬڤ˾
  ;; Ԥ (<(skk.el/skk-insert-str)>)
  (skk-cancel-undo-boundary)
  (insert str)
  (if (and skk-henkan-on (not skk-henkan-active))
      (if (and skk-auto-start-henkan (not skk-okurigana))
          (skk-auto-start-henkan str) )
    (if (and (boundp 'self-insert-after-hook) self-insert-after-hook)
        (funcall self-insert-after-hook (- (point) (length str)) (point)))
    ;; (boundp 'vip-ovwrt-limit) means that this function is within the
    ;; dynamic scope of vip-overwrite-execute
    (if (or overwrite-mode (boundp 'vip-ovwrt-limit))
        (skk-del-char-with-pad (skk-ovwrt-len (string-width str))) )))

(defun skk-kakutei-cleanup-henkan-buffer ()
  ;; ľΥХåեԤʤ 
  ;; (<(skk.el/skk-kakutei-cleanup-henkan-buffer)>)
  (if skk-okurigana
      (progn
        (skk-delete-okuri-mark)
        (if (and skk-katakana skk-convert-okurigana-into-katakana)
            (skk-katakana-region skk-henkan-end-point (point)) )))
  (skk-delete-henkan-markers)
  (if (and (boundp 'self-insert-after-hook) self-insert-after-hook)
      (funcall self-insert-after-hook skk-henkan-start-point (point)) )
  (if (or overwrite-mode (boundp 'vip-ovwrt-limit))
      (skk-del-char-with-pad
       (skk-ovwrt-len
        (string-width
         (skk-buffer-substring skk-henkan-start-point (point)) )))))

;; SKK 10.x ˻ۤ
;;(if skk-emacs19
;;    (add-hook 'vip-load-hook
;;              (function
;;               (lambda ()
;;                 (require 'viper)
;;                 (setq skk-use-vip t)
;;                 (defadvice vip-intercept-ESC-key (before skk-add activate)
;;                   (if (and (boundp 'skk-mode) skk-henkan-on)
;;                       (skk-kakutei) )))))
;;  ;; (require 'vip) ٤vip 3.5 Ǥ (provide 'vip) Ƥʤ
;;  (if (not (boundp 'vip-current-mode)) (load "vip")) )

(run-hooks 'skk-vip-load-hook)

(provide 'skk-vip)
;; skk-vip.el ends here
