;; skk-gadget.el -- ¹ѴΤΥץ
;; Copyright (C) 1995, 1996,1997  Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 1.2.2
;; Keywords: japanese
;; Last Modified: Wed Nov 27 06:56:57 1996

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;; Following people contributed to skk-gadget.el (Alphabetical order):
;;      Kazuo Hirokawa <hirokawa@rics.co.jp>
;;      Kiyotaka Sakai <ksakai@netwk.ntt-at.co.jp>
;;      Koichi MORI <kmori@onsei2.rilp.m.u-tokyo.ac.jp>
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;
;; ץ¹ѴȤ
;; ======================
;;
;;
;; 겾̾ΤʤѴθ Emacs Lisp Υɤ񤤤Ƥ,
;; SKK ϤΥɤ Lisp ΥץȤƼ¹Ԥ, η̤ʸ
;; ̤. 㤨, 
;;
;;
;;         now /(current-time-string)/
;;
;; ȤԤȤ, `/now '٤ȥפв̤ˤϸߤλ郎
;; ɽ, ڢFri Apr 10 11:41:43 1992ۤΤ褦ˤʤ. Τ褦ʹܤ
;; Ͽ̾μϿˤԤȤǤ.
;;
;; ǻȤ Lisp ΥɤϲԤޤǤʤΤ˸¤. ޤ
;; ɤϷ̤Ȥʸ֤褦ʤΤǤʤФʤʤ
;;
;; Υեϼ¹Ѵץ򽸤᤿ΤǤ롣

;;; Change log:
;; version 1.2.2 released 1996.11.27 (derived from the skk.el 8.6)

;;; Code:
(require 'skk)
(require 'skk-num)
;; -- user variables

(skk-defvar skk-date-ad nil
  "*Non-nil ǤСskk-today, skk-clock ɽ롣
nil ǤСɽ롣" )

(skk-defvar skk-number-style 1
  "*nil ⤷ 0 ǤСskk-today, skk-clock οȾѤɽ롣
t ⤷ϡ1 ǤСɽ롣
t, 0, 1 ʳ non-nil ͤǤСɽ롣" )

(skk-defvar skk-gadget-load-hook nil
  "*skk-gadget.el ɤ˥뤵եå" )

;; --internal variables
(defconst skk-month-alist
  '(("Jan" . "1") ("Feb" . "2") ("Mar" . "3") ("Apr" . "4") ("May" . "5")
    ("Jun" . "6") ("Jul" . "7") ("Aug" . "8") ("Sep" . "9") ("Oct" . "10")
    ("Nov" . "11") ("Dec" . "12") )
  "̾Ϣۥꥹȡ\(Ѹɸʸ . ɽʸ\)" )

(defconst skk-week-alist
  '(("Sun" . "") ("Mon" . "") ("Tue" . "") ("Wed" . "") ("Thu" . "")
    ("Fri" . "") ("Sat" . "") )
  "̾Ϣۥꥹȡ\(Ѹɽʸ . ܸɽʸ\)" )

;; -- programs
(defun skk-date (&optional and-time)
  ;; ߤܸ֤skk-today  skk-clock Υ֥롼
  ;; ץʥ AND-TIME ꤹȡ֤֤
  (let* ((str (current-time-string))
         (year (if skk-date-ad
                   (skk-num (substring str 20 24))
                 (let ((y (- (string-to-int (substring str 20 24)) 1988)))
                   (if (eq y 1) "" (skk-num (int-to-string y))) )))
         (month (skk-num (cdr (assoc (substring str 4 7) skk-month-alist))))
         (day (skk-num (substring str 8 10)))
         (day-of-week (cdr (assoc (substring str 0 3) skk-week-alist)))
         hour minute second )
    (concat (if skk-date-ad "" "ʿ") year "ǯ"
            month "" day "" "\(" day-of-week "\)"
            (if and-time
                (progn
                  (setq hour (skk-num (substring str 11 13))
                        minute (skk-num (substring str 14 16))
                        second (skk-num (substring str 17 19)) )
                  (concat " " hour "" minute "ʬ" second "") )))))

(defun skk-today (&optional and-time)
  "󥿥饯ƥ֤˵ưȸߤܸɽǥݥȤ롣
ץʥ AND-TIME ꤹȡ˲ä֤롣
skk-date-ad  skk-number-style ˤäɽˡΥޥǽ"
  (interactive "*P")
  (insert (skk-date and-time)) )

(defun skk-clock (&optional kakutei-when-quit time-signal)
  "ǥפߥ˥Хåեɽ롣
quit ȤλȤ롣
quit Ȥ˵ưƤηв֤ߥ˥Хåեɽ롣
interactive ˵ư¾\"clock /(skk-clock)/\" ʤɤΥȥ SKK μ
˲ä\"/clock\"+ SPC Ѵ뤳ȤˤäƤⵯưġC-g ǻߤޤ롣
¹ѴǵưϡC-g λ롣
ץʥ KAKUTEI-WHEN-QUIT  non-nil Ǥ C-g Ȥ˳
ꤹ롣
ץʥ TIME-SIGNAL  non-nil ǤСNTT λ ding 롣
줾졢\"clock /(skk-clock nil t)/\" Τ褦ʥȥ򼭽ɤ
skk-date-ad  skk-number-style ˤäɽˡΥޥǽ"
  (interactive "*")
  (let ((start (current-time-string))
        ;; Hit any key ȤȤΤ꤯椫ʤ (;_;)...
        ;;(now-map (if skk-emacs19 
        ;;             '(keymap (t . keyboard-quit))
        ;;           (fillarray (make-keymap) 'keyboard-quit) ))
        (overriding-terminal-local-map
         (fillarray (setcar (cdr (make-keymap)) (make-vector 256 nil))
                    'keyboard-quit ))
        finish mes expr1 expr2 )
    (cond ((or (not skk-number-style)
               (eq skk-number-style 0) )
           (setq expr1 "[789]"
                 expr2 "0" ))
          ((or (eq skk-number-style t)
               ;; skk-number-style   t ʳ non-nil ͤƤ
               ;; 硢= Ȥ Wrong type argument: number-or-marker-p, xxxx
               ;; ˤʤäƤޤ
               (eq skk-number-style 1) )
           (setq expr1 "[]"
                 expr2 "" ))
          (t
           (setq expr1 "[Ȭ]"
                 expr2 "" )))
    (save-match-data
      ;;(skk-use-local-map now-map)
      ;; skk-keyboard-quit ǤϤʤʪ keyboard-quit Ƥ֤ᡣ
      ;;(skk-use-local-map skk-emacs-local-map)
      (condition-case nil
          (let (case-fold-search
                inhibit-quit
                minor-mode-map-alist
                ;; overriding-local-map
                overriding-terminal-local-map
                visible-bell )
            (while (not quit-flag)
              (setq mes (skk-date t))
              ;;(message (concat  mes "    Hit C-g quit"))
              (message (concat  mes "    Hit any key to quit"))
              (if time-signal
                  (if (string-match expr1 mes)
                      ;; [7890] Τ褦ɽȤ鷺7 ƤΥޥ
                      ;; 夤Ƥ椱ɤΤ...٤δؿ¹Ի Garbage
                      ;; collection ƤФƤɽ־礬롣
                      (ding)
                    (if (string-match expr2 mes)
                        ;; 0 ֥ݡפȤȤǤޥˤ
                        ;; ƺ롣
                        ;; 386SX 25Mhz + Mule-2.x ȡ֥ԥáԥáפȤ
                        ;; դƤ椯Τ˿ɤ68LC040 33Mhz + NEmacs 
                        ;; ֥ԥԥáפȤʤꡢΥߥ󥰤ɤΤȤ
                        ;; ɤ 1 ʬĤƤʤʤ롣Pentium 90Mhz +
                        ;; Mule-2.xȡ֥ԥáפȤñˤʤäƤޤ... (;_;)
                        (progn (ding)(ding)) )))
              (sit-for 1) ))
        (quit
         (prog2
             (setq finish (current-time-string))
             (skk-date t)
           ;;(skk-use-local-map skk-map)
           (if kakutei-when-quit
               (setq skk-kakutei-flag t) )
           (message (concat "в :" (skk-time-diff start finish))) ))))))

(defun skk-time-diff (start finish)
  ;; (current-time-string) ֤ START  FINISH λֺᡢ
  ;; ":ʬ:" η֤skk-clock Υ֥롼
  (let ((s-hour (string-to-int (substring start 11 13)))
        (s-minute (string-to-int (substring start 14 16)))
        (s-second (string-to-int (substring start 17 19)))
        (f-hour (string-to-int (substring finish 11 13)))
        (f-minute (string-to-int (substring finish 14 16)))
        (f-second (string-to-int (substring finish 17 19)))
        second-diff minute-diff hour-diff )
    (if (not (string= (substring start 20) (substring finish 20)))
        (skk-error "㤦ǯλֺϷ׻Ǥޤ"
                   "Year should be same" ))
    (setq second-diff (- f-second s-second))
    (if (> 0 second-diff)
        (setq f-minute (1- f-minute)
              second-diff (- (+ f-second 60) s-second) ))
    (setq minute-diff (- f-minute s-minute))
    (if (> 0 minute-diff)
        (setq f-hour (1- f-hour)
              minute-diff (- (+ f-minute 60) s-minute) ))
    (setq hour-diff (- f-hour s-hour))
    (if (> 0 hour-diff)
        (skk-error "裲裱λ֤ǤʤФʤޤ"
                   "2nd arg should be later than 1st arg" ))
    (format "%02d:%02d:%02d" hour-diff minute-diff second-diff) ))

(defun skk-num (str)
  ;;  skk-number-style ͤ˽Ѵ롣
  ;; skk-date Υ֥롼
  (mapconcat (function
	      (lambda (c)
		(cond ((or (not skk-number-style) (eq skk-number-style 0))
		       (char-to-string c) )
		      ((or (eq skk-number-style t) (eq skk-number-style 1))
		       (cdr (assq c skk-num-alist-type1)) )
		      (t (cdr (assq c skk-num-alist-type2))) )))
	     str "" ))

(defun skk-convert-ad-to-gengo (&optional fstr lstr)
  ;; 򸵹Ѵ롣ץ fstr ꤵƤСǯ
  ;; δ֤ˡlstr ꤵƤСˡ줾ʸϢ
  ;; 롣
  ;; 񸫽Ф;
  ;; 줭#ͤ /(skk-convert-ad-to-gengo nil "ǯ")/(skk-convert-ad-to-gengo " " " ǯ")/
  (let ((ad (string-to-int (car skk-num-list))))
    (concat (cond ((>= 1866 ad)
                   (skk-error "ʬޤ" "Unkown year") )
                  ((>= 1911 ad)
                   (concat "" fstr (int-to-string (- ad 1867))) )
                  ((>= 1925 ad)
                   (concat "" fstr (int-to-string (- ad 1911))) )
                  ((>= 1988 ad)
                   (concat "" fstr (int-to-string (- ad 1925))) )
                  (t (concat "ʿ" fstr (int-to-string (- ad 1988)))) )
            lstr )))

(defun skk-convert-gengo-to-ad (&optional string)
  ;; Ѵ롣ץ string ꤵƤС
  ;; ʸϢ뤹롣
  ;; 񸫽Ф;
  ;; 礦#ͤ /(skk-convert-gengo-to-ad "ǯ")/(skk-convert-gengo-to-ad " ǯ")/
  (save-match-data
    (let ((num (car skk-num-list))
          gengo )
      (string-match num skk-henkan-key)
      (setq gengo (substring skk-henkan-key 0 (match-beginning 0))
            num (string-to-int num) )
      (concat (int-to-string
               (+ num
                  (cond ((eq num 0)
                         (skk-error "0 ǯϤʤ"
                                    "Cannot convert 0 year" ))
                        ((string= gengo "ؤ") 1988)
                        ((string= gengo "礦")
                         (if (> 64 num)
                             1925
                           (skk-error "¤ 63 ǯޤǤǤ" 
                                      "The last year of Showa is 63" )))
                        ((string= gengo "礦")
                         (if (> 15 num)
                             1911
                           (skk-error "ϡ14 ǯޤǤǤ"
                                      "The last year of Taisyo is 14" )))
                        ((string= gengo "ᤤ")
                         (if (> 45 num)
                             1867
                           (skk-error "ϡ44 ǯޤǤǤ"
                                      "The last year of Meiji is 44" )))
                        (t (skk-error "ȽǽʸǤ"
                                      "Unknown Gengo!" )))))
              string ))))

;(defun skk-calc (operator)
;  ;; 2 Ĥΰä operator η׻򤹤롣
;  ;; : '/ ϰȤϤʤΤ (defalias 'div '/) ʤɤȤ̤η
;  ;; skk-calc Ϥ
;  ;; 񸫽Ф; #*# /(skk-calc '*)/
;  (int-to-string
;   (funcall operator (string-to-int (car skk-num-list))
;            (string-to-int (nth 1 skk-num-list)) )))

(defun skk-calc (operator)
  ;; 2 Ĥΰä operator η׻򤹤롣
  ;; : '/ ϰȤϤʤΤ (defalias 'div '/) ʤɤȤ̤η
  ;; skk-calc Ϥ
  ;; 񸫽Ф; #*# /(skk-calc '*)/
  (int-to-string (apply operator (mapcar 'string-to-int skk-num-list))) )

(defun skk-plus ()
  ;; 񸫽Ф; #+#+# /(skk-plus)/
  (int-to-string
   (apply '+ (mapcar 'string-to-int skk-num-list))))

(defun skk-minus ()
  (int-to-string
   (apply '- (mapcar 'string-to-int skk-num-list))))

(defun skk-times ()
  (int-to-string
   (apply '* (mapcar 'string-to-int skk-num-list))))

(defun skk-ignore-dic-word (&rest no-show-list)
  ;; ѼϿƤ롢äƤ/ʤѴФʤ褦ˤ
  ;; 롣
  ;; 񸫽Ф;
  ;;   뤹Ф /α/(skk-ignore-dic-word "α")/
  ;;   Ƥ /(skk-ignore-dic-word "")/
  (let (new-word save-okurigana)
    ;; skk-ignore-dic-word ȤΥȥää٤
    ;; skk-henkan-list ľФƤΤ delete ǤϤʤ delq ǽʬ
    (setq skk-henkan-list (delq (nth skk-henkan-count skk-henkan-list)
                                skk-henkan-list ))
    ;;  skk-henkan-list 롣
    (while skk-current-search-prog-list
      (setq skk-henkan-list (skk-nunion skk-henkan-list (skk-search))) )
    ;; פʸΤƤ롣
    (while no-show-list
      (setq skk-henkan-list (delete (car no-show-list) skk-henkan-list)
            no-show-list (cdr no-show-list) ))
    ;; Ȥθ (skk-ignore-dic-word ȤΥȥ) äΤǡ
    ;; skk-henkan-count ϼθؤƤ롣
    (setq new-word (or (nth skk-henkan-count skk-henkan-list)
                       (progn (setq save-okurigana skk-okuri-char)
                              (skk-henkan-in-minibuff) )))
    ;; 䤬ʤȤ
    (if (not new-word)
        ;; ʸϿ줿鼭Ͽξ֤᤹
        ;; (nth -1 '(A B C)) ϡA ֤Τǡn οǤʤȤå
        ;; Ƥɬפ롣
        (if (> skk-henkan-count 0)
            (setq skk-henkan-count (- skk-henkan-count 1)
                  new-word (nth skk-henkan-count skk-henkan-list) )
          ;; (1- skk-henkan-count) == -1 ˤʤ롣⡼ɤ᤹
          (setq new-word (if save-okurigana
                             (substring skk-henkan-key 0
                                        (1- (length skk-henkan-key)) )
                             skk-henkan-key )
                skk-henkan-count -1
                ;; ѿϡskk-henkan-in-minibuff Ĵ롣
                ;; skk-henkan-active nil
                ;; skk-okuri-char nil
                ;; skk-henkan-okurigana nil
                  )
          (if skk-use-face
              (add-hook 'skk-insert-new-word-hook
                        'skk-henkan-face-off-and-remove-itself ))))
    new-word ))

(defun skk-henkan-face-off-and-remove-itself ()
  ;; skk-insert-new-word-hook ˥åȤ뤿δؿȥХåե
  ;; Ѵʬ Overlay  face °ˤäɽѹƤΤᤷ
  ;; 弫ʬȤ skk-insert-new-word-hook ؿ
  (skk-henkan-face-off)
  (remove-hook 'skk-insert-new-word-hook
               'skk-henkan-face-off-and-remove-itself ))

(run-hooks 'skk-gadget-load-hook)

(provide 'skk-gadget)
;;; skk-gadget.el ends here
