/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSPluginArray.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "PluginArray.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSPluginArrayTableEntries[] =
{
    { "length", JSPluginArray::LengthAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSPluginArrayTable = 
{
    2, 1, JSPluginArrayTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSPluginArrayPrototypeTableEntries[] =
{
    { "refresh", JSPluginArray::RefreshFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSPluginArrayPrototypeTable = 
{
    2, 1, JSPluginArrayPrototypeTableEntries, 1
};

const ClassInfo JSPluginArrayPrototype::info = { "PluginArrayPrototype", 0, &JSPluginArrayPrototypeTable, 0 };

JSObject* JSPluginArrayPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSPluginArrayPrototype>(exec, "[[JSPluginArray.prototype]]");
}

bool JSPluginArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSPluginArrayPrototypeFunction, JSObject>(exec, &JSPluginArrayPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSPluginArray::info = { "PluginArray", 0, &JSPluginArrayTable, 0 };

JSPluginArray::JSPluginArray(ExecState* exec, PluginArray* impl)
    : m_impl(impl)
{
    setPrototype(JSPluginArrayPrototype::self(exec));
}

JSPluginArray::~JSPluginArray()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSPluginArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSPluginArrayTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSPluginArray>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<PluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<PluginArray*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return KJS::DOMObject::getOwnPropertySlot(exec, propertyName, slot);
}

JSValue* JSPluginArray::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        PluginArray* imp = static_cast<PluginArray*>(impl());

        return jsNumber(imp->length());
    }
    }
    return 0;
}

JSValue* JSPluginArrayPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSPluginArray::info))
      return throwError(exec, TypeError);

    PluginArray* imp = static_cast<PluginArray*>(static_cast<JSPluginArray*>(thisObj)->impl());

    switch (id) {
    case JSPluginArray::RefreshFuncNum: {
        bool reload = args[0]->toBoolean(exec);

        imp->refresh(reload);
        return jsUndefined();
    }
    }
    return 0;
}

JSValue* JSPluginArray::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSPluginArray* thisObj = static_cast<JSPluginArray*>(slot.slotBase());
    return toJS(exec, static_cast<PluginArray*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, PluginArray* obj)
{
    return KJS::cacheDOMObject<PluginArray, JSPluginArray>(exec, obj);
}
PluginArray* toPluginArray(KJS::JSValue* val)
{
    return val->isObject(&JSPluginArray::info) ? static_cast<JSPluginArray*>(val)->impl() : 0;
}

}
