<?php
	/**************************************************************************\
	* phpGroupWare - Todo list                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	*            Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/
	/* $Id: class.so.inc.php,v 1.1.2.1 2002/01/24 19:27:21 jengo Exp $ */

	class so
	{
		var $db;
		var $grants;
		var $historylog;

		function so()
		{
			global $phpgw, $phpgw_info;

			$this->db             = $phpgw->db;
			$this->db2            = $this->db;
			$this->grants         = $phpgw->acl->get_grants('todo');
			$this->owner          = $phpgw_info['user']['account_id'];
			$this->historylog     = CreateObject('phpgwapi.historylog','todo');

			// This is so our transactions follow across classes
			$this->historylog->db = $this->db;
		}

/*		function check_record_rights($todo_id, $required_rights)
		{
			global $phpgw_info;

			$this->db->query("select todo_owner from phpgw_todo where todo_id='$todo_id'");
			$this->db->next_record();

			// Make sure this user has access to this item
			if (! $this->check_perms($this->grants[$this->db->f('todo_owner')],$required_rights) && $this->db->f('todo_owner') != $phpgw_info['user']['account_id'])
			{
				return False;
			}
			else
			{
				return True;
			}
		} */

		function type($tree)
		{
			switch ($tree)
			{
				case 'mains':	$s = " and todo_id_parent = '0'"; break;
				case 'subs':	$s = " and todo_id_parent != '0'"; break;
				default: return False;
			}
			return $s;
		}

		function read_todos($start = 0, $limit = True, $query = '', $filter = '', $order = '', $sort = '', $cat_id = '', $tree = '', $parent = '')
		{
			global $phpgw;

			$type = $this->type($tree);

			if ($order)
			{
				$ordermethod = 'order by ' . $order . ' ' . $sort;
			}
			else
			{
				$ordermethod = 'order by todo_id_main, todo_id_parent, todo_level, todo_datecreated asc';
			}

			$filter = strtolower($filter);

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = "( todo_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (todo_access='public' AND todo_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " todo_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod =  " todo_owner='" . $this->owner . "' AND todo_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND todo_cat='$cat_id'";
			}

			if ($query)
			{
				$querymethod = " AND todo_des like '%$query%' OR todo_title like '%$query%'";
			}

			if ($parent)
			{
				$parentmethod = " AND todo_id_parent='$parent'";
			}

			$sql = "SELECT * FROM phpgw_todo WHERE $filtermethod $querymethod $type $parentmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();

			if ($limit)
			{
				$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);
			}
			else
			{
				$this->db->query($sql . $ordermethod,__LINE__,__FILE__);
			}

			while ($this->db->next_record())
			{
				$todos[] = array(
					'id'       => (int)$this->db->f('todo_id'),
					'main'     => (int)$this->db->f('todo_id_main'),
					'parent'   => (int)$this->db->f('todo_id_parent'),
					'level'    => (int)$this->db->f('todo_level'),
					'owner'    => $this->db->f('todo_owner'),
					'owner_id' => $this->db->f('todo_owner'),
					'access'   => $this->db->f('todo_access'),
					'cat'      => (int)$this->db->f('todo_cat'),
					'title'    => $this->db->f('todo_title'),
					'descr'    => $this->db->f('todo_des'),
					'pri'      => (int)$this->db->f('todo_pri'),
					'status'   => (int)$this->db->f('todo_status'),
					'sdate'    => $this->db->f('todo_startdate'),
					'edate'    => $this->db->f('todo_enddate'),
					'grants'   => (int)$this->grants[$this->db->f('todo_owner')],
					'sdate_epoch' => (int)$this->db->f('todo_startdate'),
					'edate_epoch' => (int)$this->db->f('todo_enddate')
				);
			}
			return $todos;
		}

		function read_single_todo($todo_id)
		{
			$this->db->query("select * from phpgw_todo where todo_id='$todo_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$todo['id']		= $this->db->f('todo_id');
				$todo['main']	= $this->db->f('todo_id_main');
				$todo['parent']	= $this->db->f('todo_id_parent');
				$todo['level']	= $this->db->f('todo_level');
				$todo['owner']	= $this->db->f('todo_owner');
				$todo['access']	= $this->db->f('todo_access');
				$todo['cat']	= $this->db->f('todo_cat');
				$todo['title']	= $this->db->f('todo_title');
				$todo['descr']	= $this->db->f('todo_des');
				$todo['pri']	= $this->db->f('todo_pri');
				$todo['status']	= $this->db->f('todo_status');
				$todo['sdate']	= $this->db->f('todo_startdate');
				$todo['edate']	= $this->db->f('todo_enddate');
			}
			return $todo;
		}

		function select_todo_list($selected = '')
		{
			global $phpgw;

			$todos = $this->read_todos($start, False, $query, $filter, $sort, $order, $cat_id, $tree);

			for ($i=0;$i<count($todos);$i++)
			{
				$todo_select .= '<option value="' . $todos[$i]['id'] . '"';
				if ($todos[$i]['id'] == $selected)
				{
					$todo_select .= ' selected';
				}
				if (! $todos[$i]['title'])
				{
					$words = split(' ',$phpgw->strip_html($todos[$i]['descr']));
					$title = "$words[0] $words[1] $words[2] $words[3] ...";
					$todo_select .= '>' . $title;				
				}
				else
				{
					$todo_select .= '>' . $phpgw->strip_html($todos[$i]['title']);
				}
				$todo_select .= '</option>';
			}
			return $todo_select;
		}

		function add_todo($values)
		{
			global $phpgw;
			ob_start();
			print_r($values);
			$contents = ob_get_contents();
			ob_end_clean();

			$phpgw->log->message(array(
				'text' => 'debug, so add_todo values: %1',
				'p1'   => $contents,
				'line' => __LINE__,
				'file' => __FILE__
			));
			$phpgw->log->commit();

			if ($values['parent'] && $values['parent'] != 0)
			{
				$values['main'] = $this->return_value($values['parent']);
				$values['level'] = $this->return_value($values['parent'],'level')+1;
			}

			$values['title'] = addslashes($values['title']);
			$values['descr'] = addslashes($values['descr']);

			$this->db->transaction_begin();
			$this->db->query("insert into phpgw_todo (todo_id_main,todo_id_parent,todo_level,todo_owner,todo_access,todo_cat,"
				. "todo_des,todo_title,todo_pri,todo_status,todo_datecreated,todo_startdate,todo_enddate) values ('" . $values['main'] . "','"
				. $values['parent'] . "','" . $values['level'] . "','" . $this->owner . "','" . $values['access'] . "','"
				. $values['cat'] . "','" . $values['descr'] . "','" . $values['title'] . "','" . $values['pri'] . "','"
				. $values['status'] . "','" . time() . "','" . $values['sdate'] . "','" . $values['edate'] . "')",__LINE__,__FILE__);
			$this->db->get_last_insert_id('phpgw_todo','todo_id');

			if (!$values['parent'] || $values[parent] == 0)
			{
				$this->db2->query("select max(todo_id) as max from phpgw_todo",__LINE__,__FILE__);
				$this->db2->next_record();

				$this->db->query("update phpgw_todo set todo_id_main='" . $this->db2->f('max') . "' "
								. "where todo_id='" . $this->db2->f('max') . "'",__LINE__,__FILE__);
			}

			$this->historylog->add('A',$todo_id,' ','');
			$this->db->transaction_commit();
		}

		function delete_todo($todo_id, $sub = False)
		{
			$this->db->transaction_begin();
			if ($sub)
			{
				$subdelete = " or todo_id_parent='$todo_id' or todo_id_main='$todo_id' ";
			}

			$this->db->query("delete from phpgw_todo where todo_id='$todo_id' $subdelete and ((todo_access='public' "
							. "and todo_owner != '" . $this->owner . "') or (todo_owner='" . $this->owner . "'))",__LINE__,__FILE__);
			$this->historylog->delete($todo_id);
			$this->db->transaction_commit();
		}

		function edit_todo($values)
		{
			if ($values['parent'] && $values['parent'] != 0)
			{
				$values['main'] = $this->return_value($values['parent']);
				$values['level'] = $this->return_value($values['parent'],'level')+1;
			}
			else
			{
				$values['main'] = $values['todo_id'];
				$values['level'] = 0;
			}

			if (! $values['cat'])
			{
				$values['cat'] = 0;
			}

			$old_values = $this->read_single_todo($values['id']);
			if (! $old_values['cat'])
			{
				$old_values['cat'] = 0;
			}

			$this->db->transaction_begin();

			if (($old_values['parent'] || $values['parent']) && ($old_values['parent'] != $values['parent']))
			{
				$this->historylog->add('P',$values['id'],$values['parent'], $old_values['parent']);
			}

			if (($old_values['sdate'] || $values['sdate']) && ($old_values['sdate'] != $values['sdate']))
			{
				$this->historylog->add('S',$values['id'],$values['sdate'], $old_values['sdate']);
			}

			if (($old_values['edate'] || $values['edate']) && ($old_values['edate'] != $values['edate']))
			{
				$this->historylog->add('E',$values['id'],$values['edate'], $old_values['edate']);
			}

			$this->historylog->add('T',$values['id'],$values['title'], $old_values['title']);
			$this->historylog->add('C',$values['id'],$values['cat'], $old_values['cat']);
			$this->historylog->add('D',$values['id'],$values['descr'], $old_values['descr']);
			$this->historylog->add('U',$values['id'],$values['pri'], $old_values['pri']);
			$this->historylog->add('s',$values['id'],$values['status'], $old_values['status']);
			$this->historylog->add('a',$values['id'],$values['access'], $old_values['access']);

			$values['title'] = addslashes($values['title']);
			$values['descr'] = addslashes($values['descr']);

			$this->db->query("update phpgw_todo set todo_des='". $values['descr'] . "', todo_id_parent='" . $values['parent']
				. "', todo_pri='" . $values['pri'] . "', todo_status='" . $values['status'] . "', todo_id_main='" . $values['main']
				. "', todo_access='" . $values['access'] . "', todo_level='" . $values['level']
				. "', todo_startdate='" . $values['sdate'] . "', todo_enddate='" . $values['edate'] . "', todo_title='" . $values['title']
				. "', todo_cat='" . $values['cat'] . "' where todo_id='" . $values['id']
				. "'",__LINE__,__FILE__);
			$this->db->transaction_commit();
		}

		function return_value($todo_id,$action = 'main')
		{
			switch($action)
			{
				case 'main':	$item = 'todo_id_main'; break;
				case 'level':	$item = 'todo_level'; break;
			}

			$this->db->query("select $item from phpgw_todo where todo_id='$todo_id'",__LINE__,__FILE__);
			if ($this->db->next_record())
			{
				return $this->db->f(0);
			}
		}

		function exists($todo_id)
		{
			$this->db->query("select count(*) from phpgw_todo where todo_id_parent = '$todo_id'",__LINE__,__FILE__);
			$this->db->next_record();

			if ($this->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}
	}
?>
