<?php
	/**************************************************************************\
	* phpGroupWare - Todo list                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	*            Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: class.bo.inc.php,v 1.1 2001/12/03 19:44:38 jengo Exp $ */

	class bo
	{
		var $start;
		var $query;
		var $filter;
		var $order;
		var $sort;
		var $cat_id;

		var $public_functions = array
		(
			'cached_accounts'  => True,
			'_list'            => True,
			'check_perms'      => True,
			'check_values'     => True,
			'select_todo_list' => True,
			'save'             => True,
			'_read'            => True,
			'delete'           => True,
			'exists'           => True,
			'list_methods'     => True
		);

		function bo($session=False)
		{
			global $phpgw;

			$this->sotodo = CreateObject('todo.so');

			if ($session)
			{
				$this->read_sessiondata();
				$this->use_session = True;
			}

			global $start, $query, $filter, $order, $sort, $cat_id;

			if(isset($start)) { $this->start = $start; }
			if(isset($query)) { $this->query = $query; }
			if(!empty($filter)) { $this->filter = $filter; }
			if(isset($sort)) { $this->sort = $sort; }
			if(isset($order)) { $this->order = $order; }
			if(isset($cat_id)) { $this->cat_id = $cat_id; }
		}

		function list_methods($_type)
		{
			if (is_array($_type))
			{
				$_type = $_type['type'];
			}

			switch($_type)
			{
				case 'xmlrpc':
					$xml_functions = array(
						'list_methods' => array(
							'function'  => 'list_methods',
							'signature' => array(array(xmlrpcStruct,xmlrpcString)),
							'docstring' => lang('Read this list of methods.')
						),
						'list' => array(
							'function'  => '_list',
							'signature' => array(array(xmlrpcStruct,xmlrpcStruct)),
							'docstring' => lang('Returns an array of todo items')
						),
						'save' => array(
							'function'  => 'save',
							'signature' => array(array(xmlrpcBoolean,xmlrpcStruct)),
							'docstring' => lang('Adds or edits a todo item')
						),
						'delete' => array(
							'function'  => 'delete',
							'signature' => array(array(xmlrpcBoolean,xmlrpcInt)),
							'docstring' => lang('Deletes a todo item')
						),
						'total_records' => array(
							'function'  => 'total_records',
							'signature' => array(array(xmlrpcInt)),
							'docstring' => lang('Returns a the total number of records in the database, must call list_todos first')
						)
					);
					return $xml_functions;
					break;

				case 'soap':
					return $this->soap_functions;
					break;

				default:
					return array();
					break;
			}
		}

		function get_grants()
		{
			return $this->so->grants;
		}

		function save_sessiondata($data)
		{
			global $phpgw;

			if ($this->use_session)
			{
				$phpgw->session->appsession('session_data','todo',$data);
			}
		}

		function read_sessiondata()
		{
			global $phpgw;

			$data = $phpgw->session->appsession('session_data','todo');

			$this->start	= $data['start'];
			$this->query	= $data['query'];
			$this->filter	= $data['filter'];
			$this->order	= $data['order'];
			$this->sort		= $data['sort'];
			$this->cat_id	= $data['cat_id'];
		}

/*		function check_record_rights($todo_id, $required_rights)
		{
			global $phpgw_info;

			$this->db->query("select todo_owner from phpgw_todo where todo_id='$todo_id'");
			$this->db->next_record();

			// Make sure this user has access to this item
			if (! $this->check_perms($this->grants[$this->db->f('todo_owner')],$required_rights) && $this->db->f('todo_owner') != $phpgw_info['user']['account_id'])
			{
				return False;
			}
			else
			{
				return True;
			}
		} */

		function check_perms($has, $needed)
		{
			return (!!($has & $needed) == True);
		}

		function cached_accounts($account_id)
		{
			global $phpgw;

			$this->accounts = CreateObject('phpgwapi.accounts',$account_id);
			$this->accounts->read_repository();

			$cached_data[$this->accounts->data['account_id']]['account_lid'] = $this->accounts->data['account_lid'];
			$cached_data[$this->accounts->data['account_id']]['firstname']   = $this->accounts->data['firstname'];
			$cached_data[$this->accounts->data['account_id']]['lastname']    = $this->accounts->data['lastname'];

			return $cached_data;
		}

		function _list($start = 0, $limit = '', $query = '', $filter = '', $order = '', $sort = '', $cat_id = 0, $tree = '', $parent = '')
		{
			if (is_array($start))
			{
				$params = $start;

				$start  = $params['start'];
				$limit  = $params['limit'];
				$query  = $params['query'];
				$filter = $params['filter'];
				$order  = $params['order'];
				$sort   = $params['sort'];
				$cat_id = $params['cat_id'];
				$tree   = $params['tree'];
				$parent = $params['parent'];
			}

			$todos = $this->sotodo->read_todos($start, $limit, $query, $filter, $order, $sort, $cat_id, $tree, $parent = '');
			$this->total_records = $this->sotodo->total_records;

			while (is_array($todos) && list(,$v) = each($todos))
			{
				$v['sdate'] = $GLOBALS['phpgw']->common->show_date($v['sdate'],$GLOBALS['phpgw_info']['user']['preferences']['common']['dateformat']);
	
				if ($v['edate'])
				{
					$v['edate'] = $GLOBALS['phpgw']->common->show_date($v['edate'],$GLOBALS['phpgw_info']['user']['preferences']['common']['dateformat']);
				}
				else
				{
					$v['edate'] = '';
				}

				$cached_data = $this->cached_accounts($v['owner']);

				$v['owner']  = $GLOBALS['phpgw']->common->display_fullname($cached_data[$v['owner']]['account_lid'],
										$cached_data[$v['owner']]['firstname'],$cached_data[$v['owner']]['lastname']);

				$r[] = array(
					'id'       => (int)$v['id'],
					'main'     => (int)$v['main'],
					'parent'   => (int)$v['parent'],
					'level'    => (int)$v['level'],
					'owner'    => $v['owner'],
					'owner_id' => (int)$v['owner_id'],
					'access'   => $v['access'],
					'cat'      => (int)$v['cat'],
					'title'    => $v['title'],
					'descr'    => $v['descr'],
					'pri'      => (int)$v['pri'],
					'status'   => (int)$v['status'],
					'sdate'    => $v['sdate'],
					'edate'    => $v['edate'],
					'grants'   => (int)$v['grants'],
					'sdate_epoch' => (int)$v['sdate_epoch'],
					'edate_epoch' => (int)$v['edate_epoch']
				);
			}

			return $r;
		}

		function read($todo_id)
		{
			$todo = $this->sotodo->read_single_todo($todo_id);

			return $todo;
		}

		function check_values($values)
		{
			global $phpgw;

			if (!$values['title'])
			{
				$error[] = lang('Please enter a title');
			}

			if (strlen($values['descr']) >= 8000)
			{
				$error[] = lang('Description can not exceed 8000 characters in length');
			}

			if ($values['daysfromstart'] && ! ereg('^[0-9]+$',$values[daysfromstart]))
			{
				$error[] = lang('You can only enter numbers for days from now');
			}

			if ($values['smonth'] || $values['sday'] || $values['syear'])
			{
					if (! checkdate($values['smonth'],$values['sday'],$values['syear']))
					{
						$error[] = lang('You have entered an starting invalid date');
					}
			}

			if ($values['emonth'] || $values['eday'] || $values['eyear'])
			{
				if (! checkdate($values['emonth'],$values['eday'],$values['eyear']))
				{
					$error[] = lang('You have entered an ending invalid date');
				}
			}

/*			if ($values['edate'] < $values['sdate'] && $values['edate'] && $values['sdate'])
			{
				$error[] = lang('Ending date can not be before start date');
			} */

			if (is_array($error))
			{
				return $error;
			}
		}

		function save($values)
		{
			if ($values['access'])
			{
				$values['access'] = 'private';
			}
			else
			{
				$values['access'] = 'public';
			}

			if ($values['seltoday'])
			{
				$values['sdate'] = time();
			}
			else
			{
				if ($values['smonth'] || $values['sday'] || $values['syear'])
				{
					$values['sdate'] = mktime(0,0,0,$values['smonth'], $values['sday'], $values['syear']);
				}
			}

            if (!$values['sdate'])
            {
                $values['sdate'] = time();
            }

			if ($values['emonth'] || $values['eday'] || $values['eyear'])
			{
				$values['edate'] = mktime(2,0,0,$values['emonth'],$values['eday'],$values['eyear']);
			}
			else if ($values['daysfromstart'] > 0)
			{
				$values['edate'] = mktime(0,0,0,date('m',$values['sdate']), date('d',$values['sdate'])+$values['daysfromstart'], date('Y',$values['sdate']));
			}

			if ($values['id'])
			{
				if ($values['id'] != 0)
				{
					$this->sotodo->edit_todo($values);
				}
			}
			else
			{
				$this->sotodo->add_todo($values);
			}
			return True;
		}

		function select_todo_list($parent)
		{
			$list = $this->sotodo->select_todo_list($parent);

			return $list;
		}

		function exists($todo_id)
		{
			$exists = $this->sotodo->exists($todo_id);

			if ($exists)
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function delete($todo_id, $subs = False)
		{
			if (is_array($todo_id))
			{
				$todo_id = $todo_id[0];
			}

			if ($subs)
			{
				$this->sotodo->delete_todo($todo_id,True);
			}
			else
			{
				$this->sotodo->delete_todo($todo_id);
			}
			return True;
		}
	}
?>