<?php
  /**************************************************************************\
  * phpgwTimeTrack - Setup                                                   *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: mysql_fixcontacts.inc.php,v 1.2 2001/05/24 19:32:10 rschader Exp $ */
echo "Renaming phpgw_addressbook table to 'phpgw_addressbook_bad'...<br>";
$phpgw->db->query("ALTER TABLE phpgw_addressbook rename AS phpgw_phpgw_addressbook_bad");
echo "Creating new phpgw_addressbook table...<br>";
$sql = "CREATE TABLE phpgw_addressbook (
     id    int(8) NOT NULL auto_increment,
     lid   varchar(32),
     tid   char(1),
     owner int(8),
     access   char(7),
     cat_id   varchar(32),
     fn       varchar(64),
     n_family varchar(64),
     n_given  varchar(64),
     n_middle varchar(64),
     n_prefix varchar(64),
     n_suffix varchar(64),
     sound    varchar(64),
     bday     varchar(32),
     note     text,
     tz       varchar(8),
     geo      varchar(32),
     url      varchar(128),
     pubkey   text,

     org_name varchar(64),
     org_unit varchar(64),
     title    varchar(64),

     adr_one_street      varchar(64),
     adr_one_locality    varchar(64),
     adr_one_region      varchar(64),
     adr_one_postalcode  varchar(64),
     adr_one_countryname varchar(64),
     adr_one_type        varchar(32),
     label text,

     adr_two_street      varchar(64),
     adr_two_locality    varchar(64),
     adr_two_region      varchar(64),
     adr_two_postalcode  varchar(64),
     adr_two_countryname varchar(64),
     adr_two_type        varchar(32),

     tel_work   varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_home   varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_voice  varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_fax    varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_msg    varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_cell   varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_pager  varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_bbs    varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_modem  varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_car    varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_isdn   varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_video  varchar(40) DEFAULT '+1 (000) 000-0000' NOT NULL,
     tel_prefer varchar(32),

     email varchar(64),
     email_type varchar(32) DEFAULT 'INTERNET' NOT NULL,
     email_home varchar(64),
     email_home_type varchar(32) DEFAULT 'INTERNET' NOT NULL,
     PRIMARY KEY (id),
     UNIQUE id (id)
)";

$phpgw->db->query($sql);

$phpgw->db->query("select * from addressbook");
echo "Transferring " . $phpgw->db->num_rows() . " records to new addressbook...<br>";
$i=0;
while ($phpgw->db->next_record()) {
	$id[$i] 	= $phpgw->db->f("ab_id");
	//$owner[$i] 	= $phpgw->accounts->name2id($phpgw->db->f("ab_owner"));
	$owner[$i]	= $phpgw->db->f("ab_owner");
	$access[$i] 	= addslashes($phpgw->db->f("ab_access"));
	$n_given[$i] 	= addslashes($phpgw->db->f("ab_firstname"));
	$n_family[$i] 	= addslashes($phpgw->db->f("ab_lastname"));
	$fn[$i] 	= $n_given[$i] . " " . $n_family[$i];
	$email[$i] 	= addslashes($phpgw->db->f("ab_email"));
	$tel_home[$i] 	= addslashes($phpgw->db->f("ab_hphone"));
	$tel_work[$i] 	= addslashes($phpgw->db->f("ab_wphone"));
	$tel_fax[$i] 	= addslashes($phpgw->db->f("ab_fax"));
	$tel_pager[$i] 	= addslashes($phpgw->db->f("ab_pager"));
	$tel_cell[$i] 	= addslashes($phpgw->db->f("ab_mphone"));
	$tel_voice[$i] 	= addslashes($phpgw->db->f("ab_ophone"));
	$adr_one_street[$i] 	= addslashes($phpgw->db->f("ab_street"));
	$adr_one_locality[$i] 	= addslashes($phpgw->db->f("ab_city"));
	$adr_one_region[$i] 	= addslashes($phpgw->db->f("ab_state"));
	$adr_one_postalcode[$i] = addslashes($phpgw->db->f("ab_zip"));
	$bday[$i] 	= addslashes($phpgw->db->f("ab_bday"));
	$note[$i] 	= addslashes($phpgw->db->f("ab_notes"));
	$company[$i] 	= addslashes($phpgw->db->f("ab_company"));
	$company_id[$i] = $phpgw->db->f("ab_company_id");
	$title[$i] 	= addslashes($phpgw->db->f("ab_title"));
	// Put the next one into the extras table?
	$address2[$i] 	= addslashes($phpgw->db->f("ab_address2"));
	$url[$i] 	= addslashes($phpgw->db->f("ab_url"));
	// Can't do any other queries until we've read everything in, so
	$i++;
}

for($t=0; $t < $i; $t++) {
	if($company_id[$t] > 0) {
		$phpgw->db->query("SELECT company_name from phpgw_ttrack_customers "
		  . "WHERE company_id=$company_id[$t]");
		$phpgw->db->next_record();
		$org_name[$t] = $phpgw->db->f("company_name");
	} else {
		$org_name[$t] = $company[$t];
	}
	$phpgw->db->query("INSERT into phpgw_addressbook "
	  . "(id,tid,owner,access,fn,n_given,n_family,email,tel_home,tel_work,"
	  . "tel_fax,tel_pager,tel_cell,tel_voice,adr_one_street,adr_one_locality,"
	  . "adr_one_region,adr_one_postalcode,bday,note,org_name,title,url) "
	  . "VALUES ($id[$t],'n','$owner[$t]','$access[$t]','$fn[$t]','$n_given[$t]',"
	  . "'$n_family[$t]','$email[$t]','$tel_home[$t]','$tel_work[$t]',"
	  . "'$tel_fax[$t]','$tel_pager[$t]','$tel_cell[$t]','$tel_voice[$t]',"
	  . "'$adr_one_street[$t]','$adr_one_locality[$t]','$adr_one_region[$t]',"
	  . "'$adr_one_postalcode[$t]','$bday[$t]','$note[$t]',"
	  . "'$org_name[$t]','$title[$t]','$url[$t]')");
}
?>
