<?php
  /**************************************************************************\
  * phpGroupWare                                                             *
  * http://www.phpgroupware.org/                                             *
  * This file written by Patrick Walsh <patrick@phpgroupware.org>            *
  * ------------------------------------------------------------------------ *
  * Please see the documentation for these classes in the README file in     *
  * this directory.                                                          *
  * ------------------------------------------------------------------------ *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: class.cdb_generic.inc.php,v 1.1 2001/11/11 15:43:42 milosch Exp $ */

	/* This class is extended by all cdb classes */
	class cdb_generic
	{
		var $_ = array();
		var $_dirty = array();
		var $_id = 0;
		var $grants = '';

		function cdb_generic()
		{
			$this->grants = $GLOBALS['phpgw']->acl->get_grants('cdb');
		}

		function let($var, $val)
		{
			if ($this->get($var) != $val)
			{
				/* new value, so make it dirty */
				$this->_dirty[$var] = 1;
				$this->_[$var] = $val;

				return True; /* signal that a change was made */
			}
			return False; /* signal that no change was made */
		}

		function get($var)
		{
			return $this->_[$var];
		}

		function dirty($dirty_prop)
		{
			$this->_dirty[$dirty_prop] = 1;
		}

		function id()
		{
			return $this->_id;
		}

		function exists($id)
		{
			$id = intval($id);
			$query = "SELECT (contact_id) FROM phpgw_cdb_contact_main WHERE contact_id=$id");
			$this->db->query($query,__LINE__,__FILE__);
			if($this->db->next_record())
			{
				return True;
			}
			return False;
		}

		function can_read($id)
		{
			if($this->grants & PHPGW_ACL_READ)
			{
				return True;
			}
			return False;
		}

		function can_write($id)
		{
			if($this->grants & PHPGW_ACL_EDIT)
			{
				return True;
			}
			return False;
		}
	}
?>
