<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

/* test */


// ------------------------------ HTTP_POST_VARS ------------------------------
  $submit=$HTTP_POST_VARS['submit'];
  $year=$HTTP_POST_VARS['year'];
  $month=$HTTP_POST_VARS['month'];
// ------------------------------  ------------------------------
  $phpgw_info["flags"]["currentapp"]='bookkeeping';
  include('../header.inc.php');
  include('inc/bookkeeping_header.inc.php');

  $phpgw->template->set_file(array( "reports" => "reports.tpl"));
  $phpgw->template->set_block("reports", "results", "results_t");
// ------------------------------  ------------------------------
  $lang_switch=lang("switch to");
  if($selected==""){
    $selected="expenses";
  }

  if($selected=='expenses')
  {
    $lang_selected=lang('expense');
    $lang_switch.=': <a href="'.$phpgw->link("/bookkeeping/reports.php","selected=income").'">'.lang("income").'</a>';
    $income_expense='E';
  }
  else
  {
    $lang_selected=lang('income');
    $lang_switch.=': <a href="'.$phpgw->link("/bookkeeping/reports.php","selected=expenses").'">'.lang("expenses").'</a>';
    $income_expense='I';
  }
// ------------------------------  ------------------------------
  $lang_month=lang('month');
  $now=getdate();
// ------------------------------  ------------------------------
  if($submit=='')
  {
// ------------------------------ no submit ------------------------------
    $date='<select name="year">';
    for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
    {
      if($i==$now["year"])
      {
        $date.='<option value="'.$i.'" selected>'.$i;
      }
      else
      {
        $date.='<option value="'.$i.'">'.$i;
      }
    }
    $date.='</select>';

    $date.='<select name="month">';
    for($i=1;$i<=12;$i++)
    {
      if($i==$now["mon"])
      {
        $date.='<option value="'.$i.'" selected>'.$i;
      }
      else
      {
        $date.='<option value="'.$i.'">'.$i;
      }
    }
    $date.='</select>';

    $phpgw->template->set_var('result','&nbsp');
    $phpgw->template->parse('results_t', 'results', true);
  }
  else
  {
// ------------------------------ submit ------------------------------
    $db2=new db;

    $month='<select name="year">';
    for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
    {
      if($i==$year)
      {
        $month.='<option value="'.$i.'" selected>'.$i;
      }
      else
      {
        $month.='<option value="'.$i.'">'.$i;
      }
    }
    $month.='</select>';

    $month.='<select name="month">';
    for($i=1;$i<=12;$i++)
    {
      if($i==$month)
      {
        $month.='<option value="'.$i.'" selected>'.$i;
      }
      else
      {
        $month.='<option value="'.$i.'">'.$i;
      }
    }
    $month.='</select>';
// ------------------------------  ------------------------------
    $graphWidthMax='600';
    $barHeight='10';
// ------------------------------ submit - fill $entry ------------------------------
    $begin_date=mktime(0,0,0,$month,1,$year);
    if($month=='12')
    {
      $end_year=$year+1;
      $end_month='1';
    }
    else
    {
      $end_year=$year;
      $end_month=$month+1;
    }
    $end_date=mktime(0,0,0,$end_month,1,$end_year);

    $sql="select e.category_id from phpgw_bk_entries e ".
         "where e.account_id='".$phpgw_info["user"]["account_id"]."' and ".
         "e.date_entry>='".$begin_date."' and e.date_entry<'".$end_date."'";
    $phpgw->db->query($sql);
print($sql);
    while($phpgw->db->next_record())
    {
      $sql2="select sum(e.amount) as amount, c.description as description from phpgw_bk_entries e, phpgw_bk_categories c ".
            "where e.account_id='".$phpgw_info["user"]["account_id"]."' and ".
            "e.date_entry>='".$begin_date."' and e.date_entry<'".$end_date."' and e.category_id=c.category_id ".
            "order by description";
print($sql2);
      $db2->query($sql2);
      while($db2->next_record())
      {
        $amount=$db2->f('amount');
        $description=$db2->f('description');
        $entry[]=$description.':'.$amount;
      }
    }
// ------------------------------ submit - show results ------------------------------
    $barMax=getMaxValue($entry,'report');
    $count=count($entry);

    $result='<table width="90%" align="center">';
    $phpgw->template->set_var('result',$result);
    $phpgw->template->parse('results_t', "results", true);

    for($k=0;$k<$count;$k++)
    {
      $description=strtok($entry[$k],':');
      $amount=strtok(':');
      $barWidth=intval($graphWidthMax*($amount/$barMax));

      $result='<tr><td>'.$description.'</td><td>';
      if(!$amount=='')
      {
        $result.='<img src="reddot.jpg" width="'.$barWidth.'" height="'.$barHeight.'" border="0">&nbsp;&nbsp;'.$amount.'</td></tr>';
      }
      else
      {
        $result.='0.00';
      }
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);
    }
    $result='</table>';
    $phpgw->template->set_var('result',$result);
    $phpgw->template->parse('results_t', "results", true);
  }
// ------------------------------ define template vars ------------------------------
  $phpgw->template->set_var('header',$header);
  $phpgw->template->set_var('head_color','D3DCE3');
  $phpgw->template->set_var('lang_app_title',lang('bookkeeping'));
  $phpgw->template->set_var('lang_title',lang('reports'));

  $phpgw->template->set_var('lang_selected',$lang_selected);
  $phpgw->template->set_var('lang_switch',$lang_switch);

  $phpgw->template->set_var('lang_month',$lang_month);
  $phpgw->template->set_var('date',$date);
  $phpgw->template->set_var('lang_show',lang('show'));

  $phpgw->template->set_var('actionurl',$phpgw->link('/bookkeeping/reports.php'));
  $phpgw->template->parse('out','reports',true);
  $phpgw->template->p('out');

  $phpgw->common->phpgw_footer();
?>
