<?php

  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

/*
This product includes software developed by The SyncML Initiative.
*/

/* 
These classes are returned by the callbacks - the corresponding C structs are found in smldtd.h. 
The classes are just a way to group data so that function calls do not extends over a couple lines...
Inheritance is not used since PHP doesnt support OOP good enough anyway.

Type checking is done via is_subclass_of(object obj, string superclass).
*/

// The data types will have to be registered with REGISTER_LONG_CONSTANT ...

//to be used in other classes
class sml_meta {
	var $format, $type, $mark, $version, $nextnonce, $maxmsgsize, $emilist;
}

//to be used in other classes
class sml_cred {
	var $meta="", $data=""; // this meta is NOT of type sml_meta!
}

//to be used in other classes
class sml_source_or_target {
	var $locURI="", $locName="";
}

// well, we could use some decent type checking here. unfortunately this is php... :-/
// Of course $cred needs to be an instance of sml_cred and so on...
// final
class sml_sync_hdr {
	var $version="", $proto="", $sessionID="", $msgID="", $flags=0, $cred, $meta="", $target, $source, $respURI="";
	
	function sml_sync_hdr() {
		$this->cred = new sml_cred();
		$this->target = new sml_source_or_target();
		$this->source = new sml_source_or_target();
	}
}	

class sml_item {
	var $target, $source, $meta="", $data="";

	function sml_item() {
                $this->target = new sml_source_or_target();
                $this->source = new sml_source_or_target();
	}
}

class sml_generic {	
	var $cmdID="", $flags=0, $cred="", $meta="", $itemList; // Array of items, I'd say

	function sml_generic() {
                $this->cred = new sml_cred();
                $this->meta = new sml_meta();
		// itemList?
	}
}

class sml_alert {
	var $cmdID="", $flags="", $cred, $data="", $itemList;

	function sml_alert() {
                $this->cred = new sml_cred();
	}
}

class sml_atomic_seq {
	var $cmdID="", $flags=0, $meta=""; // meta is NOT of type sml_meta
}

class sml_sync {
	var $cmdID="", $flags, $cred, $target, $source, $meta="";

	function sml_sync() {
                $this->cred = new sml_cred();
                $this->target = new sml_source_or_target();
                $this->source = new sml_source_or_target();
	}
}

class sml_exec {
	var $cmdID="", $flags=0, $cred, $item;

	function sml_exec() {
                $this->cred = new sml_cred();
		$this->item = new sml_item();
        }
}

class sml_get_put {
	var $cmdID="", $flags=0, $lang="", $cred, $meta="", $itemList;

        function sml_get_put() {
                $this->cred = new sml_cred();
		// itemList?
        }
}

class sml_map_item{
	var $target, $source;

        function sml_map_item() {
                $this->target = new sml_source_or_target();
                $this->source = new sml_source_or_target();
        }
}

class sml_map {
	var $cmdID="", $target, $source, $cred, $meta="", $mapItemList;
        function sml_exec() {
                $this->cred = new sml_cred();
		// mapItemList?
        }
}

class sml_results {
	var $cmdID="", $msgRef="", $cmdRef="", $meta="", $targetRef="", $sourceRef="", $itemList;
		// itemList?
}

class sml_search {
	var $cmdID="", $flags=0, $cred, $target, $sourceList, $lang="", $meta="", $data="";

	function sml_search() {
                $this->cred = new sml_cred();
                $this->target = new sml_source_or_target();
		// sourceList?
        }
}

class sml_chal {
	var $meta="";
}

class sml_status {
	var $cmdID="", $msgRef="", $cmdRef="", $cmd="", $targetRefList="", $sourceRefList="", $cred, $chal, $data="", $itemList;

	function sml_status() {
                $this->cred = new sml_cred();
		$this->chal = new sml_chal();
		// itemList? 
	}	
}

class syncml {
	var $id;

	/********************************************************************\
	* Define a new SyncML instance                                       *
	\********************************************************************/
	function syncml($encoding, $size, $name) {
		$this->id = sml_init_instance($encoding, $size, $name, $this);
	}

	function write_in_buffer($data) {
        	return(sml_write_in_buffer($this->id, $data));
	}
		
	function read_out_buffer() {
	        return(sml_read_out_buffer($this->id));
	}

	function get_free_buffer() {
        	return(sml_get_free_buffer($this->id));
	}

	/********************************************************************\
	* Command Builder API                                                *
	\********************************************************************/

        function start_message($sync_hdr) {
		if (get_class($sync_hdr)!='sml_sync_hdr') {
			trigger_error("Wrong parameter passed to start_message. ", E_USER_ERROR);
			exit;
		}

		sml_start_message($this->id, $sync_hdr);
	}

	function end_message($final) {
		sml_end_message($this->id, $final);
	}

	function start_sync($sync) {
                if (get_class($sync)!='sml_sync') {
                        trigger_error("Wrong parameter passed to start_sync. ", E_USER_ERROR);
                        exit;
                }
		sml_start_sync($this->id, $sync);
	}

	function end_sync() {
		sml_end_sync($this->id);
	}

	function add_cmd($gen) {
		sml_add_cmd($this->id, $gen);
	}

	/********************************************************************\
	* Command Dispatcher API                                             *
	\********************************************************************/
	function process_data() {
		sml_process_data($this->id);
	}

	/********************************************************************\
	* Callbacks                                                          *
	\********************************************************************/

	/* protocol management */
	function cb_start_message($sync_hdr) {
		echo "SyncML class: Callback cb_start_message not implemented. \n";
	}
        function cb_end_message($final) {
                echo "SyncML class: Callback cb_end_message not implemented. \n";
        }
        function cb_start_sync($sync) {
                echo "SyncML class: Callback cb_start_sync not implemented. \n";
        }
        function cb_end_sync() {
                echo "SyncML class: Callback cb_end_sync not implemented. \n";
        }
        function cb_start_atomic($atomic_seq) {
                echo "SyncML class: Callback cb_start_atomic not implemented. \n";
        }
        function cb_end_atomic() {
                echo "SyncML class: Callback cb_end_atomic not implemented. \n";
        }
        function cb_start_sequence($atomic_seq) {
                echo "SyncML class: Callback cb_start_sequence not implemented. \n";
        }
        function cb_end_sequence() {
                echo "SyncML class: Callback cb_end_sequence not implemented. \n";
        }

	/* sync commands */
        function cb_add_cmd($generic) {
                echo "SyncML class: Callback cb_add_cmd not implemented. \n";
        }
        function cb_alert_cmd() {
                echo "SyncML class: Callback cb_alert_cmd not implemented. \n";
        }
        function cb_delete_cmd() {
                echo "SyncML class: Callback cb_delete_cmd not implemented. \n";
        }
        function cb_get_cmd() {
                echo "SyncML class: Callback cb_get_cmd not implemented. \n";
        }
        function cb_put_cmd() {
                echo "SyncML class: Callback cb_put_cmd not implemented. \n";
        }
        function cb_map_cmd() {
                echo "SyncML class: Callback cb_map_cmd not implemented. \n";
        }
        function cb_results_cmd() {
                echo "SyncML class: Callback cb_results_cmd not implemented. \n";
        }
        function cb_status_cmd() {
                echo "SyncML class: Callback cb_status_cmd not implemented. \n";
        }
        function cb_replace_cmd() {
                echo "SyncML class: Callback cb_replace_cmd not implemented. \n";
        }
        function cb_copy_cmd() {
                echo "SyncML class: Callback cb_copy_cmd not implemented. \n";
        }
        function cb_exec_cmd() {
                echo "SyncML class: Callback cb_exec_cmd not implemented. \n";
        }
        function cb_search_cmd() {
                echo "SyncML class: Callback cb_search_cmd not implemented. \n";
        }

	/* other callbacks */
        function cb_handle_error() {
                echo "'SyncML class: Callback cb_handle_error not implemented. \n";
        }
        function cb_transmit_chunk() {
                echo "SyncML class: Callback cb_transmit_chunk not implemented. \n";
        }
}

// can't declare this inside the class - and debug message are global anyway, if there were any... Mark, I think we should
// remove this.
function cb_print_func($debug_msg) {
	echo "SyncML: Callback cb_print_func not implemented. \n";
}

?>
