CREATE SEQUENCE "seq_ccs_id";
CREATE SEQUENCE "seq_status_id";
CREATE SEQUENCE "seq_timecards_id";
CREATE SEQUENCE "seq_actions_id";
CREATE SEQUENCE "seq_department_id";
CREATE SEQUENCE 
	"seq_personnel_id" 
	start 2 increment 1 maxvalue 2147483647 minvalue 1  cache 1 ;

CREATE TABLE osims_ccs (
		"ccs" "int4" NOT NULL PRIMARY KEY DEFAULT(nextval('seq_ccs_id')),
		"owner" 	"int4" NOT NULL,
		"subject" 	varchar(255) NOT NULL,
		"detail"	text NOT NULL,
		"assignedto" 	"int4" NOT NULL,
		"openedon"	"timestamp" default 'now()' NOT NULL, 
		"closedon"	"date",
		"closedby"	"int4",
		"status"	"int4" NOT NULL,
		"statuson"	"timestamp",
		"lastactionon"	"timestamp"
	);


CREATE TABLE "osims_statuses" (
		"id" "int4" NOT NULL PRIMARY KEY DEFAULT(nextval('seq_status_id')),
		"short" char(10) NOT NULL, 
		"name" varchar(20) NOT NULL,
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "osims_timecards" (
		"id" "int4" NOT NULL PRIMARY KEY DEFAULT(nextval('seq_timecards_id')), 
		"ccs" "int4" NOT NULL, 
		"actionon" "date" NOT NULL, 
		"inputon" "timestamp" DEFAULT text 'now' NOT NULL, 
		"actionby" "int4" NOT NULL, 
		"status" "int4" NOT NULL, 
		"action" "int4" NOT NULL, 
		"summary" varchar(100) NOT NULL, 
		"description" varchar(1024)
	);

CREATE TABLE "osims_actions" (
		"id" "int4" NOT NULL PRIMARY KEY DEFAULT(nextval('seq_actions_id')), 
		"short" char(10) NOT NULL, 
		"name" varchar(20) NOT NULL,
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "osims_personnel" (
		"id" "int4" NOT NULL PRIMARY KEY DEFAULT(nextval('seq_personnel_id')),
		"phpgwid" "int4" NOT NULL,
		"reportto" "int4", 
		"department" "int4", 
		"security" "int4", 
		"active" varchar(1) default 'Y'
	);

CREATE TABLE "osims_departments" (
		"id" "int4" NOT NULL PRIMARY KEY DEFAULT(nextval('seq_department_id')), 
		"short" char(10) NOT NULL, 
		"name" varchar(30) NOT NULL,
		"active" varchar(1) default 'Y'
	);

COPY "osims_actions" FROM stdin;
1	PH       	Phone	Y
2	FAX       	Fax	Y
3	DOC       	Document	Y
4	TST       	Testing	Y
5	MTG       	Meeting	Y
6	IMP       	Implementation	Y
7	CORR      	Correction	Y
\.

COPY "osims_statuses" FROM stdin;
1	OP        	Open	Y
2	CL        	Closed	Y
3	DF        	Deferred	Y
4	UA        	Unassigned	Y
\.

COPY "osims_personnel" FROM stdin;
1	1	1	1	9	Y
\.

