/* Generated by re2c 0.9.12 on Sat Sep  9 14:19:46 2006 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.c,v 1.29.2.30.2.7 2006/09/09 12:26:22 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->special.type = relunit->multiplier;
			s->time->special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;


{
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0, 208,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	208,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0, 128,  64, 192,   0, 
	  8,   8,   8,   8,   8,   8,   8,   8, 
	  8,   8,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,  32,  32,  32, 160,  32,  32,  32, 
	160,  32,  32,  32,  32,  32, 160,  32, 
	 32,  32, 160, 160, 160,  32,  32,  32, 
	 32,  32,  32,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	goto yy0;

	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 29) YYFILL(29);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x00:	case 0x0A:	goto yy48;
	case 0x09:	case ' ':	goto yy45;
	case '(':	goto yy42;
	case '+':	case '-':	goto yy41;
	case ',':	case '.':	goto yy47;
	case '0':	goto yy13;
	case '1':	goto yy14;
	case '2':	goto yy15;
	case '3':	goto yy16;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy17;
	case '@':	goto yy11;
	case 'A':	goto yy25;
	case 'B':
	case 'C':	case 'G':
	case 'H':	case 'K':	case 'Q':
	case 'R':	case 'U':	case 'Z':	goto yy43;
	case 'D':	goto yy31;
	case 'E':	goto yy35;
	case 'F':	goto yy23;
	case 'I':	goto yy18;
	case 'J':	goto yy21;
	case 'L':	goto yy37;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy29;
	case 'P':	goto yy39;
	case 'S':	goto yy27;
	case 'T':	goto yy9;
	case 'V':	goto yy19;
	case 'W':	goto yy33;
	case 'X':	goto yy20;
	case 'Y':	goto yy2;
	case 'a':	goto yy26;
	case 'b':
	case 'c':	case 'g':
	case 'h':
	case 'i':	case 'k':	case 'q':
	case 'r':	case 'u':
	case 'v':	case 'x':	case 'z':	goto yy44;
	case 'd':	goto yy32;
	case 'e':	goto yy36;
	case 'f':	goto yy24;
	case 'j':	goto yy22;
	case 'l':	goto yy38;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy30;
	case 'p':	goto yy40;
	case 's':	goto yy28;
	case 't':	goto yy10;
	case 'w':	goto yy34;
	case 'y':	goto yy4;
	default:	goto yy50;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'E'){
		if(yych <= ')'){
			if(yych >= ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy137;
			goto yy1373;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy137;
			if(yych >= 'a')	goto yy142;
			goto yy3;
		} else {
			if(yych <= 'e')	goto yy1382;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy137;
			goto yy1373;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'e')	goto yy1373;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy1344;
				goto yy137;
			} else {
				if(yych <= 'I')	goto yy1345;
				if(yych <= 'N')	goto yy137;
				goto yy1343;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy137;
				goto yy3;
			} else {
				if(yych == 'e')	goto yy1360;
				goto yy142;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1361;
				goto yy142;
			} else {
				if(yych <= 'o')	goto yy1359;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy1344;
				goto yy137;
			} else {
				if(yych <= 'I')	goto yy1345;
				if(yych <= 'N')	goto yy137;
				goto yy1343;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy137;
				goto yy3;
			} else {
				if(yych == 'e')	goto yy1344;
				goto yy137;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1345;
				goto yy137;
			} else {
				if(yych <= 'o')	goto yy1343;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'A'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy1313;
		} else {
			if(yych == 'I')	goto yy1314;
			if(yych <= 'N')	goto yy137;
			goto yy1315;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1328;
			goto yy142;
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1329;
				goto yy142;
			} else {
				if(yych <= 'o')	goto yy1330;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'A'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy1313;
		} else {
			if(yych == 'I')	goto yy1314;
			if(yych <= 'N')	goto yy137;
			goto yy1315;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1313;
			goto yy137;
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1314;
				goto yy137;
			} else {
				if(yych <= 'o')	goto yy1315;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ')':	goto yy136;
	case '0':
	case '1':	goto yy1245;
	case '2':	goto yy1246;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1247;
	case 'A':
	case 'B':
	case 'C':
	case 'D':	case 'F':
	case 'G':	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':
	case 'Z':	goto yy137;
	case 'E':	goto yy1240;
	case 'H':	goto yy1241;
	case 'O':	goto yy1242;
	case 'U':	goto yy1243;
	case 'W':	goto yy1244;
	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'f':
	case 'g':	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':	case 'v':	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy1282;
	case 'h':	goto yy1283;
	case 'o':	goto yy1284;
	case 'u':	goto yy1285;
	case 'w':	goto yy1286;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ')':	goto yy136;
	case '0':
	case '1':	goto yy1245;
	case '2':	goto yy1246;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1247;
	case 'A':
	case 'B':
	case 'C':
	case 'D':	case 'F':
	case 'G':	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':
	case 'Z':	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'f':
	case 'g':	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':	case 'v':	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'E':	case 'e':	goto yy1240;
	case 'H':	case 'h':	goto yy1241;
	case 'O':	case 'o':	goto yy1242;
	case 'U':	case 'u':	goto yy1243;
	case 'W':	case 'w':	goto yy1244;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy1236;
	if(yych <= '/')	goto yy12;
	if(yych <= '9')	goto yy1237;
	goto yy12;
yy12:
	YYDEBUG(12, *YYCURSOR);

{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	goto yy1198;
	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':	case 'w':	case 'y':	goto yy1200;
	case '-':	goto yy660;
	case '.':	goto yy1202;
	case '/':	goto yy659;
	case '0':	goto yy1235;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1234;
	case ':':	goto yy1203;
	case 'n':	goto yy657;
	case 'r':	goto yy658;
	case 's':	goto yy651;
	case 't':	goto yy655;
	default:	goto yy12;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	goto yy647;
	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy649;
	case '-':	goto yy660;
	case '.':	goto yy661;
	case '/':	goto yy659;
	case '0':
	case '1':
	case '2':	goto yy1234;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1201;
	case ':':	goto yy670;
	case 'n':	goto yy657;
	case 'r':	goto yy658;
	case 's':	goto yy651;
	case 't':	goto yy655;
	default:	goto yy12;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	goto yy647;
	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy649;
	case '-':	goto yy660;
	case '.':	goto yy661;
	case '/':	goto yy659;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1201;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1197;
	case ':':	goto yy670;
	case 'n':	goto yy657;
	case 'r':	goto yy658;
	case 's':	goto yy651;
	case 't':	goto yy655;
	default:	goto yy12;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	goto yy647;
	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy649;
	case '-':	goto yy660;
	case '.':	goto yy661;
	case '/':	goto yy659;
	case '0':
	case '1':	goto yy1197;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy656;
	case ':':	goto yy670;
	case 'n':	goto yy657;
	case 'r':	goto yy658;
	case 's':	goto yy651;
	case 't':	goto yy655;
	default:	goto yy12;
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	goto yy647;
	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy649;
	case '-':	goto yy660;
	case '.':	goto yy661;
	case '/':	goto yy659;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy656;
	case ':':	goto yy670;
	case 'n':	goto yy657;
	case 'r':	goto yy658;
	case 's':	goto yy651;
	case 't':	goto yy655;
	default:	goto yy12;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy3;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy3;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy3;
			} else {
				if(yych == '/')	goto yy3;
				goto yy312;
			}
		}
	} else {
		if(yych <= 'V'){
			if(yych <= 'H'){
				if(yych <= '@')	goto yy3;
				goto yy137;
			} else {
				if(yych <= 'I')	goto yy646;
				if(yych <= 'U')	goto yy137;
				goto yy645;
			}
		} else {
			if(yych <= 'Z'){
				if(yych == 'X')	goto yy645;
				goto yy137;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy3;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy3;
			goto yy312;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'Z'){
				if(yych <= 'I')	goto yy642;
				goto yy137;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy3;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy3;
			goto yy312;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'Z'){
				if(yych <= 'I')	goto yy640;
				goto yy137;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy623;
			if(yych <= 'T')	goto yy137;
			goto yy622;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy632;
		} else {
			if(yych == 'u')	goto yy631;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy623;
			if(yych <= 'T')	goto yy137;
			goto yy622;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy623;
		} else {
			if(yych == 'u')	goto yy622;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy136;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy137;
				goto yy584;
			}
		} else {
			if(yych <= 'N'){
				if(yych == 'I')	goto yy585;
				goto yy137;
			} else {
				if(yych <= 'O')	goto yy586;
				if(yych <= 'Q')	goto yy137;
				goto yy587;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy137;
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'e')	goto yy603;
				if(yych <= 'h')	goto yy142;
				goto yy604;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'o')	goto yy605;
				goto yy142;
			} else {
				if(yych <= 'r')	goto yy606;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy136;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy137;
				goto yy584;
			}
		} else {
			if(yych <= 'N'){
				if(yych == 'I')	goto yy585;
				goto yy137;
			} else {
				if(yych <= 'O')	goto yy586;
				if(yych <= 'Q')	goto yy137;
				goto yy587;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy137;
				if(yych <= '`')	goto yy3;
				goto yy137;
			} else {
				if(yych <= 'e')	goto yy584;
				if(yych <= 'h')	goto yy137;
				goto yy585;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'o')	goto yy586;
				goto yy137;
			} else {
				if(yych <= 'r')	goto yy587;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'F'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'O'){
				if(yych <= 'G')	goto yy563;
				goto yy137;
			} else {
				if(yych <= 'P')	goto yy562;
				if(yych <= 'T')	goto yy137;
				goto yy561;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy137;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy575;
				goto yy142;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy574;
				goto yy142;
			} else {
				if(yych <= 'u')	goto yy573;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'F'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'O'){
				if(yych <= 'G')	goto yy563;
				goto yy137;
			} else {
				if(yych <= 'P')	goto yy562;
				if(yych <= 'T')	goto yy137;
				goto yy561;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy137;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy563;
				goto yy137;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy562;
				goto yy137;
			} else {
				if(yych <= 'u')	goto yy561;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy136;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'A')	goto yy504;
				goto yy137;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy503;
				goto yy137;
			} else {
				if(yych <= 'I')	goto yy505;
				if(yych <= 'T')	goto yy137;
				goto yy506;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy137;
				goto yy3;
			} else {
				if(yych <= 'a')	goto yy533;
				if(yych <= 'd')	goto yy142;
				goto yy532;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'i')	goto yy534;
				goto yy142;
			} else {
				if(yych <= 'u')	goto yy535;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy136;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'A')	goto yy504;
				goto yy137;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy503;
				goto yy137;
			} else {
				if(yych <= 'I')	goto yy505;
				if(yych <= 'T')	goto yy137;
				goto yy506;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy137;
				goto yy3;
			} else {
				if(yych <= 'a')	goto yy504;
				if(yych <= 'd')	goto yy137;
				goto yy503;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'i')	goto yy505;
				goto yy137;
			} else {
				if(yych <= 'u')	goto yy506;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy137;
			goto yy493;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy142;
		} else {
			if(yych <= 'c')	goto yy498;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy137;
			goto yy493;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'c')	goto yy493;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy137;
			goto yy308;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy142;
		} else {
			if(yych <= 'e')	goto yy486;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy137;
			goto yy308;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'e')	goto yy308;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy137;
			goto yy281;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy142;
		} else {
			if(yych <= 'e')	goto yy295;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy137;
			goto yy281;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'e')	goto yy281;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy261;
			if(yych <= 'K')	goto yy137;
			goto yy262;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy142;
			goto yy271;
		} else {
			if(yych == 'l')	goto yy272;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy261;
			if(yych <= 'K')	goto yy137;
			goto yy262;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy137;
			goto yy261;
		} else {
			if(yych == 'l')	goto yy262;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy255;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy137;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy258;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy255;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy137;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy255;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy137;
			goto yy161;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy142;
		} else {
			if(yych <= 'r')	goto yy248;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy137;
			goto yy161;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy137;
			if(yych <= '`')	goto yy3;
			goto yy137;
		} else {
			if(yych <= 'r')	goto yy161;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy54;
	}
	if(yych <= '/')	goto yy12;
	if(yych <= '1')	goto yy154;
	if(yych <= '2')	goto yy155;
	if(yych <= '9')	goto yy156;
	goto yy12;
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@')	goto yy12;
	if(yych <= 'Z')	goto yy153;
	if(yych <= '`')	goto yy12;
	if(yych <= 'z')	goto yy153;
	goto yy12;
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy137;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy142;
		goto yy3;
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy137;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy137;
		goto yy3;
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy54;
	}
	if(yych <= '/')	goto yy46;
	if(yych <= '9')	goto yy51;
	goto yy46;
yy46:
	YYDEBUG(46, *YYCURSOR);

{
		goto std;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy46;
yy48:
	YYDEBUG(48, *YYCURSOR);
	++YYCURSOR;
	goto yy49;
yy49:
	YYDEBUG(49, *YYCURSOR);

{
		s->pos = cursor; s->line++;
		goto std;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy52;
yy52:
	YYDEBUG(52, *YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy56;
				if(yych >= ' ')	goto yy56;
				goto yy53;
			} else {
				if(yych == 'D')	goto yy61;
				if(yych >= 'F')	goto yy63;
				goto yy53;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy60;
				if(yych >= 'M')	goto yy59;
				goto yy53;
			} else {
				if(yych <= 'S'){
					if(yych >= 'S')	goto yy58;
					goto yy53;
				} else {
					if(yych <= 'T')	goto yy65;
					if(yych >= 'W')	goto yy62;
					goto yy53;
				}
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy64;
				if(yych >= 'd')	goto yy61;
				goto yy53;
			} else {
				if(yych <= 'f'){
					if(yych >= 'f')	goto yy63;
					goto yy53;
				} else {
					if(yych == 'h')	goto yy60;
					goto yy53;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'm')	goto yy59;
				if(yych <= 'r')	goto yy53;
				if(yych <= 's')	goto yy58;
				goto yy65;
			} else {
				if(yych <= 'w'){
					if(yych >= 'w')	goto yy62;
					goto yy53;
				} else {
					if(yych == 'y')	goto yy64;
					goto yy53;
				}
			}
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 29:	goto yy1381;
	case 27:	goto yy1350;
	case 28:	goto yy1358;
	case 26:	goto yy1272;
	case 25:	goto yy1269;
	case 12:	goto yy678;
	case 23:	goto yy1206;
	case 24:	goto yy1214;
	case 14:	goto yy835;
	case 20:	goto yy1100;
	case 21:	goto yy1124;
	case 13:	goto yy825;
	case 9:	goto yy409;
	case 19:	goto yy943;
	case 7:	goto yy315;
	case 11:	goto yy663;
	case 18:	goto yy998;
	case 22:	goto yy992;
	case 17:	goto yy971;
	case 16:	goto yy964;
	case 15:	goto yy936;
	case 10:	goto yy565;
	case 5:	goto yy283;
	case 4:	goto yy181;
	case 6:	goto yy310;
	case 0:	goto yy3;
	case 8:	goto yy339;
	case 3:	goto yy69;
	case 2:	goto yy46;
	case 1:	goto yy12;
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy55;
yy55:
	YYDEBUG(55, *YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy54;
	}
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy51;
	goto yy53;
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy57;
yy57:
	YYDEBUG(57, *YYCURSOR);
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy56;
				if(yych <= 0x1F)	goto yy53;
				goto yy56;
			} else {
				if(yych == 'D')	goto yy61;
				if(yych <= 'E')	goto yy53;
				goto yy63;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy60;
				if(yych <= 'L')	goto yy53;
				goto yy59;
			} else {
				if(yych <= 'S'){
					if(yych <= 'R')	goto yy53;
					goto yy58;
				} else {
					if(yych <= 'T')	goto yy65;
					if(yych <= 'V')	goto yy53;
					goto yy62;
				}
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy64;
				if(yych <= 'c')	goto yy53;
				goto yy61;
			} else {
				if(yych <= 'f'){
					if(yych <= 'e')	goto yy53;
					goto yy63;
				} else {
					if(yych == 'h')	goto yy60;
					goto yy53;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'm')	goto yy59;
				if(yych <= 'r')	goto yy53;
				if(yych >= 't')	goto yy65;
				goto yy58;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy53;
					goto yy62;
				} else {
					if(yych == 'y')	goto yy64;
					goto yy53;
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy124;
			if(yych <= 'T')	goto yy53;
			goto yy122;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy124;
			if(yych == 'u')	goto yy122;
			goto yy53;
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy114;
		if(yych <= 'N')	goto yy53;
		goto yy113;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy53;
			goto yy114;
		} else {
			if(yych == 'o')	goto yy113;
			goto yy53;
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy111;
	if(yych == 'o')	goto yy111;
	goto yy53;
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy110;
	if(yych == 'a')	goto yy110;
	goto yy53;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy98;
	if(yych == 'e')	goto yy98;
	goto yy53;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy83;
		if(yych <= 'Q')	goto yy53;
		goto yy82;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy53;
			goto yy83;
		} else {
			if(yych == 'r')	goto yy82;
			goto yy53;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy79;
	if(yych == 'e')	goto yy79;
	goto yy53;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy66;
		if(yych <= 'T')	goto yy53;
		goto yy67;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy66;
		} else {
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy74;
	if(yych == 'u')	goto yy74;
	goto yy53;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy68;
	if(yych != 'e')	goto yy53;
	goto yy68;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'S')	goto yy70;
	if(yych == 's')	goto yy70;
	goto yy69;
yy69:
	YYDEBUG(69, *YYCURSOR);

{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy71;
	if(yych != 'd')	goto yy53;
	goto yy71;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy72;
	if(yych != 'a')	goto yy53;
	goto yy72;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych != 'y')	goto yy53;
	goto yy73;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy69;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy75;
	if(yych != 'r')	goto yy69;
	goto yy75;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy76;
	if(yych != 's')	goto yy53;
	goto yy76;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy77;
	if(yych != 'd')	goto yy53;
	goto yy77;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy78;
	if(yych != 'a')	goto yy53;
	goto yy78;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy80;
	if(yych != 'a')	goto yy53;
	goto yy80;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy81;
	if(yych != 'r')	goto yy53;
	goto yy81;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy73;
	if(yych == 's')	goto yy73;
	goto yy69;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy95;
	if(yych == 'i')	goto yy95;
	goto yy53;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy84;
	if(yych != 'r')	goto yy53;
	goto yy84;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy85;
	if(yych != 't')	goto yy53;
	goto yy85;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy87;
		if(yych <= 'M')	goto yy53;
		goto yy86;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy87;
		} else {
			if(yych != 'n')	goto yy53;
			goto yy86;
		}
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy92;
	if(yych == 'i')	goto yy92;
	goto yy53;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy88;
	if(yych != 'n')	goto yy53;
	goto yy88;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy89;
	if(yych != 'i')	goto yy53;
	goto yy89;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy90;
	if(yych != 'g')	goto yy53;
	goto yy90;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy91;
	if(yych != 'h')	goto yy53;
	goto yy91;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy81;
	if(yych == 't')	goto yy81;
	goto yy53;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy93;
	if(yych != 'g')	goto yy53;
	goto yy93;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy94;
	if(yych != 'h')	goto yy53;
	goto yy94;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy81;
	if(yych == 't')	goto yy81;
	goto yy53;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy96;
	if(yych != 'd')	goto yy69;
	goto yy96;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy97;
	if(yych != 'a')	goto yy53;
	goto yy97;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy53;
		if(yych <= 'D')	goto yy100;
		goto yy99;
	} else {
		if(yych <= 'c')	goto yy53;
		if(yych <= 'd')	goto yy100;
		if(yych >= 'f')	goto yy53;
		goto yy99;
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy106;
	if(yych == 'k')	goto yy106;
	goto yy53;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'N')	goto yy101;
	if(yych != 'n')	goto yy69;
	goto yy101;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy102;
	if(yych != 'e')	goto yy53;
	goto yy102;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy103;
	if(yych != 's')	goto yy53;
	goto yy103;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy104;
	if(yych != 'd')	goto yy53;
	goto yy104;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy105;
	if(yych != 'a')	goto yy53;
	goto yy105;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == 'D')	goto yy107;
		if(yych <= 'R')	goto yy69;
		goto yy73;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy69;
			goto yy107;
		} else {
			if(yych == 's')	goto yy73;
			goto yy69;
		}
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy108;
	if(yych != 'a')	goto yy53;
	goto yy108;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy109;
	if(yych != 'y')	goto yy53;
	goto yy109;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy73;
	if(yych == 's')	goto yy73;
	goto yy69;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy81;
	if(yych == 'y')	goto yy81;
	goto yy53;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy112;
	if(yych != 'u')	goto yy53;
	goto yy112;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy81;
	if(yych == 'r')	goto yy81;
	goto yy53;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy118;
	if(yych == 'n')	goto yy118;
	goto yy53;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy115;
	if(yych != 'n')	goto yy53;
	goto yy115;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych == 'S')	goto yy73;
		if(yych <= 'T')	goto yy69;
		goto yy116;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy69;
			goto yy73;
		} else {
			if(yych != 'u')	goto yy69;
			goto yy116;
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy117;
	if(yych != 't')	goto yy53;
	goto yy117;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy81;
	if(yych == 'e')	goto yy81;
	goto yy53;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == 'D')	goto yy119;
		if(yych <= 'S')	goto yy69;
		goto yy120;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy69;
			goto yy119;
		} else {
			if(yych == 't')	goto yy120;
			goto yy69;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy121;
	if(yych == 'a')	goto yy121;
	goto yy53;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy81;
	if(yych == 'h')	goto yy81;
	goto yy53;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy133;
	if(yych == 'n')	goto yy133;
	goto yy53;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy128;
	if(yych == 't')	goto yy128;
	goto yy53;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy125;
	if(yych != 'c')	goto yy53;
	goto yy125;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == 'O')	goto yy126;
		if(yych <= 'R')	goto yy69;
		goto yy73;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy69;
			goto yy126;
		} else {
			if(yych == 's')	goto yy73;
			goto yy69;
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy127;
	if(yych != 'n')	goto yy53;
	goto yy127;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy81;
	if(yych == 'd')	goto yy81;
	goto yy53;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy129;
	if(yych != 'u')	goto yy69;
	goto yy129;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy130;
	if(yych != 'r')	goto yy53;
	goto yy130;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy131;
	if(yych != 'd')	goto yy53;
	goto yy131;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy132;
	if(yych != 'a')	goto yy53;
	goto yy132;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy134;
	if(yych != 'd')	goto yy69;
	goto yy134;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy135;
	if(yych != 'a')	goto yy53;
	goto yy135;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy138;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy138;
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy139;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy139;
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy140;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy140;
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy141;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy141;
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy136;
	goto yy3;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy3;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy143;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych != '/')	goto yy3;
			goto yy144;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@')	goto yy53;
	if(yych >= '[')	goto yy53;
	goto yy145;
yy145:
	YYDEBUG(145, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy146;
	}
	goto yy53;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy147;
yy147:
	YYDEBUG(147, *YYCURSOR);
	if(yybm[0+yych] & 32) {
		goto yy146;
	}
	if(yych == '/')	goto yy144;
	if(yych == '_')	goto yy144;
	goto yy3;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy3;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy149;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy3;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy150;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy136;
		if(yych <= '.')	goto yy3;
		goto yy144;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy151;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy152;
yy152:
	YYDEBUG(152, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy144;
		goto yy53;
	} else {
		if(yych <= '_')	goto yy144;
		if(yych <= '`')	goto yy53;
		if(yych <= 'z')	goto yy151;
		goto yy53;
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy137;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy137;
		goto yy3;
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy3;
				goto yy57;
			} else {
				if(yych <= '9'){
					if(yych <= '/')	goto yy3;
					goto yy156;
				} else {
					if(yych <= ':')	goto yy157;
					if(yych <= 'C')	goto yy3;
					goto yy57;
				}
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy3;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy3;
					if(yych <= 'T')	goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy3;
				if(yych <= 'Y')	goto yy57;
				goto yy3;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy3;
				} else {
					if(yych == 'g')	goto yy3;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy3;
				}
			}
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= ':'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy3;
				goto yy57;
			} else {
				if(yych <= '3'){
					if(yych <= '/')	goto yy3;
					goto yy156;
				} else {
					if(yych <= '5')	goto yy158;
					if(yych <= '9')	goto yy159;
					goto yy157;
				}
			}
		} else {
			if(yych <= 'G'){
				if(yych <= 'D'){
					if(yych <= 'C')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'F')	goto yy57;
					goto yy3;
				}
			} else {
				if(yych <= 'L'){
					if(yych <= 'H')	goto yy57;
					goto yy3;
				} else {
					if(yych <= 'M')	goto yy57;
					if(yych <= 'R')	goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Y'){
				if(yych == 'W')	goto yy57;
				if(yych <= 'X')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'd'){
					if(yych <= 'c')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'f')	goto yy57;
					goto yy3;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'l'){
					if(yych <= 'h')	goto yy57;
					goto yy3;
				} else {
					if(yych <= 'm')	goto yy57;
					if(yych <= 'r')	goto yy3;
					goto yy57;
				}
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy3;
				}
			}
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= 'C'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy3;
				goto yy57;
			} else {
				if(yych <= '5'){
					if(yych <= '/')	goto yy3;
					goto yy158;
				} else {
					if(yych <= '9')	goto yy159;
					if(yych >= ';')	goto yy3;
					goto yy157;
				}
			}
		} else {
			if(yych <= 'G'){
				if(yych == 'E')	goto yy3;
				if(yych <= 'F')	goto yy57;
				goto yy3;
			} else {
				if(yych <= 'L'){
					if(yych <= 'H')	goto yy57;
					goto yy3;
				} else {
					if(yych <= 'M')	goto yy57;
					if(yych <= 'R')	goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Y'){
				if(yych == 'W')	goto yy57;
				if(yych <= 'X')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'd'){
					if(yych <= 'c')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'f')	goto yy57;
					goto yy3;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'l'){
					if(yych <= 'h')	goto yy57;
					goto yy3;
				} else {
					if(yych <= 'm')	goto yy57;
					if(yych <= 'r')	goto yy3;
					goto yy57;
				}
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy3;
				}
			}
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy3;
	if(yych <= '5')	goto yy160;
	if(yych <= '9')	goto yy136;
	goto yy3;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy3;
				goto yy57;
			} else {
				if(yych <= '/')	goto yy3;
				if(yych <= '9')	goto yy159;
				if(yych <= 'C')	goto yy3;
				goto yy57;
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy3;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy3;
					if(yych <= 'T')	goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy3;
				if(yych <= 'Y')	goto yy57;
				goto yy3;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy3;
				} else {
					if(yych == 'g')	goto yy3;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy3;
				}
			}
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy3;
				goto yy57;
			} else {
				if(yych == 'D')	goto yy57;
				if(yych <= 'E')	goto yy3;
				goto yy57;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy57;
				if(yych <= 'L')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'R')	goto yy3;
				if(yych <= 'T')	goto yy57;
				if(yych <= 'V')	goto yy3;
				goto yy57;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy57;
				if(yych <= 'c')	goto yy3;
				goto yy57;
			} else {
				if(yych == 'f')	goto yy57;
				if(yych <= 'g')	goto yy3;
				goto yy57;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy3;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy3;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy3;
				}
			}
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy3;
	if(yych <= '9')	goto yy136;
	goto yy3;
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy162;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'e')	goto yy162;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy139;
			goto yy163;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'v')	goto yy163;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy140;
			goto yy164;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'i')	goto yy164;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy141;
			goto yy165;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'o')	goto yy165;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'U')	goto yy166;
		if(yych != 'u')	goto yy3;
		goto yy166;
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy167;
	if(yych != 's')	goto yy53;
	goto yy167;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 0x09)	goto yy168;
	if(yych != ' ')	goto yy53;
	goto yy168;
yy168:
	YYDEBUG(168, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy169;
yy169:
	YYDEBUG(169, *YYCURSOR);
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy168;
				if(yych <= 0x1F)	goto yy53;
				goto yy168;
			} else {
				if(yych == 'D')	goto yy173;
				if(yych <= 'E')	goto yy53;
				goto yy175;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy172;
				if(yych <= 'L')	goto yy53;
				goto yy171;
			} else {
				if(yych <= 'S'){
					if(yych <= 'R')	goto yy53;
					goto yy170;
				} else {
					if(yych <= 'T')	goto yy177;
					if(yych <= 'V')	goto yy53;
					goto yy174;
				}
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy176;
				if(yych <= 'c')	goto yy53;
				goto yy173;
			} else {
				if(yych <= 'f'){
					if(yych <= 'e')	goto yy53;
					goto yy175;
				} else {
					if(yych == 'h')	goto yy172;
					goto yy53;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'm')	goto yy171;
				if(yych <= 'r')	goto yy53;
				if(yych >= 't')	goto yy177;
				goto yy170;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy53;
					goto yy174;
				} else {
					if(yych == 'y')	goto yy176;
					goto yy53;
				}
			}
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy235;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy236;
			if(yych <= 'T')	goto yy53;
			goto yy234;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy235;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy236;
			if(yych == 'u')	goto yy234;
			goto yy53;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy226;
		if(yych <= 'N')	goto yy53;
		goto yy225;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy53;
			goto yy226;
		} else {
			if(yych == 'o')	goto yy225;
			goto yy53;
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy223;
	if(yych == 'o')	goto yy223;
	goto yy53;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy222;
	if(yych == 'a')	goto yy222;
	goto yy53;
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy210;
	if(yych == 'e')	goto yy210;
	goto yy53;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy195;
		if(yych <= 'Q')	goto yy53;
		goto yy194;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy53;
			goto yy195;
		} else {
			if(yych == 'r')	goto yy194;
			goto yy53;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy191;
	if(yych == 'e')	goto yy191;
	goto yy53;
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy178;
		if(yych <= 'T')	goto yy53;
		goto yy179;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy178;
		} else {
			if(yych == 'u')	goto yy179;
			goto yy53;
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy186;
	if(yych == 'u')	goto yy186;
	goto yy53;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy180;
	if(yych != 'e')	goto yy53;
	goto yy180;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'S')	goto yy182;
	if(yych == 's')	goto yy182;
	goto yy181;
yy181:
	YYDEBUG(181, *YYCURSOR);

{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy183;
	if(yych != 'd')	goto yy53;
	goto yy183;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy184;
	if(yych != 'a')	goto yy53;
	goto yy184;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych != 'y')	goto yy53;
	goto yy185;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy181;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy187;
	if(yych != 'r')	goto yy181;
	goto yy187;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy188;
	if(yych != 's')	goto yy53;
	goto yy188;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy189;
	if(yych != 'd')	goto yy53;
	goto yy189;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy190;
	if(yych != 'a')	goto yy53;
	goto yy190;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych == 'y')	goto yy185;
	goto yy53;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy192;
	if(yych != 'a')	goto yy53;
	goto yy192;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy193;
	if(yych != 'r')	goto yy53;
	goto yy193;
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy185;
	if(yych == 's')	goto yy185;
	goto yy181;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy207;
	if(yych == 'i')	goto yy207;
	goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy196;
	if(yych != 'r')	goto yy53;
	goto yy196;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy197;
	if(yych != 't')	goto yy53;
	goto yy197;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy199;
		if(yych <= 'M')	goto yy53;
		goto yy198;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy199;
		} else {
			if(yych != 'n')	goto yy53;
			goto yy198;
		}
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy204;
	if(yych == 'i')	goto yy204;
	goto yy53;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy200;
	if(yych != 'n')	goto yy53;
	goto yy200;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy201;
	if(yych != 'i')	goto yy53;
	goto yy201;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy202;
	if(yych != 'g')	goto yy53;
	goto yy202;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy203;
	if(yych != 'h')	goto yy53;
	goto yy203;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy193;
	if(yych == 't')	goto yy193;
	goto yy53;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy205;
	if(yych != 'g')	goto yy53;
	goto yy205;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy206;
	if(yych != 'h')	goto yy53;
	goto yy206;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy193;
	if(yych == 't')	goto yy193;
	goto yy53;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy208;
	if(yych != 'd')	goto yy181;
	goto yy208;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy209;
	if(yych != 'a')	goto yy53;
	goto yy209;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych == 'y')	goto yy185;
	goto yy53;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy53;
		if(yych <= 'D')	goto yy212;
		goto yy211;
	} else {
		if(yych <= 'c')	goto yy53;
		if(yych <= 'd')	goto yy212;
		if(yych >= 'f')	goto yy53;
		goto yy211;
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy218;
	if(yych == 'k')	goto yy218;
	goto yy53;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'N')	goto yy213;
	if(yych != 'n')	goto yy181;
	goto yy213;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy214;
	if(yych != 'e')	goto yy53;
	goto yy214;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy215;
	if(yych != 's')	goto yy53;
	goto yy215;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy216;
	if(yych != 'd')	goto yy53;
	goto yy216;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy217;
	if(yych != 'a')	goto yy53;
	goto yy217;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych == 'y')	goto yy185;
	goto yy53;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == 'D')	goto yy219;
		if(yych <= 'R')	goto yy181;
		goto yy185;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy181;
			goto yy219;
		} else {
			if(yych == 's')	goto yy185;
			goto yy181;
		}
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy220;
	if(yych != 'a')	goto yy53;
	goto yy220;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy221;
	if(yych != 'y')	goto yy53;
	goto yy221;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy185;
	if(yych == 's')	goto yy185;
	goto yy181;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy193;
	if(yych == 'y')	goto yy193;
	goto yy53;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy224;
	if(yych != 'u')	goto yy53;
	goto yy224;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy193;
	if(yych == 'r')	goto yy193;
	goto yy53;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy230;
	if(yych == 'n')	goto yy230;
	goto yy53;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy227;
	if(yych != 'n')	goto yy53;
	goto yy227;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych == 'S')	goto yy185;
		if(yych <= 'T')	goto yy181;
		goto yy228;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy181;
			goto yy185;
		} else {
			if(yych != 'u')	goto yy181;
			goto yy228;
		}
	}
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy229;
	if(yych != 't')	goto yy53;
	goto yy229;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy193;
	if(yych == 'e')	goto yy193;
	goto yy53;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == 'D')	goto yy231;
		if(yych <= 'S')	goto yy181;
		goto yy232;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy181;
			goto yy231;
		} else {
			if(yych == 't')	goto yy232;
			goto yy181;
		}
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy233;
	if(yych == 'a')	goto yy233;
	goto yy53;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy193;
	if(yych == 'h')	goto yy193;
	goto yy53;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych == 'y')	goto yy185;
	goto yy53;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy245;
	if(yych == 'n')	goto yy245;
	goto yy53;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy240;
	if(yych == 't')	goto yy240;
	goto yy53;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy237;
	if(yych != 'c')	goto yy53;
	goto yy237;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == 'O')	goto yy238;
		if(yych <= 'R')	goto yy181;
		goto yy185;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy181;
			goto yy238;
		} else {
			if(yych == 's')	goto yy185;
			goto yy181;
		}
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy239;
	if(yych != 'n')	goto yy53;
	goto yy239;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy193;
	if(yych == 'd')	goto yy193;
	goto yy53;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy241;
	if(yych != 'u')	goto yy181;
	goto yy241;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy242;
	if(yych != 'r')	goto yy53;
	goto yy242;
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy243;
	if(yych != 'd')	goto yy53;
	goto yy243;
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy244;
	if(yych != 'a')	goto yy53;
	goto yy244;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych == 'y')	goto yy185;
	goto yy53;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy246;
	if(yych != 'd')	goto yy181;
	goto yy246;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy247;
	if(yych != 'a')	goto yy53;
	goto yy247;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy185;
	if(yych == 'y')	goto yy185;
	goto yy53;
yy248:
	YYDEBUG(248, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy162;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy249;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy139;
			goto yy163;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy250;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy140;
			goto yy164;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy251;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy251:
	YYDEBUG(251, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy141;
			goto yy165;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy252;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'T')	goto yy3;
			goto yy166;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy253;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy167;
	if(yych != 's')	goto yy152;
	goto yy254;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.'){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy53;
			goto yy168;
		} else {
			if(yych == ' ')	goto yy168;
			goto yy53;
		}
	} else {
		if(yych <= '_'){
			if(yych <= '/')	goto yy144;
			if(yych <= '^')	goto yy53;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy53;
			if(yych <= 'z')	goto yy151;
			goto yy53;
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy138;
			goto yy256;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 's')	goto yy256;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy257;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy257;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '('){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy3;
			goto yy168;
		} else {
			if(yych == ' ')	goto yy168;
			goto yy3;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy140;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy138;
			goto yy256;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 's')	goto yy259;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy257;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy260;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy168;
			goto yy3;
		} else {
			if(yych <= ' ')	goto yy168;
			if(yych == ')')	goto yy136;
			goto yy3;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Z')	goto yy140;
			goto yy3;
		} else {
			if(yych <= '_')	goto yy144;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy138;
			goto yy268;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'g')	goto yy268;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy263;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'e')	goto yy263;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy139;
			goto yy264;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'v')	goto yy264;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy140;
			goto yy265;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'e')	goto yy265;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy141;
			goto yy266;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'n')	goto yy266;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy267;
		if(yych != 't')	goto yy3;
		goto yy267;
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy167;
	if(yych == 'h')	goto yy167;
	goto yy53;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy139;
			goto yy269;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'h')	goto yy269;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 't')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '('){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy3;
			goto yy168;
		} else {
			if(yych == ' ')	goto yy168;
			goto yy3;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy141;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy138;
			goto yy268;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy278;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy263;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy273;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy139;
			goto yy264;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy274;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy140;
			goto yy265;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy275;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy141;
			goto yy266;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy276;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'S')	goto yy3;
			goto yy267;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy277;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy167;
	if(yych == 'h')	goto yy254;
	goto yy152;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy139;
			goto yy269;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy279;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy168;
			goto yy3;
		} else {
			if(yych <= ' ')	goto yy168;
			if(yych == ')')	goto yy136;
			goto yy3;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Z')	goto yy141;
			goto yy3;
		} else {
			if(yych <= '_')	goto yy144;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= 'C')	goto yy138;
			if(yych >= 'E')	goto yy284;
			goto yy282;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'd')	goto yy282;
			if(yych <= 'e')	goto yy284;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'N'){
		if(yych <= ')'){
			if(yych >= ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'M')	goto yy139;
			goto yy290;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy139;
			if(yych >= 'a')	goto yy139;
			goto yy283;
		} else {
			if(yych <= 'n')	goto yy290;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);

{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'K'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'J')	goto yy139;
			goto yy285;
		}
	} else {
		if(yych <= 'j'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'k')	goto yy285;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy140;
			goto yy286;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'd')	goto yy286;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy287;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy287;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Y')	goto yy288;
		if(yych != 'y')	goto yy3;
		goto yy288;
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy289;
	if(yych != 's')	goto yy283;
	goto yy289;
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy283;
yy290:
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy140;
			goto yy291;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'e')	goto yy291;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy141;
			goto yy292;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 's')	goto yy292;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'D')	goto yy293;
		if(yych != 'd')	goto yy3;
		goto yy293;
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy294;
	if(yych != 'a')	goto yy53;
	goto yy294;
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy289;
	if(yych == 'y')	goto yy289;
	goto yy53;
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy138;
			if(yych <= 'D')	goto yy282;
			goto yy284;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych <= 'd'){
				if(yych <= 'c')	goto yy143;
				goto yy296;
			} else {
				if(yych <= 'e')	goto yy297;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'M')	goto yy139;
			goto yy290;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 'n')	goto yy303;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'K'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'J')	goto yy139;
			goto yy285;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'k')	goto yy298;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy140;
			goto yy286;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy299;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy287;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy300;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'X')	goto yy3;
			goto yy288;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy301;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy283;
			goto yy144;
		} else {
			if(yych == 'S')	goto yy289;
			goto yy283;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy144;
			if(yych <= '`')	goto yy283;
			goto yy151;
		} else {
			if(yych <= 's')	goto yy302;
			if(yych <= 'z')	goto yy151;
			goto yy283;
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy144;
		goto yy283;
	} else {
		if(yych <= '_')	goto yy144;
		if(yych <= '`')	goto yy283;
		if(yych <= 'z')	goto yy151;
		goto yy283;
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy140;
			goto yy291;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy304;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy141;
			goto yy292;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 's')	goto yy305;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'C')	goto yy3;
			goto yy293;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy306;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy294;
	if(yych != 'a')	goto yy152;
	goto yy307;
yy307:
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy289;
	if(yych == 'y')	goto yy302;
	goto yy152;
yy308:
	YYDEBUG(308, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy138;
			goto yy309;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'c')	goto yy309;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych >= 0x09)	goto yy312;
				goto yy310;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych == 'E')	goto yy318;
				goto yy139;
			}
		} else {
			if(yych <= 'd'){
				if(yych >= 'a')	goto yy139;
				goto yy310;
			} else {
				if(yych <= 'e')	goto yy318;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);

{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
	yych = *YYCURSOR;
	goto yy312;
yy312:
	YYDEBUG(312, *YYCURSOR);
	if(yybm[0+yych] & 64) {
		goto yy311;
	}
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy314;
	if(yych <= '3')	goto yy316;
	if(yych <= '9')	goto yy317;
	goto yy53;
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy312;
	if(yych <= '0')	goto yy473;
	if(yych <= '2')	goto yy474;
	if(yych <= '3')	goto yy475;
	goto yy312;
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy332;
			if(yych <= '0')	goto yy412;
			goto yy413;
		} else {
			if(yych <= '2')	goto yy471;
			if(yych <= '9')	goto yy472;
			goto yy332;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy328;
			if(yych <= 'q')	goto yy332;
			goto yy329;
		} else {
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);

{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy332;
			if(yych <= '0')	goto yy412;
			goto yy413;
		} else {
			if(yych <= '2')	goto yy325;
			if(yych <= '9')	goto yy326;
			goto yy332;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy328;
			if(yych <= 'q')	goto yy332;
			goto yy329;
		} else {
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy332;
			if(yych <= '0')	goto yy323;
			goto yy324;
		} else {
			if(yych <= '2')	goto yy325;
			if(yych <= '9')	goto yy326;
			goto yy332;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy328;
			if(yych <= 'q')	goto yy332;
			goto yy329;
		} else {
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'L')	goto yy140;
			goto yy319;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'm')	goto yy319;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy141;
			goto yy320;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'b')	goto yy320;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy321;
		if(yych != 'e')	goto yy3;
		goto yy321;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy322;
	if(yych != 'r')	goto yy53;
	goto yy322;
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ' '){
		if(yych == 0x09)	goto yy312;
		if(yych <= 0x1F)	goto yy310;
		goto yy312;
	} else {
		if(yych <= '.'){
			if(yych <= ',')	goto yy310;
			goto yy312;
		} else {
			if(yych <= '/')	goto yy310;
			if(yych <= '9')	goto yy312;
			goto yy310;
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy315;
	} else {
		if(yych <= '0')	goto yy410;
		if(yych <= '9')	goto yy411;
		if(yych <= ':')	goto yy337;
		goto yy315;
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '2')	goto yy411;
		if(yych <= '9')	goto yy410;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '3')	goto yy410;
		if(yych <= '9')	goto yy407;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy407;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy332;
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy332;
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy332;
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy332;
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
	goto yy332;
yy332:
	YYDEBUG(332, *YYCURSOR);
	if(yybm[0+yych] & 128) {
		goto yy331;
	}
	if(yych <= '2'){
		if(yych <= '/')	goto yy315;
		if(yych <= '0')	goto yy373;
		if(yych <= '1')	goto yy374;
		goto yy375;
	} else {
		if(yych <= '9')	goto yy376;
		if(yych != 'T')	goto yy315;
		goto yy333;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy334;
	if(yych <= '2')	goto yy335;
	if(yych <= '9')	goto yy336;
	goto yy53;
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy53;
	} else {
		if(yych <= '9')	goto yy336;
		if(yych <= ':')	goto yy337;
		goto yy53;
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy53;
	} else {
		if(yych <= '3')	goto yy336;
		if(yych == ':')	goto yy337;
		goto yy53;
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy337;
	if(yych != ':')	goto yy53;
	goto yy337;
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy338;
	if(yych <= '9')	goto yy340;
	goto yy53;
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy341;
		goto yy339;
	} else {
		if(yych <= '9')	goto yy340;
		if(yych <= ':')	goto yy341;
		goto yy339;
	}
yy339:
	YYDEBUG(339, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy341;
	if(yych != ':')	goto yy339;
	goto yy341;
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy342;
	if(yych <= '6')	goto yy343;
	if(yych <= '9')	goto yy344;
	goto yy53;
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy339;
	if(yych <= '9')	goto yy345;
	goto yy339;
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy345;
	goto yy339;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy339;
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '*'){
		if(yych <= 0x1F){
			if(yych != 0x09)	goto yy339;
			goto yy346;
		} else {
			if(yych <= ' ')	goto yy346;
			if(yych == '(')	goto yy349;
			goto yy339;
		}
	} else {
		if(yych <= '@'){
			if(yych == ',')	goto yy339;
			if(yych <= '-')	goto yy348;
			goto yy339;
		} else {
			if(yych <= 'Z')	goto yy350;
			if(yych <= '`')	goto yy339;
			if(yych <= 'z')	goto yy351;
			goto yy339;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	goto yy347;
yy347:
	YYDEBUG(347, *YYCURSOR);
	if(yych <= '*'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy346;
			goto yy53;
		} else {
			if(yych <= ' ')	goto yy346;
			if(yych == '(')	goto yy349;
			goto yy53;
		}
	} else {
		if(yych <= '@'){
			if(yych == ',')	goto yy53;
			if(yych >= '.')	goto yy53;
			goto yy348;
		} else {
			if(yych <= 'Z')	goto yy350;
			if(yych <= '`')	goto yy53;
			if(yych <= 'z')	goto yy351;
			goto yy53;
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy368;
	if(yych <= '2')	goto yy369;
	if(yych <= '9')	goto yy370;
	goto yy53;
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@')	goto yy53;
	if(yych <= 'Z')	goto yy351;
	if(yych <= '`')	goto yy53;
	if(yych <= 'z')	goto yy351;
	goto yy53;
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy344;
		goto yy339;
	} else {
		if(yych <= 'Z')	goto yy352;
		if(yych <= '`')	goto yy339;
		if(yych <= 'z')	goto yy357;
		goto yy339;
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy344;
		goto yy339;
	} else {
		if(yych <= 'Z')	goto yy352;
		if(yych <= '`')	goto yy339;
		if(yych >= '{')	goto yy339;
		goto yy352;
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy344;
		goto yy339;
	} else {
		if(yych <= 'Z')	goto yy353;
		if(yych <= '`')	goto yy339;
		if(yych >= '{')	goto yy339;
		goto yy353;
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy344;
		goto yy339;
	} else {
		if(yych <= 'Z')	goto yy354;
		if(yych <= '`')	goto yy339;
		if(yych >= '{')	goto yy339;
		goto yy354;
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy344;
		goto yy339;
	} else {
		if(yych <= 'Z')	goto yy355;
		if(yych <= '`')	goto yy339;
		if(yych >= '{')	goto yy339;
		goto yy355;
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy344;
		goto yy339;
	} else {
		if(yych <= 'Z')	goto yy356;
		if(yych <= '`')	goto yy339;
		if(yych >= '{')	goto yy339;
		goto yy356;
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy344;
	goto yy339;
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy339;
			goto yy344;
		} else {
			if(yych == '/')	goto yy359;
			goto yy339;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy353;
			if(yych <= '^')	goto yy339;
			goto yy359;
		} else {
			if(yych <= '`')	goto yy339;
			if(yych >= '{')	goto yy339;
			goto yy358;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy339;
			goto yy344;
		} else {
			if(yych != '/')	goto yy339;
			goto yy359;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy354;
			if(yych <= '^')	goto yy339;
			goto yy359;
		} else {
			if(yych <= '`')	goto yy339;
			if(yych <= 'z')	goto yy363;
			goto yy339;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@')	goto yy53;
	if(yych >= '[')	goto yy53;
	goto yy360;
yy360:
	YYDEBUG(360, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '`')	goto yy53;
	if(yych >= '{')	goto yy53;
	goto yy361;
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 8;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy362;
yy362:
	YYDEBUG(362, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy359;
		goto yy339;
	} else {
		if(yych <= '_')	goto yy359;
		if(yych <= '`')	goto yy339;
		if(yych <= 'z')	goto yy361;
		goto yy339;
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy339;
			goto yy344;
		} else {
			if(yych == '/')	goto yy359;
			goto yy339;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy355;
			if(yych <= '^')	goto yy339;
			goto yy359;
		} else {
			if(yych <= '`')	goto yy339;
			if(yych >= '{')	goto yy339;
			goto yy364;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy339;
			goto yy344;
		} else {
			if(yych == '/')	goto yy359;
			goto yy339;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy356;
			if(yych <= '^')	goto yy339;
			goto yy359;
		} else {
			if(yych <= '`')	goto yy339;
			if(yych >= '{')	goto yy339;
			goto yy365;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy344;
		if(yych <= '.')	goto yy339;
		goto yy359;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy339;
			goto yy359;
		} else {
			if(yych <= '`')	goto yy339;
			if(yych >= '{')	goto yy339;
			goto yy366;
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy367;
yy367:
	YYDEBUG(367, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy359;
		goto yy53;
	} else {
		if(yych <= '_')	goto yy359;
		if(yych <= '`')	goto yy53;
		if(yych <= 'z')	goto yy366;
		goto yy53;
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy339;
	if(yych <= '9')	goto yy370;
	if(yych <= ':')	goto yy371;
	goto yy339;
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy339;
		if(yych >= '4')	goto yy372;
		goto yy370;
	} else {
		if(yych <= '9')	goto yy344;
		if(yych <= ':')	goto yy371;
		goto yy339;
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy339;
	if(yych <= '5')	goto yy372;
	if(yych <= '9')	goto yy344;
	if(yych >= ';')	goto yy339;
	goto yy371;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy339;
	if(yych <= '5')	goto yy372;
	if(yych <= '9')	goto yy344;
	goto yy339;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy339;
	if(yych <= '9')	goto yy344;
	goto yy339;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy315;
	} else {
		if(yych <= '0')	goto yy405;
		if(yych <= '9')	goto yy406;
		if(yych <= ':')	goto yy337;
		goto yy315;
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '2')	goto yy406;
		if(yych <= '9')	goto yy405;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '3')	goto yy405;
		if(yych <= '9')	goto yy377;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy377;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy315;
	if(yych <= '9')	goto yy403;
	goto yy315;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy379;
	if(yych <= '9')	goto yy380;
	goto yy53;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy381;
		goto yy339;
	} else {
		if(yych <= '9')	goto yy396;
		if(yych <= ':')	goto yy381;
		goto yy339;
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy381;
	if(yych != ':')	goto yy339;
	goto yy381;
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy382;
	if(yych <= '6')	goto yy383;
	if(yych <= '9')	goto yy344;
	goto yy53;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy339;
	if(yych <= '9')	goto yy384;
	goto yy339;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy339;
	goto yy384;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '*'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy386;
			goto yy339;
		} else {
			if(yych <= ' ')	goto yy386;
			if(yych == '(')	goto yy386;
			goto yy339;
		}
	} else {
		if(yych <= '@'){
			if(yych == ',')	goto yy339;
			if(yych <= '-')	goto yy386;
			goto yy339;
		} else {
			if(yych <= 'Z')	goto yy386;
			if(yych <= '`')	goto yy339;
			if(yych <= 'z')	goto yy386;
			goto yy339;
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	goto yy386;
yy386:
	YYDEBUG(386, *YYCURSOR);
	if(yych <= '-'){
		if(yych <= '\''){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy53;
				goto yy385;
			} else {
				if(yych == ' ')	goto yy385;
				goto yy53;
			}
		} else {
			if(yych <= '*'){
				if(yych <= '(')	goto yy349;
				goto yy53;
			} else {
				if(yych == ',')	goto yy53;
				goto yy348;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= 'A'){
				if(yych <= '@')	goto yy53;
				goto yy387;
			} else {
				if(yych != 'P')	goto yy350;
				goto yy387;
			}
		} else {
			if(yych <= 'o'){
				if(yych <= '`')	goto yy53;
				if(yych <= 'a')	goto yy388;
				goto yy351;
			} else {
				if(yych <= 'p')	goto yy388;
				if(yych <= 'z')	goto yy351;
				goto yy53;
			}
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '-'){
			if(yych == ')')	goto yy344;
			goto yy339;
		} else {
			if(yych <= '.')	goto yy389;
			if(yych <= '@')	goto yy339;
			goto yy352;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'M')	goto yy390;
			if(yych <= 'Z')	goto yy352;
			goto yy339;
		} else {
			if(yych == 'm')	goto yy395;
			if(yych <= 'z')	goto yy357;
			goto yy339;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '-'){
			if(yych == ')')	goto yy344;
			goto yy339;
		} else {
			if(yych <= '.')	goto yy389;
			if(yych <= '@')	goto yy339;
			goto yy352;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'M')	goto yy390;
			if(yych <= 'Z')	goto yy352;
			goto yy339;
		} else {
			if(yych == 'm')	goto yy390;
			if(yych <= 'z')	goto yy352;
			goto yy339;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy394;
	if(yych == 'm')	goto yy394;
	goto yy53;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ')'){
		if(yych <= 0x09){
			if(yych <= 0x00)	goto yy392;
			if(yych <= 0x08)	goto yy339;
			goto yy392;
		} else {
			if(yych == ' ')	goto yy392;
			if(yych <= '(')	goto yy339;
			goto yy344;
		}
	} else {
		if(yych <= '@'){
			if(yych != '.')	goto yy339;
			goto yy391;
		} else {
			if(yych <= 'Z')	goto yy353;
			if(yych <= '`')	goto yy339;
			if(yych <= 'z')	goto yy353;
			goto yy339;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x09){
		if(yych <= 0x00)	goto yy392;
		if(yych <= 0x08)	goto yy53;
		goto yy392;
	} else {
		if(yych != ' ')	goto yy53;
		goto yy392;
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	++YYCURSOR;
	goto yy393;
yy393:
	YYDEBUG(393, *YYCURSOR);

{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x1F){
		if(yych <= 0x00)	goto yy392;
		if(yych == 0x09)	goto yy392;
		goto yy53;
	} else {
		if(yych <= ' ')	goto yy392;
		if(yych == '.')	goto yy391;
		goto yy53;
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= 0x1F){
			if(yych <= 0x00)	goto yy392;
			if(yych == 0x09)	goto yy392;
			goto yy339;
		} else {
			if(yych <= ' ')	goto yy392;
			if(yych == ')')	goto yy344;
			goto yy339;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '.')	goto yy391;
			if(yych <= '/')	goto yy359;
			if(yych <= '@')	goto yy339;
			goto yy353;
		} else {
			if(yych <= '_'){
				if(yych <= '^')	goto yy339;
				goto yy359;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy358;
				goto yy339;
			}
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy397;
			if(yych <= 0x1F)	goto yy339;
			goto yy397;
		} else {
			if(yych == '.')	goto yy381;
			if(yych <= '9')	goto yy339;
			goto yy381;
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy399;
			if(yych <= 'O')	goto yy339;
			goto yy399;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy339;
				goto yy399;
			} else {
				if(yych == 'p')	goto yy399;
				goto yy339;
			}
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	goto yy398;
yy398:
	YYDEBUG(398, *YYCURSOR);
	if(yych <= 'A'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy397;
			goto yy53;
		} else {
			if(yych <= ' ')	goto yy397;
			if(yych <= '@')	goto yy53;
			goto yy399;
		}
	} else {
		if(yych <= '`'){
			if(yych != 'P')	goto yy53;
			goto yy399;
		} else {
			if(yych <= 'a')	goto yy399;
			if(yych != 'p')	goto yy53;
			goto yy399;
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy400;
	} else {
		if(yych <= 'M')	goto yy401;
		if(yych == 'm')	goto yy401;
		goto yy53;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy401;
	if(yych != 'm')	goto yy53;
	goto yy401;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x1F){
		if(yych <= 0x00)	goto yy392;
		if(yych == 0x09)	goto yy392;
		goto yy53;
	} else {
		if(yych <= ' ')	goto yy392;
		if(yych != '.')	goto yy53;
		goto yy402;
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x09){
		if(yych <= 0x00)	goto yy392;
		if(yych <= 0x08)	goto yy53;
		goto yy392;
	} else {
		if(yych == ' ')	goto yy392;
		goto yy53;
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy315;
	if(yych >= ':')	goto yy315;
	goto yy404;
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy315;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych <= ':')	goto yy337;
		goto yy315;
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy315;
	if(yych >= ':')	goto yy315;
	goto yy408;
yy408:
	YYDEBUG(408, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy409;
	if(yych <= '9')	goto yy404;
	goto yy409;
yy409:
	YYDEBUG(409, *YYCURSOR);

{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy408;
		if(yych <= ':')	goto yy337;
		goto yy315;
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy408;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych == '.')	goto yy447;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy448;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy337;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych != '.')	goto yy332;
			goto yy414;
		} else {
			if(yych <= '0')	goto yy415;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy378;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '1'){
		if(yych <= '/')	goto yy332;
		if(yych <= '0')	goto yy422;
		goto yy423;
	} else {
		if(yych <= '2')	goto yy424;
		if(yych <= '5')	goto yy425;
		if(yych <= '9')	goto yy426;
		goto yy332;
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '0')	goto yy420;
		if(yych <= '9')	goto yy421;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '2')	goto yy421;
		if(yych <= '9')	goto yy420;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '3')	goto yy420;
		if(yych <= '9')	goto yy419;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy419;
		if(yych <= ':')	goto yy378;
		goto yy315;
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy409;
	if(yych <= '9')	goto yy403;
	goto yy409;
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy409;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych <= ':')	goto yy337;
		goto yy409;
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy378;
		goto yy409;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych <= ':')	goto yy378;
		goto yy409;
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy442;
		goto yy315;
	} else {
		if(yych <= '0')	goto yy441;
		if(yych <= '9')	goto yy446;
		if(yych <= ':')	goto yy442;
		goto yy315;
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy427;
		goto yy315;
	} else {
		if(yych <= '2')	goto yy446;
		if(yych <= '9')	goto yy441;
		if(yych <= ':')	goto yy427;
		goto yy315;
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy427;
		goto yy315;
	} else {
		if(yych <= '3')	goto yy441;
		if(yych <= '9')	goto yy440;
		if(yych <= ':')	goto yy427;
		goto yy315;
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy427;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy440;
		if(yych <= ':')	goto yy427;
		goto yy315;
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych != '.')	goto yy315;
		goto yy427;
	} else {
		if(yych <= '9')	goto yy377;
		if(yych >= ';')	goto yy315;
		goto yy427;
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy428;
	if(yych <= '6')	goto yy429;
	if(yych <= '9')	goto yy380;
	goto yy53;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy381;
		goto yy339;
	} else {
		if(yych <= '9')	goto yy430;
		if(yych <= ':')	goto yy381;
		goto yy339;
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy381;
		goto yy339;
	} else {
		if(yych <= '0')	goto yy384;
		if(yych == ':')	goto yy381;
		goto yy339;
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy432;
			if(yych <= 0x1F)	goto yy339;
			goto yy432;
		} else {
			if(yych <= '('){
				if(yych <= '\'')	goto yy339;
				goto yy432;
			} else {
				if(yych == '+')	goto yy432;
				goto yy339;
			}
		}
	} else {
		if(yych <= ':'){
			if(yych <= '-')	goto yy432;
			if(yych <= '.')	goto yy381;
			if(yych <= '9')	goto yy339;
			goto yy381;
		} else {
			if(yych <= 'Z'){
				if(yych <= '@')	goto yy339;
				goto yy432;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy432;
				goto yy339;
			}
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	goto yy432;
yy432:
	YYDEBUG(432, *YYCURSOR);
	if(yych <= '-'){
		if(yych <= '\''){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy53;
				goto yy431;
			} else {
				if(yych == ' ')	goto yy431;
				goto yy53;
			}
		} else {
			if(yych <= '*'){
				if(yych <= '(')	goto yy349;
				goto yy53;
			} else {
				if(yych == ',')	goto yy53;
				goto yy348;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= 'A'){
				if(yych <= '@')	goto yy53;
				goto yy433;
			} else {
				if(yych != 'P')	goto yy350;
				goto yy433;
			}
		} else {
			if(yych <= 'o'){
				if(yych <= '`')	goto yy53;
				if(yych <= 'a')	goto yy434;
				goto yy351;
			} else {
				if(yych <= 'p')	goto yy434;
				if(yych <= 'z')	goto yy351;
				goto yy53;
			}
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '-'){
			if(yych == ')')	goto yy344;
			goto yy339;
		} else {
			if(yych <= '.')	goto yy436;
			if(yych <= '@')	goto yy339;
			goto yy352;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'M')	goto yy435;
			if(yych <= 'Z')	goto yy352;
			goto yy339;
		} else {
			if(yych == 'm')	goto yy439;
			if(yych <= 'z')	goto yy357;
			goto yy339;
		}
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '-'){
			if(yych == ')')	goto yy344;
			goto yy339;
		} else {
			if(yych <= '.')	goto yy436;
			if(yych <= '@')	goto yy339;
			goto yy352;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'M')	goto yy435;
			if(yych <= 'Z')	goto yy352;
			goto yy339;
		} else {
			if(yych == 'm')	goto yy435;
			if(yych <= 'z')	goto yy352;
			goto yy339;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ')'){
		if(yych <= 0x09){
			if(yych <= 0x00)	goto yy392;
			if(yych <= 0x08)	goto yy339;
			goto yy392;
		} else {
			if(yych == ' ')	goto yy392;
			if(yych <= '(')	goto yy339;
			goto yy344;
		}
	} else {
		if(yych <= '@'){
			if(yych == '.')	goto yy438;
			goto yy339;
		} else {
			if(yych <= 'Z')	goto yy353;
			if(yych <= '`')	goto yy339;
			if(yych <= 'z')	goto yy353;
			goto yy339;
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy437;
	if(yych != 'm')	goto yy53;
	goto yy437;
yy437:
	YYDEBUG(437, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x1F){
		if(yych <= 0x00)	goto yy392;
		if(yych == 0x09)	goto yy392;
		goto yy53;
	} else {
		if(yych <= ' ')	goto yy392;
		if(yych != '.')	goto yy53;
		goto yy438;
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x09){
		if(yych <= 0x00)	goto yy392;
		if(yych <= 0x08)	goto yy53;
		goto yy392;
	} else {
		if(yych == ' ')	goto yy392;
		goto yy53;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= 0x1F){
			if(yych <= 0x00)	goto yy392;
			if(yych == 0x09)	goto yy392;
			goto yy339;
		} else {
			if(yych <= ' ')	goto yy392;
			if(yych == ')')	goto yy344;
			goto yy339;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '.')	goto yy438;
			if(yych <= '/')	goto yy359;
			if(yych <= '@')	goto yy339;
			goto yy353;
		} else {
			if(yych <= '_'){
				if(yych <= '^')	goto yy339;
				goto yy359;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy358;
				goto yy339;
			}
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy397;
			if(yych <= 0x1F)	goto yy315;
			goto yy397;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy315;
				goto yy381;
			} else {
				if(yych <= '/')	goto yy315;
				if(yych <= '9')	goto yy403;
				goto yy381;
			}
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy399;
			if(yych <= 'O')	goto yy315;
			goto yy399;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy315;
				goto yy399;
			} else {
				if(yych == 'p')	goto yy399;
				goto yy315;
			}
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy397;
			if(yych <= 0x1F)	goto yy315;
			goto yy397;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy315;
				goto yy442;
			} else {
				if(yych <= '/')	goto yy315;
				if(yych <= '9')	goto yy403;
				goto yy442;
			}
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy399;
			if(yych <= 'O')	goto yy315;
			goto yy399;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy315;
				goto yy399;
			} else {
				if(yych == 'p')	goto yy399;
				goto yy315;
			}
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy443;
	if(yych <= '6')	goto yy444;
	if(yych <= '9')	goto yy340;
	goto yy53;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy341;
		goto yy339;
	} else {
		if(yych <= '9')	goto yy445;
		if(yych <= ':')	goto yy341;
		goto yy339;
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy341;
		goto yy339;
	} else {
		if(yych <= '0')	goto yy384;
		if(yych == ':')	goto yy341;
		goto yy339;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy386;
			if(yych <= 0x1F)	goto yy339;
			goto yy386;
		} else {
			if(yych <= '('){
				if(yych <= '\'')	goto yy339;
				goto yy386;
			} else {
				if(yych == '+')	goto yy386;
				goto yy339;
			}
		}
	} else {
		if(yych <= ':'){
			if(yych <= '-')	goto yy386;
			if(yych <= '.')	goto yy341;
			if(yych <= '9')	goto yy339;
			goto yy341;
		} else {
			if(yych <= 'Z'){
				if(yych <= '@')	goto yy339;
				goto yy386;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy386;
				goto yy339;
			}
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy397;
			if(yych <= 0x1F)	goto yy315;
			goto yy397;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy315;
				goto yy427;
			} else {
				if(yych <= '/')	goto yy315;
				if(yych <= '9')	goto yy403;
				goto yy427;
			}
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy399;
			if(yych <= 'O')	goto yy315;
			goto yy399;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy315;
				goto yy399;
			} else {
				if(yych == 'p')	goto yy399;
				goto yy315;
			}
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '1'){
		if(yych <= '/')	goto yy332;
		if(yych <= '0')	goto yy449;
		goto yy450;
	} else {
		if(yych <= '2')	goto yy451;
		if(yych <= '5')	goto yy452;
		if(yych <= '9')	goto yy453;
		goto yy332;
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy337;
		goto yy315;
	} else {
		if(yych <= '0')	goto yy420;
		if(yych <= '9')	goto yy421;
		if(yych <= ':')	goto yy337;
		goto yy315;
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy466;
		goto yy315;
	} else {
		if(yych <= '0')	goto yy465;
		if(yych <= '9')	goto yy470;
		if(yych <= ':')	goto yy466;
		goto yy315;
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy454;
		goto yy315;
	} else {
		if(yych <= '2')	goto yy470;
		if(yych <= '9')	goto yy465;
		if(yych <= ':')	goto yy454;
		goto yy315;
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy454;
		goto yy315;
	} else {
		if(yych <= '3')	goto yy465;
		if(yych <= '9')	goto yy464;
		if(yych <= ':')	goto yy454;
		goto yy315;
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy454;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy464;
		if(yych <= ':')	goto yy454;
		goto yy315;
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych != '.')	goto yy315;
		goto yy454;
	} else {
		if(yych <= '9')	goto yy377;
		if(yych >= ';')	goto yy315;
		goto yy454;
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy455;
	if(yych <= '6')	goto yy456;
	if(yych <= '9')	goto yy380;
	goto yy53;
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy381;
		goto yy339;
	} else {
		if(yych <= '9')	goto yy457;
		if(yych <= ':')	goto yy381;
		goto yy339;
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy381;
		goto yy339;
	} else {
		if(yych <= '0')	goto yy345;
		if(yych == ':')	goto yy381;
		goto yy339;
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy459;
			if(yych <= 0x1F)	goto yy339;
			goto yy459;
		} else {
			if(yych <= '('){
				if(yych <= '\'')	goto yy339;
				goto yy459;
			} else {
				if(yych == '+')	goto yy459;
				goto yy339;
			}
		}
	} else {
		if(yych <= ':'){
			if(yych <= '-')	goto yy459;
			if(yych <= '.')	goto yy381;
			if(yych <= '9')	goto yy339;
			goto yy381;
		} else {
			if(yych <= 'Z'){
				if(yych <= '@')	goto yy339;
				goto yy459;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy459;
				goto yy339;
			}
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	goto yy459;
yy459:
	YYDEBUG(459, *YYCURSOR);
	if(yych <= '-'){
		if(yych <= '\''){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy53;
				goto yy458;
			} else {
				if(yych == ' ')	goto yy458;
				goto yy53;
			}
		} else {
			if(yych <= '*'){
				if(yych <= '(')	goto yy349;
				goto yy53;
			} else {
				if(yych == ',')	goto yy53;
				goto yy348;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= 'A'){
				if(yych <= '@')	goto yy53;
				goto yy460;
			} else {
				if(yych != 'P')	goto yy350;
				goto yy460;
			}
		} else {
			if(yych <= 'o'){
				if(yych <= '`')	goto yy53;
				if(yych <= 'a')	goto yy461;
				goto yy351;
			} else {
				if(yych <= 'p')	goto yy461;
				if(yych <= 'z')	goto yy351;
				goto yy53;
			}
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '-'){
			if(yych == ')')	goto yy344;
			goto yy339;
		} else {
			if(yych <= '.')	goto yy400;
			if(yych <= '@')	goto yy339;
			goto yy352;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'M')	goto yy462;
			if(yych <= 'Z')	goto yy352;
			goto yy339;
		} else {
			if(yych == 'm')	goto yy463;
			if(yych <= 'z')	goto yy357;
			goto yy339;
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '-'){
			if(yych == ')')	goto yy344;
			goto yy339;
		} else {
			if(yych <= '.')	goto yy400;
			if(yych <= '@')	goto yy339;
			goto yy352;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'M')	goto yy462;
			if(yych <= 'Z')	goto yy352;
			goto yy339;
		} else {
			if(yych == 'm')	goto yy462;
			if(yych <= 'z')	goto yy352;
			goto yy339;
		}
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ')'){
		if(yych <= 0x09){
			if(yych <= 0x00)	goto yy392;
			if(yych <= 0x08)	goto yy339;
			goto yy392;
		} else {
			if(yych == ' ')	goto yy392;
			if(yych <= '(')	goto yy339;
			goto yy344;
		}
	} else {
		if(yych <= '@'){
			if(yych == '.')	goto yy402;
			goto yy339;
		} else {
			if(yych <= 'Z')	goto yy353;
			if(yych <= '`')	goto yy339;
			if(yych <= 'z')	goto yy353;
			goto yy339;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= 0x1F){
			if(yych <= 0x00)	goto yy392;
			if(yych == 0x09)	goto yy392;
			goto yy339;
		} else {
			if(yych <= ' ')	goto yy392;
			if(yych == ')')	goto yy344;
			goto yy339;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '.')	goto yy402;
			if(yych <= '/')	goto yy359;
			if(yych <= '@')	goto yy339;
			goto yy353;
		} else {
			if(yych <= '_'){
				if(yych <= '^')	goto yy339;
				goto yy359;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy358;
				goto yy339;
			}
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy341;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych <= ':')	goto yy341;
		goto yy315;
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych != '.')	goto yy315;
		goto yy466;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych >= ';')	goto yy315;
		goto yy466;
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy467;
	if(yych <= '6')	goto yy468;
	if(yych <= '9')	goto yy340;
	goto yy53;
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy341;
		goto yy339;
	} else {
		if(yych <= '9')	goto yy469;
		if(yych <= ':')	goto yy341;
		goto yy339;
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy341;
		goto yy339;
	} else {
		if(yych <= '0')	goto yy345;
		if(yych == ':')	goto yy341;
		goto yy339;
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy346;
			if(yych <= 0x1F)	goto yy339;
			goto yy346;
		} else {
			if(yych <= '('){
				if(yych <= '\'')	goto yy339;
				goto yy349;
			} else {
				if(yych == '+')	goto yy348;
				goto yy339;
			}
		}
	} else {
		if(yych <= ':'){
			if(yych <= '-')	goto yy348;
			if(yych <= '.')	goto yy341;
			if(yych <= '9')	goto yy339;
			goto yy341;
		} else {
			if(yych <= 'Z'){
				if(yych <= '@')	goto yy339;
				goto yy350;
			} else {
				if(yych <= '`')	goto yy339;
				if(yych <= 'z')	goto yy351;
				goto yy339;
			}
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy454;
		goto yy315;
	} else {
		if(yych <= '9')	goto yy403;
		if(yych <= ':')	goto yy454;
		goto yy315;
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych == '.')	goto yy414;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy448;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy378;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych == '.')	goto yy414;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy448;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy378;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy332;
			if(yych <= '0')	goto yy412;
			goto yy477;
		} else {
			if(yych <= '2')	goto yy484;
			if(yych <= '9')	goto yy485;
			goto yy332;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy328;
			if(yych <= 'q')	goto yy332;
			goto yy329;
		} else {
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy332;
			if(yych <= '0')	goto yy476;
			goto yy477;
		} else {
			if(yych <= '2')	goto yy484;
			if(yych <= '9')	goto yy485;
			goto yy332;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy328;
			if(yych <= 'q')	goto yy332;
			goto yy329;
		} else {
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy332;
			if(yych >= '1')	goto yy477;
			goto yy476;
		} else {
			if(yych <= '2')	goto yy325;
			if(yych <= '9')	goto yy326;
			goto yy332;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy328;
			if(yych <= 'q')	goto yy332;
			goto yy329;
		} else {
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych <= ',')	goto yy332;
			if(yych <= '-')	goto yy478;
			if(yych <= '.')	goto yy447;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy448;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy337;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych <= ',')	goto yy332;
			if(yych <= '-')	goto yy478;
			if(yych <= '.')	goto yy414;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy415;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy378;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy479;
yy479:
	YYDEBUG(479, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy480;
	if(yych <= '9')	goto yy481;
	goto yy480;
yy480:
	YYDEBUG(480, *YYCURSOR);

{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy480;
	if(yych >= ':')	goto yy480;
	goto yy482;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy480;
	if(yych >= ':')	goto yy480;
	goto yy483;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy480;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych <= ',')	goto yy332;
			if(yych <= '-')	goto yy478;
			if(yych <= '.')	goto yy414;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy448;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy378;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '/'){
			if(yych <= ',')	goto yy332;
			if(yych <= '-')	goto yy478;
			if(yych <= '.')	goto yy414;
			goto yy332;
		} else {
			if(yych <= '0')	goto yy448;
			if(yych <= '1')	goto yy416;
			if(yych <= '2')	goto yy417;
			goto yy418;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy378;
			if(yych == 'n')	goto yy328;
			goto yy332;
		} else {
			if(yych <= 'r')	goto yy329;
			if(yych <= 's')	goto yy327;
			if(yych <= 't')	goto yy330;
			goto yy332;
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy138;
			goto yy309;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'c')	goto yy487;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'D'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'E')	goto yy318;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'e')	goto yy488;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'L')	goto yy140;
			goto yy319;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy489;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy141;
			goto yy320;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy490;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'D')	goto yy3;
			goto yy321;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy491;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy322;
	if(yych != 'r')	goto yy152;
	goto yy492;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy310;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych <= ',')	goto yy310;
			goto yy312;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '/')	goto yy144;
			if(yych <= '9')	goto yy312;
			goto yy310;
		} else {
			if(yych <= '_')	goto yy144;
			if(yych <= '`')	goto yy310;
			if(yych <= 'z')	goto yy151;
			goto yy310;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy138;
			goto yy494;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 't')	goto yy494;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'O')	goto yy139;
				goto yy495;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'o')	goto yy495;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy140;
			goto yy496;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'b')	goto yy496;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy141;
			goto yy497;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'e')	goto yy497;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'R')	goto yy322;
		if(yych == 'r')	goto yy322;
		goto yy3;
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy138;
			goto yy494;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy499;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'N'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'O')	goto yy495;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'o')	goto yy500;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy140;
			goto yy496;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy501;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy141;
			goto yy497;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy502;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'Q')	goto yy3;
			goto yy322;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy492;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'B'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'O'){
				if(yych <= 'C')	goto yy519;
				goto yy138;
			} else {
				if(yych <= 'P')	goto yy518;
				if(yych <= 'U')	goto yy138;
				goto yy520;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych == 'c')	goto yy519;
				goto yy138;
			}
		} else {
			if(yych <= 'u'){
				if(yych <= 'p')	goto yy518;
				goto yy138;
			} else {
				if(yych <= 'v')	goto yy520;
				if(yych <= 'z')	goto yy138;
				goto yy3;
			}
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy138;
			goto yy513;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 't')	goto yy513;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy138;
			goto yy511;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'x')	goto yy511;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy507;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'n')	goto yy507;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy283;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'C')	goto yy139;
			goto yy508;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy283;
			goto yy139;
		} else {
			if(yych <= 'd')	goto yy508;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy509;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy509;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy141;
			goto yy510;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'y')	goto yy510;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy136;
	goto yy283;
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy512;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy512;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'h')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy283;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'T')	goto yy139;
			goto yy514;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy283;
			goto yy139;
		} else {
			if(yych <= 'u')	goto yy514;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy140;
			goto yy515;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'r')	goto yy515;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy141;
			goto yy516;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'd')	goto yy516;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy517;
		if(yych != 'a')	goto yy3;
		goto yy517;
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy289;
	if(yych == 'y')	goto yy289;
	goto yy53;
yy518:
	YYDEBUG(518, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych == 'T')	goto yy527;
				goto yy139;
			}
		} else {
			if(yych <= 's'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 't')	goto yy527;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy139;
			goto yy524;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'o')	goto yy524;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy139;
			goto yy521;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'e')	goto yy521;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy140;
			goto yy522;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'n')	goto yy522;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy141;
			goto yy523;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 't')	goto yy523;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy167;
		if(yych == 'h')	goto yy167;
		goto yy3;
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy140;
			goto yy525;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'n')	goto yy525;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy141;
			goto yy526;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'd')	goto yy526;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 0x1F){
		if(yych == 0x09)	goto yy168;
		goto yy3;
	} else {
		if(yych <= ' ')	goto yy168;
		if(yych == ')')	goto yy136;
		goto yy3;
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'E')	goto yy140;
				goto yy528;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy310;
				goto yy140;
			} else {
				if(yych <= 'e')	goto yy528;
				if(yych <= 'z')	goto yy140;
				goto yy310;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'L')	goto yy141;
			goto yy529;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'm')	goto yy529;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'B')	goto yy530;
		if(yych != 'b')	goto yy3;
		goto yy530;
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy531;
	if(yych != 'e')	goto yy53;
	goto yy531;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy322;
	if(yych == 'r')	goto yy322;
	goto yy53;
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '@'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy136;
			} else {
				if(yych == '/')	goto yy144;
				goto yy3;
			}
		} else {
			if(yych <= 'O'){
				if(yych == 'C')	goto yy519;
				goto yy138;
			} else {
				if(yych <= 'P')	goto yy518;
				if(yych <= 'U')	goto yy138;
				goto yy520;
			}
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_'){
				if(yych <= 'Z')	goto yy138;
				if(yych <= '^')	goto yy3;
				goto yy144;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'b')	goto yy143;
				goto yy548;
			}
		} else {
			if(yych <= 'u'){
				if(yych == 'p')	goto yy547;
				goto yy143;
			} else {
				if(yych <= 'v')	goto yy549;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy138;
			goto yy513;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy542;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy138;
			goto yy511;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'x')	goto yy540;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy507;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy536;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'C')	goto yy139;
			goto yy508;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 'd')	goto yy537;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy538;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy141;
			goto yy510;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy539;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy136;
		if(yych <= '.')	goto yy283;
		goto yy144;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy283;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy283;
			if(yych <= 'z')	goto yy151;
			goto yy283;
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy512;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy541;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'T')	goto yy139;
			goto yy514;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 'u')	goto yy543;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy140;
			goto yy515;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy544;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy141;
			goto yy516;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy545;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy517;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy546;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy289;
	if(yych == 'y')	goto yy302;
	goto yy152;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'S'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'T')	goto yy527;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 's'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 't')	goto yy556;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy139;
			goto yy524;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy553;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy139;
			goto yy521;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy550;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy140;
			goto yy522;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy551;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy141;
			goto yy523;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy552;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'G')	goto yy3;
			goto yy167;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy254;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy140;
			goto yy525;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy554;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy141;
			goto yy526;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy555;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ')'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy168;
			goto yy3;
		} else {
			if(yych <= ' ')	goto yy168;
			if(yych <= '(')	goto yy3;
			goto yy136;
		}
	} else {
		if(yych <= '^'){
			if(yych == '/')	goto yy144;
			goto yy3;
		} else {
			if(yych <= '_')	goto yy144;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'D'){
				if(yych <= '@')	goto yy310;
				goto yy140;
			} else {
				if(yych <= 'E')	goto yy528;
				if(yych <= 'Z')	goto yy140;
				goto yy310;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy149;
			} else {
				if(yych <= 'e')	goto yy557;
				if(yych <= 'z')	goto yy149;
				goto yy310;
			}
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'L')	goto yy141;
			goto yy529;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy558;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'A')	goto yy3;
			goto yy530;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy559;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy531;
	if(yych != 'e')	goto yy152;
	goto yy560;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy322;
	if(yych == 'r')	goto yy492;
	goto yy152;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy138;
			goto yy569;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'g')	goto yy569;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy138;
			goto yy566;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'r')	goto yy566;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy138;
			goto yy564;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'o')	goto yy564;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy136;
		goto yy565;
	} else {
		if(yych <= 'Z')	goto yy139;
		if(yych <= '`')	goto yy565;
		if(yych <= 'z')	goto yy139;
		goto yy565;
	}
yy565:
	YYDEBUG(565, *YYCURSOR);

{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->have_special_relative && s->time->special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->special.amount = 0 - s->time->special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'I')	goto yy139;
				goto yy567;
			}
		} else {
			if(yych <= 'h'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'i')	goto yy567;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy140;
			goto yy568;
		}
	} else {
		if(yych <= 'k'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'l')	goto yy568;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy310;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych == ')')	goto yy136;
			goto yy310;
		}
	} else {
		if(yych <= '@'){
			if(yych == '/')	goto yy310;
			if(yych <= '9')	goto yy312;
			goto yy310;
		} else {
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy310;
			if(yych <= 'z')	goto yy141;
			goto yy310;
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'U')	goto yy139;
				goto yy570;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'u')	goto yy570;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy140;
			goto yy571;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 's')	goto yy571;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy141;
			goto yy572;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 't')	goto yy572;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '('){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy310;
			goto yy312;
		} else {
			if(yych == ' ')	goto yy312;
			goto yy310;
		}
	} else {
		if(yych <= '.'){
			if(yych <= ')')	goto yy136;
			if(yych <= ',')	goto yy310;
			goto yy312;
		} else {
			if(yych <= '/')	goto yy310;
			if(yych <= '9')	goto yy312;
			goto yy310;
		}
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy138;
			goto yy569;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy580;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy138;
			goto yy566;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy577;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy138;
			goto yy564;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy576;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy565;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy565;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '^')	goto yy565;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy565;
			if(yych <= 'z')	goto yy148;
			goto yy565;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'H'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'I')	goto yy567;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'h'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'i')	goto yy578;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy140;
			goto yy568;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'l')	goto yy579;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy310;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy310;
			goto yy312;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '/')	goto yy144;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy310;
			goto yy141;
		} else {
			if(yych <= '_'){
				if(yych <= '^')	goto yy310;
				goto yy144;
			} else {
				if(yych <= '`')	goto yy310;
				if(yych <= 'z')	goto yy150;
				goto yy310;
			}
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'T'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'U')	goto yy570;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'u')	goto yy581;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy140;
			goto yy571;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 's')	goto yy582;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy141;
			goto yy572;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy583;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy310;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych == ')')	goto yy136;
			goto yy310;
		}
	} else {
		if(yych <= '^'){
			if(yych == '/')	goto yy144;
			if(yych <= '9')	goto yy312;
			goto yy310;
		} else {
			if(yych <= '_')	goto yy144;
			if(yych <= '`')	goto yy310;
			if(yych <= 'z')	goto yy151;
			goto yy310;
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy138;
			goto yy598;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'b')	goto yy598;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'F')	goto yy595;
			if(yych <= 'Q')	goto yy138;
			goto yy594;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'e')	goto yy138;
			goto yy595;
		} else {
			if(yych == 'r')	goto yy594;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy138;
			goto yy591;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'u')	goto yy591;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy138;
			goto yy588;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'i')	goto yy588;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy283;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'C')	goto yy139;
			goto yy589;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy283;
			goto yy139;
		} else {
			if(yych <= 'd')	goto yy589;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy590;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy590;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy141;
			goto yy510;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'y')	goto yy510;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy139;
			goto yy592;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'r')	goto yy592;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy140;
			goto yy593;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 't')	goto yy593;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy141;
			goto yy526;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'h')	goto yy526;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy139;
			goto yy597;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 's')	goto yy597;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy596;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy596;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'h')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 't')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'R')	goto yy139;
				goto yy599;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'r')	goto yy599;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy140;
			goto yy600;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'u')	goto yy600;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy601;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy601;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'R')	goto yy602;
		if(yych != 'r')	goto yy3;
		goto yy602;
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy322;
	if(yych == 'y')	goto yy322;
	goto yy53;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy138;
			goto yy598;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy617;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= 'E'){
				if(yych <= '@')	goto yy3;
				goto yy138;
			} else {
				if(yych <= 'F')	goto yy595;
				if(yych <= 'Q')	goto yy138;
				goto yy594;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy3;
				goto yy143;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= 'f')	goto yy614;
				goto yy143;
			} else {
				if(yych <= 'r')	goto yy613;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy138;
			goto yy591;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy610;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy138;
			goto yy588;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy607;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'C')	goto yy139;
			goto yy589;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 'd')	goto yy608;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy590;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy609;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy141;
			goto yy510;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy539;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy139;
			goto yy592;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy611;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy140;
			goto yy593;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy612;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy141;
			goto yy526;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy555;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy139;
			goto yy597;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 's')	goto yy616;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy596;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy615;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'Q'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'R')	goto yy599;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'r')	goto yy618;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy140;
			goto yy600;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy619;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy601;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy620;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'Q')	goto yy3;
			goto yy602;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy621;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy322;
	if(yych == 'y')	goto yy492;
	goto yy152;
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'L')	goto yy629;
			if(yych <= 'M')	goto yy138;
			goto yy628;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'k')	goto yy138;
			goto yy629;
		} else {
			if(yych == 'n')	goto yy628;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy624;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'n')	goto yy624;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'U')	goto yy139;
				goto yy625;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'u')	goto yy625;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy626;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy626;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy141;
			goto yy627;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'r')	goto yy627;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Y')	goto yy322;
		if(yych == 'y')	goto yy322;
		goto yy3;
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych == 'E')	goto yy630;
				goto yy139;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'e')	goto yy630;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'Y')	goto yy139;
				goto yy630;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'y')	goto yy630;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy310;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych == ')')	goto yy136;
			goto yy310;
		}
	} else {
		if(yych <= '@'){
			if(yych == '/')	goto yy310;
			if(yych <= '9')	goto yy312;
			goto yy310;
		} else {
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy310;
			if(yych <= 'z')	goto yy140;
			goto yy310;
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= 'K'){
				if(yych <= '@')	goto yy3;
				goto yy138;
			} else {
				if(yych <= 'L')	goto yy629;
				if(yych <= 'M')	goto yy138;
				goto yy628;
			}
		}
	} else {
		if(yych <= 'k'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy3;
				goto yy143;
			}
		} else {
			if(yych <= 'm'){
				if(yych <= 'l')	goto yy638;
				goto yy143;
			} else {
				if(yych <= 'n')	goto yy637;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy624;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy633;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'T'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'U')	goto yy625;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'u')	goto yy634;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy626;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy635;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy141;
			goto yy627;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy636;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'X')	goto yy3;
			goto yy322;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy492;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'D'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'E')	goto yy630;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'e')	goto yy639;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'X'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'Y')	goto yy630;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'y')	goto yy639;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy310;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy310;
			goto yy312;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '/')	goto yy144;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy310;
			goto yy140;
		} else {
			if(yych <= '_'){
				if(yych <= '^')	goto yy310;
				goto yy144;
			} else {
				if(yych <= '`')	goto yy310;
				if(yych <= 'z')	goto yy149;
				goto yy310;
			}
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy3;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy3;
			goto yy312;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'Z'){
				if(yych >= 'J')	goto yy138;
				goto yy641;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy138;
				goto yy3;
			}
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy3;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych == ')')	goto yy136;
			goto yy3;
		}
	} else {
		if(yych <= '@'){
			if(yych == '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			goto yy3;
		} else {
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy3;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy3;
			goto yy312;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'Z'){
				if(yych >= 'J')	goto yy138;
				goto yy643;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy138;
				goto yy3;
			}
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy3;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy3;
			goto yy312;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'Z'){
				if(yych >= 'J')	goto yy139;
				goto yy644;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy139;
				goto yy3;
			}
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy3;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych == ')')	goto yy136;
			goto yy3;
		}
	} else {
		if(yych <= '@'){
			if(yych == '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			goto yy3;
		} else {
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy312;
			goto yy3;
		} else {
			if(yych <= ' ')	goto yy312;
			if(yych == ')')	goto yy136;
			goto yy3;
		}
	} else {
		if(yych <= '@'){
			if(yych == '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			goto yy3;
		} else {
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy3;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy3;
			goto yy312;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'Z'){
				if(yych <= 'I')	goto yy641;
				goto yy138;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy138;
				goto yy3;
			}
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy649;
	if(yych <= '0')	goto yy897;
	if(yych <= '1')	goto yy898;
	if(yych <= '9')	goto yy899;
	goto yy649;
yy648:
	YYDEBUG(648, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy649;
yy649:
	YYDEBUG(649, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	goto yy648;
	case '-':
	case '.':	goto yy748;
	case 'A':	case 'a':	goto yy667;
	case 'D':	case 'd':	goto yy653;
	case 'F':	case 'f':	goto yy654;
	case 'H':	case 'h':	goto yy60;
	case 'I':	goto yy662;
	case 'J':	case 'j':	goto yy666;
	case 'M':	case 'm':	goto yy652;
	case 'N':	case 'n':	goto yy669;
	case 'O':	case 'o':	goto yy668;
	case 'P':	case 'p':	goto yy671;
	case 'S':	case 's':	goto yy650;
	case 'T':	case 't':	goto yy65;
	case 'V':	goto yy664;
	case 'W':	case 'w':	goto yy62;
	case 'X':	goto yy665;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy1196;
			if(yych <= 'T')	goto yy53;
			goto yy122;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy1196;
			if(yych == 'u')	goto yy122;
			goto yy53;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '`'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy1196;
			if(yych == 'U')	goto yy122;
			goto yy53;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'a')	goto yy123;
			if(yych <= 'd')	goto yy53;
			goto yy1196;
		} else {
			if(yych <= 's')	goto yy53;
			if(yych <= 't')	goto yy894;
			if(yych <= 'u')	goto yy122;
			goto yy53;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy763;
			goto yy53;
		} else {
			if(yych <= 'I')	goto yy114;
			if(yych <= 'N')	goto yy53;
			goto yy113;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy763;
			goto yy53;
		} else {
			if(yych <= 'i')	goto yy114;
			if(yych == 'o')	goto yy113;
			goto yy53;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'A')	goto yy110;
		if(yych <= 'D')	goto yy53;
		goto yy750;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy110;
		} else {
			if(yych == 'e')	goto yy750;
			goto yy53;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy766;
			goto yy53;
		} else {
			if(yych <= 'O')	goto yy83;
			if(yych <= 'Q')	goto yy53;
			goto yy82;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy766;
			goto yy53;
		} else {
			if(yych <= 'o')	goto yy83;
			if(yych == 'r')	goto yy82;
			goto yy53;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy66;
		if(yych <= 'T')	goto yy53;
		goto yy67;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy1195;
		} else {
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy901;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy900;
	goto yy57;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'c'){
		if(yych == 'O')	goto yy701;
		goto yy53;
	} else {
		if(yych <= 'd')	goto yy894;
		if(yych == 'o')	goto yy701;
		goto yy53;
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy894;
	goto yy53;
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':
	case '1':
	case '2':	goto yy834;
	case '3':	goto yy836;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy837;
	case 'A':	case 'a':	goto yy841;
	case 'D':	case 'd':	goto yy845;
	case 'F':	case 'f':	goto yy839;
	case 'J':	case 'j':	goto yy838;
	case 'M':	case 'm':	goto yy840;
	case 'N':	case 'n':	goto yy844;
	case 'O':	case 'o':	goto yy843;
	case 'S':	case 's':	goto yy842;
	default:	goto yy53;
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy784;
	case '1':	goto yy785;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy786;
	case 'A':	case 'a':	goto yy790;
	case 'D':	case 'd':	goto yy794;
	case 'F':	case 'f':	goto yy788;
	case 'J':	case 'j':	goto yy787;
	case 'M':	case 'm':	goto yy789;
	case 'N':	case 'n':	goto yy793;
	case 'O':	case 'o':	goto yy792;
	case 'S':	case 's':	goto yy791;
	default:	goto yy749;
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy749;
		if(yych <= '0')	goto yy739;
		goto yy740;
	} else {
		if(yych <= '5')	goto yy741;
		if(yych <= '9')	goto yy742;
		goto yy749;
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '.')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= 'U'){
			if(yych <= '9')	goto yy705;
			if(yych == 'I')	goto yy738;
			goto yy663;
		} else {
			if(yych == 'W')	goto yy663;
			if(yych <= 'X')	goto yy711;
			goto yy663;
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);

{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '9'){
			if(yych <= '.')	goto yy703;
			if(yych <= '/')	goto yy663;
			goto yy705;
		} else {
			if(yych == 'I')	goto yy736;
			goto yy663;
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '9'){
			if(yych <= '.')	goto yy703;
			if(yych <= '/')	goto yy663;
			goto yy705;
		} else {
			if(yych == 'I')	goto yy735;
			goto yy663;
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy728;
		if(yych <= 'T')	goto yy53;
		goto yy727;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy728;
		} else {
			if(yych == 'u')	goto yy727;
			goto yy53;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'L'){
			if(yych == '.')	goto yy672;
			goto yy53;
		} else {
			if(yych <= 'M')	goto yy673;
			if(yych == 'P')	goto yy721;
			goto yy53;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= 'U')	goto yy720;
			if(yych == 'm')	goto yy673;
			goto yy53;
		} else {
			if(yych <= 'p')	goto yy721;
			if(yych == 'u')	goto yy720;
			goto yy53;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy715;
	if(yych == 'c')	goto yy715;
	goto yy53;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy701;
	if(yych == 'o')	goto yy701;
	goto yy53;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy677;
	if(yych <= '9')	goto yy679;
	goto yy53;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy672;
	} else {
		if(yych <= 'M')	goto yy673;
		if(yych == 'm')	goto yy673;
		goto yy53;
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy673;
	if(yych != 'm')	goto yy53;
	goto yy673;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x1F){
		if(yych <= 0x00)	goto yy675;
		if(yych == 0x09)	goto yy675;
		goto yy53;
	} else {
		if(yych <= ' ')	goto yy675;
		if(yych != '.')	goto yy53;
		goto yy674;
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x09){
		if(yych <= 0x00)	goto yy675;
		if(yych <= 0x08)	goto yy53;
		goto yy675;
	} else {
		if(yych != ' ')	goto yy53;
		goto yy675;
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	++YYCURSOR;
	goto yy676;
yy676:
	YYDEBUG(676, *YYCURSOR);

{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy680;
		goto yy678;
	} else {
		if(yych <= '9')	goto yy694;
		if(yych <= ':')	goto yy680;
		goto yy678;
	}
yy678:
	YYDEBUG(678, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy680;
	if(yych != ':')	goto yy678;
	goto yy680;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy681;
	if(yych <= '6')	goto yy682;
	if(yych <= '9')	goto yy683;
	goto yy53;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych <= '/')	goto yy678;
	if(yych <= '9')	goto yy687;
	goto yy678;
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych == '0')	goto yy687;
	goto yy678;
yy683:
	YYDEBUG(683, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '.')	goto yy678;
	goto yy684;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy685;
yy685:
	YYDEBUG(685, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy686;
yy686:
	YYDEBUG(686, *YYCURSOR);
	if(yych <= '/')	goto yy678;
	if(yych <= '9')	goto yy685;
	goto yy678;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= 0x1F){
			if(yych != 0x09)	goto yy678;
			goto yy688;
		} else {
			if(yych <= ' ')	goto yy688;
			if(yych == '.')	goto yy684;
			goto yy678;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy690;
			if(yych == 'P')	goto yy690;
			goto yy678;
		} else {
			if(yych <= 'a')	goto yy690;
			if(yych == 'p')	goto yy690;
			goto yy678;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	goto yy689;
yy689:
	YYDEBUG(689, *YYCURSOR);
	if(yych <= 'A'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy688;
			goto yy53;
		} else {
			if(yych <= ' ')	goto yy688;
			if(yych <= '@')	goto yy53;
			goto yy690;
		}
	} else {
		if(yych <= '`'){
			if(yych != 'P')	goto yy53;
			goto yy690;
		} else {
			if(yych <= 'a')	goto yy690;
			if(yych != 'p')	goto yy53;
			goto yy690;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy691;
	} else {
		if(yych <= 'M')	goto yy692;
		if(yych == 'm')	goto yy692;
		goto yy53;
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy692;
	if(yych != 'm')	goto yy53;
	goto yy692;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x1F){
		if(yych <= 0x00)	goto yy675;
		if(yych == 0x09)	goto yy675;
		goto yy53;
	} else {
		if(yych <= ' ')	goto yy675;
		if(yych != '.')	goto yy53;
		goto yy693;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x09){
		if(yych <= 0x00)	goto yy675;
		if(yych <= 0x08)	goto yy53;
		goto yy675;
	} else {
		if(yych == ' ')	goto yy675;
		goto yy53;
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy695;
			if(yych <= 0x1F)	goto yy678;
			goto yy695;
		} else {
			if(yych == '.')	goto yy680;
			if(yych <= '9')	goto yy678;
			goto yy680;
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy697;
			if(yych <= 'O')	goto yy678;
			goto yy697;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy678;
				goto yy697;
			} else {
				if(yych == 'p')	goto yy697;
				goto yy678;
			}
		}
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	goto yy696;
yy696:
	YYDEBUG(696, *YYCURSOR);
	if(yych <= 'A'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy695;
			goto yy53;
		} else {
			if(yych <= ' ')	goto yy695;
			if(yych <= '@')	goto yy53;
			goto yy697;
		}
	} else {
		if(yych <= '`'){
			if(yych != 'P')	goto yy53;
			goto yy697;
		} else {
			if(yych <= 'a')	goto yy697;
			if(yych != 'p')	goto yy53;
			goto yy697;
		}
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy698;
	} else {
		if(yych <= 'M')	goto yy699;
		if(yych == 'm')	goto yy699;
		goto yy53;
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy699;
	if(yych != 'm')	goto yy53;
	goto yy699;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x1F){
		if(yych <= 0x00)	goto yy675;
		if(yych == 0x09)	goto yy675;
		goto yy53;
	} else {
		if(yych <= ' ')	goto yy675;
		if(yych != '.')	goto yy53;
		goto yy700;
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 0x09){
		if(yych <= 0x00)	goto yy675;
		if(yych <= 0x08)	goto yy53;
		goto yy675;
	} else {
		if(yych == ' ')	goto yy675;
		goto yy53;
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy702;
	if(yych != 'v')	goto yy53;
	goto yy702;
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych != 0x09)	goto yy663;
			goto yy703;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy707;
			if(yych == 'e')	goto yy707;
			goto yy663;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy704;
yy704:
	YYDEBUG(704, *YYCURSOR);
	if(yych <= ' '){
		if(yych == 0x09)	goto yy703;
		if(yych <= 0x1F)	goto yy53;
		goto yy703;
	} else {
		if(yych <= '.'){
			if(yych <= ',')	goto yy53;
			goto yy703;
		} else {
			if(yych <= '/')	goto yy53;
			if(yych >= ':')	goto yy53;
			goto yy705;
		}
	}
yy705:
	YYDEBUG(705, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy706;
	if(yych <= '9')	goto yy712;
	goto yy706;
yy706:
	YYDEBUG(706, *YYCURSOR);

{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy708;
	if(yych != 'm')	goto yy53;
	goto yy708;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy709;
	if(yych != 'b')	goto yy53;
	goto yy709;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy710;
	if(yych != 'e')	goto yy53;
	goto yy710;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy711;
	if(yych != 'r')	goto yy53;
	goto yy711;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ' '){
		if(yych == 0x09)	goto yy703;
		if(yych <= 0x1F)	goto yy663;
		goto yy703;
	} else {
		if(yych <= '.'){
			if(yych <= ',')	goto yy663;
			goto yy703;
		} else {
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		}
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy706;
	if(yych >= ':')	goto yy706;
	goto yy713;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy706;
	if(yych >= ':')	goto yy706;
	goto yy714;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy706;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy716;
	if(yych != 't')	goto yy53;
	goto yy716;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'N'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'O')	goto yy717;
			if(yych != 'o')	goto yy663;
			goto yy717;
		}
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy718;
	if(yych != 'b')	goto yy53;
	goto yy718;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy719;
	if(yych != 'e')	goto yy53;
	goto yy719;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy711;
	if(yych == 'r')	goto yy711;
	goto yy53;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy724;
	if(yych == 'g')	goto yy724;
	goto yy53;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy722;
	if(yych != 'r')	goto yy53;
	goto yy722;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'I')	goto yy723;
			if(yych != 'i')	goto yy663;
			goto yy723;
		}
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy711;
	if(yych == 'l')	goto yy711;
	goto yy53;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'T'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'U')	goto yy725;
			if(yych != 'u')	goto yy663;
			goto yy725;
		}
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy726;
	if(yych != 's')	goto yy53;
	goto yy726;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy711;
	if(yych == 't')	goto yy711;
	goto yy53;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy734;
		if(yych <= 'M')	goto yy53;
		goto yy733;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy734;
		} else {
			if(yych == 'n')	goto yy733;
			goto yy53;
		}
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy729;
	if(yych != 'n')	goto yy53;
	goto yy729;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'T'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'U')	goto yy730;
			if(yych != 'u')	goto yy663;
			goto yy730;
		}
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy731;
	if(yych != 'a')	goto yy53;
	goto yy731;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy732;
	if(yych != 'r')	goto yy53;
	goto yy732;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy711;
	if(yych == 'y')	goto yy711;
	goto yy53;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy711;
			if(yych == 'e')	goto yy711;
			goto yy663;
		}
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'X'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'Y')	goto yy711;
			if(yych == 'y')	goto yy711;
			goto yy663;
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '9'){
			if(yych <= '.')	goto yy703;
			if(yych <= '/')	goto yy663;
			goto yy705;
		} else {
			if(yych == 'I')	goto yy711;
			goto yy663;
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '9'){
			if(yych <= '.')	goto yy703;
			if(yych <= '/')	goto yy663;
			goto yy705;
		} else {
			if(yych != 'I')	goto yy663;
			goto yy737;
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '9'){
			if(yych <= '.')	goto yy703;
			if(yych <= '/')	goto yy663;
			goto yy705;
		} else {
			if(yych == 'I')	goto yy711;
			goto yy663;
		}
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '9'){
			if(yych <= '.')	goto yy703;
			if(yych <= '/')	goto yy663;
			goto yy705;
		} else {
			if(yych == 'I')	goto yy711;
			goto yy663;
		}
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		goto yy773;
	} else {
		if(yych <= '/')	goto yy678;
		if(yych <= '9')	goto yy783;
		if(yych <= ':')	goto yy680;
		goto yy678;
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		if(yych <= '.')	goto yy773;
		goto yy678;
	} else {
		if(yych <= '2')	goto yy783;
		if(yych <= '9')	goto yy694;
		if(yych <= ':')	goto yy680;
		goto yy678;
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		goto yy773;
	} else {
		if(yych <= '/')	goto yy678;
		if(yych <= '9')	goto yy694;
		if(yych <= ':')	goto yy680;
		goto yy678;
	}
yy742:
	YYDEBUG(742, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		goto yy773;
	} else {
		if(yych == ':')	goto yy680;
		goto yy678;
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy766;
	if(yych == 'e')	goto yy766;
	goto yy53;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy763;
	if(yych == 'a')	goto yy763;
	goto yy53;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy721;
		if(yych <= 'T')	goto yy53;
		goto yy720;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy721;
		} else {
			if(yych == 'u')	goto yy720;
			goto yy53;
		}
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy756;
	if(yych == 'e')	goto yy756;
	goto yy53;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy750;
	if(yych == 'e')	goto yy750;
	goto yy53;
yy748:
	YYDEBUG(748, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy749;
yy749:
	YYDEBUG(749, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	case '-':
	case '.':	goto yy748;
	case 'A':	case 'a':	goto yy745;
	case 'D':	case 'd':	goto yy747;
	case 'F':	case 'f':	goto yy743;
	case 'I':	goto yy662;
	case 'J':	case 'j':	goto yy666;
	case 'M':	case 'm':	goto yy744;
	case 'N':	case 'n':	goto yy669;
	case 'O':	case 'o':	goto yy668;
	case 'S':	case 's':	goto yy746;
	case 'V':	goto yy664;
	case 'X':	goto yy665;
	default:	goto yy53;
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy751;
	if(yych != 'c')	goto yy53;
	goto yy751;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy752;
			if(yych != 'e')	goto yy663;
			goto yy752;
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy753;
	if(yych != 'm')	goto yy53;
	goto yy753;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy754;
	if(yych != 'b')	goto yy53;
	goto yy754;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy755;
	if(yych != 'e')	goto yy53;
	goto yy755;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy711;
	if(yych == 'r')	goto yy711;
	goto yy53;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy757;
	if(yych != 'p')	goto yy53;
	goto yy757;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'S'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'T')	goto yy758;
			if(yych != 't')	goto yy663;
			goto yy758;
		}
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy759;
			if(yych != 'e')	goto yy663;
			goto yy759;
		}
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy760;
	if(yych != 'm')	goto yy53;
	goto yy760;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy761;
	if(yych != 'b')	goto yy53;
	goto yy761;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy762;
	if(yych != 'e')	goto yy53;
	goto yy762;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy711;
	if(yych == 'r')	goto yy711;
	goto yy53;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy764;
		if(yych <= 'X')	goto yy53;
		goto yy711;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy764;
		} else {
			if(yych == 'y')	goto yy711;
			goto yy53;
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'B'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'C')	goto yy765;
			if(yych != 'c')	goto yy663;
			goto yy765;
		}
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy711;
	if(yych == 'h')	goto yy711;
	goto yy53;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy767;
	if(yych != 'b')	goto yy53;
	goto yy767;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			goto yy703;
		}
	} else {
		if(yych <= 'Q'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'R')	goto yy768;
			if(yych != 'r')	goto yy663;
			goto yy768;
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy769;
	if(yych != 'u')	goto yy53;
	goto yy769;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy770;
	if(yych != 'a')	goto yy53;
	goto yy770;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy771;
	if(yych != 'r')	goto yy53;
	goto yy771;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy711;
	if(yych == 'y')	goto yy711;
	goto yy53;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy782;
	goto yy53;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy774;
	if(yych <= '6')	goto yy775;
	if(yych <= '9')	goto yy776;
	goto yy53;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych <= '/')	goto yy678;
	if(yych <= '9')	goto yy781;
	goto yy678;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy684;
		goto yy678;
	} else {
		if(yych <= '0')	goto yy781;
		if(yych <= '9')	goto yy777;
		goto yy678;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych <= '/')	goto yy678;
	if(yych >= ':')	goto yy678;
	goto yy777;
yy777:
	YYDEBUG(777, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy778;
	if(yych <= '9')	goto yy779;
	goto yy778;
yy778:
	YYDEBUG(778, *YYCURSOR);

{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy778;
	if(yych >= ':')	goto yy778;
	goto yy780;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy778;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy688;
			if(yych <= 0x1F)	goto yy678;
			goto yy688;
		} else {
			if(yych == '.')	goto yy684;
			if(yych <= '/')	goto yy678;
			goto yy779;
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy690;
			if(yych <= 'O')	goto yy678;
			goto yy690;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy678;
				goto yy690;
			} else {
				if(yych == 'p')	goto yy690;
				goto yy678;
			}
		}
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy778;
	if(yych <= '9')	goto yy777;
	goto yy778;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy695;
			if(yych <= 0x1F)	goto yy678;
			goto yy695;
		} else {
			if(yych <= '-'){
				if(yych <= ',')	goto yy678;
				goto yy772;
			} else {
				if(yych <= '.')	goto yy773;
				if(yych <= '9')	goto yy678;
				goto yy680;
			}
		}
	} else {
		if(yych <= 'P'){
			if(yych == 'A')	goto yy697;
			if(yych <= 'O')	goto yy678;
			goto yy697;
		} else {
			if(yych <= 'a'){
				if(yych <= '`')	goto yy678;
				goto yy697;
			} else {
				if(yych == 'p')	goto yy697;
				goto yy678;
			}
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.'){
		if(yych <= ',')	goto yy53;
		if(yych <= '-')	goto yy823;
		goto yy772;
	} else {
		if(yych <= '/')	goto yy53;
		if(yych <= '9')	goto yy786;
		goto yy53;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.'){
		if(yych <= ',')	goto yy53;
		if(yych <= '-')	goto yy823;
		goto yy772;
	} else {
		if(yych <= '/')	goto yy53;
		if(yych >= '3')	goto yy53;
		goto yy786;
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ',')	goto yy53;
	if(yych <= '-')	goto yy823;
	if(yych <= '.')	goto yy772;
	goto yy53;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy819;
		if(yych <= 'T')	goto yy53;
		goto yy818;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy819;
		} else {
			if(yych == 'u')	goto yy818;
			goto yy53;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy816;
	if(yych == 'e')	goto yy816;
	goto yy53;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy813;
	if(yych == 'a')	goto yy813;
	goto yy53;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy810;
		if(yych <= 'T')	goto yy53;
		goto yy809;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy810;
		} else {
			if(yych == 'u')	goto yy809;
			goto yy53;
		}
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy806;
	if(yych == 'e')	goto yy806;
	goto yy53;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy804;
	if(yych == 'c')	goto yy804;
	goto yy53;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy802;
	if(yych == 'o')	goto yy802;
	goto yy53;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy795;
	if(yych != 'e')	goto yy53;
	goto yy795;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy796;
	if(yych != 'c')	goto yy53;
	goto yy796;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych >= '.')	goto yy703;
			goto yy797;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy752;
			if(yych == 'e')	goto yy752;
			goto yy663;
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy704;
	if(yych <= '0')	goto yy798;
	if(yych <= '2')	goto yy799;
	if(yych <= '3')	goto yy800;
	goto yy704;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy706;
	if(yych <= '0')	goto yy712;
	if(yych <= '9')	goto yy801;
	goto yy706;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy706;
	if(yych <= '9')	goto yy801;
	goto yy706;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy706;
	if(yych <= '1')	goto yy801;
	if(yych <= '9')	goto yy712;
	goto yy706;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy706;
	if(yych <= '9')	goto yy713;
	goto yy706;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy803;
	if(yych != 'v')	goto yy53;
	goto yy803;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy707;
			if(yych == 'e')	goto yy707;
			goto yy663;
		}
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy805;
	if(yych != 't')	goto yy53;
	goto yy805;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'N'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'O')	goto yy717;
			if(yych == 'o')	goto yy717;
			goto yy663;
		}
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy807;
	if(yych != 'p')	goto yy53;
	goto yy807;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'S'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'T')	goto yy808;
			if(yych != 't')	goto yy663;
			goto yy808;
		}
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy759;
			if(yych == 'e')	goto yy759;
			goto yy663;
		}
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy812;
	if(yych == 'g')	goto yy812;
	goto yy53;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy811;
	if(yych != 'r')	goto yy53;
	goto yy811;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'H'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'I')	goto yy723;
			if(yych == 'i')	goto yy723;
			goto yy663;
		}
	}
yy812:
	YYDEBUG(812, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'T'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'U')	goto yy725;
			if(yych == 'u')	goto yy725;
			goto yy663;
		}
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy814;
		if(yych <= 'X')	goto yy53;
		goto yy815;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy814;
		} else {
			if(yych == 'y')	goto yy815;
			goto yy53;
		}
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'B'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'C')	goto yy765;
			if(yych == 'c')	goto yy765;
			goto yy663;
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ','){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy663;
			goto yy703;
		} else {
			if(yych == ' ')	goto yy703;
			goto yy663;
		}
	} else {
		if(yych <= '.'){
			if(yych <= '-')	goto yy797;
			goto yy703;
		} else {
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		}
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy817;
	if(yych != 'b')	goto yy53;
	goto yy817;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'Q'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'R')	goto yy768;
			if(yych == 'r')	goto yy768;
			goto yy663;
		}
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy822;
		if(yych <= 'M')	goto yy53;
		goto yy821;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy822;
		} else {
			if(yych == 'n')	goto yy821;
			goto yy53;
		}
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy820;
	if(yych != 'n')	goto yy53;
	goto yy820;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'T'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'U')	goto yy730;
			if(yych == 'u')	goto yy730;
			goto yy663;
		}
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'E')	goto yy711;
			if(yych == 'e')	goto yy711;
			goto yy663;
		}
	}
yy822:
	YYDEBUG(822, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= 0x1F){
			if(yych == 0x09)	goto yy703;
			goto yy663;
		} else {
			if(yych <= ' ')	goto yy703;
			if(yych <= ',')	goto yy663;
			if(yych <= '-')	goto yy797;
			goto yy703;
		}
	} else {
		if(yych <= 'X'){
			if(yych <= '/')	goto yy663;
			if(yych <= '9')	goto yy705;
			goto yy663;
		} else {
			if(yych <= 'Y')	goto yy711;
			if(yych == 'y')	goto yy711;
			goto yy663;
		}
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy824;
	if(yych <= '3')	goto yy826;
	if(yych <= '9')	goto yy827;
	goto yy53;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy825;
		if(yych <= '9')	goto yy833;
		if(yych >= 'n')	goto yy829;
		goto yy825;
	} else {
		if(yych <= 'r'){
			if(yych >= 'r')	goto yy830;
			goto yy825;
		} else {
			if(yych <= 's')	goto yy828;
			if(yych <= 't')	goto yy831;
			goto yy825;
		}
	}
yy825:
	YYDEBUG(825, *YYCURSOR);

{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy825;
			goto yy833;
		} else {
			if(yych <= '9')	goto yy777;
			if(yych <= 'm')	goto yy825;
			goto yy829;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy825;
			goto yy830;
		} else {
			if(yych <= 's')	goto yy828;
			if(yych <= 't')	goto yy831;
			goto yy825;
		}
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy825;
		if(yych <= '9')	goto yy777;
		if(yych <= 'm')	goto yy825;
		goto yy829;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy825;
			goto yy830;
		} else {
			if(yych <= 's')	goto yy828;
			if(yych <= 't')	goto yy831;
			goto yy825;
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy832;
	goto yy53;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy832;
	goto yy53;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy832;
	goto yy53;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'h')	goto yy53;
	goto yy832;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy825;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy825;
		if(yych <= '9')	goto yy779;
		if(yych <= 'm')	goto yy825;
		goto yy829;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy825;
			goto yy830;
		} else {
			if(yych <= 's')	goto yy828;
			if(yych <= 't')	goto yy831;
			goto yy825;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/'){
			if(yych >= '/')	goto yy888;
			goto yy835;
		} else {
			if(yych <= '9')	goto yy837;
			if(yych >= 'n')	goto yy885;
			goto yy835;
		}
	} else {
		if(yych <= 'r'){
			if(yych >= 'r')	goto yy886;
			goto yy835;
		} else {
			if(yych <= 's')	goto yy884;
			if(yych <= 't')	goto yy887;
			goto yy835;
		}
	}
yy835:
	YYDEBUG(835, *YYCURSOR);

{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy835;
			goto yy888;
		} else {
			if(yych <= '1')	goto yy837;
			if(yych <= 'm')	goto yy835;
			goto yy885;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy835;
			goto yy886;
		} else {
			if(yych <= 's')	goto yy884;
			if(yych <= 't')	goto yy887;
			goto yy835;
		}
	}
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == '/')	goto yy888;
		if(yych <= 'm')	goto yy835;
		goto yy885;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy835;
			goto yy886;
		} else {
			if(yych <= 's')	goto yy884;
			if(yych <= 't')	goto yy887;
			goto yy835;
		}
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy883;
		if(yych <= 'T')	goto yy53;
		goto yy882;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy883;
		} else {
			if(yych == 'u')	goto yy882;
			goto yy53;
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy881;
	if(yych == 'e')	goto yy881;
	goto yy53;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy880;
	if(yych == 'a')	goto yy880;
	goto yy53;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy879;
		if(yych <= 'T')	goto yy53;
		goto yy878;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy879;
		} else {
			if(yych == 'u')	goto yy878;
			goto yy53;
		}
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy876;
	if(yych == 'e')	goto yy876;
	goto yy53;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy875;
	if(yych == 'c')	goto yy875;
	goto yy53;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy874;
	if(yych == 'o')	goto yy874;
	goto yy53;
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy846;
	if(yych != 'e')	goto yy53;
	goto yy846;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy847;
	if(yych != 'c')	goto yy53;
	goto yy847;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy53;
	goto yy848;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy849;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy850;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy851;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy852;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy853;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy854;
	if(yych <= '2')	goto yy855;
	goto yy53;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy856;
	goto yy53;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '4')	goto yy53;
	goto yy856;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy857;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy858;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy859;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy860;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy861;
	if(yych <= '6')	goto yy862;
	goto yy53;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy863;
	goto yy53;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy53;
	goto yy863;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 0x09)	goto yy864;
	if(yych != ' ')	goto yy53;
	goto yy864;
yy864:
	YYDEBUG(864, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy865;
yy865:
	YYDEBUG(865, *YYCURSOR);
	if(yych <= ' '){
		if(yych == 0x09)	goto yy864;
		if(yych <= 0x1F)	goto yy53;
		goto yy864;
	} else {
		if(yych <= '+'){
			if(yych <= '*')	goto yy53;
			goto yy866;
		} else {
			if(yych != '-')	goto yy53;
			goto yy866;
		}
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy867;
	if(yych <= '2')	goto yy869;
	if(yych <= '9')	goto yy870;
	goto yy53;
yy867:
	YYDEBUG(867, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy868;
	if(yych <= '9')	goto yy870;
	if(yych <= ':')	goto yy871;
	goto yy868;
yy868:
	YYDEBUG(868, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy868;
		if(yych >= '4')	goto yy872;
		goto yy870;
	} else {
		if(yych <= '9')	goto yy873;
		if(yych <= ':')	goto yy871;
		goto yy868;
	}
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy868;
	if(yych <= '5')	goto yy872;
	if(yych <= '9')	goto yy873;
	if(yych >= ';')	goto yy868;
	goto yy871;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy868;
	if(yych <= '5')	goto yy872;
	if(yych <= '9')	goto yy873;
	goto yy868;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy868;
	if(yych >= ':')	goto yy868;
	goto yy873;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy868;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy847;
	if(yych == 'v')	goto yy847;
	goto yy53;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy847;
	if(yych == 't')	goto yy847;
	goto yy53;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy877;
	if(yych != 'p')	goto yy53;
	goto yy877;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == '/')	goto yy848;
		goto yy53;
	} else {
		if(yych <= 'T')	goto yy847;
		if(yych == 't')	goto yy847;
		goto yy53;
	}
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy847;
	if(yych == 'g')	goto yy847;
	goto yy53;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy847;
	if(yych == 'r')	goto yy847;
	goto yy53;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy847;
		if(yych <= 'X')	goto yy53;
		goto yy847;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy847;
		} else {
			if(yych == 'y')	goto yy847;
			goto yy53;
		}
	}
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy847;
	if(yych == 'b')	goto yy847;
	goto yy53;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy847;
		if(yych <= 'M')	goto yy53;
		goto yy847;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy847;
		} else {
			if(yych == 'n')	goto yy847;
			goto yy53;
		}
	}
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy847;
	if(yych == 'n')	goto yy847;
	goto yy53;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy893;
	goto yy53;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy893;
	goto yy53;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy893;
	goto yy53;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'h')	goto yy893;
	goto yy53;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy889;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy835;
	if(yych >= ':')	goto yy835;
	goto yy890;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy835;
	if(yych >= ':')	goto yy835;
	goto yy891;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy835;
	if(yych >= ':')	goto yy835;
	goto yy892;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy835;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '/')	goto yy888;
	goto yy835;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ','){
		if(yych == 0x09)	goto yy896;
		goto yy749;
	} else {
		if(yych <= '.')	goto yy896;
		if(yych >= '0')	goto yy749;
		goto yy895;
	}
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'A':	case 'a':	goto yy841;
	case 'D':	case 'd':	goto yy845;
	case 'F':	case 'f':	goto yy839;
	case 'J':	case 'j':	goto yy838;
	case 'M':	case 'm':	goto yy840;
	case 'N':	case 'n':	goto yy844;
	case 'O':	case 'o':	goto yy843;
	case 'S':	case 's':	goto yy842;
	default:	goto yy53;
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy749;
	if(yych <= '0')	goto yy897;
	if(yych <= '1')	goto yy898;
	if(yych <= '9')	goto yy899;
	goto yy749;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ',')	goto yy53;
	if(yych <= '.')	goto yy772;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy899;
	goto yy53;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ',')	goto yy53;
	if(yych <= '.')	goto yy772;
	if(yych <= '/')	goto yy53;
	if(yych >= '3')	goto yy53;
	goto yy899;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ',')	goto yy53;
	if(yych <= '.')	goto yy772;
	goto yy53;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy901;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy935;
	goto yy57;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy910;
	case '1':	goto yy911;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy912;
	case 'A':	case 'a':	goto yy905;
	case 'D':	case 'd':	goto yy909;
	case 'F':	case 'f':	goto yy903;
	case 'J':	case 'j':	goto yy902;
	case 'M':	case 'm':	goto yy904;
	case 'N':	case 'n':	goto yy908;
	case 'O':	case 'o':	goto yy907;
	case 'S':	case 's':	goto yy906;
	default:	goto yy53;
	}
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy934;
		if(yych <= 'T')	goto yy53;
		goto yy933;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy934;
		} else {
			if(yych == 'u')	goto yy933;
			goto yy53;
		}
	}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy932;
	if(yych == 'e')	goto yy932;
	goto yy53;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy931;
	if(yych == 'a')	goto yy931;
	goto yy53;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy930;
		if(yych <= 'T')	goto yy53;
		goto yy929;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy930;
		} else {
			if(yych == 'u')	goto yy929;
			goto yy53;
		}
	}
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy927;
	if(yych == 'e')	goto yy927;
	goto yy53;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy926;
	if(yych == 'c')	goto yy926;
	goto yy53;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy925;
	if(yych == 'o')	goto yy925;
	goto yy53;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy917;
	if(yych == 'e')	goto yy917;
	goto yy53;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy913;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy912;
	goto yy53;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy913;
	if(yych <= '/')	goto yy53;
	if(yych >= '3')	goto yy53;
	goto yy912;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy53;
	goto yy913;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy914;
	if(yych <= '3')	goto yy915;
	if(yych <= '9')	goto yy916;
	goto yy53;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy825;
		if(yych <= '9')	goto yy916;
		if(yych <= 'm')	goto yy825;
		goto yy829;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy825;
			goto yy830;
		} else {
			if(yych <= 's')	goto yy828;
			if(yych <= 't')	goto yy831;
			goto yy825;
		}
	}
yy915:
	YYDEBUG(915, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy825;
		if(yych <= '1')	goto yy916;
		if(yych <= 'm')	goto yy825;
		goto yy829;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy825;
			goto yy830;
		} else {
			if(yych <= 's')	goto yy828;
			if(yych <= 't')	goto yy831;
			goto yy825;
		}
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'q'){
		if(yych == 'n')	goto yy829;
		goto yy825;
	} else {
		if(yych <= 'r')	goto yy830;
		if(yych <= 's')	goto yy828;
		if(yych <= 't')	goto yy831;
		goto yy825;
	}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy918;
	if(yych != 'c')	goto yy53;
	goto yy918;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy53;
	goto yy919;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy920;
	if(yych <= '2')	goto yy921;
	if(yych <= '3')	goto yy922;
	goto yy53;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy923;
	goto yy53;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy923;
	goto yy53;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '2')	goto yy53;
	goto yy923;
yy923:
	YYDEBUG(923, *YYCURSOR);
	++YYCURSOR;
	goto yy924;
yy924:
	YYDEBUG(924, *YYCURSOR);

{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy918;
	if(yych == 'v')	goto yy918;
	goto yy53;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy918;
	if(yych == 't')	goto yy918;
	goto yy53;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy928;
	if(yych != 'p')	goto yy53;
	goto yy928;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == '-')	goto yy919;
		goto yy53;
	} else {
		if(yych <= 'T')	goto yy918;
		if(yych == 't')	goto yy918;
		goto yy53;
	}
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy918;
	if(yych == 'g')	goto yy918;
	goto yy53;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy918;
	if(yych == 'r')	goto yy918;
	goto yy53;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy918;
		if(yych <= 'X')	goto yy53;
		goto yy918;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy918;
		} else {
			if(yych == 'y')	goto yy918;
			goto yy53;
		}
	}
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy918;
	if(yych == 'b')	goto yy918;
	goto yy53;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy918;
		if(yych <= 'M')	goto yy53;
		goto yy918;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy918;
		} else {
			if(yych == 'n')	goto yy918;
			goto yy53;
		}
	}
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy918;
	if(yych == 'n')	goto yy918;
	goto yy53;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy940;
	case '-':	goto yy937;
	case '.':	goto yy941;
	case '/':	goto yy938;
	case '0':	goto yy954;
	case '1':	goto yy955;
	case '2':	goto yy957;
	case '3':	goto yy958;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy956;
	case 'W':	goto yy959;
	default:	goto yy936;
	}
yy936:
	YYDEBUG(936, *YYCURSOR);

{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy1123;
	case '1':	goto yy1125;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1126;
	case 'A':	case 'a':	goto yy1117;
	case 'D':	case 'd':	goto yy1121;
	case 'F':	case 'f':	goto yy1115;
	case 'J':	case 'j':	goto yy1114;
	case 'M':	case 'm':	goto yy1116;
	case 'N':	case 'n':	goto yy1120;
	case 'O':	case 'o':	goto yy1119;
	case 'S':	case 's':	goto yy1118;
	case 'W':	goto yy1122;
	default:	goto yy1087;
	}
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy1095;
	if(yych <= '1')	goto yy1096;
	if(yych <= '9')	goto yy1097;
	goto yy53;
yy939:
	YYDEBUG(939, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy940;
yy940:
	YYDEBUG(940, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	goto yy939;
	case '-':
	case '.':	goto yy1086;
	case 'A':	case 'a':	goto yy949;
	case 'D':	case 'd':	goto yy953;
	case 'F':	case 'f':	goto yy947;
	case 'H':	case 'h':	goto yy60;
	case 'I':	goto yy942;
	case 'J':	case 'j':	goto yy946;
	case 'M':	case 'm':	goto yy948;
	case 'N':	case 'n':	goto yy952;
	case 'O':	case 'o':	goto yy951;
	case 'S':	case 's':	goto yy950;
	case 'T':	case 't':	goto yy65;
	case 'V':	goto yy944;
	case 'W':	case 'w':	goto yy62;
	case 'X':	goto yy945;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1087;
	if(yych <= '0')	goto yy1079;
	if(yych <= '2')	goto yy1080;
	if(yych <= '3')	goto yy1081;
	goto yy1087;
yy942:
	YYDEBUG(942, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'U'){
		if(yych == 'I')	goto yy1078;
		goto yy943;
	} else {
		if(yych == 'W')	goto yy943;
		if(yych <= 'X')	goto yy1032;
		goto yy943;
	}
yy943:
	YYDEBUG(943, *YYCURSOR);

{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1076;
	goto yy943;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1075;
	goto yy943;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1068;
		if(yych <= 'T')	goto yy53;
		goto yy1067;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy1068;
		} else {
			if(yych == 'u')	goto yy1067;
			goto yy53;
		}
	}
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy1061;
			goto yy53;
		} else {
			if(yych <= 'O')	goto yy83;
			if(yych <= 'Q')	goto yy53;
			goto yy82;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy1061;
			goto yy53;
		} else {
			if(yych <= 'o')	goto yy83;
			if(yych == 'r')	goto yy82;
			goto yy53;
		}
	}
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy1058;
			goto yy53;
		} else {
			if(yych <= 'I')	goto yy114;
			if(yych <= 'N')	goto yy53;
			goto yy113;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy1058;
			goto yy53;
		} else {
			if(yych <= 'i')	goto yy114;
			if(yych == 'o')	goto yy113;
			goto yy53;
		}
	}
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy1052;
		if(yych <= 'T')	goto yy53;
		goto yy1051;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy1052;
		} else {
			if(yych == 'u')	goto yy1051;
			goto yy53;
		}
	}
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy1044;
			if(yych <= 'T')	goto yy53;
			goto yy122;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy123;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy1044;
			if(yych == 'u')	goto yy122;
			goto yy53;
		}
	}
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1039;
	if(yych == 'c')	goto yy1039;
	goto yy53;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1033;
	if(yych == 'o')	goto yy1033;
	goto yy53;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'A')	goto yy110;
		if(yych <= 'D')	goto yy53;
		goto yy1026;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy110;
		} else {
			if(yych == 'e')	goto yy1026;
			goto yy53;
		}
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy1024;
	if(yych <= '9')	goto yy1025;
	goto yy57;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '2')	goto yy993;
	if(yych <= '9')	goto yy972;
	goto yy57;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy973;
	if(yych <= '1')	goto yy974;
	goto yy53;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy972;
	goto yy57;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '5')	goto yy968;
	if(yych <= '6')	goto yy969;
	if(yych <= '9')	goto yy51;
	goto yy57;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy53;
		if(yych <= '0')	goto yy960;
		if(yych <= '4')	goto yy961;
		goto yy962;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy53;
			goto yy98;
		} else {
			if(yych == 'e')	goto yy98;
			goto yy53;
		}
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy963;
	goto yy53;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy963;
	goto yy53;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '4')	goto yy53;
	goto yy963;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy965;
	if(yych <= '/')	goto yy964;
	if(yych <= '7')	goto yy966;
	goto yy964;
yy964:
	YYDEBUG(964, *YYCURSOR);

{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '8')	goto yy53;
	goto yy966;
yy966:
	YYDEBUG(966, *YYCURSOR);
	++YYCURSOR;
	goto yy967;
yy967:
	YYDEBUG(967, *YYCURSOR);

{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy970;
	goto yy57;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '6')	goto yy970;
	if(yych <= '9')	goto yy51;
	goto yy57;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych >= ' ')	goto yy57;
				goto yy971;
			} else {
				if(yych == 'D')	goto yy57;
				if(yych >= 'F')	goto yy57;
				goto yy971;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy57;
				if(yych >= 'M')	goto yy57;
				goto yy971;
			} else {
				if(yych <= 'R')	goto yy971;
				if(yych <= 'T')	goto yy57;
				if(yych >= 'W')	goto yy57;
				goto yy971;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy57;
				if(yych >= 'd')	goto yy57;
				goto yy971;
			} else {
				if(yych == 'f')	goto yy57;
				if(yych >= 'h')	goto yy57;
				goto yy971;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych >= 's')	goto yy57;
				goto yy971;
			} else {
				if(yych <= 'w'){
					if(yych >= 'w')	goto yy57;
					goto yy971;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy971;
				}
			}
		}
	}
yy971:
	YYDEBUG(971, *YYCURSOR);

{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy970;
	goto yy57;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy975;
	goto yy53;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '3')	goto yy53;
	goto yy975;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy976;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy977;
	if(yych <= '2')	goto yy978;
	if(yych <= '3')	goto yy979;
	goto yy53;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy980;
	goto yy53;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy980;
	goto yy53;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '2')	goto yy53;
	goto yy980;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ' ')	goto yy53;
	goto yy981;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy982;
	if(yych <= '2')	goto yy983;
	goto yy53;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy984;
	goto yy53;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '4')	goto yy53;
	goto yy984;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy985;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy986;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy987;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy988;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy989;
	if(yych <= '6')	goto yy990;
	goto yy53;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy991;
	goto yy53;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy53;
	goto yy991;
yy991:
	YYDEBUG(991, *YYCURSOR);
	++YYCURSOR;
	goto yy992;
yy992:
	YYDEBUG(992, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy57;
		if(yych >= '1')	goto yy995;
		goto yy994;
	} else {
		if(yych <= '3')	goto yy996;
		if(yych <= '9')	goto yy970;
		goto yy57;
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy971;
				goto yy57;
			} else {
				if(yych <= '0'){
					if(yych <= '/')	goto yy971;
					goto yy51;
				} else {
					if(yych <= '9')	goto yy997;
					if(yych <= 'C')	goto yy971;
					goto yy57;
				}
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy971;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy971;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy971;
					if(yych <= 'T')	goto yy57;
					goto yy971;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy971;
				if(yych <= 'Y')	goto yy57;
				goto yy971;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy971;
				} else {
					if(yych == 'g')	goto yy971;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy971;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy971;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy971;
				}
			}
		}
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy971;
				goto yy57;
			} else {
				if(yych <= '/')	goto yy971;
				if(yych <= '9')	goto yy997;
				if(yych <= 'C')	goto yy971;
				goto yy57;
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy971;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy971;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy971;
					if(yych <= 'T')	goto yy57;
					goto yy971;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy971;
				if(yych <= 'Y')	goto yy57;
				goto yy971;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy971;
				} else {
					if(yych == 'g')	goto yy971;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy971;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy971;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy971;
				}
			}
		}
	}
yy996:
	YYDEBUG(996, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy971;
				goto yy57;
			} else {
				if(yych <= '1'){
					if(yych <= '/')	goto yy971;
					goto yy997;
				} else {
					if(yych <= '9')	goto yy51;
					if(yych <= 'C')	goto yy971;
					goto yy57;
				}
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy971;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy971;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy971;
					if(yych <= 'T')	goto yy57;
					goto yy971;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy971;
				if(yych <= 'Y')	goto yy57;
				goto yy971;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy971;
				} else {
					if(yych == 'g')	goto yy971;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy971;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy971;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy971;
				}
			}
		}
	}
yy997:
	YYDEBUG(997, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy56;
				if(yych >= ' ')	goto yy56;
				goto yy998;
			} else {
				if(yych == 'D')	goto yy61;
				if(yych >= 'F')	goto yy63;
				goto yy998;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy60;
				if(yych >= 'M')	goto yy59;
				goto yy998;
			} else {
				if(yych <= 'S'){
					if(yych >= 'S')	goto yy58;
					goto yy998;
				} else {
					if(yych <= 'T')	goto yy999;
					if(yych >= 'W')	goto yy62;
					goto yy998;
				}
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy64;
				if(yych >= 'd')	goto yy61;
				goto yy998;
			} else {
				if(yych <= 'f'){
					if(yych >= 'f')	goto yy63;
					goto yy998;
				} else {
					if(yych == 'h')	goto yy60;
					goto yy998;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'm')	goto yy59;
				if(yych <= 'r')	goto yy998;
				if(yych <= 's')	goto yy58;
				goto yy1000;
			} else {
				if(yych <= 'w'){
					if(yych >= 'w')	goto yy62;
					goto yy998;
				} else {
					if(yych == 'y')	goto yy64;
					goto yy998;
				}
			}
		}
	}
yy998:
	YYDEBUG(998, *YYCURSOR);

{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '2'){
			if(yych <= '/')	goto yy53;
			if(yych <= '1')	goto yy1014;
			goto yy1015;
		} else {
			if(yych <= '9')	goto yy1016;
			if(yych <= 'G')	goto yy53;
			goto yy66;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'U')	goto yy67;
			goto yy53;
		} else {
			if(yych <= 'h')	goto yy66;
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '2'){
			if(yych <= '/')	goto yy53;
			if(yych >= '2')	goto yy1002;
			goto yy1001;
		} else {
			if(yych <= '9')	goto yy1003;
			if(yych <= 'G')	goto yy53;
			goto yy66;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'U')	goto yy67;
			goto yy53;
		} else {
			if(yych <= 'h')	goto yy66;
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1008;
	if(yych <= '9')	goto yy1003;
	goto yy53;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '3')	goto yy1008;
	if(yych <= '5')	goto yy1004;
	goto yy53;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy1004;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1005;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1006;
	if(yych <= '6')	goto yy1007;
	goto yy53;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy991;
	goto yy53;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy991;
	goto yy53;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1009;
	if(yych <= '9')	goto yy1005;
	goto yy53;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1010;
	if(yych <= '6')	goto yy1011;
	if(yych <= '9')	goto yy1005;
	goto yy53;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1012;
	if(yych <= '6')	goto yy1013;
	if(yych <= '9')	goto yy991;
	goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy1012;
	if(yych <= '5')	goto yy1006;
	if(yych <= '6')	goto yy1007;
	goto yy53;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '9')	goto yy991;
	goto yy992;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy991;
	goto yy992;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1023;
	if(yych <= '9')	goto yy1016;
	if(yych <= ':')	goto yy1017;
	goto yy53;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy53;
		if(yych <= '3')	goto yy1023;
		goto yy1004;
	} else {
		if(yych == ':')	goto yy1017;
		goto yy53;
	}
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1004;
	if(yych != ':')	goto yy53;
	goto yy1017;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy1018;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1019;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1020;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1021;
	if(yych <= '6')	goto yy1022;
	goto yy53;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy991;
	goto yy53;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy991;
	goto yy53;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1009;
	if(yych <= '9')	goto yy1005;
	if(yych <= ':')	goto yy1017;
	goto yy53;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy51;
	if(yych <= '9')	goto yy970;
	goto yy57;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy57;
		if(yych <= '0')	goto yy994;
		goto yy995;
	} else {
		if(yych <= '3')	goto yy996;
		if(yych <= '9')	goto yy970;
		goto yy57;
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1027;
	if(yych != 'c')	goto yy53;
	goto yy1027;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy1028;
	if(yych != 'e')	goto yy943;
	goto yy1028;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1029;
	if(yych != 'm')	goto yy53;
	goto yy1029;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1030;
	if(yych != 'b')	goto yy53;
	goto yy1030;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1031;
	if(yych != 'e')	goto yy53;
	goto yy1031;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1032;
	if(yych != 'r')	goto yy53;
	goto yy1032;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy943;
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1034;
	if(yych != 'v')	goto yy53;
	goto yy1034;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy1035;
	if(yych != 'e')	goto yy943;
	goto yy1035;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1036;
	if(yych != 'm')	goto yy53;
	goto yy1036;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1037;
	if(yych != 'b')	goto yy53;
	goto yy1037;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1038;
	if(yych != 'e')	goto yy53;
	goto yy1038;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1032;
	if(yych == 'r')	goto yy1032;
	goto yy53;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1040;
	if(yych != 't')	goto yy53;
	goto yy1040;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'O')	goto yy1041;
	if(yych != 'o')	goto yy943;
	goto yy1041;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1042;
	if(yych != 'b')	goto yy53;
	goto yy1042;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1043;
	if(yych != 'e')	goto yy53;
	goto yy1043;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1032;
	if(yych == 'r')	goto yy1032;
	goto yy53;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'C')	goto yy125;
		if(yych <= 'O')	goto yy53;
		goto yy1045;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy53;
			goto yy125;
		} else {
			if(yych != 'p')	goto yy53;
			goto yy1045;
		}
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1046;
	if(yych != 't')	goto yy943;
	goto yy1046;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy1047;
	if(yych != 'e')	goto yy943;
	goto yy1047;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1048;
	if(yych != 'm')	goto yy53;
	goto yy1048;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1049;
	if(yych != 'b')	goto yy53;
	goto yy1049;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1050;
	if(yych != 'e')	goto yy53;
	goto yy1050;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1032;
	if(yych == 'r')	goto yy1032;
	goto yy53;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1055;
	if(yych == 'g')	goto yy1055;
	goto yy53;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1053;
	if(yych != 'r')	goto yy53;
	goto yy1053;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'I')	goto yy1054;
	if(yych != 'i')	goto yy943;
	goto yy1054;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1032;
	if(yych == 'l')	goto yy1032;
	goto yy53;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy1056;
	if(yych != 'u')	goto yy943;
	goto yy1056;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1057;
	if(yych != 's')	goto yy53;
	goto yy1057;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1032;
	if(yych == 't')	goto yy1032;
	goto yy53;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy1059;
		if(yych <= 'X')	goto yy53;
		goto yy1032;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy1059;
		} else {
			if(yych == 'y')	goto yy1032;
			goto yy53;
		}
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'C')	goto yy1060;
	if(yych != 'c')	goto yy943;
	goto yy1060;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1032;
	if(yych == 'h')	goto yy1032;
	goto yy53;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1062;
	if(yych != 'b')	goto yy53;
	goto yy1062;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy1063;
	if(yych != 'r')	goto yy943;
	goto yy1063;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1064;
	if(yych != 'u')	goto yy53;
	goto yy1064;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1065;
	if(yych != 'a')	goto yy53;
	goto yy1065;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1066;
	if(yych != 'r')	goto yy53;
	goto yy1066;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1032;
	if(yych == 'y')	goto yy1032;
	goto yy53;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1074;
		if(yych <= 'M')	goto yy53;
		goto yy1073;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy1074;
		} else {
			if(yych == 'n')	goto yy1073;
			goto yy53;
		}
	}
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1069;
	if(yych != 'n')	goto yy53;
	goto yy1069;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy1070;
	if(yych != 'u')	goto yy943;
	goto yy1070;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1071;
	if(yych != 'a')	goto yy53;
	goto yy1071;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1072;
	if(yych != 'r')	goto yy53;
	goto yy1072;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1032;
	if(yych == 'y')	goto yy1032;
	goto yy53;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1032;
	if(yych == 'e')	goto yy1032;
	goto yy943;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1032;
	if(yych == 'y')	goto yy1032;
	goto yy943;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1032;
	goto yy943;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'I')	goto yy943;
	goto yy1077;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1032;
	goto yy943;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1032;
	goto yy943;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy1094;
	if(yych <= '9')	goto yy1093;
	goto yy53;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1092;
	goto yy53;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1090;
	if(yych <= '6')	goto yy1089;
	goto yy53;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1061;
	if(yych == 'e')	goto yy1061;
	goto yy53;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1058;
	if(yych == 'a')	goto yy1058;
	goto yy53;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1088;
	if(yych == 'e')	goto yy1088;
	goto yy53;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1026;
	if(yych == 'e')	goto yy1026;
	goto yy53;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	goto yy1087;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	case '-':
	case '.':	goto yy1086;
	case 'A':	case 'a':	goto yy949;
	case 'D':	case 'd':	goto yy1085;
	case 'F':	case 'f':	goto yy1082;
	case 'I':	goto yy942;
	case 'J':	case 'j':	goto yy946;
	case 'M':	case 'm':	goto yy1083;
	case 'N':	case 'n':	goto yy952;
	case 'O':	case 'o':	goto yy951;
	case 'S':	case 's':	goto yy1084;
	case 'V':	goto yy944;
	case 'X':	goto yy945;
	default:	goto yy53;
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1045;
	if(yych == 'p')	goto yy1045;
	goto yy53;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '6')	goto yy1091;
	goto yy53;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1091;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy971;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1091;
	goto yy53;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1091;
	goto yy53;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy1091;
	goto yy53;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.')	goto yy53;
	if(yych <= '/')	goto yy1098;
	if(yych <= '0')	goto yy1097;
	if(yych <= '9')	goto yy1108;
	goto yy53;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.')	goto yy53;
	if(yych <= '/')	goto yy1098;
	if(yych <= '2')	goto yy1108;
	goto yy53;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy53;
	goto yy1098;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy1099;
	if(yych <= '3')	goto yy1101;
	if(yych <= '9')	goto yy1102;
	goto yy53;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1100;
		if(yych <= '9')	goto yy1102;
		if(yych >= 'n')	goto yy1104;
		goto yy1100;
	} else {
		if(yych <= 'r'){
			if(yych >= 'r')	goto yy1105;
			goto yy1100;
		} else {
			if(yych <= 's')	goto yy1103;
			if(yych <= 't')	goto yy1106;
			goto yy1100;
		}
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);

{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1100;
		if(yych <= '1')	goto yy1102;
		if(yych <= 'm')	goto yy1100;
		goto yy1104;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1100;
			goto yy1105;
		} else {
			if(yych <= 's')	goto yy1103;
			if(yych <= 't')	goto yy1106;
			goto yy1100;
		}
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'q'){
		if(yych == 'n')	goto yy1104;
		goto yy1100;
	} else {
		if(yych <= 'r')	goto yy1105;
		if(yych <= 's')	goto yy1103;
		if(yych <= 't')	goto yy1106;
		goto yy1100;
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy1107;
	goto yy53;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1107;
	goto yy53;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1107;
	goto yy53;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'h')	goto yy53;
	goto yy1107;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1100;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy53;
	goto yy1109;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy53;
		if(yych >= '1')	goto yy1111;
		goto yy1110;
	} else {
		if(yych <= '3')	goto yy1112;
		if(yych <= '9')	goto yy1102;
		goto yy53;
	}
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '0'){
			if(yych <= '/')	goto yy1100;
			goto yy1102;
		} else {
			if(yych <= '9')	goto yy1113;
			if(yych <= 'm')	goto yy1100;
			goto yy1104;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1100;
			goto yy1105;
		} else {
			if(yych <= 's')	goto yy1103;
			if(yych <= 't')	goto yy1106;
			goto yy1100;
		}
	}
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1100;
		if(yych <= '9')	goto yy1113;
		if(yych <= 'm')	goto yy1100;
		goto yy1104;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1100;
			goto yy1105;
		} else {
			if(yych <= 's')	goto yy1103;
			if(yych <= 't')	goto yy1106;
			goto yy1100;
		}
	}
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1100;
		if(yych <= '1')	goto yy1113;
		if(yych <= 'm')	goto yy1100;
		goto yy1104;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1100;
			goto yy1105;
		} else {
			if(yych <= 's')	goto yy1103;
			if(yych <= 't')	goto yy1106;
			goto yy1100;
		}
	}
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == '/')	goto yy1107;
		if(yych <= 'm')	goto yy1100;
		goto yy1104;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1100;
			goto yy1105;
		} else {
			if(yych <= 's')	goto yy1103;
			if(yych <= 't')	goto yy1106;
			goto yy1100;
		}
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1191;
		if(yych <= 'T')	goto yy53;
		goto yy1190;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy1191;
		} else {
			if(yych == 'u')	goto yy1190;
			goto yy53;
		}
	}
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1188;
	if(yych == 'e')	goto yy1188;
	goto yy53;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1185;
	if(yych == 'a')	goto yy1185;
	goto yy53;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy1182;
		if(yych <= 'T')	goto yy53;
		goto yy1181;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy1182;
		} else {
			if(yych == 'u')	goto yy1181;
			goto yy53;
		}
	}
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1178;
	if(yych == 'e')	goto yy1178;
	goto yy53;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1176;
	if(yych == 'c')	goto yy1176;
	goto yy53;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1174;
	if(yych == 'o')	goto yy1174;
	goto yy53;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1172;
	if(yych == 'e')	goto yy1172;
	goto yy53;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy960;
	if(yych <= '4')	goto yy961;
	if(yych <= '5')	goto yy962;
	goto yy53;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '-')	goto yy1127;
		goto yy1124;
	} else {
		if(yych <= '0')	goto yy1126;
		if(yych <= '9')	goto yy1146;
		goto yy1124;
	}
yy1124:
	YYDEBUG(1124, *YYCURSOR);

{
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy1127;
	if(yych <= '/')	goto yy1124;
	if(yych <= '2')	goto yy1146;
	goto yy1124;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '-')	goto yy1124;
	goto yy1127;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy1128;
	if(yych <= '3')	goto yy1129;
	if(yych <= '9')	goto yy1130;
	goto yy53;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy825;
			goto yy1130;
		} else {
			if(yych == 'T')	goto yy1135;
			goto yy825;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1132;
			if(yych <= 'q')	goto yy825;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy825;
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy825;
			goto yy1130;
		} else {
			if(yych == 'T')	goto yy1135;
			goto yy825;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1132;
			if(yych <= 'q')	goto yy825;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy825;
		}
	}
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == 'T')	goto yy1135;
		if(yych <= 'm')	goto yy825;
		goto yy1132;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy825;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy825;
		}
	}
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy1145;
	goto yy53;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1145;
	goto yy53;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1145;
	goto yy53;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'h')	goto yy1145;
	goto yy53;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy1136;
	if(yych <= '2')	goto yy1137;
	if(yych <= '9')	goto yy1138;
	goto yy53;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1138;
	if(yych <= ':')	goto yy1139;
	goto yy53;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '3')	goto yy1138;
	if(yych == ':')	goto yy1139;
	goto yy53;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1139;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1140;
	if(yych <= '9')	goto yy1141;
	goto yy53;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1141;
	if(yych <= ':')	goto yy1142;
	goto yy53;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1142;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1143;
	if(yych <= '6')	goto yy1144;
	if(yych <= '9')	goto yy991;
	goto yy53;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '9')	goto yy991;
	goto yy992;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy991;
	goto yy992;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'T')	goto yy1135;
	goto yy825;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '-')	goto yy1124;
	goto yy1147;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy53;
		if(yych >= '1')	goto yy1149;
		goto yy1148;
	} else {
		if(yych <= '3')	goto yy1150;
		if(yych <= '9')	goto yy1130;
		goto yy53;
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy825;
			if(yych <= '0')	goto yy1130;
			goto yy1151;
		} else {
			if(yych == 'T')	goto yy1135;
			goto yy825;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1132;
			if(yych <= 'q')	goto yy825;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy825;
		}
	}
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy825;
			goto yy1151;
		} else {
			if(yych == 'T')	goto yy1135;
			goto yy825;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1132;
			if(yych <= 'q')	goto yy825;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy825;
		}
	}
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy825;
			goto yy1151;
		} else {
			if(yych == 'T')	goto yy1135;
			goto yy825;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1132;
			if(yych <= 'q')	goto yy825;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy825;
		}
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == 'T')	goto yy1152;
		if(yych <= 'm')	goto yy1100;
		goto yy1132;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1100;
			goto yy1133;
		} else {
			if(yych <= 's')	goto yy1131;
			if(yych <= 't')	goto yy1134;
			goto yy1100;
		}
	}
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy1153;
	if(yych <= '2')	goto yy1154;
	if(yych <= '9')	goto yy1138;
	goto yy53;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1155;
	if(yych <= ':')	goto yy1139;
	goto yy53;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '3')	goto yy1155;
	if(yych == ':')	goto yy1139;
	goto yy53;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1156;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1157;
	if(yych <= '9')	goto yy1141;
	goto yy53;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1158;
	if(yych <= ':')	goto yy1142;
	goto yy53;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1159;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1160;
	if(yych <= '6')	goto yy1161;
	if(yych <= '9')	goto yy991;
	goto yy53;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '9')	goto yy1162;
	goto yy992;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy992;
	goto yy1162;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '.')	goto yy992;
	goto yy1163;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1164;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yyaccept = 22;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy1165;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	if(yych <= ','){
		if(yych != '+')	goto yy992;
		goto yy1166;
	} else {
		if(yych <= '-')	goto yy1166;
		if(yych <= '/')	goto yy992;
		if(yych <= '9')	goto yy1164;
		goto yy992;
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy1167;
	if(yych <= '2')	goto yy1168;
	if(yych <= '9')	goto yy1169;
	goto yy53;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '9')	goto yy1169;
	if(yych <= ':')	goto yy1170;
	goto yy992;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy992;
		if(yych >= '4')	goto yy1171;
		goto yy1169;
	} else {
		if(yych <= '9')	goto yy991;
		if(yych <= ':')	goto yy1170;
		goto yy992;
	}
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '5')	goto yy1171;
	if(yych <= '9')	goto yy991;
	if(yych >= ';')	goto yy992;
	goto yy1170;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '5')	goto yy1171;
	if(yych <= '9')	goto yy991;
	goto yy992;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy992;
	if(yych <= '9')	goto yy991;
	goto yy992;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1173;
	if(yych != 'c')	goto yy53;
	goto yy1173;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'E')	goto yy1028;
		if(yych == 'e')	goto yy1028;
		goto yy943;
	}
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1175;
	if(yych != 'v')	goto yy53;
	goto yy1175;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'E')	goto yy1035;
		if(yych == 'e')	goto yy1035;
		goto yy943;
	}
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1177;
	if(yych != 't')	goto yy53;
	goto yy1177;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'O')	goto yy1041;
		if(yych == 'o')	goto yy1041;
		goto yy943;
	}
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1179;
	if(yych != 'p')	goto yy53;
	goto yy1179;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'T')	goto yy1180;
		if(yych != 't')	goto yy943;
		goto yy1180;
	}
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'E')	goto yy1047;
		if(yych == 'e')	goto yy1047;
		goto yy943;
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1184;
	if(yych == 'g')	goto yy1184;
	goto yy53;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1183;
	if(yych != 'r')	goto yy53;
	goto yy1183;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'I')	goto yy1054;
		if(yych == 'i')	goto yy1054;
		goto yy943;
	}
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'U')	goto yy1056;
		if(yych == 'u')	goto yy1056;
		goto yy943;
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy1186;
		if(yych <= 'X')	goto yy53;
		goto yy1187;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy1186;
		} else {
			if(yych == 'y')	goto yy1187;
			goto yy53;
		}
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'C')	goto yy1060;
		if(yych == 'c')	goto yy1060;
		goto yy943;
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy919;
	goto yy943;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1189;
	if(yych != 'b')	goto yy53;
	goto yy1189;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'R')	goto yy1063;
		if(yych == 'r')	goto yy1063;
		goto yy943;
	}
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1194;
		if(yych <= 'M')	goto yy53;
		goto yy1193;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy1194;
		} else {
			if(yych == 'n')	goto yy1193;
			goto yy53;
		}
	}
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1192;
	if(yych != 'n')	goto yy53;
	goto yy1192;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'U')	goto yy1070;
		if(yych == 'u')	goto yy1070;
		goto yy943;
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'E')	goto yy1032;
		if(yych == 'e')	goto yy1032;
		goto yy943;
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych == '-')	goto yy919;
		goto yy943;
	} else {
		if(yych <= 'Y')	goto yy1032;
		if(yych == 'y')	goto yy1032;
		goto yy943;
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych <= 0x09){
			if(yych <= 0x08)	goto yy749;
			goto yy896;
		} else {
			if(yych <= ',')	goto yy749;
			if(yych <= '.')	goto yy896;
			goto yy895;
		}
	} else {
		if(yych <= 'U'){
			if(yych <= 'T')	goto yy749;
			goto yy74;
		} else {
			if(yych == 'u')	goto yy74;
			goto yy749;
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'C')	goto yy125;
		if(yych <= 'O')	goto yy53;
		goto yy757;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy53;
			goto yy125;
		} else {
			if(yych == 'p')	goto yy757;
			goto yy53;
		}
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= ','){
			if(yych != 0x09)	goto yy1200;
			goto yy1198;
		} else {
			if(yych <= '-')	goto yy660;
			if(yych <= '.')	goto yy896;
			if(yych <= '/')	goto yy895;
			goto yy900;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'n')	goto yy657;
			goto yy1200;
		} else {
			if(yych <= 'r')	goto yy658;
			if(yych <= 's')	goto yy651;
			if(yych <= 't')	goto yy655;
			goto yy1200;
		}
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1200;
	if(yych <= '0')	goto yy897;
	if(yych <= '1')	goto yy898;
	if(yych <= '9')	goto yy899;
	goto yy1200;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy1200;
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	goto yy1199;
	case '-':
	case '.':	goto yy748;
	case 'A':	case 'a':	goto yy745;
	case 'D':	case 'd':	goto yy653;
	case 'F':	case 'f':	goto yy654;
	case 'H':	case 'h':	goto yy60;
	case 'I':	goto yy662;
	case 'J':	case 'j':	goto yy666;
	case 'M':	case 'm':	goto yy652;
	case 'N':	case 'n':	goto yy669;
	case 'O':	case 'o':	goto yy668;
	case 'S':	case 's':	goto yy650;
	case 'T':	case 't':	goto yy65;
	case 'V':	goto yy664;
	case 'W':	case 'w':	goto yy62;
	case 'X':	goto yy665;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == 0x09)	goto yy1198;
			if(yych <= ',')	goto yy1200;
			goto yy660;
		} else {
			if(yych <= '.')	goto yy1202;
			if(yych <= '/')	goto yy895;
			if(yych <= '5')	goto yy1204;
			goto yy900;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy1203;
			if(yych == 'n')	goto yy657;
			goto yy1200;
		} else {
			if(yych <= 'r')	goto yy658;
			if(yych <= 's')	goto yy651;
			if(yych <= 't')	goto yy655;
			goto yy1200;
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy749;
		if(yych <= '0')	goto yy1226;
		goto yy1227;
	} else {
		if(yych <= '5')	goto yy1228;
		if(yych <= '9')	goto yy1229;
		goto yy749;
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1221;
	if(yych <= '9')	goto yy1222;
	goto yy53;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy901;
	if(yych <= '/')	goto yy57;
	if(yych >= ':')	goto yy57;
	goto yy1205;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x09:	case ' ':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy940;
	case '-':	goto yy937;
	case '.':	goto yy941;
	case '/':	goto yy938;
	case '0':	goto yy1207;
	case '1':	goto yy1208;
	case '2':	goto yy1209;
	case '3':	goto yy1210;
	case '4':
	case '5':	goto yy1211;
	case '6':	goto yy1212;
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy956;
	case 'W':	goto yy959;
	default:	goto yy1206;
	}
yy1206:
	YYDEBUG(1206, *YYCURSOR);

{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy1219;
	if(yych <= '9')	goto yy1220;
	goto yy57;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '2')	goto yy1218;
	if(yych <= '9')	goto yy1217;
	goto yy57;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy1217;
	goto yy57;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '5')	goto yy1215;
	if(yych <= '6')	goto yy1216;
	if(yych <= '9')	goto yy1213;
	goto yy57;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy1213;
	goto yy57;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy1213;
	if(yych <= '9')	goto yy51;
	goto yy57;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'W'){
		if(yych <= 'F'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych >= ' ')	goto yy57;
				goto yy1214;
			} else {
				if(yych == 'D')	goto yy57;
				if(yych >= 'F')	goto yy57;
				goto yy1214;
			}
		} else {
			if(yych <= 'M'){
				if(yych == 'H')	goto yy57;
				if(yych >= 'M')	goto yy57;
				goto yy1214;
			} else {
				if(yych <= 'R')	goto yy1214;
				if(yych <= 'T')	goto yy57;
				if(yych >= 'W')	goto yy57;
				goto yy1214;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'd'){
				if(yych == 'Y')	goto yy57;
				if(yych >= 'd')	goto yy57;
				goto yy1214;
			} else {
				if(yych == 'f')	goto yy57;
				if(yych >= 'h')	goto yy57;
				goto yy1214;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych >= 's')	goto yy57;
				goto yy1214;
			} else {
				if(yych <= 'w'){
					if(yych >= 'w')	goto yy57;
					goto yy1214;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy1214;
				goto yy57;
			} else {
				if(yych <= '/')	goto yy1214;
				if(yych <= '9')	goto yy970;
				if(yych <= 'C')	goto yy1214;
				goto yy57;
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy1214;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy1214;
					if(yych <= 'T')	goto yy57;
					goto yy1214;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy1214;
				if(yych <= 'Y')	goto yy57;
				goto yy1214;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy1214;
				} else {
					if(yych == 'g')	goto yy1214;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy1214;
				goto yy57;
			} else {
				if(yych <= '6'){
					if(yych <= '/')	goto yy1214;
					goto yy970;
				} else {
					if(yych <= '9')	goto yy51;
					if(yych <= 'C')	goto yy1214;
					goto yy57;
				}
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy1214;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy1214;
					if(yych <= 'T')	goto yy57;
					goto yy1214;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy1214;
				if(yych <= 'Y')	goto yy57;
				goto yy1214;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy1214;
				} else {
					if(yych == 'g')	goto yy1214;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy1214;
				goto yy57;
			} else {
				if(yych <= '/')	goto yy1214;
				if(yych <= '9')	goto yy970;
				if(yych <= 'C')	goto yy1214;
				goto yy57;
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy1214;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy1214;
					if(yych <= 'T')	goto yy57;
					goto yy1214;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy1214;
				if(yych <= 'Y')	goto yy57;
				goto yy1214;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy1214;
				} else {
					if(yych == 'g')	goto yy1214;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '9'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy1214;
				goto yy57;
			} else {
				if(yych <= '0'){
					if(yych <= '/')	goto yy1214;
					goto yy994;
				} else {
					if(yych <= '2')	goto yy995;
					if(yych <= '3')	goto yy996;
					goto yy970;
				}
			}
		} else {
			if(yych <= 'G'){
				if(yych <= 'D'){
					if(yych <= 'C')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'F')	goto yy57;
					goto yy1214;
				}
			} else {
				if(yych <= 'L'){
					if(yych <= 'H')	goto yy57;
					goto yy1214;
				} else {
					if(yych <= 'M')	goto yy57;
					if(yych <= 'R')	goto yy1214;
					goto yy57;
				}
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Y'){
				if(yych == 'W')	goto yy57;
				if(yych <= 'X')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'd'){
					if(yych <= 'c')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'f')	goto yy57;
					goto yy1214;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'l'){
					if(yych <= 'h')	goto yy57;
					goto yy1214;
				} else {
					if(yych <= 'm')	goto yy57;
					if(yych <= 'r')	goto yy1214;
					goto yy57;
				}
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= 'D'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy1214;
				goto yy57;
			} else {
				if(yych <= '0'){
					if(yych <= '/')	goto yy1214;
					goto yy51;
				} else {
					if(yych <= '9')	goto yy970;
					if(yych <= 'C')	goto yy1214;
					goto yy57;
				}
			}
		} else {
			if(yych <= 'H'){
				if(yych == 'F')	goto yy57;
				if(yych <= 'G')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'M'){
					if(yych <= 'L')	goto yy1214;
					goto yy57;
				} else {
					if(yych <= 'R')	goto yy1214;
					if(yych <= 'T')	goto yy57;
					goto yy1214;
				}
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'c'){
				if(yych == 'X')	goto yy1214;
				if(yych <= 'Y')	goto yy57;
				goto yy1214;
			} else {
				if(yych <= 'e'){
					if(yych <= 'd')	goto yy57;
					goto yy1214;
				} else {
					if(yych == 'g')	goto yy1214;
					goto yy57;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych == 'm')	goto yy57;
				if(yych <= 'r')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '9'){
			if(yych <= ' '){
				if(yych == 0x09)	goto yy57;
				if(yych <= 0x1F)	goto yy1214;
				goto yy57;
			} else {
				if(yych <= '0'){
					if(yych <= '/')	goto yy1214;
					goto yy994;
				} else {
					if(yych <= '2')	goto yy995;
					if(yych <= '3')	goto yy996;
					goto yy970;
				}
			}
		} else {
			if(yych <= 'G'){
				if(yych <= 'D'){
					if(yych <= 'C')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'F')	goto yy57;
					goto yy1214;
				}
			} else {
				if(yych <= 'L'){
					if(yych <= 'H')	goto yy57;
					goto yy1214;
				} else {
					if(yych <= 'M')	goto yy57;
					if(yych <= 'R')	goto yy1214;
					goto yy57;
				}
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Y'){
				if(yych == 'W')	goto yy57;
				if(yych <= 'X')	goto yy1214;
				goto yy57;
			} else {
				if(yych <= 'd'){
					if(yych <= 'c')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'f')	goto yy57;
					goto yy1214;
				}
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'l'){
					if(yych <= 'h')	goto yy57;
					goto yy1214;
				} else {
					if(yych <= 'm')	goto yy57;
					if(yych <= 'r')	goto yy1214;
					goto yy57;
				}
			} else {
				if(yych <= 'w'){
					if(yych <= 'v')	goto yy1214;
					goto yy57;
				} else {
					if(yych == 'y')	goto yy57;
					goto yy1214;
				}
			}
		}
	}
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1223;
		goto yy678;
	} else {
		if(yych <= '9')	goto yy1222;
		if(yych <= ':')	goto yy1223;
		goto yy678;
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy1223;
	if(yych != ':')	goto yy678;
	goto yy1223;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1224;
	if(yych <= '6')	goto yy1225;
	if(yych <= '9')	goto yy683;
	goto yy53;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych <= '/')	goto yy678;
	if(yych <= '9')	goto yy683;
	goto yy678;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych == '0')	goto yy683;
	goto yy678;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		goto yy1230;
	} else {
		if(yych <= '/')	goto yy678;
		if(yych <= '9')	goto yy1229;
		if(yych <= ':')	goto yy1223;
		goto yy678;
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		if(yych <= '.')	goto yy1230;
		goto yy678;
	} else {
		if(yych <= '2')	goto yy1229;
		if(yych <= '9')	goto yy1222;
		if(yych <= ':')	goto yy1223;
		goto yy678;
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		goto yy1230;
	} else {
		if(yych <= '/')	goto yy678;
		if(yych <= '9')	goto yy1222;
		if(yych <= ':')	goto yy1223;
		goto yy678;
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ',')	goto yy678;
		if(yych <= '-')	goto yy772;
		goto yy1230;
	} else {
		if(yych == ':')	goto yy1223;
		goto yy678;
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1231;
	if(yych <= '6')	goto yy1232;
	if(yych <= '9')	goto yy776;
	goto yy53;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych <= '/')	goto yy678;
	if(yych <= '9')	goto yy1233;
	goto yy678;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy684;
		goto yy678;
	} else {
		if(yych <= '0')	goto yy1233;
		if(yych <= '9')	goto yy777;
		goto yy678;
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy684;
	if(yych <= '/')	goto yy678;
	if(yych <= '9')	goto yy779;
	goto yy678;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == 0x09)	goto yy647;
			if(yych <= ',')	goto yy649;
			goto yy660;
		} else {
			if(yych <= '.')	goto yy661;
			if(yych <= '/')	goto yy659;
			if(yych <= '5')	goto yy1204;
			goto yy900;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy670;
			if(yych == 'n')	goto yy657;
			goto yy649;
		} else {
			if(yych <= 'r')	goto yy658;
			if(yych <= 's')	goto yy651;
			if(yych <= 't')	goto yy655;
			goto yy649;
		}
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == 0x09)	goto yy1198;
			if(yych <= ',')	goto yy1200;
			goto yy660;
		} else {
			if(yych <= '.')	goto yy1202;
			if(yych <= '/')	goto yy659;
			if(yych <= '5')	goto yy1204;
			goto yy900;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy1203;
			if(yych == 'n')	goto yy657;
			goto yy1200;
		} else {
			if(yych <= 'r')	goto yy658;
			if(yych <= 's')	goto yy651;
			if(yych <= 't')	goto yy655;
			goto yy1200;
		}
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1237;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy1238;
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	if(yych <= '/')	goto yy1239;
	if(yych <= '9')	goto yy1237;
	goto yy1239;
yy1239:
	YYDEBUG(1239, *YYCURSOR);

{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy1280;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'n')	goto yy1280;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy1274;
			if(yych <= 'T')	goto yy138;
			goto yy1273;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy138;
			goto yy1274;
		} else {
			if(yych == 'u')	goto yy1273;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'D')	goto yy1262;
			if(yych <= 'L')	goto yy138;
			goto yy1263;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'c')	goto yy138;
			goto yy1262;
		} else {
			if(yych == 'm')	goto yy1263;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy1258;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'e')	goto yy1258;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy1254;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'e')	goto yy1254;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '.')	goto yy1203;
		goto yy53;
	} else {
		if(yych <= '9')	goto yy1248;
		if(yych <= ':')	goto yy1203;
		goto yy53;
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '.')	goto yy1203;
		goto yy53;
	} else {
		if(yych <= '3')	goto yy1248;
		if(yych == ':')	goto yy1203;
		goto yy53;
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy1203;
	if(yych == ':')	goto yy1203;
	goto yy53;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '.')	goto yy1203;
		goto yy53;
	} else {
		if(yych <= '5')	goto yy1249;
		if(yych == ':')	goto yy1203;
		goto yy53;
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1250;
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy1206;
	if(yych <= '5')	goto yy1251;
	if(yych <= '6')	goto yy1252;
	goto yy1206;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1253;
	goto yy53;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy53;
	goto yy1253;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1214;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy139;
			goto yy1255;
		}
	} else {
		if(yych <= 'k'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'l')	goto yy1255;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'F'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'E')	goto yy140;
			goto yy1256;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'f')	goto yy1256;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy141;
			goto yy1257;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 't')	goto yy1257;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy167;
		if(yych == 'h')	goto yy167;
		goto yy3;
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy283;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'R')	goto yy139;
			goto yy1259;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy283;
			goto yy139;
		} else {
			if(yych <= 's')	goto yy1259;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy140;
			goto yy1260;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'd')	goto yy1260;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy1261;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy1261;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'Y')	goto yy289;
		if(yych == 'y')	goto yy289;
		goto yy3;
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy1270;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy1270;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy139;
			goto yy1264;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'o')	goto yy1264;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy140;
			goto yy1265;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'r')	goto yy1265;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy141;
			goto yy1266;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'r')	goto yy1266;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'O')	goto yy1267;
		if(yych != 'o')	goto yy3;
		goto yy1267;
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1268;
	if(yych != 'w')	goto yy53;
	goto yy1268;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	++YYCURSOR;
	goto yy1269;
yy1269:
	YYDEBUG(1269, *YYCURSOR);

{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy140;
			goto yy1271;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'y')	goto yy1271;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy136;
		goto yy1272;
	} else {
		if(yych <= 'Z')	goto yy141;
		if(yych <= '`')	goto yy1272;
		if(yych <= 'z')	goto yy141;
		goto yy1272;
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);

{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy283;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'Q')	goto yy139;
			goto yy1276;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy283;
			goto yy139;
		} else {
			if(yych <= 'r')	goto yy1276;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Q')	goto yy139;
			if(yych >= 'S')	goto yy257;
			goto yy1275;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'r')	goto yy1275;
			if(yych <= 's')	goto yy257;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'd')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy140;
			goto yy1277;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 's')	goto yy1277;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy141;
			goto yy1278;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'd')	goto yy1278;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy1279;
		if(yych != 'a')	goto yy3;
		goto yy1279;
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy289;
	if(yych == 'y')	goto yy289;
	goto yy53;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy1281;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy1281;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'h')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy1280;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1311;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= 'H'){
				if(yych <= '@')	goto yy3;
				goto yy138;
			} else {
				if(yych <= 'I')	goto yy1274;
				if(yych <= 'T')	goto yy138;
				goto yy1273;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy3;
				goto yy143;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'i')	goto yy1305;
				goto yy143;
			} else {
				if(yych <= 'u')	goto yy1304;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= 'C'){
				if(yych <= '@')	goto yy3;
				goto yy138;
			} else {
				if(yych <= 'D')	goto yy1262;
				if(yych <= 'L')	goto yy138;
				goto yy1263;
			}
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy3;
				goto yy143;
			}
		} else {
			if(yych <= 'l'){
				if(yych <= 'd')	goto yy1295;
				goto yy143;
			} else {
				if(yych <= 'm')	goto yy1296;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy1258;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1291;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy138;
			goto yy1254;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1287;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy139;
			goto yy1255;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'l')	goto yy1288;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'F'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'E')	goto yy140;
			goto yy1256;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'f')	goto yy1289;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy141;
			goto yy1257;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1290;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'G')	goto yy3;
			goto yy167;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy254;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'R')	goto yy139;
			goto yy1259;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 's')	goto yy1292;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy140;
			goto yy1260;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy1293;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy1261;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1294;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'X')	goto yy3;
			goto yy289;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy302;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy1270;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1302;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy139;
			goto yy1264;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy1297;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy140;
			goto yy1265;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy1298;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy141;
			goto yy1266;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy1299;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'N')	goto yy3;
			goto yy1267;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy1300;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1268;
	if(yych != 'w')	goto yy152;
	goto yy1301;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy144;
		goto yy1269;
	} else {
		if(yych <= '_')	goto yy144;
		if(yych <= '`')	goto yy1269;
		if(yych <= 'z')	goto yy151;
		goto yy1269;
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy140;
			goto yy1271;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy1303;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy1272;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy1272;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '^')	goto yy1272;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy1272;
			if(yych <= 'z')	goto yy150;
			goto yy1272;
		}
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'Q')	goto yy139;
			goto yy1276;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 'r')	goto yy1307;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy139;
			if(yych <= 'R')	goto yy1275;
			goto yy257;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych <= 'r'){
				if(yych <= 'q')	goto yy148;
				goto yy1306;
			} else {
				if(yych <= 's')	goto yy260;
				if(yych <= 'z')	goto yy148;
				goto yy3;
			}
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy140;
			goto yy1277;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 's')	goto yy1308;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy141;
			goto yy1278;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy1309;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy1279;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy1310;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy289;
	if(yych == 'y')	goto yy302;
	goto yy152;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy1281;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1312;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= '@'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych == 'R')	goto yy1325;
			if(yych <= 'X')	goto yy138;
			goto yy1326;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'q')	goto yy138;
			goto yy1325;
		} else {
			if(yych == 'y')	goto yy1326;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy138;
			goto yy1319;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'd')	goto yy1319;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy1316;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'n')	goto yy1316;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy283;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy283;
			if(yych <= 'C')	goto yy139;
			goto yy1317;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy283;
			goto yy139;
		} else {
			if(yych <= 'd')	goto yy1317;
			if(yych <= 'z')	goto yy139;
			goto yy283;
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy136;
		if(yych <= '@')	goto yy3;
		goto yy1318;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy1318;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy141;
			goto yy510;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'y')	goto yy510;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy139;
			goto yy1320;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'n')	goto yy1320;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy140;
			goto yy1321;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'i')	goto yy1321;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy141;
			goto yy1322;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'g')	goto yy1322;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy1323;
		if(yych != 'h')	goto yy3;
		goto yy1323;
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1324;
	if(yych != 't')	goto yy53;
	goto yy1324;
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1272;
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych == 'C')	goto yy1327;
				goto yy139;
			}
		} else {
			if(yych <= 'b'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'c')	goto yy1327;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy310;
			goto yy312;
		} else {
			if(yych == ')')	goto yy136;
			if(yych <= ',')	goto yy310;
			goto yy313;
		}
	} else {
		if(yych <= '@'){
			if(yych == '/')	goto yy310;
			if(yych <= '9')	goto yy312;
			goto yy310;
		} else {
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy310;
			if(yych <= 'z')	goto yy139;
			goto yy310;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy568;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'h')	goto yy568;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '/'){
			if(yych == ')')	goto yy136;
			if(yych <= '.')	goto yy3;
			goto yy144;
		} else {
			if(yych <= 'Q'){
				if(yych <= '@')	goto yy3;
				goto yy138;
			} else {
				if(yych <= 'R')	goto yy1325;
				if(yych <= 'X')	goto yy138;
				goto yy1326;
			}
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy3;
				goto yy143;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= 'r')	goto yy1340;
				goto yy143;
			} else {
				if(yych <= 'y')	goto yy1341;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy138;
			goto yy1319;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy1334;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy1316;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1331;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy283;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy283;
			if(yych <= 'C')	goto yy139;
			goto yy1317;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy283;
		} else {
			if(yych == 'd')	goto yy1332;
			if(yych <= 'z')	goto yy148;
			goto yy283;
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			goto yy1318;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '^')	goto yy3;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1333;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'X')	goto yy141;
			goto yy510;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy539;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy139;
			goto yy1320;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1335;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy140;
			goto yy1321;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy1336;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy141;
			goto yy1322;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy1337;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'G')	goto yy3;
			goto yy1323;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy1338;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1324;
	if(yych != 't')	goto yy152;
	goto yy1339;
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy144;
		goto yy1272;
	} else {
		if(yych <= '_')	goto yy144;
		if(yych <= '`')	goto yy1272;
		if(yych <= 'z')	goto yy151;
		goto yy1272;
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'B'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'C')	goto yy1327;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'b'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'c')	goto yy1342;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ' '){
			if(yych == 0x09)	goto yy312;
			if(yych <= 0x1F)	goto yy310;
			goto yy312;
		} else {
			if(yych <= ')'){
				if(yych <= '(')	goto yy310;
				goto yy136;
			} else {
				if(yych <= ',')	goto yy310;
				if(yych <= '-')	goto yy313;
				goto yy312;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '/')	goto yy144;
			if(yych <= '9')	goto yy312;
			if(yych <= '@')	goto yy310;
			goto yy139;
		} else {
			if(yych <= '_'){
				if(yych <= '^')	goto yy310;
				goto yy144;
			} else {
				if(yych <= '`')	goto yy310;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy568;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy579;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'N'){
			if(yych == ')')	goto yy136;
			if(yych <= '@')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'O')	goto yy1351;
			if(yych <= 'U')	goto yy138;
			if(yych <= 'V')	goto yy1352;
			goto yy1349;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'n')	goto yy138;
			goto yy1351;
		} else {
			if(yych <= 'v'){
				if(yych <= 'u')	goto yy138;
				goto yy1352;
			} else {
				if(yych <= 'w')	goto yy1349;
				if(yych <= 'z')	goto yy138;
				goto yy3;
			}
		}
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy138;
			goto yy1348;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'x')	goto yy1348;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy1346;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'n')	goto yy1346;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy1347;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy1347;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'h')	goto yy270;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy257;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy257;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy136;
		goto yy1350;
	} else {
		if(yych <= 'Z')	goto yy139;
		if(yych <= '`')	goto yy1350;
		if(yych <= 'z')	goto yy139;
		goto yy1350;
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);

{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy139;
			goto yy1357;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 'n')	goto yy1357;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= ','){
				if(yych <= ')')	goto yy136;
				goto yy310;
			} else {
				if(yych <= '-')	goto yy313;
				if(yych <= '.')	goto yy312;
				goto yy310;
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@'){
				if(yych <= '9')	goto yy312;
				goto yy310;
			} else {
				if(yych != 'E')	goto yy139;
				goto yy1353;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'e')	goto yy1353;
				if(yych <= 'z')	goto yy139;
				goto yy310;
			}
		}
	}
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'L')	goto yy140;
			goto yy1354;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'm')	goto yy1354;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy141;
			goto yy1355;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'b')	goto yy1355;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy1356;
		if(yych != 'e')	goto yy3;
		goto yy1356;
	}
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy322;
	if(yych == 'r')	goto yy322;
	goto yy53;
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy136;
		goto yy1358;
	} else {
		if(yych <= 'Z')	goto yy140;
		if(yych <= '`')	goto yy1358;
		if(yych <= 'z')	goto yy140;
		goto yy1358;
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);

{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'W'){
		if(yych <= '@'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy136;
			} else {
				if(yych == '/')	goto yy144;
				goto yy3;
			}
		} else {
			if(yych <= 'O'){
				if(yych <= 'N')	goto yy138;
				goto yy1351;
			} else {
				if(yych <= 'U')	goto yy138;
				if(yych <= 'V')	goto yy1352;
				goto yy1349;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy138;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy3;
				goto yy143;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'o')	goto yy1366;
				if(yych <= 'u')	goto yy143;
				goto yy1367;
			} else {
				if(yych <= 'w')	goto yy1365;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy138;
			goto yy1348;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'x')	goto yy1364;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy138;
			goto yy1346;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1362;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy1347;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1363;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy140;
			goto yy270;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy280;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy257;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy260;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy1350;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy1350;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '^')	goto yy1350;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy1350;
			if(yych <= 'z')	goto yy148;
			goto yy1350;
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy139;
			goto yy1357;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1372;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '('){
			if(yych <= 0x09){
				if(yych <= 0x08)	goto yy310;
				goto yy312;
			} else {
				if(yych == ' ')	goto yy312;
				goto yy310;
			}
		} else {
			if(yych <= '-'){
				if(yych <= ')')	goto yy136;
				if(yych <= ',')	goto yy310;
				goto yy313;
			} else {
				if(yych == '/')	goto yy144;
				goto yy312;
			}
		}
	} else {
		if(yych <= '^'){
			if(yych <= 'D'){
				if(yych <= '@')	goto yy310;
				goto yy139;
			} else {
				if(yych <= 'E')	goto yy1353;
				if(yych <= 'Z')	goto yy139;
				goto yy310;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '_')	goto yy144;
				if(yych <= '`')	goto yy310;
				goto yy148;
			} else {
				if(yych <= 'e')	goto yy1368;
				if(yych <= 'z')	goto yy148;
				goto yy310;
			}
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'L')	goto yy140;
			goto yy1354;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy1369;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy141;
			goto yy1355;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy1370;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'D')	goto yy3;
			goto yy1356;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1371;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy322;
	if(yych == 'r')	goto yy492;
	goto yy152;
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy1358;
			goto yy136;
		} else {
			if(yych == '/')	goto yy144;
			goto yy1358;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '^')	goto yy1358;
			goto yy144;
		} else {
			if(yych <= '`')	goto yy1358;
			if(yych <= 'z')	goto yy149;
			goto yy1358;
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy138;
			goto yy1374;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy138;
			if(yych <= '`')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 's')	goto yy1374;
			if(yych <= 'z')	goto yy138;
			goto yy3;
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy1375;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy139;
			if(yych <= '`')	goto yy3;
			goto yy139;
		} else {
			if(yych <= 't')	goto yy1375;
			if(yych <= 'z')	goto yy139;
			goto yy3;
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy140;
			goto yy1376;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy140;
			if(yych <= '`')	goto yy3;
			goto yy140;
		} else {
			if(yych <= 'e')	goto yy1376;
			if(yych <= 'z')	goto yy140;
			goto yy3;
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy136;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy141;
			goto yy1377;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy141;
			if(yych <= '`')	goto yy3;
			goto yy141;
		} else {
			if(yych <= 'r')	goto yy1377;
			if(yych <= 'z')	goto yy141;
			goto yy3;
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych == ')')	goto yy136;
		goto yy3;
	} else {
		if(yych <= 'D')	goto yy1378;
		if(yych != 'd')	goto yy3;
		goto yy1378;
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1379;
	if(yych != 'a')	goto yy53;
	goto yy1379;
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1380;
	if(yych != 'y')	goto yy53;
	goto yy1380;
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	++YYCURSOR;
	goto yy1381;
yy1381:
	YYDEBUG(1381, *YYCURSOR);

{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy138;
			goto yy1374;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy138;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 's')	goto yy1383;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy139;
			goto yy1375;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy139;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1384;
			if(yych <= 'z')	goto yy148;
			goto yy3;
		}
	}
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy140;
			goto yy1376;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy140;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1385;
			if(yych <= 'z')	goto yy149;
			goto yy3;
		}
	}
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy141;
			goto yy1377;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy141;
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy1386;
			if(yych <= 'z')	goto yy150;
			goto yy3;
		}
	}
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy136;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy144;
			if(yych <= 'C')	goto yy3;
			goto yy1378;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy144;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy1387;
			if(yych <= 'z')	goto yy151;
			goto yy3;
		}
	}
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1379;
	if(yych != 'a')	goto yy152;
	goto yy1388;
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1380;
	if(yych != 'y')	goto yy152;
	goto yy1389;
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy144;
		goto yy1381;
	} else {
		if(yych <= '_')	goto yy144;
		if(yych <= '`')	goto yy1381;
		if(yych <= 'z')	goto yy151;
		goto yy1381;
	}
}
}

}

#define YYMAXFILL 29


timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 1) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
