<?php
/**
 * Define the messages structure in the messages file, for an automated rewriting.
 *
 * @addtogroup Maintenance
 */

/** The structure of the messages, divided to blocks */
$wgMessageStructure = array(
	'sidebar' => array(
		'sidebar',
	),
	'toggles' => array(
		'tog-underline',
		'tog-highlightbroken',
		'tog-justify',
		'tog-hideminor',
		'tog-extendwatchlist',
		'tog-usenewrc',
		'tog-numberheadings',
		'tog-showtoolbar',
		'tog-editondblclick',
		'tog-editsection',
		'tog-editsectiononrightclick',
		'tog-showtoc',
		'tog-rememberpassword',
		'tog-editwidth',
		'tog-watchcreations',
		'tog-watchdefault',
		'tog-watchmoves',
		'tog-watchdeletion',
		'tog-minordefault',
		'tog-previewontop',
		'tog-previewonfirst',
		'tog-nocache',
		'tog-enotifwatchlistpages',
		'tog-enotifusertalkpages',
		'tog-enotifminoredits',
		'tog-enotifrevealaddr',
		'tog-shownumberswatching',
		'tog-fancysig',
		'tog-externaleditor',
		'tog-externaldiff',
		'tog-showjumplinks',
		'tog-uselivepreview',
		'tog-forceeditsummary',
		'tog-watchlisthideown',
		'tog-watchlisthidebots',
		'tog-watchlisthideminor',
		'tog-nolangconversion',
		'tog-ccmeonemails',
		'tog-diffonly',
	),
	'underline' => array(
		'underline-always',
		'underline-never',
		'underline-default',
	),
	'skinpreview' => array(
		'skinpreview',
	),
	'dates' => array(
		'sunday',
		'monday',
		'tuesday',
		'wednesday',
		'thursday',
		'friday',
		'saturday',
		'sun',
		'mon',
		'tue',
		'wed',
		'thu',
		'fri',
		'sat',
		'january',
		'february',
		'march',
		'april',
		'may_long',
		'june',
		'july',
		'august',
		'september',
		'october',
		'november',
		'december',
		'january-gen',
		'february-gen',
		'march-gen',
		'april-gen',
		'may-gen',
		'june-gen',
		'july-gen',
		'august-gen',
		'september-gen',
		'october-gen',
		'november-gen',
		'december-gen',
		'jan',
		'feb',
		'mar',
		'apr',
		'may',
		'jun',
		'jul',
		'aug',
		'sep',
		'oct',
		'nov',
		'dec',
	),
	'categories' => array(
		'categories',
		'pagecategories',
		'pagecategorieslink',
		'category_header',
		'subcategories',
		'category-media-header',
		'category-empty',
	),
	'mainpage' => array(
		'linkprefix',
		'mainpagetext',
		'mainpagedocfooter',
	),
	'miscellaneous1' => array(
		'about',
		'article',
		'newwindow',
		'cancel',
		'qbfind',
		'qbbrowse',
		'qbedit',
		'qbpageoptions',
		'qbpageinfo',
		'qbmyoptions',
		'qbspecialpages',
		'moredotdotdot',
		'mypage',
		'mytalk',
		'anontalk',
		'navigation',
		'and',
	),
	'metadata_help' => array(
		'metadata_help',
	),
	'miscellaneous2' => array(
		'errorpagetitle',
		'returnto',
		'tagline',
		'help',
		'search',
		'searchbutton',
		'go',
		'searcharticle',
		'history',
		'history_short',
		'updatedmarker',
		'info_short',
		'printableversion',
		'permalink',
		'print',
		'edit',
		'editthispage',
		'delete',
		'deletethispage',
		'undelete_short',
		'protect',
		'protect_change',
		'protectthispage',
		'unprotect',
		'unprotectthispage',
		'newpage',
		'talkpage',
		'talkpagelinktext',
		'specialpage',
		'personaltools',
		'postcomment',
		'addsection',
		'articlepage',
		'talk',
		'views',
		'toolbox',
		'userpage',
		'projectpage',
		'imagepage',
		'mediawikipage',
		'templatepage',
		'viewhelppage',
		'categorypage',
		'viewtalkpage',
		'otherlanguages',
		'redirectedfrom',
		'redirectpagesub',
		'lastmodifiedat',
		'viewcount',
		'protectedpage',
		'jumpto',
		'jumptonavigation',
		'jumptosearch',
	),
	'links' => array(
		'aboutsite',
		'aboutpage',
		'bugreports',
		'bugreportspage',
		'copyright',
		'copyrightpagename',
		'copyrightpage',
		'currentevents',
		'currentevents-url',
		'disclaimers',
		'disclaimerpage',
		'edithelp',
		'edithelppage',
		'faq',
		'faqpage',
		'help',
		'helppage',
		'mainpage',
		'policy-url',
		'portal',
		'portal-url',
		'privacy',
		'privacypage',
		'sitesupport',
		'sitesupport-url',
	),
	'badaccess' => array(
		'badaccess',
		'badaccess-group0',
		'badaccess-group1',
		'badaccess-group2',
		'badaccess-groups',
	),
	'versionrequired' => array(
		'versionrequired',
		'versionrequiredtext',
	),
	'miscellaneous3' => array(
		'ok',
		'sitetitle',
		'pagetitle',
		'sitesubtitle',
		'retrievedfrom',
		'youhavenewmessages',
		'newmessageslink',
		'newmessagesdifflink',
		'youhavenewmessagesmulti',
		'newtalkseperator',
		'editsection',
		'editsection-brackets',
		'editold',
		'editsectionhint',
		'toc',
		'showtoc',
		'hidetoc',
		'thisisdeleted',
		'viewdeleted',
		'restorelink',
		'feedlinks',
		'feed-invalid',
		'feed-unavailable',
		'site-rss-feed',
		'site-atom-feed',
		'page-rss-feed',
		'page-atom-feed',
		'feed-atom',
		'feed-rss',
		'sitenotice',
		'anonnotice',
		'newsectionheaderdefaultlevel',
		'red-link-title',
	),
	'nstab' => array(
		'nstab-main',
		'nstab-user',
		'nstab-media',
		'nstab-special',
		'nstab-project',
		'nstab-image',
		'nstab-mediawiki',
		'nstab-template',
		'nstab-help',
		'nstab-category',
	),
	'main' => array(
		'nosuchaction',
		'nosuchactiontext',
		'nosuchspecialpage',
		'nospecialpagetext',
	),
	'errors' => array(
		'error',
		'databaseerror',
		'dberrortext',
		'dberrortextcl',
		'noconnect',
		'nodb',
		'cachederror',
		'laggedslavemode',
		'readonly',
		'enterlockreason',
		'readonlytext',
		'missingarticle',
		'readonly_lag',
		'internalerror',
		'internalerror_info',
		'filecopyerror',
		'filerenameerror',
		'filedeleteerror',
		'directorycreateerror',
		'filenotfound',
		'fileexistserror',
		'unexpected',
		'formerror',
		'badarticleerror',
		'cannotdelete',
		'badtitle',
		'badtitletext',
		'perfdisabled',
		'perfcached',
		'perfcachedts',
		'querypage-no-updates',
		'wrong_wfQuery_params',
		'viewsource',
		'viewsourcefor',
		'actionthrottled',
		'actionthrottledtext',
		'protectedpagetext',
		'viewsourcetext',
		'protectedinterface',
		'editinginterface',
		'sqlhidden',
		'cascadeprotected',
		'namespaceprotected',
		'customcssjsprotected',
		'ns-specialprotected',
		'titleprotected',
	),
	'login' => array(
		'logouttitle',
		'logouttext',
		'welcomecreation',
		'loginpagetitle',
		'yourname',
		'yourpassword',
		'yourpasswordagain',
		'remembermypassword',
		'yourdomainname',
		'externaldberror',
		'loginproblem',
		'login',
		'loginprompt',
		'userlogin',
		'logout',
		'userlogout',
		'notloggedin',
		'nologin',
		'nologinlink',
		'createaccount',
		'gotaccount',
		'gotaccountlink',
		'createaccountmail',
		'badretype',
		'userexists',
		'youremail',
		'username',
		'uid',
		'yourrealname',
		'yourlanguage',
		'yourvariant',
		'yournick',
		'badsig',
		'badsiglength',
		'email',
		'prefs-help-realname',
		'loginerror',
		'prefs-help-email',
		'prefs-help-email-required',
		'nocookiesnew',
		'nocookieslogin',
		'noname',
		'loginsuccesstitle',
		'loginsuccess',
		'nosuchuser',
		'nosuchusershort',
		'nouserspecified',
		'wrongpassword',
		'wrongpasswordempty',
		'passwordtooshort',
		'mailmypassword',
		'passwordremindertitle',
		'passwordremindertext',
		'noemail',
		'passwordsent',
		'blocked-mailpassword',
		'eauthentsent',
		'throttled-mailpassword',
		'loginstart',
		'loginend',
		'signupend',
		'mailerror',
		'acct_creation_throttle_hit',
		'emailauthenticated',
		'emailnotauthenticated',
		'noemailprefs',
		'emailconfirmlink',
		'invalidemailaddress',
		'accountcreated',
		'accountcreatedtext',
		'createaccount-title',
		'createaccount-text',
		'loginlanguagelabel',
		'loginlanguagelinks',
	),
	'resetpass' => array(
		'resetpass',
		'resetpass_announce',
		'resetpass_text',
		'resetpass_header',
		'resetpass_submit',
		'resetpass_success',
		'resetpass_bad_temporary',
		'resetpass_forbidden',
		'resetpass_missing',
	),
	'toolbar' => array(
		'bold_sample',
		'bold_tip',
		'italic_sample',
		'italic_tip',
		'link_sample',
		'link_tip',
		'extlink_sample',
		'extlink_tip',
		'headline_sample',
		'headline_tip',
		'math_sample',
		'math_tip',
		'nowiki_sample',
		'nowiki_tip',
		'image_sample',
		'image_tip',
		'media_sample',
		'media_tip',
		'sig_tip',
		'hr_tip',
	),
	'edit' => array(
		'summary',
		'subject',
		'minoredit',
		'watchthis',
		'savearticle',
		'preview',
		'showpreview',
		'showlivepreview',
		'showdiff',
		'anoneditwarning',
		'missingsummary',
		'missingcommenttext',
		'missingcommentheader',
		'summary-preview',
		'subject-preview',
		'blockedtitle',
		'blockedtext',
		'autoblockedtext',
		'blockednoreason',
		'blockedoriginalsource',
		'blockededitsource',
		'whitelistedittitle',
		'whitelistedittext',
		'whitelistreadtitle',
		'whitelistreadtext',
		'whitelistacctitle',
		'whitelistacctext',
		'confirmedittitle',
		'confirmedittext',
		'nosuchsectiontitle',
		'nosuchsectiontext',
		'loginreqtitle',
		'loginreqlink',
		'loginreqpagetext',
		'accmailtitle',
		'accmailtext',
		'newarticle',
		'newarticletext',
		'newarticletextanon',
		'talkpagetext',
		'anontalkpagetext',
		'noarticletext',
		'noarticletextanon',
		'userpage-userdoesnotexist',
		'clearyourcache',
		'usercssjsyoucanpreview',
		'usercsspreview',
		'userjspreview',
		'userinvalidcssjstitle',
		'updated',
		'note',
		'previewnote',
		'previewconflict',
		'session_fail_preview',
		'session_fail_preview_html',
		'token_suffix_mismatch',
		'editing',
		'editinguser',
		'editingsection',
		'editingcomment',
		'editconflict',
		'explainconflict',
		'yourtext',
		'storedversion',
		'nonunicodebrowser',
		'editingold',
		'yourdiff',
		'copyrightwarning',
		'copyrightwarning2',
		'longpagewarning',
		'longpageerror',
		'readonlywarning',
		'protectedpagewarning',
		'semiprotectedpagewarning',
		'cascadeprotectedwarning',
		'titleprotectedwarning',
		'templatesused',
		'templatesusedpreview',
		'templatesusedsection',
		'template-protected',
		'template-semiprotected',
		'edittools',
		'nocreatetitle',
		'nocreatetext',
		'nocreate-loggedin',
		'permissionserrors',
		'permissionserrorstext',
		'recreate-deleted-warn',
	),
	'undo' => array(
		'undo-success',
		'undo-failure',
		'undo-summary',
	),
	'cantcreateaccount' => array(
		'cantcreateaccounttitle',
		'cantcreateaccount-text',
	),
	'history' => array(
		'viewpagelogs',
		'nohistory',
		'revnotfound',
		'revnotfoundtext',
		'loadhist',
		'currentrev',
		'revisionasof',
		'revision-info',
		'revision-info-current',
		'revision-nav',
		'previousrevision',
		'nextrevision',
		'currentrevisionlink',
		'cur',
		'next',
		'last',
		'orig',
		'page_first',
		'page_last',
		'histlegend',
		'history_copyright',
		'deletedrev',
		'histfirst',
		'histlast',
		'historysize',
		'historyempty',
	),
	'history-feed' => array(
		'history-feed-title',
		'history-feed-description',
		'history-feed-item-nocomment',
		'history-feed-empty',
	),
	'revdelete' => array(
		'rev-deleted-comment',
		'rev-deleted-user',
		'rev-deleted-event',
		'rev-deleted-text-permission',
		'rev-deleted-text-view',
		'rev-delundel',
		'revisiondelete',
		'revdelete-nooldid-title',
		'revdelete-nooldid-text',
		'revdelete-selected',
		'logdelete-selected',
		'revdelete-text',
		'revdelete-legend',
		'revdelete-hide-text',
		'revdelete-hide-name',
		'revdelete-hide-comment',
		'revdelete-hide-user',
		'revdelete-hide-restricted',
		'revdelete-suppress',
		'revdelete-hide-image',
		'revdelete-unsuppress',
		'revdelete-log',
		'revdelete-submit',
		'revdelete-logentry',
		'logdelete-logentry',
		'revdelete-logaction',
		'logdelete-logaction',
		'revdelete-success',
		'logdelete-success',
	),
	'oversightlog' => array(
		'oversightlog',
		'overlogpagetext',
	),
	'mergehistory' => array(
		'mergehistory',
		'mergehistory-header',
		'mergehistory-box',
		'mergehistory-from',
		'mergehistory-into',
		'mergehistory-list',
		'mergehistory-merge',
		'mergehistory-go',
		'mergehistory-submit',
		'mergehistory-empty',
		'mergehistory-success',
		'mergehistory-fail',
		'mergehistory-no-source',
		'mergehistory-no-destination',
		'mergehistory-invalid-source',
		'mergehistory-invalid-destination',
	),
	'mergelog' => array(
		'mergelog',
		'pagemerge-logentry',
		'revertmerge',
		'mergelogpagetext',
	),
	'diffs' => array(
		'history-title',
		'difference',
		'lineno',
		'compareselectedversions',
		'editundo',
		'diff-multi',
	),
	'search' => array(
		'searchresults',
		'searchresulttext',
		'searchsubtitle',
		'searchsubtitleinvalid',
		'noexactmatch',
		'noexactmatch-nocreate',
		'toomanymatches',
		'titlematches',
		'notitlematches',
		'textmatches',
		'notextmatches',
		'prevn',
		'nextn',
		'viewprevnext',
		'showingresults',
		'showingresultsnum',
		'nonefound',
		'powersearch',
		'powersearchtext',
		'searchdisabled',
		'googlesearch',
	),
	'preferences' => array(
		'preferences',
		'preferences-summary',
		'mypreferences',
		'prefs-edits',
		'prefsnologin',
		'prefsnologintext',
		'prefsreset',
		'qbsettings',
		'qbsettings-none',
		'qbsettings-fixedleft',
		'qbsettings-fixedright',
		'qbsettings-floatingleft',
		'qbsettings-floatingright',
		'changepassword',
		'skin',
		'math',
		'dateformat',
		'datedefault',
		'datetime',
		'math_failure',
		'math_unknown_error',
		'math_unknown_function',
		'math_lexing_error',
		'math_syntax_error',
		'math_image_error',
		'math_bad_tmpdir',
		'math_bad_output',
		'math_notexvc',
		'prefs-personal',
		'prefs-rc',
		'prefs-watchlist',
		'prefs-watchlist-days',
		'prefs-watchlist-edits',
		'prefs-misc',
		'saveprefs',
		'resetprefs',
		'oldpassword',
		'newpassword',
		'retypenew',
		'textboxsize',
		'rows',
		'columns',
		'searchresultshead',
		'resultsperpage',
		'contextlines',
		'contextchars',
		'stub-threshold',
		'recentchangesdays',
		'recentchangescount',
		'savedprefs',
		'timezonelegend',
		'timezonetext',
		'localtime',
		'timezoneoffset',
		'servertime',
		'guesstimezone',
		'allowemail',
		'defaultns',
		'default',
		'files',
	),
	'userrights' => array(
		'userrights-lookup-user',
		'userrights-user-editname',
		'editusergroup',
		'userrights-editusergroup',
		'saveusergroups',
		'userrights-groupsmember',
		'userrights-groupsremovable',
		'userrights-groupsavailable',
		'userrights-groupshelp',
		'userrights-reason',
		'userrights-available-none',
		'userrights-available-add',
		'userrights-available-remove',
		'userrights-available-add-self',
		'userrights-available-remove-self',
		'userrights-no-interwiki',
		'userrights-nodatabase',
		'userrights-nologin',
		'userrights-notallowed',
	),
	'group' => array(
		'group',
		'group-autoconfirmed',
		'group-bot',
		'group-sysop',
		'group-bureaucrat',
		'group-all',
	),
	'group-member' => array(
		'group-autoconfirmed-member',
		'group-bot-member',
		'group-sysop-member',
		'group-bureaucrat-member',
	),
	'grouppage' => array(
		'grouppage-autoconfirmed',
		'grouppage-bot',
		'grouppage-sysop',
		'grouppage-bureaucrat',
	),
	'rightslog' => array(
		'rightslog',
		'rightslogtext',
		'rightslogentry',
		'rightsnone',
	),
	'recentchanges' => array(
		'nchanges',
		'recentchanges',
		'recentchanges-url',
		'recentchangestext',
		'recentchanges-feed-description',
		'rcnote',
		'rcnotefrom',
		'rclistfrom',
		'rcshowhideminor',
		'rcshowhidebots',
		'rcshowhideliu',
		'rcshowhideanons',
		'rcshowhidepatr',
		'rcshowhidemine',
		'rclinks',
		'diff',
		'hist',
		'hide',
		'show',
		'minoreditletter',
		'newpageletter',
		'boteditletter',
		'sectionlink',
		'number_of_watching_users_RCview',
		'number_of_watching_users_pageview',
		'rc_categories',
		'rc_categories_any',
		'rc-change-size',
		'newsectionsummary',
	),
	'recentchangeslinked' => array(
		'recentchangeslinked',
		'recentchangeslinked-title',
		'recentchangeslinked-noresult',
		'recentchangeslinked-summary',
	),
	'upload' => array(
		'upload',
		'uploadbtn',
		'reupload',
		'reuploaddesc',
		'uploadnologin',
		'uploadnologintext',
		'upload_directory_read_only',
		'uploaderror',
		'upload-summary',
		'uploadtext',
		'upload-permitted',
		'upload-preferred',
		'upload-prohibited',
		'uploadlog',
		'uploadlogpage',
		'uploadlogpagetext',
		'filename',
		'filedesc',
		'fileuploadsummary',
		'filestatus',
		'filesource',
		'uploadedfiles',
		'ignorewarning',
		'ignorewarnings',
		'minlength1',
		'illegalfilename',
		'badfilename',
		'filetype-badmime',
		'filetype-unwanted-type',
		'filetype-banned-type',
		'filetype-missing',
		'large-file',
		'largefileserver',
		'emptyfile',
		'fileexists',
		'filepageexists',
		'fileexists-extension',
		'fileexists-thumb',
		'fileexists-thumbnail-yes',
		'file-thumbnail-no',
		'fileexists-forbidden',
		'fileexists-shared-forbidden',
		'successfulupload',
		'uploadwarning',
		'savefile',
		'uploadedimage',
		'overwroteimage',
		'uploaddisabled',
		'uploaddisabledtext',
		'uploadscripted',
		'uploadcorrupt',
		'uploadvirus',
		'sourcefilename',
		'destfilename',
		'watchthisupload',
		'filewasdeleted',
		'upload-wasdeleted',
		'filename-bad-prefix',
		'filename-prefix-blacklist',
	),
	'upload-errors' => array(
		'upload-proto-error',
		'upload-proto-error-text',
		'upload-file-error',
		'upload-file-error-text',
		'upload-misc-error',
		'upload-misc-error-text',
	),
	'upload-curl-errors' => array(
		'upload-curl-error6',
		'upload-curl-error6-text',
		'upload-curl-error28',
		'upload-curl-error28-text',
	),
	'licenses' => array(
		'license',
		'nolicense',
		'licenses',
		'license-nopreview',
		'upload_source_url',
		'upload_source_file',
	),
	'imagelist' => array(
		'imagelist',
		'imagelist-summary',
		'imagelisttext',
		'getimagelist',
		'ilsubmit',
		'showlast',
		'byname',
		'bydate',
		'bysize',
		'imgdelete',
		'imgdesc',
		'imgfile',
		'filehist',
		'filehist-help',
		'filehist-deleteall',
		'filehist-deleteone',
		'filehist-revert',
		'filehist-current',
		'filehist-datetime',
		'filehist-user',
		'filehist-dimensions',
		'filehist-filesize',
		'filehist-comment',
		'imagelinks',
		'linkstoimage',
		'nolinkstoimage',
		'sharedupload',
		'shareduploadwiki',
		'shareduploadwiki-desc',
		'shareduploadwiki-linktext',
		'shareddescriptionfollows',
		'noimage',
		'noimage-linktext',
		'uploadnewversion-linktext',
		'imagelist_date',
		'imagelist_name',
		'imagelist_user',
		'imagelist_size',
		'imagelist_description',
		'imagelist_search_for',
	),
	'filerevert' => array(
		'filerevert',
		'filerevert-backlink',
		'filerevert-legend',
		'filerevert-intro',
		'filerevert-comment',
		'filerevert-defaultcomment',
		'filerevert-submit',
		'filerevert-success',
		'filerevert-badversion',
	),
	'filedelete' => array(
		'filedelete',
		'filedelete-backlink',
		'filedelete-legend',
		'filedelete-intro',
		'filedelete-intro-old',
		'filedelete-comment',
		'filedelete-submit',
		'filedelete-success',
		'filedelete-success-old',
		'filedelete-nofile',
		'filedelete-nofile-old',
		'filedelete-iscurrent',
		'filedelete-otherreason',
		'filedelete-reason-otherlist',
		'filedelete-reason-dropdown',
	),
	'mimesearch' => array(
		'mimesearch',
		'mimesearch-summary',
		'mimetype',
		'download',
	),
	'unwatchedpages' => array(
		'unwatchedpages',
		'unwatchedpages-summary',
	),
	'listredirects' => array(
		'listredirects',
		'listredirects-summary',
	),
	'unusedtemplates' => array(
		'unusedtemplates',
		'unusedtemplates-summary',
		'unusedtemplatestext',
		'unusedtemplateswlh',
	),
	'randompage' => array(
		'randompage',
		'randompage-nopages',
		'randompage-url',
	),
	'randomredirect' => array(
		'randomredirect',
		'randomredirect-nopages',
	),
	'statistics' => array(
		'statistics',
		'sitestats',
		'userstats',
		'sitestatstext',
		'userstatstext',
		'statistics-mostpopular',
		'statistics-footer',
	),
	'disambiguations' => array(
		'disambiguations',
		'disambiguations-summary',
		'disambiguationspage',
		'disambiguations-text',
	),
	'doubleredirects' => array(
		'doubleredirects',
		'doubleredirects-summary',
		'doubleredirectstext',
	),
	'brokenredirects' => array(
		'brokenredirects',
		'brokenredirects-summary',
		'brokenredirectstext',
		'brokenredirects-edit',
		'brokenredirects-delete',
	),
	'withoutinterwiki' => array(
		'withoutinterwiki',
		'withoutinterwiki-header',
		'withoutinterwiki-summary',
		'withoutinterwiki-submit',
	),
	'fewestrevisions' => array(
		'fewestrevisions',
		'fewestrevisions-summary',
	),
	'specialpages' => array(
		'nbytes',
		'ncategories',
		'nlinks',
		'nmembers',
		'nrevisions',
		'nviews',
		'nchanges',
		'specialpage-empty',
		'lonelypages',
		'lonelypages-summary',
		'lonelypagestext',
		'uncategorizedpages',
		'uncategorizedpages-summary',
		'uncategorizedcategories',
		'uncategorizedcategories-summary',
		'uncategorizedimages',
		'uncategorizedimages-summary',
		'uncategorizedtemplates',
		'uncategorizedtemplates-summary',
		'unusedcategories',
		'unusedimages',
		'popularpages',
		'popularpages-summary',
		'wantedcategories',
		'wantedcategories-summary',
		'wantedpages',
		'wantedpages-summary',
		'mostlinked',
		'mostlinked-summary',
		'mostlinkedcategories',
		'mostlinkedcategories-summary',
		'mostlinkedtemplates',
		'mostlinkedtemplates-summary',
		'mostcategories',
		'mostcategories-summary',
		'mostimages',
		'mostimages-summary',
		'mostrevisions',
		'mostrevisions-summary',
		'allpages',
		'allpages-summary',
		'prefixindex',
		'prefixindex-summary',
		'shortpages',
		'shortpages-summary',
		'longpages',
		'longpages-summary',
		'deadendpages',
		'deadendpages-summary',
		'deadendpagestext',
		'protectedpages',
		'protectedpages-summary',
		'protectedpagestext',
		'protectedpagesempty',
		'protectedtitles',
		'protectedtitles-summary',
		'protectedtitlestext',
		'protectedtitlesempty',
		'listusers',
		'listusers-summary',
		'specialpages',
		'specialpages-summary',
		'spheading',
		'restrictedpheading',
		'newpages',
		'newpages-summary',
		'newpages-username',
		'ancientpages',
		'ancientpages-summary',
		'intl',
		'move',
		'movethispage',
		'unusedimagestext',
		'unusedcategoriestext',
		'notargettitle',
		'notargettext',
		'pager-newer-n',
		'pager-older-n',
	),
	'booksources' => array(
		'booksources',
		'booksources-summary',
		'booksources-search-legend',
		'booksources-isbn',
		'booksources-go',
		'booksources-text',
	),
	'specialpages2' => array(
		'categoriespagetext',
		'data',
		'userrights',
		'userrights-summary',
		'groups',
		'isbn',
		'rfcurl',
		'pubmedurl',
		'alphaindexline',
		'version',
	),
	'logpages' => array(
		'specialloguserlabel',
		'speciallogtitlelabel',
		'log',
		'all-logs-page',
		'log-search-legend',
		'log-search-submit',
		'alllogstext',
		'logempty',
		'log-title-wildcard',
	),
	'allpages' => array(
		'nextpage',
		'prevpage',
		'allpagesfrom',
		'allarticles',
		'allinnamespace',
		'allnotinnamespace',
		'allpagesprev',
		'allpagesnext',
		'allpagessubmit',
		'allpagesprefix',
		'allpagesbadtitle',
		'allpages-bad-ns',
	),
	'listusers' => array(
		'listusersfrom',
		'listusers-submit',
		'listusers-noresult',
	),
	'emailuser' => array(
		'mailnologin',
		'mailnologintext',
		'emailuser',
		'emailpage',
		'emailpagetext',
		'usermailererror',
		'defemailsubject',
		'noemailtitle',
		'noemailtext',
		'emailfrom',
		'emailto',
		'emailsubject',
		'emailmessage',
		'emailsend',
		'emailccme',
		'emailccsubject',
		'emailsent',
		'emailsenttext',
	),
	'watchlist' => array(
		'watchlist',
		'mywatchlist',
		'watchlistfor',
		'nowatchlist',
		'watchlistanontext',
		'watchnologin',
		'watchnologintext',
		'addedwatch',
		'addedwatchtext',
		'removedwatch',
		'removedwatchtext',
		'watch',
		'watchthispage',
		'unwatch',
		'unwatchthispage',
		'notanarticle',
		'watchnochange',
		'watchlist-details',
		'wlheader-enotif',
		'wlheader-showupdated',
		'watchmethod-recent',
		'watchmethod-list',
		'watchlistcontains',
		'iteminvalidname',
		'wlnote',
		'wlshowlast',
		'watchlist-show-bots',
		'watchlist-hide-bots',
		'watchlist-show-own',
		'watchlist-hide-own',
		'watchlist-show-minor',
		'watchlist-hide-minor',
	),
	'watching' => array(
		'watching',
		'unwatching',
	),
	'enotif' => array(
		'enotif_mailer',
		'enotif_reset',
		'enotif_newpagetext',
		'enotif_impersonal_salutation',
		'changed',
		'created',
		'enotif_subject',
		'enotif_lastvisited',
		'enotif_lastdiff',
		'enotif_anon_editor',
		'enotif_body',
	),
	'deleteprotectrev' => array(
		'deletepage',
		'confirm',
		'excontent',
		'excontentauthor',
		'exbeforeblank',
		'exblank',
		'delete-confirm',
		'delete-backlink',
		'delete-legend',
		'historywarning',
		'confirmdeletetext',
		'actioncomplete',
		'deletedtext',
		'deletedarticle',
		'dellogpage',
		'dellogpagetext',
		'deletionlog',
		'reverted',
		'deletecomment',
		'deleteotherreason',
		'deletereasonotherlist',
		'deletereason-dropdown',
		'delete-toobig',
		'delete-warning-toobig',
		'rollback',
		'rollback_short',
		'rollbacklink',
		'rollbackfailed',
		'cantrollback',
		'alreadyrolled',
		'editcomment',
		'revertpage',
		'rollback-success',
		'sessionfailure',
		'protectlogpage',
		'protectlogtext',
		'protectedarticle',
		'modifiedarticleprotection',
		'unprotectedarticle',
		'protectsub',
		'confirmprotect',
		'protectcomment',
		'protectexpiry',
		'protect_expiry_invalid',
		'protect_expiry_old',
		'unprotectsub',
		'protect-unchain',
		'protect-text',
		'protect-locked-blocked',
		'protect-locked-dblock',
		'protect-locked-access',
		'protect-cascadeon',
		'protect-default',
		'protect-fallback',
		'protect-level-autoconfirmed',
		'protect-level-sysop',
		'protect-summary-cascade',
		'protect-expiring',
		'protect-cascade',
		'protect-cantedit',
		'restriction-type',
		'restriction-level',
		'minimum-size',
		'maximum-size',
		'pagesize',
	),
	'restrictions' => array(
		'restriction-edit',
		'restriction-move',
		'restriction-create',
	),
	'restriction-levels' => array(
		'restriction-level-sysop',
		'restriction-level-autoconfirmed',
		'restriction-level-all',
	),
	'undelete' => array(
		'undelete',
		'undeletepage',
		'viewdeletedpage',
		'undeletepagetext',
		'undeleteextrahelp',
		'undeleterevisions',
		'undeletehistory',
		'undeleterevdel',
		'undeletehistorynoadmin',
		'undelete-revision',
		'undeleterevision-missing',
		'undelete-nodiff',
		'undeletebtn',
		'undeletelink',
		'undeletereset',
		'undeletecomment',
		'undeletedarticle',
		'undeletedrevisions',
		'undeletedrevisions-files',
		'undeletedfiles',
		'cannotundelete',
		'undeletedpage',
		'undelete-header',
		'undelete-search-box',
		'undelete-search-prefix',
		'undelete-search-submit',
		'undelete-no-results',
		'undelete-filename-mismatch',
		'undelete-bad-store-key',
		'undelete-cleanup-error',
		'undelete-missing-filearchive',
		'undelete-error-short',
		'undelete-error-long',
	),
	'nsform' => array(
		'namespace',
		'invert',
		'blanknamespace',
	),
	'contributions' => array(
		'contributions',
		'mycontris',
		'contribsub2',
		'nocontribs',
		'ucnote',
		'uclinks',
		'uctop',
		'month',
		'year',
	),
	'sp-contributions' => array(
		'sp-contributions-newbies',
		'sp-contributions-newbies-sub',
		'sp-contributions-blocklog',
		'sp-contributions-search',
		'sp-contributions-username',
		'sp-contributions-submit',
		'sp-contributions-explain',
		'sp-contributions-footer',
		'sp-contributions-footer-anon',
	),
	'newimages-showfrom' => array(
		'sp-newimages-showfrom',
	),
	'whatlinkshere' => array(
		'whatlinkshere',
		'whatlinkshere-title',
		'whatlinkshere-summary',
		'whatlinkshere-page',
		'whatlinkshere-barrow',
		'linklistsub',
		'linkshere',
		'nolinkshere',
		'nolinkshere-ns',
		'isredirect',
		'istemplate',
		'whatlinkshere-prev',
		'whatlinkshere-next',
		'whatlinkshere-links',
	),
	'block' => array(
		'blockip',
		'blockiptext',
		'ipaddress',
		'ipadressorusername',
		'ipbexpiry',
		'ipbreason',
		'ipbreasonotherlist',
		'ipbreason-dropdown',
		'ipbanononly',
		'ipbcreateaccount',
		'ipbemailban',
		'ipbenableautoblock',
		'ipbsubmit',
		'ipbother',
		'ipboptions',
		'ipbotheroption',
		'ipbotherreason',
		'ipbhidename',
		'badipaddress',
		'blockipsuccesssub',
		'blockipsuccesstext',
		'ipb-edit-dropdown',
		'ipb-unblock-addr',
		'ipb-unblock',
		'ipb-blocklist-addr',
		'ipb-blocklist',
		'unblockip',
		'unblockiptext',
		'ipusubmit',
		'unblocked',
		'unblocked-id',
		'ipblocklist',
		'ipblocklist-legend',
		'ipblocklist-username',
		'ipblocklist-summary',
		'ipblocklist-submit',
		'blocklistline',
		'infiniteblock',
		'expiringblock',
		'anononlyblock',
		'noautoblockblock',
		'createaccountblock',
		'emailblock',
		'ipblocklist-empty',
		'ipblocklist-no-results',
		'blocklink',
		'unblocklink',
		'contribslink',
		'autoblocker',
		'blocklogpage',
		'blocklogentry',
		'blocklogtext',
		'unblocklogentry',
		'block-log-flags-anononly',
		'block-log-flags-nocreate',
		'block-log-flags-noautoblock',
		'block-log-flags-noemail',
		'range_block_disabled',
		'ipb_expiry_invalid',
		'ipb_already_blocked',
		'ipb_cant_unblock',
		'ipb_blocked_as_range',
		'ip_range_invalid',
		'blockme',
		'proxyblocker',
		'proxyblocker-disabled',
		'proxyblockreason',
		'proxyblocksuccess',
		'sorbs',
		'sorbsreason',
		'sorbs_create_account_reason',
	),
	'developertools' => array(
		'lockdb',
		'unlockdb',
		'lockdbtext',
		'unlockdbtext',
		'lockconfirm',
		'unlockconfirm',
		'lockbtn',
		'unlockbtn',
		'locknoconfirm',
		'lockdbsuccesssub',
		'unlockdbsuccesssub',
		'lockdbsuccesstext',
		'unlockdbsuccesstext',
		'lockfilenotwritable',
		'databasenotlocked',
	),
	'movepage' => array(
		'movepage',
		'movepagetext',
		'movepagetalktext',
		'movearticle',
		'movenologin',
		'movenologintext',
		'movenotallowed',
		'newtitle',
		'move-watch',
		'movepagebtn',
		'pagemovedsub',
		'movepage-moved',
		'articleexists',
		'cantmove-titleprotected',
		'talkexists',
		'movedto',
		'movetalk',
		'talkpagemoved',
		'talkpagenotmoved',
		'1movedto2',
		'1movedto2_redir',
		'movelogpage',
		'movelogpagetext',
		'movereason',
		'revertmove',
		'delete_and_move',
		'delete_and_move_text',
		'delete_and_move_confirm',
		'delete_and_move_reason',
		'selfmove',
		'immobile_namespace',
	),
	'export' => array(
		'export',
		'exporttext',
		'exportcuronly',
		'exportnohistory',
		'export-submit',
		'export-addcattext',
		'export-addcat',
		'export-download',
		'export-templates',
	),
	'allmessages' => array(
		'allmessages',
		'allmessagesname',
		'allmessagesdefault',
		'allmessagescurrent',
		'allmessagestext',
		'allmessagesnotsupportedDB',
		'allmessagesfilter',
		'allmessagesmodified',
	),
	'thumbnails' => array(
		'thumbnail-more',
		'filemissing',
		'thumbnail_error',
		'djvu_page_error',
		'djvu_no_xml',
		'thumbnail_invalid_params',
		'thumbnail_dest_directory',
	),
	'import' => array(
		'import',
		'importinterwiki',
		'import-interwiki-text',
		'import-interwiki-history',
		'import-interwiki-submit',
		'import-interwiki-namespace',
		'importtext',
		'importstart',
		'import-revision-count',
		'importnopages',
		'importfailed',
		'importunknownsource',
		'importcantopen',
		'importbadinterwiki',
		'importnotext',
		'importsuccess',
		'importhistoryconflict',
		'importnosources',
		'importnofile',
		'importuploaderrorsize',
		'importuploaderrorpartial',
		'importuploaderrortemp',
		'import-parse-failure',
		'import-noarticle',
		'import-nonewrevisions',
		'xml-error-string',
	),
	'importlog' => array(
		'importlogpage',
		'importlogpagetext',
		'import-logentry-upload',
		'import-logentry-upload-detail',
		'import-logentry-interwiki',
		'import-logentry-interwiki-detail',
	),
	'accesskeys' => array(
		'accesskey-pt-userpage',
		'accesskey-pt-anonuserpage',
		'accesskey-pt-mytalk',
		'accesskey-pt-anontalk',
		'accesskey-pt-preferences',
		'accesskey-pt-watchlist',
		'accesskey-pt-mycontris',
		'accesskey-pt-login',
		'accesskey-pt-anonlogin',
		'accesskey-pt-logout',
		'accesskey-ca-talk',
		'accesskey-ca-edit',
		'accesskey-ca-addsection',
		'accesskey-ca-viewsource',
		'accesskey-ca-history',
		'accesskey-ca-protect',
		'accesskey-ca-delete',
		'accesskey-ca-undelete',
		'accesskey-ca-move',
		'accesskey-ca-watch',
		'accesskey-ca-unwatch',
		'accesskey-search',
		'accesskey-search-go',
		'accesskey-search-fulltext',
		'accesskey-p-logo',
		'accesskey-n-mainpage',
		'accesskey-n-portal',
		'accesskey-n-currentevents',
		'accesskey-n-recentchanges',
		'accesskey-n-randompage',
		'accesskey-n-help',
		'accesskey-n-sitesupport',
		'accesskey-t-whatlinkshere',
		'accesskey-t-recentchangeslinked',
		'accesskey-t-random',
		'accesskey-feed-rss',
		'accesskey-feed-atom',
		'accesskey-t-contributions',
		'accesskey-t-emailuser',
		'accesskey-t-permalink',
		'accesskey-t-print',
		'accesskey-t-upload',
		'accesskey-t-specialpages',
		'accesskey-ca-nstab-main',
		'accesskey-ca-nstab-user',
		'accesskey-ca-nstab-media',
		'accesskey-ca-nstab-special',
		'accesskey-ca-nstab-project',
		'accesskey-ca-nstab-image',
		'accesskey-ca-nstab-mediawiki',
		'accesskey-ca-nstab-template',
		'accesskey-ca-nstab-help',
		'accesskey-ca-nstab-category',
		'accesskey-minoredit',
		'accesskey-save',
		'accesskey-preview',
		'accesskey-diff',
		'accesskey-compareselectedversions',
		'accesskey-watch',
		'accesskey-upload',
	),
	'tooltips' => array(
		'tooltip-pt-userpage',
		'tooltip-pt-anonuserpage',
		'tooltip-pt-mytalk',
		'tooltip-pt-anontalk',
		'tooltip-pt-preferences',
		'tooltip-pt-watchlist',
		'tooltip-pt-mycontris',
		'tooltip-pt-login',
		'tooltip-pt-anonlogin',
		'tooltip-pt-logout',
		'tooltip-ca-talk',
		'tooltip-ca-edit',
		'tooltip-ca-addsection',
		'tooltip-ca-viewsource',
		'tooltip-ca-history',
		'tooltip-ca-protect',
		'tooltip-ca-delete',
		'tooltip-ca-undelete',
		'tooltip-ca-move',
		'tooltip-ca-watch',
		'tooltip-ca-unwatch',
		'tooltip-search',
		'tooltip-search-go',
		'tooltip-search-fulltext',
		'tooltip-p-logo',
		'tooltip-n-mainpage',
		'tooltip-n-portal',
		'tooltip-n-currentevents',
		'tooltip-n-recentchanges',
		'tooltip-n-randompage',
		'tooltip-n-help',
		'tooltip-n-sitesupport',
		'tooltip-t-whatlinkshere',
		'tooltip-t-recentchangeslinked',
		'tooltip-t-random',
		'tooltip-feed-rss',
		'tooltip-feed-atom',
		'tooltip-t-contributions',
		'tooltip-t-emailuser',
		'tooltip-t-upload',
		'tooltip-t-specialpages',
		'tooltip-t-print',
		'tooltip-t-permalink',
		'tooltip-ca-nstab-main',
		'tooltip-ca-nstab-user',
		'tooltip-ca-nstab-media',
		'tooltip-ca-nstab-special',
		'tooltip-ca-nstab-project',
		'tooltip-ca-nstab-image',
		'tooltip-ca-nstab-mediawiki',
		'tooltip-ca-nstab-template',
		'tooltip-ca-nstab-help',
		'tooltip-ca-nstab-category',
		'tooltip-minoredit',
		'tooltip-save',
		'tooltip-preview',
		'tooltip-diff',
		'tooltip-compareselectedversions',
		'tooltip-watch',
		'tooltip-recreate',
		'tooltip-upload',
	),
	'stylesheets' => array(
		'common.css',
		'monobook.css',
	),
	'scripts' => array(
		'common.js',
		'monobook.js',
	),
	'metadata_cc' => array(
		'nodublincore',
		'nocreativecommons',
		'notacceptable',
	),
	'attribution' => array(
		'anonymous',
		'siteuser',
		'lastmodifiedatby',
		'othercontribs',
		'others',
		'siteusers',
		'creditspage',
		'nocredits',
	),
	'spamprotection' => array(
		'spamprotectiontitle',
		'spamprotectiontext',
		'spamprotectionmatch',
		'subcategorycount',
		'categoryarticlecount',
		'category-media-count',
		'listingcontinuesabbrev',
		'spambot_username',
		'spam_reverting',
		'spam_blanking',
	),
	'info' => array(
		'infosubtitle',
		'numedits',
		'numtalkedits',
		'numwatchers',
		'numauthors',
		'numtalkauthors',
	),
	'math' => array(
		'mw_math_png',
		'mw_math_simple',
		'mw_math_html',
		'mw_math_source',
		'mw_math_modern',
		'mw_math_mathml',
	),
	'patrolling' => array(
		'markaspatrolleddiff',
		'markaspatrolledlink',
		'markaspatrolledtext',
		'markedaspatrolled',
		'markedaspatrolledtext',
		'rcpatroldisabled',
		'rcpatroldisabledtext',
		'markedaspatrollederror',
		'markedaspatrollederrortext',
		'markedaspatrollederror-noautopatrol',
	),
	'patrol-log' => array(
		'patrol-log-page',
		'patrol-log-header',
		'patrol-log-line',
		'patrol-log-auto',
		'patrol-log-diff',
	),
	'imagedeletion' => array(
		'deletedrevision',
		'filedeleteerror-short',
		'filedeleteerror-long',
		'filedelete-missing',
		'filedelete-old-unregistered',
		'filedelete-current-unregistered',
		'filedelete-archive-read-only',
	),
	'browsediffs' => array(
		'previousdiff',
		'nextdiff',
	),
	'media-info' => array(
		'mediawarning',
		'imagemaxsize',
		'thumbsize',
		'widthheight',
		'widthheightpage',
		'file-info',
		'file-info-size',
		'file-nohires',
		'svg-long-desc',
		'show-big-image',
		'show-big-image-thumb',
	),
	'newimages' => array(
		'newimages',
		'newimages-summary',
		'showhidebots',
		'noimages',
	),
	'video-info' => array(
		'video-dims',
		'seconds-abbrev',
		'minutes-abbrev',
		'hours-abbrev',
	),
	'badimagelist' => array(
		'bad_image_list',
	),
	'variantname-zh' => array(
		'variantname-zh-hans',
		'variantname-zh-hant',
		'variantname-zh-cn',
		'variantname-zh-tw',
		'variantname-zh-hk',
		'variantname-zh-sg',
		'variantname-zh',
	),
	'variantname-sr' => array(
		'variantname-sr-ec',
		'variantname-sr-el',
		'variantname-sr-jc',
		'variantname-sr-jl',
		'variantname-sr',
	),
	'variantname-kk' => array(
		'variantname-kk-kz',
		'variantname-kk-tr',
		'variantname-kk-cn',
		'variantname-kk-cyrl',
		'variantname-kk-latn',
		'variantname-kk-arab',
		'variantname-kk',
	),
	'variantname-ku' => array(
		'variantname-ku-arab',
		'variantname-ku-latn',
		'variantname-ku',
	),
	'metadata' => array(
		'metadata',
		'metadata-help',
		'metadata-expand',
		'metadata-collapse',
		'metadata-fields',
	),
	'exif' => array(
		'exif-imagewidth',
		'exif-imagelength',
		'exif-bitspersample',
		'exif-compression',
		'exif-photometricinterpretation',
		'exif-orientation',
		'exif-samplesperpixel',
		'exif-planarconfiguration',
		'exif-ycbcrsubsampling',
		'exif-ycbcrpositioning',
		'exif-xresolution',
		'exif-yresolution',
		'exif-resolutionunit',
		'exif-stripoffsets',
		'exif-rowsperstrip',
		'exif-stripbytecounts',
		'exif-jpeginterchangeformat',
		'exif-jpeginterchangeformatlength',
		'exif-transferfunction',
		'exif-whitepoint',
		'exif-primarychromaticities',
		'exif-ycbcrcoefficients',
		'exif-referenceblackwhite',
		'exif-datetime',
		'exif-imagedescription',
		'exif-make',
		'exif-model',
		'exif-software',
		'exif-artist',
		'exif-copyright',
		'exif-exifversion',
		'exif-flashpixversion',
		'exif-colorspace',
		'exif-componentsconfiguration',
		'exif-compressedbitsperpixel',
		'exif-pixelydimension',
		'exif-pixelxdimension',
		'exif-makernote',
		'exif-usercomment',
		'exif-relatedsoundfile',
		'exif-datetimeoriginal',
		'exif-datetimedigitized',
		'exif-subsectime',
		'exif-subsectimeoriginal',
		'exif-subsectimedigitized',
		'exif-exposuretime',
		'exif-exposuretime-format',
		'exif-fnumber',
		'exif-fnumber-format',
		'exif-exposureprogram',
		'exif-spectralsensitivity',
		'exif-isospeedratings',
		'exif-oecf',
		'exif-shutterspeedvalue',
		'exif-aperturevalue',
		'exif-brightnessvalue',
		'exif-exposurebiasvalue',
		'exif-maxaperturevalue',
		'exif-subjectdistance',
		'exif-meteringmode',
		'exif-lightsource',
		'exif-flash',
		'exif-focallength',
		'exif-focallength-format',
		'exif-subjectarea',
		'exif-flashenergy',
		'exif-spatialfrequencyresponse',
		'exif-focalplanexresolution',
		'exif-focalplaneyresolution',
		'exif-focalplaneresolutionunit',
		'exif-subjectlocation',
		'exif-exposureindex',
		'exif-sensingmethod',
		'exif-filesource',
		'exif-scenetype',
		'exif-cfapattern',
		'exif-customrendered',
		'exif-exposuremode',
		'exif-whitebalance',
		'exif-digitalzoomratio',
		'exif-focallengthin35mmfilm',
		'exif-scenecapturetype',
		'exif-gaincontrol',
		'exif-contrast',
		'exif-saturation',
		'exif-sharpness',
		'exif-devicesettingdescription',
		'exif-subjectdistancerange',
		'exif-imageuniqueid',
		'exif-gpsversionid',
		'exif-gpslatituderef',
		'exif-gpslatitude',
		'exif-gpslongituderef',
		'exif-gpslongitude',
		'exif-gpsaltituderef',
		'exif-gpsaltitude',
		'exif-gpstimestamp',
		'exif-gpssatellites',
		'exif-gpsstatus',
		'exif-gpsmeasuremode',
		'exif-gpsdop',
		'exif-gpsspeedref',
		'exif-gpsspeed',
		'exif-gpstrackref',
		'exif-gpstrack',
		'exif-gpsimgdirectionref',
		'exif-gpsimgdirection',
		'exif-gpsmapdatum',
		'exif-gpsdestlatituderef',
		'exif-gpsdestlatitude',
		'exif-gpsdestlongituderef',
		'exif-gpsdestlongitude',
		'exif-gpsdestbearingref',
		'exif-gpsdestbearing',
		'exif-gpsdestdistanceref',
		'exif-gpsdestdistance',
		'exif-gpsprocessingmethod',
		'exif-gpsareainformation',
		'exif-gpsdatestamp',
		'exif-gpsdifferential',
	),
	'exif-values' => array(
		'exif-make-value',
		'exif-model-value',
		'exif-software-value',
	),
	'exif-compression' => array(
		'exif-compression-1',
		'exif-compression-6',
	),
	'exif-photometricinterpretation' => array(
		'exif-photometricinterpretation-2',
		'exif-photometricinterpretation-6',
	),
	'exif-unknowndate' => array(
		'exif-unknowndate',
	),
	'exif-orientation' => array(
		'exif-orientation-1',
		'exif-orientation-2',
		'exif-orientation-3',
		'exif-orientation-4',
		'exif-orientation-5',
		'exif-orientation-6',
		'exif-orientation-7',
		'exif-orientation-8',
	),
	'exif-planarconfiguration' => array(
		'exif-planarconfiguration-1',
		'exif-planarconfiguration-2',
	),
	'exif-xyresolution' => array(
		'exif-xyresolution-i',
		'exif-xyresolution-c',
	),
	'exif-colorspace' => array(
		'exif-colorspace-1',
		'exif-colorspace-ffff.h',
	),
	'exif-componentsconfiguration' => array(
		'exif-componentsconfiguration-0',
		'exif-componentsconfiguration-1',
		'exif-componentsconfiguration-2',
		'exif-componentsconfiguration-3',
		'exif-componentsconfiguration-4',
		'exif-componentsconfiguration-5',
		'exif-componentsconfiguration-6',
	),
	'exif-exposureprogram' => array(
		'exif-exposureprogram-0',
		'exif-exposureprogram-1',
		'exif-exposureprogram-2',
		'exif-exposureprogram-3',
		'exif-exposureprogram-4',
		'exif-exposureprogram-5',
		'exif-exposureprogram-6',
		'exif-exposureprogram-7',
		'exif-exposureprogram-8',
	),
	'exif-subjectdistance-value' => array(
		'exif-subjectdistance-value',
	),
	'exif-meteringmode' => array(
		'exif-meteringmode-0',
		'exif-meteringmode-1',
		'exif-meteringmode-2',
		'exif-meteringmode-3',
		'exif-meteringmode-4',
		'exif-meteringmode-5',
		'exif-meteringmode-6',
		'exif-meteringmode-255',
	),
	'exif-lightsource' => array(
		'exif-lightsource-0',
		'exif-lightsource-1',
		'exif-lightsource-2',
		'exif-lightsource-3',
		'exif-lightsource-4',
		'exif-lightsource-9',
		'exif-lightsource-10',
		'exif-lightsource-11',
		'exif-lightsource-12',
		'exif-lightsource-13',
		'exif-lightsource-14',
		'exif-lightsource-15',
		'exif-lightsource-17',
		'exif-lightsource-18',
		'exif-lightsource-19',
		'exif-lightsource-20',
		'exif-lightsource-21',
		'exif-lightsource-22',
		'exif-lightsource-23',
		'exif-lightsource-24',
		'exif-lightsource-255',
	),
	'exif-focalplaneresolutionunit' => array(
		'exif-focalplaneresolutionunit-2',
	),
	'exif-sensingmethod' => array(
		'exif-sensingmethod-1',
		'exif-sensingmethod-2',
		'exif-sensingmethod-3',
		'exif-sensingmethod-4',
		'exif-sensingmethod-5',
		'exif-sensingmethod-7',
		'exif-sensingmethod-8',
	),
	'exif-filesource' => array(
		'exif-filesource-3',
	),
	'exif-scenetype' => array(
		'exif-scenetype-1',
	),
	'exif-customrendered' => array(
		'exif-customrendered-0',
		'exif-customrendered-1',
	),
	'exif-exposuremode' => array(
		'exif-exposuremode-0',
		'exif-exposuremode-1',
		'exif-exposuremode-2',
	),
	'exif-whitebalance' => array(
		'exif-whitebalance-0',
		'exif-whitebalance-1',
	),
	'exif-scenecapturetype' => array(
		'exif-scenecapturetype-0',
		'exif-scenecapturetype-1',
		'exif-scenecapturetype-2',
		'exif-scenecapturetype-3',
	),
	'exif-gaincontrol' => array(
		'exif-gaincontrol-0',
		'exif-gaincontrol-1',
		'exif-gaincontrol-2',
		'exif-gaincontrol-3',
		'exif-gaincontrol-4',
	),
	'exif-contrast' => array(
		'exif-contrast-0',
		'exif-contrast-1',
		'exif-contrast-2',
	),
	'exif-saturation' => array(
		'exif-saturation-0',
		'exif-saturation-1',
		'exif-saturation-2',
	),
	'exif-sharpness' => array(
		'exif-sharpness-0',
		'exif-sharpness-1',
		'exif-sharpness-2',
	),
	'exif-subjectdistancerange' => array(
		'exif-subjectdistancerange-0',
		'exif-subjectdistancerange-1',
		'exif-subjectdistancerange-2',
		'exif-subjectdistancerange-3',
	),
	'exif-gpslatitude' => array(
		'exif-gpslatitude-n',
		'exif-gpslatitude-s',
	),
	'exif-gpslongitude' => array(
		'exif-gpslongitude-e',
		'exif-gpslongitude-w',
	),
	'exif-gpsstatus' => array(
		'exif-gpsstatus-a',
		'exif-gpsstatus-v',
	),
	'exif-gpsmeasuremode' => array(
		'exif-gpsmeasuremode-2',
		'exif-gpsmeasuremode-3',
	),
	'exif-gpsspeed' => array(
		'exif-gpsspeed-k',
		'exif-gpsspeed-m',
		'exif-gpsspeed-n',
	),
	'exif-gpsdirection' => array(
		'exif-gpsdirection-t',
		'exif-gpsdirection-m',
	),
	'edit-externally' => array(
		'edit-externally',
		'edit-externally-help',
	),
	'all' => array(
		'recentchangesall',
		'imagelistall',
		'watchlistall2',
		'namespacesall',
		'monthsall',
	),
	'confirmemail' => array(
		'confirmemail',
		'confirmemail_noemail',
		'confirmemail_text',
		'confirmemail_pending',
		'confirmemail_send',
		'confirmemail_sent',
		'confirmemail_oncreate',
		'confirmemail_sendfailed',
		'confirmemail_invalid',
		'confirmemail_needlogin',
		'confirmemail_success',
		'confirmemail_loggedin',
		'confirmemail_error',
		'confirmemail_subject',
		'confirmemail_body',
	),
	'scarytransclusion' => array(
		'scarytranscludedisabled',
		'scarytranscludefailed',
		'scarytranscludetoolong',
	),
	'trackbacks' => array(
		'trackbackbox',
		'trackback',
		'trackbackexcerpt',
		'trackbackremove',
		'trackbacklink',
		'trackbackdeleteok',
	),
	'deleteconflict' => array(
		'deletedwhileediting',
		'confirmrecreate',
		'recreate',
	),
	'unit-pixel' => array(
		'unit-pixel',
	),
	'htmldump' => array(
		'redirectingto',
	),
	'purge' => array(
		'confirm_purge',
		'confirm_purge_button',
	),
	'search2' => array(
		'searchcontaining',
		'searchnamed',
		'articletitles',
		'hideresults',
		'useajaxsearch',
	),
	'separators' => array(
		'catseparator',
		'semicolon-separator',
		'comma-separator',
	),
	'imgmulti' => array(
		'imgmultipageprev',
		'imgmultipagenext',
		'imgmultigo',
		'imgmultigotopre',
		'imgmultigotopost',
	),
	'tablepager' => array(
		'ascending_abbrev',
		'descending_abbrev',
		'table_pager_next',
		'table_pager_prev',
		'table_pager_first',
		'table_pager_last',
		'table_pager_limit',
		'table_pager_limit_submit',
		'table_pager_empty',
	),
	'autosumm' => array(
		'autosumm-blank',
		'autosumm-replace',
		'autoredircomment',
		'autosumm-new',
	),
	'autoblock_whitelist' => array(
		'autoblock_whitelist',
	),
	'sizeunits' => array(
		'size-bytes',
		'size-kilobytes',
		'size-megabytes',
		'size-gigabytes',
	),
	'livepreview' => array(
		'livepreview-loading',
		'livepreview-ready',
		'livepreview-failed',
		'livepreview-error',
	),
	'lagwarning' => array(
		'lag-warn-normal',
		'lag-warn-high',
	),
	'watchlisteditor' => array(
		'watchlistedit-numitems',
		'watchlistedit-noitems',
		'watchlistedit-normal-title',
		'watchlistedit-normal-legend',
		'watchlistedit-normal-explain',
		'watchlistedit-normal-submit',
		'watchlistedit-normal-done',
		'watchlistedit-raw-title',
		'watchlistedit-raw-legend',
		'watchlistedit-raw-explain',
		'watchlistedit-raw-titles',
		'watchlistedit-raw-submit',
		'watchlistedit-raw-done',
		'watchlistedit-raw-added',
		'watchlistedit-raw-removed',
	),
	'watchlisttools' => array(
		'watchlisttools-view',
		'watchlisttools-edit',
		'watchlisttools-raw',
	),
	'iranian-dates' => array(
		'iranian-calendar-m1',
		'iranian-calendar-m2',
		'iranian-calendar-m3',
		'iranian-calendar-m4',
		'iranian-calendar-m5',
		'iranian-calendar-m6',
		'iranian-calendar-m7',
		'iranian-calendar-m8',
		'iranian-calendar-m9',
		'iranian-calendar-m10',
		'iranian-calendar-m11',
		'iranian-calendar-m12',
	),
	'hebrew-dates' => array(
		'hebrew-calendar-m1',
		'hebrew-calendar-m2',
		'hebrew-calendar-m3',
		'hebrew-calendar-m4',
		'hebrew-calendar-m5',
		'hebrew-calendar-m6',
		'hebrew-calendar-m6a',
		'hebrew-calendar-m6b',
		'hebrew-calendar-m7',
		'hebrew-calendar-m8',
		'hebrew-calendar-m9',
		'hebrew-calendar-m10',
		'hebrew-calendar-m11',
		'hebrew-calendar-m12',
		'hebrew-calendar-m1-gen',
		'hebrew-calendar-m2-gen',
		'hebrew-calendar-m3-gen',
		'hebrew-calendar-m4-gen',
		'hebrew-calendar-m5-gen',
		'hebrew-calendar-m6-gen',
		'hebrew-calendar-m6a-gen',
		'hebrew-calendar-m6b-gen',
		'hebrew-calendar-m7-gen',
		'hebrew-calendar-m8-gen',
		'hebrew-calendar-m9-gen',
		'hebrew-calendar-m10-gen',
		'hebrew-calendar-m11-gen',
		'hebrew-calendar-m12-gen',
	),
	'signatures' => array(
		'signature',
		'signature-anon',
	),
	'CoreParserFunctions' => array(
		'unknown_extension_tag',
	),
	'version' => array(
		'version-extensions',
		'version-specialpages',
		'version-parserhooks',
		'version-variables',
		'version-other',
		'version-mediahandlers',
		'version-hooks',
		'version-extension-functions',
		'version-parser-extensiontags',
		'version-parser-function-hooks',
		'version-skin-extension-functions',
		'version-hook-name',
		'version-hook-subscribedby',
		'version-version',
		'version-license',
		'version-software',
		'version-software-product',
		'version-software-version',
	),
	'filepath' => array(
		'filepath',
		'filepath-page',
		'filepath-submit',
		'filepath-summary',
	),
);
/** Comments for each block */
$wgBlockComments = array(
	'sidebar'             => "The sidebar for MonoBook is generated from this message, lines that do not
begin with * or ** are discarded, furthermore lines that do begin with ** and
do not contain | are also discarded, but don't depend on this behaviour for
future releases. Also note that since each list value is wrapped in a unique
XHTML id it should only appear once and include characters that are legal
XHTML id names.",
	'toggles'             => 'User preference toggles',
	'underline'           => '',
	'skinpreview'         => '',
	'dates'               => 'Dates',
	'categories'          => 'Bits of text used by many pages',
	'mainpage'            => '',
	'miscellaneous1'      => '',
	'metadata_help'       => 'Metadata in edit box',
	'miscellaneous2'      => '',
	'links'               => 'All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).',
	'badaccess'           => '',
	'versionrequired'     => '',
	'miscellaneous3'      => '',
	'nstab'               => "Short words for each namespace, by default used in the namespace tab in monobook",
	'main'                => 'Main script and global functions',
	'errors'              => 'General errors',
	'login'               => 'Login and logout pages',
	'resetpass'           => 'Password reset dialog',
	'toolbar'             => 'Edit page toolbar',
	'edit'                => 'Edit pages',
	'undo'                => '"Undo" feature',
	'cantcreateaccount'   => 'Account creation failure',
	'history'             => 'History pages',
	'history-feed'        => 'Revision feed',
	'revdelete'           => 'Revision deletion',
	'oversightlog'        => 'Oversight log',
	'mergehistory'        => 'History merging',
	'mergelog'            => 'Merge log',
	'diffs'               => 'Diffs',
	'search'              => 'Search results',
	'preferences'         => 'Preferences page',
	'userrights'          => 'User rights',
	'group'               => 'Groups',
	'group-member'        => '',
	'grouppage'           => '',
	'rightslog'           => 'User rights log',
	'recentchanges'       => 'Recent changes',
	'recentchangeslinked' => 'Recent changes linked',
	'upload'              => 'Upload',
	'upload-errors'       => '',
	'upload-curl-errors'  => 'Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>',
	'licenses'            => '',
	'imagelist'           => 'Image list',
	'filerevert'          => 'File reversion',
	'filedelete'		  => 'File deletion',
	'mimesearch'          => 'MIME search',
	'unwatchedpages'      => 'Unwatched pages',
	'listredirects'       => 'List redirects',
	'unusedtemplates'     => 'Unused templates',
	'randompage'          => 'Random page',
	'randomredirect'      => 'Random redirect',
	'statistics'          => 'Statistics',
	'disambiguations'     => '',
	'doubleredirects'     => '',
	'brokenredirects'     => '',
	'withoutinterwiki'    => '',
	'fewestrevisions'     => '',
	'specialpages'        => 'Miscellaneous special pages',
	'booksources'         => 'Book sources',
	'specialpages2'       => '',
	'logpages'            => 'Special:Log',
	'allpages'            => 'Special:Allpages',
	'listusers'           => 'Special:Listusers',
	'emailuser'           => 'E-mail user',
	'watchlist'           => 'Watchlist',
	'watching'            => 'Displayed when you click the "watch" button and it\'s in the process of watching',
	'enotif'              => '',
	'deleteprotectrev'    => 'Delete/protect/revert',
	'restrictions'        => 'Restrictions (nouns)',
	'restriction-levels'  => 'Restriction levels',
	'undelete'            => 'Undelete',
	'nsform'              => 'Namespace form on various pages',
	'contributions'       => 'Contributions',
	'sp-contributions'    => '',
	'newimages-showfrom'  => '',
	'whatlinkshere'       => 'What links here',
	'block'               => 'Block/unblock',
	'developertools'      => 'Developer tools',
	'movepage'            => 'Move page',
	'export'              => 'Export',
	'allmessages'         => 'Namespace 8 related',
	'thumbnails'          => 'Thumbnails',
	'import'              => 'Special:Import',
	'importlog'           => 'Import log',
	'accesskeys'          => 'Keyboard access keys for power users',
	'tooltips'            => 'Tooltip help for the actions',
	'stylesheets'         => 'Stylesheets',
	'scripts'             => 'Scripts',
	'metadata_cc'         => 'Metadata',
	'attribution'         => 'Attribution',
	'spamprotection'      => 'Spam protection',
	'info'                => 'Info page',
	'math'                => 'Math options',
	'patrolling'          => 'Patrolling',
	'patrol-log'          => 'Patrol log',
	'imagedeletion'       => 'Image deletion',
	'browsediffs'         => 'Browsing diffs',
	'newimages'           => 'Special:Newimages',
	'video-info'          => 'Video information, used by Language::formatTimePeriod() to format lengths in the above messages',
	'badimagelist'        => 'Bad image list',
	'variantname-zh'      => "Short names for language variants used for language conversion links.
To disable showing a particular link, set it to 'disable', e.g.
'variantname-zh-sg' => 'disable',
Variants for Chinese language",
	'variantname-sr'      => 'Variants for Serbian language',
	'variantname-kk'      => 'Variants for Kazakh language',
	'variantname-ku'      => 'Variants for Kurdish language',
	'media-info'          => 'Media information',
	'metadata'            => 'Metadata',
	'exif'                           => 'EXIF tags',
	'exif-values'                    => 'Make & model, can be wikified in order to link to the camera and model name',
	'exif-compression'               => 'EXIF attributes',
	'exif-unknowndate'               => '',
	'exif-photometricinterpretation' => '',
	'exif-orientation'               => '',
	'exif-planarconfiguration'       => '',
	'exif-xyresolution'              => '',
	'exif-colorspace'                => '',
	'exif-componentsconfiguration'   => '',
	'exif-exposureprogram'           => '',
	'exif-subjectdistance-value'     => '',
	'exif-meteringmode'              => '',
	'exif-lightsource'               => '',
	'exif-focalplaneresolutionunit'  => '',
	'exif-sensingmethod'             => '',
	'exif-filesource'                => '',
	'exif-scenetype'                 => '',
	'exif-customrendered'            => '',
	'exif-exposuremode'              => '',
	'exif-whitebalance'              => '',
	'exif-scenecapturetype'          => '',
	'exif-gaincontrol'               => '',
	'exif-contrast'                  => '',
	'exif-saturation'                => '',
	'exif-sharpness'                 => '',
	'exif-subjectdistancerange'      => '',
	'exif-gpslatitude'               => 'Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef',
	'exif-gpslongitude'              => 'Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef',
	'exif-gpsstatus'                 => '',
	'exif-gpsmeasuremode'            => '',
	'exif-gpsspeed'                  => 'Pseudotags used for GPSSpeedRef and GPSDestDistanceRef',
	'exif-gpsdirection'              => 'Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef',
	'edit-externally'       => 'External editor support',
	'all'                   => "'all' in various places, this might be different for inflected languages",
	'confirmemail'          => 'E-mail address confirmation',
	'scarytransclusion'     => 'Scary transclusion',
	'trackbacks'            => 'Trackbacks',
	'deleteconflict'        => 'Delete conflict',
	'unit-pixel'            => '',
	'htmldump'              => 'HTML dump',
	'purge'                 => 'action=purge',
	'search2'               => 'AJAX search',
	'separators'            => 'Separators for various lists',
	'imgmulti'              => 'Multipage image navigation',
	'tablepager'            => 'Table pager',
	'autosumm'              => 'Auto-summaries',
	'autoblock_whitelist'   => 'Autoblock whitelist',
	'sizeunits'             => 'Size units',
	'livepreview'           => 'Live preview',
	'lagwarning'            => 'Friendlier slave lag warnings',
	'watchlisteditor'       => 'Watchlist editor',
	'watchlisttools'        => 'Watchlist editing tools',
	'iranian-dates'         => 'Iranian month names',
	'hebrew-dates'          => 'Hebrew month names',
	'signatures'            => 'Signatures',
	'CoreParserFunctions'   => 'Core parser functions',
	'version'               => 'Special:Version',
	'filepath'              => 'Special:Filepath',
);

/** Short comments for standalone messages */
$wgMessageComments = array(
	'lastmodifiedat'              => '$1 date, $2 time',
	'sitenotice'                  => 'the equivalent to wgSiteNotice',
	'history-feed-item-nocomment' => 'user at time',
	'editcomment'                 => 'only shown if there is an edit comment',
	'revertpage'                  => 'Additional available: $3: revid of the revision reverted to, $4: timestamp of the revision reverted to, $5: revid of the revision reverted from, $6: timestamp of the revision reverted from',
	'lastmodifiedatby'            => '$1 date, $2 time, $3 user',
	'exif-orientation-1'          => '0th row: top; 0th column: left',
	'exif-orientation-2'          => '0th row: top; 0th column: right',
	'exif-orientation-3'          => '0th row: bottom; 0th column: right',
	'exif-orientation-4'          => '0th row: bottom; 0th column: left',
	'exif-orientation-5'          => '0th row: left; 0th column: top',
	'exif-orientation-6'          => '0th row: right; 0th column: top',
	'exif-orientation-7'          => '0th row: right; 0th column: bottom',
	'exif-orientation-8'          => '0th row: left; 0th column: bottom',
	'movepage-moved'              => 'The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.',
	'ipboptions'                  => 'display1:time1,display2:time2,...',
	'metadata-fields'             => 'Do not translate list items',
);
