#---------------------------------------------------------------------------
#
#   libtunepimp -- The MusicBrainz tagging library.  
#                  Let a thousand taggers bloom!
#   
#   Copyright (C) Robert Kaye 2003
#   
#   This file is part of libtunepimp.
#
#   libtunepimp is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   libtunepimp is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with libtunepimp; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   $Id: track.py,v 1.3 2004/03/25 09:20:15 robert Exp $
#
#---------------------------------------------------------------------------
import _tunepimp

import metadata

def _swig_setattr(self,class_type,name,value):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    self.__dict__[name] = value

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types

class artistresult(_object):
    '''This class is used to get/set the information for an artist lookup result. For details
       on how to use this class, please look up the main tunepimp documentation'''

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, artistresult, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, artistresult, name)
    def __repr__(self):
        return "<C artistresult instance at %s>" % (self.this,)
    __swig_setmethods__["relevance"] = _tunepimp.artistresult_relevance_set
    __swig_getmethods__["relevance"] = _tunepimp.artistresult_relevance_get
    if _newclass:relevance = property(_tunepimp.artistresult_relevance_get, _tunepimp.artistresult_relevance_set)
    __swig_setmethods__["name"] = _tunepimp.artistresult_name_set
    __swig_getmethods__["name"] = _tunepimp.artistresult_name_get
    if _newclass:name = property(_tunepimp.artistresult_name_get, _tunepimp.artistresult_name_set)
    __swig_setmethods__["sortName"] = _tunepimp.artistresult_sortName_set
    __swig_getmethods__["sortName"] = _tunepimp.artistresult_sortName_get
    if _newclass:sortName = property(_tunepimp.artistresult_sortName_get, _tunepimp.artistresult_sortName_set)
    __swig_setmethods__["id"] = _tunepimp.artistresult_id_set
    __swig_getmethods__["id"] = _tunepimp.artistresult_id_get
    if _newclass:id = property(_tunepimp.artistresult_id_get, _tunepimp.artistresult_id_set)
    def __init__(self, *args):
        _swig_setattr(self, artistresult, 'this', _tunepimp.new_artistresult(*args))
        _swig_setattr(self, artistresult, 'thisown', 1)
    def __del__(self, destroy=_tunepimp.delete_artistresult):
        try:
            if self.thisown: destroy(self)
        except: pass

class artistresultPtr(artistresult):
    def __init__(self, this):
        _swig_setattr(self, artistresult, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, artistresult, 'thisown', 0)
        _swig_setattr(self, artistresult,self.__class__,artistresult)
_tunepimp.artistresult_swigregister(artistresultPtr)

class albumresult(_object):
    '''This class is used to get/set the information for an album lookup result. For details
       on how to use this clase, please look up the main tunepimp documentation'''

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, albumresult, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, albumresult, name)
    def __repr__(self):
        return "<C albumresult instance at %s>" % (self.this,)
    __swig_setmethods__["relevance"] = _tunepimp.albumresult_relevance_set
    __swig_getmethods__["relevance"] = _tunepimp.albumresult_relevance_get
    if _newclass:relevance = property(_tunepimp.albumresult_relevance_get, _tunepimp.albumresult_relevance_set)
    __swig_setmethods__["name"] = _tunepimp.albumresult_name_set
    __swig_getmethods__["name"] = _tunepimp.albumresult_name_get
    if _newclass:name = property(_tunepimp.albumresult_name_get, _tunepimp.albumresult_name_set)
    __swig_setmethods__["id"] = _tunepimp.albumresult_id_set
    __swig_getmethods__["id"] = _tunepimp.albumresult_id_get
    if _newclass:id = property(_tunepimp.albumresult_id_get, _tunepimp.albumresult_id_set)
    __swig_setmethods__["numTracks"] = _tunepimp.albumresult_numTracks_set
    __swig_getmethods__["numTracks"] = _tunepimp.albumresult_numTracks_get
    if _newclass:numTracks = property(_tunepimp.albumresult_numTracks_get, _tunepimp.albumresult_numTracks_set)
    __swig_setmethods__["numCDIndexIds"] = _tunepimp.albumresult_numCDIndexIds_set
    __swig_getmethods__["numCDIndexIds"] = _tunepimp.albumresult_numCDIndexIds_get
    if _newclass:numCDIndexIds = property(_tunepimp.albumresult_numCDIndexIds_get, _tunepimp.albumresult_numCDIndexIds_set)
    __swig_setmethods__["isVA"] = _tunepimp.albumresult_isVA_set
    __swig_getmethods__["isVA"] = _tunepimp.albumresult_isVA_get
    if _newclass:isVA = property(_tunepimp.albumresult_isVA_get, _tunepimp.albumresult_isVA_set)
    __swig_setmethods__["status"] = _tunepimp.albumresult_status_set
    __swig_getmethods__["status"] = _tunepimp.albumresult_status_get
    if _newclass:status = property(_tunepimp.albumresult_status_get, _tunepimp.albumresult_status_set)
    __swig_setmethods__["type"] = _tunepimp.albumresult_type_set
    __swig_getmethods__["type"] = _tunepimp.albumresult_type_get
    if _newclass:type = property(_tunepimp.albumresult_type_get, _tunepimp.albumresult_type_set)
    __swig_setmethods__["artist"] = _tunepimp.albumresult_artist_set
    __swig_getmethods__["artist"] = _tunepimp.albumresult_artist_get
    if _newclass:artist = property(_tunepimp.albumresult_artist_get, _tunepimp.albumresult_artist_set)
    def __init__(self, *args):
        _swig_setattr(self, albumresult, 'this', _tunepimp.new_albumresult(*args))
        _swig_setattr(self, albumresult, 'thisown', 1)
    def __del__(self, destroy=_tunepimp.delete_albumresult):
        try:
            if self.thisown: destroy(self)
        except: pass

class albumresultPtr(albumresult):
    def __init__(self, this):
        _swig_setattr(self, albumresult, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, albumresult, 'thisown', 0)
        _swig_setattr(self, albumresult,self.__class__,albumresult)
_tunepimp.albumresult_swigregister(albumresultPtr)

class albumtrackresult(_object):
    '''This class is used to get/set the information for an album/track lookup result. For details
       on how to use this clase, please look up the main tunepimp documentation'''

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, albumtrackresult, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, albumtrackresult, name)
    def __repr__(self):
        return "<C albumtrackresult instance at %s>" % (self.this,)
    __swig_setmethods__["relevance"] = _tunepimp.albumtrackresult_relevance_set
    __swig_getmethods__["relevance"] = _tunepimp.albumtrackresult_relevance_get
    if _newclass:relevance = property(_tunepimp.albumtrackresult_relevance_get, _tunepimp.albumtrackresult_relevance_set)
    __swig_setmethods__["name"] = _tunepimp.albumtrackresult_name_set
    __swig_getmethods__["name"] = _tunepimp.albumtrackresult_name_get
    if _newclass:name = property(_tunepimp.albumtrackresult_name_get, _tunepimp.albumtrackresult_name_set)
    __swig_setmethods__["id"] = _tunepimp.albumtrackresult_id_set
    __swig_getmethods__["id"] = _tunepimp.albumtrackresult_id_get
    if _newclass:id = property(_tunepimp.albumtrackresult_id_get, _tunepimp.albumtrackresult_id_set)
    __swig_setmethods__["numTRMIds"] = _tunepimp.albumtrackresult_numTRMIds_set
    __swig_getmethods__["numTRMIds"] = _tunepimp.albumtrackresult_numTRMIds_get
    if _newclass:numTRMIds = property(_tunepimp.albumtrackresult_numTRMIds_get, _tunepimp.albumtrackresult_numTRMIds_set)
    __swig_setmethods__["trackNum"] = _tunepimp.albumtrackresult_trackNum_set
    __swig_getmethods__["trackNum"] = _tunepimp.albumtrackresult_trackNum_get
    if _newclass:trackNum = property(_tunepimp.albumtrackresult_trackNum_get, _tunepimp.albumtrackresult_trackNum_set)
    __swig_setmethods__["duration"] = _tunepimp.albumtrackresult_duration_set
    __swig_getmethods__["duration"] = _tunepimp.albumtrackresult_duration_get
    if _newclass:duration = property(_tunepimp.albumtrackresult_duration_get, _tunepimp.albumtrackresult_duration_set)
    __swig_setmethods__["artist"] = _tunepimp.albumtrackresult_artist_set
    __swig_getmethods__["artist"] = _tunepimp.albumtrackresult_artist_get
    if _newclass:artist = property(_tunepimp.albumtrackresult_artist_get, _tunepimp.albumtrackresult_artist_set)
    __swig_setmethods__["album"] = _tunepimp.albumtrackresult_album_set
    __swig_getmethods__["album"] = _tunepimp.albumtrackresult_album_get
    if _newclass:album = property(_tunepimp.albumtrackresult_album_get, _tunepimp.albumtrackresult_album_set)
    def __init__(self, *args):
        _swig_setattr(self, albumtrackresult, 'this', _tunepimp.new_albumtrackresult(*args))
        _swig_setattr(self, albumtrackresult, 'thisown', 1)
    def __del__(self, destroy=_tunepimp.delete_albumtrackresult):
        try:
            if self.thisown: destroy(self)
        except: pass

class albumtrackresultPtr(albumtrackresult):
    def __init__(self, this):
        _swig_setattr(self, albumtrackresult, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, albumtrackresult, 'thisown', 0)
        _swig_setattr(self, albumtrackresult,self.__class__,albumtrackresult)
_tunepimp.albumtrackresult_swigregister(albumtrackresultPtr)

class track(object):
    '''This class is used to get/set the information for a track lookup result. For details
       on how to use this clase, please look up the main tunepimp documentation'''

    def __init__(self, tr):
        self.tr = tr

    def getTrackObject(self):
        return self.tr

    def getStatus(self):
        return _tunepimp.GetTrackStatus(self.tr)

    def setStatus(self, status):
        _tunepimp.SetTrackStatus(self.tr, status)

    def getFileName(self):
        return _tunepimp.GetFileName(self.tr)

    def getTRM(self):
        return _tunepimp.GetTRM(self.tr)

    def getLocalMetadata(self):
        mdata = metadata.metadata()
        _tunepimp.GetLocalMetadata(self.tr, mdata)
        return mdata

    def setLocalMetadata(self, metadata):
        _tunepimp.SetLocalMetadata(self.tr, metadata)

    def getServerMetadata(self):
        mdata = metadata.metadata()
        _tunepimp.GetServerMetadata(self.tr, mdata)
        return mdata

    def setServerMetadata(self, metadata):
        _tunepimp.SetServerMetadata(self.tr, metadata)

    def getTrackError(self):
        return _tunepimp.GetTrackError(self.tr)

    def getSimilarity(self):
        return _tunepimp.GetSimilarity(self.tr)

    def hasChanged(self):
        return _tunepimp.HasChanged(self.tr)

    def getResults(self):
        return _tunepimp.GetResults(self.tr)

    def lock(self):
        _tunepimp.Lock(self.tr)

    def unlock(self):
        _tunepimp.Unlock(self.tr)
