/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: id3_meta.h,v 1.6 2003/07/24 00:23:27 robert Exp $

----------------------------------------------------------------------------*/

#ifndef MBID3_H
#define MBID3_H

#include "id3tag/id3tag.h"
#include "file_meta.h"

class ID3 : public FileMetadata
{
    public:

           ID3(bool writeV1);
          ~ID3(void) {};

       bool write(const string  &fileName,
                  const Metadata    &data,
                  bool               clear);
       bool read (const string  &fileName,
                  Metadata          &data);

    private:

       string     getText        (struct id3_tag *tag, const char *frameName);
       string     getUserText    (struct id3_tag *tag, const char *userTextName);
       string     getUniqueFileId(struct id3_tag *tag, const char *ufidName);

       bool       setUniqueFileId(struct id3_tag *tag, 
                                  const char *ufidName, 
                                  const string &id);
       bool       setUserText    (struct id3_tag *tag, 
                                  const char *userTextName, 
                                  const string &text);
       bool       setText(struct id3_tag *tag, 
                                  const char *frameName,
                                  const string &text);

       bool       writeV1;
};

#endif
