/*
CLASS:command_apply:command_frame
*/
#ifndef GABA_DEFINE
struct command_apply
{
  struct command_frame super;
  struct command *f;
};
extern struct lsh_class command_apply_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_apply_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_apply *i = (struct command_apply *) o;
  mark((struct lsh_object *) i->f);
}

struct lsh_class command_apply_class =
{ STATIC_HEADER,
  &command_frame_class, "command_apply", sizeof(struct command_apply),
  do_command_apply_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:trace_continuation:command_continuation
*/
#ifndef GABA_DEFINE
struct trace_continuation
{
  struct command_continuation super;
  const char * name;
  struct command_continuation *real;
};
extern struct lsh_class trace_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_trace_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct trace_continuation *i = (struct trace_continuation *) o;
  mark((struct lsh_object *) i->real);
}

struct lsh_class trace_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "trace_continuation", sizeof(struct trace_continuation),
  do_trace_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:trace_command:command
*/
#ifndef GABA_DEFINE
struct trace_command
{
  struct command super;
  const char * name;
  struct command *real;
};
extern struct lsh_class trace_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_trace_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct trace_command *i = (struct trace_command *) o;
  mark((struct lsh_object *) i->real);
}

struct lsh_class trace_command_class =
{ STATIC_HEADER,
  &command_class, "trace_command", sizeof(struct trace_command),
  do_trace_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:collect_state_1:command_simple
*/
#ifndef GABA_DEFINE
struct collect_state_1
{
  struct command_simple super;
  struct collect_info_2 *info;
  struct lsh_object *a;
};
extern struct lsh_class collect_state_1_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_collect_state_1_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct collect_state_1 *i = (struct collect_state_1 *) o;
  mark((struct lsh_object *) i->info);
  mark((struct lsh_object *) i->a);
}

struct lsh_class collect_state_1_class =
{ STATIC_HEADER,
  &command_simple_class, "collect_state_1", sizeof(struct collect_state_1),
  do_collect_state_1_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:collect_state_2:command_simple
*/
#ifndef GABA_DEFINE
struct collect_state_2
{
  struct command_simple super;
  struct collect_info_3 *info;
  struct lsh_object *a;
  struct lsh_object *b;
};
extern struct lsh_class collect_state_2_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_collect_state_2_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct collect_state_2 *i = (struct collect_state_2 *) o;
  mark((struct lsh_object *) i->info);
  mark((struct lsh_object *) i->a);
  mark((struct lsh_object *) i->b);
}

struct lsh_class collect_state_2_class =
{ STATIC_HEADER,
  &command_simple_class, "collect_state_2", sizeof(struct collect_state_2),
  do_collect_state_2_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:collect_state_3:command_simple
*/
#ifndef GABA_DEFINE
struct collect_state_3
{
  struct command_simple super;
  struct collect_info_4 *info;
  struct lsh_object *a;
  struct lsh_object *b;
  struct lsh_object *c;
};
extern struct lsh_class collect_state_3_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_collect_state_3_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct collect_state_3 *i = (struct collect_state_3 *) o;
  mark((struct lsh_object *) i->info);
  mark((struct lsh_object *) i->a);
  mark((struct lsh_object *) i->b);
  mark((struct lsh_object *) i->c);
}

struct lsh_class collect_state_3_class =
{ STATIC_HEADER,
  &command_simple_class, "collect_state_3", sizeof(struct collect_state_3),
  do_collect_state_3_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:parallell_progn:command
*/
#ifndef GABA_DEFINE
struct parallell_progn
{
  struct command super;
  struct object_list *body;
};
extern struct lsh_class parallell_progn_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parallell_progn_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parallell_progn *i = (struct parallell_progn *) o;
  mark((struct lsh_object *) i->body);
}

struct lsh_class parallell_progn_class =
{ STATIC_HEADER,
  &command_class, "parallell_progn", sizeof(struct parallell_progn),
  do_parallell_progn_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:catch_handler_info:
*/
#ifndef GABA_DEFINE
struct catch_handler_info
{
  struct lsh_object super;
  UINT32 mask;
  UINT32 value;
  int ignore_value;
  struct command *handler;
};
extern struct lsh_class catch_handler_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_catch_handler_info_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct catch_handler_info *i = (struct catch_handler_info *) o;
  mark((struct lsh_object *) i->handler);
}

struct lsh_class catch_handler_info_class =
{ STATIC_HEADER,
  0, "catch_handler_info", sizeof(struct catch_handler_info),
  do_catch_handler_info_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:catch_handler:exception_handler
*/
#ifndef GABA_DEFINE
struct catch_handler
{
  struct exception_handler super;
  struct command_continuation *c;
  struct catch_handler_info *info;
};
extern struct lsh_class catch_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_catch_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct catch_handler *i = (struct catch_handler *) o;
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->info);
}

struct lsh_class catch_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "catch_handler", sizeof(struct catch_handler),
  do_catch_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:catch_apply:command
*/
#ifndef GABA_DEFINE
struct catch_apply
{
  struct command super;
  struct catch_handler_info *info;
  struct command *body;
};
extern struct lsh_class catch_apply_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_catch_apply_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct catch_apply *i = (struct catch_apply *) o;
  mark((struct lsh_object *) i->info);
  mark((struct lsh_object *) i->body);
}

struct lsh_class catch_apply_class =
{ STATIC_HEADER,
  &command_class, "catch_apply", sizeof(struct catch_apply),
  do_catch_apply_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:catch_collect_body:command_simple
*/
#ifndef GABA_DEFINE
struct catch_collect_body
{
  struct command_simple super;
  struct catch_handler_info *info;
};
extern struct lsh_class catch_collect_body_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_catch_collect_body_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct catch_collect_body *i = (struct catch_collect_body *) o;
  mark((struct lsh_object *) i->info);
}

struct lsh_class catch_collect_body_class =
{ STATIC_HEADER,
  &command_simple_class, "catch_collect_body", sizeof(struct catch_collect_body),
  do_catch_collect_body_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:catch_report_apply:command
*/
#ifndef GABA_DEFINE
struct catch_report_apply
{
  struct command super;
  struct report_exception_info *info;
  struct command *body;
};
extern struct lsh_class catch_report_apply_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_catch_report_apply_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct catch_report_apply *i = (struct catch_report_apply *) o;
  mark((struct lsh_object *) i->info);
  mark((struct lsh_object *) i->body);
}

struct lsh_class catch_report_apply_class =
{ STATIC_HEADER,
  &command_class, "catch_report_apply", sizeof(struct catch_report_apply),
  do_catch_report_apply_mark,
  NULL
};
#endif /* !GABA_DECLARE */

