@echo off

rem $Header: /cvsroot/lesstif/lesstif/scripts/OS2/ltv2.cmd,v 1.9 2001/10/02 16:10:26 amai Exp $
rem
rem This script toggles the default version of LessTif (Motif)
rem libraries, headers, etc. being used for compiling/building.
rem
rem Written by Alexander Mai <amai@lesstif.org>

setlocal

if "%1." == "1.2." goto :VERSIONOK
if "%1." == "2.0." goto :VERSIONOK
if "%1." == "2.1." goto :VERSIONOK

echo  %0%: Unknown version
echo  Syntax: %0% version
echo  version is either 1.2, 2.0 or 2.1
goto :ENDE


:VERSIONOK

if "%X11ROOT%." == "." goto XROOTBROKEN

rem Care about our backup directory structure!
if not exist %X11ROOT%\XFree86\lib\X11\LessTif                  md %X11ROOT%\XFree86\lib\X11\LessTif
if not exist %X11ROOT%\XFree86\lib\X11\LessTif\last             md %X11ROOT%\XFree86\lib\X11\LessTif\last
if not exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include     md %X11ROOT%\XFree86\lib\X11\LessTif\last\include
if not exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Xm  md %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Xm
if not exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Mrm md %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Mrm
if not exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include\uil md %X11ROOT%\XFree86\lib\X11\LessTif\last\include\uil
if not exist %X11ROOT%\XFree86\lib\X11\LessTif\last\lib         md %X11ROOT%\XFree86\lib\X11\LessTif\last\lib


echo Backing up previous default version's libs and headers

cd %X11ROOT%\XFree86\lib

if exist Xm.a      copy Xm.a     %X11ROOT%\XFree86\lib\X11\LessTif\last\lib  >nul
if exist Xm.lib    copy Xm.lib   %X11ROOT%\XFree86\lib\X11\LessTif\last\lib  >nul
if exist Mrm.a     copy Mrm.a    %X11ROOT%\XFree86\lib\X11\LessTif\last\lib  >nul
if exist Mrm.lib   copy Mrm.lib  %X11ROOT%\XFree86\lib\X11\LessTif\last\lib  >nul
if exist Uil.a     copy Uil.a    %X11ROOT%\XFree86\lib\X11\LessTif\last\lib  >nul
if exist Uil.lib   copy Uil.lib  %X11ROOT%\XFree86\lib\X11\LessTif\last\lib  >nul


cd %X11ROOT%\XFree86\include

if exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Xm\*.h   del %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Xm\*.h >nul
copy Xm\*.h  %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Xm\   >nul
if exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Mrm\*.h  del %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Mrm\*.h >nul
copy Mrm\*.h %X11ROOT%\XFree86\lib\X11\LessTif\last\include\Mrm\  >nul
if exist %X11ROOT%\XFree86\lib\X11\LessTif\last\include\uil\*.h  del %X11ROOT%\XFree86\lib\X11\LessTif\last\include\uil\*.h >nul
copy uil\*.h %X11ROOT%\XFree86\lib\X11\LessTif\last\include\uil\  >nul

if "%1." == "1.2." goto :LIB12
if "%1." == "2.0." goto :LIB20
if "%1." == "2.1." goto :LIB21
goto :ENDE


:LIB12
echo Installing Version 1.2
cd %X11ROOT%\XFree86\lib 
copy Xm_12.a     Xm.a         >nul
copy Xm_12.lib   Xm.lib       >nul
copy Mrm_12.a    Mrm.a        >nul
copy Mrm_12.lib  Mrm.lib      >nul
copy Uil_12.a    Uil.a        >nul
copy Uil_12.lib  Uil.lib      >nul
cd %X11ROOT%\XFree86\include
del Xm\*.h                    >nul
del Mrm\*.h                   >nul
del uil\*.h                   >nul
copy Xm-1.2\*.h   Xm\         >nul
copy Mrm-1.2\*.h  Mrm\        >nul
copy uil-1.2\*.h  uil\        >nul
echo Done.
goto ENDE


:LIB20
echo Installing Version 2.0
cd %X11ROOT%\XFree86\lib
copy Xm_20.a     Xm.a         >nul
copy Xm_20.lib   Xm.lib       >nul
copy Mrm_20.a    Mrm.a        >nul
copy Mrm_20.lib  Mrm.lib      >nul
copy Uil_20.a    Uil.a        >nul
copy Uil_20.lib  Uil.lib      >nul
cd %X11ROOT%\XFree86\include
del Xm\*.h                    >nul
del Mrm\*.h                   >nul
del uil\*.h                   >nul
copy Xm-2.0\*.h   Xm\         >nul
copy Mrm-2.0\*.h  Mrm\        >nul
copy uil-2.0\*.h  uil\        >nul
echo Done.
goto ENDE


:LIB21
echo Installing Version 2.1
cd %X11ROOT%\XFree86\lib
copy Xm_21.a     Xm.a         >nul
copy Xm_21.lib   Xm.lib       >nul
copy Mrm_21.a    Mrm.a        >nul
copy Mrm_21.lib  Mrm.lib      >nul
copy Uil_21.a    Uil.a        >nul
copy Uil_21.lib  Uil.lib      >nul
cd %X11ROOT%\XFree86\include
del Xm\*.h                    >nul
del Mrm\*.h                   >nul
del uil\*.h                   >nul
copy Xm-2.1\*.h   Xm\         >nul
copy Mrm-2.1\*.h  Mrm\        >nul
copy uil-2.1\*.h  uil\        >nul
echo Done.
goto ENDE


:XROOTBROKEN
echo Environment X11ROOT variable not set! Cannot continue.


:ENDE

endlocal
